/*
 * Decompiled with CFR 0.152.
 */
package com.inscada.mono.communication.base.repositories;

import com.inscada.mono.communication.base.model.VariableFilter;
import com.inscada.mono.communication.base.model.VariableIdentity;
import com.inscada.mono.communication.base.model.VariableView;
import com.inscada.mono.shared.aspects.DisableSpaceFilter;
import com.inscada.mono.shared.aspects.EnableSpaceFilter;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.Repository;
import org.springframework.data.repository.query.Param;

@org.springframework.stereotype.Repository
@EnableSpaceFilter
public interface VariableRepositoryFacade
extends Repository<VariableView, String> {
    @DisableSpaceFilter
    @Query(value="SELECT COUNT(v) FROM VariableView v WHERE v.protocol IS NOT NULL AND v.protocol <> 'LOCAL'")
    public long ioCount();

    @Query(value="SELECT v FROM VariableView v WHERE v.id = ?1")
    public Optional<VariableView> findOne(String var1);

    @Query(value="SELECT v.* FROM inscada.variable v JOIN inscada.frame f ON v.frame_id = f.frame_id JOIN inscada.device d ON f.device_id = d.device_id JOIN inscada.connection c ON d.conn_id = c.conn_id WHERE v.project_id = ?1 AND c.name = ?2 AND v.space_id = :#{T(com.inscada.mono.space.SpaceContext).getActiveSpace().getId()} AND v.deleted_dttm IS NULL AND f.deleted_dttm IS NULL AND d.deleted_dttm IS NULL AND c.deleted_dttm IS NULL", nativeQuery=true)
    public Collection<VariableView> findVariablesByConnectionName(String var1, String var2);

    @Query(value="SELECT v.name FROM VariableView v WHERE v.projectId = :projectId AND v.logType IS NOT NULL AND v.logType <> 'No Log'")
    public Collection<String> findLoggedVariableNames(@Param(value="projectId") String var1);

    @Query(value="SELECT v FROM VariableView v WHERE v.frameId = ?1")
    public Collection<VariableView> findByFrameId(String var1);

    @Query(value="SELECT NEW com.inscada.mono.communication.base.model.VariableIdentity(v.id, v.name, v.projectId) FROM VariableView v WHERE v.projectId = ?1")
    public Collection<VariableIdentity> findIdentitiesByProjectId(String var1);

    @Query(value="SELECT v FROM VariableView v", countQuery="SELECT COUNT(v) FROM VariableView v")
    public Page<VariableView> findAll(Pageable var1);

    @Query(value="SELECT v FROM VariableView v WHERE v.projectId = ?1")
    public Collection<VariableView> findByProjectId(String var1);

    @Query(value="SELECT NEW com.inscada.mono.communication.base.model.VariableIdentity(v.id, v.name, v.projectId) FROM VariableView v")
    public Collection<VariableIdentity> findAllIdentities();

    @Query(value="SELECT v.* FROM inscada.variable v JOIN inscada.frame f ON v.frame_id = f.frame_id JOIN inscada.device d ON f.device_id = d.device_id JOIN inscada.connection c ON d.conn_id = c.conn_id WHERE (:#{#variableFilter.projectId} IS NULL OR :#{#variableFilter.projectId} = '' OR v.project_id = :#{#variableFilter.projectId}) AND (:#{#variableFilter.connectionId} IS NULL OR :#{#variableFilter.connectionId} = '' OR c.conn_id = :#{#variableFilter.connectionId}) AND (:#{#variableFilter.deviceId} IS NULL OR :#{#variableFilter.deviceId} = '' OR d.device_id = :#{#variableFilter.deviceId}) AND (:#{#variableFilter.frameId} IS NULL OR :#{#variableFilter.frameId} = '' OR f.frame_id = :#{#variableFilter.frameId}) AND (:#{#variableFilter.name} IS NULL OR :#{#variableFilter.name} = '' OR v.name = :#{#variableFilter.name}) AND (:#{#variableFilter.nameIn} IS NULL OR :#{#variableFilter.nameIn} = '' OR UPPER(v.name) LIKE CONCAT('%', UPPER(:#{#variableFilter.nameIn}), '%')) AND (:#{#variableFilter.dscIn} IS NULL OR :#{#variableFilter.dscIn} = '' OR UPPER(v.dsc) LIKE CONCAT('%', UPPER(:#{#variableFilter.dscIn}), '%')) AND v.space_id = :#{T(com.inscada.mono.space.SpaceContext).getActiveSpace().getId()} AND v.deleted_dttm IS NULL AND f.deleted_dttm IS NULL AND d.deleted_dttm IS NULL AND c.deleted_dttm IS NULL", countQuery="SELECT COUNT(*) FROM inscada.variable v JOIN inscada.frame f ON v.frame_id = f.frame_id JOIN inscada.device d ON f.device_id = d.device_id JOIN inscada.connection c ON d.conn_id = c.conn_id WHERE (:#{#variableFilter.projectId} IS NULL OR :#{#variableFilter.projectId} = '' OR v.project_id = :#{#variableFilter.projectId}) AND (:#{#variableFilter.connectionId} IS NULL OR :#{#variableFilter.connectionId} = '' OR c.conn_id = :#{#variableFilter.connectionId}) AND (:#{#variableFilter.deviceId} IS NULL OR :#{#variableFilter.deviceId} = '' OR d.device_id = :#{#variableFilter.deviceId}) AND (:#{#variableFilter.frameId} IS NULL OR :#{#variableFilter.frameId} = '' OR f.frame_id = :#{#variableFilter.frameId}) AND (:#{#variableFilter.name} IS NULL OR :#{#variableFilter.name} = '' OR v.name = :#{#variableFilter.name}) AND (:#{#variableFilter.nameIn} IS NULL OR :#{#variableFilter.nameIn} = '' OR UPPER(v.name) LIKE CONCAT('%', UPPER(:#{#variableFilter.nameIn}), '%')) AND (:#{#variableFilter.dscIn} IS NULL OR :#{#variableFilter.dscIn} = '' OR UPPER(v.dsc) LIKE CONCAT('%', UPPER(:#{#variableFilter.dscIn}), '%')) AND v.space_id = :#{T(com.inscada.mono.space.SpaceContext).getActiveSpace().getId()} AND v.deleted_dttm IS NULL AND f.deleted_dttm IS NULL AND d.deleted_dttm IS NULL AND c.deleted_dttm IS NULL", nativeQuery=true)
    public Page<VariableView> findVariablesByFilter(@Param(value="variableFilter") VariableFilter var1, Pageable var2);

    @Query(value="SELECT v FROM VariableView v")
    public List<VariableView> findAll();

    @Query(value="SELECT NEW com.inscada.mono.communication.base.model.VariableIdentity(v.id, v.name, v.projectId) FROM VariableView v WHERE v.frameId = ?1")
    public Collection<VariableIdentity> findIdentitiesByFrameId(String var1);

    @Query(value="SELECT v.* FROM inscada.variable v JOIN inscada.frame f ON v.frame_id = f.frame_id JOIN inscada.device d ON f.device_id = d.device_id JOIN inscada.connection c ON d.conn_id = c.conn_id WHERE v.project_id = ?1 AND c.name = ?2 AND d.name = ?3 AND v.space_id = :#{T(com.inscada.mono.space.SpaceContext).getActiveSpace().getId()} AND v.deleted_dttm IS NULL AND f.deleted_dttm IS NULL AND d.deleted_dttm IS NULL AND c.deleted_dttm IS NULL", nativeQuery=true)
    public Collection<VariableView> findVariablesByDeviceName(String var1, String var2, String var3);

    @Query(value="SELECT NEW com.inscada.mono.communication.base.model.VariableIdentity(v.id, v.name, v.projectId) FROM VariableView v WHERE v.projectId = ?1 AND v.name IN (?2)")
    public Collection<VariableIdentity> findIdentitiesByProjectIdAndNameIn(String var1, String[] var2);

    @Query(value="SELECT v.* FROM inscada.variable v JOIN inscada.frame f ON v.frame_id = f.frame_id JOIN inscada.device d ON f.device_id = d.device_id JOIN inscada.connection c ON d.conn_id = c.conn_id WHERE v.project_id = ?1 AND c.name = ?2 AND d.name = ?3 AND f.name = ?4 AND v.space_id = :#{T(com.inscada.mono.space.SpaceContext).getActiveSpace().getId()} AND v.deleted_dttm IS NULL AND f.deleted_dttm IS NULL AND d.deleted_dttm IS NULL AND c.deleted_dttm IS NULL", nativeQuery=true)
    public Collection<VariableView> findVariablesByFrameName(String var1, String var2, String var3, String var4);

    @Query(value="SELECT COUNT(v) FROM VariableView v")
    public long count();

    @Query(value="SELECT v FROM VariableView v WHERE v.projectId = ?1 AND v.name IN (?2)")
    public Collection<VariableView> findByProjectIdAndNameIn(String var1, String[] var2);

    @Query(value="SELECT v FROM VariableView v WHERE v.id IN (?1)")
    public List<VariableView> findAll(Iterable<String> var1);

    @Query(value="SELECT v FROM VariableView v WHERE v.projectId = ?1 AND v.name = ?2")
    public Optional<VariableView> findOneByProjectIdAndName(String var1, String var2);

    @Query(value="SELECT NEW com.inscada.mono.communication.base.model.VariableIdentity(v.id, v.name, v.projectId) FROM VariableView v WHERE v.projectId = ?1 AND v.name = ?2")
    public VariableIdentity findIdentityByProjectIdAndName(String var1, String var2);

    @Query(value="SELECT v FROM VariableView v WHERE v.projectId = ?1", countQuery="SELECT COUNT(v) FROM VariableView v WHERE v.projectId = ?1")
    public Page<VariableView> findByProjectId(String var1, Pageable var2);
}

