/*
 * Decompiled with CFR 0.152.
 */
package com.inscada.mono.communication.base.repositories;

import com.inscada.mono.communication.base.model.DeviceView;
import com.inscada.mono.shared.aspects.EnableSpaceFilter;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.Repository;

@org.springframework.stereotype.Repository
@EnableSpaceFilter
public interface DeviceRepositoryFacade
extends Repository<DeviceView, String> {
    @Query(value="SELECT d FROM DeviceView d")
    public List<DeviceView> findAll();

    @Query(value="SELECT d FROM DeviceView d WHERE d.connectionId = ?1")
    public Collection<DeviceView> findByConnectionId(String var1);

    @Query(value="SELECT d FROM DeviceView d WHERE d.connectionId = ?1 AND d.name = ?2")
    public Optional<DeviceView> findOneByConnectionIdAndName(String var1, String var2);

    @Query(value="SELECT d FROM DeviceView d WHERE d.deviceId IN (?1)")
    public List<DeviceView> findAll(Iterable<String> var1);

    @Query(value="SELECT d.* FROM inscada.device d JOIN inscada.connection c ON d.conn_id = c.conn_id WHERE c.project_id = ?1 AND d.space_id = :#{T(com.inscada.mono.space.SpaceContext).getActiveSpace().getId()} AND d.deleted_dttm IS NULL AND c.deleted_dttm IS NULL", nativeQuery=true)
    public Collection<DeviceView> findByProjectId(String var1);

    @Query(value="SELECT d FROM DeviceView d WHERE d.connectionId = ?1 AND d.deviceId = ?2")
    public Optional<DeviceView> findOneByConnectionIdAndId(String var1, String var2);

    @Query(value="SELECT d FROM DeviceView d WHERE d.deviceId = ?1")
    public Optional<DeviceView> findOne(String var1);
}

