/*
 * Decompiled with CFR 0.152.
 */
package com.inscada.mono.communication.base.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.inscada.mono.communication.base.model.Connection;
import com.inscada.mono.communication.base.model.Device;
import com.inscada.mono.communication.base.model.Frame;
import com.inscada.mono.communication.base.model.HasFrame;
import com.inscada.mono.communication.base.model.values.VariableValue;
import com.inscada.mono.communication.base.z.c_kk;
import com.inscada.mono.communication.base.z.c_ol;
import com.inscada.mono.expression.model.Expression;
import com.inscada.mono.project.model.Project;
import com.inscada.mono.shared.model.SpaceBaseModel;
import com.inscada.mono.shared.validations.CheckAtLeastOneNotNull;
import com.inscada.mono.shared.validations.CheckAtLeastOneNotNull$List;
import jakarta.persistence.AttributeOverride;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.Inheritance;
import jakarta.persistence.InheritanceType;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.Transient;
import jakarta.validation.constraints.Min;
import jakarta.validation.constraints.NotBlank;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.PositiveOrZero;
import jakarta.validation.constraints.Size;
import java.util.Objects;
import org.hibernate.annotations.SQLRestriction;

@Entity
@Inheritance(strategy=InheritanceType.TABLE_PER_CLASS)
@AttributeOverride(name="id", column=@Column(name="variable_id", length=36, nullable=false, updatable=false))
@CheckAtLeastOneNotNull$List(value={@CheckAtLeastOneNotNull(fieldNames={"projectId", "project"}), @CheckAtLeastOneNotNull(fieldNames={"frameId", "frame"})})
public class Variable<TFrame extends Frame<?, ?>, TDevice extends Device<?, ?>, TConnection extends Connection<?>>
extends SpaceBaseModel
implements HasFrame<TFrame> {
    @Column(name="project_id", insertable=false, updatable=false)
    protected String projectId;
    @Column(name="log_type")
    protected c_ol logType;
    @NotNull
    @Column(name="pulse_on_flag")
    protected Boolean isPulseOn;
    @NotNull
    @Column(name="active_flag")
    protected Boolean isActive;
    @Size(max=20)
    protected String code;
    @Column(name="fractional_digit_count")
    protected Short fractionalDigitCount;
    @PositiveOrZero
    @Column(name="pulse_off_duration")
    protected Integer pulseOffDuration;
    @NotNull
    @Column(name="writable_flag", nullable=false)
    protected Boolean isWritable;
    @PositiveOrZero
    @Column(name="pulse_on_duration")
    protected Integer pulseOnDuration;
    @Column(name="set_max_value")
    protected Double setMaxValue;
    @Column(name="raw_full_scale")
    protected Double rawFullScale;
    @Size(max=4000)
    @Column(name="value_expression")
    protected String valueExpressionCode;
    @Column(name="value_expression_id", insertable=false, updatable=false)
    protected String valueExpressionId;
    @Column(name="eng_full_scale")
    protected Double engFullScale;
    @NotBlank
    @Size(max=100)
    protected String name;
    @Min(value=1L)
    @Column(name="log_period")
    protected Integer logPeriod;
    @Column(name="set_min_value")
    protected Double setMinValue;
    @NotNull
    @Column(name="pulse_off_flag")
    protected Boolean isPulseOff;
    @NotNull
    @Column(name="keep_last_values")
    protected Boolean keepLastValues;
    @Column(name="log_min_value")
    protected Double logMinValue;
    @JsonIgnore
    @ManyToOne
    @SQLRestriction(value="deleted_dttm IS NULL")
    @JoinColumn(name="log_expression_id")
    protected Expression logExpression;
    @JsonIgnore
    @ManyToOne
    @SQLRestriction(value="deleted_dttm IS NULL")
    @JoinColumn(name="value_expression_id")
    protected Expression valueExpression;
    @Column(name="log_threshold")
    protected Double logThreshold;
    @Column(name="frame_id", insertable=false, updatable=false)
    protected String frameId;
    @Column(name="eng_zero_scale")
    protected Double engZeroScale;
    @Column(name="value_expression_type")
    protected c_kk valueExpressionType;
    @Column(name="raw_zero_scale")
    protected Double rawZeroScale;
    @Column(name="log_expression_id", insertable=false, updatable=false)
    protected String logExpressionId;
    @JsonIgnore
    @Transient
    protected VariableValue<?> value;
    @JsonIgnore
    @ManyToOne(optional=false)
    @SQLRestriction(value="deleted_dttm IS NULL")
    @JoinColumn(name="project_id", updatable=false)
    protected Project project;
    @Size(max=4000)
    @Column(name="log_expression")
    protected String logExpressionCode;
    protected String unit;
    @Size(max=255)
    protected String dsc;
    @Column(name="log_max_value")
    protected Double logMaxValue;

    public String getConnectionId() {
        Variable a;
        if (a.getDevice() == null) {
            return null;
        }
        return a.getDevice().getConnectionId();
    }

    public String getName() {
        Variable a;
        return a.name;
    }

    public void setKeepLastValues(Boolean bl) {
        Object a = bl;
        Variable a2 = this;
        a2.keepLastValues = a;
    }

    public void setIsWritable(Boolean bl) {
        Object a = bl;
        Variable a2 = this;
        a2.isWritable = a;
    }

    public Project getProject() {
        Variable a;
        return a.project;
    }

    public String getFrameId() {
        Variable a;
        return a.frameId;
    }

    public void setValueExpression(Expression expression) {
        Variable a;
        Variable a2 = expression;
        Variable variable = a = this;
        variable.valueExpression = a2;
        variable.valueExpressionId = a2 != null && a2.getId() != null ? a2.getId() : null;
    }

    public Variable() {
        Variable a;
    }

    public c_kk getValueExpressionType() {
        Variable a;
        return a.valueExpressionType;
    }

    public String getProjectId() {
        Variable a;
        return a.projectId;
    }

    public Double getRawFullScale() {
        Variable a;
        return a.rawFullScale;
    }

    public Boolean getIsPulseOn() {
        Variable a;
        return a.isPulseOn;
    }

    public Short getFractionalDigitCount() {
        Variable a;
        return a.fractionalDigitCount;
    }

    public void setValueExpressionType(c_kk c_kk2) {
        Variable a = c_kk2;
        Variable a2 = this;
        a2.valueExpressionType = a;
    }

    public boolean equals(Object object) {
        Variable a = this;
        Object a2 = object;
        if (a == a2) {
            return (3 & 5) != 0;
        }
        if (!(a2 instanceof Variable)) {
            return false;
        }
        Object object2 = a2;
        if (!super.equals(a2)) {
            return 5 >> 3;
        }
        if (a.getProjectId().equals(object2.getProjectId()) && a.getName().equals(object2.getName())) {
            return 5 >> 2;
        }
        return false;
    }

    public void setSetMaxValue(Double d) {
        Object a = d;
        Variable a2 = this;
        a2.setMaxValue = a;
    }

    public void setProjectId(String string) {
        Object a = string;
        Variable a2 = this;
        a2.projectId = a;
    }

    public void setFrameId(String string) {
        Object a = string;
        Variable a2 = this;
        a2.frameId = a;
    }

    public void setLogType(c_ol c_ol2) {
        Variable a = c_ol2;
        Variable a2 = this;
        a2.logType = a;
    }

    public Double getSetMaxValue() {
        Variable a;
        return a.setMaxValue;
    }

    public Boolean getIsWritable() {
        Variable a;
        return a.isWritable;
    }

    public void setPulseOffDuration(Integer n) {
        Object a = n;
        Variable a2 = this;
        a2.pulseOffDuration = a;
    }

    public Double getLogMinValue() {
        Variable a;
        return a.logMinValue;
    }

    public String getValueExpressionId() {
        Variable a;
        return a.valueExpressionId;
    }

    public Expression getValueExpression() {
        Variable a;
        return a.valueExpression;
    }

    public void setLogPeriod(Integer n) {
        Object a = n;
        Variable a2 = this;
        a2.logPeriod = a;
    }

    public void setProject(Project project) {
        Variable a;
        Variable a2 = project;
        Variable variable = a = this;
        variable.project = a2;
        variable.projectId = a2 != null && a2.getId() != null ? a2.getId() : null;
    }

    public Double getLogMaxValue() {
        Variable a;
        return a.logMaxValue;
    }

    public String getLogExpressionCode() {
        Variable a;
        return a.logExpressionCode;
    }

    public void setValue(VariableValue<?> variableValue) {
        VariableValue<?> a = variableValue;
        VariableValue<?> a2 = this;
        a2.value = a;
    }

    public void setLogExpressionId(String string) {
        Object a = string;
        Variable a2 = this;
        a2.logExpressionId = a;
    }

    public void setIsPulseOn(Boolean bl) {
        Object a = bl;
        Variable a2 = this;
        a2.isPulseOn = a;
    }

    public void setValueExpressionCode(String string) {
        Object a = string;
        Variable a2 = this;
        a2.valueExpressionCode = a;
    }

    public void setLogMinValue(Double d) {
        Object a = d;
        Variable a2 = this;
        a2.logMinValue = a;
    }

    public void setLogMaxValue(Double d) {
        Object a = d;
        Variable a2 = this;
        a2.logMaxValue = a;
    }

    public c_ol getLogType() {
        Variable a;
        return a.logType;
    }

    public void setValueExpressionId(String string) {
        Object a = string;
        Variable a2 = this;
        a2.valueExpressionId = a;
    }

    public void setDsc(String string) {
        Object a = string;
        Variable a2 = this;
        a2.dsc = a;
    }

    public void setIsActive(Boolean bl) {
        Object a = bl;
        Variable a2 = this;
        a2.isActive = a;
    }

    public Boolean getIsPulseOff() {
        Variable a;
        return a.isPulseOff;
    }

    public int hashCode() {
        Variable a;
        Object[] objectArray = new Object[--3];
        objectArray[3 >> 2] = super.hashCode();
        objectArray[5 >> 2] = a.getProjectId();
        objectArray[5 >> 1] = a.getName();
        return Objects.hash(objectArray);
    }

    public Integer getLogPeriod() {
        Variable a;
        return a.logPeriod;
    }

    public void setEngFullScale(Double d) {
        Object a = d;
        Variable a2 = this;
        a2.engFullScale = a;
    }

    public void setSetMinValue(Double d) {
        Object a = d;
        Variable a2 = this;
        a2.setMinValue = a;
    }

    public void setEngZeroScale(Double d) {
        Object a = d;
        Variable a2 = this;
        a2.engZeroScale = a;
    }

    public String getLogExpressionId() {
        Variable a;
        return a.logExpressionId;
    }

    public void setUnit(String string) {
        Object a = string;
        Variable a2 = this;
        a2.unit = a;
    }

    public String getUnit() {
        Variable a;
        return a.unit;
    }

    public VariableValue<?> getValue() {
        Variable a;
        return a.value;
    }

    @JsonIgnore
    public TConnection getConnection() {
        Variable a;
        if (a.getDevice() == null) {
            return null;
        }
        return (TConnection)a.getDevice().getConnection();
    }

    public String getDeviceId() {
        Variable a;
        if (a.getFrame() == null) {
            return null;
        }
        return a.getFrame().getDeviceId();
    }

    public void setIsPulseOff(Boolean bl) {
        Object a = bl;
        Variable a2 = this;
        a2.isPulseOff = a;
    }

    public void setRawZeroScale(Double d) {
        Object a = d;
        Variable a2 = this;
        a2.rawZeroScale = a;
    }

    public Double getEngFullScale() {
        Variable a;
        return a.engFullScale;
    }

    public Double getRawZeroScale() {
        Variable a;
        return a.rawZeroScale;
    }

    public Expression getLogExpression() {
        Variable a;
        return a.logExpression;
    }

    public String getDsc() {
        Variable a;
        return a.dsc;
    }

    public void setName(String string) {
        Object a = string;
        Variable a2 = this;
        a2.name = a;
    }

    public String getValueExpressionCode() {
        Variable a;
        return a.valueExpressionCode;
    }

    public void setLogThreshold(Double d) {
        Object a = d;
        Variable a2 = this;
        a2.logThreshold = a;
    }

    public Double getSetMinValue() {
        Variable a;
        return a.setMinValue;
    }

    public Double getLogThreshold() {
        Variable a;
        return a.logThreshold;
    }

    public Integer getPulseOffDuration() {
        Variable a;
        return a.pulseOffDuration;
    }

    public Boolean getIsActive() {
        Variable a;
        return a.isActive;
    }

    public void setRawFullScale(Double d) {
        Object a = d;
        Variable a2 = this;
        a2.rawFullScale = a;
    }

    public String getCode() {
        Variable a;
        return a.code;
    }

    @JsonIgnore
    public TDevice getDevice() {
        Variable a;
        if (a.getFrame() == null) {
            return null;
        }
        return (TDevice)a.getFrame().getDevice();
    }

    public Double getEngZeroScale() {
        Variable a;
        return a.engZeroScale;
    }

    public Integer getPulseOnDuration() {
        Variable a;
        return a.pulseOnDuration;
    }

    public void setCode(String string) {
        Object a = string;
        Variable a2 = this;
        a2.code = a;
    }

    public void setLogExpressionCode(String string) {
        Object a = string;
        Variable a2 = this;
        a2.logExpressionCode = a;
    }

    public void setPulseOnDuration(Integer n) {
        Object a = n;
        Variable a2 = this;
        a2.pulseOnDuration = a;
    }

    public void setLogExpression(Expression expression) {
        Variable a;
        Variable a2 = expression;
        Variable variable = a = this;
        variable.logExpression = a2;
        variable.logExpressionId = a2 != null && a2.getId() != null ? a2.getId() : null;
    }

    public void setFractionalDigitCount(Short s) {
        Object a = s;
        Variable a2 = this;
        a2.fractionalDigitCount = a;
    }

    public Boolean getKeepLastValues() {
        Variable a;
        return a.keepLastValues;
    }
}

