/*
 * Decompiled with CFR 0.152.
 */
package com.inscada.mono.communication.base.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.inscada.mono.communication.base.model.Device;
import com.inscada.mono.communication.base.model.HasDevices;
import com.inscada.mono.communication.base.z.c_ML;
import com.inscada.mono.project.model.Project;
import com.inscada.mono.shared.model.OwnedSpaceBaseModel;
import com.inscada.mono.shared.validations.CheckAtLeastOneNotNull;
import jakarta.persistence.AttributeOverride;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.Inheritance;
import jakarta.persistence.InheritanceType;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.validation.constraints.Max;
import jakarta.validation.constraints.Min;
import jakarta.validation.constraints.NotBlank;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Size;
import java.util.Objects;
import org.hibernate.annotations.SQLRestriction;

@Entity
@Inheritance(strategy=InheritanceType.TABLE_PER_CLASS)
@AttributeOverride(name="id", column=@Column(name="conn_id", length=36, nullable=false, updatable=false))
@CheckAtLeastOneNotNull(fieldNames={"projectId", "project"})
public class Connection<TDevice extends Device<?, ?>>
extends OwnedSpaceBaseModel
implements HasDevices<TDevice> {
    @JsonIgnore
    @ManyToOne(optional=false)
    @SQLRestriction(value="deleted_dttm IS NULL")
    @JoinColumn(name="project_id", updatable=false)
    protected Project project;
    @NotNull
    protected c_ML protocol;
    @Column(name="project_id", insertable=false, updatable=false)
    protected String projectId;
    @Size(max=255)
    protected String dsc;
    @NotNull
    @Min(value=0L)
    @Max(value=65535L)
    protected Integer port;
    @NotBlank
    @Size(max=50)
    protected String ip;
    @NotBlank
    @Size(max=100)
    protected String name;

    public void setProjectId(String string) {
        Object a = string;
        Connection a2 = this;
        a2.projectId = a;
    }

    public Integer getPort() {
        Connection a;
        return a.port;
    }

    public void setName(String string) {
        Object a = string;
        Connection a2 = this;
        a2.name = a;
    }

    public void setProtocol(c_ML c_ML2) {
        Connection a = c_ML2;
        Connection a2 = this;
        a2.protocol = a;
    }

    public int hashCode() {
        Connection a;
        Object[] objectArray = new Object[--3];
        objectArray[5 >> 3] = super.hashCode();
        objectArray[3 & 5] = a.getProjectId();
        objectArray[5 >> 1] = a.getName();
        return Objects.hash(objectArray);
    }

    public void setIp(String string) {
        Object a = string;
        Connection a2 = this;
        a2.ip = a;
    }

    public String getIp() {
        Connection a;
        return a.ip;
    }

    public void setProject(Project project) {
        Connection a;
        Connection a2 = project;
        Connection connection = a = this;
        connection.project = a2;
        connection.projectId = a2 != null && a2.getId() != null ? a2.getId() : null;
    }

    public Connection() {
        Connection a;
    }

    public void setDsc(String string) {
        Object a = string;
        Connection a2 = this;
        a2.dsc = a;
    }

    public void setPort(Integer n) {
        Object a = n;
        Connection a2 = this;
        a2.port = a;
    }

    public String getDsc() {
        Connection a;
        return a.dsc;
    }

    public Project getProject() {
        Connection a;
        return a.project;
    }

    public String getName() {
        Connection a;
        return a.name;
    }

    public String getProjectId() {
        Connection a;
        return a.projectId;
    }

    public c_ML getProtocol() {
        Connection a;
        return a.protocol;
    }

    public boolean equals(Object object) {
        Connection a = this;
        Object a2 = object;
        if (a == a2) {
            return 3 >> 1;
        }
        if (!(a2 instanceof Connection)) {
            return false;
        }
        Object object2 = a2;
        if (!super.equals(a2)) {
            return (3 & 4) != 0;
        }
        if (a.getProjectId().equals(object2.getProjectId()) && a.getName().equals(object2.getName())) {
            return 5 >> 2;
        }
        return false;
    }
}

