/*
 * Decompiled with CFR 0.152.
 */
package com.inscada.mono.cluster.replication;

import com.inscada.mono.auth.c_zL;
import com.inscada.mono.cluster.model.ClusterNodeInfo;
import com.inscada.mono.cluster.services.ClusterNodeListener;
import com.inscada.mono.cluster.services.c_g;
import com.inscada.mono.config.c_Qb;
import com.inscada.mono.system.model.Stats;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.stereotype.Component;
import redis.clients.jedis.JedisPooled;
import redis.clients.jedis.util.SafeEncoder;

@Component
@ConditionalOnProperty(value={"ins.cluster.redis.replication.enabled"}, havingValue="true")
public class RedisReplicator
implements ClusterNodeListener {
    private final c_g f_rT;
    private final c_zL f_JS;
    private final JedisPooled f_VT;
    private final String f_AU;
    private final Logger f_ps;
    private final Integer f_ys;

    /*
     * WARNING - void declaration
     */
    public RedisReplicator(c_g c_g2, c_zL c_zL2, JedisPooled jedisPooled, @Value(value="${spring.data.redis.host:localhost}") String string, @Value(value="${spring.data.redis.port:6379}") Integer n) {
        void localRedisHost;
        void jedis;
        void runAsManager;
        void clusterOperations;
        RedisReplicator a;
        RedisReplicator redisReplicator = object;
        Object object = n;
        RedisReplicator redisReplicator2 = a = redisReplicator;
        RedisReplicator redisReplicator3 = a;
        redisReplicator3.f_ps = LoggerFactory.getLogger(RedisReplicator.class);
        redisReplicator3.f_rT = clusterOperations;
        redisReplicator2.f_JS = runAsManager;
        redisReplicator2.f_VT = jedis;
        a.f_AU = localRedisHost;
        a.f_ys = object;
        a.f_rT.m_X((ClusterNodeListener)a);
    }

    public void leader() {
        RedisReplicator redisReplicator = this;
        try {
            byte[][] byArrayArray = new byte[--2][];
            byArrayArray[5 >> 3] = SafeEncoder.encode((String)Stats.m_TF((Object)"<\u0000"));
            byArrayArray[4 ^ 5] = SafeEncoder.encode((String)c_Qb.m_dr((Object)"Z/P"));
            redisReplicator.f_VT.sendCommand(() -> SafeEncoder.encode((String)Stats.m_TF((Object)"\u001c>\u000e$\n=\t")), (byte[][])byArrayArray);
            RedisReplicator redisReplicator2 = redisReplicator;
            redisReplicator.f_ps.info(Stats.m_TF((Object)"\u001b\u001a&\u0001o\u001c \u0016*R&\u0001o>\n3\u000b7\u001d\\o> \u0011.\u001eo *\u0016&\u0001oZ4\u000fu\t2[o\u0001*\u0006o\u0006 R-\u0017o?\u000e!\u001b7\u001dRg!\u00033\u00197\u00004o<\u0000R\u0000<\n[a"), (Object)redisReplicator2.f_AU, (Object)redisReplicator2.f_ys);
            return;
        }
        catch (Exception a) {
            Object[] objectArray = new Object[--4];
            objectArray[3 ^ 3] = redisReplicator.f_AU;
            objectArray[2 ^ 3] = redisReplicator.f_ys;
            objectArray[--2] = a.getMessage();
            objectArray[--3] = a;
            redisReplicator.f_ps.error(c_Qb.m_dr((Object)"P\u0013g\u000egAf\u0004a\u0015|\u000frAy\u000ev\u0000yAG\u0004q\bfA=\u001ah[n\u001c<Aa\u000e5,T2A$G[5\u001ah"), objectArray);
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void notLeader() {
        RedisReplicator redisReplicator;
        RedisReplicator redisReplicator2 = redisReplicator = this;
        redisReplicator.f_ps.info(Stats.m_TF((Object)"&'\u001b<R!\u001d+\u0017o\u001b<R\u0001=\u001bR\u00037\u000e6\n aR\u000e\u0006;\u0017\"\u0002;\u001b!\u0015o\u0006 R,\u001d!\u0014&\u0015:\u0000*R#\u001d,\u0013#R\u001d\u0017+\u001b<Rg\t2H4\u000ffR.\u0001o\u0001#\u00139\u0017a"), (Object)redisReplicator2.f_AU, (Object)redisReplicator2.f_ys);
        try {
            String[] stringArray = new String[--1];
            stringArray[3 >> 2] = c_Qb.m_dr((Object)"C(P6J\"Y4F5P3J2A A4F");
            Optional optional = (Optional)redisReplicator.f_JS.m_Eea(() -> {
                RedisReplicator a;
                return a.f_rT.m_Ja().stream().filter(ClusterNodeInfo::getIsLeader).findFirst();
            }, stringArray);
            if (optional.isPresent()) {
                ClusterNodeInfo clusterNodeInfo = (ClusterNodeInfo)optional.get();
                String string = clusterNodeInfo.getHost();
                String a = clusterNodeInfo.getRedisHost();
                Integer n = clusterNodeInfo.getRedisPort();
                if (a == null || n == null) {
                    Object[] objectArray = new Object[--4];
                    objectArray[5 >> 3] = clusterNodeInfo.getNodeId();
                    objectArray[5 >> 2] = string;
                    objectArray[1 ^ 3] = redisReplicator.f_AU;
                    objectArray[--3] = redisReplicator.f_ys;
                    redisReplicator.f_ps.error(Stats.m_TF((Object)">*\u0013+\u0017=R!\u001d+\u0017o\t2Rg8\b\u0000 \u0007?\u0001o: \u0001;Ho\t2[o\u0005.\u0001o\u001b+\u0017!\u0006&\u0014&\u0017+^o\u0010:\u0006o\u001b;\u0001o\u0001?\u0017,\u001b)\u001b,R\u001d\u0017+\u001b<R'\u001d<\u0006`\u0002 \u0000;R&\u0001o\u001f&\u0001<\u001b!\u0015o\u001b!R\f\u001e:\u0001;\u0017=< \u0016*;!\u0014 \\o1.\u001c!\u001d;R,\u001d!\u0014&\u0015:\u0000*R#\u001d,\u0013#R\u001d\u0017+\u001b<Rg\t2H4\u000ffR.\u0001o\u0001#\u00139\u0017aR\u0003\u001d,\u0013#R\u001d\u0017+\u001b<R=\u0017\"\u0013&\u001c<R&\u001co\u001b;\u0001o\u0011:\u0000=\u0017!\u0006o\u0000*\u0002#\u001b,\u0013;\u001b \u001co\u0001;\u0013;\u0017a"), objectArray);
                    return;
                }
                if (a.equals(redisReplicator.f_AU) && n.equals(redisReplicator.f_ys)) {
                    Object[] objectArray = new Object[--4];
                    objectArray[5 >> 3] = a;
                    objectArray[4 ^ 5] = n;
                    objectArray[1 ^ 3] = redisReplicator.f_AU;
                    objectArray[--3] = redisReplicator.f_ys;
                    redisReplicator.f_ps.warn(c_Qb.m_dr((Object)"\\\u0005p\u000fa\bs\bp\u00055\rp\u0000q\u0004gFfAG\u0004q\bfA=\u001ah[n\u001c<A|\u00125\u0015}\u00045\u0012t\fpAt\u00125\rz\u0002t\r53p\u0005|\u00125In\u001c/\u001ahH;AA\t|\u00125\u000fz\u0005pAb\by\r5\u000fz\u00155\u0000a\u0015p\fe\u00155\u0015zAf\rt\u0017pAz\u0007sA|\u0015f\u0004y\u0007;AP\u000ff\u0014g\b{\u00065\rz\u0002t\r53p\u0005|\u00125\bfAx\u0000f\u0015p\u0013;"), objectArray);
                    Object[] objectArray2 = new Object[--4];
                    objectArray2[3 ^ 3] = redisReplicator.f_AU;
                    objectArray2[--1] = redisReplicator.f_ys;
                    objectArray2[5 >> 1] = a;
                    objectArray2[--3] = n;
                    redisReplicator.f_ps.error(Stats.m_TF((Object)"\f \u0006&\u00061\u000e>o1\u0000<\t;\b'\u001d3\u001b;\u0000<o;\u001c!\u001a7uR\u001b\u001a&\u0001o\u001c \u0016*Rg\t2H4\u000ffR&\u0001o\u001c \u0006o8\b\u0000 \u0007?\u0001o\u001e*\u0013+\u0017=^o\u0010:\u0006o\u0006'\u0017o\u001b+\u0017!\u0006&\u0014&\u0017+R\u00055=\u001d:\u0002<R#\u0017.\u0016*\u0000h\u0001o *\u0016&\u0001o\u0017!\u0016?\u001d&\u001c;Rg\t2H4\u000ffR?\u001d&\u001c;\u0001o\u0006 R;\u001a&\u0001o\u001c \u0016*U<R#\u001d,\u0013#R\u001d\u0017+\u001b<\\o&'\u001b<R&\u001c+\u001b,\u0013;\u0017<R.R?\u001d;\u0017!\u0006&\u0013#R\"\u001b<\u0011 \u001c)\u001b(\u0007=\u0013;\u001b \u001co\u001d=R.\u001co\u0007!\u0001;\u0013-\u001e*R<\u0006.\u0006*\\o> \u0011.\u001eo *\u0016&\u0001o\u0000*\u0002#\u001b,\u0013;\u001b \u001co\u0001;\u0013;\u0017o\u0005&\u001e#R\u0001=\u001bR-\u0017o\u0011'\u0013!\u0015*\u0016o\u0013:\u0006 \u001f.\u0006&\u0011.\u001e#\u000bo\u0006 R?\u0000*\u0004*\u001c;R&\u0001<\u0007*\u0001a"), objectArray2);
                    return;
                }
                Object[] objectArray = new Object[0x67 & 0x1E];
                objectArray[3 ^ 3] = clusterNodeInfo.getNodeId();
                objectArray[1] = string;
                objectArray[5 >> 1] = redisReplicator.f_AU;
                objectArray[3] = redisReplicator.f_ys;
                objectArray[4] = a;
                objectArray[5] = n;
                redisReplicator.f_ps.info(c_Qb.m_dr((Object)"S\u000e`\u000fqA_&g\u000e`\u0011fAy\u0004t\u0005p\u0013/A[\u000eq\u0004\\\u0005(Fn\u001c2M5+R\u0013z\u0014e\u0012]\u000ef\u0015(Fn\u001c2O5 a\u0015p\fe\u0015|\u000frAa\u000e5\u0012y\u0000c\u00045\rz\u0002t\r53p\u0005|\u00125In\u001c/\u001ahH5\u0015zAy\u0004t\u0005p\u00132\u001253p\u0005|\u00125\u0000aAn\u001c/\u001ah"), objectArray);
                byte[][] byArrayArray = new byte[2][];
                byArrayArray[0] = SafeEncoder.encode((String)a);
                byArrayArray[1] = SafeEncoder.encode((String)String.valueOf(n));
                redisReplicator.f_VT.sendCommand(() -> SafeEncoder.encode((String)c_Qb.m_dr((Object)"F-T7P.S")), (byte[][])byArrayArray);
                Object[] objectArray3 = new Object[4];
                objectArray3[0] = redisReplicator.f_AU;
                objectArray3[1] = redisReplicator.f_ys;
                objectArray3[2] = a;
                objectArray3[3] = n;
                redisReplicator.f_ps.info(Stats.m_TF((Object)"\u0003\u001d,\u0013#R\u001d\u0017+\u001b<Rg\t2H4\u000ffHo!*\u001c;R,\u001d\"\u001f.\u001c+R\u001c>\u000e$\n=\tR4\u000fo\t2"), objectArray3);
                return;
            }
            RedisReplicator redisReplicator3 = redisReplicator;
            redisReplicator.f_ps.warn(c_Qb.m_dr((Object)"\"z\u0014y\u00055\u000fz\u00155\u0007|\u000fqAtA_&g\u000e`\u0011fAy\u0004t\u0005p\u00135\u000fz\u0005pAc\btAG1VAa\u000e5\u0005p\u0015p\u0013x\b{\u00045\u0015}\u00045\ft\u0012a\u0004gAG\u0004q\bfA|\u000ff\u0015t\u000fv\u0004;AY\u000ev\u0000yAG\u0004q\bfA=\u001ah[n\u001c<Ab\by\r5\u0013p\ft\b{A|\u000f5\ba\u00125\u0002`\u0013g\u0004{\u00155\u0013p\u0011y\bv\u0000a\bz\u000f5\u0012a\u0000a\u0004;AA\t|\u00125\bfAa\tpAf\u0000s\u0004f\u00155\u0000e\u0011g\u000et\u0002}Aa\u000e5\u0000c\u000e|\u00055\u0012e\r|\u00158\u0003g\u0000|\u000f5\b{Av\u0000f\u00045\u000esA{\u0004a\u0016z\u0013~Ae\u0000g\u0015|\u0015|\u000e{\u0012;AX\u0000{\u0014t\r5\b{\u0015p\u0013c\u0004{\u0015|\u000e{Ax\u0000lAw\u00045\u0013p\u0010`\bg\u0004qA|\u00075\u0015}\u00045\u0002y\u0014f\u0015p\u00135\bfAe\u0000g\u0015|\u0015|\u000e{\u0004qAz\u00135\u0015}\u00045\u0005p\u0012|\u0006{\u0000a\u0004qAy\u0004t\u0005p\u00135\bfAa\u0013`\rlAq\u000eb\u000f;"), (Object)redisReplicator3.f_AU, (Object)redisReplicator3.f_ys);
            return;
        }
        catch (Exception exception) {
            Object[] objectArray = new Object[4];
            objectArray[0] = redisReplicator.f_AU;
            objectArray[1] = redisReplicator.f_ys;
            objectArray[2] = exception.getMessage();
            objectArray[3] = exception;
            redisReplicator.f_ps.error(Stats.m_TF((Object)"7=\u0000 \u0000o\u001b!R\u001d\u0017+\u001b< *\u0002#\u001b,\u0013;\u001b \u001c\u001c\u0017=\u0004&\u0011*\\!\u001d;>*\u0013+\u0017=ZfR8\u001a&\u001e*R,\u001d!\u0014&\u0015:\u0000&\u001c(R#\u001d,\u0013#R\u001d\u0017+\u001b<Rg\t2H4\u000ffHo\t2"), objectArray);
            return;
        }
    }
}

