/*
 * Decompiled with CFR 0.152.
 */
package com.inscada.mono.shared.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.inscada.mono.alarm.model.CheckedAlarm;
import com.inscada.mono.auth.security.model.AuthenticationResponseToken;
import com.inscada.mono.shared.model.SpaceBaseModel;
import com.inscada.mono.user.model.User;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.MappedSuperclass;
import jakarta.persistence.PrePersist;
import jakarta.persistence.PreUpdate;
import java.util.Objects;
import org.hibernate.annotations.SQLRestriction;
import org.springframework.security.core.context.SecurityContextHolder;

@MappedSuperclass
public abstract class OwnedSpaceBaseModel
extends SpaceBaseModel {
    @JsonIgnore
    @ManyToOne(optional=false)
    @SQLRestriction(value="deleted_dttm IS NULL")
    @JoinColumn(name="owner_id")
    protected User user;

    public OwnedSpaceBaseModel() {
        OwnedSpaceBaseModel a;
    }

    public void setUser(User user) {
        OwnedSpaceBaseModel a = user;
        OwnedSpaceBaseModel a2 = this;
        a2.user = a;
    }

    @PrePersist
    @PreUpdate
    void setOwner() {
        OwnedSpaceBaseModel ownedSpaceBaseModel = this;
        OwnedSpaceBaseModel a = (AuthenticationResponseToken)SecurityContextHolder.getContext().getAuthentication();
        Objects.requireNonNull(a, CheckedAlarm.m_Zga((Object)"|\u000fI\u0012X\u0014I\u0013^\u001bI\u0013R\u0014\u001d\u0017H\tIZS\u0015IZ_\u001f\u001d\u0014H\u0016Q"));
        ownedSpaceBaseModel.setUser(a.getUser());
    }

    public String getOwner() {
        OwnedSpaceBaseModel a;
        return a.user.getUsername();
    }

    public User getUser() {
        OwnedSpaceBaseModel a;
        return a.user;
    }
}

