/*
 * Decompiled with CFR 0.152.
 */
package com.inscada.mono.script.services;

import com.inscada.mono.animation.model.AnimationJoin;
import com.inscada.mono.auth.c_Lk;
import com.inscada.mono.cluster.exceptions.ClusterRpcException;
import com.inscada.mono.cluster.services.ClusterNodeListener;
import com.inscada.mono.cluster.services.c_F;
import com.inscada.mono.communication.base.restcontrollers.ConnectionController;
import com.inscada.mono.job.b.c_PB;
import com.inscada.mono.job.model.Job;
import com.inscada.mono.log.g.c_lb;
import com.inscada.mono.project.g.c_l;
import com.inscada.mono.script.b.c_fA;
import com.inscada.mono.script.b.c_gC;
import com.inscada.mono.script.g.c_Pd;
import com.inscada.mono.script.g.c_zA;
import com.inscada.mono.script.model.RepeatableScript;
import com.inscada.mono.script.model.RepeatableScriptSummary;
import com.inscada.mono.script.model.Script;
import com.inscada.mono.script.services.c_qA;
import com.inscada.mono.script.services.c_tC;
import com.inscada.mono.script.services.c_yA;
import com.inscada.mono.shared.exceptions.NotActiveException;
import com.inscada.mono.shared.model.OwnedSpaceBaseModel;
import jakarta.annotation.PostConstruct;
import java.time.Duration;
import java.time.LocalTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Component;
import org.springframework.transaction.event.TransactionalEventListener;
import redis.clients.jedis.JedisPooled;

@Component
public class ScriptManager
implements ClusterNodeListener,
c_l {
    private final c_tC f_YA;
    public static final short f_Qb = 303;
    private final c_lb f_AC;
    public static final short f_Zc = 304;
    public static final short f_rB = 301;
    private final c_PB f_Cd;
    public static final short f_vC = 305;
    private final c_qA f_yC;
    private final c_Lk f_Sd;
    public static final short f_RA = 306;
    private final Lock f_jA;
    private static final Logger f_WB = LoggerFactory.getLogger(ScriptManager.class);
    private static final String f_wA = "scheduled_scripts";
    private final c_F f_pC;
    private final JedisPooled f_ac;
    public static final short f_OB = 302;
    public static final short f_zc = 307;
    private final Map<String, Job> f_kc;

    public void deactivateForProject(String string) {
        Object a = string;
        ScriptManager a2 = this;
        if (a2.f_pC.m_O()) {
            f_WB.info(ConnectionController.m_dT((Object)"\u0019z\u0014{\u0010mo\u001f\u001d^;[9V;Xuo'P?Z6K\u0011Z4\\!V#^!Z\u0010I0Q!\u001f3P'\u001f%M:U0\\!\u001f\u001c{o\u001f.B"), a);
            a2.cancelScriptsByProjectIdInternal((String)a);
            return;
        }
        f_WB.debug(AnimationJoin.m_xea((Object)"\f\\\f>\u000eV\u0003W\u0007Ax3\u000bt,|0z,tbC0|(v!g\u0006v#p6z4r6v\u0007e'}63$|032a-y'p63\u000bWx39n"), a);
    }

    @PreAuthorize(value="hasAuthority('VIEW_SCRIPT')")
    public Map<String, c_gC> getScriptStatuses(String string) {
        Object a = string;
        ScriptManager a2 = this;
        if (a2.f_pC.m_O()) {
            f_WB.debug(AnimationJoin.m_xea((Object)"_\u0007R\u0006V\u0010)bT'g6z,tbr.\u007fb`!a+c631g#g7`'`bu-abc0|(v!gbh?3.|!r.\u007f;="), a);
            return a2.getScriptStatusesByProjectIdInternal((String)a);
        }
        f_WB.debug(ConnectionController.m_dT((Object)"q\u001aqxs\u0010~\u0011z\u0007\u0005um0N Z&K<Q2\u001f9Z4[0MuY:Mu^9SuL6M<O!\u001f&K4K L0LuY:MuO'P?Z6KuD(\u0011"), a);
        try {
            Object[] objectArray = new Object[2 ^ 3];
            objectArray[2 & 5] = a;
            return (Map)a2.f_pC.m_ka(Short.valueOf((short)(0x59FF & 0x2733)), objectArray);
        }
        catch (Exception exception) {
            throw new ClusterRpcException("Failed to RPC get statuses for project" + (String)a, (Throwable)exception);
        }
    }

    private /* synthetic */ void lambda$cancelScriptInternal$9(RepeatableScript repeatableScript) {
        ScriptManager a = repeatableScript;
        ScriptManager a2 = this;
        a2.f_jA.lock();
        try {
            Job job = (Job)a2.f_kc.get(a.getId());
            if (job != null) {
                a2.f_Cd.m_eL(job);
            }
            ScriptManager scriptManager = a2;
            scriptManager.f_kc.remove(a.getId());
            String[] stringArray = new String[--1];
            stringArray[5 >> 3] = a.getId();
            scriptManager.f_ac.srem(f_wA, stringArray);
            return;
        }
        finally {
            a2.f_jA.unlock();
        }
    }

    protected void cancelScriptInternal(String string) {
        ScriptManager a;
        Object a2 = string;
        ScriptManager scriptManager = a = this;
        scriptManager.cancelScriptInternal(scriptManager.f_YA.m_ZD((String)a2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void leader() {
        ScriptManager scriptManager;
        ScriptManager scriptManager2 = scriptManager = this;
        Object a = scriptManager2.f_pC.m_o();
        f_WB.info(ConnectionController.m_dT((Object)"l6M<O!r4Q4X0Mo\u001f\u0001W<LuQ:[0\u001f}D(\u0016uW4Lu]0\\:R0\u001f!W0\u001f\u0019z\u0014{\u0010m{\u001f\u0007Z&K:M<Q2\u001f&\\=Z1J9Z1\u001f&\\'V%K&\u0011{\u0011"), a);
        scriptManager2.f_jA.lock();
        try {
            HashSet hashSet = new HashSet(scriptManager.f_ac.smembers(f_wA));
            if (hashSet.isEmpty()) {
                f_WB.info(AnimationJoin.m_xea((Object)"\u0011p0z2g\u000fr,r%v03j_'r&v039nk)b]-31p*v&f.v&31p0z2g13$|7}&3+}bA'w+`bg-30v1g-a'="), a);
                return;
            }
            Object[] objectArray = new Object[--3];
            objectArray[2 & 5] = a;
            objectArray[5 >> 2] = hashSet.size();
            objectArray[5 >> 1] = hashSet;
            f_WB.info(ConnectionController.m_dT((Object)"\u0006\\'V%K\u0018^;^2Z'\u001f}s0^1Z'\u001f.B|\u0005uy:J;[uD(\u001f&\\=Z1J9Z1\u001f&\\'V%Kuv\u0011LuV;\u001f\u0007Z1V&\u001f!PuM0L!P'Zo\u001f.B"), objectArray);
            ArrayList arrayList = new ArrayList();
            String[] stringArray = new String[3 >> 1];
            stringArray[3 & 4] = AnimationJoin.m_xea((Object)"E\u000bV\u0015L\u0011P\u0010Z\u0012G");
            scriptManager.f_Sd.m_XDa(() -> {
                void a;
                Object a2 = hashSet;
                ScriptManager a3 = this;
                a.addAll(a3.f_YA.m_Ve((Set)a2));
            }, stringArray);
            f_WB.info(ConnectionController.m_dT((Object)"\u0006\\'V%K\u0018^;^2Z'\u001f}s0^1Z'\u001f.B|\u0005u~!K0R%K<Q2\u001f!PuM0L!P'ZuD(\u001f&\\'V%K&\u0011"), a, (Object)arrayList.size());
            arrayList.forEach(repeatableScript -> {
                void a;
                ScriptManager scriptManager;
                ScriptManager scriptManager2 = scriptManager = this;
                Object a2 = scriptManager2.f_pC.m_o();
                String[] stringArray = new String[1 ^ 3];
                stringArray[3 & 4] = AnimationJoin.m_xea((Object)"@\u0001[\u0007W\u0017_\u0007L\u0011P\u0010Z\u0012G");
                stringArray[2 ^ 3] = ConnectionController.m_dT((Object)"|\u0014q\u0016z\u0019`\u0006|\u0007v\u0005k");
                scriptManager2.f_Sd.m_jEa(() -> scriptManager.lambda$restoreSingleScriptOnLeader$1((String)a2, (RepeatableScript)a), a.getSpace(), stringArray);
            });
            f_WB.info(AnimationJoin.m_xea((Object)"@!a+c6^#}#t'ab;\u000ev#w'abh?:x3\u0004z,z1{'wb`!a+c630v1g-a#g+|,32a-p'`1="), a);
            return;
        }
        catch (Exception exception) {
            Object[] objectArray = new Object[--3];
            objectArray[2 & 5] = a;
            objectArray[3 >> 1] = exception.getMessage();
            objectArray[1 ^ 3] = exception;
            f_WB.error(ConnectionController.m_dT((Object)"\u0006\\'V%K\u0018^;^2Z'\u001f}s0^1Z'\u001f.B|\u0005uz'M:Mu[ M<Q2\u001f&\\'V%KuM0L!P'^!V:QuO'P6Z&Lo\u001f.B"), objectArray);
            return;
        }
        finally {
            scriptManager.f_jA.unlock();
        }
    }

    @PreAuthorize(value="hasAuthority('CANCEL_SCRIPT')")
    public void cancelScript(String string) {
        Object a = string;
        ScriptManager a2 = this;
        if (a2.f_pC.m_O()) {
            f_WB.debug(ConnectionController.m_dT((Object)"s\u0010~\u0011z\u0007\u0005u|4Q6Z9S<Q2\u001f&\\'V%KuD(\u001f9P6^9S,\u0011"), a);
            a2.cancelScriptInternal((String)a);
            return;
        }
        f_WB.debug(AnimationJoin.m_xea((Object)"\f\\\f>\u000eV\u0003W\u0007Ax3\u0010v3f'`6z,tb\u007f'r&v036|bp#}!v.31p0z2gbh?="), a);
        try {
            Object[] objectArray = new Object[3 >> 1];
            objectArray[3 >> 2] = a;
            a2.f_pC.m_ka(Short.valueOf((short)(0x1B3E & 0x65EF)), objectArray);
            return;
        }
        catch (Exception exception) {
            throw new ClusterRpcException("Failed to RPC cancel script " + (String)a, (Throwable)exception);
        }
    }

    private /* synthetic */ void lambda$scheduleScriptInternal$4(RepeatableScript repeatableScript) {
        ScriptManager a = repeatableScript;
        ScriptManager a2 = this;
        a2.f_jA.lock();
        try {
            Job job;
            ScriptManager scriptManager;
            block14: {
                a2.cancelScriptInternal((RepeatableScript)a);
                if (!Boolean.TRUE.equals(a.getProject().getIsActive())) {
                    throw new NotActiveException("Project should be active to schedule script " + a.getName());
                }
                switch (c_yA.f_ld[a.getType().ordinal()]) {
                    case 1: {
                        ScriptManager scriptManager2 = a2;
                        while (false) {
                        }
                        scriptManager = scriptManager2;
                        job = scriptManager2.createDailyScriptJob((RepeatableScript)a);
                        break block14;
                    }
                    case 2: {
                        ScriptManager scriptManager3 = a2;
                        scriptManager = scriptManager3;
                        job = scriptManager3.createPeriodicScriptJob((RepeatableScript)a);
                        break block14;
                    }
                    case 3: {
                        job = a2.createOnceScriptJob((RepeatableScript)a);
                        break;
                    }
                    case 4: {
                        return;
                    }
                    default: {
                        throw new IllegalArgumentException("Unknown schedule type of " + String.valueOf(a.getType()));
                    }
                }
                scriptManager = a2;
            }
            scriptManager.f_kc.put(a.getId(), job);
            String[] stringArray = new String[5 >> 2];
            stringArray[3 ^ 3] = a.getId();
            a2.f_ac.sadd(f_wA, stringArray);
            return;
        }
        finally {
            a2.f_jA.unlock();
        }
    }

    private /* synthetic */ void lambda$createPeriodicScriptJob$7(RepeatableScript repeatableScript) {
        ScriptManager a = repeatableScript;
        ScriptManager a2 = this;
        a = Script.newBuilder((RepeatableScript)a).build();
        a2.f_yC.m_rF((Script)a);
    }

    @PostConstruct
    private /* synthetic */ void initializeClusterIntegration() {
        ScriptManager a;
        ScriptManager scriptManager = a;
        scriptManager.registerRemoteCallsWithClusterNode();
        scriptManager.f_pC.m_Da((ClusterNodeListener)a);
        f_WB.info(AnimationJoin.m_xea((Object)"\u0011p0z2g\u000fr,r%v03+}+g+r.z8v&3#}&30v%z1g'a'wbr13\u0001\u007f7`6v0]-w'_+`6v,v0="));
    }

    protected void scheduleScriptInternal(String string) {
        ScriptManager a;
        Object a2 = string;
        ScriptManager scriptManager = a = this;
        scriptManager.scheduleScriptInternal(scriptManager.f_YA.m_ZD((String)a2));
    }

    @PreAuthorize(value="hasAuthority('VIEW_SCRIPT')")
    public Map<String, c_gC> getScriptStatuses(List<String> list) {
        List<String> a = list;
        ScriptManager a2 = this;
        if (a == null || a.isEmpty()) {
            return Collections.emptyMap();
        }
        if (a2.f_pC.m_O()) {
            f_WB.debug(ConnectionController.m_dT((Object)"\u0019z\u0014{\u0010mo\u001f\u0012Z!K<Q2\u001f&\\'V%KuL!^!J&Z&\u001f3P'\u001f.Buv\u0011LuS:\\4S9Fo\u001f.B"), (Object)a.size(), (Object)a);
            return a2.getScriptStatusesByIdsInternal((List)a);
        }
        f_WB.debug(AnimationJoin.m_xea((Object)"\f\\\f>\u000eV\u0003W\u0007Ax3\u0010v3f'`6z,tb\u007f'r&v03$|031p0z2gb`6r6f1v13$|039nbZ\u0006`x39n"), (Object)a.size(), (Object)a);
        try {
            Object[] objectArray = new Object[3 & 5];
            objectArray[2 & 5] = new ArrayList(a);
            return (Map)a2.f_pC.m_ka(Short.valueOf((short)(0x6FBB & 0x1176)), objectArray);
        }
        catch (Exception exception) {
            throw new ClusterRpcException("Failed to RPC get script statuses for IDs " + a.stream().map(String::valueOf).collect(Collectors.joining(ConnectionController.m_dT((Object)"\u0013"))), (Throwable)exception);
        }
    }

    private /* synthetic */ Job createPeriodicScriptJob(RepeatableScript repeatableScript) {
        ScriptManager a = repeatableScript;
        ScriptManager a2 = this;
        return a2.f_Cd.m_El(a.getProject(), a2.generateJobName((RepeatableScript)a), () -> a2.lambda$createPeriodicScriptJob$7((RepeatableScript)a), Duration.ofMillis(a.getPeriod().intValue()), a.getOffset());
    }

    private /* synthetic */ Job createOnceScriptJob(RepeatableScript repeatableScript) {
        ScriptManager a = repeatableScript;
        ScriptManager a2 = this;
        return a2.f_Cd.m_Gm(a.getProject(), a2.generateJobName((RepeatableScript)a), () -> a2.lambda$createOnceScriptJob$6((RepeatableScript)a), Duration.ofMillis(a.getDelay().intValue()), (2 & 5) != 0);
    }

    public void notLeader() {
        ScriptManager scriptManager;
        ScriptManager scriptManager2 = scriptManager = this;
        Object a = scriptManager2.f_pC.m_o();
        f_WB.info(AnimationJoin.m_xea((Object)"\u0011p0z2g\u000fr,r%v0)bG*z13,|&vb;9nk3+`b]\r3\u000e\\\fT\u0007AbG\nVb_\u0007R\u0006V\u0010=bP#}!v.\u007f+}%3#\u007f.3.|!r.31p0z2gby-q1=l="), a);
        scriptManager2.f_jA.lock();
        try {
            new ArrayList(scriptManager.f_kc.keySet()).forEach(arg_0 -> scriptManager.lambda$notLeader$2((String)a, arg_0));
            scriptManager.f_kc.clear();
            f_WB.info(ConnectionController.m_dT((Object)"l6M<O!r4Q4X0Mu\u0017\u001bP!\u001f\u0019Z4[0MuD(\u0016o\u001f\u0014S9\u001f9P6^9\u001f&\\'V%KuU:]&\u001f=^#Zu]0Z;\u001f'Z$J0L!Z1\u001f!Pu\\4Q6Z9\u001f4Q1\u001f6S0^'Z1\u001f3M:RuS:\\4SuK'^6T<Q2\u0011"), a);
            return;
        }
        catch (Exception exception) {
            Object[] objectArray = new Object[--3];
            objectArray[3 & 4] = a;
            objectArray[2 ^ 3] = exception.getMessage();
            objectArray[5 >> 1] = exception;
            f_WB.error(AnimationJoin.m_xea((Object)"@!a+c6^#}#t'ab;\f|63\u000ev#w'abh?:x3\u0007a0|03&f0z,tbc0|!v1`b|$3!r,p'\u007f.z,tb\u007f-p#\u007fb`!a+c63(| `x39n"), objectArray);
            return;
        }
        finally {
            scriptManager.f_jA.unlock();
        }
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void lambda$createOnceScriptJob$6(RepeatableScript repeatableScript) {
        void a;
        ScriptManager scriptManager = this;
        ScriptManager a2 = Script.newBuilder((RepeatableScript)a).build();
        scriptManager.f_yC.m_rF((Script)a2);
        scriptManager.cancelScript(a.getId());
    }

    /*
     * WARNING - void declaration
     */
    @PreAuthorize(value="hasAuthority('VIEW_SCRIPT')")
    public c_gC getScriptStatus(String string, String string2) {
        void a;
        Object a2 = string;
        ScriptManager a3 = this;
        if ((a2 = a3.f_YA.m_bE((String)a2, (String)a)) == null) {
            return c_gC.f_BA;
        }
        return a3.getScriptStatus(a2.getId());
    }

    /*
     * WARNING - void declaration
     */
    @TransactionalEventListener(value={c_zA.class})
    public void handleCancelEvent(c_zA c_zA2) {
        void a;
        ScriptManager scriptManager = this;
        if (scriptManager.f_pC.m_O()) {
            ScriptManager a2 = a.m_GF();
            f_WB.info(ConnectionController.m_dT((Object)"\u0019z\u0014{\u0010mo\u001f\u001d^;[9V;Xu|4Q6Z9z#Z;KuY:MuL6M<O!\u0005uD(\u001f}v\u0011\u0005uD(\u0016"), (Object)a2.getName(), (Object)a2.getId());
            scriptManager.cancelScriptInternal((RepeatableScript)a2);
            return;
        }
        f_WB.debug(AnimationJoin.m_xea((Object)"]\r]o_\u0007R\u0006V\u0010)bZ%}-a+}%3\u0001r,p'\u007f\u0007e'}63$|031p0z2gx39n"), (Object)a.m_GF().getId());
    }

    private /* synthetic */ void lambda$createDailyScriptJob$8(RepeatableScript repeatableScript) {
        ScriptManager a = repeatableScript;
        ScriptManager a2 = this;
        a = Script.newBuilder((RepeatableScript)a).build();
        a2.f_yC.m_rF((Script)a);
    }

    @TransactionalEventListener(value={c_Pd.class})
    public void handleRescheduleEvent(c_Pd c_Pd2) {
        ScriptManager scriptManager = this;
        if (scriptManager.f_pC.m_O()) {
            ScriptManager a = a.m_fE();
            f_WB.info(ConnectionController.m_dT((Object)"\u0019z\u0014{\u0010mo\u001f\u001d^;[9V;Xum0L6W0[ S0z#Z;KuY:MuL6M<O!\u0005uD(\u001f}v\u0011\u0005uD(\u0016"), (Object)a.getName(), (Object)a.getId());
            if (scriptManager.getScriptStatusInternal(a.getId()) == c_gC.f_mb) {
                scriptManager.scheduleScriptInternal(a.getId());
                return;
            }
        } else {
            f_WB.debug(AnimationJoin.m_xea((Object)"]\r]o_\u0007R\u0006V\u0010)bZ%}-a+}%3\u0010v1p*v&f.v\u0007e'}63$|031p0z2gx39n"), (Object)a.m_fE().getId());
        }
    }

    protected Map<String, c_gC> getScriptStatusesByIdsInternal(List<String> list) {
        List<String> a = list;
        ScriptManager a2 = this;
        if (a == null || a.isEmpty()) {
            return Collections.emptyMap();
        }
        return a.stream().collect(Collectors.toMap(Function.identity(), arg_0 -> a2.getScriptStatusInternal(arg_0)));
    }

    /*
     * WARNING - void declaration
     */
    public ScriptManager(c_tC c_tC2, c_PB c_PB2, c_qA c_qA2, c_lb c_lb2, JedisPooled jedisPooled, c_F c_F2, c_Lk c_Lk2) {
        ScriptManager a;
        void a2;
        void a3;
        void a4;
        void a5;
        void a6;
        void a7;
        ScriptManager a8;
        ScriptManager scriptManager = scriptManager2;
        ScriptManager scriptManager2 = c_Lk2;
        ScriptManager scriptManager3 = a8 = scriptManager;
        ScriptManager scriptManager4 = a8;
        ScriptManager scriptManager5 = a8;
        ScriptManager scriptManager6 = a8;
        ScriptManager scriptManager7 = a8;
        scriptManager6.f_jA = new ReentrantLock();
        scriptManager6.f_kc = new ConcurrentHashMap();
        scriptManager6.f_YA = a7;
        scriptManager5.f_Cd = a6;
        scriptManager5.f_yC = a5;
        scriptManager4.f_AC = a4;
        scriptManager4.f_ac = a3;
        scriptManager3.f_pC = a2;
        scriptManager3.f_Sd = a;
    }

    protected void cancelScriptInternal(RepeatableScript repeatableScript) {
        ScriptManager a = repeatableScript;
        ScriptManager a2 = this;
        a2.f_Sd.m_Dga(() -> a2.lambda$cancelScriptInternal$9((RepeatableScript)a), (OwnedSpaceBaseModel)a);
    }

    protected c_gC getScriptStatusInternal(String string) {
        Object a = string;
        ScriptManager a2 = this;
        if (a2.f_kc.containsKey(a)) {
            return c_gC.f_mb;
        }
        return c_gC.f_BA;
    }

    private /* synthetic */ String generateJobName(RepeatableScript repeatableScript) {
        ScriptManager a = repeatableScript;
        ScriptManager a2 = this;
        Object[] objectArray = new Object[1 ^ 3];
        objectArray[5 >> 3] = a.getType().m_tI();
        objectArray[3 >> 1] = a.getName();
        return AnimationJoin.m_xea((Object)"g`b@!a+c63o3g`").formatted(objectArray);
    }

    @PreAuthorize(value="hasAuthority('VIEW_SCRIPT')")
    public c_gC getScriptStatus(String string) {
        Object a = string;
        ScriptManager a2 = this;
        if (a2.f_pC.m_O()) {
            f_WB.debug(ConnectionController.m_dT((Object)"s\u0010~\u0011z\u0007\u0005ux0K!V;XuL6M<O!\u001f&K4K LuY:MuD(\u001f9P6^9S,\u0011"), a);
            return a2.getScriptStatusInternal((String)a);
        }
        f_WB.debug(AnimationJoin.m_xea((Object)"]\r]o_\u0007R\u0006V\u0010)bA'b7v1g+}%3.v#w'abu-ab`!a+c631g#g7`bu-abh?="), a);
        try {
            Object[] objectArray = new Object[5 >> 2];
            objectArray[3 ^ 3] = a;
            return (c_gC)a2.f_pC.m_ka(Short.valueOf((short)(0x77BF & 0x96F)), objectArray);
        }
        catch (Exception exception) {
            throw new ClusterRpcException("Failed to RPC get script status for " + (String)a, (Throwable)exception);
        }
    }

    protected void scheduleScriptsByProjectIdInternal(String string) {
        Object a2 = string;
        ScriptManager a3 = this;
        if ((a2 = a3.f_YA.m_Td((String)a2)) == null || a2.isEmpty()) {
            return;
        }
        a2.stream().filter(a -> {
            if (a.getType() != c_fA.f_sA) {
                return 3 >> 1;
            }
            return false;
        }).forEach(arg_0 -> a3.scheduleScriptInternal(arg_0));
    }

    private /* synthetic */ void registerRemoteCallsWithClusterNode() {
        ScriptManager scriptManager = this;
        try {
            Class[] classArray = new Class[--1];
            classArray[2 & 5] = String.class;
            scriptManager.f_pC.m_q((short)(0x4F2F & 0x31FD), (Object)scriptManager, ScriptManager.class.getDeclaredMethod(ConnectionController.m_dT((Object)"&\\=Z1J9Z\u0006\\'V%K\u001cQ!Z'Q4S"), classArray));
            Class[] classArray2 = new Class[--1];
            classArray2[3 >> 2] = String.class;
            scriptManager.f_pC.m_q((short)(0x3FAF & 0x417E), (Object)scriptManager, ScriptManager.class.getDeclaredMethod(AnimationJoin.m_xea((Object)"!r,p'\u007f\u0011p0z2g\u000b}6v0}#\u007f"), classArray2));
            Class[] classArray3 = new Class[5 >> 2];
            classArray3[3 >> 2] = String.class;
            scriptManager.f_pC.m_q((short)(0x452F & 0x3BFF), (Object)scriptManager, ScriptManager.class.getDeclaredMethod(ConnectionController.m_dT((Object)"X0K\u0006\\'V%K\u0006K4K L\u001cQ!Z'Q4S"), classArray3));
            Class[] classArray4 = new Class[2 ^ 3];
            classArray4[3 & 4] = String.class;
            scriptManager.f_pC.m_q((short)(0x197A & 0x67B5), (Object)scriptManager, ScriptManager.class.getDeclaredMethod(AnimationJoin.m_xea((Object)"1p*v&f.v\u0011p0z2g1Q;C0|(v!g\u000bw\u000b}6v0}#\u007f"), classArray4));
            Class[] classArray5 = new Class[4 ^ 5];
            classArray5[3 & 4] = String.class;
            scriptManager.f_pC.m_q((short)(0x657F & 0x1BB1), (Object)scriptManager, ScriptManager.class.getDeclaredMethod(ConnectionController.m_dT((Object)"6^;\\0S\u0006\\'V%K&},o'P?Z6K\u001c[\u001cQ!Z'Q4S"), classArray5));
            Class[] classArray6 = new Class[1];
            classArray6[0] = List.class;
            scriptManager.f_pC.m_q((short)(0xBBE & 0x7573), (Object)scriptManager, ScriptManager.class.getDeclaredMethod(AnimationJoin.m_xea((Object)"%v6@!a+c6@6r6f1v1Q;Z&`\u000b}6v0}#\u007f"), classArray6));
            Class[] classArray7 = new Class[1];
            classArray7[0] = String.class;
            scriptManager.f_pC.m_q((short)(0x337B & 0x4DB7), (Object)scriptManager, ScriptManager.class.getDeclaredMethod(ConnectionController.m_dT((Object)"2Z!l6M<O!l!^!J&Z&},o'P?Z6K\u001c[\u001cQ!Z'Q4S"), classArray7));
            return;
        }
        catch (NoSuchMethodException a) {
            throw new IllegalStateException(AnimationJoin.m_xea((Object)"\u0004r+\u007f'wbg-30v%z1g'ab@!a+c6^#}#t'abA\u0012Pb~'g*|&`"), a);
        }
    }

    /*
     * WARNING - void declaration
     */
    @PreAuthorize(value="hasAuthority('SCHEDULE_SCRIPT')")
    public void scheduleScript(String string, String string2) {
        void a;
        ScriptManager a2;
        Object a3 = string2;
        ScriptManager scriptManager = a2 = this;
        scriptManager.scheduleScript(scriptManager.f_YA.m_kf((String)a, (String)a3).getId());
    }

    protected void scheduleScriptInternal(RepeatableScript repeatableScript) {
        ScriptManager a = repeatableScript;
        ScriptManager a2 = this;
        a2.f_Sd.m_Dga(() -> a2.lambda$scheduleScriptInternal$4((RepeatableScript)a), (OwnedSpaceBaseModel)a);
    }

    @PreAuthorize(value="hasAuthority('SCHEDULE_SCRIPT')")
    public void scheduleScript(String string) {
        Object a = string;
        ScriptManager a2 = this;
        if (a2.f_pC.m_O()) {
            f_WB.debug(AnimationJoin.m_xea((Object)"_\u0007R\u0006V\u0010)b@!{'w7\u007f+}%31p0z2gbh?3.|!r.\u007f;="), a);
            a2.scheduleScriptInternal((String)a);
            return;
        }
        f_WB.debug(ConnectionController.m_dT((Object)"\u001bp\u001b\u0012\u0019z\u0014{\u0010mo\u001f\u0007Z$J0L!V;XuS0^1Z'\u001f!PuL6W0[ S0\u001f&\\'V%KuD(\u0011"), a);
        try {
            Object[] objectArray = new Object[4 ^ 5];
            objectArray[3 ^ 3] = a;
            a2.f_pC.m_ka(Short.valueOf((short)(0x19FD & 0x672F)), objectArray);
            return;
        }
        catch (Exception exception) {
            throw new ClusterRpcException("Failed to RPC schedule script " + (String)a, (Throwable)exception);
        }
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void lambda$restoreSingleScriptOnLeader$1(String string, RepeatableScript repeatableScript) {
        void a;
        ScriptManager a2 = repeatableScript;
        ScriptManager a3 = this;
        try {
            Object[] objectArray = new Object[--3];
            objectArray[5 >> 3] = a;
            objectArray[3 & 5] = a2.getName();
            objectArray[5 >> 1] = a2.getId();
            f_WB.info(ConnectionController.m_dT((Object)"\u0006\\'V%K\u0018^;^2Z'\u001f}s0^1Z'\u001f.B|\u0005um0L!P'V;XuL6M<O!\u0005uD(\u001f}v\u0011\u0005uD(\u0016"), objectArray);
            a3.scheduleScriptInternal((RepeatableScript)a2);
            return;
        }
        catch (Exception exception) {
            Object[] objectArray = new Object[--3];
            objectArray[3 >> 2] = a2.getName();
            objectArray[3 >> 1] = a2.getId();
            objectArray[1 ^ 3] = ExceptionUtils.getRootCauseMessage((Throwable)exception);
            a3.f_AC.m_wj(a2.getProject()).m_p("Script Restore (Leader " + (String)a + ")", AnimationJoin.m_xea((Object)"g`b;\u000bWx3g`k3$r+\u007f'wbg-30v1g-a'=bP#f1vx3g`").formatted(objectArray));
            try {
                f_WB.warn(ConnectionController.m_dT((Object)"\u0006\\'V%K\u0018^;^2Z'\u001f}s0^1Z'\u001f.B|\u0005u~!K0R%K<Q2\u001f!Pu\\4Q6Z9\u001f&\\'V%KuD(\u001f4Y!Z'\u001f'Z&K:M4K<P;\u001f3^<S M0\u0011"), (Object)a, (Object)a2.getId());
                a3.cancelScriptInternal((RepeatableScript)a2);
                return;
            }
            catch (Exception exception2) {
                Object[] objectArray2 = new Object[--4];
                objectArray2[2 & 5] = a;
                objectArray2[5 >> 2] = a2.getId();
                objectArray2[1 ^ 3] = exception2.getMessage();
                objectArray2[--3] = exception2;
                f_WB.error(AnimationJoin.m_xea((Object)"@!a+c6^#}#t'ab;\u000ev#w'abh?:x3\u0004r+\u007f'wbg-3!r,p'\u007fb`!a+c639nbr$g'aba'`6|0r6z-}bu#z.f0vx39n"), objectArray2);
                return;
            }
        }
    }

    @PreAuthorize(value="hasAuthority('SCHEDULE_SCRIPT')")
    public void scheduleScripts(String string) {
        Object a = string;
        ScriptManager a2 = this;
        if (a2.f_pC.m_O()) {
            f_WB.debug(AnimationJoin.m_xea((Object)"\u000eV\u0003W\u0007Ax3\u0011p*v&f.z,tbr.\u007fb`!a+c6`bu-abc0|(v!gbh?3.|!r.\u007f;="), a);
            a2.scheduleScriptsByProjectIdInternal((String)a);
            return;
        }
        f_WB.debug(ConnectionController.m_dT((Object)"q\u001aqxs\u0010~\u0011z\u0007\u0005um0N Z&K<Q2\u001f9Z4[0MuK:\u001f&\\=Z1J9Zu^9SuL6M<O!LuY:MuO'P?Z6KuD(\u0011"), a);
        try {
            Object[] objectArray = new Object[--1];
            objectArray[5 >> 3] = a;
            a2.f_pC.m_ka(Short.valueOf((short)(0x49FC & 0x3733)), objectArray);
            return;
        }
        catch (Exception exception) {
            throw new ClusterRpcException("Failed to RPC schedule scripts for project " + (String)a, (Throwable)exception);
        }
    }

    protected void cancelScriptsByProjectIdInternal(String string) {
        Object a = string;
        ScriptManager a2 = this;
        if ((a = a2.f_YA.m_Td((String)a)) == null || a.isEmpty()) {
            return;
        }
        a.forEach(arg_0 -> a2.cancelScriptInternal(arg_0));
    }

    /*
     * WARNING - void declaration
     */
    @PreAuthorize(value="hasAuthority('CANCEL_SCRIPT')")
    public void cancelScript(String string, String string2) {
        void a;
        ScriptManager a2;
        Object a3 = string2;
        ScriptManager scriptManager = a2 = this;
        scriptManager.cancelScript(scriptManager.f_YA.m_kf((String)a, (String)a3).getId());
    }

    @PreAuthorize(value="hasAuthority('CANCEL_SCRIPT')")
    public void cancelScripts(String string) {
        Object a = string;
        ScriptManager a2 = this;
        if (a2.f_pC.m_O()) {
            f_WB.debug(ConnectionController.m_dT((Object)"\u0019z\u0014{\u0010mo\u001f\u0016^;\\0S9V;Xu^9SuL6M<O!LuY:MuO'P?Z6KuD(\u001f9P6^9S,\u0011"), a);
            a2.cancelScriptsByProjectIdInternal((String)a);
            return;
        }
        f_WB.debug(AnimationJoin.m_xea((Object)"]\r]o_\u0007R\u0006V\u0010)bA'b7v1g+}%3.v#w'abg-3!r,p'\u007fbr.\u007fb`!a+c6`bu-abc0|(v!gbh?="), a);
        try {
            Object[] objectArray = new Object[3 & 5];
            objectArray[2 & 5] = a;
            a2.f_pC.m_ka(Short.valueOf((short)(0x5D3D & 0x23F3)), objectArray);
            return;
        }
        catch (Exception exception) {
            throw new ClusterRpcException("Failed to RPC cancel scripts for project " + (String)a, (Throwable)exception);
        }
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ Job createDailyScriptJob(RepeatableScript repeatableScript) {
        void a;
        ScriptManager scriptManager = this;
        Object a2 = a.getTime();
        a2 = LocalTime.of(((Date)a2).getHours(), ((Date)a2).getMinutes(), ((Date)a2).getSeconds());
        return scriptManager.f_Cd.m_Fm(a.getProject(), scriptManager.generateJobName((RepeatableScript)a), () -> scriptManager.lambda$createDailyScriptJob$8((RepeatableScript)a), (LocalTime)a2);
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void lambda$notLeader$2(String string, String string2) {
        void a;
        ScriptManager scriptManager = this;
        ScriptManager a22 = (Job)scriptManager.f_kc.get(a);
        if (a22 != null) {
            void a3;
            try {
                f_WB.info(ConnectionController.m_dT((Object)"l6M<O!r4Q4X0Mu\u0017\u001bP!\u001f\u0019Z4[0MuD(\u0016o\u001f\u0016^;\\0S9V;XuS:\\4SuU:]uY:MuL6M<O!\u001f\u001c{o\u001f.B"), (Object)a3, (Object)a);
                scriptManager.f_Cd.m_eL((Job)a22);
                return;
            }
            catch (Exception a22) {
                Object[] objectArray = new Object[--4];
                objectArray[2 & 5] = a3;
                objectArray[--1] = a;
                objectArray[5 >> 1] = a22.getMessage();
                objectArray[--3] = a22;
                f_WB.error(AnimationJoin.m_xea((Object)"\u0011p0z2g\u000fr,r%v03j]-gb_'r&v039nk)bV0a-abp#}!v.\u007f+}%3.|!r.3(| 3$|031p0z2gbZ\u000639nx39n"), objectArray);
            }
        }
    }

    protected Map<String, c_gC> getScriptStatusesByProjectIdInternal(String string) {
        Object a = string;
        ScriptManager a2 = this;
        if ((a = a2.f_YA.m_Le((String)a)) == null || a.isEmpty()) {
            return Collections.emptyMap();
        }
        return a.stream().collect(Collectors.toMap(RepeatableScriptSummary::getId, repeatableScriptSummary -> {
            ScriptManager a = repeatableScriptSummary;
            ScriptManager a2 = this;
            return a2.getScriptStatusInternal(a.getId());
        }));
    }
}

