/*
 * Decompiled with CFR 0.152.
 */
package com.inscada.mono.report.services;

import com.inscada.mono.auth.c_Lk;
import com.inscada.mono.cluster.exceptions.ClusterRpcException;
import com.inscada.mono.cluster.services.ClusterNodeListener;
import com.inscada.mono.cluster.services.c_F;
import com.inscada.mono.job.b.c_PB;
import com.inscada.mono.job.model.DailyJob;
import com.inscada.mono.job.model.Job;
import com.inscada.mono.job.model.MonthlyJob;
import com.inscada.mono.log.g.c_lb;
import com.inscada.mono.log.model.LogEntryFilter;
import com.inscada.mono.project.g.c_l;
import com.inscada.mono.project.model.ProjectLocationDto;
import com.inscada.mono.report.b.c_Kb;
import com.inscada.mono.report.b.c_tB;
import com.inscada.mono.report.exceptions.ReportSchedulingException;
import com.inscada.mono.report.g.c_Tc;
import com.inscada.mono.report.g.c_rc;
import com.inscada.mono.report.model.Report;
import com.inscada.mono.report.model.ReportSummary;
import com.inscada.mono.report.services.c_JC;
import com.inscada.mono.report.services.c_rC;
import com.inscada.mono.shared.exceptions.NotActiveException;
import com.inscada.mono.shared.model.OwnedSpaceBaseModel;
import jakarta.annotation.PostConstruct;
import java.time.LocalTime;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Component;
import org.springframework.transaction.event.TransactionalEventListener;
import redis.clients.jedis.JedisPooled;

@Component
public class ReportManager
implements ClusterNodeListener,
c_l {
    private final Lock f_ef;
    private static final Logger f_qE = LoggerFactory.getLogger(ReportManager.class);
    private final c_PB f_vF;
    private final c_F f_QF;
    public static final short f_LF = 501;
    public static final short f_bF = 504;
    private static final String f_dD = "scheduledReports";
    public static final short f_ve = 503;
    public static final short f_gf = 502;
    public static final short f_KF = 506;
    private final c_rC f_aD;
    public static final short f_Df = 505;
    private final c_lb f_Cg;
    public static final short f_zE = 507;
    private final c_Lk f_iA;
    private final Map<String, List<Job>> f_fA;
    private final JedisPooled f_XB;
    private final c_JC f_Gd;

    /*
     * WARNING - void declaration
     */
    @PreAuthorize(value="hasAuthority('SCHEDULE_REPORT')")
    public void scheduleReport(String string, String string2) {
        void a;
        ReportManager a2;
        Object a3 = string2;
        ReportManager reportManager = a2 = this;
        reportManager.scheduleReport(reportManager.f_Gd.m_TG((String)a, (String)a3).getId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void leader() {
        ReportManager reportManager;
        ReportManager reportManager2 = reportManager = this;
        Object a = reportManager2.f_QF.m_o();
        f_qE.info(ProjectLocationDto.m_zk((Object)"cfAlCw|b_bVfC9\u0011WYjB#_lUf\u0011+J~\u0018#YbB#SfRl\\f\u0011wYf\u0011OtBuFc-\u0011QTpElCj_d\u0011pRkTgDoTg\u0011qTs^qEp\u001f-\u001f"), a);
        reportManager2.f_ef.lock();
        try {
            HashSet hashSet = new HashSet(reportManager.f_XB.smembers(f_dD));
            if (hashSet.isEmpty()) {
                f_qE.info(LogEntryFilter.m_Tk((Object)"\u007fn]d_\u007f`jCjJn_+\u0005GHjIn_+Vv\u00041\rEB+^hEnI~AnI+_n]d_\u007f^+KdXeI+De\rYHoDx\r\u007fB+_n^\u007fByH%"), a);
                return;
            }
            Object[] objectArray = new Object[--3];
            objectArray[3 ^ 3] = a;
            objectArray[3 >> 1] = hashSet.size();
            objectArray[--2] = hashSet;
            f_qE.info(ProjectLocationDto.m_zk((Object)"QTs^qENPmPdTq\u0011+}fPgTq\u0011xL*\u000b#wlDmU#J~\u0011pRkTgDoTg\u0011qTs^qE#xGB#Xm\u0011QTgXp\u0011w^#CfBw^qT9\u0011xL"), objectArray);
            ArrayList arrayList = new ArrayList();
            String[] stringArray = new String[4 ^ 5];
            stringArray[3 >> 2] = LogEntryFilter.m_Tk((Object)"{Bh\\rYh[bYyTd_hF");
            reportManager.f_iA.m_XDa(() -> {
                void a;
                Object a2 = hashSet;
                ReportManager a3 = this;
                a.addAll(a3.f_Gd.m_SG((Set)a2));
            }, stringArray);
            f_qE.info(ProjectLocationDto.m_zk((Object)"QTs^qENPmPdTq\u0011+}fPgTq\u0011xL*\u000b#pwEf\\sEj_d\u0011w^#CfBw^qT#J~\u0011qTs^qEp\u001f"), a, (Object)arrayList.size());
            arrayList.forEach(report -> {
                void a;
                ReportManager reportManager;
                ReportManager reportManager2 = reportManager = this;
                Object a2 = reportManager2.f_QF.m_o();
                String[] stringArray = new String[5 >> 1];
                stringArray[3 & 4] = LogEntryFilter.m_Tk((Object)"XnChOxGhT\u007fN}D\u007f_");
                stringArray[3 >> 1] = ProjectLocationDto.m_zk((Object)"rB\u007f@tOnQtS~Qe");
                reportManager2.f_iA.m_jEa(() -> reportManager.lambda$restoreSingleReportOnLeader$1((String)a2, (Report)a), a.getSpace(), stringArray);
            });
            f_qE.info(LogEntryFilter.m_Tk((Object)"YH{ByYFLeLlHy\r#anLoHy\rpP\"\u0017+kbCb^cHo\ryH{ByY+_n^\u007fByL\u007fDdC+]yBhHx^%"), a);
            return;
        }
        catch (Exception exception) {
            Object[] objectArray = new Object[--3];
            objectArray[3 ^ 3] = a;
            objectArray[--1] = exception.getMessage();
            objectArray[5 >> 1] = exception;
            f_qE.error(ProjectLocationDto.m_zk((Object)"QTs^qENPmPdTq\u0011+}fPgTq\u0011xL*\u000b#tqClC#UvCj_d\u0011qTs^qE#CfBw^qPwXl_#Aq^`TpB9\u0011xL"), objectArray);
            return;
        }
        finally {
            reportManager.f_ef.unlock();
        }
    }

    private /* synthetic */ DailyJob scheduleDailyPrintReportJob(Report report) {
        ReportManager a = report;
        ReportManager a2 = this;
        return a2.f_vF.m_Fm(a.getProject(), "Report Print - " + a.getName(), () -> a2.lambda$scheduleDailyPrintReportJob$7((Report)a), LocalTime.of(a.getPrintTime().getHours(), a.getPrintTime().getMinutes(), a.getPrintTime().getSeconds()));
    }

    private /* synthetic */ DailyJob scheduleDailyMailReportJob(Report report) {
        ReportManager a = report;
        ReportManager a2 = this;
        return a2.f_vF.m_Fm(a.getProject(), "Report Mail - " + a.getName(), () -> a2.lambda$scheduleDailyMailReportJob$8((Report)a), LocalTime.of(a.getMailTime().getHours(), a.getMailTime().getMinutes(), a.getMailTime().getSeconds()));
    }

    private /* synthetic */ MonthlyJob scheduleMonthlyMailReportJob(Report report) {
        ReportManager a = report;
        ReportManager a2 = this;
        return a2.f_vF.m_im(a.getProject(), "Report Mail - " + a.getName(), () -> a2.lambda$scheduleMonthlyMailReportJob$6((Report)a), (int)a.getMailDay().shortValue(), LocalTime.of(a.getMailTime().getHours(), a.getMailTime().getMinutes(), a.getMailTime().getSeconds()));
    }

    @PreAuthorize(value="hasAuthority('VIEW_REPORT')")
    public c_Kb getReportStatus(String string) {
        Object a = string;
        ReportManager a2 = this;
        if (a2.f_QF.m_O()) {
            f_qE.debug(ProjectLocationDto.m_zk((Object)"}FpGtQ\u000b#vfEwXmV#CfAlCw\u0011pEbEvB#WlC#xG\u000b#J~\u0011o^`Po]z\u001f"), a);
            return a2.getReportStatusInternal((String)a);
        }
        f_qE.debug(LogEntryFilter.m_Tk((Object)"EbE\u0000GhJiN\u007f1\rYHzXn^\u007fDeJ+AnLoHy\rmBy\ryH{ByY+^\u007fL\u007fXx\rmBy\rBi1\rpP%"), a);
        try {
            Object[] objectArray = new Object[--1];
            objectArray[2 & 5] = a;
            return (c_Kb)a2.f_QF.m_ka(Short.valueOf((short)(0x1FFF & 0x61F7)), objectArray);
        }
        catch (Exception exception) {
            throw new ClusterRpcException("Failed to RPC get report transfer status for " + (String)a, (Throwable)exception);
        }
    }

    @PostConstruct
    private /* synthetic */ void initializeClusterIntegration() {
        ReportManager a;
        ReportManager reportManager = a;
        reportManager.registerRemoteCallsWithClusterNode();
        reportManager.f_QF.m_Da((ClusterNodeListener)a);
        f_qE.info(LogEntryFilter.m_Tk((Object)"\u007fn]d_\u007f`jCjJn_+DeD\u007fDjAbWnI+LeI+_nJb^\u007fHyHo\rj^+ngXxYn_EBoHGDxYnCn_%"));
    }

    @PreAuthorize(value="hasAuthority('CANCEL_REPORT')")
    public void cancelReport(String string) {
        Object a = string;
        ReportManager a2 = this;
        if (a2.f_QF.m_O()) {
            f_qE.debug(LogEntryFilter.m_Tk((Object)"GhJiN\u007f1\rHLeNnAgDeJ+_n]d_\u007f\rpP+AdNjAgT%"), a);
            a2.cancelReportInternal((String)a);
            return;
        }
        f_qE.debug(ProjectLocationDto.m_zk((Object)"M~M\u001cOtBuFc9\u0011QTrDfBwXmV#]fPgTq\u0011w^#Rb_`To\u0011qTs^qE#J~\u001f"), a);
        try {
            Object[] objectArray = new Object[--1];
            objectArray[2 & 5] = a;
            a2.f_QF.m_ka(Short.valueOf((short)(0x45F6 & 0x3BFF)), objectArray);
            return;
        }
        catch (Exception exception) {
            throw new ClusterRpcException("Failed to RPC cancel report " + (String)a, (Throwable)exception);
        }
    }

    protected void scheduleReportsByProjectIdInternal(String string) {
        Object a = string;
        ReportManager a2 = this;
        if ((a = a2.f_Gd.m_Cj((String)a)) == null || a.isEmpty()) {
            return;
        }
        a.forEach(arg_0 -> a2.scheduleReportInternal(arg_0));
    }

    protected c_Kb getReportStatusInternal(String string) {
        Object a = string;
        ReportManager a2 = this;
        if (a2.f_fA.containsKey(a)) {
            return c_Kb.f_mF;
        }
        return c_Kb.f_DE;
    }

    protected void cancelReportsByProjectIdInternal(String string) {
        Object a = string;
        ReportManager a2 = this;
        if ((a = a2.f_Gd.m_Cj((String)a)) == null || a.isEmpty()) {
            return;
        }
        a.forEach(arg_0 -> a2.cancelReportInternal(arg_0));
    }

    /*
     * WARNING - void declaration
     */
    @PreAuthorize(value="hasAuthority('CANCEL_REPORT')")
    public void cancelReport(String string, String string2) {
        void a;
        ReportManager a2;
        Object a3 = string2;
        ReportManager reportManager = a2 = this;
        reportManager.cancelReport(reportManager.f_Gd.m_TG((String)a, (String)a3).getId());
    }

    @PreAuthorize(value="hasAuthority('SCHEDULE_REPORT')")
    public void scheduleReport(String string) {
        Object a = string;
        ReportManager a2 = this;
        if (a2.f_QF.m_O()) {
            f_qE.debug(LogEntryFilter.m_Tk((Object)"GhJiN\u007f1\rXNcHoXgDeJ+_n]d_\u007f\rpP+AdNjAgT%"), a);
            a2.scheduleReportInternal((String)a);
            return;
        }
        f_qE.debug(ProjectLocationDto.m_zk((Object)"M~M\u001cOtBuFc9\u0011QTrDfBwXmV#]fPgTq\u0011w^#B`YfUv]f\u0011qTs^qE#J~\u001f"), a);
        try {
            Object[] objectArray = new Object[4 ^ 5];
            objectArray[3 & 4] = a;
            a2.f_QF.m_ka(Short.valueOf((short)(0x33F5 & 0x4DFF)), objectArray);
            return;
        }
        catch (Exception exception) {
            throw new ClusterRpcException("Failed to RPC schedule report " + (String)a, (Throwable)exception);
        }
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void lambda$scheduleMonthlyPrintReportJob$5(Report report) {
        void a;
        Object a2;
        ReportManager reportManager = this;
        Calendar calendar = Calendar.getInstance();
        Object object = a2 = calendar;
        Object object2 = a2;
        ((Calendar)a2).set(--5, a.getReportDay().shortValue());
        ((Calendar)object2).set(0x7F & 0xB, a.getReportTime().getHours());
        ((Calendar)object2).set(0x4E & 0x3D, a.getReportTime().getMinutes());
        ((Calendar)object).set(0x4F & 0x3D, a.getReportTime().getSeconds());
        calendar.set(0x7E & 0xF, 3 ^ 3);
        a2 = ((Calendar)object).getTime();
        calendar.add(--2, -4 >> 2);
        Date date = calendar.getTime();
        reportManager.f_aD.m_dI(a.getId(), date, (Date)a2, 3 >> 1, a.getLang());
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void lambda$scheduleDailyMailReportJob$8(Report report) {
        void a;
        Object a2;
        ReportManager reportManager = this;
        Calendar calendar = Calendar.getInstance();
        Object object = a2 = calendar;
        Object object2 = a2;
        ((Calendar)object2).set(0x3F & 0x4B, a.getReportTime().getHours());
        ((Calendar)object2).set(0x4E & 0x3D, a.getReportTime().getMinutes());
        ((Calendar)object).set(0x6D & 0x1F, a.getReportTime().getSeconds());
        calendar.set(0x4F & 0x3E, 3 ^ 3);
        a2 = ((Calendar)object).getTime();
        calendar.add(--5, -4 >> 2);
        Date date = calendar.getTime();
        reportManager.f_aD.m_wi(a.getId(), date, (Date)a2, 5 >> 2, a.getLang());
    }

    /*
     * WARNING - void declaration
     */
    public ReportManager(c_JC c_JC2, c_PB c_PB2, c_rC c_rC2, c_lb c_lb2, JedisPooled jedisPooled, c_F c_F2, c_Lk c_Lk2) {
        ReportManager a;
        void a2;
        void a3;
        void a4;
        void a5;
        void a6;
        void a7;
        ReportManager a8;
        ReportManager reportManager = reportManager2;
        ReportManager reportManager2 = c_Lk2;
        ReportManager reportManager3 = a8 = reportManager;
        ReportManager reportManager4 = a8;
        ReportManager reportManager5 = a8;
        ReportManager reportManager6 = a8;
        ReportManager reportManager7 = a8;
        reportManager6.f_ef = new ReentrantLock();
        reportManager6.f_fA = new ConcurrentHashMap();
        reportManager6.f_Gd = a7;
        reportManager5.f_vF = a6;
        reportManager5.f_aD = a5;
        reportManager4.f_Cg = a4;
        reportManager4.f_XB = a3;
        reportManager3.f_QF = a2;
        reportManager3.f_iA = a;
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void lambda$scheduleDailyPrintReportJob$7(Report report) {
        void a;
        Object a2;
        ReportManager reportManager = this;
        Calendar calendar = Calendar.getInstance();
        Object object = a2 = calendar;
        Object object2 = a2;
        ((Calendar)object2).set(0xB & 0x7F, a.getReportTime().getHours());
        ((Calendar)object2).set(0x4C & 0x3F, a.getReportTime().getMinutes());
        ((Calendar)object).set(0x6D & 0x1F, a.getReportTime().getSeconds());
        calendar.set(0x6F & 0x1E, 5 >> 3);
        a2 = ((Calendar)object).getTime();
        calendar.add(--5, -4 >> 2);
        Date date = calendar.getTime();
        reportManager.f_aD.m_dI(a.getId(), date, (Date)a2, (4 ^ 5) != 0, a.getLang());
    }

    protected void cancelReportInternal(String string) {
        ReportManager a;
        Object a2 = string;
        ReportManager reportManager = a = this;
        reportManager.cancelReportInternal(reportManager.f_Gd.m_SH((String)a2));
    }

    public void deactivateForProject(String string) {
        Object a = string;
        ReportManager a2 = this;
        if (a2.f_QF.m_O()) {
            f_qE.info(LogEntryFilter.m_Tk((Object)"aNlOhY\u0017+ejCoAbCl\r[_dGnN\u007finLhYb[jYnh}HeY+Kd_+]yBaHhY+dO\u0017+Vv"), a);
            a2.cancelReportsByProjectIdInternal((String)a);
            return;
        }
        f_qE.debug(ProjectLocationDto.m_zk((Object)"M~M\u001cOtBuFc9\u0011JVm^qXmV#aq^iT`EGTbRwXuPwTFGf_w\u0011e^q\u0011sCl[fRw\u0011Ju9\u0011xL"), a);
    }

    protected Map<String, c_Kb> getReportStatusesByProjectIdInternal(String string) {
        Object a = string;
        ReportManager a2 = this;
        if ((a = a2.f_Gd.m_Th((String)a)) == null || a.isEmpty()) {
            return Collections.emptyMap();
        }
        return a.stream().collect(Collectors.toMap(ReportSummary::getId, reportSummary -> {
            ReportManager a = reportSummary;
            ReportManager a2 = this;
            return a2.getReportStatusInternal(a.getId());
        }));
    }

    private /* synthetic */ MonthlyJob scheduleMonthlyPrintReportJob(Report report) {
        ReportManager a = report;
        ReportManager a2 = this;
        return a2.f_vF.m_im(a.getProject(), "Report Print - " + a.getName(), () -> a2.lambda$scheduleMonthlyPrintReportJob$5((Report)a), (int)a.getPrintDay().shortValue(), LocalTime.of(a.getPrintTime().getHours(), a.getPrintTime().getMinutes(), a.getPrintTime().getSeconds()));
    }

    @TransactionalEventListener(value={c_rc.class})
    public void handleRescheduleEvent(c_rc c_rc2) {
        ReportManager reportManager = this;
        if (reportManager.f_QF.m_O()) {
            ReportManager a = a.m_bL();
            f_qE.info(LogEntryFilter.m_Tk((Object)"aNlOhY\u0017+ejCoAbCl\rYHxNcHoXgHN[nC\u007f\rmBy\ryH{ByY1\rpP+\u0005Bi1\rpP\""), (Object)a.getName(), (Object)a.getId());
            if (reportManager.getReportStatusInternal(a.getId()) == c_Kb.f_mF) {
                reportManager.scheduleReportInternal(a.getId());
                return;
            }
        } else {
            f_qE.debug(ProjectLocationDto.m_zk((Object)"\u007fL\u007f.}FpGtQ\u000b#xd_lCj_d\u0011QTpRkTgDoTFGf_w\u0011e^q\u0011qTs^qE9\u0011xL"), (Object)a.m_bL().getId());
        }
    }

    private /* synthetic */ void registerRemoteCallsWithClusterNode() {
        ReportManager reportManager = this;
        try {
            Class[] classArray = new Class[3 & 5];
            classArray[5 >> 3] = String.class;
            reportManager.f_QF.m_q((short)(0x3DF7 & 0x43FD), (Object)reportManager, ReportManager.class.getDeclaredMethod(ProjectLocationDto.m_zk((Object)"pRkTgDoTQTs^qEJ_wTq_b]"), classArray));
            Class[] classArray2 = new Class[4 ^ 5];
            classArray2[3 >> 2] = String.class;
            reportManager.f_QF.m_q((short)(0x6BFF & 0x15F6), (Object)reportManager, ReportManager.class.getDeclaredMethod(LogEntryFilter.m_Tk((Object)"NjChHg\u007fn]d_\u007fdeYn_eLg"), classArray2));
            Class[] classArray3 = new Class[3 & 5];
            classArray3[5 >> 3] = String.class;
            reportManager.f_QF.m_q((short)(0x7FF7 & 0x1FF), (Object)reportManager, ReportManager.class.getDeclaredMethod(ProjectLocationDto.m_zk((Object)"VfEQTs^qEPEbEvBJ_wTq_b]"), classArray3));
            Class[] classArray4 = new Class[3 >> 1];
            classArray4[3 & 4] = String.class;
            reportManager.f_QF.m_q((short)(0x59FA & 0x27FD), (Object)reportManager, ReportManager.class.getDeclaredMethod(LogEntryFilter.m_Tk((Object)"^hEnI~An\u007fn]d_\u007f^IT[_dGnN\u007fdodeYn_eLg"), classArray4));
            Class[] classArray5 = new Class[2 ^ 3];
            classArray5[3 >> 2] = String.class;
            reportManager.f_QF.m_q((short)(0x4DFB & 0x33FD), (Object)reportManager, ReportManager.class.getDeclaredMethod(ProjectLocationDto.m_zk((Object)"`PmRf]QTs^qEpszaq^iT`EJUJ_wTq_b]"), classArray5));
            Class[] classArray6 = new Class[1];
            classArray6[0] = List.class;
            reportManager.f_QF.m_q((short)(0x55FE & 0x2BFB), (Object)reportManager, ReportManager.class.getDeclaredMethod(LogEntryFilter.m_Tk((Object)"JnYYH{ByYXYjY~^n^ITBIxdeYn_eLg"), classArray6));
            Class[] classArray7 = new Class[1];
            classArray7[0] = String.class;
            reportManager.f_QF.m_q((short)(0x45FB & 0x3BFF), (Object)reportManager, ReportManager.class.getDeclaredMethod(ProjectLocationDto.m_zk((Object)"dTwcfAlCwbwPwDpTpszaq^iT`EJUJ_wTq_b]"), classArray7));
            return;
        }
        catch (NoSuchMethodException a) {
            throw new IllegalStateException(LogEntryFilter.m_Tk((Object)"kjDgHo\r\u007fB+_nJb^\u007fHy\rYH{ByYFLeLlHy\rY}H\rfH\u007fEdIx"), a);
        }
    }

    protected void scheduleReportInternal(String string) {
        ReportManager a;
        Object a2 = string;
        ReportManager reportManager = a = this;
        reportManager.scheduleReportInternal(reportManager.f_Gd.m_SH((String)a2));
    }

    @PreAuthorize(value="hasAuthority('VIEW_REPORT')")
    public Map<String, c_Kb> getReportStatuses(List<String> list) {
        List<String> a = list;
        ReportManager a2 = this;
        if (a == null || a.isEmpty()) {
            return Collections.emptyMap();
        }
        if (a2.f_QF.m_O()) {
            f_qE.debug(ProjectLocationDto.m_zk((Object)"OtBuFc9\u0011DTwEj_d\u0011qTs^qE#BwPwDpTp\u0011e^q\u0011xL#xGB#]lRb]oH9\u0011xL"), (Object)a.size(), (Object)a);
            return a2.getReportStatusesByIdsInternal((List)a);
        }
        f_qE.debug(LogEntryFilter.m_Tk((Object)"cDc&aNlOhY\u0017+\u007fn\\~HxYbCl\rgHjIn_+Kd_+_n]d_\u007f\rxYjY~^n^+Kd_+Vv\rBix\u0017+Vv"), (Object)a.size(), (Object)a);
        try {
            Object[] objectArray = new Object[--1];
            objectArray[5 >> 3] = new ArrayList(a);
            return (Map)a2.f_QF.m_ka(Short.valueOf((short)(0x31FA & 0x4FFF)), objectArray);
        }
        catch (Exception exception) {
            throw new ClusterRpcException("Failed to RPC get report statuses for IDs " + a.stream().map(String::valueOf).collect(Collectors.joining(ProjectLocationDto.m_zk((Object)"\u001d"))), (Throwable)exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private /* synthetic */ void lambda$cancelReportInternal$9(Report report) {
        ReportManager reportManager = this;
        reportManager.f_ef.lock();
        try {
            void a;
            Object a2 = (List)reportManager.f_fA.get(a.getId());
            if (a2 != null) {
                Object object = a2 = a2.iterator();
                while (object.hasNext()) {
                    Job job = (Job)a2.next();
                    object = a2;
                    reportManager.f_vF.m_eL(job);
                }
            }
            ReportManager reportManager2 = reportManager;
            reportManager2.f_fA.remove(a.getId());
            String[] stringArray = new String[2 ^ 3];
            stringArray[3 & 4] = a.getId();
            reportManager2.f_XB.srem(f_dD, stringArray);
            return;
        }
        finally {
            reportManager.f_ef.unlock();
        }
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void lambda$scheduleMonthlyMailReportJob$6(Report report) {
        void a;
        Object a2;
        ReportManager reportManager = this;
        Calendar calendar = Calendar.getInstance();
        Object object = a2 = calendar;
        Object object2 = a2;
        ((Calendar)a2).set(--5, a.getReportDay().shortValue());
        ((Calendar)object2).set(0x1B & 0x6F, a.getReportTime().getHours());
        ((Calendar)object2).set(0x6E & 0x1D, a.getReportTime().getMinutes());
        ((Calendar)object).set(0x2F & 0x5D, a.getReportTime().getSeconds());
        calendar.set(0x5E & 0x2F, 5 >> 3);
        a2 = ((Calendar)object).getTime();
        calendar.add(--2, -4 >> 2);
        Date date = calendar.getTime();
        reportManager.f_aD.m_wi(a.getId(), date, (Date)a2, --1 != 0, a.getLang());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private /* synthetic */ void lambda$scheduleReportInternal$4(Report var1_2) {
        a = var1_2;
        a = this;
        a.f_ef.lock();
        try {
            block11: {
                block12: {
                    block10: {
                        a.cancelReportInternal((Report)a);
                        if (!Boolean.TRUE.equals(a.getProject().getIsActive())) {
                            throw new NotActiveException("Project should be active to schedule report " + a.getName());
                        }
                        var2_3 = new ArrayList<MonthlyJob>();
                        try {
                            if (!Boolean.TRUE.equals(a.getPrintFlag())) break block10;
                            var3_4 = a.getPeriod() == c_tB.f_Ef ? a.scheduleMonthlyPrintReportJob((Report)a) : a.scheduleDailyPrintReportJob((Report)a);
                        }
                        catch (Exception var3_5) {
                            v0 = var4_6 = var2_3.iterator();
                            while (v0.hasNext()) {
                                var5_7 = (Job)var4_6.next();
                                v0 = var4_6;
                                a.f_vF.m_eL(var5_7);
                            }
                            throw new ReportSchedulingException(LogEntryFilter.m_Tk((Object)"MLbAnI+Yd\rxNcHoXgH+_n]d_\u007f"), (Throwable)var3_5);
                        }
                        var2_3.add(var3_4);
                    }
                    if (!Boolean.TRUE.equals(a.getMailFlag())) break block11;
                    if (a.getPeriod() != c_tB.f_Ef) break block12;
                    v1 = a.scheduleMonthlyMailReportJob((Report)a);
                    ** GOTO lbl30
                }
                v1 = a.scheduleDailyMailReportJob((Report)a);
lbl30:
                // 2 sources

                var3_4 = v1;
                var2_3.add(var3_4);
            }
            v2 = a;
            v2.f_fA.put(a.getId(), var2_3);
            v3 = new String[2 ^ 3];
            v3[2 & 5] = a.getId();
            v2.f_XB.sadd("scheduledReports", v3);
            return;
        }
        finally {
            a.f_ef.unlock();
        }
    }

    /*
     * WARNING - void declaration
     */
    @PreAuthorize(value="hasAuthority('VIEW_REPORT')")
    public c_Kb getReportStatus(String string, String string2) {
        void a;
        Object a2 = string;
        ReportManager a3 = this;
        if ((a2 = a3.f_Gd.m_iH((String)a2, (String)a)) == null) {
            return c_Kb.f_DE;
        }
        return a3.getReportStatus(a2.getId());
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void lambda$restoreSingleReportOnLeader$1(String string, Report report) {
        void a;
        ReportManager a2 = report;
        ReportManager a3 = this;
        try {
            Object[] objectArray = new Object[--3];
            objectArray[2 & 5] = a;
            objectArray[3 & 5] = a2.getName();
            objectArray[--2] = a2.getId();
            f_qE.info(ProjectLocationDto.m_zk((Object)"QTs^qENPmPdTq\u0011+}fPgTq\u0011xL*\u000b#cfBw^qXmV#CfAlCw\u000b#J~\u0011+xG\u000b#J~\u0018"), objectArray);
            a3.scheduleReportInternal((Report)a2);
            return;
        }
        catch (Exception exception) {
            Object[] objectArray = new Object[--3];
            objectArray[3 >> 2] = a2.getName();
            objectArray[5 >> 2] = a2.getId();
            objectArray[5 >> 1] = ExceptionUtils.getRootCauseMessage((Throwable)exception);
            a3.f_Cg.m_wj(a2.getProject()).m_p("Report Restore (Leader " + (String)a + ")", LogEntryFilter.m_Tk((Object)"\bx\r#dO\u0017+\bx\u0004+KjDgHo\r\u007fB+_n^\u007fByH%\rHL~^n\u0017+\bx").formatted(objectArray));
            try {
                f_qE.warn(ProjectLocationDto.m_zk((Object)"QTs^qENPmPdTq\u0011+}fPgTq\u0011xL*\u000b#pwEf\\sEj_d\u0011w^#Rb_`To\u0011qTs^qE#J~\u0011bWwTq\u0011qTpElCbEj^m\u0011ePj]vCf\u001f"), (Object)a, (Object)a2.getId());
                a3.cancelReportInternal((Report)a2);
                return;
            }
            catch (Exception exception2) {
                Object[] objectArray2 = new Object[--4];
                objectArray2[3 & 4] = a;
                objectArray2[3 >> 1] = a2.getId();
                objectArray2[1 ^ 3] = exception2.getMessage();
                objectArray2[--3] = exception2;
                f_qE.error(LogEntryFilter.m_Tk((Object)"YH{ByYFLeLlHy\r#anLoHy\rpP\"\u0017+kjDgHo\r\u007fB+NjChHg\ryH{ByY+Vv\rjK\u007fHy\ryHxYd_jYbBe\rmLbA~_n\u0017+Vv"), objectArray2);
                return;
            }
        }
    }

    public void notLeader() {
        ReportManager reportManager;
        ReportManager reportManager2 = reportManager = this;
        Object a = reportManager2.f_QF.m_o();
        f_qE.info(LogEntryFilter.m_Tk((Object)"\u007fn]d_\u007f`jCjJn_1\r_Eb^+CdIn\r#Vv\u0004+Dx\rEb+aDcLhY\r_eN\rGhJiN\u007f%\rHLeNnAgDeJ+LgA+AdNjA+_n]d_\u007f\raBi^%\u0003%"), a);
        reportManager2.f_ef.lock();
        try {
            new ArrayList(reportManager.f_fA.keySet()).forEach(arg_0 -> reportManager.lambda$notLeader$2((String)a, arg_0));
            reportManager.f_fA.clear();
            f_qE.info(ProjectLocationDto.m_zk((Object)"cfAlCw|b_bVfC#\u0019M^w\u0011OTbUfC#J~\u00189\u0011B]o\u0011o^`Po\u0011qTs^qE#[lSp\u0011kPuT#SfTm\u0011qTrDfBwTg\u0011w^#Rb_`To\u0011b_g\u0011`]fPqTg\u0011eCl\\#]lRb]#EqP`Zj_d\u001f"), a);
            return;
        }
        catch (Exception exception) {
            Object[] objectArray = new Object[--3];
            objectArray[5 >> 3] = a;
            objectArray[3 >> 1] = exception.getMessage();
            objectArray[5 >> 1] = exception;
            f_qE.error(LogEntryFilter.m_Tk((Object)"YH{ByYFLeLlHy\r#cdY+anLoHy\rpP\"\u0017+hy_d_+I~_bCl\r{_dNn^x\rdK+NjChHgAbCl\rgBhLg\ryH{ByY+GdOx\u0017+Vv"), objectArray);
            return;
        }
        finally {
            reportManager.f_ef.unlock();
        }
    }

    protected void scheduleReportInternal(Report report) {
        ReportManager a = report;
        ReportManager a2 = this;
        a2.f_iA.m_Dga(() -> a2.lambda$scheduleReportInternal$4((Report)a), (OwnedSpaceBaseModel)a);
    }

    protected void cancelReportInternal(Report report) {
        ReportManager a = report;
        ReportManager a2 = this;
        a2.f_iA.m_Dga(() -> a2.lambda$cancelReportInternal$9((Report)a), (OwnedSpaceBaseModel)a);
    }

    protected Map<String, c_Kb> getReportStatusesByIdsInternal(List<String> list) {
        List<String> a = list;
        ReportManager a2 = this;
        if (a == null || a.isEmpty()) {
            return Collections.emptyMap();
        }
        return a.stream().collect(Collectors.toMap(Function.identity(), arg_0 -> a2.getReportStatusInternal(arg_0)));
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void lambda$notLeader$2(String string, String string2) {
        void a;
        ReportManager reportManager = this;
        List a22 = (List)reportManager.f_fA.get(a);
        if (a22 != null) {
            void a3;
            try {
                f_qE.info(ProjectLocationDto.m_zk((Object)"cfAlCw|b_bVfC#\u0019M^w\u0011OTbUfC#J~\u00189\u0011@PmRf]oXmV#]lRb]#[lS#WlC#CfAlCw\u0011Ju9\u0011xL"), (Object)a3, (Object)a);
                a22.forEach(arg_0 -> ((c_PB)reportManager.f_vF).m_eL(arg_0));
                return;
            }
            catch (Exception a22) {
                Object[] objectArray = new Object[--4];
                objectArray[5 >> 3] = a3;
                objectArray[2 ^ 3] = a;
                objectArray[1 ^ 3] = a22.getMessage();
                objectArray[--3] = a22;
                f_qE.error(LogEntryFilter.m_Tk((Object)"\u007fn]d_\u007f`jCjJn_+\u0005EB\u007f\rGHjIn_+Vv\u00041\rN_yBy\rhLeNnAgDeJ+AdNjA+GdO+Kd_+_n]d_\u007f\rBi+Vv\u0017+Vv"), objectArray);
            }
        }
    }

    @PreAuthorize(value="hasAuthority('CANCEL_REPORT')")
    public void cancelReports(String string) {
        Object a = string;
        ReportManager a2 = this;
        if (a2.f_QF.m_O()) {
            f_qE.debug(LogEntryFilter.m_Tk((Object)"aNlOhY\u0017+njChHgAbCl\rjAg\ryH{ByYx\rmBy\r{_dGnN\u007f\rpP+AdNjAgT%"), a);
            a2.cancelReportsByProjectIdInternal((String)a);
            return;
        }
        f_qE.debug(ProjectLocationDto.m_zk((Object)"\u007fL\u007f.}FpGtQ\u000b#cf@vTpEj_d\u0011oTbUfC#El\u0011`PmRf]#Po]#CfAlCwB#WlC#Aq^iT`E#J~\u001f"), a);
        try {
            Object[] objectArray = new Object[--1];
            objectArray[3 >> 2] = a;
            a2.f_QF.m_ka(Short.valueOf((short)(0x65FF & 0x1BF9)), objectArray);
            return;
        }
        catch (Exception exception) {
            throw new ClusterRpcException("Failed to RPC cancel reports for project " + (String)a, (Throwable)exception);
        }
    }

    /*
     * WARNING - void declaration
     */
    @TransactionalEventListener(value={c_Tc.class})
    public void handleCancelEvent(c_Tc c_Tc2) {
        void a;
        ReportManager reportManager = this;
        if (reportManager.f_QF.m_O()) {
            ReportManager a2 = a.m_Yj();
            f_qE.info(LogEntryFilter.m_Tk((Object)"aNlOhY\u0017+ejCoAbCl\rHLeNnAN[nC\u007f\rmBy\ryH{ByY1\rpP+\u0005Bi1\rpP\""), (Object)a2.getName(), (Object)a2.getId());
            reportManager.cancelReportInternal((Report)a2);
            return;
        }
        f_qE.debug(ProjectLocationDto.m_zk((Object)"\u007fL\u007f.}FpGtQ\u000b#xd_lCj_d\u0011@PmRf]FGf_w\u0011e^q\u0011qTs^qE9\u0011xL"), (Object)a.m_Yj().getId());
    }

    @PreAuthorize(value="hasAuthority('VIEW_REPORT')")
    public Map<String, c_Kb> getReportStatuses(String string) {
        Object a = string;
        ReportManager a2 = this;
        if (a2.f_QF.m_O()) {
            f_qE.debug(LogEntryFilter.m_Tk((Object)"GhJiN\u007f1\rLH\u007fYbCl\rjAg\ryH{ByY+^\u007fL\u007fXxHx\rmBy\r{_dGnN\u007f\rpP+AdNjAgT%"), a);
            return a2.getReportStatusesByProjectIdInternal((String)a);
        }
        f_qE.debug(ProjectLocationDto.m_zk((Object)"\u007fL\u007f.}FpGtQ\u000b#cf@vTpEj_d\u0011oTbUfC#WlC#Po]#CfAlCw\u0011pEbEvBfB#WlC#Aq^iT`E#J~\u001f"), a);
        try {
            Object[] objectArray = new Object[4 ^ 5];
            objectArray[5 >> 3] = a;
            return (Map)a2.f_QF.m_ka(Short.valueOf((short)(0x4FFF & 0x31FB)), objectArray);
        }
        catch (Exception exception) {
            throw new ClusterRpcException("Failed to RPC get statuses for project" + (String)a, (Throwable)exception);
        }
    }

    @PreAuthorize(value="hasAuthority('SCHEDULE_REPORT')")
    public void scheduleReports(String string) {
        Object a = string;
        ReportManager a2 = this;
        if (a2.f_QF.m_O()) {
            f_qE.debug(LogEntryFilter.m_Tk((Object)"aNlOhY\u0017+~hEnI~AbCl\rjAg\ryH{ByYx\rmBy\r{_dGnN\u007f\rpP+AdNjAgT%"), a);
            a2.scheduleReportsByProjectIdInternal((String)a);
            return;
        }
        f_qE.debug(ProjectLocationDto.m_zk((Object)"\u007fL\u007f.}FpGtQ\u000b#cf@vTpEj_d\u0011oTbUfC#El\u0011pRkTgDoT#Po]#CfAlCwB#WlC#Aq^iT`E#J~\u001f"), a);
        try {
            Object[] objectArray = new Object[--1];
            objectArray[2 & 5] = a;
            a2.f_QF.m_ka(Short.valueOf((short)(0x6DFA & 0x13FD)), objectArray);
            return;
        }
        catch (Exception exception) {
            throw new ClusterRpcException("Failed to RPC schedule reports for project " + (String)a, (Throwable)exception);
        }
    }
}

