/*
 * Decompiled with CFR 0.152.
 */
package com.inscada.mono.filesystem.g;

import com.inscada.mono.communication.base.restcontrollers.ConnectionController;
import com.inscada.mono.communication.base.services.g.c_sD;
import com.inscada.mono.filesystem.model.FileDownloadResult;
import com.inscada.mono.filesystem.model.FileInfo;
import com.inscada.mono.filesystem.repositories.FileInfoRepository;
import com.inscada.mono.shared.c.c_Fc;
import com.inscada.mono.shared.exceptions.FileStorageException;
import com.inscada.mono.shared.exceptions.NotFoundException;
import com.inscada.mono.shared.model.BaseModel;
import com.inscada.mono.shared.model.ModelUpdater;
import com.inscada.mono.shared.model.SpaceBaseModel;
import com.inscada.mono.space.SpaceContext;
import com.inscada.mono.space.model.Space;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.io.Resource;
import org.springframework.core.io.UrlResource;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.StringUtils;
import org.springframework.web.multipart.MultipartFile;

@Service
@Transactional(readOnly=true)
public class c_Jb {
    private final String f_Hi;
    public static final String f_jh = "project-icons";
    public static final String f_bh = "symbols";
    public static final String f_vI = "general-uploads";
    private static final Logger f_nh = LoggerFactory.getLogger(c_Jb.class);
    public static final String f_ph = "animations";
    public static final String f_Ci = "jasper-templates";
    public static final String f_mH = "scl-files";
    private final ModelUpdater f_Ch;
    private final FileInfoRepository f_Yh;
    public static final String f_AG = "login-images";
    public static final String f_ZI = "faceplates";
    public static final String f_JH = "logo";

    /*
     * WARNING - void declaration
     */
    @Transactional
    @PreAuthorize(value="hasAuthority('CREATE_FILE') and hasAuthority('UPDATE_LOGIN_SETTINGS')")
    public String m_po(MultipartFile multipartFile) {
        void a22;
        c_Jb c_Jb2 = this;
        void v0 = a22;
        Objects.requireNonNull(v0, c_sD.m_Yu((Object)"-J\fK\tO\u0001M\u0014y\tS\u0005\u001f\u0003^\u000eQ\u000fK@]\u0005\u001f\u000eJ\fSN"));
        if (v0.isEmpty()) {
            throw new FileStorageException(ConnectionController.m_dT((Object)"|4Q;P!\u001f&K:M0\u001f4QuZ8O!FuY<S0\u0011"));
        }
        Object a = StringUtils.cleanPath((String)Objects.requireNonNull(a22.getOriginalFilename(), c_sD.m_Yu((Object)"-J\fK\tO\u0001M\u0014y\tS\u0005\u001f\u000fM\tX\tQ\u0001S@Y\tS\u0005Q\u0001R\u0005\u001f\u0003^\u000eQ\u000fK@]\u0005\u001f\u000eJ\fSN")));
        if (a.contains(ConnectionController.m_dT((Object)"{\u0011"))) {
            throw new FileStorageException(c_sD.m_Yu((Object)"&V\fZ\u000e^\rZ@\\\u000fQ\u0014^\tQ\u0013\u001f\tQ\u0016^\fV\u0004\u001f\u0010^\u0014W@L\u0005N\u0015Z\u000e\\\u0005\u001fG\u0011N\u0018N"));
        }
        Path path = Path.of(c_Jb2.f_Hi, new String[5 >> 3]).toAbsolutePath().normalize().resolve(f_AG).normalize();
        Path path2 = path.resolve((String)a).normalize();
        if (!path2.startsWith(path)) {
            throw new FileStorageException(ConnectionController.m_dT((Object)"\u001cQ#^9V1\u001f9P2V;\u001f<R4X0\u001f%^!W"));
        }
        try {
            Files.createDirectories(path, new FileAttribute[2 & 5]);
            CopyOption[] copyOptionArray = new CopyOption[2 ^ 3];
            copyOptionArray[3 >> 2] = StandardCopyOption.REPLACE_EXISTING;
            Files.copy(a22.getInputStream(), path2, copyOptionArray);
            f_nh.info(c_sD.m_Yu((Object)",P\u0007V\u000e\u001f\tR\u0001X\u0005\u001fGD\u001d\u0018@L\u0015\\\u0003Z\u0013L\u0006J\fS\u0019\u001f\u0017M\tK\u0014Z\u000e\u001f\u0014P@Y\tS\u0005L\u0019L\u0014Z\r\u001f\u0001K@\u0018\u001bBG"), a, (Object)path2);
            return a;
        }
        catch (IOException a22) {
            throw new FileStorageException("Could not store login image " + (String)a + ". Please try again!", (Throwable)a22);
        }
    }

    private static /* synthetic */ NotFoundException m_kO(String a) {
        return new NotFoundException("File info not found with id: " + a);
    }

    /*
     * WARNING - void declaration
     */
    @PreAuthorize(value="hasAuthority('DELETE_FILE')")
    @Transactional
    public void m_ZN(String string) {
        Path path;
        FileInfo fileInfo;
        void a;
        Object object;
        block5: {
            object = this;
            fileInfo = object.m_wo((String)a).orElse(null);
            if (fileInfo == null) {
                return;
            }
            String[] stringArray = new String[5 >> 2];
            stringArray[3 & 4] = fileInfo.getSpace().getName();
            Path path2 = Path.of(object.f_Hi, stringArray);
            path = path2.resolve(fileInfo.getRelativePath()).normalize();
            if (!Files.exists(path, new LinkOption[2 & 5])) break block5;
            Object a2 = fileInfo.getFileName();
            String string2 = LocalDateTime.now().format(DateTimeFormatter.ofPattern(ConnectionController.m_dT((Object)"F,F,r\u0018[1`\u001dw8R&L")));
            Object object2 = a2;
            String string3 = "";
            int n = ((String)object2).lastIndexOf(0x2E & 0x7F);
            if (n > 0) {
                Object object3 = a2;
                object2 = ((String)object3).substring(2 & 5, n);
                string3 = ((String)object3).substring(n);
            }
            a2 = (String)object2 + "_deleted_" + string2 + string3;
            Path path3 = path;
            a2 = path3.getParent().resolve((String)a2);
            Files.move(path3, (Path)a2, new CopyOption[5 >> 3]);
            f_nh.info(c_sD.m_Yu((Object)"&V\fZ@M\u0005Q\u0001R\u0005[@Y\u0012P\r\u001fGD\u001d\u0018@K\u000f\u001fGD\u001d\u0018@Y\u000fM@[\u0005S\u0005K\u0005"), (Object)path, a2);
        }
        try {
            f_nh.warn(ConnectionController.m_dT((Object)"\u0005W,L<\\4SuY<S0\u001f;P!\u001f3P Q1\u001f3P'\u001f1Z9Z!Zo\u001f.B"), (Object)path);
        }
        catch (IOException iOException) {
            f_nh.error(c_sD.m_Yu((Object)"|\u000fJ\f[@Q\u000fK@M\u0005Q\u0001R\u0005\u001f\u0006V\fZ@Y\u000fM@[\u0005S\u0005K\u0005\u0005@D\u001d"), (Object)fileInfo.getFileName(), (Object)iOException);
        }
        object.f_Yh.delete((Object)fileInfo);
        f_nh.info(ConnectionController.m_dT((Object)"\u0013V9Zu[0S0K0[uY:Muv\u0011\u0005uD(\u0013up'V2V;^9\u001f\u001b^8Zo\u001f.B"), (Object)a, (Object)fileInfo.getFileName());
    }

    @PreAuthorize(value="hasAuthority('VIEW_FILE')")
    public FileInfo m_RO(String string) {
        Object a = string;
        c_Jb a2 = this;
        return (FileInfo)a2.m_pM((String)a).orElseThrow(() -> c_Jb.m_Um((String)a));
    }

    @Transactional
    @PreAuthorize(value="hasAuthority('CREATE_FILE') and hasAuthority('UPDATE_FILE')")
    public void m_Ao(Collection<FileInfo> collection) {
        Iterator a;
        c_Jb c_Jb2 = this;
        Object object = a.stream().map(BaseModel::getId).filter(Objects::nonNull).collect(Collectors.toSet());
        Object object2 = a.stream().map(FileInfo::getName).filter(c_Fc::m_vD).collect(Collectors.toSet());
        object = c_Jb2.f_Yh.findByIdInOrNameIn(object, object2);
        object2 = object.stream().collect(Collectors.toMap(BaseModel::getId, Function.identity()));
        object = object.stream().collect(Collectors.toMap(FileInfo::getName, Function.identity()));
        ArrayList<Object> arrayList = new ArrayList<Object>();
        a = a.iterator();
        while (a.hasNext()) {
            FileInfo fileInfo;
            c_Jb a2 = (FileInfo)a.next();
            Object object3 = a2.getId() != null ? (FileInfo)object2.get(a2.getId()) : (fileInfo = c_Fc.m_vD((String)a2.getName()) ? (FileInfo)object.get(a2.getName()) : null);
            if (fileInfo != null) {
                c_Jb2.f_Ch.copyForUpdate((Object)a2, (SpaceBaseModel)fileInfo, new String[2 & 5]);
                arrayList.add(fileInfo);
                continue;
            }
            arrayList.add(a2);
        }
        c_Jb2.f_Yh.bulkSave(arrayList);
    }

    /*
     * WARNING - void declaration
     */
    public c_Jb(FileInfoRepository fileInfoRepository, ModelUpdater modelUpdater, @Value(value="${ins.files.path}") String string) {
        void modelUpdater2;
        void fileInfoRepository2;
        c_Jb a;
        c_Jb c_Jb2 = object;
        Object object = string;
        c_Jb c_Jb3 = a = c_Jb2;
        a.f_Yh = fileInfoRepository2;
        c_Jb3.f_Ch = modelUpdater2;
        c_Jb3.f_Hi = object;
    }

    @PreAuthorize(value="hasAuthority('VIEW_FILE')")
    public Optional<FileInfo> m_pM(String string) {
        Object a = string;
        c_Jb a2 = this;
        return a2.f_Yh.findByRelativePath((String)a);
    }

    @PreAuthorize(value="hasAuthority('VIEW_FILE')")
    public FileInfo m_mm(String string) {
        Object a = string;
        c_Jb a2 = this;
        return a2.f_Yh.findOneByName((String)a);
    }

    /*
     * WARNING - void declaration
     */
    public FileDownloadResult m_eM(String string) {
        Path path;
        block7: {
            FileInfo fileInfo;
            Object a;
            void a2;
            c_Jb c_Jb2 = this;
            if (!StringUtils.hasText((String)a2)) {
                throw new NotFoundException(ConnectionController.m_dT((Object)"q:\u001f9P2V;\u001f7^6T2M:J;[uV8^2ZuY<S0Q4R0\u001f%M:I<[0["));
            }
            Path path2 = Path.of(c_Jb2.f_Hi, new String[3 >> 2]);
            path = path2.resolve(f_AG).resolve((String)a2).normalize();
            if (!path.startsWith((Path)(a = path2.resolve(f_AG).normalize()))) {
                throw new FileStorageException(c_sD.m_Yu((Object)"v\u000eI\u0001S\t[@S\u000fX\tQ@V\r^\u0007Z@O\u0001K\b"));
            }
            a = new UrlResource(path.toUri());
            if (!a.exists() || !a.isReadable()) break block7;
            FileInfo fileInfo2 = fileInfo = new FileInfo();
            fileInfo2.setFileName((String)a2);
            fileInfo2.setFileType(Files.probeContentType(path));
            if (fileInfo2.getFileType() == null) {
                fileInfo.setFileType(ConnectionController.m_dT((Object)"4O%S<\\4K<P;\u0010:\\!Z!\u0012&K'Z4R"));
            }
            return new FileDownloadResult((Resource)a, fileInfo);
        }
        try {
            f_nh.error(c_sD.m_Yu((Object)"s\u000fX\tQ@V\r^\u0007Z@Y\tS\u0005\u001f\u000eP\u0014\u001f\u0006P\u0015Q\u0004\u001f\u000fQ@[\tL\u000b\u0005@D\u001d"), (Object)path);
            throw new NotFoundException(ConnectionController.m_dT((Object)"\u0019P2V;\u001f<R4X0\u001f3V9ZuQ:KuY:J;["));
        }
        catch (MalformedURLException a) {
            throw new NotFoundException(c_sD.m_Yu((Object)",P\u0007V\u000e\u001f\tR\u0001X\u0005\u001f\u0006V\fZ@Q\u000fK@Y\u000fJ\u000e[@\u0017\r^\fY\u000fM\rZ\u0004\u001f5m,\u0016N"));
        }
        catch (IOException a) {
            f_nh.error(ConnectionController.m_dT((Object)"\u0010M'P'\u001f4\\6Z&L<Q2\u001f9P2V;\u001f<R4X0\u001f3V9Zo\u001f.B"), (Object)path, (Object)a);
            throw new NotFoundException(c_sD.m_Yu((Object)"s\u000fX\tQ@V\r^\u0007Z@Y\tS\u0005\u001f\u000eP\u0014\u001f\u0006P\u0015Q\u0004"));
        }
    }

    /*
     * WARNING - void declaration
     */
    @Transactional
    @PreAuthorize(value="hasAuthority('UPDATE_FILE')")
    public FileInfo m_Xm(String string, MultipartFile multipartFile, FileInfo fileInfo) {
        String string2;
        String string3;
        void a;
        int n;
        Object object;
        c_Jb a2;
        void a3;
        c_Jb c_Jb2;
        block12: {
            int n2;
            void v2;
            void a222;
            c_Jb2 = this;
            Objects.requireNonNull(a3, c_sD.m_Yu((Object)"j\u0010[\u0001K\u0005[@R\u0005K\u0001[\u0001K\u0001\u001fHy\tS\u0005v\u000eY\u000f\u0016@P\u0002U\u0005\\\u0014\u001f\u0003^\u000eQ\u000fK@]\u0005\u001f\u000eJ\fSN"));
            a2 = c_Jb2.m_Am((String)a222);
            String[] stringArray = new String[2 ^ 3];
            stringArray[5 >> 3] = a2.getSpace().getName();
            object = Path.of(c_Jb2.f_Hi, stringArray).toAbsolutePath().normalize();
            Path path = object.resolve(a2.getRelativePath()).normalize();
            int n3 = n = a != null && !a.isEmpty() ? 5 >> 2 : 0;
            if (n != 0) {
                string3 = StringUtils.cleanPath((String)Objects.requireNonNull(a.getOriginalFilename(), ConnectionController.m_dT((Object)"\u0018J9K<O4M!y<S0\u001f:M<X<Q4SuY<S0Q4R0\u001f6^;Q:Ku]0\u001f;J9SuH=Z;\u001f'Z%S4\\<Q2\u001f6P;K0Q!\u0011")));
                v2 = a3;
            } else {
                string3 = a2.getFileName();
                v2 = a3;
            }
            String string4 = StringUtils.hasText((String)v2.getTargetSubdirectory()) ? StringUtils.cleanPath((String)a3.getTargetSubdirectory()) : (string2 = StringUtils.hasText((String)a2.getTargetSubdirectory()) ? a2.getTargetSubdirectory() : f_vI);
            if (string3.contains(c_sD.m_Yu((Object)"\u0011N")) || string2.contains(ConnectionController.m_dT((Object)"{\u0011"))) {
                throw new FileStorageException(c_sD.m_Yu((Object)")Q\u0016^\fV\u0004\u001f\u0010^\u0014W@L\u0010Z\u0003V\u0006V\u0005[@V\u000e\u001f\u0015O\u0004^\u0014Z@M\u0005N\u0015Z\u0013KN"));
            }
            Path path2 = object.resolve(string2).normalize();
            if (!path2.startsWith((Path)object)) {
                f_nh.warn(ConnectionController.m_dT((Object)"o4K=\u001f!M4I0M&^9\u001f4K!Z8O!\u0011uq0HuK4M2Z!\u001f&J7[<M0\\!P'Fu\u0018.Br\u001f'Z&P9I0LuP K&V1ZuL%^6ZuM:P!\u001frD(\u0018"), (Object)string2, object);
                throw new FileStorageException(c_sD.m_Yu((Object)")Q\u0016^\fV\u0004\u001f\u0004V\u0012Z\u0003K\u000fM\u0019\u001f\u0010^\u0014W@L\u0010Z\u0003V\u0006V\u0005[N"));
            }
            Path path3 = path2.resolve(string3).normalize();
            if (!path3.startsWith(path2)) {
                f_nh.warn(ConnectionController.m_dT((Object)"o4K=\u001f!M4I0M&^9\u001f4K!Z8O!\u001f#V4\u001f;Z\"\u001f3V9Z;^8Z{\u001f\u0013V9Z;^8Zu\u0018.Br\u001f<Qu[<M0\\!P'Fu\u0018.Br\u001f'Z&P9I0LuP K&V1Z"), (Object)string3, (Object)path2);
                throw new FileStorageException(c_sD.m_Yu((Object)")Q\u0016^\fV\u0004\u001f\u0006V\fZ\u000e^\rZ@L\u0010Z\u0003V\u0006V\u0005[N"));
            }
            int n4 = n2 = !((String)(object = object.relativize(path3).toString().replace(ConnectionController.m_dT((Object)"c"), c_sD.m_Yu((Object)"O")))).equals(a2.getRelativePath()) ? --1 : 0;
            if (n2 != 0 && c_Jb2.f_Yh.existsByRelativePathAndIdNot((String)object, (String)a222)) {
                throw new FileStorageException(ConnectionController.m_dT((Object)"\u0014\u001f3V9ZuH<K=\u001f!W<LuQ4R0\u001f4S'Z4[,\u001f0G<L!Lu^!\u001f!W0\u001f!^'X0KuS:\\4K<P;\u0011"));
            }
            try {
                if (n != 0) {
                    if (Files.exists(path, new LinkOption[2 & 5])) {
                        Files.deleteIfExists(path);
                        f_nh.info(c_sD.m_Yu((Object)"p\f[@Y\tS\u0005\u001f\u0003P\u000eK\u0005Q\u0014\u001f\u0004Z\fZ\u0014Z\u0004\u001f\u0006M\u000fR@Y\tS\u0005L\u0019L\u0014Z\r\u0005@D\u001d"), (Object)path);
                    }
                    Files.createDirectories(path2, new FileAttribute[3 ^ 3]);
                    CopyOption[] copyOptionArray = new CopyOption[2 ^ 3];
                    copyOptionArray[3 & 4] = StandardCopyOption.REPLACE_EXISTING;
                    Files.copy(a.getInputStream(), path3, copyOptionArray);
                    f_nh.info(ConnectionController.m_dT((Object)"\u001bZ\"\u001f3V9Zu\\:Q!Z;KuY:Mu\u0018.Br\u001f&J6\\0L&Y S9FuH'V!K0QuK:\u001f3V9Z&F&K0Ru^!\u001frD(\u0018"), (Object)string3, (Object)path3);
                    break block12;
                }
                if (n2 == 0) break block12;
                if (Files.exists(path, new LinkOption[2 & 5])) {
                    Files.createDirectories(path2, new FileAttribute[0]);
                    CopyOption[] copyOptionArray = new CopyOption[1];
                    copyOptionArray[0] = StandardCopyOption.REPLACE_EXISTING;
                    Files.move(path, path3, copyOptionArray);
                    f_nh.info(c_sD.m_Yu((Object)"y\tS\u0005\u001f\rP\u0016Z\u0004\u001f\u0006M\u000fR@D\u001d\u001f\u0014P@D\u001d"), (Object)path, (Object)path3);
                    break block12;
                }
                f_nh.warn(ConnectionController.m_dT((Object)"\u001aS1\u001f3V9ZuQ:KuY:J;[u^!\u001f.BuY:MuR:I0\u001f:O0M4K<P;\u0013u] KuR0K4[4K4\u001f0G<L!Z1\u0011"), (Object)path);
                throw new NotFoundException(c_sD.m_Yu((Object)"y\tS\u0005\u001f\u000eP\u0014\u001f\u0006P\u0015Q\u0004\u001f\u0006P\u0012\u001f\u0015O\u0004^\u0014Z@P\u0010Z\u0012^\u0014V\u000fQN"));
            }
            catch (IOException a222) {
                f_nh.error(ConnectionController.m_dT((Object)"|:J9[uQ:KuJ%[4K0\u001f3V9Zu\u0018.Br\u001f1J0\u001f!Puv\u001az-\\0O!V:Q"), (Object)a2.getFileName(), (Object)a222);
                throw new FileStorageException(c_sD.m_Yu((Object)"|\u000fJ\f[@Q\u000fK@J\u0010[\u0001K\u0005\u001f\u0014W\u0005\u001f\u0006V\fZN\u001f0S\u0005^\u0013Z@K\u0012F@^\u0007^\tQN"));
            }
        }
        c_Jb c_Jb3 = a2;
        c_Jb c_Jb4 = a2;
        c_Jb4.setName(a3.getName());
        c_Jb4.setDsc(a3.getDsc());
        c_Jb3.setFileName(string3);
        c_Jb3.setTargetSubdirectory(string2);
        a2.setRelativePath((String)object);
        if (n != 0) {
            c_Jb c_Jb5 = a2;
            c_Jb5.setFileSize(Long.valueOf(a.getSize()));
            c_Jb5.setFileType(StringUtils.hasText((String)a.getContentType()) ? a.getContentType() : ConnectionController.m_dT((Object)"4O%S<\\4K<P;\u0010:\\!Z!\u0012&K'Z4R"));
        }
        return (FileInfo)c_Jb2.f_Yh.save((Object)a2);
    }

    @PreAuthorize(value="hasAuthority('VIEW_FILE')")
    public Optional<FileInfo> m_wo(String string) {
        Object a = string;
        c_Jb a2 = this;
        return a2.f_Yh.findById(a);
    }

    @Transactional
    @PreAuthorize(value="hasAuthority('CREATE_FILE') and hasAuthority('UPDATE_FILE')")
    public FileInfo m_um(FileInfo fileInfo) {
        FileInfo fileInfo2;
        c_Jb a = fileInfo;
        c_Jb a2 = this;
        Object object = a.getId() != null ? a2.m_GN(a.getId()) : (fileInfo2 = StringUtils.hasText((String)a.getName()) ? a2.m_mm(a.getName()) : null);
        if (fileInfo2 != null) {
            a2.f_Ch.copyForUpdate((Object)a, (SpaceBaseModel)fileInfo2, new String[3 & 4]);
            return fileInfo2;
        }
        return (FileInfo)a2.f_Yh.save((Object)a);
    }

    @Transactional
    @PreAuthorize(value="hasAuthority('VIEW_FILE') and hasAuthority('CREATE_FILE')")
    public FileInfo m_mM(String string) {
        FileInfo a;
        c_Jb c_Jb2 = this;
        Objects.requireNonNull(a, c_sD.m_Yu((Object)"p\u0012V\u0007V\u000e^\f\u001f\u0006V\fZ@v$\u001f\u0003^\u000eQ\u000fK@]\u0005\u001f\u000eJ\fSN"));
        a = c_Jb2.m_Am((String)a);
        long l = System.currentTimeMillis();
        String string2 = a.getFileName();
        Object a22 = "";
        String string3 = string2;
        int n = string3.lastIndexOf(0x6E & 0x3F);
        if (n > 0) {
            String string4 = string2;
            string3 = string4.substring(3 & 4, n);
            a22 = string4.substring(n);
        }
        if ((string2 = StringUtils.cleanPath((String)(string3 + "_clone_" + l + (String)a22))).contains(ConnectionController.m_dT((Object)"{\u0011"))) {
            throw new FileStorageException(c_sD.m_Yu((Object)"'Z\u000eZ\u0012^\u0014Z\u0004\u001f\u0006V\fZ\u000e^\rZ@\\\u000fQ\u0014^\tQ\u0013\u001f\tQ\u0016^\fV\u0004\u001f\u0010^\u0014W@L\u0005N\u0015Z\u000e\\\u0005\u001fG\u0011N\u0018N"));
        }
        a22 = Objects.requireNonNull(SpaceContext.getActiveSpace(), ConnectionController.m_dT((Object)"~6K<I0\u001f&O4\\0\u001f<LuM0N V'Z1\u001f!Pu\\9P;Zu^uY<S0\u0011"));
        String[] stringArray = new String[--1];
        stringArray[3 ^ 3] = a22.getName();
        a22 = Path.of(c_Jb2.f_Hi, stringArray).toAbsolutePath().normalize();
        Path path = a22.resolve(string3 = StringUtils.hasText((String)a.getTargetSubdirectory()) ? a.getTargetSubdirectory() : f_vI).normalize();
        Path path2 = path.resolve(string2).normalize();
        if (!path2.startsWith(path)) {
            throw new FileStorageException("Generated filename results in path traversal: " + string2);
        }
        String string5 = a22.relativize(path2).toString().replace(c_sD.m_Yu((Object)"<"), ConnectionController.m_dT((Object)"\u0010"));
        if (c_Jb2.f_Yh.existsByRelativePath(string5)) {
            throw new FileStorageException("A file already exists at generated path: " + string5);
        }
        a22 = a22.resolve(a.getRelativePath()).normalize();
        try {
            Files.createDirectories(path, new FileAttribute[3 & 4]);
            CopyOption[] copyOptionArray = new CopyOption[2 ^ 3];
            copyOptionArray[3 & 4] = StandardCopyOption.REPLACE_EXISTING;
            Files.copy((Path)a22, path2, copyOptionArray);
            f_nh.info(c_sD.m_Yu((Object)"&V\fZ@\\\fP\u000eZ\u0004\u001f\u0006M\u000fR@\u0018\u001bBG\u001f\u0014P@\u0018\u001bBG"), a22, (Object)path2);
        }
        catch (IOException a22) {
            throw new FileStorageException("Could not clone file: " + a.getFileName(), (Throwable)a22);
        }
        a22 = a.getName() + "_clone_" + l;
        Path path3 = path = new FileInfo();
        path3.setName((String)a22);
        path3.setDsc("Clone of " + a.getName());
        Path path4 = path;
        FileInfo fileInfo = a;
        Path path5 = path;
        path5.setFileName(string2);
        path5.setRelativePath(string5);
        path.setFileSize(fileInfo.getFileSize());
        path4.setFileType(fileInfo.getFileType());
        path4.setTargetSubdirectory(string3);
        return (FileInfo)c_Jb2.f_Yh.save((Object)path);
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @PreAuthorize(value="hasAuthority('CREATE_FILE') and hasAuthority('UPDATE_FILE')")
    public void m_Bn(ZipFile zipFile, FileInfo fileInfo) {
        void a3222;
        InputStream a22;
        c_Jb c_Jb2 = this;
        ZipEntry zipEntry = ((ZipFile)((Object)a22)).getEntry(a3222.getFileName());
        if (zipEntry == null) return;
        Objects.requireNonNull(a3222, c_sD.m_Yu((Object)"&V\fZ)Q\u0006P@P\u0002U\u0005\\\u0014\u001f\u0003^\u000eQ\u000fK@]\u0005\u001f\u000eJ\fSN"));
        Object a = zipEntry.getName();
        if (((String)a).trim().isEmpty()) {
            throw new FileStorageException(ConnectionController.m_dT((Object)"e<OuZ;K'FuQ4R0\u001f6^;Q:Ku]0\u001f0R%K,\u0011"));
        }
        if (((String)a).contains(c_sD.m_Yu((Object)"\u0011N")) || ((String)a).startsWith(ConnectionController.m_dT((Object)"\u0010")) || ((String)a).startsWith(c_sD.m_Yu((Object)"<")) || ((String)a).contains(ConnectionController.m_dT((Object)"o\u0010")) || ((String)a).contains(c_sD.m_Yu((Object)"\u0005<"))) {
            f_nh.warn(ConnectionController.m_dT((Object)"e<OuL9V%\u001f4K!Z8O!\u001f1Z!Z6K0[uV;\u001f0Q!M,\u001f;^8Zo\u001frD(\u0018"), a);
            throw new FileStorageException(c_sD.m_Yu((Object)"e\tO@Z\u000eK\u0012F@\\\u000fQ\u0014^\tQ\u0013\u001f\tQ\u0016^\fV\u0004\u001f\u0010^\u0014W@L\u0005N\u0015Z\u000e\\\u0005\u001f\u0014W\u0001K@\\\u000fJ\f[@S\u0005^\u0004\u001f\u0014P@[\tM\u0005\\\u0014P\u0012F@K\u0012^\u0016Z\u0012L\u0001SN"));
        }
        Object object = ((String)a).replace((char)(0x7E & 0x5D), (char)(0x6F & 0x3F));
        if (((String)object).contains(ConnectionController.m_dT((Object)"\u0011{\u0010")) || ((String)object).contains(c_sD.m_Yu((Object)"O\u0011N")) || ((String)object).equals(ConnectionController.m_dT((Object)"{\u0011"))) {
            f_nh.warn(c_sD.m_Yu((Object)"e\tO@L\fV\u0010\u001f\u0001K\u0014Z\rO\u0014\u001f\u0004Z\u0014Z\u0003K\u0005[@V\u000e\u001f\u000eP\u0012R\u0001S\tE\u0005[@Z\u000eK\u0012F@Q\u0001R\u0005\u0005@\u0018\u001bBG"), object);
            throw new FileStorageException(ConnectionController.m_dT((Object)"e<OuZ;K'Fu\\:Q!^<Q&\u001f1V'Z6K:M,\u001f!M4I0M&^9\u001f&Z$J0Q6Z&\u0011"));
        }
        Object object2 = object;
        int n = ((String)object2).lastIndexOf(0x3F & 0x6F);
        if (n >= 0) {
            object2 = ((String)object).substring(n + (3 >> 1));
        }
        if (((String)object2).isEmpty() || ((String)object2).equals(c_sD.m_Yu((Object)"N")) || ((String)object2).equals(ConnectionController.m_dT((Object)"{\u0011"))) {
            throw new FileStorageException("Invalid filename extracted from zip entry: " + (String)a);
        }
        if (((String)(object2 = StringUtils.cleanPath((String)object2))).contains(c_sD.m_Yu((Object)"\u0011N"))) {
            throw new FileStorageException(ConnectionController.m_dT((Object)"\u0013V9Z;^8Zu\\:Q!^<Q&\u001f<Q#^9V1\u001f%^!WuL0N Z;\\0\u001fr\u0011{\u0018u^3K0Mu\\9Z4Q<Q2\u0011"));
        }
        String string = a = StringUtils.hasText((String)a3222.getTargetSubdirectory()) ? StringUtils.cleanPath((String)a3222.getTargetSubdirectory()) : f_vI;
        if (((String)a).contains(c_sD.m_Yu((Object)"\u0011N"))) {
            throw new FileStorageException(ConnectionController.m_dT((Object)"\u0001^'X0KuL ]1V'Z6K:M,\u001f6P;K4V;LuV;I4S<[uO4K=\u001f&Z$J0Q6Zu\u0018{\u0011r\u0011"));
        }
        Space a3222 = Objects.requireNonNull(SpaceContext.getActiveSpace(), c_sD.m_Yu((Object)"~\u0003K\tI\u0005\u001f\u0013O\u0001\\\u0005\u001f\tL@M\u0005N\u0015V\u0012Z\u0004\u001f\u0014P@J\u0010S\u000f^\u0004\u001f\u0001\u001f\u0006V\fZN"));
        String[] stringArray = new String[--1];
        stringArray[5 >> 3] = a3222.getName();
        object = Path.of(c_Jb2.f_Hi, stringArray).toAbsolutePath().normalize();
        Path path = object.resolve((String)a).normalize();
        if (!path.startsWith((Path)object)) {
            Object[] objectArray = new Object[--3];
            objectArray[2 & 5] = a;
            objectArray[--1] = object;
            objectArray[5 >> 1] = a3222.getName();
            f_nh.warn(ConnectionController.m_dT((Object)"\u0005^!WuK'^#Z'L4Su^!K0R%K{\u001f\u0000O9P4[uK:\u001f1Z'V#Z1\u001f1V'Z6K:M,\u001frD(\u0018uM0L:S#Z&\u001f:J!L<[0\u001f&O4\\0\u001f'P:Ku\u0018.Br\u001f3P'\u001f&O4\\0\u001frD(\u0018"), objectArray);
            throw new FileStorageException(c_sD.m_Yu((Object)")Q\u0016^\fV\u0004\u001f\u0004Z\u0012V\u0016Z\u0004\u001f\u0010^\u0014W@L\u0010Z\u0003V\u0006V\u0005[N\u001f!K\u0014Z\rO\u0014\u001f\u0014P@^\u0003\\\u0005L\u0013\u001f\u000fJ\u0014L\t[\u0005\u001f\u0004Z\u0013V\u0007Q\u0001K\u0005[@[\tM\u0005\\\u0014P\u0012FN"));
        }
        a = path.resolve((String)object2).normalize();
        if (!a.startsWith(path)) {
            Object[] objectArray = new Object[--3];
            objectArray[3 & 4] = object2;
            objectArray[4 ^ 5] = path;
            objectArray[5 >> 1] = a3222.getName();
            f_nh.warn(ConnectionController.m_dT((Object)"\u0005^!WuK'^#Z'L4Su^!K0R%KuI<^uY<S0Q4R0\u0011uy<S0Q4R0\u001frD(\u0018uV;\u001f1V'Z6K:M,\u001frD(\u0018uM0L:S#Z&\u001f:J!L<[0\u001f3P'\u001f&O4\\0\u001frD(\u0018"), objectArray);
            throw new FileStorageException("Invalid file name results in path traversal: " + (String)object2);
        }
        if (!a.startsWith((Path)object)) {
            Object[] objectArray = new Object[--3];
            objectArray[3 & 4] = a;
            objectArray[3 & 5] = object;
            objectArray[1 ^ 3] = a3222.getName();
            f_nh.warn(c_sD.m_Yu((Object)"y\tQ\u0001S@L\u0005\\\u0015M\tK\u0019\u001f\u0003W\u0005\\\u000b\u001f\u0006^\tS\u0005[N\u001f4^\u0012X\u0005K@Y\tS\u0005\u001f\u0010^\u0014W@\u0018\u001bBG\u001f\tL@P\u0015K\u0013V\u0004Z@L\u0010^\u0003Z@M\u000fP\u0014\u001fGD\u001d\u0018@Y\u000fM@L\u0010^\u0003Z@\u0018\u001bBG"), objectArray);
            throw new FileStorageException(ConnectionController.m_dT((Object)"k4M2Z!\u001f3V9ZuO4K=\u001f'Z&P9I0LuP K&V1Zu[0L<X;^!Z1\u001f&O4\\0\u001f1V'Z6K:M,\u0011"));
        }
        String a3222 = object.relativize((Path)a).toString().replace(c_sD.m_Yu((Object)"<"), ConnectionController.m_dT((Object)"\u0010"));
        if (c_Jb2.f_Yh.existsByRelativePath(a3222)) {
            f_nh.info("A file already exists at path: " + a3222);
            return;
        }
        try {
            Files.createDirectories(path, new FileAttribute[0]);
            a22 = ((ZipFile)((Object)a22)).getInputStream(zipEntry);
            try {
                CopyOption[] copyOptionArray = new CopyOption[1];
                copyOptionArray[0] = StandardCopyOption.REPLACE_EXISTING;
                Files.copy(a22, (Path)a, copyOptionArray);
                f_nh.info(c_sD.m_Yu((Object)"y\tS\u0005\u001fGD\u001d\u0018@L\u0015\\\u0003Z\u0013L\u0006J\fS\u0019\u001f\u0017M\tK\u0014Z\u000e\u001f\u0014P@Y\tS\u0005L\u0019L\u0014Z\r\u001f\u0001K@\u0018\u001bBG"), object2, a);
                if (a22 == null) return;
            }
            catch (Throwable throwable) {
                Throwable throwable2;
                if (a22 != null) {
                    try {
                        a22.close();
                        throwable2 = throwable;
                        throw throwable2;
                    }
                    catch (Throwable a3222) {
                        throwable.addSuppressed(a3222);
                    }
                }
                throwable2 = throwable;
                throw throwable2;
            }
            a22.close();
            return;
        }
        catch (IOException a22) {
            throw new FileStorageException("Could not store file " + (String)object2 + ". Please try again!", (Throwable)a22);
        }
    }

    @PreAuthorize(value="hasAuthority('VIEW_FILE')")
    public FileDownloadResult m_ho(String string) {
        Path path;
        block3: {
            c_Jb a;
            Object a2 = string;
            c_Jb c_Jb2 = a = this;
            a2 = c_Jb2.m_RO((String)a2);
            String[] stringArray = new String[3 & 5];
            stringArray[3 >> 2] = a2.getSpace().getName();
            path = Path.of(c_Jb2.f_Hi, stringArray).resolve(a2.getRelativePath()).normalize();
            try {
                UrlResource urlResource = new UrlResource(path.toUri());
                if (!urlResource.exists() || !urlResource.isReadable()) break block3;
                return new FileDownloadResult((Resource)urlResource, (FileInfo)a2);
            }
            catch (MalformedURLException malformedURLException) {
                throw new NotFoundException(ConnectionController.m_dT((Object)"y<S0\u001f;P!\u001f3P Q1\u001f}R4S3P'R0[uj\u0007s|\u0011"));
            }
        }
        f_nh.error(ConnectionController.m_dT((Object)"\u0013V9ZuR0K4[4K4\u001f0G<L!LuY:Mu\u0018.Br\u001f7J!\u001f3V9ZuV&\u001f8V&L<Q2\u001f:Qu[<L>\u0011"), (Object)path);
        throw new NotFoundException(c_sD.m_Yu((Object)"y\tS\u0005\u001f\u000eP\u0014\u001f\u0006P\u0015Q\u0004"));
    }

    private static /* synthetic */ NotFoundException m_Um(String a) {
        return new NotFoundException("File info not found with relative path: " + a);
    }

    /*
     * WARNING - void declaration
     */
    @Transactional
    @PreAuthorize(value="hasAuthority('DELETE_FILE') and hasAuthority('UPDATE_LOGIN_SETTINGS')")
    public void m_rM(String string) {
        void a;
        c_Jb c_Jb2 = this;
        if (!StringUtils.hasText((String)a)) {
            f_nh.warn(ConnectionController.m_dT((Object)"1Z9Z!Z\u0019P2V;v8^2Zu\\4S9Z1\u001f\"V!WuZ8O!FuP'\u001f;J9SuY<S0Q4R0\u0011"));
            return;
        }
        try {
            Object a2 = StringUtils.cleanPath((String)a);
            if (a2.contains(c_sD.m_Yu((Object)"\u0011N"))) {
                throw new FileStorageException(ConnectionController.m_dT((Object)"y<S0Q4R0\u001f6P;K4V;LuV;I4S<[uO4K=\u001f&Z$J0Q6Zu\u0018{\u0011r\u0011"));
            }
            Path path = Path.of(c_Jb2.f_Hi, new String[3 >> 2]).toAbsolutePath().normalize().resolve(f_AG).normalize();
            Path path2 = path.resolve((String)a2).normalize();
            if (!path2.startsWith(path)) {
                f_nh.warn(c_sD.m_Yu((Object)"0^\u0014W@K\u0012^\u0016Z\u0012L\u0001S@^\u0014K\u0005R\u0010K@Y\u000fM@S\u000fX\tQ@V\r^\u0007Z@[\u0005S\u0005K\tP\u000e\u0005@D\u001d"), a2);
                throw new FileStorageException(ConnectionController.m_dT((Object)"\u001cQ#^9V1\u001f9P2V;\u001f<R4X0\u001f%^!WuY:Mu[0S0K<P;\u0011"));
            }
            Files.deleteIfExists(path2);
            f_nh.info(c_sD.m_Yu((Object)",P\u0007V\u000e\u001f\tR\u0001X\u0005\u001fGD\u001d\u0018@[\u0005S\u0005K\u0005[@Y\u0012P\r\u001f\u0006V\fZ\u0013F\u0013K\u0005R@\u0017\tY@V\u0014\u001f\u0005G\tL\u0014Z\u0004\u0016N"), a2);
            return;
        }
        catch (IOException a2) {
            f_nh.error(ConnectionController.m_dT((Object)"\u0010M'P'\u001f:\\6J'M0[uH=V9Zu[0S0K<Q2\u001f9P2V;\u001f<R4X0\u001f3V9Zo\u001f.B"), (Object)a, (Object)a2);
            return;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Transactional
    @PreAuthorize(value="hasAuthority('CREATE_FILE')")
    public FileInfo m_In(MultipartFile multipartFile, FileInfo fileInfo) {
        String string;
        c_Jb c_Jb2;
        String string2;
        void a22;
        c_Jb a = fileInfo;
        c_Jb a3 = this;
        void v0 = a22;
        Objects.requireNonNull(a, c_sD.m_Yu((Object)"&V\fZ)Q\u0006P@P\u0002U\u0005\\\u0014\u001f\u0003^\u000eQ\u000fK@]\u0005\u001f\u000eJ\fSN"));
        Objects.requireNonNull(v0, ConnectionController.m_dT((Object)"r S!V%^'K\u0013V9Zu\\4Q;P!\u001f7ZuQ S9\u0011"));
        if (v0.isEmpty()) {
            throw new FileStorageException(c_sD.m_Yu((Object)"#^\u000eQ\u000fK@L\u0014P\u0012Z@^\u000e\u001f\u0005R\u0010K\u0019\u001f\u0006V\fZN"));
        }
        String string3 = StringUtils.cleanPath((String)Objects.requireNonNull(a22.getOriginalFilename(), ConnectionController.m_dT((Object)"r S!V%^'K\u0013V9ZuP'V2V;^9\u001f3V9Z;^8Zu\\4Q;P!\u001f7ZuQ S9\u0011")));
        String string4 = string2 = StringUtils.hasText((String)a.getTargetSubdirectory()) ? StringUtils.cleanPath((String)a.getTargetSubdirectory()) : f_vI;
        if (string3.contains(c_sD.m_Yu((Object)"\u0011N")) || string2.contains(ConnectionController.m_dT((Object)"{\u0011"))) {
            throw new FileStorageException(c_sD.m_Yu((Object)"v\u000eI\u0001S\t[@Y\tS\u0005\u001f\u0010^\u0014W@L\u0010Z\u0003V\u0006V\u0005[N"));
        }
        Space space = Objects.requireNonNull(SpaceContext.getActiveSpace(), ConnectionController.m_dT((Object)"\u0014\\!V#ZuL%^6ZuV&\u001f'Z$J<M0[uK:\u001f O9P4[u^uY<S0\u0011"));
        String[] stringArray = new String[4 ^ 5];
        stringArray[5 >> 3] = space.getName();
        Path path = Path.of(a3.f_Hi, stringArray).toAbsolutePath().normalize();
        Path path2 = path.resolve(string2).normalize();
        if (!path2.startsWith(path)) {
            Object[] objectArray = new Object[--3];
            objectArray[5 >> 3] = string2;
            objectArray[3 >> 1] = path;
            objectArray[--2] = space.getName();
            f_nh.warn(c_sD.m_Yu((Object)"o\u0001K\b\u001f\u0014M\u0001I\u0005M\u0013^\f\u001f\u0001K\u0014Z\rO\u0014\u0011@j\u0010S\u000f^\u0004\u001f\u0014P@[\u0005M\tI\u0005[@[\tM\u0005\\\u0014P\u0012F@\u0018\u001bBG\u001f\u0012Z\u0013P\fI\u0005L@P\u0015K\u0013V\u0004Z@L\u0010^\u0003Z@M\u000fP\u0014\u001fGD\u001d\u0018@Y\u000fM@L\u0010^\u0003Z@\u0018\u001bBG"), objectArray);
            throw new FileStorageException(ConnectionController.m_dT((Object)"v;I4S<[u[<M0\\!P'FuO4K=\u001f&O0\\<Y<Z1\u0011"));
        }
        Path path3 = path2.resolve(string3).normalize();
        if (!path3.startsWith(path2)) {
            Object[] objectArray = new Object[--3];
            objectArray[3 >> 2] = string3;
            objectArray[3 >> 1] = path2;
            objectArray[--2] = space.getName();
            f_nh.warn(c_sD.m_Yu((Object)"o\u0001K\b\u001f\u0014M\u0001I\u0005M\u0013^\f\u001f\u0001K\u0014Z\rO\u0014\u001f\u0016V\u0001\u001f\u0006V\fZ\u000e^\rZN\u001f&V\fZ\u000e^\rZ@\u0018\u001bBG\u001f\tQ@[\tM\u0005\\\u0014P\u0012F@\u0018\u001bBG\u001f\u0012Z\u0013P\fI\u0005L@P\u0015K\u0013V\u0004Z@Y\u000fM@L\u0010^\u0003Z@\u0018\u001bBG"), objectArray);
            throw new FileStorageException(ConnectionController.m_dT((Object)"v;I4S<[uY<S0Q4R0\u001f&O0\\<Y<Z1\u0011"));
        }
        String string5 = path.relativize(path3).toString().replace(c_sD.m_Yu((Object)"<"), ConnectionController.m_dT((Object)"\u0010"));
        if (a3.f_Yh.existsByRelativePath(string5)) {
            throw new FileStorageException(c_sD.m_Yu((Object)"~@Y\tS\u0005\u001f\u0017V\u0014W@K\bV\u0013\u001f\u000e^\rZ@^\fM\u0005^\u0004F@Z\u0018V\u0013K\u0013\u001f\tQ@K\bZ@K\u0001M\u0007Z\u0014\u001f\fP\u0003^\u0014V\u000fQN"));
        }
        try {
            Files.createDirectories(path2, new FileAttribute[3 ^ 3]);
            CopyOption[] copyOptionArray = new CopyOption[4 ^ 5];
            copyOptionArray[5 >> 3] = StandardCopyOption.REPLACE_EXISTING;
            Files.copy(a22.getInputStream(), path3, copyOptionArray);
            f_nh.info(ConnectionController.m_dT((Object)"\u0013V9Zu\u0018.Br\u001f&J6\\0L&Y S9FuH'V!K0QuK:\u001f3V9Z&F&K0Ru^!\u001frD(\u0018"), (Object)string3, (Object)path3);
            c_Jb c_Jb3 = a;
            a.setFileName(string3);
            c_Jb3.setRelativePath(string5);
            c_Jb3.setFileSize(Long.valueOf(a22.getSize()));
            c_Jb2 = a;
            string = StringUtils.hasText((String)a22.getContentType()) ? a22.getContentType() : c_sD.m_Yu((Object)"^\u0010O\fV\u0003^\u0014V\u000fQOP\u0003K\u0005KML\u0014M\u0005^\r");
        }
        catch (IOException a22) {
            f_nh.error(ConnectionController.m_dT((Object)"\u0016P S1\u001f;P!\u001f&K:M0\u001f3V9Zu\u0018.Br\u001f1J0\u001f!Puv\u001az-\\0O!V:Q"), (Object)string3, (Object)a22);
            throw new FileStorageException(c_sD.m_Yu((Object)"|\u000fJ\f[@Q\u000fK@L\u0014P\u0012Z@K\bZ@J\u0010S\u000f^\u0004Z\u0004\u001f\u0006V\fZN\u001f0S\u0005^\u0013Z@K\u0012F@^\u0007^\tQN"));
        }
        {
            c_Jb2.setFileType(string);
            a.setTargetSubdirectory(string2);
            return (FileInfo)a3.f_Yh.save((Object)a);
        }
    }

    @PreAuthorize(value="hasAuthority('VIEW_FILE')")
    public List<FileInfo> m_go() {
        c_Jb a;
        return a.f_Yh.findAll();
    }

    @PreAuthorize(value="hasAuthority('VIEW_FILE')")
    public FileInfo m_GN(String string) {
        Object a = string;
        c_Jb a2 = this;
        return a2.f_Yh.findById(a).orElse(null);
    }

    @PreAuthorize(value="hasAuthority('VIEW_FILE')")
    public FileInfo m_Am(String string) {
        Object a = string;
        c_Jb a2 = this;
        return (FileInfo)a2.m_wo((String)a).orElseThrow(() -> c_Jb.m_kO((String)a));
    }
}

