/*
 * Decompiled with CFR 0.152.
 */
package com.inscada.mono.datatransfer.services;

import com.inscada.mono.auth.c_Lk;
import com.inscada.mono.cluster.exceptions.ClusterRpcException;
import com.inscada.mono.cluster.services.ClusterNodeListener;
import com.inscada.mono.cluster.services.c_F;
import com.inscada.mono.communication.base.b.c_CK;
import com.inscada.mono.communication.base.b.c_yl;
import com.inscada.mono.communication.base.model.DeviceView;
import com.inscada.mono.communication.base.model.Variable;
import com.inscada.mono.communication.base.model.values.NumberVariableValue;
import com.inscada.mono.communication.base.model.values.VariableValue;
import com.inscada.mono.communication.base.model.values.logged.LoggedVariableValueStats;
import com.inscada.mono.communication.base.restcontrollers.ConnectionController;
import com.inscada.mono.communication.base.services.c_Yg;
import com.inscada.mono.communication.base.services.c_mH;
import com.inscada.mono.communication.base.services.c_ti;
import com.inscada.mono.datatransfer.b.c_NB;
import com.inscada.mono.datatransfer.g.c_GC;
import com.inscada.mono.datatransfer.g.c_ib;
import com.inscada.mono.datatransfer.model.DataTransfer;
import com.inscada.mono.datatransfer.model.DataTransferDetail;
import com.inscada.mono.datatransfer.model.DataTransferSummary;
import com.inscada.mono.datatransfer.services.c_uc;
import com.inscada.mono.datatransfer.services.c_yc;
import com.inscada.mono.job.b.c_PB;
import com.inscada.mono.job.model.Job;
import com.inscada.mono.job.model.PeriodicJob;
import com.inscada.mono.log.g.c_lb;
import com.inscada.mono.project.g.c_l;
import com.inscada.mono.shared.exceptions.NotActiveException;
import com.inscada.mono.shared.model.BaseModel;
import com.inscada.mono.shared.model.OwnedSpaceBaseModel;
import jakarta.annotation.PostConstruct;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Component;
import org.springframework.transaction.event.TransactionalEventListener;
import redis.clients.jedis.JedisPooled;

@Component
public class DataTransferManager
implements ClusterNodeListener,
c_l {
    public static final short f_BH = 407;
    private final Map<String, Job> f_KI;
    private final c_yc f_vi;
    private final JedisPooled f_mG;
    private final c_ti f_BG;
    public static final short f_oh = 405;
    public static final short f_vg = 401;
    public static final short f_eh = 404;
    public static final short f_Ph = 406;
    public static final short f_hh = 403;
    public static final short f_th = 402;
    private final c_Lk f_Ah;
    private final c_F f_Tg;
    private final c_PB f_hI;
    private static final String f_kI = "scheduledDataTransfers";
    private final c_mH f_pI;
    private static final Logger f_Si = LoggerFactory.getLogger(DataTransferManager.class);
    private final Lock f_xh;
    private final c_Yg f_lh;
    private final c_lb f_Wh;

    protected void scheduleDataTransferInternal(DataTransfer dataTransfer) {
        DataTransferManager a = dataTransfer;
        DataTransferManager a2 = this;
        a2.f_Ah.m_Dga(() -> a2.lambda$scheduleDataTransferInternal$5((DataTransfer)a), (OwnedSpaceBaseModel)a);
    }

    protected void cancelDataTransferInternal(DataTransfer dataTransfer) {
        DataTransferManager a = dataTransfer;
        DataTransferManager a2 = this;
        a2.f_Ah.m_Dga(() -> a2.lambda$cancelDataTransferInternal$6((DataTransfer)a), (OwnedSpaceBaseModel)a);
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void lambda$handleCurrentValues$10(Map map, Map map2, Map map3, Map map4, DataTransferDetail dataTransferDetail) {
        Variable a;
        void a2;
        VariableValue a3;
        Object a4 = map2;
        DataTransferManager a5 = this;
        a3 = (VariableValue)a3.get(a2.getSourceVariableId());
        a4 = (VariableValue)a4.get(a2.getTargetVariableId());
        a = (Variable)a.get(a2.getTargetVariableId());
        if (a3 != null && a != null && a5.isValueInThresholdRange(a2.getThreshold(), a3, (VariableValue)a4)) {
            void a6;
            a4 = new HashMap<String, Object>();
            a4.put(DeviceView.m_MAa((Object)"q\rk\u0019b"), a3.getValue());
            a6.put(a.getName(), a4);
        }
    }

    protected Map<String, c_NB> getDataTransferStatusesByIdsInternal(List<String> list) {
        List<String> a = list;
        DataTransferManager a2 = this;
        if (a == null || a.isEmpty()) {
            return Collections.emptyMap();
        }
        return a.stream().collect(Collectors.toMap(Function.identity(), arg_0 -> a2.getDataTransferStatusInternal(arg_0)));
    }

    protected void cancelDataTransfersByProjectIdInternal(String string) {
        Object a = string;
        DataTransferManager a2 = this;
        if ((a = a2.f_vi.m_cn((String)a)) == null || a.isEmpty()) {
            return;
        }
        a.forEach(arg_0 -> a2.cancelDataTransferInternal(arg_0));
    }

    private /* synthetic */ String buildStatCacheKey(DataTransferDetail dataTransferDetail) {
        DataTransferManager a = dataTransferDetail;
        DataTransferManager a2 = this;
        Object[] objectArray = new Object[--3];
        objectArray[3 >> 2] = a.getSourceVariableId();
        objectArray[4 ^ 5] = a.getRangeType();
        objectArray[1 ^ 3] = a.getCalcType();
        return DeviceView.m_MAa((Object)"c\rs\r*\u0018u\ri\u001fa\tuVt\u0018f\u0018tVq\ru\u0005f\u000ek\t=ItV\"\u001f=It").formatted(objectArray);
    }

    protected c_NB getDataTransferStatusInternal(String string) {
        Object a = string;
        DataTransferManager a2 = this;
        if (a2.f_KI.containsKey(a)) {
            return c_NB.f_Sg;
        }
        return c_NB.f_XH;
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void updateVariableWithCachedValue(String string, DataTransferDetail dataTransferDetail, Map<String, Variable<?, ?, ?>> map, Map<String, Map<String, Object>> map2, Map<String, VariableValue<?>> map3) {
        void a;
        Variable a2;
        Object a3 = string;
        DataTransferManager a4 = this;
        if ((a2 = (Variable)a2.get(a.getTargetVariableId())) != null) {
            void a5;
            double d = Double.parseDouble((String)a3);
            a3 = (VariableValue)a5.get(a.getTargetVariableId());
            if (a4.isValueInThresholdRange(a.getThreshold(), Double.valueOf(d), (VariableValue)a3)) {
                void a6;
                a3 = new HashMap<String, Double>();
                a3.put(ConnectionController.m_dT((Object)"I4S Z"), d);
                a6.put(a2.getName(), a3);
            }
        }
    }

    protected void scheduleDataTransferInternal(String string) {
        DataTransferManager a;
        Object a2 = string;
        DataTransferManager dataTransferManager = a = this;
        dataTransferManager.scheduleDataTransferInternal(dataTransferManager.f_vi.m_oN((String)a2));
    }

    @PreAuthorize(value="hasAuthority('SCHEDULE_DATA_TRANSFER')")
    public void scheduleDataTransfers(String string) {
        Object a = string;
        DataTransferManager a2 = this;
        if (a2.f_Tg.m_O()) {
            f_Si.debug(DeviceView.m_MAa((Object)"K)F(B>=LT\u000fo\tc\u0019k\u0005i\u000b'\rk\u0000'\bf\u0018fLs\u001ef\u0002t\nb\u001etLa\u0003uLw\u001eh\u0006b\u000fsL|\u0011'\u0000h\u000ff\u0000k\u0015)"), a);
            a2.scheduleDataTransfersByProjectIdInternal((String)a);
            return;
        }
        f_Si.debug(ConnectionController.m_dT((Object)"\u001bp\u001b\u0012\u0019z\u0014{\u0010mo\u001f\u0007Z$J0L!V;XuS0^1Z'\u001f!PuL6W0[ S0\u001f4S9\u001f1^!^uK'^;L3Z'LuY:MuO'P?Z6KuD(\u0011"), a);
        try {
            Object[] objectArray = new Object[5 >> 2];
            objectArray[3 >> 2] = a;
            a2.f_Tg.m_ka(Short.valueOf((short)(0x4BDE & 0x35B5)), objectArray);
            return;
        }
        catch (Exception exception) {
            throw new ClusterRpcException("Failed to RPC schedule data transfers for project " + (String)a, (Throwable)exception);
        }
    }

    private /* synthetic */ void lambda$cancelDataTransferInternal$6(DataTransfer dataTransfer) {
        DataTransferManager a = dataTransfer;
        DataTransferManager a2 = this;
        a2.f_xh.lock();
        try {
            Job job = (Job)a2.f_KI.get(a.getId());
            if (job != null) {
                a2.f_hI.m_eL(job);
            }
            DataTransferManager dataTransferManager = a2;
            dataTransferManager.f_KI.remove(a.getId());
            String[] stringArray = new String[--1];
            stringArray[5 >> 3] = a.getId();
            dataTransferManager.f_mG.srem(f_kI, stringArray);
            return;
        }
        finally {
            a2.f_xh.unlock();
        }
    }

    @PreAuthorize(value="hasAuthority('VIEW_DATA_TRANSFER')")
    public c_NB getDataTransferStatus(String string) {
        Object a = string;
        DataTransferManager a2 = this;
        if (a2.f_Tg.m_O()) {
            f_Si.debug(ConnectionController.m_dT((Object)"\u0019z\u0014{\u0010mo\u001f\u0012Z!K<Q2\u001f1^!^uK'^;L3Z'\u001f&K4K LuY:Muv\u0011\u0005uD(\u001f9P6^9S,\u0011"), a);
            return a2.getDataTransferStatusInternal((String)a);
        }
        f_Si.debug(DeviceView.m_MAa((Object)"\"H\"* B-C)UV'>b\u001dr\tt\u0018n\u0002`Lk\tf\bb\u001e'\nh\u001e'\bf\u0018fLs\u001ef\u0002t\nb\u001e'\u001fs\rs\u0019tLa\u0003uLN(=L|\u0011)"), a);
        try {
            Object[] objectArray = new Object[2 ^ 3];
            objectArray[3 ^ 3] = a;
            return (c_NB)a2.f_Tg.m_ka(Short.valueOf((short)(0x4BF7 & 0x359B)), objectArray);
        }
        catch (Exception exception) {
            throw new ClusterRpcException("Failed to RPC get data transfer status for " + (String)a, (Throwable)exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void leader() {
        DataTransferManager dataTransferManager;
        DataTransferManager dataTransferManager2 = dataTransferManager = this;
        Object a = dataTransferManager2.f_Tg.m_o();
        f_Si.info(ConnectionController.m_dT((Object)"\u0011^!^\u0001M4Q&Y0M\u0018^;^2Z'\u0005uk=V&\u001f;P1Zu\u0017.B|\u001f=^&\u001f7Z6P8ZuK=Zus\u0010~\u0011z\u0007\u0011um0L!P'V;XuL6W0[ S0[u[4K4\u001f!M4Q&Y0M&\u0011{\u0011"), a);
        dataTransferManager2.f_xh.lock();
        try {
            HashSet hashSet = new HashSet(dataTransferManager.f_mG.smembers(f_kI));
            if (hashSet.isEmpty()) {
                f_Si.info(DeviceView.m_MAa((Object)"C\rs\rS\u001ef\u0002t\nb\u001eJ\ri\r`\tuL/ b\rc\tuL|\u0011.V'\"hLt\u000fo\tc\u0019k\tcLc\rs\r'\u0018u\ri\u001fa\tu\u001f'\nh\u0019i\b'\u0005iLU\tc\u0005tLs\u0003'\u001eb\u001fs\u0003u\t)"), a);
                return;
            }
            Object[] objectArray = new Object[--3];
            objectArray[5 >> 3] = a;
            objectArray[3 & 5] = hashSet.size();
            objectArray[--2] = hashSet;
            f_Si.info(ConnectionController.m_dT((Object)"{4K4k'^;L3Z'r4Q4X0Mu\u0017\u0019Z4[0MuD(\u0016o\u001f\u0013P Q1\u001f.BuL6W0[ S0[u[4K4\u001f!M4Q&Y0Muv\u0011LuV;\u001f\u0007Z1V&\u001f!PuM0L!P'Zo\u001f.B"), objectArray);
            ArrayList arrayList = new ArrayList();
            String[] stringArray = new String[2 ^ 3];
            stringArray[2 & 5] = DeviceView.m_MAa((Object)":N)P3C-S-X8U-I?A)U");
            dataTransferManager.f_Ah.m_XDa(() -> {
                void a;
                Object a2 = hashSet;
                DataTransferManager a3 = this;
                a.addAll(a3.f_vi.m_Zn((Set)a2));
            }, stringArray);
            f_Si.info(ConnectionController.m_dT((Object)"{4K4k'^;L3Z'r4Q4X0Mu\u0017\u0019Z4[0MuD(\u0016o\u001f\u0014K!Z8O!V;XuK:\u001f'Z&K:M0\u001f.Bu[4K4\u001f!M4Q&Y0M&\u0011"), a, (Object)arrayList.size());
            arrayList.forEach(dataTransfer -> {
                void a;
                DataTransferManager dataTransferManager;
                DataTransferManager dataTransferManager2 = dataTransferManager = this;
                Object a2 = dataTransferManager2.f_Tg.m_o();
                String[] stringArray = new String[--2];
                stringArray[2 & 5] = DeviceView.m_MAa((Object)"?D$B(R B3C-S-X8U-I?A)U");
                stringArray[5 >> 2] = ConnectionController.m_dT((Object)"\u0016~\u001b|\u0010s\n{\u0014k\u0014`\u0001m\u0014q\u0006y\u0010m");
                dataTransferManager2.f_Ah.m_jEa(() -> dataTransferManager.lambda$restoreSingleDataTransferOnLeader$1((String)a2, (DataTransfer)a), a.getSpace(), stringArray);
            });
            f_Si.info(DeviceView.m_MAa((Object)"(f\u0018f8u\ri\u001fa\tu!f\u0002f\u000bb\u001e'DK\tf\bb\u001e'\u0017zE=LA\u0005i\u0005t\u0004b\b'\bf\u0018fLs\u001ef\u0002t\nb\u001e'\u001eb\u001fs\u0003u\rs\u0005h\u0002'\u001cu\u0003d\tt\u001f)"), a);
            return;
        }
        catch (Exception exception) {
            Object[] objectArray = new Object[--3];
            objectArray[3 & 4] = a;
            objectArray[3 >> 1] = exception.getMessage();
            objectArray[1 ^ 3] = exception;
            f_Si.error(ConnectionController.m_dT((Object)"{4K4k'^;L3Z'r4Q4X0Mu\u0017\u0019Z4[0MuD(\u0016o\u001f\u0010M'P'\u001f1J'V;Xu[4K4\u001f!M4Q&Y0MuM0L!P'^!V:QuO'P6Z&Lo\u001f.B"), objectArray);
            return;
        }
        finally {
            dataTransferManager.f_xh.unlock();
        }
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void lambda$handleStatValues$16(Map map, Map map2, Map map3, Map map4, DataTransferDetail dataTransferDetail) {
        Variable a;
        DataTransferManager a2;
        Object a3;
        DataTransferManager dataTransferManager = dataTransferManager2;
        DataTransferManager dataTransferManager2 = dataTransferDetail;
        DataTransferManager a4 = dataTransferManager;
        if ((a3 = (LoggedVariableValueStats)a3.get(a2.getSourceVariableId())) != null && (a = (Variable)a.get(a2.getTargetVariableId())) != null) {
            String a5;
            double d = a4.extractValue(a3, a2.getCalcType());
            a3 = (VariableValue)a5.get(a2.getTargetVariableId());
            DataTransferManager dataTransferManager3 = a4;
            a5 = dataTransferManager3.buildStatCacheKey((DataTransferDetail)a2);
            String string = dataTransferManager3.buildStatLastCalcTimeKey((DataTransferDetail)a2);
            int n = dataTransferManager3.getMaxTTLForRangeType(a2.getRangeType());
            dataTransferManager3.f_mG.setex(a5, (long)n, String.valueOf(d));
            a4.f_mG.setex(string, (long)n, String.valueOf(System.currentTimeMillis()));
            if (dataTransferManager3.isValueInThresholdRange(a2.getThreshold(), Double.valueOf(d), (VariableValue)a3)) {
                void a6;
                a3 = new HashMap<String, Double>();
                a3.put(ConnectionController.m_dT((Object)"I4S Z"), d);
                a6.put(a.getName(), a3);
            }
        }
    }

    public void deactivateForProject(String string) {
        Object a = string;
        DataTransferManager a2 = this;
        if (a2.f_Tg.m_O()) {
            f_Si.info(DeviceView.m_MAa((Object)" B-C)UV'$f\u0002c\u0000n\u0002`LW\u001eh\u0006b\u000fs(b\rd\u0018n\u001af\u0018b)q\ti\u0018'\nh\u001e'\u001cu\u0003m\td\u0018'%CV'\u0017z"), a);
            a2.cancelDataTransfersByProjectIdInternal((String)a);
            return;
        }
        f_Si.debug(ConnectionController.m_dT((Object)"\u001bp\u001b\u0012\u0019z\u0014{\u0010mo\u001f\u001cX;P'V;Xuo'P?Z6K\u0011Z4\\!V#^!Z\u0010I0Q!\u001f3P'\u001f%M:U0\\!\u001f\u001c{o\u001f.B"), a);
    }

    @PreAuthorize(value="hasAuthority('CANCEL_DATA_TRANSFER')")
    public void cancelDataTransfer(String string) {
        Object a = string;
        DataTransferManager a2 = this;
        if (a2.f_Tg.m_O()) {
            f_Si.debug(DeviceView.m_MAa((Object)" B-C)UV'/f\u0002d\tk\u0000n\u0002`Lc\rs\r'\u0018u\ri\u001fa\tuL|\u0011'\u0000h\u000ff\u0000k\u0015)"), a);
            a2.cancelDataTransferInternal((String)a);
            return;
        }
        f_Si.debug(ConnectionController.m_dT((Object)"q\u001aqxs\u0010~\u0011z\u0007\u0005um0N Z&K<Q2\u001f9Z4[0MuK:\u001f6^;\\0Su[4K4\u001f!M4Q&Y0MuD(\u0011"), a);
        try {
            Object[] objectArray = new Object[--1];
            objectArray[3 >> 2] = a;
            a2.f_Tg.m_ka(Short.valueOf((short)(0x79DF & 0x7B2)), objectArray);
            return;
        }
        catch (Exception exception) {
            throw new ClusterRpcException("Failed to RPC cancel data transfer " + (String)a, (Throwable)exception);
        }
    }

    @PostConstruct
    private /* synthetic */ void initializeClusterIntegration() {
        DataTransferManager a;
        DataTransferManager dataTransferManager = a;
        dataTransferManager.registerRemoteCallsWithClusterNode();
        dataTransferManager.f_Tg.m_Da((ClusterNodeListener)a);
        f_Si.info(DeviceView.m_MAa((Object)"(f\u0018f8u\ri\u001fa\tu!f\u0002f\u000bb\u001e'\u0005i\u0005s\u0005f\u0000n\u0016b\b'\ri\b'\u001eb\u000bn\u001fs\tu\tcLf\u001f'/k\u0019t\u0018b\u001eI\u0003c\tK\u0005t\u0018b\u0002b\u001e)"));
    }

    protected void cancelDataTransferInternal(String string) {
        DataTransferManager a;
        Object a2 = string;
        DataTransferManager dataTransferManager = a = this;
        dataTransferManager.cancelDataTransferInternal(dataTransferManager.f_vi.m_Ym((String)a2));
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void handleStatValues(List<DataTransferDetail> list, Map<String, Map<String, Object>> map) {
        void a;
        void a2;
        DataTransferManager dataTransferManager = this;
        Object a3 = a2.stream().map(DataTransferDetail::getTargetVariableId).collect(Collectors.toList());
        Map map2 = dataTransferManager.f_pI.m_FCa((List)a3).stream().collect(Collectors.toMap(BaseModel::getId, Function.identity()));
        a3 = dataTransferManager.f_BG.m_uaa((String[])a3.toArray(String[]::new));
        Date date = new Date();
        a2.stream().filter(arg_0 -> dataTransferManager.lambda$handleStatValues$12(date, map2, (Map)a, (Map)a3, arg_0)).collect(Collectors.groupingBy(dataTransferDetail -> {
            void a;
            DataTransferManager a2 = dataTransferDetail;
            DataTransferManager a3 = this;
            return (Date)a3.calculateDateRange((Date)a, a2.getRangeType()).getLeft();
        })).forEach((arg_0, arg_1) -> dataTransferManager.lambda$handleStatValues$17(date, map2, (Map)a3, (Map)a, arg_0, arg_1));
    }

    @PreAuthorize(value="hasAuthority('VIEW_DATA_TRANSFER')")
    public Map<String, c_NB> getDataTransferStatuses(List<String> list) {
        List<String> a = list;
        DataTransferManager a2 = this;
        if (a == null || a.isEmpty()) {
            return Collections.emptyMap();
        }
        if (a2.f_Tg.m_O()) {
            f_Si.debug(ConnectionController.m_dT((Object)"s\u0010~\u0011z\u0007\u0005ux0K!V;Xu[4K4\u001f!M4Q&Y0MuL!^!J&Z&\u001f3P'\u001f.Buv\u0011LuS:\\4S9Fo\u001f.B"), (Object)a.size(), (Object)a);
            return a2.getDataTransferStatusesByIdsInternal((List)a);
        }
        f_Si.debug(DeviceView.m_MAa((Object)"I#IAK)F(B>=LU\tv\u0019b\u001fs\u0005i\u000b'\u0000b\rc\tuLa\u0003uLc\rs\r'\u0018u\ri\u001fa\tuLt\u0018f\u0018r\u001fb\u001f'\nh\u001e'\u0017zLN(tV'\u0017z"), (Object)a.size(), (Object)a);
        try {
            Object[] objectArray = new Object[--1];
            objectArray[3 ^ 3] = new ArrayList(a);
            return (Map)a2.f_Tg.m_ka(Short.valueOf((short)(0x11DE & 0x6FB7)), objectArray);
        }
        catch (Exception exception) {
            throw new ClusterRpcException("Failed to RPC get data transfer statuses for IDs " + a.stream().map(String::valueOf).collect(Collectors.joining(ConnectionController.m_dT((Object)"\u0013"))), (Throwable)exception);
        }
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ boolean isValueInThresholdRange(Double d, Double d2, VariableValue<?> variableValue) {
        void a;
        void a2;
        VariableValue<?> a3 = variableValue;
        VariableValue<?> a4 = this;
        return a4.isValueInThresholdRange((Double)a2, (VariableValue)new NumberVariableValue((Number)a, new Date()), a3);
    }

    /*
     * Enabled aggressive block sorting
     */
    private /* synthetic */ int getMaxTTLForRangeType(c_CK c_CK2) {
        DataTransferManager a = c_CK2;
        DataTransferManager a2 = this;
        switch (c_uc.f_mh[a.ordinal()]) {
            case 1: 
            case 2: {
                return 3600;
            }
            case 3: 
            case 4: {
                return 86400;
            }
            case 5: 
            case 6: {
                return 604800;
            }
            case 7: 
            case 8: {
                return 2678400;
            }
            case 9: 
            case 10: {
                return 31622400;
            }
        }
        throw new IllegalArgumentException("Unexpected range type: " + String.valueOf(a));
    }

    private /* synthetic */ String buildStatLastCalcTimeKey(DataTransferDetail dataTransferDetail) {
        DataTransferManager a = dataTransferDetail;
        DataTransferManager a2 = this;
        Object[] objectArray = new Object[--3];
        objectArray[5 >> 3] = a.getSourceVariableId();
        objectArray[3 & 5] = a.getRangeType();
        objectArray[--2] = a.getCalcType();
        return ConnectionController.m_dT((Object)"1^!^xK'^;L3Z'\u00059^&Kx\\4S6\u0012!V8ZoI4M<^7S0\u0005pLo\u001a&\u0005pL").formatted(objectArray);
    }

    /*
     * WARNING - void declaration
     */
    @PreAuthorize(value="hasAuthority('SCHEDULE_DATA_TRANSFER')")
    public void scheduleDataTransfer(String string, String string2) {
        void a;
        DataTransferManager a2;
        Object a3 = string2;
        DataTransferManager dataTransferManager = a2 = this;
        dataTransferManager.scheduleDataTransfer(dataTransferManager.f_vi.m_XN((String)a, (String)a3).getId());
    }

    /*
     * WARNING - void declaration
     */
    public DataTransferManager(c_yc c_yc2, c_mH c_mH2, c_ti c_ti2, c_Yg c_Yg2, c_PB c_PB2, JedisPooled jedisPooled, c_lb c_lb2, c_F c_F2, c_Lk c_Lk2) {
        DataTransferManager a;
        void a2;
        void a3;
        void a4;
        void a5;
        void a6;
        void a7;
        void a8;
        void a9;
        DataTransferManager a10;
        DataTransferManager dataTransferManager = dataTransferManager2;
        DataTransferManager dataTransferManager2 = c_Lk2;
        DataTransferManager dataTransferManager3 = a10 = dataTransferManager;
        DataTransferManager dataTransferManager4 = a10;
        DataTransferManager dataTransferManager5 = a10;
        DataTransferManager dataTransferManager6 = a10;
        DataTransferManager dataTransferManager7 = a10;
        DataTransferManager dataTransferManager8 = a10;
        dataTransferManager7.f_xh = new ReentrantLock();
        dataTransferManager7.f_KI = new ConcurrentHashMap();
        dataTransferManager7.f_vi = a9;
        dataTransferManager6.f_pI = a8;
        dataTransferManager6.f_BG = a7;
        dataTransferManager5.f_lh = a6;
        dataTransferManager5.f_hI = a5;
        dataTransferManager4.f_Wh = a4;
        dataTransferManager4.f_mG = a3;
        dataTransferManager3.f_Tg = a2;
        dataTransferManager3.f_Ah = a;
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void lambda$notLeader$2(String string, String string2) {
        void a;
        DataTransferManager dataTransferManager = this;
        DataTransferManager a22 = (Job)dataTransferManager.f_KI.get(a);
        if (a22 != null) {
            void a3;
            try {
                f_Si.info(DeviceView.m_MAa((Object)"(f\u0018f8u\ri\u001fa\tu!f\u0002f\u000bb\u001e'DI\u0003sLK\tf\bb\u001e'\u0017zE=LD\ri\u000fb\u0000k\u0005i\u000b'\u0000h\u000ff\u0000'\u0006h\u000e'\nh\u001e'\bf\u0018fLs\u001ef\u0002t\nb\u001e'%CV'\u0017z"), (Object)a3, (Object)a);
                dataTransferManager.f_hI.m_eL((Job)a22);
                return;
            }
            catch (Exception a22) {
                Object[] objectArray = new Object[--4];
                objectArray[3 ^ 3] = a3;
                objectArray[3 >> 1] = a;
                objectArray[5 >> 1] = a22.getMessage();
                objectArray[--3] = a22;
                f_Si.error(ConnectionController.m_dT((Object)"{4K4k'^;L3Z'r4Q4X0Mu\u0017\u001bP!\u001f\u0019Z4[0MuD(\u0016o\u001f\u0010M'P'\u001f6^;\\0S9V;XuS:\\4SuU:]uY:Mu[4K4\u001f!M4Q&Y0Muv\u0011\u001f.Bo\u001f.B"), objectArray);
            }
        }
    }

    @PreAuthorize(value="hasAuthority('CANCEL_DATA_TRANSFER')")
    public void cancelDataTransfers(String string) {
        Object a = string;
        DataTransferManager a2 = this;
        if (a2.f_Tg.m_O()) {
            f_Si.debug(DeviceView.m_MAa((Object)"K)F(B>=LD\ri\u000fb\u0000k\u0005i\u000b'\rk\u0000'\bf\u0018fLs\u001ef\u0002t\nb\u001etLa\u0003uLw\u001eh\u0006b\u000fsL|\u0011'\u0000h\u000ff\u0000k\u0015)"), a);
            a2.cancelDataTransfersByProjectIdInternal((String)a);
            return;
        }
        f_Si.debug(ConnectionController.m_dT((Object)"\u001bp\u001b\u0012\u0019z\u0014{\u0010mo\u001f\u0007Z$J0L!V;XuS0^1Z'\u001f!Pu\\4Q6Z9\u001f4S9\u001f1^!^uK'^;L3Z'LuY:MuO'P?Z6KuD(\u0011"), a);
        try {
            Object[] objectArray = new Object[3 & 5];
            objectArray[3 ^ 3] = a;
            a2.f_Tg.m_ka(Short.valueOf((short)(0x37D7 & 0x49BD)), objectArray);
            return;
        }
        catch (Exception exception) {
            throw new ClusterRpcException("Failed to RPC cancel data transfers for project " + (String)a, (Throwable)exception);
        }
    }

    protected void scheduleDataTransfersByProjectIdInternal(String string) {
        Object a = string;
        DataTransferManager a2 = this;
        if ((a = a2.f_vi.m_Rm((String)a)) == null || a.isEmpty()) {
            return;
        }
        a.forEach(arg_0 -> a2.scheduleDataTransferInternal(arg_0));
    }

    @TransactionalEventListener(value={c_ib.class})
    public void handleRescheduleEvent(c_ib c_ib2) {
        DataTransferManager dataTransferManager = this;
        if (dataTransferManager.f_Tg.m_O()) {
            DataTransferManager a = a.m_GP();
            f_Si.info(DeviceView.m_MAa((Object)"K)F(B>=LO\ri\bk\u0005i\u000b'>b\u001fd\u0004b\br\u0000b)q\ti\u0018'\nh\u001e'\bf\u0018fLs\u001ef\u0002t\nb\u001e=L|\u0011'DN(=L|\u0011."), (Object)a.getName(), (Object)a.getId());
            if (dataTransferManager.getDataTransferStatusInternal(a.getId()) == c_NB.f_Sg) {
                dataTransferManager.scheduleDataTransferInternal(a.getId());
                return;
            }
        } else {
            f_Si.debug(ConnectionController.m_dT((Object)"\u001bp\u001b\u0012\u0019z\u0014{\u0010mo\u001f\u001cX;P'V;Xum0L6W0[ S0z#Z;KuY:Mu[4K4\u001f!M4Q&Y0Mo\u001f.B"), (Object)a.m_GP().getId());
        }
    }

    private /* synthetic */ void lambda$scheduleDataTransferInternal$5(DataTransfer dataTransfer) {
        DataTransferManager a = dataTransfer;
        DataTransferManager a2 = this;
        a2.f_xh.lock();
        try {
            a2.cancelDataTransferInternal((DataTransfer)a);
            if (!Boolean.TRUE.equals(a.getProject().getIsActive())) {
                throw new NotActiveException("Project should be active to schedule data transfer " + a.getName());
            }
            Object[] objectArray = new Object[--1];
            objectArray[3 & 4] = a.getName();
            PeriodicJob periodicJob = a2.f_hI.m_Lj(a.getProject(), ConnectionController.m_dT((Object)"pLu{4K4\u001f\u0001M4Q&Y0M").formatted(objectArray), () -> a2.lambda$scheduleDataTransferInternal$4((DataTransfer)a), Duration.ofMillis(a.getPeriod().intValue()));
            DataTransferManager dataTransferManager = a2;
            dataTransferManager.f_KI.put(a.getId(), periodicJob);
            String[] stringArray = new String[3 & 5];
            stringArray[2 & 5] = a.getId();
            dataTransferManager.f_mG.sadd(f_kI, stringArray);
            return;
        }
        finally {
            a2.f_xh.unlock();
        }
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void handleCurrentValues(List<DataTransferDetail> list, Map<String, Map<String, Object>> map) {
        void a;
        void a2;
        DataTransferManager dataTransferManager = this;
        Object object = (String[])a2.stream().map(DataTransferDetail::getSourceVariableId).toArray(String[]::new);
        Object a3 = a2.stream().map(DataTransferDetail::getTargetVariableId).collect(Collectors.toList());
        Map map2 = dataTransferManager.f_pI.m_FCa((List)a3).stream().collect(Collectors.toMap(BaseModel::getId, Function.identity()));
        DataTransferManager dataTransferManager2 = dataTransferManager;
        object = dataTransferManager2.f_BG.m_uaa(object);
        a3 = dataTransferManager2.f_BG.m_uaa((String[])a3.toArray(String[]::new));
        a2.forEach(arg_0 -> dataTransferManager.lambda$handleCurrentValues$10((Map)object, (Map)a3, map2, (Map)a, arg_0));
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    private /* synthetic */ double extractValue(LoggedVariableValueStats loggedVariableValueStats, c_yl c_yl2) {
        void a;
        DataTransferManager a2 = loggedVariableValueStats;
        DataTransferManager a3 = this;
        switch (c_uc.f_Di[a.ordinal()]) {
            case 1: {
                return a2.getMinValue();
            }
            case 2: {
                return a2.getMaxValue();
            }
            case 3: {
                return a2.getAvgValue();
            }
            case 4: {
                return a2.getSumValue();
            }
            case 5: {
                return a2.getCountValue();
            }
            case 6: {
                return a2.getFirstValue();
            }
            case 7: {
                return a2.getLastValue();
            }
            case 8: {
                return a2.getMaxDiffValue();
            }
            case 9: {
                return a2.getLastFirstDiffValue();
            }
            case 10: {
                return a2.getMiddleValue();
            }
            case 11: {
                return a2.getMedianValue();
            }
        }
        throw new IllegalArgumentException("Unexpected calculation type: " + String.valueOf(a));
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void transfer(DataTransfer dataTransfer) {
        void a;
        DataTransferManager dataTransferManager = this;
        if (a.getDataTransferDetails() == null || a.getDataTransferDetails().isEmpty()) {
            return;
        }
        ArrayList arrayList = new ArrayList();
        ArrayList arrayList2 = new ArrayList();
        a.getDataTransferDetails().forEach(dataTransferDetail -> {
            void a;
            List a2 = dataTransferDetail;
            List a3 = arrayList2;
            if (a2.getCalcType() != null && a2.getRangeType() != null) {
                a3.add(a2);
                return;
            }
            a.add(a2);
        });
        HashMap a2 = new HashMap();
        if (!arrayList.isEmpty()) {
            dataTransferManager.handleCurrentValues(arrayList, (Map)a2);
        }
        if (!arrayList2.isEmpty()) {
            dataTransferManager.handleStatValues(arrayList2, (Map)a2);
        }
        if (!a2.isEmpty()) {
            dataTransferManager.f_BG.m_oBa(a.getProjectId(), (Map)a2);
        }
    }

    /*
     * WARNING - void declaration
     */
    @TransactionalEventListener(value={c_GC.class})
    public void handleCancelEvent(c_GC c_GC2) {
        void a;
        DataTransferManager dataTransferManager = this;
        if (dataTransferManager.f_Tg.m_O()) {
            DataTransferManager a2 = a.m_Jq();
            f_Si.info(DeviceView.m_MAa((Object)"K)F(B>=LO\ri\bk\u0005i\u000b'/f\u0002d\tk)q\ti\u0018'\nh\u001e'\bf\u0018fLs\u001ef\u0002t\nb\u001e=L|\u0011'DN(=L|\u0011."), (Object)a2.getName(), (Object)a2.getId());
            dataTransferManager.cancelDataTransferInternal((DataTransfer)a2);
            return;
        }
        f_Si.debug(ConnectionController.m_dT((Object)"\u001bp\u001b\u0012\u0019z\u0014{\u0010mo\u001f\u001cX;P'V;Xu|4Q6Z9z#Z;KuY:Mu[4K4\u001f!M4Q&Y0Mo\u001f.B"), (Object)a.m_Jq().getId());
    }

    private /* synthetic */ void registerRemoteCallsWithClusterNode() {
        DataTransferManager dataTransferManager = this;
        try {
            Class[] classArray = new Class[--1];
            classArray[3 & 4] = String.class;
            dataTransferManager.f_Tg.m_q((short)(0x53B7 & 0x2DD9), (Object)dataTransferManager, DataTransferManager.class.getDeclaredMethod(ConnectionController.m_dT((Object)"&\\=Z1J9Z\u0011^!^\u0001M4Q&Y0M\u001cQ!Z'Q4S"), classArray));
            Class[] classArray2 = new Class[5 >> 2];
            classArray2[2 & 5] = String.class;
            dataTransferManager.f_Tg.m_q((short)(0x31FA & 0x4F97), (Object)dataTransferManager, DataTransferManager.class.getDeclaredMethod(DeviceView.m_MAa((Object)"\u000ff\u0002d\tk(f\u0018f8u\ri\u001fa\tu%i\u0018b\u001ei\rk"), classArray2));
            Class[] classArray3 = new Class[2 ^ 3];
            classArray3[2 & 5] = String.class;
            dataTransferManager.f_Tg.m_q((short)(0x57D3 & 0x29BF), (Object)dataTransferManager, DataTransferManager.class.getDeclaredMethod(ConnectionController.m_dT((Object)"X0K\u0011^!^\u0001M4Q&Y0M\u0006K4K L\u001cQ!Z'Q4S"), classArray3));
            Class[] classArray4 = new Class[2 ^ 3];
            classArray4[2 & 5] = String.class;
            dataTransferManager.f_Tg.m_q((short)(0x41B6 & 0x3FDD), (Object)dataTransferManager, DataTransferManager.class.getDeclaredMethod(DeviceView.m_MAa((Object)"\u001fd\u0004b\br\u0000b(f\u0018f8u\ri\u001fa\tu\u001fE\u0015W\u001eh\u0006b\u000fs%c%i\u0018b\u001ei\rk"), classArray4));
            Class[] classArray5 = new Class[3 & 5];
            classArray5[3 & 4] = String.class;
            dataTransferManager.f_Tg.m_q((short)(0x3797 & 0x49FD), (Object)dataTransferManager, DataTransferManager.class.getDeclaredMethod(ConnectionController.m_dT((Object)"6^;\\0S\u0011^!^\u0001M4Q&Y0M&},o'P?Z6K\u001c[\u001cQ!Z'Q4S"), classArray5));
            Class[] classArray6 = new Class[1];
            classArray6[0] = List.class;
            dataTransferManager.f_Tg.m_q((short)(0x4FBF & 0x31D6), (Object)dataTransferManager, DataTransferManager.class.getDeclaredMethod(DeviceView.m_MAa((Object)"\u000bb\u0018C\rs\rS\u001ef\u0002t\nb\u001eT\u0018f\u0018r\u001fb\u001fE\u0015N\bt%i\u0018b\u001ei\rk"), classArray6));
            Class[] classArray7 = new Class[1];
            classArray7[0] = String.class;
            dataTransferManager.f_Tg.m_q((short)(0x6FFF & 0x1197), (Object)dataTransferManager, DataTransferManager.class.getDeclaredMethod(ConnectionController.m_dT((Object)"2Z!{4K4k'^;L3Z'l!^!J&Z&},o'P?Z6K\u001c[\u001cQ!Z'Q4S"), classArray7));
            return;
        }
        catch (NoSuchMethodException a) {
            throw new IllegalStateException(DeviceView.m_MAa((Object)"*f\u0005k\tcLs\u0003'\u001eb\u000bn\u001fs\tuLC\rs\rS\u001ef\u0002t\nb\u001eJ\ri\r`\tuLU<DLj\ts\u0004h\bt"), a);
        }
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void lambda$handleStatValues$17(Date date, Map map, Map map2, Map map3, Date date2, List list) {
        void a;
        void a2;
        void a3;
        Map a4;
        void a5;
        List a6;
        DataTransferManager dataTransferManager = list2;
        List list2 = list;
        DataTransferManager a7 = dataTransferManager;
        String[] stringArray = (String[])a6.stream().map(DataTransferDetail::getSourceVariableId).distinct().toArray(String[]::new);
        c_yl[] c_ylArray = (c_yl[])a6.stream().map(DataTransferDetail::getCalcType).distinct().toArray(c_yl[]::new);
        a4 = a7.f_lh.m_pba(stringArray, (Date)a5, (Date)((Object)a4), c_ylArray).stream().collect(Collectors.toMap(LoggedVariableValueStats::getVariableId, Function.identity()));
        a6.forEach(arg_0 -> a7.lambda$handleStatValues$16(a4, (Map)a3, (Map)a2, (Map)a, arg_0));
    }

    public void notLeader() {
        DataTransferManager dataTransferManager;
        DataTransferManager dataTransferManager2 = dataTransferManager = this;
        Object a = dataTransferManager2.f_Tg.m_o();
        f_Si.info(DeviceView.m_MAa((Object)"C\rs\rS\u001ef\u0002t\nb\u001eJ\ri\r`\tuV'8o\u0005tLi\u0003c\t'D|\u0011.Ln\u001f'\"HLK#I+B>'8O)' B-C)UB'/f\u0002d\tk\u0000n\u0002`Lf\u0000kLk\u0003d\rkLc\rs\r'\u0018u\ri\u001fa\tuLm\u0003e\u001f)B)"), a);
        dataTransferManager2.f_xh.lock();
        try {
            new ArrayList(dataTransferManager.f_KI.keySet()).forEach(arg_0 -> dataTransferManager.lambda$notLeader$2((String)a, arg_0));
            dataTransferManager.f_KI.clear();
            f_Si.info(ConnectionController.m_dT((Object)"\u0011^!^\u0001M4Q&Y0M\u0018^;^2Z'\u001f}q:Kus0^1Z'\u001f.B|\u0005u~9SuS:\\4Su[4K4\u001f!M4Q&Y0MuU:]&\u001f=^#Zu]0Z;\u001f'Z$J0L!Z1\u001f!Pu\\4Q6Z9\u001f4Q1\u001f6S0^'Z1\u001f3M:RuS:\\4SuK'^6T<Q2\u0011"), a);
            return;
        }
        catch (Exception exception) {
            Object[] objectArray = new Object[--3];
            objectArray[2 & 5] = a;
            objectArray[3 & 5] = exception.getMessage();
            objectArray[5 >> 1] = exception;
            f_Si.error(DeviceView.m_MAa((Object)"(f\u0018f8u\ri\u001fa\tu!f\u0002f\u000bb\u001e'DI\u0003sLK\tf\bb\u001e'\u0017zE=LB\u001eu\u0003uLc\u0019u\u0005i\u000b'\u001cu\u0003d\tt\u001f'\u0003aLd\ri\u000fb\u0000k\u0005i\u000b'\u0000h\u000ff\u0000'\bf\u0018fLs\u001ef\u0002t\nb\u001e'\u0006h\u000etV'\u0017z"), objectArray);
            return;
        }
        finally {
            dataTransferManager.f_xh.unlock();
        }
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ boolean lambda$handleStatValues$12(Date date, Map map, Map map2, Map map3, DataTransferDetail dataTransferDetail) {
        void a;
        void a2;
        DataTransferManager dataTransferManager;
        DataTransferManager dataTransferManager2 = dataTransferManager = this;
        Object a3 = dataTransferManager2.buildStatCacheKey((DataTransferDetail)a2);
        if (!dataTransferManager2.shouldRecalculateStats((DataTransferDetail)a2, (Date)a, (String)(a3 = dataTransferManager2.f_mG.get((String)a3)))) {
            void a4;
            void a5;
            void a6;
            dataTransferManager.updateVariableWithCachedValue((String)a3, (DataTransferDetail)a2, (Map)a6, (Map)a5, (Map)a4);
            return 5 >> 3;
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ Pair<Date, Date> calculateDateRange(Date date, c_CK c_CK2) {
        void a;
        void a2;
        Object a3;
        DataTransferManager dataTransferManager = this;
        Object object = a3 = Calendar.getInstance();
        ((Calendar)a3).setTime((Date)a2);
        ((Calendar)object).set(0x6F & 0x1D, 3 ^ 3);
        ((Calendar)object).set(0x7E & 0xF, 2 & 5);
        Calendar calendar = (Calendar)((Calendar)object).clone();
        switch (c_uc.f_mh[a.ordinal()]) {
            case 1: {
                Object object2 = a3;
                while (false) {
                }
                ((Calendar)object2).set(0x1C & 0x6F, 3 >> 2);
                return Pair.of((Object)((Calendar)object2).getTime(), (Object)a2);
            }
            case 2: {
                calendar.add(0x7F & 0xB, -4 >> 2);
                Object object3 = a3;
                ((Calendar)object3).add(0x4B & 0x3F, 0xFFFFFFFF & 0xFFFFFFFE);
                ((Calendar)object3).set(0xF & 0x7C, 3 ^ 3);
                return Pair.of((Object)((Calendar)object3).getTime(), (Object)calendar.getTime());
            }
            case 3: {
                Object object4 = a3;
                ((Calendar)object4).set(0x5B & 0x2F, 2 & 5);
                ((Calendar)object4).set(0x5F & 0x2C, 2 & 5);
                return Pair.of((Object)((Calendar)a3).getTime(), (Object)a2);
            }
            case 4: {
                calendar.add(--5, -4 >> 2);
                Object object5 = a3;
                ((Calendar)a3).add(--5, -2);
                ((Calendar)object5).set(11, 2 & 5);
                ((Calendar)object5).set(0x5F & 0x2C, 3 & 4);
                return Pair.of((Object)((Calendar)object5).getTime(), (Object)calendar.getTime());
            }
            case 5: {
                Object object6 = a3;
                Object object7 = a3;
                ((Calendar)object7).set(7, ((Calendar)object7).getFirstDayOfWeek());
                ((Calendar)object6).set(11, 3 ^ 3);
                ((Calendar)object6).set(12, 0);
                return Pair.of((Object)((Calendar)a3).getTime(), (Object)a2);
            }
            case 6: {
                calendar.add(--3, -4 >> 2);
                Object object8 = a3;
                ((Calendar)a3).add(--3, -2);
                Object object9 = a3;
                ((Calendar)object9).set(7, ((Calendar)object9).getFirstDayOfWeek());
                ((Calendar)object8).set(11, 0);
                ((Calendar)object8).set(12, 0);
                return Pair.of((Object)((Calendar)object8).getTime(), (Object)calendar.getTime());
            }
            case 7: {
                Object object10 = a3;
                ((Calendar)a3).set(--5, 1);
                ((Calendar)object10).set(11, 0);
                ((Calendar)object10).set(12, 0);
                return Pair.of((Object)((Calendar)a3).getTime(), (Object)a2);
            }
            case 8: {
                calendar.add(--2, -4 >> 2);
                Object object11 = a3;
                Object object12 = a3;
                ((Calendar)object12).add(2, -2);
                ((Calendar)object12).set(5, 1);
                ((Calendar)object11).set(11, 0);
                ((Calendar)object11).set(12, 0);
                return Pair.of((Object)((Calendar)object11).getTime(), (Object)calendar.getTime());
            }
            case 9: {
                Object object13 = a3;
                ((Calendar)a3).set(6, 1);
                ((Calendar)object13).set(11, 0);
                ((Calendar)object13).set(12, 0);
                return Pair.of((Object)((Calendar)a3).getTime(), (Object)a2);
            }
            case 10: {
                calendar.add(1, -1);
                Object object14 = a3;
                Object object15 = a3;
                ((Calendar)object15).add(1, -2);
                ((Calendar)object15).set(6, 1);
                ((Calendar)object14).set(11, 0);
                ((Calendar)object14).set(12, 0);
                return Pair.of((Object)((Calendar)object14).getTime(), (Object)calendar.getTime());
            }
        }
        throw new IllegalArgumentException(DeviceView.m_MAa((Object)"R\u0002b\u0014w\td\u0018b\b'\u001ef\u0002`\t'\u0018~\u001cb"));
    }

    @PreAuthorize(value="hasAuthority('VIEW_DATA_TRANSFER')")
    public Map<String, c_NB> getDataTransferStatuses(String string) {
        Object a = string;
        DataTransferManager a2 = this;
        if (a2.f_Tg.m_O()) {
            f_Si.debug(DeviceView.m_MAa((Object)" B-C)UV'+b\u0018s\u0005i\u000b'\rk\u0000'\bf\u0018fLs\u001ef\u0002t\nb\u001e'\u001fs\rs\u0019t\ttLa\u0003uLw\u001eh\u0006b\u000fsL|\u0011'\u0000h\u000ff\u0000k\u0015)"), a);
            return a2.getDataTransferStatusesByProjectIdInternal((String)a);
        }
        f_Si.debug(ConnectionController.m_dT((Object)"\u001bp\u001b\u0012\u0019z\u0014{\u0010mo\u001f\u0007Z$J0L!V;XuS0^1Z'\u001f3P'\u001f4S9\u001f1^!^uK'^;L3Z'\u001f&K4K L0LuY:MuO'P?Z6KuD(\u0011"), a);
        try {
            Object[] objectArray = new Object[--1];
            objectArray[5 >> 3] = a;
            return (Map)a2.f_Tg.m_ka(Short.valueOf((short)(0x5397 & 0x2DFF)), objectArray);
        }
        catch (Exception exception) {
            throw new ClusterRpcException("Failed to RPC get statuses for project" + (String)a, (Throwable)exception);
        }
    }

    /*
     * WARNING - void declaration
     */
    @PreAuthorize(value="hasAuthority('CANCEL_DATA_TRANSFER')")
    public void cancelDataTransfer(String string, String string2) {
        void a;
        DataTransferManager a2;
        Object a3 = string2;
        DataTransferManager dataTransferManager = a2 = this;
        dataTransferManager.cancelDataTransfer(dataTransferManager.f_vi.m_XN((String)a, (String)a3).getId());
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    private /* synthetic */ boolean shouldRecalculateStats(DataTransferDetail dataTransferDetail, Date date, String string) {
        int n;
        void a;
        void a2;
        Object a222 = string;
        DataTransferManager a3 = this;
        if (a222 == null) {
            return (4 ^ 5) != 0;
        }
        a222 = Calendar.getInstance();
        String string2 = a3.f_mG.get(a3.buildStatLastCalcTimeKey((DataTransferDetail)a2));
        if (string2 == null) {
            return (3 & 5) != 0;
        }
        ((Calendar)a222).setTimeInMillis(Long.parseLong(string2));
        Calendar calendar = Calendar.getInstance();
        calendar.setTime((Date)a);
        switch (c_uc.f_mh[a2.getRangeType().ordinal()]) {
            default: {
                throw new IncompatibleClassChangeError();
            }
            case 1: 
            case 2: {
                int n2;
                if (((Calendar)a222).get(0x7B & 0xF) != calendar.get(0xB & 0x7F)) {
                    n2 = --1;
                    break;
                }
                n2 = 0;
                break;
            }
            case 3: 
            case 4: {
                int n2;
                if (((Calendar)a222).get(0x5E & 0x27) != calendar.get(0x3F & 0x46)) {
                    n2 = 2 ^ 3;
                    break;
                }
                n2 = 0;
                break;
            }
            case 5: 
            case 6: {
                int n2;
                if (((Calendar)a222).get(--3) != calendar.get(--3)) {
                    n2 = 4 ^ 5;
                    break;
                }
                n2 = 0;
                break;
            }
            case 7: 
            case 8: {
                int n2;
                if (((Calendar)a222).get(--2) != calendar.get(--2)) {
                    n2 = --1;
                    break;
                }
                n2 = 0;
                break;
            }
            case 9: 
            case 10: {
                int n2 = n = ((Calendar)a222).get(2 ^ 3) != calendar.get(3 >> 1) ? --1 : 0;
            }
        }
        if (n != 0) {
            DataTransferManager dataTransferManager = a3;
            a222 = dataTransferManager.buildStatCacheKey((DataTransferDetail)a2);
            String string3 = dataTransferManager.buildStatLastCalcTimeKey((DataTransferDetail)a2);
            String[] stringArray = new String[1 ^ 3];
            stringArray[0] = a222;
            stringArray[1] = string3;
            dataTransferManager.f_mG.del(stringArray);
            return true;
        }
        if (!a2.getRangeType().toString().startsWith(DeviceView.m_MAa((Object)"D\u0019u\u001eb\u0002s"))) {
            return false;
        }
        int a222 = switch (c_uc.f_mh[a2.getRangeType().ordinal()]) {
            case 1 -> 5;
            case 3 -> 5;
            case 5 -> 60;
            case 7 -> 720;
            case 9 -> 720;
            default -> throw new IllegalArgumentException("Unexpected range type: " + String.valueOf(a2.getRangeType()));
        };
        long l = a.getTime();
        long l2 = Long.parseLong(string2);
        return l - l2 >= (long)(a222 * (0x3C & 0x7F) * (0x17F8 & 0x6BEF));
    }

    protected Map<String, c_NB> getDataTransferStatusesByProjectIdInternal(String string) {
        Object a = string;
        DataTransferManager a2 = this;
        if ((a = a2.f_vi.m_iO((String)a)) == null || a.isEmpty()) {
            return Collections.emptyMap();
        }
        return a.stream().collect(Collectors.toMap(DataTransferSummary::getId, dataTransferSummary -> {
            DataTransferManager a = dataTransferSummary;
            DataTransferManager a2 = this;
            return a2.getDataTransferStatusInternal(a.getId());
        }));
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ boolean isValueInThresholdRange(Double d, VariableValue<?> variableValue, VariableValue<?> variableValue2) {
        void a;
        void a2;
        VariableValue<?> a3 = variableValue2;
        VariableValue<?> a4 = this;
        if (a2 == null || a3 == null) {
            return true;
        }
        if (!(a instanceof NumberVariableValue) || !(a3 instanceof NumberVariableValue)) {
            return true;
        }
        double d2 = ((Number)a.getValue()).doubleValue();
        double d3 = ((Number)a3.getValue()).doubleValue();
        double d4 = d2 == 0.0 ? Math.abs(d3 - d2) : Math.abs((d3 - d2) / d2 * 100.0);
        if (d4 >= a2.doubleValue()) {
            return --1 != 0;
        }
        return false;
    }

    @PreAuthorize(value="hasAuthority('SCHEDULE_DATA_TRANSFER')")
    public void scheduleDataTransfer(String string) {
        Object a = string;
        DataTransferManager a2 = this;
        if (a2.f_Tg.m_O()) {
            f_Si.debug(DeviceView.m_MAa((Object)" B-C)UV'?d\u0004b\br\u0000n\u0002`Lc\rs\r'\u0018u\ri\u001fa\tuL|\u0011'\u0000h\u000ff\u0000k\u0015)"), a);
            a2.scheduleDataTransferInternal((String)a);
            return;
        }
        f_Si.debug(ConnectionController.m_dT((Object)"q\u001aqxs\u0010~\u0011z\u0007\u0005um0N Z&K<Q2\u001f9Z4[0MuK:\u001f&\\=Z1J9Zu[4K4\u001f!M4Q&Y0MuD(\u0011"), a);
        try {
            Object[] objectArray = new Object[3 & 5];
            objectArray[3 & 4] = a;
            a2.f_Tg.m_ka(Short.valueOf((short)(0x1F9 & 0x7F97)), objectArray);
            return;
        }
        catch (Exception exception) {
            throw new ClusterRpcException("Failed to RPC schedule data transfer " + (String)a, (Throwable)exception);
        }
    }

    private /* synthetic */ void lambda$scheduleDataTransferInternal$4(DataTransfer dataTransfer) {
        DataTransferManager a = dataTransfer;
        DataTransferManager a2 = this;
        a2.transfer((DataTransfer)a);
    }

    /*
     * WARNING - void declaration
     */
    @PreAuthorize(value="hasAuthority('VIEW_DATA_TRANSFER')")
    public c_NB getDataTransferStatus(String string, String string2) {
        void a;
        Object a2 = string;
        DataTransferManager a3 = this;
        if ((a2 = a3.f_vi.m_on((String)a2, (String)a)) == null) {
            return c_NB.f_XH;
        }
        return a3.getDataTransferStatus(a2.getId());
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void lambda$restoreSingleDataTransferOnLeader$1(String string, DataTransfer dataTransfer) {
        void a;
        DataTransferManager a2 = dataTransfer;
        DataTransferManager a3 = this;
        try {
            Object[] objectArray = new Object[--3];
            objectArray[3 ^ 3] = a;
            objectArray[--1] = a2.getName();
            objectArray[1 ^ 3] = a2.getId();
            f_Si.info(DeviceView.m_MAa((Object)"C\rs\rS\u001ef\u0002t\nb\u001eJ\ri\r`\tuL/ b\rc\tuL|\u0011.V'>b\u001fs\u0003u\u0005i\u000b'\bf\u0018fLs\u001ef\u0002t\nb\u001e=L|\u0011'DN(=L|\u0011."), objectArray);
            a3.scheduleDataTransferInternal((DataTransfer)a2);
            return;
        }
        catch (Exception exception) {
            Object[] objectArray = new Object[--3];
            objectArray[2 & 5] = a2.getName();
            objectArray[3 >> 1] = a2.getId();
            objectArray[1 ^ 3] = ExceptionUtils.getRootCauseMessage((Throwable)exception);
            a3.f_Wh.m_wj(a2.getProject()).m_p("Data Transfer Restore (Leader " + (String)a + ")", ConnectionController.m_dT((Object)"pLu\u0017\u001c{o\u001fpL|\u001f3^<S0[uK:\u001f'Z&K:M0\u0011u|4J&Zo\u001fpL").formatted(objectArray));
            try {
                f_Si.warn(DeviceView.m_MAa((Object)"C\rs\rS\u001ef\u0002t\nb\u001eJ\ri\r`\tuL/ b\rc\tuL|\u0011.V'-s\u0018b\u0001w\u0018n\u0002`Ls\u0003'\u000ff\u0002d\tkLc\rs\r'\u0018u\ri\u001fa\tuL|\u0011'\ra\u0018b\u001e'\u001eb\u001fs\u0003u\rs\u0005h\u0002'\nf\u0005k\u0019u\t)"), (Object)a, (Object)a2.getId());
                a3.cancelDataTransferInternal((DataTransfer)a2);
                return;
            }
            catch (Exception exception2) {
                Object[] objectArray2 = new Object[--4];
                objectArray2[3 ^ 3] = a;
                objectArray2[3 >> 1] = a2.getId();
                objectArray2[5 >> 1] = exception2.getMessage();
                objectArray2[--3] = exception2;
                f_Si.error(ConnectionController.m_dT((Object)"\u0011^!^\u0001M4Q&Y0M\u0018^;^2Z'\u001f}s0^1Z'\u001f.B|\u0005uy4V9Z1\u001f!Pu\\4Q6Z9\u001f1^!^uK'^;L3Z'\u001f.Bu^3K0MuM0L!P'^!V:QuY4V9J'Zo\u001f.B"), objectArray2);
                return;
            }
        }
    }
}

