/*
 * Decompiled with CFR 0.152.
 */
package com.inscada.mono.communication.protocols.opcua.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.inscada.mono.communication.base.model.Connection;
import com.inscada.mono.communication.protocols.opcua.b.c_YE;
import com.inscada.mono.communication.protocols.opcua.b.c_aE;
import com.inscada.mono.communication.protocols.opcua.b.c_oE;
import com.inscada.mono.communication.protocols.opcua.model.OpcUaDevice;
import com.inscada.mono.shared.converters.c_Bb;
import jakarta.persistence.Column;
import jakarta.persistence.Convert;
import jakarta.persistence.Entity;
import jakarta.persistence.OneToMany;
import jakarta.persistence.Table;
import jakarta.validation.constraints.Max;
import jakarta.validation.constraints.Min;
import jakarta.validation.constraints.NotNull;
import java.util.HashSet;
import java.util.Set;
import org.hibernate.annotations.SQLRestriction;

@Entity
@Table(name="opc_ua_connection")
public class OpcUaConnection
extends Connection<OpcUaDevice> {
    @Column(name="is_https_enabled")
    private Boolean isHttpsEnabled;
    @Min(value=100L)
    @Column(name="timeout")
    private Integer timeoutInMs;
    @NotNull
    @Column(name="is_anonymous_authentication")
    private Boolean isAnonymousAuthentication;
    @JsonIgnore
    @OneToMany(mappedBy="connection")
    @SQLRestriction(value="deleted_dttm IS NULL")
    protected Set<OpcUaDevice> devices;
    @Column(name="server_name")
    private String serverName;
    @Min(value=0L)
    @Max(value=65535L)
    @Column(name="https_port")
    private Integer httpsPort;
    @NotNull
    @Column(name="security_policy")
    private c_oE securityPolicy;
    @NotNull
    @Column(name="security_mode")
    private c_aE securityMode;
    @Column(name="username")
    private String username;
    @Column(name="encoding_type")
    private c_YE encodingType;
    @Column(name="password")
    @Convert(converter=c_Bb.class)
    private String password;
    @NotNull
    @Column(name="is_username_password_authentication")
    private Boolean isUsernamePasswordAuthentication;

    public String getUsername() {
        OpcUaConnection a;
        return a.username;
    }

    public Boolean getIsHttpsEnabled() {
        OpcUaConnection a;
        return a.isHttpsEnabled;
    }

    public Set<OpcUaDevice> getDevices() {
        OpcUaConnection a;
        return a.devices;
    }

    public void setDevices(Set<OpcUaDevice> set) {
        Object a = set;
        OpcUaConnection a2 = this;
        a2.devices = a;
    }

    public void setPassword(String string) {
        Object a = string;
        OpcUaConnection a2 = this;
        a2.password = a;
    }

    public void setUsername(String string) {
        Object a = string;
        OpcUaConnection a2 = this;
        a2.username = a;
    }

    public Integer getTimeoutInMs() {
        OpcUaConnection a;
        return a.timeoutInMs;
    }

    public OpcUaConnection() {
        OpcUaConnection a;
        OpcUaConnection opcUaConnection = a;
        opcUaConnection.devices = new HashSet();
    }

    public void setSecurityMode(c_aE c_aE2) {
        OpcUaConnection a = c_aE2;
        OpcUaConnection a2 = this;
        a2.securityMode = a;
    }

    public Boolean getIsUsernamePasswordAuthentication() {
        OpcUaConnection a;
        return a.isUsernamePasswordAuthentication;
    }

    public String getServerName() {
        OpcUaConnection a;
        return a.serverName;
    }

    public c_YE getEncodingType() {
        OpcUaConnection a;
        return a.encodingType;
    }

    public void setIsAnonymousAuthentication(Boolean bl) {
        Object a = bl;
        OpcUaConnection a2 = this;
        a2.isAnonymousAuthentication = a;
    }

    public void setEncodingType(c_YE c_YE2) {
        OpcUaConnection a = c_YE2;
        OpcUaConnection a2 = this;
        a2.encodingType = a;
    }

    public Integer getHttpsPort() {
        OpcUaConnection a;
        return a.httpsPort;
    }

    public c_oE getSecurityPolicy() {
        OpcUaConnection a;
        return a.securityPolicy;
    }

    public c_aE getSecurityMode() {
        OpcUaConnection a;
        return a.securityMode;
    }

    public void setSecurityPolicy(c_oE c_oE2) {
        OpcUaConnection a = c_oE2;
        OpcUaConnection a2 = this;
        a2.securityPolicy = a;
    }

    public String getPassword() {
        OpcUaConnection a;
        return a.password;
    }

    public void setIsUsernamePasswordAuthentication(Boolean bl) {
        Object a = bl;
        OpcUaConnection a2 = this;
        a2.isUsernamePasswordAuthentication = a;
    }

    public void setTimeoutInMs(Integer n) {
        Object a = n;
        OpcUaConnection a2 = this;
        a2.timeoutInMs = a;
    }

    public void setServerName(String string) {
        Object a = string;
        OpcUaConnection a2 = this;
        a2.serverName = a;
    }

    public void setIsHttpsEnabled(Boolean bl) {
        Object a = bl;
        OpcUaConnection a2 = this;
        a2.isHttpsEnabled = a;
    }

    public void setHttpsPort(Integer n) {
        Object a = n;
        OpcUaConnection a2 = this;
        a2.httpsPort = a;
    }

    public Boolean getIsAnonymousAuthentication() {
        OpcUaConnection a;
        return a.isAnonymousAuthentication;
    }
}

