/*
 * Decompiled with CFR 0.152.
 */
package com.inscada.mono.communication.protocols.mqtt.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.inscada.mono.communication.base.b.c_dL;
import com.inscada.mono.communication.base.model.Frame;
import com.inscada.mono.communication.protocols.mqtt.model.MqttDevice;
import com.inscada.mono.communication.protocols.mqtt.model.MqttVariable;
import com.inscada.mono.expression.model.Expression;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.OneToMany;
import jakarta.persistence.Table;
import jakarta.validation.constraints.Max;
import jakarta.validation.constraints.Min;
import jakarta.validation.constraints.NotBlank;
import jakarta.validation.constraints.NotNull;
import java.util.HashSet;
import java.util.Set;
import org.hibernate.annotations.SQLRestriction;

@Entity
@Table(name="mqtt_frame")
public class MqttFrame
extends Frame<MqttDevice, MqttVariable> {
    @Column(name="subscribe_expression_type")
    private c_dL subscribeExpressionType;
    @Column(name="publish_expression_id", insertable=false, updatable=false)
    private String publishExpressionId;
    @NotBlank
    private String topic;
    @Column(name="subscribe_expression")
    private String subscribeExpressionCode;
    @Column(name="publish_expression_type")
    private c_dL publishExpressionType;
    @JsonIgnore
    @OneToMany(mappedBy="frame")
    @SQLRestriction(value="deleted_dttm IS NULL")
    protected Set<MqttVariable> variables;
    @Column(name="publish_expression")
    private String publishExpressionCode;
    @JsonIgnore
    @ManyToOne(optional=false)
    @SQLRestriction(value="deleted_dttm IS NULL")
    @JoinColumn(name="device_id")
    protected MqttDevice device;
    @ManyToOne
    @SQLRestriction(value="deleted_dttm IS NULL")
    @JoinColumn(name="subscribe_expression_id")
    @JsonIgnore
    private Expression subscribeExpression;
    @NotNull
    @Min(value=0L)
    @Max(value=2L)
    private Integer qos;
    @JsonIgnore
    @ManyToOne
    @SQLRestriction(value="deleted_dttm IS NULL")
    @JoinColumn(name="publish_expression_id")
    private Expression publishExpression;
    @Column(name="subscribe_expression_id", insertable=false, updatable=false)
    private String subscribeExpressionId;

    public void setQos(Integer n) {
        Object a = n;
        MqttFrame a2 = this;
        a2.qos = a;
    }

    public void setVariables(Set<MqttVariable> set) {
        Object a = set;
        MqttFrame a2 = this;
        a2.variables = a;
    }

    public String getTopic() {
        MqttFrame a;
        return a.topic;
    }

    public void setPublishExpression(Expression expression) {
        MqttFrame a;
        MqttFrame a2 = expression;
        MqttFrame mqttFrame = a = this;
        mqttFrame.publishExpression = a2;
        mqttFrame.publishExpressionId = a2 != null && a2.getId() != null ? a2.getId() : null;
    }

    public void setPublishExpressionCode(String string) {
        Object a = string;
        MqttFrame a2 = this;
        a2.publishExpressionCode = a;
    }

    public Set<MqttVariable> getVariables() {
        MqttFrame a;
        return a.variables;
    }

    public String getPublishExpressionId() {
        MqttFrame a;
        return a.publishExpressionId;
    }

    public MqttDevice getDevice() {
        MqttFrame a;
        return a.device;
    }

    public void setSubscribeExpression(Expression expression) {
        MqttFrame a;
        MqttFrame a2 = expression;
        MqttFrame mqttFrame = a = this;
        mqttFrame.subscribeExpression = a2;
        mqttFrame.subscribeExpressionId = a2 != null && a2.getId() != null ? a2.getId() : null;
    }

    public String getSubscribeExpressionId() {
        MqttFrame a;
        return a.subscribeExpressionId;
    }

    public void setSubscribeExpressionType(c_dL c_dL2) {
        MqttFrame a = c_dL2;
        MqttFrame a2 = this;
        a2.subscribeExpressionType = a;
    }

    public Expression getPublishExpression() {
        MqttFrame a;
        return a.publishExpression;
    }

    public String getPublishExpressionCode() {
        MqttFrame a;
        return a.publishExpressionCode;
    }

    public String getSubscribeExpressionCode() {
        MqttFrame a;
        return a.subscribeExpressionCode;
    }

    public void setDevice(MqttDevice mqttDevice) {
        MqttFrame a;
        MqttFrame a2 = mqttDevice;
        MqttFrame mqttFrame = a = this;
        mqttFrame.device = a2;
        mqttFrame.deviceId = a2 != null && a2.getId() != null ? a2.getId() : null;
    }

    public Integer getQos() {
        MqttFrame a;
        return a.qos;
    }

    public c_dL getSubscribeExpressionType() {
        MqttFrame a;
        return a.subscribeExpressionType;
    }

    public void setSubscribeExpressionCode(String string) {
        Object a = string;
        MqttFrame a2 = this;
        a2.subscribeExpressionCode = a;
    }

    public void setPublishExpressionType(c_dL c_dL2) {
        MqttFrame a = c_dL2;
        MqttFrame a2 = this;
        a2.publishExpressionType = a;
    }

    public c_dL getPublishExpressionType() {
        MqttFrame a;
        return a.publishExpressionType;
    }

    public void setPublishExpressionId(String string) {
        Object a = string;
        MqttFrame a2 = this;
        a2.publishExpressionId = a;
    }

    public void setTopic(String string) {
        Object a = string;
        MqttFrame a2 = this;
        a2.topic = a;
    }

    public MqttFrame() {
        MqttFrame a;
        MqttFrame mqttFrame = a;
        mqttFrame.variables = new HashSet();
    }

    public Expression getSubscribeExpression() {
        MqttFrame a;
        return a.subscribeExpression;
    }

    public void setSubscribeExpressionId(String string) {
        Object a = string;
        MqttFrame a2 = this;
        a2.subscribeExpressionId = a;
    }
}

