/*
 * Decompiled with CFR 0.152.
 */
package com.inscada.mono.communication.protocols.iec104.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.inscada.mono.communication.base.model.Variable;
import com.inscada.mono.communication.protocols.iec104.model.Iec104Connection;
import com.inscada.mono.communication.protocols.iec104.model.Iec104Device;
import com.inscada.mono.communication.protocols.iec104.model.Iec104Frame;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.Table;
import jakarta.validation.constraints.Max;
import jakarta.validation.constraints.Min;
import jakarta.validation.constraints.NotNull;
import org.hibernate.annotations.SQLRestriction;

@Entity
@Table(name="iec104_variable")
public class Iec104Variable
extends Variable<Iec104Frame, Iec104Device, Iec104Connection> {
    @JsonIgnore
    @ManyToOne(optional=false)
    @SQLRestriction(value="deleted_dttm IS NULL")
    @JoinColumn(name="frame_id")
    protected Iec104Frame frame;
    @Min(value=0L)
    @Column(name="write_address")
    private Integer writeAddress;
    @NotNull
    @Column(name="use_ioa_addresses")
    private Boolean useIoaAddresses = (3 & 4) != 0;
    @Min(value=0L)
    @Max(value=255L)
    @Column(name="write_ioa_address_3")
    private Integer writeIoaAddress3;
    @Min(value=0L)
    @Column(name="read_address")
    private Integer readAddress;
    @Min(value=0L)
    @Max(value=255L)
    @Column(name="write_ioa_address_2")
    private Integer writeIoaAddress2;
    @Min(value=0L)
    @Max(value=255L)
    @Column(name="read_ioa_address_1")
    private Integer readIoaAddress1;
    @Min(value=0L)
    @Max(value=255L)
    @Column(name="read_ioa_address_2")
    private Integer readIoaAddress2;
    @Min(value=0L)
    @Max(value=255L)
    @Column(name="read_ioa_address_3")
    private Integer readIoaAddress3;
    @Min(value=0L)
    @Max(value=255L)
    @Column(name="write_ioa_address_1")
    private Integer writeIoaAddress1;

    public void setReadIoaAddress2(Integer n) {
        Object a = n;
        Iec104Variable a2 = this;
        a2.readIoaAddress2 = a;
    }

    public void setReadIoaAddress1(Integer n) {
        Object a = n;
        Iec104Variable a2 = this;
        a2.readIoaAddress1 = a;
    }

    public void setFrame(Iec104Frame iec104Frame) {
        Iec104Variable a;
        Iec104Variable a2 = iec104Frame;
        Iec104Variable iec104Variable = a = this;
        iec104Variable.frame = a2;
        iec104Variable.frameId = a2 != null && a2.getId() != null ? a2.getId() : null;
    }

    public Integer getReadAddress() {
        Iec104Variable a;
        return a.readAddress;
    }

    public Integer getReadIoaAddress1() {
        Iec104Variable a;
        return a.readIoaAddress1;
    }

    public Boolean getUseIoaAddresses() {
        Iec104Variable a;
        return a.useIoaAddresses;
    }

    public Integer getWriteIoaAddress3() {
        Iec104Variable a;
        return a.writeIoaAddress3;
    }

    public void setWriteIoaAddress1(Integer n) {
        Object a = n;
        Iec104Variable a2 = this;
        a2.writeIoaAddress1 = a;
    }

    public Integer getWriteIoaAddress1() {
        Iec104Variable a;
        return a.writeIoaAddress1;
    }

    public void setReadAddress(Integer n) {
        Object a = n;
        Iec104Variable a2 = this;
        a2.readAddress = a;
    }

    public Integer getReadIoaAddress3() {
        Iec104Variable a;
        return a.readIoaAddress3;
    }

    public void setUseIoaAddresses(Boolean bl) {
        Object a = bl;
        Iec104Variable a2 = this;
        a2.useIoaAddresses = a;
    }

    public Integer getReadIoaAddress2() {
        Iec104Variable a;
        return a.readIoaAddress2;
    }

    public Integer getWriteIoaAddress2() {
        Iec104Variable a;
        return a.writeIoaAddress2;
    }

    public void setReadIoaAddress3(Integer n) {
        Object a = n;
        Iec104Variable a2 = this;
        a2.readIoaAddress3 = a;
    }

    public void setWriteIoaAddress3(Integer n) {
        Object a = n;
        Iec104Variable a2 = this;
        a2.writeIoaAddress3 = a;
    }

    public Iec104Frame getFrame() {
        Iec104Variable a;
        return a.frame;
    }

    public void setWriteIoaAddress2(Integer n) {
        Object a = n;
        Iec104Variable a2 = this;
        a2.writeIoaAddress2 = a;
    }

    public void setWriteAddress(Integer n) {
        Object a = n;
        Iec104Variable a2 = this;
        a2.writeAddress = a;
    }

    public Integer getWriteAddress() {
        Iec104Variable a;
        return a.writeAddress;
    }

    public Iec104Variable() {
        Iec104Variable a;
    }
}

