/*
 * Decompiled with CFR 0.152.
 */
package com.inscada.mono.communication.base.services;

import com.inscada.mono.auth.c_Lk;
import com.inscada.mono.cluster.exceptions.ClusterRpcException;
import com.inscada.mono.cluster.replication.ReplicationReceiver;
import com.inscada.mono.cluster.services.ClusterNodeListener;
import com.inscada.mono.cluster.services.c_F;
import com.inscada.mono.communication.base.b.c_Bl;
import com.inscada.mono.communication.base.exceptions.BrowseOperationException;
import com.inscada.mono.communication.base.g.c_jL;
import com.inscada.mono.communication.base.g.c_ul;
import com.inscada.mono.communication.base.model.Connection;
import com.inscada.mono.communication.base.model.ConnectionSummary;
import com.inscada.mono.communication.base.model.SetValueRequest;
import com.inscada.mono.communication.base.model.Variable;
import com.inscada.mono.communication.base.services.c_HK;
import com.inscada.mono.communication.base.services.c_OD;
import com.inscada.mono.communication.base.services.c_Yg;
import com.inscada.mono.communication.base.services.c_h;
import com.inscada.mono.communication.base.services.c_lh;
import com.inscada.mono.license.g.c_nc;
import com.inscada.mono.log.g.c_lb;
import com.inscada.mono.project.g.c_l;
import com.inscada.mono.shared.exceptions.NotActiveException;
import com.inscada.mono.shared.exceptions.NotFoundException;
import com.inscada.mono.shared.model.OwnedSpaceBaseModel;
import jakarta.annotation.PostConstruct;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.stream.Collectors;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Component;
import org.springframework.transaction.event.TransactionalEventListener;
import redis.clients.jedis.JedisPooled;

@Component
public class ConnectionManager<C extends Connection<?>, V extends Variable<?, ?, ?>>
implements ClusterNodeListener,
c_l {
    private final c_F f_MS;
    public static final short f_cU = 206;
    public static final short f_su = 204;
    private final c_lb f_ys;
    private final JedisPooled f_Tt;
    private static final String f_lt = "activeConnections";
    public static final short f_cs = 201;
    public static final short f_eU = 202;
    public static final short f_OR = 205;
    public static final short f_kS = 203;
    public static final short f_Zs = 208;
    public static final short f_cT = 207;
    public static final short f_rT = 209;
    private final c_Lk f_Ts;
    private final c_HK f_eT;
    private static final Logger f_Jt = LoggerFactory.getLogger(ConnectionManager.class);
    public static final short f_US = 210;
    private final Lock f_lu;
    private final c_nc f_nu;
    private final c_lh<C, V> f_xu;

    @PreAuthorize(value="hasAuthority('START_CONNECTION')")
    public void startConnection(String string) {
        Object a = string;
        ConnectionManager a2 = this;
        if (a2.f_MS.m_O()) {
            f_Jt.debug(ReplicationReceiver.m_Sca((Object)"6\u0007;\u0006?\u0010@b)6\u001b0\u000e+\u0014%Z!\u0015,\u0014'\u00196\u0013-\u0014b\u0001?Z.\u0015!\u001b.\u0016;T"), a);
            a2.startConnectionInternal((String)a);
            return;
        }
        f_Jt.debug(c_Yg.m_Rca((Object)"\u00155\u0015W\u0017?\u001a>\u001e(aZ\t\u001f*\u000f>\t/\u00135\u001d{\u0016>\u001b?\u001f)Z/\u0015{\t/\u001b)\u000e{\u00194\u00145\u001f8\u000e2\u00155Z \u0007u"), a);
        try {
            Object[] objectArray = new Object[4 ^ 5];
            objectArray[3 ^ 3] = a;
            a2.f_MS.m_ka(Short.valueOf((short)(0x21C9 & 0x5EFF)), objectArray);
            return;
        }
        catch (Exception exception) {
            throw new ClusterRpcException("Failed to RPC start connection " + (String)a, (Throwable)exception);
        }
    }

    protected c_Bl getConnectionStatusInternal(String string) {
        Object a = string;
        ConnectionManager a2 = this;
        if ((a = a2.f_xu.m_TBa((String)a)) != null && a.m_PR()) {
            return c_Bl.f_zS;
        }
        return c_Bl.f_Vs;
    }

    @PostConstruct
    private /* synthetic */ void initializeClusterIntegration() {
        ConnectionManager a;
        ConnectionManager connectionManager = a;
        connectionManager.registerRemoteCallsWithClusterNode();
        connectionManager.f_MS.m_Da((ClusterNodeListener)a);
        f_Jt.info(c_Yg.m_Rca((Object)"94\u00145\u001f8\u000e2\u001557:\u0014:\u001d>\b{\u00135\u0013/\u0013:\u00162\u0000>\u001e{\u001b5\u001e{\b>\u001d2\t/\u001f)\u001f?Z:\t{97\u000f(\u000e>\b\u0015\u0015?\u001f\u0017\u0013(\u000e>\u0014>\bu"));
    }

    protected void startConnectionInternal(Connection<?> connection) {
        Connection<?> a = connection;
        Connection<?> a2 = this;
        a2.f_Ts.m_Dga(() -> {
            ConnectionManager a = a;
            ConnectionManager a2 = this;
            a2.f_lu.lock();
            try {
                a2.stopConnectionInternal((Connection)a);
                if (!Boolean.TRUE.equals(a.getProject().getIsActive())) {
                    throw new NotActiveException("Project should be active to start connection " + a.getName());
                }
                ConnectionManager connectionManager = a2;
                connectionManager.f_nu.m_ak();
                connectionManager.f_xu.m_CAa((Connection)a).m_Us();
                String[] stringArray = new String[2 ^ 3];
                stringArray[5 >> 3] = a.getId();
                connectionManager.f_Tt.sadd(f_lt, stringArray);
                return;
            }
            finally {
                a2.f_lu.unlock();
            }
        }, a);
    }

    protected void setVariableValuesInternal(Collection<SetValueRequest<V>> collection) {
        Collection<SetValueRequest<V>> a = collection;
        ConnectionManager a2 = this;
        a.stream().collect(Collectors.groupingBy(SetValueRequest::getConnectionId)).forEach((string, list) -> {
            Object a = string;
            ConnectionManager a2 = this;
            if ((a = a2.f_xu.m_TBa((String)a)) != null) {
                void a3;
                a.m_Ru((List)a3);
            }
        });
    }

    @PreAuthorize(value="hasAuthority('STOP_CONNECTION')")
    public void stopConnection(String string) {
        Object a = string;
        ConnectionManager a2 = this;
        if (a2.f_MS.m_O()) {
            f_Jt.debug(ReplicationReceiver.m_Sca((Object)"6\u0007;\u0006?\u0010@b)6\u00152\n+\u0014%Z!\u0015,\u0014'\u00196\u0013-\u0014b\u0001?Z.\u0015!\u001b.\u0016;T"), a);
            a2.stopConnectionInternal((String)a);
            return;
        }
        f_Jt.debug(c_Yg.m_Rca((Object)"4\u00144v6\u001e;\u001f?\t@{(>\u000b.\u001f(\u000e2\u0014<Z7\u001f:\u001e>\b{\u000e4Z(\u000e4\n{\u00194\u00145\u001f8\u000e2\u00155Z \u0007u"), a);
        try {
            Object[] objectArray = new Object[--1];
            objectArray[2 & 5] = a;
            a2.f_MS.m_ka(Short.valueOf((short)(0x67EB & 0x18DE)), objectArray);
            return;
        }
        catch (Exception exception) {
            throw new ClusterRpcException("Failed to RPC stop connection " + (String)a, (Throwable)exception);
        }
    }

    @PreAuthorize(value="hasAuthority('SET_VARIABLE_VALUE')")
    public void setVariableValues(Collection<SetValueRequest<V>> collection) {
        Collection<SetValueRequest<V>> a22 = collection;
        ConnectionManager a3 = this;
        if (a22 == null || a22.isEmpty()) {
            return;
        }
        a22.forEach(a -> Objects.requireNonNull(a, ReplicationReceiver.m_Sca((Object)"\u0011\u001f6,#\u00167\u001f\u0010\u001f3\u000f'\t6Z!\u001b,\u0014-\u000eb\u0018'Z,\u000f.\u0016")));
        a22.forEach(a -> Objects.requireNonNull(a.getConnectionId(), c_Yg.m_Rca((Object)"94\u00145\u001f8\u000e2\u001553?Z2\u0014{)>\u000e\r\u001b7\u000f>(>\u000b.\u001f(\u000e{\u0019:\u00145\u0015/Z9\u001f{\u0014.\u00167")));
        if (a3.f_MS.m_O()) {
            f_Jt.debug(ReplicationReceiver.m_Sca((Object)"6\u0007;\u0006?\u0010@b)'\u000e6\u0013,\u001db\u0001?Z4\u001b0\u0013#\u0018.\u001fb\f#\u00167\u001f1Z.\u0015!\u001b.\u0016;T"), (Object)a22.size());
            a3.setVariableValuesInternal((Collection)a22);
            return;
        }
        f_Jt.debug(c_Yg.m_Rca((Object)"4\u00144v6\u001e;\u001f?\t@{(>\u000b.\u001f(\u000e2\u0014<Z7\u001f:\u001e>\b{\u000e4Z(\u001f/Z \u0007{\f:\b2\u001b9\u0016>Z-\u001b7\u000f>\tu"), (Object)a22.size());
        try {
            Object[] objectArray = new Object[3 >> 1];
            objectArray[3 & 4] = new ArrayList(a22);
            a3.f_MS.m_ka(Short.valueOf((short)(0x8EF & 0x77DD)), objectArray);
            return;
        }
        catch (Exception a22) {
            throw new ClusterRpcException(ReplicationReceiver.m_Sca((Object)"<#\u0013.\u001f&Z6\u0015b(\u00129b\t'\u000eb\f#\b+\u001b \u0016'Z4\u001b.\u000f'\t"), (Throwable)a22);
        }
    }

    private /* synthetic */ Connection<?> loadConnectionWithDetails(Connection<?> connection) {
        Connection<?> a = connection;
        Connection<?> a2 = this;
        if (a == null) {
            return null;
        }
        return a2.f_eT.m_Vba(a.getId());
    }

    /*
     * WARNING - void declaration
     */
    protected Object browseConnectionInternal(String string) {
        void a;
        ConnectionManager connectionManager;
        ConnectionManager connectionManager2 = connectionManager = this;
        ConnectionManager a2 = connectionManager2.f_eT.m_Gca((String)a);
        return connectionManager2.f_Ts.m_fga(() -> connectionManager.lambda$browseConnectionInternal$2((String)a), (OwnedSpaceBaseModel)a2);
    }

    /*
     * WARNING - void declaration
     */
    @TransactionalEventListener(value={c_jL.class})
    public void handleRestartEvent(c_jL c_jL2) {
        void a;
        ConnectionManager connectionManager = this;
        if (connectionManager.f_MS.m_O()) {
            ConnectionManager a2 = a.m_UAa();
            f_Jt.info(c_Yg.m_Rca((Object)"\u0017?\u001a>\u001e(aZ\u0013\u001b5\u001e7\u00135\u001d{(>\t/\u001b)\u000e\u001e\f>\u0014/Z=\u0015)Z8\u00155\u0014>\u0019/\u00134\u0014aZ \u0007{R\u0012>aZ \u0007r"), (Object)a2.getName(), (Object)a2.getId());
            connectionManager.f_lu.lock();
            try {
                if (connectionManager.getConnectionStatusInternal(a2.getId()) == c_Bl.f_zS) {
                    connectionManager.startConnectionInternal(a2.getId());
                }
                return;
            }
            finally {
                connectionManager.f_lu.unlock();
            }
        }
        f_Jt.debug(ReplicationReceiver.m_Sca((Object)"\f5\fW\u000e?\u0003>\u0007(xZ\u000b\u001d,\u00150\u0013,\u001db('\t6\u001b0\u000e\u0007\f'\u00146Z$\u00150Z!\u0015,\u0014'\u00196\u0013-\u0014xZ9\u0007"), (Object)a.m_UAa().getId());
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void lambda$restoreSingleConnectionOnLeader$1(String string, Connection connection) {
        void a;
        ConnectionManager a2 = connection;
        ConnectionManager a3 = this;
        try {
            Object[] objectArray = new Object[--3];
            objectArray[3 ^ 3] = a;
            objectArray[4 ^ 5] = a2.getName();
            objectArray[--2] = a2.getId();
            f_Jt.info(ReplicationReceiver.m_Sca((Object)"\u0001\u0015,\u0014'\u00196\u0013-\u0014\u000f\u001b,\u001b%\u001f0Zj6'\u001b&\u001f0Z9\u0007k@b('\t6\u00150\u0013,\u001db\u0019-\u0014,\u001f!\u000e+\u0015,@b\u0001?Zj3\u0006@b\u0001?S"), objectArray);
            ConnectionManager connectionManager = a3;
            Connection connection2 = connectionManager.loadConnectionWithDetails((Connection)a2);
            connectionManager.startConnectionInternal(connection2);
            return;
        }
        catch (Exception exception) {
            Object[] objectArray = new Object[--3];
            objectArray[3 & 4] = a2.getName();
            objectArray[3 >> 1] = a2.getId();
            objectArray[5 >> 1] = ExceptionUtils.getRootCauseMessage((Throwable)exception);
            a3.f_ys.m_wj(a2.getProject()).m_p("Connection Restore (Leader " + (String)a + ")", c_Yg.m_Rca((Object)"_(Zs3\u001f@{_(S{\u001c:\u00137\u001f?Z/\u0015{\b>\t/\u0015)\u001fuZ\u0018\u001b.\t>@{_(").formatted(objectArray));
            try {
                f_Jt.warn(ReplicationReceiver.m_Sca((Object)"\u0001\u0015,\u0014'\u00196\u0013-\u0014\u000f\u001b,\u001b%\u001f0Zj6'\u001b&\u001f0Z9\u0007k@b;6\u000e'\u00172\u000e+\u0014%Z6\u0015b\t6\u00152Z!\u0015,\u0014'\u00196\u0013-\u0014b\u0001?Z#\u001c6\u001f0Z0\u001f1\u000e-\b#\u000e+\u0015,Z$\u001b+\u00167\b'T"), (Object)a, (Object)a2.getId());
                a3.stopConnectionInternal((Connection)a2);
                return;
            }
            catch (Exception exception2) {
                Object[] objectArray2 = new Object[--4];
                objectArray2[2 & 5] = a;
                objectArray2[5 >> 2] = a2.getId();
                objectArray2[5 >> 1] = exception2.getMessage();
                objectArray2[--3] = exception2;
                f_Jt.error(c_Yg.m_Rca((Object)"\u0018\u00155\u0014>\u0019/\u00134\u0014\u0016\u001b5\u001b<\u001f)Zs6>\u001b?\u001f)Z \u0007r@{<:\u00137\u001f?Z/\u0015{\t/\u0015+Z8\u00155\u0014>\u0019/\u00134\u0014{\u0001&Z:\u001c/\u001f)Z)\u001f(\u000e4\b:\u000e2\u00155Z=\u001b2\u0016.\b>@{\u0001&"), objectArray2);
                return;
            }
        }
    }

    @PreAuthorize(value="hasAuthority('STOP_CONNECTION')")
    public void stopConnections(String string) {
        Object a = string;
        ConnectionManager a2 = this;
        if (a2.f_MS.m_O()) {
            f_Jt.debug(ReplicationReceiver.m_Sca((Object)"\u000e?\u0003>\u0007(xZ\u0011\u000e-\n2\u0013,\u001db\u001b.\u0016b\u0019-\u0014,\u001f!\u000e+\u0015,\tb\u001c-\bb\n0\u0015(\u001f!\u000eb\u0001?Z.\u0015!\u001b.\u0016;T"), a);
            a2.stopConnectionsByProjectIdInternal((String)a);
            return;
        }
        f_Jt.debug(c_Yg.m_Rca((Object)"\u00155\u0015W\u0017?\u001a>\u001e(aZ\t\u001f*\u000f>\t/\u00135\u001d{\u0016>\u001b?\u001f)Z/\u0015{\t/\u0015+Z:\u00167Z8\u00155\u0014>\u0019/\u00134\u0014(Z=\u0015)Z+\b4\u0010>\u0019/Z \u0007u"), a);
        try {
            Object[] objectArray = new Object[--1];
            objectArray[5 >> 3] = a;
            a2.f_MS.m_ka(Short.valueOf((short)(Short.MAX_VALUE & 0xCF)), objectArray);
            return;
        }
        catch (Exception exception) {
            throw new ClusterRpcException("Failed to RPC stop connections for project " + (String)a, (Throwable)exception);
        }
    }

    public void deactivateForProject(String string) {
        Object a = string;
        ConnectionManager a2 = this;
        if (a2.f_MS.m_O()) {
            f_Jt.info(c_Yg.m_Rca((Object)"6\u001e;\u001f?\t@{2:\u0014?\u00162\u0014<Z\u000b\b4\u0010>\u0019/>>\u001b8\u000e2\f:\u000e>?-\u001f5\u000e{\u001c4\b{\n)\u00151\u001f8\u000e{3\u001f@{\u0001&"), a);
            a2.stopConnectionsByProjectIdInternal((String)a);
            return;
        }
        f_Jt.debug(ReplicationReceiver.m_Sca((Object)"\f5\fW\u000e?\u0003>\u0007(xZ\u000b\u001d,\u00150\u0013,\u001db*0\u0015(\u001f!\u000e\u0006\u001f#\u00196\u00134\u001b6\u001f\u0007\f'\u00146Z$\u00150Z2\b-\u0010'\u00196Z\u000b>xZ9\u0007"), a);
    }

    @PreAuthorize(value="hasAuthority('VIEW_CONNECTION_ITEM')")
    public Map<String, c_Bl> getConnectionStatuses(String string) {
        Object a = string;
        ConnectionManager a2 = this;
        if (a2.f_MS.m_O()) {
            f_Jt.debug(ReplicationReceiver.m_Sca((Object)"6\u0007;\u0006?\u0010@b='\u000e6\u0013,\u001db\u001b.\u0016b\u0019-\u0014,\u001f!\u000e+\u0015,Z1\u000e#\u000e7\t'\tb\u001c-\bb\n0\u0015(\u001f!\u000eb\u0001?Z.\u0015!\u001b.\u0016;T"), a);
            return a2.getConnectionStatusesByProjectIdInternal((String)a);
        }
        f_Jt.debug(c_Yg.m_Rca((Object)"\u00155\u0015W\u0017?\u001a>\u001e(aZ\t\u001f*\u000f>\t/\u00135\u001d{\u0016>\u001b?\u001f)Z=\u0015)Z:\u00167Z8\u00155\u0014>\u0019/\u00134\u0014{\t/\u001b/\u000f(\u001f(Z=\u0015)Z+\b4\u0010>\u0019/Z \u0007u"), a);
        try {
            Object[] objectArray = new Object[--1];
            objectArray[3 & 4] = a;
            return (Map)a2.f_MS.m_ka(Short.valueOf((short)(0x4CFC & 0x33D3)), objectArray);
        }
        catch (Exception exception) {
            throw new ClusterRpcException("Failed to RPC get connection statuses for project " + (String)a, (Throwable)exception);
        }
    }

    @PreAuthorize(value="hasAuthority('VIEW_CONNECTION_ITEM')")
    public Map<String, c_Bl> getConnectionStatuses(String[] stringArray) {
        Object[] a = stringArray;
        Object[] a2 = this;
        if (a == null || a.length == 0) {
            return Collections.emptyMap();
        }
        if (a2.f_MS.m_O()) {
            f_Jt.debug(ReplicationReceiver.m_Sca((Object)"6\u0007;\u0006?\u0010@b='\u000e6\u0013,\u001db\u0019-\u0014,\u001f!\u000e+\u0015,Z1\u000e#\u000e7\t'\tb\u001c-\bb\u0001?Z\u000b>1Z.\u0015!\u001b.\u0016;T"), (Object)a.length);
            return a2.getConnectionStatusesByIdsInternal((String[])a);
        }
        f_Jt.debug(c_Yg.m_Rca((Object)"\u00155\u0015W\u0017?\u001a>\u001e(aZ\t\u001f*\u000f>\t/\u00135\u001d{\u0016>\u001b?\u001f)Z=\u0015)Z8\u00155\u0014>\u0019/\u00134\u0014{\t/\u001b/\u000f(\u001f(Z=\u0015)Z \u0007{3\u001f\tu"), (Object)a.length);
        try {
            Object[] objectArray = new Object[2 ^ 3];
            objectArray[3 ^ 3] = a;
            return (Map)a2.f_MS.m_ka(Short.valueOf((short)(0x13D9 & 0x6CF7)), objectArray);
        }
        catch (Exception exception) {
            throw new ClusterRpcException("Failed to RPC get connection statuses for IDs " + Arrays.toString(a), (Throwable)exception);
        }
    }

    @PreAuthorize(value="hasAuthority('VIEW_CONNECTION_ITEM')")
    public c_Bl getConnectionStatus(String string) {
        Object a = string;
        ConnectionManager a2 = this;
        if (a2.f_MS.m_O()) {
            f_Jt.debug(ReplicationReceiver.m_Sca((Object)"6\u0007;\u0006?\u0010@b='\u000e6\u0013,\u001db\u0019-\u0014,\u001f!\u000e+\u0015,Z1\u000e#\u000e7\tb\u001c-\bb\u0001?Z.\u0015!\u001b.\u0016;T"), a);
            return a2.getConnectionStatusInternal((String)a);
        }
        f_Jt.debug(c_Yg.m_Rca((Object)"\u00155\u0015W\u0017?\u001a>\u001e(aZ\t\u001f*\u000f>\t/\u00135\u001d{\u0016>\u001b?\u001f)Z=\u0015)Z8\u00155\u0014>\u0019/\u00134\u0014{\t/\u001b/\u000f(Z=\u0015)Z \u0007u"), a);
        try {
            Object[] objectArray = new Object[--1];
            objectArray[3 >> 2] = a;
            return (c_Bl)a2.f_MS.m_ka(Short.valueOf((short)(0x1BFF & 0x64CB)), objectArray);
        }
        catch (Exception exception) {
            throw new ClusterRpcException("Failed to RPC get connection status for " + (String)a, (Throwable)exception);
        }
    }

    /*
     * WARNING - void declaration
     */
    @PreAuthorize(value="hasAuthority('VIEW_CONNECTION_ITEM')")
    public c_Bl getConnectionStatus(String string, String string2) {
        void a;
        Object a2 = string;
        ConnectionManager a3 = this;
        if ((a2 = a3.f_eT.m_YAa((String)a2, (String)a)) == null) {
            return c_Bl.f_Vs;
        }
        return a3.getConnectionStatus(a2.getId());
    }

    protected void stopConnectionInternal(Connection<?> connection) {
        Connection<?> a = connection;
        Connection<?> a2 = this;
        a2.f_Ts.m_Dga(() -> {
            ConnectionManager a = a;
            ConnectionManager a2 = this;
            a2.f_lu.lock();
            try {
                c_OD c_OD2 = a2.f_xu.m_TBa(a.getId());
                if (c_OD2 != null) {
                    c_OD2.m_jS();
                    a2.f_xu.m_KCa(a.getId(), c_OD2);
                }
                String[] stringArray = new String[2 ^ 3];
                stringArray[3 ^ 3] = a.getId();
                a2.f_Tt.srem(f_lt, stringArray);
                return;
            }
            finally {
                a2.f_lu.unlock();
            }
        }, a);
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void restoreSingleConnectionOnLeader(Connection<?> connection) {
        void a;
        ConnectionManager connectionManager;
        ConnectionManager connectionManager2 = connectionManager = this;
        Object a2 = connectionManager2.f_MS.m_o();
        String[] stringArray = new String[--3];
        stringArray[3 & 4] = ReplicationReceiver.m_Sca((Object)"\u0011.\u0003(\u0016%\u00015\f4\u00079\u00163\r4");
        stringArray[5 >> 2] = c_Yg.m_Rca((Object)"\b.\u0014*\u00049\u00144\u0015?\u0018.\u00125\u0015");
        stringArray[5 >> 1] = ReplicationReceiver.m_Sca((Object)"\u00143\u0007-\u001d9\r4\f?\u0001.\u000b5\f%\u000b.\u00077");
        connectionManager2.f_Ts.m_jEa(() -> connectionManager.lambda$restoreSingleConnectionOnLeader$1((String)a2, (Connection)a), a.getSpace(), stringArray);
    }

    /*
     * WARNING - void declaration
     */
    @TransactionalEventListener(value={c_ul.class})
    public void handleDeleteEvent(c_ul c_ul2) {
        void a;
        ConnectionManager connectionManager = this;
        if (connectionManager.f_MS.m_O()) {
            ConnectionManager a2 = a.m_zCa();
            f_Jt.info(c_Yg.m_Rca((Object)"6\u001e;\u001f?\t@{2:\u0014?\u00162\u0014<Z\u001f\u001f7\u001f/\u001f\u001e\f>\u0014/Z=\u0015)Z8\u00155\u0014>\u0019/\u00134\u0014aZ \u0007{R\u0012>aZ \u0007r"), (Object)a2.getName(), (Object)a2.getId());
            connectionManager.stopConnectionInternal((Connection)a2);
            return;
        }
        f_Jt.debug(ReplicationReceiver.m_Sca((Object)"4\r4o6\u0007;\u0006?\u0010@b3%\u0014-\b+\u0014%Z\u0006\u001f.\u001f6\u001f\u0007\f'\u00146Z$\u00150Z!\u0015,\u0014'\u00196\u0013-\u0014xZ9\u0007"), (Object)a.m_zCa().getId());
    }

    /*
     * WARNING - void declaration
     */
    @PreAuthorize(value="hasAuthority('STOP_CONNECTION')")
    public void stopConnection(String string, String string2) {
        void a;
        ConnectionManager a2;
        Object a3 = string2;
        ConnectionManager connectionManager = a2 = this;
        connectionManager.stopConnection(connectionManager.f_eT.m_fBa((String)a, (String)a3).getId());
    }

    protected Map<String, c_Bl> getConnectionStatusesByProjectIdInternal(String string) {
        Object a = string;
        ConnectionManager a2 = this;
        if ((a = a2.f_eT.m_Iba((String)a)) == null || a.isEmpty()) {
            return Collections.emptyMap();
        }
        return a.stream().collect(Collectors.toMap(ConnectionSummary::getId, connectionSummary -> {
            ConnectionManager a = connectionSummary;
            ConnectionManager a2 = this;
            return a2.getConnectionStatusInternal(a.getId());
        }));
    }

    protected void stopConnectionInternal(String string) {
        ConnectionManager a;
        Object a2 = string;
        ConnectionManager connectionManager = a = this;
        connectionManager.stopConnectionInternal(connectionManager.f_eT.m_Gca((String)a2));
    }

    private /* synthetic */ Object lambda$browseConnectionInternal$2(String string) throws Exception {
        Object a = string;
        ConnectionManager a2 = this;
        if ((a = a2.f_xu.m_TBa((String)a)) instanceof c_h) {
            return ((c_h)a).m_U();
        }
        throw new BrowseOperationException(c_Yg.m_Rca((Object)"8)\u0015,\t>Z4\n>\b:\u000e2\u00155Z5\u0015/Z(\u000f+\n4\b/\u001f?"));
    }

    @PreAuthorize(value="hasAuthority('START_CONNECTION')")
    public void startConnections(String string) {
        Object a = string;
        ConnectionManager a2 = this;
        if (a2.f_MS.m_O()) {
            f_Jt.debug(ReplicationReceiver.m_Sca((Object)"\u000e?\u0003>\u0007(xZ\u0011\u000e#\b6\u0013,\u001db\u001b.\u0016b\u0019-\u0014,\u001f!\u000e+\u0015,\tb\u001c-\bb\n0\u0015(\u001f!\u000eb\u0001?Z.\u0015!\u001b.\u0016;T"), a);
            a2.startConnectionsByProjectIdInternal((String)a);
            return;
        }
        f_Jt.debug(c_Yg.m_Rca((Object)"4\u00144v6\u001e;\u001f?\t@{(>\u000b.\u001f(\u000e2\u0014<Z7\u001f:\u001e>\b{\u000e4Z(\u000e:\b/Z:\u00167Z8\u00155\u0014>\u0019/\u00134\u0014(Z=\u0015)Z+\b4\u0010>\u0019/Z \u0007u"), a);
        try {
            Object[] objectArray = new Object[2 ^ 3];
            objectArray[5 >> 3] = a;
            a2.f_MS.m_ka(Short.valueOf((short)(0x6ACF & 0x15FE)), objectArray);
            return;
        }
        catch (Exception exception) {
            throw new ClusterRpcException("Failed to RPC start connections for project " + (String)a, (Throwable)exception);
        }
    }

    protected void setVariableValueInternal(SetValueRequest<V> setValueRequest) {
        SetValueRequest<V> a = setValueRequest;
        SetValueRequest<V> a2 = this;
        c_OD c_OD2 = a2.f_xu.m_TBa(a.getConnectionId());
        if (c_OD2 == null) {
            throw new NotFoundException("Connector for connection " + a.getConnectionId() + " not found or not active on leader.");
        }
        c_OD2.m_gU(a);
    }

    @PreAuthorize(value="hasAuthority('VIEW_CONNECTION_ITEM')")
    public Object browseConnection(String string) {
        Object a = string;
        ConnectionManager a2 = this;
        if (a2.f_MS.m_O()) {
            f_Jt.debug(ReplicationReceiver.m_Sca((Object)"\u000e?\u0003>\u0007(xZ\u0012\u001f0\u001c-\b/\u0013,\u001db\u00180\u00155\t'Z-\n'\b#\u000e+\u0015,Z$\u00150Z!\u0015,\u0014'\u00196\u0013-\u0014b\u0001?Z.\u0015!\u001b.\u0016;T"), a);
            return a2.browseConnectionInternal((String)a);
        }
        f_Jt.debug(c_Yg.m_Rca((Object)"4\u00144v6\u001e;\u001f?\t@{(>\u000b.\u001f(\u000e2\u0014<Z7\u001f:\u001e>\b{\u000e4Z+\u001f)\u001c4\b6Z9\b4\r(\u001f{\u0015+\u001f)\u001b/\u00134\u0014{\u001c4\b{\u00194\u00145\u001f8\u000e2\u00155Z \u0007u"), a);
        try {
            Object[] objectArray = new Object[3 >> 1];
            objectArray[3 >> 2] = a;
            return a2.f_MS.m_ka(Short.valueOf((short)(0x48F2 & 0x37DF)), objectArray);
        }
        catch (Exception exception) {
            throw new ClusterRpcException("Failed to RPC browse connection " + (String)a, (Throwable)exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void leader() {
        ConnectionManager connectionManager;
        ConnectionManager connectionManager2 = connectionManager = this;
        Object a = connectionManager2.f_MS.m_o();
        f_Jt.info(c_Yg.m_Rca((Object)"94\u00145\u001f8\u000e2\u001557:\u0014:\u001d>\baZ\u000f\u00122\t{\u00144\u001e>Zs\u0001&S{\u0012:\t{\u0018>\u00194\u0017>Z/\u0012>Z\u0017?\u001a>\u001e(uZ\t\u001f(\u000e4\b2\u0014<Z:\u0019/\u0013-\u001f{\u00194\u00145\u001f8\u000e2\u00155\tuTu"), a);
        connectionManager2.f_lu.lock();
        try {
            HashSet hashSet = new HashSet(connectionManager.f_Tt.smembers(f_lt));
            if (hashSet.isEmpty()) {
                f_Jt.info(ReplicationReceiver.m_Sca((Object)"9-\u0014,\u001f!\u000e+\u0015,7#\u0014#\u001d'\bbR\u000e\u001f#\u001e'\bb\u0001?SxZ\f\u0015b\u001b!\u000e+\f'Z!\u0015,\u0014'\u00196\u0013-\u00141Z$\u00157\u0014&Z+\u0014b('\u001e+\tb\u000e-Z0\u001f1\u000e-\b'T"), a);
                return;
            }
            Object[] objectArray = new Object[--3];
            objectArray[2 & 5] = a;
            objectArray[--1] = hashSet.size();
            objectArray[1 ^ 3] = hashSet;
            f_Jt.info(c_Yg.m_Rca((Object)"\u0018\u00155\u0014>\u0019/\u00134\u0014\u0016\u001b5\u001b<\u001f)Zs6>\u001b?\u001f)Z \u0007r@{<4\u000f5\u001e{\u0001&Z:\u0019/\u0013-\u001f{\u00194\u00145\u001f8\u000e2\u00155Z\u0012>(Z2\u0014{(>\u001e2\t{\u000e4Z)\u001f(\u000e4\b>@{\u0001&"), objectArray);
            Object object = new ArrayList();
            String[] stringArray = new String[--1];
            stringArray[3 >> 2] = ReplicationReceiver.m_Sca((Object)"\u00143\u0007-\u001d9\r4\f?\u0001.\u000b5\f%\u000b.\u00077");
            connectionManager.f_Ts.m_XDa(() -> {
                void a;
                Object a2 = hashSet;
                ConnectionManager a3 = this;
                a.addAll(a3.f_eT.m_NBa((Set)a2));
            }, stringArray);
            f_Jt.info(c_Yg.m_Rca((Object)"94\u00145\u001f8\u000e2\u001557:\u0014:\u001d>\b{R\u0017\u001f:\u001e>\b{\u0001&SaZ\u001a\u000e/\u001f6\n/\u00135\u001d{\u000e4Z)\u001f(\u000e4\b>Z \u0007{\u00194\u00145\u001f8\u000e2\u00155\tu"), a, (Object)object.size());
            Object object2 = object = object.iterator();
            while (object2.hasNext()) {
                Connection connection = (Connection)object.next();
                object2 = object;
                connectionManager.restoreSingleConnectionOnLeader(connection);
            }
            f_Jt.info(ReplicationReceiver.m_Sca((Object)"9-\u0014,\u001f!\u000e+\u0015,7#\u0014#\u001d'\bbR\u000e\u001f#\u001e'\bb\u0001?SxZ\u0004\u0013,\u00131\u0012'\u001eb\u0019-\u0014,\u001f!\u000e+\u0015,Z0\u001f1\u000e-\b#\u000e+\u0015,Z2\b-\u0019'\t1T"), a);
            return;
        }
        catch (Exception exception) {
            Object[] objectArray = new Object[--3];
            objectArray[2 & 5] = a;
            objectArray[2 ^ 3] = exception.getMessage();
            objectArray[1 ^ 3] = exception;
            f_Jt.error(c_Yg.m_Rca((Object)"94\u00145\u001f8\u000e2\u001557:\u0014:\u001d>\b{R\u0017\u001f:\u001e>\b{\u0001&SaZ\u001e\b)\u0015)Z?\u000f)\u00135\u001d{\u00194\u00145\u001f8\u000e2\u00155Z)\u001f(\u000e4\b:\u000e2\u00155Z+\b4\u0019>\t(@{\u0001&"), objectArray);
            return;
        }
        finally {
            connectionManager.f_lu.unlock();
        }
    }

    /*
     * WARNING - void declaration
     */
    @PreAuthorize(value="hasAuthority('START_CONNECTION')")
    public void startConnection(String string, String string2) {
        void a;
        ConnectionManager a2;
        Object a3 = string2;
        ConnectionManager connectionManager = a2 = this;
        connectionManager.startConnection(connectionManager.f_eT.m_fBa((String)a, (String)a3).getId());
    }

    /*
     * WARNING - void declaration
     */
    public ConnectionManager(c_HK c_HK2, c_nc c_nc2, c_lb c_lb2, c_lh<C, V> c_lh2, JedisPooled jedisPooled, c_F c_F2, c_Lk c_Lk2) {
        ConnectionManager a;
        void a2;
        void a3;
        void a4;
        void a5;
        void a6;
        void a7;
        ConnectionManager a8;
        ConnectionManager connectionManager = connectionManager2;
        ConnectionManager connectionManager2 = c_Lk2;
        ConnectionManager connectionManager3 = a8 = connectionManager;
        ConnectionManager connectionManager4 = a8;
        ConnectionManager connectionManager5 = a8;
        ConnectionManager connectionManager6 = a8;
        a8.f_lu = new ReentrantLock();
        a8.f_eT = a7;
        connectionManager5.f_nu = a6;
        connectionManager5.f_ys = a5;
        connectionManager4.f_xu = a4;
        connectionManager4.f_Tt = a3;
        connectionManager3.f_MS = a2;
        connectionManager3.f_Ts = a;
    }

    /*
     * WARNING - void declaration
     */
    protected void startConnectionInternal(String string) {
        void a;
        ConnectionManager connectionManager = this;
        ConnectionManager a2 = connectionManager.f_eT.m_mda((String)a);
        if (a2 == null) {
            throw new NotFoundException("Connection not found with id: " + (String)a);
        }
        ConnectionManager connectionManager2 = connectionManager;
        connectionManager2.startConnectionInternal(connectionManager2.loadConnectionWithDetails((Connection)a2));
    }

    protected Map<String, c_Bl> getConnectionStatusesByIdsInternal(String[] stringArray) {
        String[] a2 = stringArray;
        String[] a3 = this;
        return Arrays.stream(a2).collect(Collectors.toMap(a -> a, arg_0 -> ((ConnectionManager)a3).getConnectionStatusInternal(arg_0)));
    }

    public void notLeader() {
        ConnectionManager connectionManager;
        ConnectionManager connectionManager2 = connectionManager = this;
        Object a = connectionManager2.f_MS.m_o();
        f_Jt.info(c_Yg.m_Rca((Object)"\u0018\u00155\u0014>\u0019/\u00134\u0014\u0016\u001b5\u001b<\u001f)@{.3\u0013(Z5\u0015?\u001f{R \u0007rZ2\t{4\u0014Z\u00175\u0015=\u001e({.\u0013?{6\u001e;\u001f?\tT{)/\u0015+\n2\u0014<Z:\u00167Z7\u00158\u001b7Z8\u00155\u0014>\u0019/\u0015)\tuTu"), a);
        connectionManager2.f_lu.lock();
        try {
            connectionManager.f_xu.m_YCa();
            f_Jt.info(ReplicationReceiver.m_Sca((Object)"\u0001\u0015,\u0014'\u00196\u0013-\u0014\u000f\u001b,\u001b%\u001f0Zj4-\u000eb6'\u001b&\u001f0Z9\u0007k@b;.\u0016b\u0016-\u0019#\u0016b\u0019-\u0014,\u001f!\u000e-\b1Z*\u001b4\u001fb\u0018'\u001f,Z0\u001f3\u000f'\t6\u001f&Z6\u0015b\t6\u00152Z#\u0014&Z!\u0016'\u001b0\u001f&Z$\b-\u0017b\u0016-\u0019#\u0016b\u000e0\u001b!\u0011+\u0014%T"), a);
            return;
        }
        catch (Exception exception) {
            Object[] objectArray = new Object[--3];
            objectArray[3 ^ 3] = a;
            objectArray[4 ^ 5] = exception.getMessage();
            objectArray[--2] = exception;
            f_Jt.error(c_Yg.m_Rca((Object)"94\u00145\u001f8\u000e2\u001557:\u0014:\u001d>\b{R\u0015\u0015/Z\u0017\u001f:\u001e>\b{\u0001&SaZ\u001e\b)\u0015)Z?\u000f)\u00135\u001d{\n)\u00158\u001f(\t{\u0015=Z(\u000e4\n+\u00135\u001d{\u00164\u0019:\u0016{\u00194\u00145\u001f8\u000e4\b(@{\u0001&"), objectArray);
            return;
        }
        finally {
            connectionManager.f_lu.unlock();
        }
    }

    @PreAuthorize(value="hasAuthority('SET_VARIABLE_VALUE')")
    public void setVariableValue(SetValueRequest<V> setValueRequest) {
        SetValueRequest<V> a = setValueRequest;
        SetValueRequest<V> a2 = this;
        Objects.requireNonNull(a, ReplicationReceiver.m_Sca((Object)"\u0011\u001f6,#\u00167\u001f\u0010\u001f3\u000f'\t6Z!\u001b,\u0014-\u000eb\u0018'Z,\u000f.\u0016"));
        Objects.requireNonNull(a.getConnectionId(), c_Yg.m_Rca((Object)"94\u00145\u001f8\u000e2\u001553?Z2\u0014{)>\u000e\r\u001b7\u000f>(>\u000b.\u001f(\u000e{\u0019:\u00145\u0015/Z9\u001f{\u0014.\u00167"));
        if (a2.f_MS.m_O()) {
            f_Jt.debug(ReplicationReceiver.m_Sca((Object)"\u000e?\u0003>\u0007(xZ\u0011\u001f6\u000e+\u0014%Z4\u001b0\u0013#\u0018.\u001fb\f#\u00167\u001fb\u001c-\bb\u0019-\u0014,\u001f!\u000e+\u0015,Z9\u0007b\u0016-\u0019#\u0016.\u0003xZ9\u0007"), (Object)a.getConnectionId(), a);
            a2.setVariableValueInternal(a);
            return;
        }
        f_Jt.debug(c_Yg.m_Rca((Object)"\u00155\u0015W\u0017?\u001a>\u001e(aZ\t\u001f*\u000f>\t/\u00135\u001d{\u0016>\u001b?\u001f)Z/\u0015{\t>\u000e{\f:\b2\u001b9\u0016>Z-\u001b7\u000f>Z=\u0015)Z8\u00155\u0014>\u0019/\u00134\u0014{\u0001&@{\u0001&"), (Object)a.getConnectionId(), a);
        try {
            Object[] objectArray = new Object[--1];
            objectArray[2 & 5] = a;
            a2.f_MS.m_ka(Short.valueOf((short)(0x79FE & 0x6CD)), objectArray);
            return;
        }
        catch (Exception exception) {
            throw new ClusterRpcException("Failed to RPC set variable value for connection " + a.getConnectionId(), (Throwable)exception);
        }
    }

    protected void startConnectionsByProjectIdInternal(String string) {
        Object a = string;
        ConnectionManager a2 = this;
        if ((a = a2.f_eT.m_Lba((String)a)) == null || a.isEmpty()) {
            return;
        }
        Object object = a = a.iterator();
        while (object.hasNext()) {
            Connection connection = (Connection)a.next();
            ConnectionManager connectionManager = a2;
            connectionManager.startConnectionInternal(connectionManager.loadConnectionWithDetails(connection));
            object = a;
        }
    }

    private /* synthetic */ void registerRemoteCallsWithClusterNode() {
        ConnectionManager connectionManager = this;
        try {
            Class[] classArray = new Class[3 & 5];
            classArray[5 >> 3] = String.class;
            connectionManager.f_MS.m_q((short)(0x35F9 & 0x4ACF), (Object)connectionManager, ConnectionManager.class.getDeclaredMethod(ReplicationReceiver.m_Sca((Object)"\t6\u001b0\u000e\u0001\u0015,\u0014'\u00196\u0013-\u0014\u000b\u00146\u001f0\u0014#\u0016"), classArray));
            Class[] classArray2 = new Class[--1];
            classArray2[3 ^ 3] = String.class;
            connectionManager.f_MS.m_q((short)(0x55CA & 0x2AFF), (Object)connectionManager, ConnectionManager.class.getDeclaredMethod(c_Yg.m_Rca((Object)"\t/\u0015+94\u00145\u001f8\u000e2\u0015535\u000e>\b5\u001b7"), classArray2));
            Class[] classArray3 = new Class[3 & 5];
            classArray3[3 >> 2] = String.class;
            connectionManager.f_MS.m_q((short)(0x15DB & 0x6AEF), (Object)connectionManager, ConnectionManager.class.getDeclaredMethod(ReplicationReceiver.m_Sca((Object)"\u001d'\u000e\u0001\u0015,\u0014'\u00196\u0013-\u0014\u0011\u000e#\u000e7\t\u000b\u00146\u001f0\u0014#\u0016"), classArray3));
            Class[] classArray4 = new Class[5 >> 2];
            classArray4[3 ^ 3] = SetValueRequest.class;
            connectionManager.f_MS.m_q((short)(0x34EC & 0x4BDF), (Object)connectionManager, ConnectionManager.class.getDeclaredMethod(c_Yg.m_Rca((Object)"\t>\u000e\r\u001b)\u0013:\u00187\u001f\r\u001b7\u000f>35\u000e>\b5\u001b7"), classArray4));
            Class[] classArray5 = new Class[3 & 5];
            classArray5[3 & 4] = Collection.class;
            connectionManager.f_MS.m_q((short)(0x3ADF & 0x45ED), (Object)connectionManager, ConnectionManager.class.getDeclaredMethod(ReplicationReceiver.m_Sca((Object)"\t'\u000e\u0014\u001b0\u0013#\u0018.\u001f\u0014\u001b.\u000f'\t\u000b\u00146\u001f0\u0014#\u0016"), classArray5));
            Class[] classArray6 = new Class[1];
            classArray6[0] = String.class;
            connectionManager.f_MS.m_q((short)(0x5FCE & 0x20FF), (Object)connectionManager, ConnectionManager.class.getDeclaredMethod(c_Yg.m_Rca((Object)"(\u000e:\b/94\u00145\u001f8\u000e2\u00155\t\u0019\u0003\u000b\b4\u0010>\u0019/3?35\u000e>\b5\u001b7"), classArray6));
            Class[] classArray7 = new Class[1];
            classArray7[0] = String.class;
            connectionManager.f_MS.m_q((short)(0x6ECF & 0x11FF), (Object)connectionManager, ConnectionManager.class.getDeclaredMethod(ReplicationReceiver.m_Sca((Object)"1\u000e-\n\u0001\u0015,\u0014'\u00196\u0013-\u001418;*0\u0015(\u001f!\u000e\u000b\u001e\u000b\u00146\u001f0\u0014#\u0016"), classArray7));
            Class[] classArray8 = new Class[1];
            classArray8[0] = String.class;
            connectionManager.f_MS.m_q((short)(0x28FD & 0x57D2), (Object)connectionManager, ConnectionManager.class.getDeclaredMethod(c_Yg.m_Rca((Object)"\u001d>\u000e\u0018\u00155\u0014>\u0019/\u00134\u0014\b\u000e:\u000e.\t>\t\u0019\u0003\u000b\b4\u0010>\u0019/3?35\u000e>\b5\u001b7"), classArray8));
            Class[] classArray9 = new Class[1];
            classArray9[0] = String[].class;
            connectionManager.f_MS.m_q((short)(0x1AF7 & 0x65D9), (Object)connectionManager, ConnectionManager.class.getDeclaredMethod(ReplicationReceiver.m_Sca((Object)"%\u001f69-\u0014,\u001f!\u000e+\u0015,)6\u001b6\u000f1\u001f18;3&\t\u000b\u00146\u001f0\u0014#\u0016"), classArray9));
            Class[] classArray10 = new Class[1];
            classArray10[0] = String.class;
            connectionManager.f_MS.m_q((short)(0x48FB & 0x37D6), (Object)connectionManager, ConnectionManager.class.getDeclaredMethod(c_Yg.m_Rca((Object)"\u0018)\u0015,\t>94\u00145\u001f8\u000e2\u0015535\u000e>\b5\u001b7"), classArray10));
            return;
        }
        catch (NoSuchMethodException a) {
            throw new IllegalStateException(ReplicationReceiver.m_Sca((Object)"\u0004\u001b+\u0016'\u001eb\u000e-Z0\u001f%\u00131\u000e'\bb9-\u0014,\u001f!\u000e+\u0015,7#\u0014#\u001d'\bb(\u00129b\u0017'\u000e*\u0015&\t"), a);
        }
    }

    protected void stopConnectionsByProjectIdInternal(String string) {
        Object a = string;
        ConnectionManager a2 = this;
        if ((a = a2.f_eT.m_Lba((String)a)) == null || a.isEmpty()) {
            return;
        }
        a.forEach(arg_0 -> a2.stopConnectionInternal(arg_0));
    }
}

