/*
 * Decompiled with CFR 0.152.
 */
package com.inscada.mono.cluster.replication;

import com.inscada.mono.auth.c_Lk;
import com.inscada.mono.cluster.model.ClusterNodeInfo;
import com.inscada.mono.cluster.services.ClusterNodeListener;
import com.inscada.mono.cluster.services.c_F;
import com.inscada.mono.communication.base.services.c_Yg;
import com.inscada.mono.config.c_md;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.stereotype.Component;
import redis.clients.jedis.JedisPooled;
import redis.clients.jedis.util.SafeEncoder;

@Component
@ConditionalOnProperty(value={"ins.cluster.redis.replication.enabled"}, havingValue="true")
public class RedisReplicator
implements ClusterNodeListener {
    private final c_Lk f_xT;
    private final Logger f_cu;
    private final String f_Os;
    private final c_F f_Zu;
    private final JedisPooled f_Fs;
    private final Integer f_ds;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void notLeader() {
        RedisReplicator redisReplicator;
        RedisReplicator redisReplicator2 = redisReplicator = this;
        redisReplicator.f_cu.info(c_Yg.m_Rca((Object)".3\u0013(Z5\u0015?\u001f{\u0013(Z\u00155\u000fZ\u0017?\u001a>\u001e(uZ\u001a\u000e/\u001f6\n/\u00135\u001d{\u000e4Z8\u00155\u001c2\u001d.\b>Z7\u00158\u001b7Z\t\u001f?\u0013(Zs\u0001&@ \u0007rZ:\t{\t7\u001b-\u001fu"), (Object)redisReplicator2.f_Os, (Object)redisReplicator2.f_ds);
        try {
            String[] stringArray = new String[--1];
            stringArray[2 & 5] = c_md.m_fr((Object)"\u001aC\t]\u0013I\u0000_\u001f^\tX\u0013Y\u0018K\u0018_\u001f");
            Optional optional = (Optional)redisReplicator.f_xT.m_Pea(() -> {
                RedisReplicator a;
                return a.f_Zu.m_Aa().stream().filter(ClusterNodeInfo::getIsLeader).findFirst();
            }, stringArray);
            if (optional.isPresent()) {
                ClusterNodeInfo clusterNodeInfo = (ClusterNodeInfo)optional.get();
                String string = clusterNodeInfo.getHost();
                String a = clusterNodeInfo.getRedisHost();
                Integer n = clusterNodeInfo.getRedisPort();
                if (a == null || n == null) {
                    Object[] objectArray = new Object[--4];
                    objectArray[5 >> 3] = clusterNodeInfo.getNodeId();
                    objectArray[--1] = string;
                    objectArray[5 >> 1] = redisReplicator.f_Os;
                    objectArray[--3] = redisReplicator.f_ds;
                    redisReplicator.f_cu.error(c_Yg.m_Rca((Object)"6>\u001b?\u001f)Z5\u0015?\u001f{\u0001&Zs0\u001c\b4\u000f+\t{24\t/@{\u0001&S{\r:\t{\u0013?\u001f5\u000e2\u001c2\u001f?V{\u0018.\u000e{\u0013/\t{\t+\u001f8\u0013=\u00138Z\t\u001f?\u0013(Z3\u0015(\u000et\n4\b/Z2\t{\u00172\t(\u00135\u001d{\u00135Z\u0018\u0016.\t/\u001f)44\u001e>35\u001c4T{9:\u00145\u0015/Z8\u00155\u001c2\u001d.\b>Z7\u00158\u001b7Z\t\u001f?\u0013(Zs\u0001&@ \u0007rZ:\t{\t7\u001b-\u001fuZ\u0017\u00158\u001b7Z\t\u001f?\u0013(Z)\u001f6\u001b2\u0014(Z2\u0014{\u0013/\t{\u0019.\b)\u001f5\u000e{\b>\n7\u00138\u001b/\u00134\u0014{\t/\u001b/\u001fu"), objectArray);
                    return;
                }
                if (a.equals(redisReplicator.f_Os) && n.equals(redisReplicator.f_ds)) {
                    Object[] objectArray = new Object[--4];
                    objectArray[5 >> 3] = a;
                    objectArray[4 ^ 5] = n;
                    objectArray[5 >> 1] = redisReplicator.f_Os;
                    objectArray[--3] = redisReplicator.f_ds;
                    redisReplicator.f_cu.warn(c_md.m_fr((Object)"\u0005n)d8c*c)nlf)k(o>-?*\u001eo(c?*dq107we*%yl~$oly-g)*-ylf#i-flX)n%yl\"7wvq1#b*\u0018b%yld#n)*;c fld#~lk8~)g<~l~#*?f-|)*#l**%~?o lb*\td?\u007f>c\"mlf#i-flX)n%ylc?*!k?~)xb"), objectArray);
                    Object[] objectArray2 = new Object[--4];
                    objectArray2[3 >> 2] = redisReplicator.f_Os;
                    objectArray2[3 & 5] = redisReplicator.f_ds;
                    objectArray2[5 >> 1] = a;
                    objectArray2[--3] = n;
                    redisReplicator.f_cu.error(c_Yg.m_Rca((Object)"\u0018(\u0012.\u00129\u001a6{9\u00144\u001d3\u001c/\t;\u000f3\u00144{3\b)\u000e?aZ\u000f\u00122\t{\u00144\u001e>Zs\u0001&@ \u0007rZ2\t{\u00144\u000e{0\u001c\b4\u000f+\t{\u0016>\u001b?\u001f)V{\u0018.\u000e{\u000e3\u001f{\u0013?\u001f5\u000e2\u001c2\u001f?Z\u0011=)\u0015.\n(Z7\u001f:\u001e>\b|\t{(>\u001e2\t{\u001f5\u001e+\u00152\u0014/Zs\u0001&@ \u0007rZ+\u00152\u0014/\t{\u000e4Z/\u00122\t{\u00144\u001e>](Z7\u00158\u001b7Z\t\u001f?\u0013(T{.3\u0013(Z2\u0014?\u00138\u001b/\u001f(Z:Z+\u0015/\u001f5\u000e2\u001b7Z6\u0013(\u00194\u0014=\u0013<\u000f)\u001b/\u00134\u0014{\u0015)Z:\u0014{\u000f5\t/\u001b9\u0016>Z(\u000e:\u000e>T{64\u0019:\u0016{(>\u001e2\t{\b>\n7\u00138\u001b/\u00134\u0014{\t/\u001b/\u001f{\r2\u00167Z\u00155\u000fZ9\u001f{\u00193\u001b5\u001d>\u001e{\u001b.\u000e4\u0017:\u000e2\u0019:\u00167\u0003{\u000e4Z+\b>\f>\u0014/Z2\t(\u000f>\tu"), objectArray2);
                    return;
                }
                Object[] objectArray = new Object[7 & 0x7E];
                objectArray[3 >> 2] = clusterNodeInfo.getNodeId();
                objectArray[1] = string;
                objectArray[--2] = redisReplicator.f_Os;
                objectArray[3] = redisReplicator.f_ds;
                objectArray[4] = a;
                objectArray[5] = n;
                redisReplicator.f_cu.info(c_md.m_fr((Object)"\ne9d(*\u0006M>e9z?* o-n)xv*\u0002e(o\u0005nq-7wk&l@\u000bx#\u007f<y\u0004e?~q-7wk$lK8~)g<~%d+*8ely k:olf#i-flX)n%yl\"7wvq1#l~#* o-n)xkylX)n%ylk8*7wvq1"), objectArray);
                byte[][] byArrayArray = new byte[2][];
                byArrayArray[0] = SafeEncoder.encode((String)a);
                byArrayArray[1] = SafeEncoder.encode((String)String.valueOf(n));
                redisReplicator.f_Fs.sendCommand(() -> SafeEncoder.encode((String)c_md.m_fr((Object)"\u001fF\r\\\tE\n")), (byte[][])byArrayArray);
                Object[] objectArray3 = new Object[4];
                objectArray3[0] = redisReplicator.f_Os;
                objectArray3[1] = redisReplicator.f_ds;
                objectArray3[2] = a;
                objectArray3[3] = n;
                redisReplicator.f_cu.info(c_Yg.m_Rca((Object)"\u0017\u00158\u001b7Z\t\u001f?\u0013(Zs\u0001&@ \u0007r@{)>\u0014/Z8\u00156\u0017:\u0014?Z\b6\u001a,\u001e5\u001dZ \u0007{\u0001&"), objectArray3);
                return;
            }
            RedisReplicator redisReplicator3 = redisReplicator;
            redisReplicator.f_cu.warn(c_md.m_fr((Object)"I#\u007f nld#~ll%d(*-*\u0006M>e9z?* o-n)xld#n)*:c-*\u001eZ\u000f*8eln)~)x!c\"ol~$olg-y8o>*\u001eo(c?*%d?~-d/ob*\u0000e/k *\u001eo(c?*dq107we*;c flx)g-c\"*%dlc8yli9x>o\"~lx)z c/k8c#dly8k8ob*\u0018b%ylc?*8b)*?k*o?~lk<z>e-i$*8elk:e%nly<f%~ah>k%dlc\"*/k?ole**\"o8}#x'*<k>~%~%e\"yb*\u0001k\"\u007f-flc\"~)x:o\"~%e\"*!k5*.olx){9c>o(*%ll~$oli \u007f?~)xlc?*<k>~%~%e\"o(*#xl~$oln)y%m\"k8o(* o-n)xlc?*8x9f5*(e;db"), (Object)redisReplicator3.f_Os, (Object)redisReplicator3.f_ds);
            return;
        }
        catch (Exception exception) {
            Object[] objectArray = new Object[4];
            objectArray[0] = redisReplicator.f_Os;
            objectArray[1] = redisReplicator.f_ds;
            objectArray[2] = exception.getMessage();
            objectArray[3] = exception;
            redisReplicator.f_cu.error(c_Yg.m_Rca((Object)"?)\b4\b{\u00135Z\t\u001f?\u0013((>\n7\u00138\u001b/\u00134\u0014\b\u001f)\f2\u0019>T5\u0015/6>\u001b?\u001f)RrZ,\u00122\u0016>Z8\u00155\u001c2\u001d.\b2\u0014<Z7\u00158\u001b7Z\t\u001f?\u0013(Zs\u0001&@ \u0007r@{\u0001&"), objectArray);
            return;
        }
    }

    public void leader() {
        RedisReplicator redisReplicator = this;
        try {
            byte[][] byArrayArray = new byte[1 ^ 3][];
            byArrayArray[3 ^ 3] = SafeEncoder.encode((String)c_Yg.m_Rca((Object)"4\u0014"));
            byArrayArray[4 ^ 5] = SafeEncoder.encode((String)c_md.m_fr((Object)"\u0003D\t"));
            redisReplicator.f_Fs.sendCommand(() -> SafeEncoder.encode((String)c_Yg.m_Rca((Object)"\b6\u001a,\u001e5\u001d")), (byte[][])byArrayArray);
            RedisReplicator redisReplicator2 = redisReplicator;
            redisReplicator.f_cu.info(c_Yg.m_Rca((Object)"\u000f\u00122\t{\u00144\u001e>Z2\t{6\u001e;\u001f?\tT{64\u0019:\u0016{(>\u001e2\t{R \u0007a\u0001&S{\t>\u000e{\u000e4Z9\u001f{7\u001a)\u000f?\tZs)\u0017;\r?\u0014<{4\u0014Z\u00144\u001eSu"), (Object)redisReplicator2.f_Os, (Object)redisReplicator2.f_ds);
            return;
        }
        catch (Exception a) {
            Object[] objectArray = new Object[--4];
            objectArray[5 >> 3] = redisReplicator.f_Os;
            objectArray[3 >> 1] = redisReplicator.f_ds;
            objectArray[5 >> 1] = a.getMessage();
            objectArray[--3] = a;
            redisReplicator.f_cu.error(c_md.m_fr((Object)"\tx>e>*?o8~%d+* e/k *\u001eo(c?*dq107we*8elG\rY\u0018O\u001e0lq1"), objectArray);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    public RedisReplicator(c_F c_F2, c_Lk c_Lk2, JedisPooled jedisPooled, @Value(value="${spring.data.redis.host:localhost}") String string, @Value(value="${spring.data.redis.port:6379}") Integer n) {
        void localRedisHost;
        void jedis;
        void runAsManager;
        void clusterOperations;
        RedisReplicator a;
        RedisReplicator redisReplicator = object;
        Object object = n;
        RedisReplicator redisReplicator2 = a = redisReplicator;
        RedisReplicator redisReplicator3 = a;
        redisReplicator3.f_cu = LoggerFactory.getLogger(RedisReplicator.class);
        redisReplicator3.f_Zu = clusterOperations;
        redisReplicator2.f_xT = runAsManager;
        redisReplicator2.f_Fs = jedis;
        a.f_Os = localRedisHost;
        a.f_ds = object;
        a.f_Zu.m_Da((ClusterNodeListener)a);
    }
}

