/*
 * Decompiled with CFR 0.152.
 */
package com.inscada.mono.alarm.services;

import com.inscada.mono.alarm.b.c_gk;
import com.inscada.mono.alarm.g.c_Ak;
import com.inscada.mono.alarm.g.c_BL;
import com.inscada.mono.alarm.g.c_Tk;
import com.inscada.mono.alarm.g.c_iL;
import com.inscada.mono.alarm.g.c_sK;
import com.inscada.mono.alarm.model.Alarm;
import com.inscada.mono.alarm.model.AlarmGroup;
import com.inscada.mono.alarm.model.AlarmGroupSummary;
import com.inscada.mono.alarm.services.c_LJ;
import com.inscada.mono.alarm.services.c_Yl;
import com.inscada.mono.alarm.services.c_jl;
import com.inscada.mono.alarm.services.c_uK;
import com.inscada.mono.auth.c_Lk;
import com.inscada.mono.auth.restcontrollers.AuthController;
import com.inscada.mono.cluster.exceptions.ClusterRpcException;
import com.inscada.mono.cluster.services.ClusterNodeListener;
import com.inscada.mono.cluster.services.c_F;
import com.inscada.mono.log.g.c_lb;
import com.inscada.mono.project.g.c_l;
import com.inscada.mono.shared.exceptions.NotActiveException;
import com.inscada.mono.shared.model.BaseModel;
import com.inscada.mono.shared.model.OwnedSpaceBaseModel;
import com.inscada.mono.user.g.c_u;
import jakarta.annotation.PostConstruct;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Component;
import org.springframework.transaction.event.TransactionalEventListener;
import redis.clients.jedis.JedisPooled;

@Component
public class AlarmManager
implements ClusterNodeListener,
c_l {
    private final c_Lk f_Ew;
    private final Lock f_Kx;
    private final c_uK f_pw;
    public static final short f_zx = 105;
    private final c_lb f_rx;
    private final c_Yl f_PU;
    private final c_F f_VU;
    public static final short f_Qx = 102;
    public static final short f_vw = 108;
    public static final short f_Hx = 107;
    private static final String f_Yx = "activeAlarmGroups";
    public static final short f_ZV = 103;
    public static final short f_fW = 109;
    private final c_LJ f_zv;
    private static final Logger f_qv = LoggerFactory.getLogger(AlarmManager.class);
    public static final short f_Qw = 101;
    private final JedisPooled f_hx;
    public static final short f_sU = 104;
    public static final short f_nv = 106;

    protected void deactivateAlarmGroupInternal(String string) {
        AlarmManager a;
        Object a2 = string;
        AlarmManager alarmManager = a = this;
        alarmManager.deactivateAlarmGroupInternal(alarmManager.f_pw.m_zha((String)a2));
    }

    /*
     * WARNING - void declaration
     */
    @PreAuthorize(value="hasAuthority('VIEW_ALARM')")
    public c_gk getAlarmStatus(String string, String string2) {
        void a;
        Object a2 = string;
        AlarmManager a3 = this;
        if ((a2 = a3.f_PU.m_tIa((String)a2, (String)a)) == null) {
            return c_gk.f_zZ;
        }
        return a3.getAlarmStatus(a2.getId());
    }

    protected c_gk getAlarmGroupStatusInternal(String string) {
        Object a = string;
        AlarmManager a2 = this;
        if ((a = a2.f_zv.m_oga((String)a)) != null && a.m_qha()) {
            return c_gk.f_hX;
        }
        return c_gk.f_zZ;
    }

    @PreAuthorize(value="hasAuthority('VIEW_ALARM')")
    public Map<String, c_gk> getAlarmStatuses(List<String> list) {
        List<String> a = list;
        AlarmManager a2 = this;
        if (a == null || a.isEmpty()) {
            return Collections.emptyMap();
        }
        if (a2.f_VU.m_O()) {
            f_qv.debug(AuthController.m_hEa((Object)"j\u001fg\u001ec\b\u001cza?R.O4AzG6G(KzU.G.S)C)\u0006<I(\u0006![zo\u001eUzJ5E;J6_`\u0006!["), (Object)a.size(), (Object)a);
            return a2.getAlarmStatusesInternal((List)a);
        }
        f_qv.debug(c_u.m_Nd((Object)"n+nIl!a e6\u001aDr\u0001Q\u0011E\u0017T\rN\u0003\u0000\bE\u0005D\u0001RDF\u000bRDA\bA\u0016MDS\u0010A\u0010U\u0017E\u0017\u0000\u0002O\u0016\u0000\u001f]Di S^\u0000\u001f]"), (Object)a.size(), (Object)a);
        try {
            Object[] objectArray = new Object[3 >> 1];
            objectArray[3 >> 2] = new ArrayList(a);
            return (Map)a2.f_VU.m_ka(Short.valueOf((short)(0x6F & 0x7B)), objectArray);
        }
        catch (Exception exception) {
            throw new ClusterRpcException("Failed to RPC get alarm statuses for IDs " + String.valueOf(a), (Throwable)exception);
        }
    }

    @TransactionalEventListener(value={c_iL.class})
    public void handleAlarmGroupDeleteEvent(c_iL c_iL2) {
        AlarmManager a = c_iL2;
        AlarmManager a2 = this;
        if (a2.f_VU.m_O()) {
            f_qv.info(AuthController.m_hEa((Object)"j\u001fg\u001ec\b\u001czn;H>J3H=\u0006\u001bJ;T7a(I/V\u001eC6C.C\u001fP?H.\u0006<I(\u0006=T5S*\u0006\u0013b`\u0006!["), (Object)a.m_ria().getId());
            a2.deactivateAlarmGroupInternal(a.m_ria().getId());
            return;
        }
        f_qv.debug(c_u.m_Nd((Object)"n+nIl!a e6\u001aDi\u0003N\u000bR\rN\u0003\u0000%L\u0005R\tg\u0016O\u0011P E\bE\u0010E!V\u0001N\u0010\u0000\u0002O\u0016\u0000\u0003R\u000bU\u0014\u0000-d^\u0000\u001f]"), (Object)a.m_ria().getId());
    }

    @PreAuthorize(value="hasAuthority('DEACTIVATE_ALARM')")
    public void deactivateAlarmGroups(String string) {
        Object a = string;
        AlarmManager a2 = this;
        if (a2.f_VU.m_O()) {
            f_qv.debug(AuthController.m_hEa((Object)"j\u001fg\u001ec\b\u001czb?G9R3P;R3H=\u0006;J6\u0006;J;T7\u0006=T5S*Uz@5TzV(I0C9Rz]'\u00066I9G6J#\b"), a);
            a2.deactivateAlarmGroupsByProjectIdInternal((String)a);
            return;
        }
        f_qv.debug(c_u.m_Nd((Object)"*o*\r(e%d!r^\u00006E\u0015U\u0001S\u0010I\nGDL\u0001A\u0000E\u0016\u0000\u0010ODD\u0001A\u0007T\rV\u0005T\u0001\u0000\u0005L\b\u0000\u0005L\u0005R\t\u0000\u0003R\u000bU\u0014SDF\u000bRDP\u0016O\u000eE\u0007TD[\u0019\u000e"), a);
        try {
            Object[] objectArray = new Object[2 ^ 3];
            objectArray[3 >> 2] = a;
            a2.f_VU.m_ka(Short.valueOf((short)(0x6F & 0x7D)), objectArray);
            return;
        }
        catch (Exception exception) {
            throw new ClusterRpcException("Failed to RPC deactivate alarm groups for project " + (String)a, (Throwable)exception);
        }
    }

    @TransactionalEventListener(value={c_BL.class})
    public void handleAlarmChangeEvent(c_BL c_BL2) {
        AlarmManager alarmManager = this;
        if (alarmManager.f_VU.m_O()) {
            AlarmManager a = a.m_IHa();
            f_qv.info(AuthController.m_hEa((Object)"\u0016c\u001bb\u001ft`\u0006\u0012G4B6O4Azg6G(K\u0019N;H=C\u001fP?H.\u0006<I(\u0006;J;T7\u0006\u0013b`\u0006![v\u0006\u001dT5S*\u0006\u0013b`\u0006!["), (Object)a.getId(), (Object)a.getGroupId());
            c_jl c_jl2 = alarmManager.f_zv.m_oga(a.getGroupId());
            if (c_jl2 != null && c_jl2.m_qha()) {
                if (Boolean.TRUE.equals(a.getIsActive())) {
                    c_jl2.m_JIa((Alarm)a);
                    return;
                }
                c_jl2.m_iga((Alarm)a);
                return;
            }
        } else {
            f_qv.debug(c_u.m_Nd((Object)"*o*\r(e%d!r^\u0000-G\nO\u0016I\nGDa\bA\u0016M'H\u0005N\u0003E!V\u0001N\u0010\u0000\u0002O\u0016\u0000\u0005L\u0005R\t\u0000-d^\u0000\u001f]"), (Object)a.m_IHa().getId());
        }
    }

    protected void activateAlarmGroupInternal(AlarmGroup alarmGroup) {
        AlarmManager a = alarmGroup;
        AlarmManager a2 = this;
        a2.f_Ew.m_Dga(() -> a2.lambda$activateAlarmGroupInternal$2((AlarmGroup)a), (OwnedSpaceBaseModel)a);
    }

    protected void activateAlarmGroupInternal(String string) {
        AlarmManager a;
        Object a2 = string;
        AlarmManager alarmManager = a = this;
        alarmManager.activateAlarmGroupInternal(alarmManager.f_pw.m_zha((String)a2));
    }

    @TransactionalEventListener(value={c_Ak.class})
    public void handleAlarmDeleteEvent(c_Ak c_Ak2) {
        AlarmManager alarmManager = this;
        if (alarmManager.f_VU.m_O()) {
            AlarmManager a = a.m_uia();
            f_qv.info(AuthController.m_hEa((Object)"\u0016c\u001bb\u001ft`\u0006\u0012G4B6O4Azg6G(K\u001eC6C.C\u001fP?H.\u0006<I(\u0006;J;T7\u0006\u0013b`\u0006![v\u0006\u001dT5S*\u0006\u0013b`\u0006!["), (Object)a.getId(), (Object)a.getGroupId());
            c_jl c_jl2 = alarmManager.f_zv.m_oga(a.getGroupId());
            if (c_jl2 != null && c_jl2.m_qha()) {
                c_jl2.m_iga((Alarm)a);
                return;
            }
        } else {
            f_qv.debug(c_u.m_Nd((Object)"*o*\r(e%d!r^\u0000-G\nO\u0016I\nGDa\bA\u0016M E\bE\u0010E!V\u0001N\u0010\u0000\u0002O\u0016\u0000\u0005L\u0005R\t\u0000-d^\u0000\u001f]"), (Object)a.m_uia().getId());
        }
    }

    private /* synthetic */ void registerRemoteCallsWithClusterNode() {
        AlarmManager alarmManager = this;
        try {
            Class[] classArray = new Class[4 ^ 5];
            classArray[5 >> 3] = String.class;
            alarmManager.f_VU.m_q((short)(0x75 & 0x6F), (Object)alarmManager, AlarmManager.class.getDeclaredMethod(AuthController.m_hEa((Object)";E.O,G.C\u001bJ;T7a(I/V\u0013H.C(H;J"), classArray));
            Class[] classArray2 = new Class[--1];
            classArray2[5 >> 3] = String.class;
            alarmManager.f_VU.m_q((short)(0x66 & 0x7F), (Object)alarmManager, AlarmManager.class.getDeclaredMethod(c_u.m_Nd((Object)"\u0000E\u0005C\u0010I\u0012A\u0010E%L\u0005R\tg\u0016O\u0011P-N\u0010E\u0016N\u0005L"), classArray2));
            Class[] classArray3 = new Class[2 ^ 3];
            classArray3[3 & 4] = String.class;
            alarmManager.f_VU.m_q((short)(0x77 & 0x6F), (Object)alarmManager, AlarmManager.class.getDeclaredMethod(AuthController.m_hEa((Object)"=C.g6G(K\tR;R/U\u0013H.C(H;J"), classArray3));
            Class[] classArray4 = new Class[4 ^ 5];
            classArray4[3 ^ 3] = String.class;
            alarmManager.f_VU.m_q((short)(0x68 & 0x7F), (Object)alarmManager, AlarmManager.class.getDeclaredMethod(c_u.m_Nd((Object)"G\u0001T%L\u0005R\tg\u0016O\u0011P7T\u0005T\u0011S-N\u0010E\u0016N\u0005L"), classArray4));
            Class[] classArray5 = new Class[5 >> 2];
            classArray5[2 & 5] = String.class;
            alarmManager.f_VU.m_q((short)(0x6F & 0x79), (Object)alarmManager, AlarmManager.class.getDeclaredMethod(AuthController.m_hEa((Object)"A?R\u001bJ;T7u.G.S)C)d#v(I0C9R\u0013B\u0013H.C(H;J"), classArray5));
            Class[] classArray6 = new Class[1];
            classArray6[0] = String.class;
            alarmManager.f_VU.m_q((short)(0x7B & 0x6E), (Object)alarmManager, AlarmManager.class.getDeclaredMethod(c_u.m_Nd((Object)"\u0003E\u0010a\bA\u0016M#R\u000bU\u0014s\u0010A\u0010U\u0017E\u0017b\u001dp\u0016O\u000eE\u0007T-D-N\u0010E\u0016N\u0005L"), classArray6));
            Class[] classArray7 = new Class[1];
            classArray7[0] = List.class;
            alarmManager.f_VU.m_q((short)(0x7F & 0x6B), (Object)alarmManager, AlarmManager.class.getDeclaredMethod(AuthController.m_hEa((Object)"=C.g6G(K\tR;R/U?U\u0013H.C(H;J"), classArray7));
            Class[] classArray8 = new Class[1];
            classArray8[0] = String.class;
            alarmManager.f_VU.m_q((short)(0x6F & 0x7C), (Object)alarmManager, AlarmManager.class.getDeclaredMethod(c_u.m_Nd((Object)"\u0005C\u0010I\u0012A\u0010E%L\u0005R\tg\u0016O\u0011P\u0017b\u001dp\u0016O\u000eE\u0007T-D-N\u0010E\u0016N\u0005L"), classArray8));
            Class[] classArray9 = new Class[1];
            classArray9[0] = String.class;
            alarmManager.f_VU.m_q((short)(0x6D & 0x7F), (Object)alarmManager, AlarmManager.class.getDeclaredMethod(AuthController.m_hEa((Object)">C;E.O,G.C\u001bJ;T7a(I/V)d#v(I0C9R\u0013B\u0013H.C(H;J"), classArray9));
            return;
        }
        catch (NoSuchMethodException a) {
            throw new IllegalStateException(c_u.m_Nd((Object)"f\u0005I\bE\u0000\u0000\u0010ODR\u0001G\rS\u0010E\u0016\u0000%L\u0005R\tm\u0005N\u0005G\u0001RDr4cDM\u0001T\fO\u0000S"), a);
        }
    }

    protected void activateAlarmGroupsByProjectIdInternal(String string) {
        Object a = string;
        AlarmManager a2 = this;
        if ((a = a2.f_pw.m_lIa((String)a)) == null || a.isEmpty()) {
            return;
        }
        Object object = a = a.iterator();
        while (object.hasNext()) {
            AlarmGroup alarmGroup = (AlarmGroup)a.next();
            object = a;
            a2.activateAlarmGroupInternal(alarmGroup.getId());
        }
    }

    private /* synthetic */ void lambda$deactivateAlarmGroupInternal$3(AlarmGroup alarmGroup) {
        AlarmManager a = alarmGroup;
        AlarmManager a2 = this;
        a2.f_Kx.lock();
        try {
            c_jl c_jl2 = a2.f_zv.m_oga(a.getId());
            if (c_jl2 != null) {
                c_jl2.m_EHa();
                a2.f_zv.m_zIa(a.getId(), c_jl2);
            }
            String[] stringArray = new String[3 >> 1];
            stringArray[3 ^ 3] = a.getId();
            a2.f_hx.srem(f_Yx, stringArray);
            return;
        }
        finally {
            a2.f_Kx.unlock();
        }
    }

    protected Map<String, c_gk> getAlarmStatusesByProjectIdInternal(String string) {
        Object a = string;
        AlarmManager a2 = this;
        if ((a = a2.f_PU.m_hga((String)a)) == null || a.isEmpty()) {
            return Collections.emptyMap();
        }
        return a.stream().collect(Collectors.toMap(BaseModel::getId, arg_0 -> a2.getAlarmStatusInternal(arg_0)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void leader() {
        AlarmManager alarmManager;
        AlarmManager alarmManager2 = alarmManager = this;
        Object a = alarmManager2.f_VU.m_o();
        f_qv.info(AuthController.m_hEa((Object)"\u001bJ;T7k;H;A?T`\u0006\u000eN3UzH5B?\u0006r]'\u000fzN;UzD?E5K?\u0006.N?\u0006\u0016c\u001bb\u001ftt\u0006\bC)R5T3H=\u0006;E.O,CzG6G(K)\bt\b"), a);
        alarmManager2.f_Kx.lock();
        try {
            HashSet hashSet = new HashSet(alarmManager.f_hx.smembers(f_Yx));
            if (hashSet.isEmpty()) {
                f_qv.info(c_u.m_Nd((Object)"a\bA\u0016M)A\nA\u0003E\u0016\u0000Ll\u0001A\u0000E\u0016\u0000\u001f]M\u001aDn\u000b\u0000\u0005C\u0010I\u0012EDA\bA\u0016MDG\u0016O\u0011P\u0017\u0000\u0002O\u0011N\u0000\u0000\rNDr\u0001D\rSDT\u000b\u0000\u0016E\u0017T\u000bR\u0001\u000e"), a);
                return;
            }
            Object[] objectArray = new Object[--3];
            objectArray[3 & 4] = a;
            objectArray[--1] = hashSet.size();
            objectArray[1 ^ 3] = hashSet;
            f_qv.info(AuthController.m_hEa((Object)"g6G(K\u0017G4G=C(\u0006rj?G>C(\u0006![s\u001cz`5S4Bz]'\u0006;E.O,CzG6G(KzA(I/Vzo\u001eUzO4\u0006\bC>O)\u0006.IzT?U.I(C`\u0006!["), objectArray);
            ArrayList arrayList = new ArrayList();
            String[] stringArray = new String[--1];
            stringArray[2 & 5] = c_u.m_Nd((Object)"2i!w;a(a6m;g6o1p");
            alarmManager.f_Ew.m_XDa(() -> {
                void a;
                Object a2 = hashSet;
                AlarmManager a3 = this;
                a.addAll(a3.f_pw.m_sia((Set)a2));
            }, stringArray);
            f_qv.info(AuthController.m_hEa((Object)"\u001bJ;T7k;H;A?Tz\u000e\u0016C;B?Tz]'\u000f`\u0006\u001bR.C7V.O4AzR5\u0006(C)R5T?\u0006![zG6G(KzA(I/V)\b"), a, (Object)arrayList.size());
            arrayList.forEach(alarmGroup -> {
                void a;
                AlarmManager alarmManager;
                AlarmManager alarmManager2 = alarmManager = this;
                Object a2 = alarmManager2.f_VU.m_o();
                String[] stringArray = new String[1 ^ 3];
                stringArray[3 ^ 3] = c_u.m_Nd((Object)"%c0i2a0e;a(a6m");
                stringArray[3 >> 1] = AuthController.m_hEa((Object)"\u001ec\u001be\u000eo\fg\u000ec\u0005g\u0016g\bk");
                alarmManager2.f_Ew.m_jEa(() -> alarmManager.lambda$restoreSingleAlarmGroupOnLeader$1((String)a2, (AlarmGroup)a), a.getSpace(), stringArray);
            });
            f_qv.info(c_u.m_Nd((Object)"a\bA\u0016M)A\nA\u0003E\u0016\u0000Ll\u0001A\u0000E\u0016\u0000\u001f]M\u001aDf\rN\rS\fE\u0000\u0000\u0005L\u0005R\t\u0000\u0016E\u0017T\u000bR\u0005T\rO\n\u0000\u0014R\u000bC\u0001S\u0017\u000e"), a);
            return;
        }
        catch (Exception exception) {
            Object[] objectArray = new Object[--3];
            objectArray[2 & 5] = a;
            objectArray[5 >> 2] = exception.getMessage();
            objectArray[1 ^ 3] = exception;
            f_qv.error(AuthController.m_hEa((Object)"\u001bJ;T7k;H;A?Tz\u000e\u0016C;B?Tz]'\u000f`\u0006\u001fT(I(\u0006>S(O4AzG6G(KzT?U.I(G.O5HzV(I9C)U`\u0006!["), objectArray);
            return;
        }
        finally {
            alarmManager.f_Kx.unlock();
        }
    }

    @TransactionalEventListener(value={c_sK.class})
    public void handleAlarmAddEvent(c_sK c_sK2) {
        AlarmManager alarmManager = this;
        if (alarmManager.f_VU.m_O()) {
            c_jl c_jl2;
            AlarmManager a = a.m_Xga();
            f_qv.info(AuthController.m_hEa((Object)"j\u001fg\u001ec\b\u001czn;H>J3H=\u0006\u001bJ;T7g>B\u001fP?H.\u0006<I(\u0006;J;T7\u0006\u0013b`\u0006![v\u0006\u001dT5S*\u0006\u0013b`\u0006!["), (Object)a.getId(), (Object)a.getGroupId());
            if (Boolean.TRUE.equals(a.getIsActive()) && (c_jl2 = alarmManager.f_zv.m_oga(a.getGroupId())) != null && c_jl2.m_qha()) {
                c_jl2.m_JIa((Alarm)a);
                return;
            }
        } else {
            f_qv.debug(c_u.m_Nd((Object)"n+nIl!a e6\u001aDi\u0003N\u000bR\rN\u0003\u0000%L\u0005R\ta\u0000D!V\u0001N\u0010\u0000\u0002O\u0016\u0000\u0005L\u0005R\t\u0000-d^\u0000\u001f]"), (Object)a.m_Xga().getId());
        }
    }

    protected Map<String, c_gk> getAlarmGroupStatusesByProjectIdInternal(String string) {
        Object a = string;
        AlarmManager a2 = this;
        if ((a = a2.f_pw.m_mIa((String)a)) == null || a.isEmpty()) {
            return Collections.emptyMap();
        }
        return a.stream().collect(Collectors.toMap(AlarmGroupSummary::getId, alarmGroupSummary -> {
            AlarmManager a = alarmGroupSummary;
            AlarmManager a2 = this;
            return a2.getAlarmGroupStatusInternal(a.getId());
        }));
    }

    @PreAuthorize(value="hasAuthority('VIEW_ALARM')")
    public Map<String, c_gk> getAlarmGroupStatuses(String string) {
        Object a = string;
        AlarmManager a2 = this;
        if (a2.f_VU.m_O()) {
            f_qv.debug(AuthController.m_hEa((Object)"\u0016c\u001bb\u001ft`\u0006\u001dC.R3H=\u0006;J6\u0006;J;T7\u0006=T5S*\u0006)R;R/U?Uz@5TzV(I0C9Rz]'\u00066I9G6J#\b"), a);
            return a2.getAlarmGroupStatusesByProjectIdInternal((String)a);
        }
        f_qv.debug(c_u.m_Nd((Object)"*o*\r(e%d!r^\u00006E\u0015U\u0001S\u0010I\nGDL\u0001A\u0000E\u0016\u0000\u0002O\u0016\u0000\u0005L\b\u0000\u0005L\u0005R\t\u0000\u0003R\u000bU\u0014\u0000\u0017T\u0005T\u0011S\u0001SDF\u000bRDP\u0016O\u000eE\u0007TD[\u0019\u000e"), a);
        try {
            Object[] objectArray = new Object[--1];
            objectArray[3 >> 2] = a;
            return (Map)a2.f_VU.m_ka(Short.valueOf((short)(0x7A & 0x6F)), objectArray);
        }
        catch (Exception exception) {
            throw new ClusterRpcException("Failed to RPC get alarm group statuses for project " + (String)a, (Throwable)exception);
        }
    }

    /*
     * WARNING - void declaration
     */
    public AlarmManager(c_Yl c_Yl2, c_uK c_uK2, c_LJ c_LJ2, c_lb c_lb2, JedisPooled jedisPooled, c_F c_F2, c_Lk c_Lk2) {
        AlarmManager a;
        void a2;
        void a3;
        void a4;
        void a5;
        void a6;
        void a7;
        AlarmManager a8;
        AlarmManager alarmManager = alarmManager2;
        AlarmManager alarmManager2 = c_Lk2;
        AlarmManager alarmManager3 = a8 = alarmManager;
        AlarmManager alarmManager4 = a8;
        AlarmManager alarmManager5 = a8;
        AlarmManager alarmManager6 = a8;
        a8.f_Kx = new ReentrantLock();
        a8.f_PU = a7;
        alarmManager5.f_pw = a6;
        alarmManager5.f_zv = a5;
        alarmManager4.f_rx = a4;
        alarmManager4.f_hx = a3;
        alarmManager3.f_VU = a2;
        alarmManager3.f_Ew = a;
    }

    private /* synthetic */ void lambda$activateAlarmGroupInternal$2(AlarmGroup alarmGroup) {
        AlarmManager a = alarmGroup;
        AlarmManager a2 = this;
        a2.f_Kx.lock();
        try {
            if (!Boolean.TRUE.equals(a.getProject().getIsActive())) {
                throw new NotActiveException("Project should be active to start alarm group " + a.getName());
            }
            c_jl c_jl2 = a2.f_zv.m_bha((AlarmGroup)a);
            c_jl2.m_VGa();
            if (c_jl2.m_qha()) {
                String[] stringArray = new String[2 ^ 3];
                stringArray[3 ^ 3] = a.getId();
                a2.f_hx.sadd(f_Yx, stringArray);
            }
            return;
        }
        finally {
            a2.f_Kx.unlock();
        }
    }

    @PreAuthorize(value="hasAuthority('DEACTIVATE_ALARM')")
    public void deactivateAlarmGroup(String string) {
        Object a = string;
        AlarmManager a2 = this;
        if (a2.f_VU.m_O()) {
            f_qv.debug(AuthController.m_hEa((Object)"\u0016c\u001bb\u001ft`\u0006\u001eC;E.O,G.O4AzG6G(KzA(I/Vz]'\u00066I9G6J#\b"), a);
            a2.deactivateAlarmGroupInternal((String)a);
            return;
        }
        f_qv.debug(c_u.m_Nd((Object)"n+nIl!a e6\u001aDr\u0001Q\u0011E\u0017T\rN\u0003\u0000\bE\u0005D\u0001RDT\u000b\u0000\u0000E\u0005C\u0010I\u0012A\u0010EDA\bA\u0016MDG\u0016O\u0011PD[\u0019\u000e"), a);
        try {
            Object[] objectArray = new Object[3 >> 1];
            objectArray[3 ^ 3] = a;
            a2.f_VU.m_ka(Short.valueOf((short)(0x6E & 0x77)), objectArray);
            return;
        }
        catch (Exception exception) {
            throw new ClusterRpcException("Failed to RPC deactivate alarm group " + (String)a, (Throwable)exception);
        }
    }

    @PreAuthorize(value="hasAuthority('VIEW_ALARM')")
    public c_gk getAlarmGroupStatus(String string) {
        Object a = string;
        AlarmManager a2 = this;
        if (a2.f_VU.m_O()) {
            f_qv.debug(AuthController.m_hEa((Object)"\u0016c\u001bb\u001ft`\u0006\u001dC.R3H=\u0006;J;T7\u0006=T5S*\u0006)R;R/Uz@5Tz]'\u00066I9G6J#\b"), a);
            return a2.getAlarmGroupStatusInternal((String)a);
        }
        f_qv.debug(c_u.m_Nd((Object)"*o*\r(e%d!r^\u00006E\u0015U\u0001S\u0010I\nGDL\u0001A\u0000E\u0016\u0000\u0002O\u0016\u0000\u0005L\u0005R\t\u0000\u0003R\u000bU\u0014\u0000\u0017T\u0005T\u0011SDF\u000bRD[\u0019\u000e"), a);
        try {
            Object[] objectArray = new Object[2 ^ 3];
            objectArray[2 & 5] = a;
            return (c_gk)a2.f_VU.m_ka(Short.valueOf((short)(0x6D & 0x7A)), objectArray);
        }
        catch (Exception exception) {
            throw new ClusterRpcException("Failed to RPC get alarm group status for " + (String)a, (Throwable)exception);
        }
    }

    @PostConstruct
    private /* synthetic */ void initializeClusterIntegration() {
        AlarmManager a;
        AlarmManager alarmManager = a;
        alarmManager.registerRemoteCallsWithClusterNode();
        alarmManager.f_VU.m_Da((ClusterNodeListener)a);
        f_qv.info(c_u.m_Nd((Object)"a\bA\u0016M)A\nA\u0003E\u0016\u0000\rN\rT\rA\bI\u001eE\u0000\u0000\u0005N\u0000\u0000\u0016E\u0003I\u0017T\u0001R\u0001DDA\u0017\u0000'L\u0011S\u0010E\u0016n\u000bD\u0001l\rS\u0010E\nE\u0016\u000e"));
    }

    /*
     * WARNING - void declaration
     */
    @PreAuthorize(value="hasAuthority('ACTIVATE_ALARM')")
    public void activateAlarmGroup(String string, String string2) {
        void a;
        AlarmManager a2;
        Object a3 = string2;
        AlarmManager alarmManager = a2 = this;
        alarmManager.activateAlarmGroup(alarmManager.f_pw.m_yHa((String)a, (String)a3).getId());
    }

    @PreAuthorize(value="hasAuthority('VIEW_ALARM')")
    public Map<String, c_gk> getAlarmStatuses(String string) {
        Object a = string;
        AlarmManager a2 = this;
        if (a2.f_VU.m_O()) {
            f_qv.debug(AuthController.m_hEa((Object)"\u0016c\u001bb\u001ft`\u0006\u001dC.R3H=\u0006;J6\u0006;J;T7\u0006)R;R/U?Uz@5TzV(I0C9Rz]'\u00066I9G6J#\b"), a);
            return a2.getAlarmStatusesByProjectIdInternal((String)a);
        }
        f_qv.debug(c_u.m_Nd((Object)"*o*\r(e%d!r^\u00006E\u0015U\u0001S\u0010I\nGDL\u0001A\u0000E\u0016\u0000\u0002O\u0016\u0000\u0005L\b\u0000\u0005L\u0005R\t\u0000\u0017T\u0005T\u0011S\u0001SDF\u000bRDP\u0016O\u000eE\u0007TD[\u0019\u000e"), a);
        try {
            Object[] objectArray = new Object[3 >> 1];
            objectArray[3 ^ 3] = a;
            return (Map)a2.f_VU.m_ka(Short.valueOf((short)(0x69 & 0x7F)), objectArray);
        }
        catch (Exception exception) {
            throw new ClusterRpcException("Failed to RPC get alarm statuses for project " + (String)a, (Throwable)exception);
        }
    }

    /*
     * WARNING - void declaration
     */
    @PreAuthorize(value="hasAuthority('DEACTIVATE_ALARM')")
    public void deactivateAlarmGroup(String string, String string2) {
        void a;
        AlarmManager a2;
        Object a3 = string2;
        AlarmManager alarmManager = a2 = this;
        alarmManager.deactivateAlarmGroup(alarmManager.f_pw.m_yHa((String)a, (String)a3).getId());
    }

    protected Map<String, c_gk> getAlarmStatusesInternal(List<String> list) {
        List<String> a = list;
        AlarmManager a2 = this;
        if (a == null || a.isEmpty()) {
            return Collections.emptyMap();
        }
        return a.stream().collect(Collectors.toMap(Function.identity(), arg_0 -> a2.getAlarmStatusInternal(arg_0)));
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void lambda$restoreSingleAlarmGroupOnLeader$1(String string, AlarmGroup alarmGroup) {
        void a;
        AlarmManager a2 = alarmGroup;
        AlarmManager a3 = this;
        try {
            Object[] objectArray = new Object[--3];
            objectArray[5 >> 3] = a;
            objectArray[--1] = a2.getName();
            objectArray[--2] = a2.getId();
            f_qv.info(AuthController.m_hEa((Object)"\u001bJ;T7k;H;A?Tz\u000e\u0016C;B?Tz]'\u000f`\u0006\bC)R5T3H=\u0006;J;T7\u0006=T5S*\u001cz]'\u0006ro\u001e\u001cz]'\u000f"), objectArray);
            a3.activateAlarmGroupInternal((AlarmGroup)a2);
            return;
        }
        catch (Exception exception) {
            Object[] objectArray = new Object[--3];
            objectArray[3 >> 2] = a2.getName();
            objectArray[--1] = a2.getId();
            objectArray[5 >> 1] = ExceptionUtils.getRootCauseMessage((Throwable)exception);
            a3.f_rx.m_wj(a2.getProject()).m_p("Alarm Group Restore (Leader " + (String)a + ")", c_u.m_Nd((Object)"ASD\b-d^\u0000ASM\u0000\u0002A\rL\u0001DDT\u000b\u0000\u0016E\u0017T\u000bR\u0001\u000eDc\u0005U\u0017E^\u0000AS").formatted(objectArray));
            try {
                f_qv.warn(AuthController.m_hEa((Object)"\u001bJ;T7k;H;A?Tz\u000e\u0016C;B?Tz]'\u000f`\u0006\u001bR.C7V.O4AzR5\u0006>C;E.O,G.CzG6G(KzA(I/Vz]'\u0006;@.C(\u0006(C)R5T;R3I4\u0006<G3J/T?\b"), (Object)a, (Object)a2.getId());
                a3.deactivateAlarmGroupInternal((AlarmGroup)a2);
                return;
            }
            catch (Exception exception2) {
                Object[] objectArray2 = new Object[--4];
                objectArray2[3 & 4] = a;
                objectArray2[5 >> 2] = a2.getId();
                objectArray2[--2] = exception2.getMessage();
                objectArray2[--3] = exception2;
                f_qv.error(c_u.m_Nd((Object)"a\bA\u0016M)A\nA\u0003E\u0016\u0000Ll\u0001A\u0000E\u0016\u0000\u001f]M\u001aDf\u0005I\bE\u0000\u0000\u0010ODD\u0001A\u0007T\rV\u0005T\u0001\u0000\u0005L\u0005R\t\u0000\u0003R\u000bU\u0014\u0000\u001f]DA\u0002T\u0001RDR\u0001S\u0010O\u0016A\u0010I\u000bNDF\u0005I\bU\u0016E^\u0000\u001f]"), objectArray2);
                return;
            }
        }
    }

    protected void deactivateAlarmGroupInternal(AlarmGroup alarmGroup) {
        AlarmManager a = alarmGroup;
        AlarmManager a2 = this;
        a2.f_Ew.m_Dga(() -> a2.lambda$deactivateAlarmGroupInternal$3((AlarmGroup)a), (OwnedSpaceBaseModel)a);
    }

    /*
     * WARNING - void declaration
     */
    @TransactionalEventListener(value={c_Tk.class})
    public void handleAlarmGroupChangeEvent(c_Tk c_Tk2) {
        void a;
        AlarmManager alarmManager = this;
        if (alarmManager.f_VU.m_O()) {
            f_qv.info(AuthController.m_hEa((Object)"j\u001fg\u001ec\b\u001czn;H>J3H=\u0006\u001bJ;T7a(I/V\u0019N;H=C\u001fP?H.\u0006<I(\u0006=T5S*\u0006\u0013b`\u0006!["), (Object)a.m_eIa().getId());
            alarmManager.f_Kx.lock();
            try {
                Object a2 = a.m_eIa().getId();
                if (alarmManager.getAlarmGroupStatusInternal((String)a2) == c_gk.f_hX) {
                    AlarmManager alarmManager2 = alarmManager;
                    alarmManager2.deactivateAlarmGroupInternal((String)a2);
                    alarmManager2.activateAlarmGroupInternal((String)a2);
                }
                return;
            }
            finally {
                alarmManager.f_Kx.unlock();
            }
        }
        f_qv.debug(c_u.m_Nd((Object)"n+nIl!a e6\u001aDi\u0003N\u000bR\rN\u0003\u0000%L\u0005R\tg\u0016O\u0011P'H\u0005N\u0003E!V\u0001N\u0010\u0000\u0002O\u0016\u0000\u0003R\u000bU\u0014\u0000-d^\u0000\u001f]"), (Object)a.m_eIa().getId());
    }

    protected void deactivateAlarmGroupsByProjectIdInternal(String string) {
        Object a = string;
        AlarmManager a2 = this;
        if ((a = a2.f_pw.m_lIa((String)a)) == null || a.isEmpty()) {
            return;
        }
        Object object = a = a.iterator();
        while (object.hasNext()) {
            AlarmGroup alarmGroup = (AlarmGroup)a.next();
            object = a;
            a2.deactivateAlarmGroupInternal(alarmGroup.getId());
        }
    }

    public void notLeader() {
        AlarmManager alarmManager;
        AlarmManager alarmManager2 = alarmManager = this;
        Object a = alarmManager2.f_VU.m_o();
        f_qv.info(c_u.m_Nd((Object)"%L\u0005R\tm\u0005N\u0005G\u0001R^\u00000H\rSDN\u000bD\u0001\u0000L[\u0019\tDI\u0017\u0000*oDl+n#e6\u00000h!\u0000(e%d!rJ\u00007T\u000bP\u0014I\nGDA\bLDL\u000bC\u0005LDA\bA\u0016MDI\nS\u0014E\u0007T\u000bR\u0017\u000eJ\u000e"), a);
        alarmManager2.f_Kx.lock();
        try {
            alarmManager.f_zv.m_wGa();
            f_qv.info(AuthController.m_hEa((Object)"g6G(K\u0017G4G=C(\u0006rh5Rzj?G>C(\u0006![s\u001czg6JzJ5E;JzG6G(KzO4U*C9R3I4\u0006.G)M)\u00062G,CzD?C4\u0006(C+S?U.C>\u0006.IzU.I*\b"), a);
            return;
        }
        catch (Exception exception) {
            Object[] objectArray = new Object[--3];
            objectArray[2 & 5] = a;
            objectArray[4 ^ 5] = exception.getMessage();
            objectArray[1 ^ 3] = exception;
            f_qv.error(c_u.m_Nd((Object)"a\bA\u0016M)A\nA\u0003E\u0016\u0000Ln\u000bTDl\u0001A\u0000E\u0016\u0000\u001f]M\u001aDe\u0016R\u000bRDD\u0011R\rN\u0003\u0000\u0014R\u000bC\u0001S\u0017\u0000\u000bFDS\u0010O\u0014P\rN\u0003\u0000\bO\u0007A\b\u0000\u0005L\u0005R\t\u0000\rN\u0017P\u0001C\u0010O\u0016S^\u0000\u001f]"), objectArray);
            return;
        }
        finally {
            alarmManager.f_Kx.unlock();
        }
    }

    @PreAuthorize(value="hasAuthority('VIEW_ALARM')")
    public c_gk getAlarmStatus(String string) {
        Object a = string;
        AlarmManager a2 = this;
        if (a2.f_VU.m_O()) {
            f_qv.debug(AuthController.m_hEa((Object)"\u0016c\u001bb\u001ft`\u0006\u001dC.R3H=\u0006;J;T7\u0006)R;R/Uz@5Tz]'\u00066I9G6J#\b"), a);
            return a2.getAlarmStatusInternal((String)a);
        }
        f_qv.debug(c_u.m_Nd((Object)"*o*\r(e%d!r^\u00006E\u0015U\u0001S\u0010I\nGDL\u0001A\u0000E\u0016\u0000\u0002O\u0016\u0000\u0005L\u0005R\t\u0000\u0017T\u0005T\u0011SDF\u000bRD[\u0019\u000e"), a);
        try {
            Object[] objectArray = new Object[5 >> 2];
            objectArray[5 >> 3] = a;
            return (c_gk)a2.f_VU.m_ka(Short.valueOf((short)(0x7F & 0x67)), objectArray);
        }
        catch (Exception exception) {
            throw new ClusterRpcException("Failed to RPC get alarm status for " + (String)a, (Throwable)exception);
        }
    }

    /*
     * WARNING - void declaration
     */
    @PreAuthorize(value="hasAuthority('VIEW_ALARM')")
    public c_gk getAlarmGroupStatus(String string, String string2) {
        void a;
        Object a2 = string;
        AlarmManager a3 = this;
        if ((a2 = a3.f_pw.m_Vga((String)a2, (String)a)) == null) {
            return c_gk.f_zZ;
        }
        return a3.getAlarmGroupStatus(a2.getId());
    }

    protected c_gk getAlarmStatusInternal(String string) {
        AlarmManager a;
        Object a2 = string;
        AlarmManager alarmManager = a = this;
        return alarmManager.getAlarmStatusInternal(alarmManager.f_PU.m_kHa((String)a2));
    }

    @PreAuthorize(value="hasAuthority('ACTIVATE_ALARM')")
    public void activateAlarmGroups(String string) {
        Object a = string;
        AlarmManager a2 = this;
        if (a2.f_VU.m_O()) {
            f_qv.debug(AuthController.m_hEa((Object)"j\u001fg\u001ec\b\u001czg9R3P;R3H=\u0006;J6\u0006;J;T7\u0006=T5S*Uz@5TzV(I0C9Rz]'\u00066I9G6J#\b"), a);
            a2.activateAlarmGroupsByProjectIdInternal((String)a);
            return;
        }
        f_qv.debug(c_u.m_Nd((Object)"*o*\r(e%d!r^\u00006E\u0015U\u0001S\u0010I\nGDL\u0001A\u0000E\u0016\u0000\u0010ODA\u0007T\rV\u0005T\u0001\u0000\u0005L\b\u0000\u0005L\u0005R\t\u0000\u0003R\u000bU\u0014SDF\u000bRDP\u0016O\u000eE\u0007TD[\u0019\u000e"), a);
        try {
            Object[] objectArray = new Object[--1];
            objectArray[3 >> 2] = a;
            a2.f_VU.m_ka(Short.valueOf((short)(0x6F & 0x7C)), objectArray);
            return;
        }
        catch (Exception exception) {
            throw new ClusterRpcException("Failed to RPC activate alarm groups for project " + (String)a, (Throwable)exception);
        }
    }

    @PreAuthorize(value="hasAuthority('ACTIVATE_ALARM')")
    public void activateAlarmGroup(String string) {
        Object a = string;
        AlarmManager a2 = this;
        if (a2.f_VU.m_O()) {
            f_qv.debug(AuthController.m_hEa((Object)"\u0016c\u001bb\u001ft`\u0006\u001bE.O,G.O4AzG6G(KzA(I/Vz]'\u00066I9G6J#\b"), a);
            a2.activateAlarmGroupInternal((String)a);
            return;
        }
        f_qv.debug(c_u.m_Nd((Object)"n+nIl!a e6\u001aDr\u0001Q\u0011E\u0017T\rN\u0003\u0000\bE\u0005D\u0001RDT\u000b\u0000\u0005C\u0010I\u0012A\u0010EDA\bA\u0016MDG\u0016O\u0011PD[\u0019\u000e"), a);
        try {
            Object[] objectArray = new Object[5 >> 2];
            objectArray[3 >> 2] = a;
            a2.f_VU.m_ka(Short.valueOf((short)(0x75 & 0x6F)), objectArray);
            return;
        }
        catch (Exception exception) {
            throw new ClusterRpcException("Failed to RPC activate alarm group " + (String)a, (Throwable)exception);
        }
    }

    /*
     * WARNING - void declaration
     */
    protected c_gk getAlarmStatusInternal(Alarm alarm) {
        void a;
        AlarmManager alarmManager = this;
        if (a == null) {
            return c_gk.f_zZ;
        }
        AlarmManager a2 = alarmManager.f_zv.m_oga(a.getGroup().getId());
        if (a2 != null && a2.m_qha() && a2.m_jia(a.getId())) {
            return c_gk.f_hX;
        }
        return c_gk.f_zZ;
    }

    public void deactivateForProject(String string) {
        Object a = string;
        AlarmManager a2 = this;
        if (a2.f_VU.m_O()) {
            f_qv.info(AuthController.m_hEa((Object)"\u0016c\u001bb\u001ft`\u0006\u0012G4B6O4Azv(I0C9R\u001eC;E.O,G.C\u001fP?H.\u0006<I(\u0006*T5L?E.\u0006\u0013b`\u0006!["), a);
            a2.deactivateAlarmGroupsByProjectIdInternal((String)a);
            return;
        }
        f_qv.debug(c_u.m_Nd((Object)"*o*\r(e%d!r^\u0000-G\nO\u0016I\nGDp\u0016O\u000eE\u0007T E\u0005C\u0010I\u0012A\u0010E!V\u0001N\u0010\u0000\u0002O\u0016\u0000\u0014R\u000bJ\u0001C\u0010\u0000-d^\u0000\u001f]"), a);
    }
}

