/*
 * Decompiled with CFR 0.152.
 */
package com.inscada.mono.alarm.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.inscada.mono.alarm.b.c_wL;
import com.inscada.mono.alarm.model.Alarm;
import com.inscada.mono.communication.base.model.Variable;
import com.inscada.mono.communication.base.model.VariableView;
import com.inscada.mono.shared.validations.CheckAtLeastOneNotNull;
import com.inscada.mono.shared.validations.CheckAtLeastOneNotNull$List;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.Table;
import org.hibernate.annotations.SQLRestriction;

@Entity
@Table(name="analog_alarm")
@CheckAtLeastOneNotNull$List(value={@CheckAtLeastOneNotNull(fieldNames={"variableId", "variable"}), @CheckAtLeastOneNotNull(fieldNames={"setPointValue", "highHighValue", "highValue", "lowValue", "lowLowValue"})})
public class AnalogAlarm
extends Alarm {
    @Column(name="high_high_value")
    private Double highHighValue;
    @Column(name="low_low_value")
    private Double lowLowValue;
    @JsonIgnore
    @ManyToOne(optional=false)
    @SQLRestriction(value="deleted_dttm IS NULL")
    @JoinColumn(name="variable_id", insertable=false, updatable=false)
    private VariableView variable;
    @Column(name="deviation_percentage")
    private Double deviationPercentage;
    @Column(name="high_value")
    private Double highValue;
    @Column(name="dead_band")
    private Double deadband;
    @Column(name="low_value")
    private Double lowValue;
    @Column(name="set_point_value")
    private Double setPointValue;
    @Column(name="variable_id")
    private String variableId;

    public void setLowValue(Double d) {
        Object a = d;
        AnalogAlarm a2 = this;
        a2.lowValue = a;
    }

    public c_wL getType() {
        return c_wL.f_Rz;
    }

    public VariableView getVariable() {
        AnalogAlarm a;
        return a.variable;
    }

    public AnalogAlarm() {
        AnalogAlarm a;
    }

    public Double getLowValue() {
        AnalogAlarm a;
        return a.lowValue;
    }

    public Double getHighHighValue() {
        AnalogAlarm a;
        return a.highHighValue;
    }

    public void setHighValue(Double d) {
        Object a = d;
        AnalogAlarm a2 = this;
        a2.highValue = a;
    }

    public Double getDeviationPercentage() {
        AnalogAlarm a;
        return a.deviationPercentage;
    }

    public Double getDeadband() {
        AnalogAlarm a;
        return a.deadband;
    }

    public void setDeadband(Double d) {
        Object a = d;
        AnalogAlarm a2 = this;
        a2.deadband = a;
    }

    public void setVariable(Variable<?, ?, ?> variable) {
        Variable<?, ?, ?> a = variable;
        Variable<?, ?, ?> a2 = this;
        if (a != null) {
            Variable<?, ?, ?> variable2 = a2;
            variable2.variableId = a.getId();
            variable2.variable = VariableView.from(a);
            return;
        }
        a2.variableId = null;
        a2.variable = null;
    }

    public void setLowLowValue(Double d) {
        Object a = d;
        AnalogAlarm a2 = this;
        a2.lowLowValue = a;
    }

    public void setVariableId(String string) {
        Object a = string;
        AnalogAlarm a2 = this;
        a2.variableId = a;
    }

    @JsonSetter
    public void setVariable(VariableView variableView) {
        AnalogAlarm a = variableView;
        AnalogAlarm a2 = this;
        a2.variable = a;
        if (a2.variable != null) {
            a2.variableId = a.getId();
            return;
        }
        a2.variableId = null;
    }

    public Double getLowLowValue() {
        AnalogAlarm a;
        return a.lowLowValue;
    }

    public void setDeviationPercentage(Double d) {
        Object a = d;
        AnalogAlarm a2 = this;
        a2.deviationPercentage = a;
    }

    public String getVariableId() {
        AnalogAlarm a;
        return a.variableId;
    }

    public void setSetPointValue(Double d) {
        Object a = d;
        AnalogAlarm a2 = this;
        a2.setPointValue = a;
    }

    public Double getHighValue() {
        AnalogAlarm a;
        return a.highValue;
    }

    public Double getSetPointValue() {
        AnalogAlarm a;
        return a.setPointValue;
    }

    public void setHighHighValue(Double d) {
        Object a = d;
        AnalogAlarm a2 = this;
        a2.highHighValue = a;
    }
}

