/*
 * Decompiled with CFR 0.152.
 */
package com.inscada.mono.user.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.inscada.mono.menu.model.Menu;
import com.inscada.mono.shared.model.BaseModel;
import com.inscada.mono.space.model.Space;
import com.inscada.mono.user.model.Permission;
import com.inscada.mono.user.model.Role;
import com.inscada.mono.user.p.c_q;
import jakarta.persistence.AttributeOverride;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.FetchType;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.JoinTable;
import jakarta.persistence.ManyToMany;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.Table;
import jakarta.persistence.Transient;
import jakarta.validation.constraints.Email;
import jakarta.validation.constraints.NotBlank;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Size;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.hibernate.annotations.SQLRestriction;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.authority.AuthorityUtils;

@Entity
@Table(name="users")
@AttributeOverride(name="id", column=@Column(name="user_id", length=36, nullable=false, updatable=false))
public class User
extends BaseModel {
    @Transient
    @JsonProperty(access=JsonProperty.Access.READ_ONLY)
    private String passwordResetUrl;
    @JsonProperty(access=JsonProperty.Access.READ_ONLY)
    @Column(name="eula_accepted")
    private Boolean eulaAccepted;
    @Column(name="otp_type")
    private c_q otpType;
    @NotBlank
    @Size(max=50)
    @Column(updatable=false)
    private String username;
    @JsonIgnore
    @ManyToMany(fetch=FetchType.LAZY)
    @JoinTable(name="role_members", joinColumns={@JoinColumn(name="user_id")}, inverseJoinColumns={@JoinColumn(name="role_id")})
    @SQLRestriction(value="deleted_dttm IS NULL")
    private Set<Role> roles;
    @Transient
    @JsonProperty(access=JsonProperty.Access.READ_ONLY)
    private String passwordResetToken;
    @JsonIgnore
    @ManyToOne
    @SQLRestriction(value="deleted_dttm IS NULL")
    @JoinColumn(name="default_space_id")
    private Space defaultSpace;
    @NotNull
    @Column(name="require_password_reset")
    private Boolean requirePasswordReset;
    @JsonIgnore
    @Size(max=60)
    @Column(name="passwd")
    private String password;
    @JsonIgnore
    @ManyToMany(fetch=FetchType.LAZY)
    @JoinTable(name="space_users", joinColumns={@JoinColumn(name="user_id")}, inverseJoinColumns={@JoinColumn(name="space_id")})
    @SQLRestriction(value="deleted_dttm IS NULL")
    private Set<Space> spaces;
    @Size(max=15)
    private String phone;
    @Email
    @Size(max=255)
    private String email;

    public int hashCode() {
        User a;
        Object[] objectArray = new Object[3 & 5];
        objectArray[3 & 4] = a.getUsername();
        return Objects.hash(objectArray);
    }

    private static /* synthetic */ boolean lambda$removeSpace$1(String string, Space space) {
        String a = space;
        String a2 = string;
        return a.getId().equals(a2);
    }

    @JsonIgnore
    public List<GrantedAuthority> getAuthorities() {
        User a2;
        return AuthorityUtils.createAuthorityList((String[])((String[])a2.getRoles().stream().flatMap(a -> a.getPermissions().stream()).map(Permission::getName).distinct().toArray(String[]::new)));
    }

    public String getEmail() {
        User a;
        return a.email;
    }

    @JsonIgnore
    public List<String> getRoleNames() {
        User a;
        return a.getRoles().stream().map(Role::getName).collect(Collectors.toList());
    }

    public void setRequirePasswordReset(Boolean bl) {
        Object a = bl;
        User a2 = this;
        a2.requirePasswordReset = a;
    }

    public Set<Role> getRoles() {
        User a;
        return a.roles;
    }

    public void setDefaultSpace(Space space) {
        User a = space;
        User a2 = this;
        a2.defaultSpace = a;
    }

    public void setPasswordResetToken(String string) {
        Object a = string;
        User a2 = this;
        a2.passwordResetToken = a;
    }

    public boolean equals(Object object) {
        User a = this;
        Object a2 = object;
        if (a == a2) {
            return (3 & 5) != 0;
        }
        if (!(a2 instanceof User)) {
            return false;
        }
        Object object2 = a2;
        return a.getUsername().equals(object2.getUsername());
    }

    public void setOtpType(c_q c_q2) {
        User a = c_q2;
        User a2 = this;
        a2.otpType = a;
    }

    public void setEulaAccepted(Boolean bl) {
        Object a = bl;
        User a2 = this;
        a2.eulaAccepted = a;
    }

    public c_q getOtpType() {
        User a;
        return a.otpType;
    }

    public Space getDefaultSpace() {
        User a;
        return a.defaultSpace;
    }

    private static /* synthetic */ boolean lambda$removeRole$0(String string, Role role) {
        String a = role;
        String a2 = string;
        return a.getId().equals(a2);
    }

    public void addRole(Role role) {
        User a = role;
        User a2 = this;
        a2.roles.add(a);
        a.getUsers().add(a2);
    }

    public Boolean getEulaAccepted() {
        User a;
        return a.eulaAccepted;
    }

    public Set<Space> getSpaces() {
        User a;
        return a.spaces;
    }

    public String getPassword() {
        User a;
        return a.password;
    }

    public void addSpace(Space space) {
        User a = space;
        User a2 = this;
        a2.spaces.add(a);
        a.getUsers().add(a2);
    }

    public Boolean getRequirePasswordReset() {
        User a;
        return a.requirePasswordReset;
    }

    @JsonIgnore
    public List<String> getMenus() {
        User a2;
        return a2.getRoles().stream().flatMap(a -> a.getMenus().stream()).map(Menu::getName).distinct().collect(Collectors.toList());
    }

    public void removeRole(String string) {
        Object a = string;
        User a2 = this;
        a = a2.roles.stream().filter(arg_0 -> User.lambda$removeRole$0((String)a, arg_0)).findFirst();
        if (((Optional)a).isPresent()) {
            Object object = a;
            a2.roles.remove(((Optional)object).get());
            ((Role)((Optional)object).get()).getUsers().remove(a2);
        }
    }

    public void setRoles(Set<Role> set) {
        Object a = set;
        User a2 = this;
        a2.roles = a;
    }

    public String getPhone() {
        User a;
        return a.phone;
    }

    public void setPasswordResetUrl(String string) {
        Object a = string;
        User a2 = this;
        a2.passwordResetUrl = a;
    }

    public String getPasswordResetToken() {
        User a;
        return a.passwordResetToken;
    }

    public void removeSpace(String string) {
        Object a = string;
        User a2 = this;
        a = a2.spaces.stream().filter(arg_0 -> User.lambda$removeSpace$1((String)a, arg_0)).findFirst();
        if (((Optional)a).isPresent()) {
            Object object = a;
            a2.spaces.remove(((Optional)object).get());
            ((Space)((Optional)object).get()).getUsers().remove(a2);
        }
    }

    public void setUsername(String string) {
        Object a = string;
        User a2 = this;
        a2.username = a;
    }

    @JsonIgnore
    public List<String> getSpaceNames() {
        User a;
        return a.getSpaces().stream().map(Space::getName).collect(Collectors.toList());
    }

    public void setPhone(String string) {
        Object a = string;
        User a2 = this;
        a2.phone = a;
    }

    public void setSpaces(Set<Space> set) {
        Object a = set;
        User a2 = this;
        a2.spaces = a;
    }

    public String getPasswordResetUrl() {
        User a;
        return a.passwordResetUrl;
    }

    public void setPassword(String string) {
        Object a = string;
        User a2 = this;
        a2.password = a;
    }

    public String getUsername() {
        User a;
        return a.username;
    }

    public void remove() {
        User a;
        Iterator iterator;
        User user = this;
        Iterator iterator2 = iterator = new HashSet(user.roles).iterator();
        while (iterator2.hasNext()) {
            a = (Role)iterator.next();
            iterator2 = iterator;
            user.roles.remove(a);
            a.getUsers().remove(user);
        }
        iterator = new HashSet(user.spaces).iterator();
        Iterator iterator3 = iterator;
        while (iterator3.hasNext()) {
            a = (Space)iterator.next();
            iterator3 = iterator;
            user.spaces.remove(a);
            a.getUsers().remove(user);
        }
    }

    public void setEmail(String string) {
        Object a = string;
        User a2 = this;
        a2.email = a;
    }

    public User() {
        User a;
        User user = a;
        a.roles = new HashSet();
        user.spaces = new HashSet();
    }
}

