/*
 * Decompiled with CFR 0.152.
 */
package com.inscada.mono.trend.repositories;

import com.inscada.mono.shared.aspects.EnableSpaceFilter;
import com.inscada.mono.shared.repositories.BaseJpaRepository;
import com.inscada.mono.trend.model.TrendTag;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;

@EnableSpaceFilter
public interface TrendTagRepository
extends BaseJpaRepository<TrendTag> {
    @Query(value="select t from TrendTag t left join fetch t.trend trend left join fetch t.variable variable where trend.id = :trendId and t.id = :tagId")
    public Optional<TrendTag> findOneByTrendIdAndId(@Param(value="trendId") String var1, @Param(value="tagId") String var2);

    @Query(value="select distinct t from TrendTag t left join fetch t.trend trend left join fetch t.variable variable where trend.id in :trendIds")
    public List<TrendTag> findByTrendIdIn(@Param(value="trendIds") Iterable<String> var1);

    @Query(value="select t from TrendTag t left join fetch t.trend trend left join fetch t.variable variable where trend.id = :trendId and t.name = :name")
    public Optional<TrendTag> findOneByTrendIdAndName(@Param(value="trendId") String var1, @Param(value="name") String var2);

    @Query(value="select distinct t from TrendTag t left join fetch t.trend trend left join fetch t.variable variable where trend.id = :trendId and t.name in :names")
    public List<TrendTag> findByTrendIdAndNameIn(@Param(value="trendId") String var1, @Param(value="names") Set<String> var2);

    @Query(value="select distinct t from TrendTag t left join fetch t.trend trend left join fetch t.variable variable where trend.id = :trendId")
    public List<TrendTag> findByTrendId(@Param(value="trendId") String var1);
}

