/*
 * Decompiled with CFR 0.152.
 */
package com.inscada.mono.shared.repositories;

import com.inscada.mono.c_ql;
import com.inscada.mono.project.q.c_Tb;
import com.inscada.mono.shared.model.BaseModel;
import com.inscada.mono.shared.repositories.BaseJpaRepository;
import com.inscada.mono.shared.s.c_tB;
import jakarta.persistence.EntityManager;
import jakarta.persistence.criteria.CriteriaBuilder;
import jakarta.persistence.criteria.CriteriaDelete;
import jakarta.persistence.criteria.Expression;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.data.domain.AuditorAware;
import org.springframework.data.jpa.repository.support.JpaEntityInformation;
import org.springframework.data.jpa.repository.support.SimpleJpaRepository;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

public class BaseJpaRepositoryImpl<T extends BaseModel>
extends SimpleJpaRepository<T, String>
implements BaseJpaRepository<T> {
    private final EntityManager entityManager;
    private final AuditorAware<String> auditorAware;
    private final int batchSize;

    @Transactional
    public void deleteAll() {
        BaseJpaRepositoryImpl a;
        BaseJpaRepositoryImpl baseJpaRepositoryImpl = a;
        baseJpaRepositoryImpl.deleteAll((Iterable)baseJpaRepositoryImpl.findAll());
    }

    @Transactional
    public void hardDeleteById(String string) {
        Object a = string;
        BaseJpaRepositoryImpl a2 = this;
        Object object = a;
        Assert.notNull((Object)object, (String)c_Tb.m_Xl((Object)"\u007fLN\u0004LM]AE\u0004B@\u000bI^W_\u0004EK_\u0004IA\u000bJ^HG\u0005"));
        a2.findByIdIncludingDeleted((String)object).ifPresent(arg_0 -> a2.lambda$hardDeleteById$1((String)a, arg_0));
    }

    public Collection<T> bulkSave(Collection<T> collection) {
        Object a = collection;
        BaseJpaRepositoryImpl a2 = this;
        ArrayList<BaseModel> arrayList = new ArrayList<BaseModel>(a.size());
        int n = 2 & 5;
        Set set = a.stream().map(BaseModel::getId).filter(Objects::nonNull).collect(Collectors.toSet());
        set = new HashSet(a2.findExistingIdsIncludingDeleted(set));
        a = a.iterator();
        while (a.hasNext()) {
            BaseModel baseModel = (BaseModel)a.next();
            arrayList.add(a2.persistOrMerge(baseModel, set));
            if (++n % a2.batchSize != 0) continue;
            BaseJpaRepositoryImpl baseJpaRepositoryImpl = a2;
            baseJpaRepositoryImpl.entityManager.flush();
            baseJpaRepositoryImpl.entityManager.clear();
        }
        return arrayList;
    }

    @Transactional
    public void deleteInBatch(Iterable<T> iterable) {
        Object a = iterable;
        BaseJpaRepositoryImpl a2 = this;
        a2.deleteAll((Iterable)a);
    }

    public List<String> findExistingIdsIncludingDeleted(Collection<String> collection) {
        Collection<String> a = collection;
        BaseJpaRepositoryImpl a2 = this;
        if (a == null || a.isEmpty()) {
            return new ArrayList<String>();
        }
        return a2.entityManager.createQuery("SELECT e.id FROM " + a2.getDomainClass().getSimpleName() + " e WHERE e.id IN :ids", String.class).setParameter(c_Tb.m_Xl((Object)"MOW"), (Object)a).getResultList();
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ T persistOrMerge(T t, Set<String> set) {
        void a;
        Object a2 = t;
        BaseJpaRepositoryImpl a3 = this;
        if (a2.getId() == null || !a.contains(a2.getId())) {
            a3.entityManager.persist(a2);
            return (T)a2;
        }
        return (T)((BaseModel)a3.entityManager.merge(a2));
    }

    @Transactional
    public void hardDeleteAllByIdInBatch(Iterable<String> iterable) {
        Object a = iterable;
        BaseJpaRepositoryImpl a2 = this;
        Object object = a;
        Assert.notNull((Object)object, (String)c_ql.m_tha((Object)"!\u0000\u0010H\u0012\u0001\u0003\r\u001bH<\u001c\u0010\u001a\u0014\n\u0019\rU\u0007\u0013H<\fR\u001bU\u0005\u0000\u001b\u0001H\u001b\u0007\u0001H\u0017\rU\u0006\u0000\u0004\u0019I"));
        a = new ArrayList();
        object.forEach(arg_0 -> a.add(arg_0));
        if (a.isEmpty()) {
            return;
        }
        if (!(a = a2.findAllByIdIncludingDeleted((Iterable)a)).isEmpty()) {
            a = a.stream().map(BaseModel::getId).collect(Collectors.toList());
            CriteriaDelete criteriaDelete = a2.entityManager.getCriteriaBuilder().createCriteriaDelete(a2.getDomainClass());
            criteriaDelete.where((Expression)criteriaDelete.from(a2.getDomainClass()).get(c_Tb.m_Xl((Object)"B@")).in((Collection)a));
            a2.entityManager.createQuery(criteriaDelete).executeUpdate();
        }
    }

    public List<T> findAllIncludingDeleted() {
        BaseJpaRepositoryImpl a;
        return super.findAll();
    }

    @Transactional
    public void restore(T t) {
        Object a = t;
        BaseJpaRepositoryImpl a2 = this;
        Object object = a;
        Assert.notNull((Object)a, (String)c_ql.m_tha((Object)"!\u0000\u0010H\u0010\u0006\u0001\u0001\u0001\u0011U\u0005\u0000\u001b\u0001H\u001b\u0007\u0001H\u0017\rU\u0006\u0000\u0004\u0019I"));
        object.setDeletedDate(null);
        object.setDeletedBy(null);
        a2.save(object);
    }

    @Transactional
    public void deleteById(String string) {
        Object a = string;
        BaseJpaRepositoryImpl a2 = this;
        Object object = a;
        Assert.notNull((Object)object, (String)c_Tb.m_Xl((Object)"\u007fLN\u0004LM]AE\u0004B@\u000bI^W_\u0004EK_\u0004IA\u000bJ^HG\u0005"));
        a2.findById(object).ifPresent(arg_0 -> a2.delete(arg_0));
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void lambda$hardDeleteById$1(String string, BaseModel baseModel) {
        void a;
        BaseJpaRepositoryImpl a2;
        BaseJpaRepositoryImpl baseJpaRepositoryImpl = this;
        CriteriaBuilder a3 = baseJpaRepositoryImpl.entityManager.getCriteriaBuilder();
        BaseJpaRepositoryImpl baseJpaRepositoryImpl2 = a2 = a3.createCriteriaDelete(baseJpaRepositoryImpl.getDomainClass());
        baseJpaRepositoryImpl2.where((Expression)a3.equal((Expression)baseJpaRepositoryImpl2.from(baseJpaRepositoryImpl.getDomainClass()).get(c_ql.m_tha((Object)"\u001c\f")), (Object)a));
        baseJpaRepositoryImpl.entityManager.createQuery((CriteriaDelete)a2).executeUpdate();
    }

    public Optional<T> findByIdIncludingDeleted(String string) {
        Object a = string;
        BaseJpaRepositoryImpl a2 = this;
        return super.findById(a);
    }

    @Transactional
    public void deleteAllInBatch(Iterable<T> iterable) {
        Object a = iterable;
        BaseJpaRepositoryImpl a2 = this;
        a2.deleteAll((Iterable)a);
    }

    @Transactional
    public void delete(T t) {
        Object a = t;
        BaseJpaRepositoryImpl a2 = this;
        Object object = a;
        Assert.notNull((Object)object, (String)c_Tb.m_Xl((Object)"\u007fLN\u0004NJ_M_]\u000bI^W_\u0004EK_\u0004IA\u000bJ^HG\u0005"));
        Object object2 = a;
        object.setDeletedDate(new Date());
        object.setDeletedBy(a2.auditorAware.getCurrentAuditor().orElse(c_ql.m_tha((Object)"\u001d\u001b\u0003\u001b\u0007\u0002\u0006")));
        a2.save(a);
    }

    /*
     * WARNING - void declaration
     */
    public BaseJpaRepositoryImpl(JpaEntityInformation<T, ?> jpaEntityInformation, EntityManager entityManager) {
        void a;
        BaseJpaRepositoryImpl a2;
        BaseJpaRepositoryImpl a3 = entityManager;
        BaseJpaRepositoryImpl baseJpaRepositoryImpl = a2 = this;
        BaseJpaRepositoryImpl baseJpaRepositoryImpl2 = a3;
        super((JpaEntityInformation)a, (EntityManager)baseJpaRepositoryImpl2);
        baseJpaRepositoryImpl.entityManager = baseJpaRepositoryImpl2;
        baseJpaRepositoryImpl.batchSize = Integer.parseInt(a3.getEntityManagerFactory().getProperties().get(c_ql.m_tha((Object)"\u0000\u001c\n\u0010\u001a\u001b\t\u0001\r[\u0002\u0011\n\u0016F\u0017\t\u0001\u000b\u001d7\u0006\u0001\u000f\r")).toString());
        BaseJpaRepositoryImpl baseJpaRepositoryImpl3 = a2;
        baseJpaRepositoryImpl.auditorAware = new c_tB();
    }

    @Transactional
    public void deleteAll(Iterable<? extends T> iterable) {
        Iterable<? extends T> a = iterable;
        BaseJpaRepositoryImpl a2 = this;
        Iterable<? extends T> iterable2 = a;
        Assert.notNull((Object)iterable2, (String)c_ql.m_tha((Object)"<\u001d\rU\u000f\u001c\u001e\u0010\u0006U!\u0001\r\u0007\t\u0017\u0004\u0010H\u001a\u000eU\r\u001b\u001c\u001c\u001c\u001c\r\u0006H\u001b\u0007\u0001H\u0017\rU\u0006\u0000\u0004\u0019I"));
        iterable2.forEach(arg_0 -> a2.delete(arg_0));
    }

    /*
     * WARNING - void declaration
     */
    public BaseJpaRepositoryImpl(Class<T> clazz, EntityManager entityManager) {
        void a;
        BaseJpaRepositoryImpl a2;
        BaseJpaRepositoryImpl a3 = entityManager;
        BaseJpaRepositoryImpl baseJpaRepositoryImpl = a2 = this;
        BaseJpaRepositoryImpl baseJpaRepositoryImpl2 = a3;
        super((Class)a, (EntityManager)baseJpaRepositoryImpl2);
        baseJpaRepositoryImpl.entityManager = baseJpaRepositoryImpl2;
        baseJpaRepositoryImpl.batchSize = Integer.parseInt(a3.getEntityManagerFactory().getProperties().get(c_Tb.m_Xl((Object)"LBFNVEE_A\u0005NOFH\nIE_GC{XMQA")).toString());
        BaseJpaRepositoryImpl baseJpaRepositoryImpl3 = a2;
        baseJpaRepositoryImpl.auditorAware = new c_tB();
    }

    @Transactional
    public void deleteAllByIdInBatch(Iterable<String> iterable) {
        Object a = iterable;
        BaseJpaRepositoryImpl a2 = this;
        a2.deleteAllById((Iterable)a);
    }

    private /* synthetic */ List<T> findAllByIdIncludingDeleted(Iterable<String> iterable) {
        Object a = iterable;
        BaseJpaRepositoryImpl a2 = this;
        return super.findAllById((Iterable)a);
    }

    @Transactional
    public void hardDelete(T t) {
        Object a = t;
        BaseJpaRepositoryImpl a2 = this;
        Object object = a;
        Assert.notNull((Object)object, (String)c_ql.m_tha((Object)"!\u0000\u0010H\u0010\u0006\u0001\u0001\u0001\u0011U\u0005\u0000\u001b\u0001H\u001b\u0007\u0001H\u0017\rU\u0006\u0000\u0004\u0019I"));
        a2.findByIdIncludingDeleted(object.getId()).ifPresent(baseModel -> {
            BaseJpaRepositoryImpl a = baseModel;
            BaseJpaRepositoryImpl a2 = this;
            a2.hardDeleteById(a.getId());
        });
    }

    @Transactional
    public void deleteAllById(Iterable<? extends String> iterable) {
        Object a = iterable;
        BaseJpaRepositoryImpl a2 = this;
        Object object = a;
        Assert.notNull((Object)object, (String)c_Tb.m_Xl((Object)"\u007fLN\u0004LM]AE\u0004bPNVJFGA\u000bKM\u0004b@\fW\u000bI^W_\u0004EK_\u0004IA\u000bJ^HG\u0005"));
        a = new ArrayList();
        object.forEach(arg_0 -> a.add(arg_0));
        if (a.isEmpty()) {
            return;
        }
        if (!(a = a2.findAllById((Iterable)a)).isEmpty()) {
            a2.deleteAll((Iterable)a);
        }
    }
}

