/*
 * Decompiled with CFR 0.152.
 */
package com.inscada.mono.shared.exceptions;

import com.inscada.mono.auth.exceptions.AuthTokenException;
import com.inscada.mono.auth.exceptions.RunAsExecutionException;
import com.inscada.mono.broadcast.exceptions.BroadcastOperationException;
import com.inscada.mono.communication.base.exceptions.BrowseOperationException;
import com.inscada.mono.communication.base.exceptions.CommunicationException;
import com.inscada.mono.communication.base.exceptions.SetValueException;
import com.inscada.mono.impexp.exceptions.ImportExportException;
import com.inscada.mono.report.exceptions.ReportGenerationException;
import com.inscada.mono.report.exceptions.ReportSchedulingException;
import com.inscada.mono.script.exceptions.ScriptException;
import com.inscada.mono.script.model.Script;
import com.inscada.mono.settings.exceptions.SettingsException;
import com.inscada.mono.shared.exceptions.AlreadyExistsException;
import com.inscada.mono.shared.exceptions.FileStorageException;
import com.inscada.mono.shared.exceptions.InscadaException;
import com.inscada.mono.shared.exceptions.MismatchException;
import com.inscada.mono.shared.exceptions.NotActiveException;
import com.inscada.mono.shared.exceptions.NotFoundException;
import com.inscada.mono.shared.exceptions.ParsingException;
import com.inscada.mono.shared.exceptions.RelationExistsException;
import com.inscada.mono.shared.exceptions.ValidationDefinitionException;
import com.inscada.mono.shared.exceptions.model.ExceptionDetails;
import com.inscada.mono.shared.model.BaseModel;
import com.inscada.mono.sms.exceptions.SmsProviderException;
import com.inscada.mono.space.exceptions.SpaceOperationException;
import jakarta.persistence.EntityNotFoundException;
import jakarta.persistence.OptimisticLockException;
import jakarta.validation.ConstraintViolation;
import jakarta.validation.ConstraintViolationException;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.hibernate.StaleObjectStateException;
import org.influxdb.InfluxDBMapperException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.env.Environment;
import org.springframework.dao.DataIntegrityViolationException;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.http.converter.HttpMessageNotReadableException;
import org.springframework.lang.NonNull;
import org.springframework.security.access.AccessDeniedException;
import org.springframework.security.authentication.BadCredentialsException;
import org.springframework.transaction.TransactionSystemException;
import org.springframework.validation.FieldError;
import org.springframework.web.bind.MethodArgumentNotValidException;
import org.springframework.web.bind.MissingServletRequestParameterException;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.RestControllerAdvice;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;
import org.springframework.web.context.request.WebRequest;
import org.springframework.web.method.annotation.MethodArgumentTypeMismatchException;
import org.springframework.web.servlet.mvc.method.annotation.ResponseEntityExceptionHandler;

@RestControllerAdvice(basePackages={"com.inscada.mono"})
public class GeneralExceptionHandler
extends ResponseEntityExceptionHandler {
    private static final String OPTIMISTIC_LOCK_ERROR = "Optimistic Lock Error";
    private static final String REPORT_GENERATION_ERROR = "Report Generation Error";
    private static final String SCRIPT_ERROR = "Script Execution Error";
    private final Environment environment;
    private static final String SMS_PROVIDER_ERROR = "SMS Provider Error";
    private static final String RELATION_EXISTS_ERROR = "Relation Exists Error";
    private static final String COMMUNICATION_ERROR = "Communication Error";
    private static final String SPACE_OPERATION_ERROR = "Space Operation Error";
    private static final String BROWSE_OPERATION_ERROR = "Browse Operation Error";
    private static final String NOT_FOUND_ERROR = "Not Found Error";
    private static final String CONSTRAINT_VIOLATION = "Constraint Violation";
    private static final String IMPORT_EXPORT_ERROR = "Import/Export Error";
    private static final String UNKNOWN_ERROR = "Unknown Error";
    private static final String ALREADY_EXISTS_ERROR = "Already Exists Error";
    private static final Logger log = LoggerFactory.getLogger(GeneralExceptionHandler.class);
    private static final String NOT_ACTIVE_ERROR = "Not Active Error";
    private static final String BROADCAST_OPERATION_ERROR = "Broadcast Operation Error";
    private static final String FILE_STORAGE_ERROR = "File Storage Error";
    private static final String PARSING_ERROR = "Parsing Error";
    private static final String AUTH_TOKEN_ERROR = "Auth Token Error";
    private static final String RUN_AS_ERROR = "Run-As Execution Error";
    private static final String DATABASE_ERROR = "Database Error";
    private static final String REPORT_SCHEDULING_ERROR = "Report Scheduling Error";
    private static final String MISMATCH_ERROR = "Mismatch Error";
    private static final String INSCADA_ERROR = "Inscada Error";
    private static final String VALIDATION_ERROR = "Validation Error";
    private static final String SECURITY_ERROR = "Security Error";
    private static final String SET_VALUE_ERROR = "Set Value Error";
    private static final String VALIDATION_DEFINITION_ERROR = "Validation Definition Error";
    private static final String SETTINGS_ERROR = "Settings Error";

    @ExceptionHandler(value={ReportGenerationException.class})
    protected ResponseEntity<Object> handleReportGenerationException(ReportGenerationException reportGenerationException) {
        GeneralExceptionHandler a = reportGenerationException;
        GeneralExceptionHandler a2 = this;
        GeneralExceptionHandler generalExceptionHandler = a;
        return a2.buildErrorResponse((Exception)generalExceptionHandler, generalExceptionHandler.getMessage(), (HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR, REPORT_GENERATION_ERROR);
    }

    @ExceptionHandler(value={ReportSchedulingException.class})
    protected ResponseEntity<Object> handleReportSchedulingException(ReportSchedulingException reportSchedulingException) {
        GeneralExceptionHandler a = reportSchedulingException;
        GeneralExceptionHandler a2 = this;
        GeneralExceptionHandler generalExceptionHandler = a;
        return a2.buildErrorResponse((Exception)generalExceptionHandler, generalExceptionHandler.getMessage(), (HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR, REPORT_SCHEDULING_ERROR);
    }

    @ExceptionHandler(value={BrowseOperationException.class})
    protected ResponseEntity<Object> handleBrowseOperationException(BrowseOperationException browseOperationException) {
        GeneralExceptionHandler a = browseOperationException;
        GeneralExceptionHandler a2 = this;
        GeneralExceptionHandler generalExceptionHandler = a;
        return a2.buildErrorResponse((Exception)generalExceptionHandler, generalExceptionHandler.getMessage(), (HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR, BROWSE_OPERATION_ERROR);
    }

    @ExceptionHandler(value={ParsingException.class})
    protected ResponseEntity<Object> handleParsingException(ParsingException parsingException) {
        GeneralExceptionHandler a = parsingException;
        GeneralExceptionHandler a2 = this;
        GeneralExceptionHandler generalExceptionHandler = a;
        return a2.buildErrorResponse((Exception)generalExceptionHandler, generalExceptionHandler.getMessage(), (HttpStatusCode)HttpStatus.BAD_REQUEST, PARSING_ERROR);
    }

    /*
     * WARNING - void declaration
     */
    protected ResponseEntity<Object> handleHttpMessageNotReadable(HttpMessageNotReadableException httpMessageNotReadableException, @NonNull HttpHeaders httpHeaders, @NonNull HttpStatusCode httpStatusCode, @NonNull WebRequest webRequest) {
        void ex;
        GeneralExceptionHandler generalExceptionHandler = generalExceptionHandler2;
        GeneralExceptionHandler generalExceptionHandler2 = httpHeaders;
        GeneralExceptionHandler headers = generalExceptionHandler;
        generalExceptionHandler2 = headers.createExceptionDetails((HttpStatusCode)HttpStatus.BAD_REQUEST, "Malformed JSON request: " + ex.getMessage(), (Exception)ex, VALIDATION_ERROR);
        log.error(Script.m_be((Object)"\u001e\u000f \u00192\r6J=\u0005'J!\u000f2\u000e2\b?\u000fiJ(\u0017"), (Object)generalExceptionHandler2, (Object)ex);
        return new ResponseEntity((Object)generalExceptionHandler2, (HttpStatusCode)HttpStatus.BAD_REQUEST);
    }

    public GeneralExceptionHandler(Environment environment) {
        GeneralExceptionHandler a = environment;
        GeneralExceptionHandler a2 = this;
        a2.environment = a;
    }

    @ExceptionHandler(value={AuthTokenException.class})
    protected ResponseEntity<Object> handleAuthTokenException(AuthTokenException authTokenException) {
        GeneralExceptionHandler a = authTokenException;
        GeneralExceptionHandler a2 = this;
        GeneralExceptionHandler generalExceptionHandler = a;
        return a2.buildErrorResponse((Exception)generalExceptionHandler, generalExceptionHandler.getMessage(), (HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR, AUTH_TOKEN_ERROR);
    }

    @ExceptionHandler(value={DataIntegrityViolationException.class})
    protected ResponseEntity<Object> handleDataIntegrityViolation(DataIntegrityViolationException dataIntegrityViolationException) {
        GeneralExceptionHandler a = dataIntegrityViolationException;
        GeneralExceptionHandler a2 = this;
        GeneralExceptionHandler generalExceptionHandler = a;
        return a2.buildErrorResponse((Exception)generalExceptionHandler, ExceptionUtils.getRootCauseMessage((Throwable)generalExceptionHandler), (HttpStatusCode)HttpStatus.CONFLICT, DATABASE_ERROR);
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ ExceptionDetails createExceptionDetails(HttpStatusCode httpStatusCode, String string, Exception exception, String string2, Map<String, List<String>> map) {
        void a;
        void a2;
        Object a3;
        void a4;
        String a5;
        GeneralExceptionHandler a6;
        GeneralExceptionHandler generalExceptionHandler = object;
        Object object = string2;
        GeneralExceptionHandler generalExceptionHandler2 = a6 = generalExceptionHandler;
        a5 = generalExceptionHandler2.sanitizeMessage(a5, (Exception)a4);
        String string3 = generalExceptionHandler2.isDevelopment() ? a4.getClass().getName() : BaseModel.m_LA((Object)".\u001d\b\u0000\u001b\u0011\u0002\n\u0005");
        Object object2 = a6.isDevelopment() ? a3 : Script.m_be((Object)"/!\u0018<\u0018");
        return new ExceptionDetails(a2.value(), a5, string3, (String)object2, (Map)a, (String)(a3 = a6.isDevelopment() ? ExceptionUtils.getStackTrace((Throwable)a4) : null), new Date(), a6.getCurrentPath());
    }

    @ExceptionHandler(value={NotActiveException.class})
    protected ResponseEntity<Object> handleNotActive(NotActiveException notActiveException) {
        GeneralExceptionHandler a = notActiveException;
        GeneralExceptionHandler a2 = this;
        GeneralExceptionHandler generalExceptionHandler = a;
        return a2.buildErrorResponse((Exception)generalExceptionHandler, generalExceptionHandler.getMessage(), (HttpStatusCode)HttpStatus.BAD_REQUEST, NOT_ACTIVE_ERROR);
    }

    /*
     * WARNING - void declaration
     */
    @ExceptionHandler(value={TransactionSystemException.class})
    protected ResponseEntity<Object> handleTransactionSystemException(TransactionSystemException transactionSystemException) {
        void a;
        GeneralExceptionHandler generalExceptionHandler = this;
        Object a2 = a.getRootCause();
        if (a2 instanceof ConstraintViolationException) {
            a2 = (ConstraintViolationException)a2;
            return generalExceptionHandler.handleConstraintViolation((ConstraintViolationException)a2);
        }
        void v0 = a;
        return generalExceptionHandler.buildErrorResponse((Exception)v0, ExceptionUtils.getRootCauseMessage((Throwable)v0), (HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR, DATABASE_ERROR);
    }

    @ExceptionHandler(value={NotFoundException.class, EntityNotFoundException.class})
    protected ResponseEntity<Object> handleEntityNotFound(Exception exception) {
        Exception a = exception;
        GeneralExceptionHandler a2 = this;
        Exception exception2 = a;
        return a2.buildErrorResponse(exception2, exception2.getMessage(), (HttpStatusCode)HttpStatus.NOT_FOUND, NOT_FOUND_ERROR);
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ ExceptionDetails createExceptionDetails(HttpStatusCode httpStatusCode, String string, Exception exception, String string2) {
        Object a;
        void a2;
        void a3;
        void a4;
        GeneralExceptionHandler generalExceptionHandler = object;
        Object object = string2;
        GeneralExceptionHandler a5 = generalExceptionHandler;
        return a5.createExceptionDetails((HttpStatusCode)a4, (String)a3, (Exception)a2, (String)a, null);
    }

    @ExceptionHandler(value={FileStorageException.class})
    protected ResponseEntity<Object> handleFileStorage(FileStorageException fileStorageException) {
        GeneralExceptionHandler a = fileStorageException;
        GeneralExceptionHandler a2 = this;
        GeneralExceptionHandler generalExceptionHandler = a;
        return a2.buildErrorResponse((Exception)generalExceptionHandler, generalExceptionHandler.getMessage(), (HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR, FILE_STORAGE_ERROR);
    }

    @ExceptionHandler(value={ScriptException.class})
    protected ResponseEntity<Object> handleScriptException(ScriptException scriptException) {
        GeneralExceptionHandler a = scriptException;
        GeneralExceptionHandler a2 = this;
        GeneralExceptionHandler generalExceptionHandler = a;
        return a2.buildErrorResponse((Exception)generalExceptionHandler, generalExceptionHandler.getMessage(), (HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR, SCRIPT_ERROR);
    }

    protected ResponseEntity<Object> handleMissingServletRequestParameter(MissingServletRequestParameterException missingServletRequestParameterException, @NonNull HttpHeaders httpHeaders, @NonNull HttpStatusCode httpStatusCode, @NonNull WebRequest webRequest) {
        GeneralExceptionHandler generalExceptionHandler = generalExceptionHandler2;
        GeneralExceptionHandler generalExceptionHandler2 = missingServletRequestParameterException;
        GeneralExceptionHandler ex = generalExceptionHandler;
        Object[] objectArray = new Object[--2];
        objectArray[5 >> 3] = generalExceptionHandler2.getParameterName();
        objectArray[5 >> 2] = generalExceptionHandler2.getParameterType();
        ExceptionDetails headers = ex.createExceptionDetails((HttpStatusCode)HttpStatus.BAD_REQUEST, Script.m_be((Object)"86\u001b&\u0003!\u000f7J#\u000b!\u000b>\u000f'\u000f!JtO Ms\u00055J'\u0013#\u000fsMv\u0019tJ:\u0019s\u0007:\u0019 \u0003=\r").formatted(objectArray), (Exception)generalExceptionHandler2, VALIDATION_ERROR);
        log.error(BaseModel.m_LA((Object)"&\f\u0018\u0016\u0002\u000b\fE\u001b\u0004\u0019\u0004\u0006\u0000\u001f\u0000\u0019_K\u001e\u0016"), (Object)headers, (Object)generalExceptionHandler2);
        return new ResponseEntity((Object)headers, (HttpStatusCode)HttpStatus.BAD_REQUEST);
    }

    @ExceptionHandler(value={MethodArgumentTypeMismatchException.class})
    protected ResponseEntity<Object> handleMethodArgumentTypeMismatch(MethodArgumentTypeMismatchException methodArgumentTypeMismatchException) {
        GeneralExceptionHandler a = methodArgumentTypeMismatchException;
        GeneralExceptionHandler a2 = this;
        Object[] objectArray = new Object[--3];
        objectArray[5 >> 3] = a.getName();
        objectArray[3 & 5] = a.getValue();
        objectArray[1 ^ 3] = a.getRequiredType() != null ? a.getRequiredType().getSimpleName() : BaseModel.m_LA((Object)"\u001e\u000b\u0000\u000b\u0004\u0012\u0005");
        String string = Script.m_be((Object)"\u0003\u000b!\u000b>\u000f'\u000f!JtO Ms\u001d:\u001e;J%\u000b?\u001f6JtO Ms\t<\u001f?\u000es\u0004<\u001es\b6J0\u0005=\u001c6\u0018'\u000f7J'\u0005s\u001e*\u001a6JtO M").formatted(objectArray);
        return a2.buildErrorResponse((Exception)a, string, (HttpStatusCode)HttpStatus.BAD_REQUEST, VALIDATION_ERROR);
    }

    private /* synthetic */ boolean isDevelopment() {
        String[] stringArray = this;
        String[] a = stringArray.environment.getActiveProfiles();
        if (a.length == 0) {
            return (3 ^ 3) != 0;
        }
        return Arrays.asList(a).contains(BaseModel.m_LA((Object)"\u000f\u0000\u001d"));
    }

    @ExceptionHandler(value={OptimisticLockException.class, StaleObjectStateException.class})
    protected ResponseEntity<Object> handleOptimisticLock(Exception exception) {
        Object a = exception;
        GeneralExceptionHandler a2 = this;
        return a2.buildErrorResponse((Exception)a, Script.m_be((Object)"\u0007\u0002:\u0019s\u00186\t<\u00187J$\u000b J&\u001a7\u000b'\u000f7J1\u0013s\u000b=\u0005'\u00026\u0018s\u001f \u000f!Ds:?\u000f2\u00196J!\u000f5\u00186\u0019;J*\u0005&\u0018s\u000e2\u001e2J2\u00047J'\u0018*J2\r2\u0003=D"), (HttpStatusCode)HttpStatus.CONFLICT, OPTIMISTIC_LOCK_ERROR);
    }

    /*
     * WARNING - void declaration
     */
    protected ResponseEntity<Object> handleExceptionInternal(Exception exception, Object object, @NonNull HttpHeaders httpHeaders, @NonNull HttpStatusCode httpStatusCode, @NonNull WebRequest webRequest) {
        void ex;
        void status;
        GeneralExceptionHandler generalExceptionHandler = object2;
        Object object2 = object;
        GeneralExceptionHandler body = generalExceptionHandler;
        object2 = body.createExceptionDetails((HttpStatusCode)status, ex.getMessage(), (Exception)ex, UNKNOWN_ERROR);
        log.error(BaseModel.m_LA((Object)",\u0005\u0011\u000e\u0017\u0005\u0004\u0007E\u000e\u0017\u0019\n\u0019_K\u001e\u0016"), object2, (Object)ex);
        return new ResponseEntity(object2, (HttpStatusCode)status);
    }

    @ExceptionHandler(value={RelationExistsException.class})
    protected ResponseEntity<Object> handleRelationExists(RelationExistsException relationExistsException) {
        GeneralExceptionHandler a = relationExistsException;
        GeneralExceptionHandler a2 = this;
        GeneralExceptionHandler generalExceptionHandler = a;
        return a2.buildErrorResponse((Exception)generalExceptionHandler, generalExceptionHandler.getMessage(), (HttpStatusCode)HttpStatus.CONFLICT, RELATION_EXISTS_ERROR);
    }

    @ExceptionHandler(value={ImportExportException.class})
    protected ResponseEntity<Object> handleImportExportException(ImportExportException importExportException) {
        GeneralExceptionHandler a = importExportException;
        GeneralExceptionHandler a2 = this;
        GeneralExceptionHandler generalExceptionHandler = a;
        return a2.buildErrorResponse((Exception)generalExceptionHandler, generalExceptionHandler.getMessage(), (HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR, IMPORT_EXPORT_ERROR);
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ String sanitizeMessage(String string, Exception exception) {
        void a;
        Object a2 = exception;
        GeneralExceptionHandler a3 = this;
        if (a2 instanceof ScriptException) {
            return a;
        }
        if (a3.isDevelopment()) {
            return a;
        }
        if (a2 instanceof AlreadyExistsException) {
            return Script.m_be((Object)"86\u0019<\u001f!\t6J2\u0006!\u000f2\u000e*J6\u0012:\u0019'\u0019");
        }
        if (a2 instanceof FileStorageException) {
            return BaseModel.m_LA((Object)"-\f\u0007\u0000K\n\u001b\u0000\u0019\u0004\u001f\f\u0004\u000bK\u0003\n\f\u0007\u0000\u000f");
        }
        if (a2 instanceof MismatchException) {
            return Script.m_be((Object)"86\u0019<\u001f!\t6J>\u0003 \u00072\u001e0\u0002");
        }
        if (a2 instanceof NotActiveException) {
            return BaseModel.m_LA((Object)"7\u000e\u0016\u0004\u0010\u0019\u0006\u000eE\u0002\u0016K\u000b\u0004\u0011K\u0004\b\u0011\u0002\u0013\u000e");
        }
        if (a2 instanceof NotFoundException) {
            return Script.m_be((Object)"\u0001\u000f \u0005&\u00180\u000fs\u0004<\u001es\f<\u001f=\u000e");
        }
        if (a2 instanceof RelationExistsException) {
            return BaseModel.m_LA((Object)"9\u0000\u0007\u0004\u001f\u0000\u000fE\u0019\u0000\u0018\n\u001e\u0017\b\u0000K\u0000\u0013\f\u0018\u0011\u0018");
        }
        if (a2 instanceof OptimisticLockException || a2 instanceof StaleObjectStateException) {
            return Script.m_be((Object)"\u0001\u000f \u0005&\u00180\u000fs\u001d2\u0019s\u001f#\u000e2\u001e6\u000es\b*J2\u0004<\u001e;\u000f!J&\u00196\u0018");
        }
        if (a2 instanceof SmsProviderException) {
            return BaseModel.m_LA((Object)"6&6K\u0016\u000e\u0017\u001d\f\b\u0000K\n\u001b\u0000\u0019\u0004\u001f\f\u0004\u000bK\u0003\n\f\u0007\u0000\u000f");
        }
        if (a2 instanceof SettingsException) {
            return Script.m_be((Object)"\u0012\u001a#\u0006:\t2\u001e:\u0005=J \u000f'\u001e:\u00044\u0019s\u000f!\u0018<\u0018");
        }
        if (a2 instanceof ParsingException) {
            return BaseModel.m_LA((Object)"\"\u000b\u001d\u0004\u0007\f\u000fE\u000f\u0004\u001f\u0004K\u0003\u0004\u0017\u0006\u0004\u001f");
        }
        if (a2 instanceof ValidationDefinitionException) {
            return Script.m_be((Object)"#=\u001e6\u0018=\u000b?J%\u000b?\u00037\u000b'\u0003<\u0004s\t<\u00045\u00034\u001f!\u000b'\u0003<\u0004s\u000f!\u0018<\u0018");
        }
        if (a2 instanceof BrowseOperationException) {
            return BaseModel.m_LA((Object)"*\u000bK\u0000\u0019\u0017\u0004\u0017K\n\b\u0006\u001e\u0017\u0019\u0000\u000fE\u000f\u0010\u0019\f\u0005\u0002K\u0004K\u0007\u0019\n\u001c\u0016\u000eE\u0004\u0015\u000e\u0017\n\u0011\u0002\n\u0005");
        }
        if (a2 instanceof SetValueException) {
            return Script.m_be((Object)"+=J6\u0018!\u0005!J<\t0\u001f!\u00186\u000es\u001d;\u0003?\u000fs\u00196\u001e'\u0003=\rs\u000bs\u001c2\u0006&\u000f");
        }
        if (a2 instanceof CommunicationException) {
            return BaseModel.m_LA((Object)"(\n\u0006\b\u001e\u000b\u0002\u0006\n\u0011\u0002\n\u0005E\b\n\u0005\u0003\u0002\u0002\u001e\u0017\n\u0011\u0002\n\u0005E\u000e\u0017\u0019\n\u0019");
        }
        if (a2 instanceof RunAsExecutionException) {
            return Script.m_be((Object)"+=J:\u0004'\u000f!\u00042\u0006s\u0005#\u000f!\u000b'\u0003<\u0004s\f2\u0003?\u000f7J7\u001f!\u0003=\rs\u000f+\u000f0\u001f'\u0003<\u0004");
        }
        if (a2 instanceof SpaceOperationException) {
            return BaseModel.m_LA((Object)"8\u0015\n\u0006\u000eE\u0004\u0015\u000e\u0017\n\u0011\u0002\n\u0005E\r\u0004\u0002\t\u000e\u0001K\u0001\u001e\u0000K\u0011\u0004E\nE\t\u0010\u0018\f\u0005\u0000\u0018\u0016K\u0017\u001e\t\u000eE\u001d\f\u0004\t\n\u0011\u0002\n\u0005");
        }
        if (a2 instanceof ImportExportException) {
            return Script.m_be((Object)"+=J6\u0018!\u0005!J<\t0\u001f!\u00186\u000es\u000e&\u0018:\u00044J7\u000b'\u000bs\u0003>\u001a<\u0018'E6\u0012#\u0005!\u001e");
        }
        if (a2 instanceof ReportGenerationException) {
            return BaseModel.m_LA((Object)"$\u0005E\u000e\u0017\u0019\n\u0019E\u0004\u0006\b\u0010\u0019\u0017\u000e\u0001K\u0001\u001e\u0017\u0002\u000b\fE\u0019\u0000\u001b\n\u0019\u0011K\u0002\u000e\u000b\u000e\u0017\n\u0011\u0002\n\u0005");
        }
        if (a2 instanceof ReportSchedulingException) {
            return Script.m_be((Object)"\u0012\u0004s\u000f!\u0018<\u0018s\u00050\t&\u0018!\u000f7J7\u001f!\u0003=\rs\u00186\u001a<\u0018'J \t;\u000f7\u001f?\u0003=\r");
        }
        if (a2 instanceof BroadcastOperationException) {
            return BaseModel.m_LA((Object)"$\u0005E\u000e\u0017\u0019\n\u0019E\u0004\u0006\b\u0010\u0019\u0017\u000e\u0001K\u0001\u001e\u0017\u0002\u000b\fE\nE\t\u0017\u0004\u0004\u000f\u0006\n\u0016\u001fE\u0004\u0015\u000e\u0017\n\u0011\u0002\n\u0005");
        }
        if (a2 instanceof AuthTokenException) {
            return Script.m_be((Object)"\u0012\u0004s\u000b&\u001e;\u000f=\u001e:\t2\u001e:\u0005=J'\u00058\u000f=J6\u0018!\u0005!J<\t0\u001f!\u00186\u000e");
        }
        if (a2 instanceof DataIntegrityViolationException) {
            return BaseModel.m_LA((Object)"/\u0004\u001f\u0004\t\u0004\u0018\u0000K\u0006\u0004\u000b\u0018\u0011\u0019\u0004\u0002\u000b\u001fE\u001d\f\u0004\t\n\u0011\u0002\n\u0005");
        }
        if (a2 instanceof TransactionSystemException) {
            return Script.m_be((Object)"\u0017\u000b'\u000b1\u000b \u000fs\u001e!\u000b=\u00192\t'\u0003<\u0004s\u000f!\u0018<\u0018");
        }
        if (a2 instanceof InfluxDBMapperException) {
            return BaseModel.m_LA((Object)"1\u0002\b\u000eE\u0018\u0000\u0019\f\u000e\u0016K\u0001\n\u0011\n\u0007\n\u0016\u000eE\u000e\u0017\u0019\n\u0019");
        }
        if (a2 instanceof SecurityException || a2 instanceof AccessDeniedException || a2 instanceof BadCredentialsException) {
            return Script.m_be((Object)"+0\t6\u0019 J7\u000f=\u00036\u000e");
        }
        if (a2 instanceof MethodArgumentNotValidException || a2 instanceof IllegalArgumentException) {
            return BaseModel.m_LA((Object)"\"\u000b\u001d\u0004\u0007\f\u000fE\u0002\u000b\u001b\u0010\u001f");
        }
        if (a2 instanceof ConstraintViolationException) {
            return Script.m_be((Object)"<2\u0006:\u000e2\u001e:\u0005=J0\u0005=\u0019'\u00182\u0003=\u001es\u001c:\u0005?\u000b'\u0003<\u0004");
        }
        if (a2 instanceof HttpMessageNotReadableException) {
            return BaseModel.m_LA((Object)",\u0005\u0013\n\t\u0002\u0001K\u0017\u000e\u0014\u001e\u0000\u0018\u0011K\u0003\u0004\u0017\u0006\u0004\u001f");
        }
        if (a2 instanceof MissingServletRequestParameterException) {
            return Script.m_be((Object)"\u001e\u0003 \u0019:\u00044J!\u000f\"\u001f:\u00186\u000es\u001a2\u00182\u00076\u001e6\u0018");
        }
        if (a2 instanceof IllegalStateException) {
            return BaseModel.m_LA((Object)"\"\u000b\u001d\u0004\u0007\f\u000fE\n\u0015\u001b\t\u0002\u0006\n\u0011\u0002\n\u0005E\u0018\u0011\n\u0011\u000e");
        }
        return Script.m_be((Object)"\u0012\u0004s\u001f=\u000f+\u001a6\t'\u000f7J6\u0018!\u0005!J<\t0\u001f!\u00186\u000e");
    }

    @ExceptionHandler(value={CommunicationException.class})
    protected ResponseEntity<Object> handleCommunicationException(CommunicationException communicationException) {
        GeneralExceptionHandler a = communicationException;
        GeneralExceptionHandler a2 = this;
        GeneralExceptionHandler generalExceptionHandler = a;
        return a2.buildErrorResponse((Exception)generalExceptionHandler, generalExceptionHandler.getMessage(), (HttpStatusCode)HttpStatus.BAD_REQUEST, COMMUNICATION_ERROR);
    }

    @ExceptionHandler(value={InscadaException.class})
    protected ResponseEntity<Object> handleInscadaException(InscadaException inscadaException) {
        GeneralExceptionHandler a = inscadaException;
        GeneralExceptionHandler a2 = this;
        GeneralExceptionHandler generalExceptionHandler = a;
        return a2.buildErrorResponse((Exception)generalExceptionHandler, generalExceptionHandler.getMessage(), (HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR, INSCADA_ERROR);
    }

    @ExceptionHandler(value={IllegalStateException.class})
    protected ResponseEntity<Object> handleIllegalState(IllegalStateException illegalStateException) {
        IllegalStateException a = illegalStateException;
        GeneralExceptionHandler a2 = this;
        IllegalStateException illegalStateException2 = a;
        return a2.buildErrorResponse((Exception)illegalStateException2, illegalStateException2.getMessage(), (HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR, INSCADA_ERROR);
    }

    @ExceptionHandler(value={BroadcastOperationException.class})
    protected ResponseEntity<Object> handleBroadcastOperationException(BroadcastOperationException broadcastOperationException) {
        GeneralExceptionHandler a = broadcastOperationException;
        GeneralExceptionHandler a2 = this;
        GeneralExceptionHandler generalExceptionHandler = a;
        return a2.buildErrorResponse((Exception)generalExceptionHandler, generalExceptionHandler.getMessage(), (HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR, BROADCAST_OPERATION_ERROR);
    }

    @ExceptionHandler(value={MismatchException.class})
    protected ResponseEntity<Object> handleMismatch(MismatchException mismatchException) {
        GeneralExceptionHandler a = mismatchException;
        GeneralExceptionHandler a2 = this;
        GeneralExceptionHandler generalExceptionHandler = a;
        return a2.buildErrorResponse((Exception)generalExceptionHandler, generalExceptionHandler.getMessage(), (HttpStatusCode)HttpStatus.BAD_REQUEST, MISMATCH_ERROR);
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ ResponseEntity<Object> buildErrorResponse(Exception exception, String string, HttpStatusCode httpStatusCode, String string2) {
        void a;
        void a2;
        void a3;
        Object a4 = string;
        GeneralExceptionHandler a5 = this;
        a4 = a5.createExceptionDetails((HttpStatusCode)a3, (String)a4, (Exception)a2, (String)a, null);
        log.error(Script.m_be((Object)"\u001a\u0004'\u000f!\u00042\u0006s\u000f!\u0018<\u0018iJ(\u0017"), a4, (Object)a2);
        return new ResponseEntity(a4, (HttpStatusCode)a3);
    }

    @ExceptionHandler(value={AccessDeniedException.class, BadCredentialsException.class})
    protected ResponseEntity<Object> handleSecurityExceptions(Exception exception) {
        Exception a = exception;
        GeneralExceptionHandler a2 = this;
        Exception exception2 = a;
        return a2.buildErrorResponse(exception2, exception2.getMessage(), (HttpStatusCode)HttpStatus.FORBIDDEN, SECURITY_ERROR);
    }

    /*
     * WARNING - void declaration
     */
    @NonNull
    protected ResponseEntity<Object> handleMethodArgumentNotValid(MethodArgumentNotValidException methodArgumentNotValidException, @NonNull HttpHeaders httpHeaders, @NonNull HttpStatusCode httpStatusCode, @NonNull WebRequest webRequest) {
        void ex;
        GeneralExceptionHandler generalExceptionHandler = object;
        Object object = httpHeaders;
        GeneralExceptionHandler headers = generalExceptionHandler;
        object = new HashMap();
        Map status = ex.getBindingResult().getFieldErrors().stream().collect(Collectors.groupingBy(FieldError::getField, Collectors.mapping(objectError -> {
            GeneralExceptionHandler a = objectError;
            GeneralExceptionHandler a2 = this;
            if (a.getDefaultMessage() != null) {
                return a.getDefaultMessage();
            }
            return BaseModel.m_LA((Object)"+\u0004E\u0006\u0000\u0018\u0016\n\u0002\u000eE\n\u0013\n\f\u0007\u0004\t\t\u000e");
        }, Collectors.toList())));
        List a = ex.getBindingResult().getGlobalErrors().stream().map(objectError -> {
            GeneralExceptionHandler a = objectError;
            GeneralExceptionHandler a2 = this;
            if (a.getDefaultMessage() != null) {
                return a.getDefaultMessage();
            }
            return BaseModel.m_LA((Object)"+\u0004E\u0006\u0000\u0018\u0016\n\u0002\u000eE\n\u0013\n\f\u0007\u0004\t\t\u000e");
        }).collect(Collectors.toList());
        object.putAll(status);
        if (!a.isEmpty()) {
            object.put(Script.m_be((Object)"4\u0006<\b2\u0006"), a);
        }
        object = headers.createExceptionDetails((HttpStatusCode)HttpStatus.BAD_REQUEST, headers.formatErrorMessages((Map)object), (Exception)ex, VALIDATION_ERROR, (Map)object);
        log.error(BaseModel.m_LA((Object)"3\n\t\u0002\u0001\n\u0011\u0002\n\u0005E\u000e\u0017\u0019\n\u0019_K\u001e\u0016"), object, (Object)ex);
        return new ResponseEntity(object, (HttpStatusCode)HttpStatus.BAD_REQUEST);
    }

    @ExceptionHandler(value={RunAsExecutionException.class})
    protected ResponseEntity<Object> handleRunAsExecution(RunAsExecutionException runAsExecutionException) {
        GeneralExceptionHandler a = runAsExecutionException;
        GeneralExceptionHandler a2 = this;
        GeneralExceptionHandler generalExceptionHandler = a;
        return a2.buildErrorResponse((Exception)generalExceptionHandler, generalExceptionHandler.getMessage(), (HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR, RUN_AS_ERROR);
    }

    private /* synthetic */ String getCurrentPath() {
        try {
            return ((ServletRequestAttributes)RequestContextHolder.currentRequestAttributes()).getRequest().getRequestURI();
        }
        catch (Exception exception) {
            return BaseModel.m_LA((Object)"\u0015\n\u0011\u0003J\u001e\u000b\u0000\u000b\u0004\u0012\u0005");
        }
    }

    @ExceptionHandler(value={ValidationDefinitionException.class})
    protected ResponseEntity<Object> handleValidationDefinitionException(ValidationDefinitionException validationDefinitionException) {
        GeneralExceptionHandler a = validationDefinitionException;
        GeneralExceptionHandler a2 = this;
        GeneralExceptionHandler generalExceptionHandler = a;
        return a2.buildErrorResponse((Exception)generalExceptionHandler, generalExceptionHandler.getMessage(), (HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR, VALIDATION_DEFINITION_ERROR);
    }

    @ExceptionHandler(value={SmsProviderException.class})
    protected ResponseEntity<Object> handleSmsProviderException(SmsProviderException smsProviderException) {
        GeneralExceptionHandler a = smsProviderException;
        GeneralExceptionHandler a2 = this;
        GeneralExceptionHandler generalExceptionHandler = a;
        return a2.buildErrorResponse((Exception)generalExceptionHandler, generalExceptionHandler.getMessage(), (HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR, SMS_PROVIDER_ERROR);
    }

    @ExceptionHandler(value={SetValueException.class})
    protected ResponseEntity<Object> handleSetValueException(SetValueException setValueException) {
        GeneralExceptionHandler a = setValueException;
        GeneralExceptionHandler a2 = this;
        GeneralExceptionHandler generalExceptionHandler = a;
        return a2.buildErrorResponse((Exception)generalExceptionHandler, generalExceptionHandler.getMessage(), (HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR, SET_VALUE_ERROR);
    }

    @ExceptionHandler(value={AlreadyExistsException.class})
    protected ResponseEntity<Object> handleAlreadyExists(AlreadyExistsException alreadyExistsException) {
        GeneralExceptionHandler a = alreadyExistsException;
        GeneralExceptionHandler a2 = this;
        GeneralExceptionHandler generalExceptionHandler = a;
        return a2.buildErrorResponse((Exception)generalExceptionHandler, generalExceptionHandler.getMessage(), (HttpStatusCode)HttpStatus.CONFLICT, ALREADY_EXISTS_ERROR);
    }

    @ExceptionHandler(value={InfluxDBMapperException.class})
    protected ResponseEntity<Object> handleInfluxDBMapper(InfluxDBMapperException influxDBMapperException) {
        GeneralExceptionHandler a = influxDBMapperException;
        GeneralExceptionHandler a2 = this;
        GeneralExceptionHandler generalExceptionHandler = a;
        return a2.buildErrorResponse((Exception)generalExceptionHandler, generalExceptionHandler.getMessage(), (HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR, DATABASE_ERROR);
    }

    @ExceptionHandler(value={SettingsException.class})
    protected ResponseEntity<Object> handleSettingsException(SettingsException settingsException) {
        GeneralExceptionHandler a = settingsException;
        GeneralExceptionHandler a2 = this;
        GeneralExceptionHandler generalExceptionHandler = a;
        return a2.buildErrorResponse((Exception)generalExceptionHandler, generalExceptionHandler.getMessage(), (HttpStatusCode)HttpStatus.BAD_REQUEST, SETTINGS_ERROR);
    }

    @ExceptionHandler(value={Exception.class})
    protected ResponseEntity<Object> handleAllExceptions(Exception exception) {
        Exception a = exception;
        GeneralExceptionHandler a2 = this;
        Exception exception2 = a;
        return a2.buildErrorResponse(exception2, exception2.getMessage(), (HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR, UNKNOWN_ERROR);
    }

    private /* synthetic */ String formatErrorMessages(Map<String, List<String>> map) {
        Map<String, List<String>> a2 = map;
        GeneralExceptionHandler a3 = this;
        return a2.entrySet().stream().map(a -> (String)a.getKey() + ": " + String.join((CharSequence)Script.m_be((Object)"\u007fJ"), (Iterable)a.getValue())).collect(Collectors.joining(Script.m_be((Object)"J/J")));
    }

    @ExceptionHandler(value={SpaceOperationException.class})
    protected ResponseEntity<Object> handleSpaceOperationException(SpaceOperationException spaceOperationException) {
        GeneralExceptionHandler a = spaceOperationException;
        GeneralExceptionHandler a2 = this;
        GeneralExceptionHandler generalExceptionHandler = a;
        return a2.buildErrorResponse((Exception)generalExceptionHandler, generalExceptionHandler.getMessage(), (HttpStatusCode)HttpStatus.BAD_REQUEST, SPACE_OPERATION_ERROR);
    }

    @ExceptionHandler(value={ConstraintViolationException.class})
    protected ResponseEntity<Object> handleConstraintViolation(ConstraintViolationException constraintViolationException) {
        GeneralExceptionHandler a2 = constraintViolationException;
        GeneralExceptionHandler a3 = this;
        Map map = a2.getConstraintViolations().stream().collect(Collectors.groupingBy(a -> a.getPropertyPath().toString(), Collectors.mapping(ConstraintViolation::getMessage, Collectors.toList())));
        GeneralExceptionHandler generalExceptionHandler = a3;
        a2 = generalExceptionHandler.createExceptionDetails((HttpStatusCode)HttpStatus.CONFLICT, generalExceptionHandler.formatErrorMessages(map), (Exception)a2, CONSTRAINT_VIOLATION, map);
        log.error(BaseModel.m_LA((Object)"&\u0004\u000b\u0018\u0011\u0019\u0004\u0002\u000b\u001fE\u001d\f\u0004\t\n\u0011\u0002\n\u0005_K\u001e\u0016"), (Object)a2);
        return new ResponseEntity((Object)a2, (HttpStatusCode)HttpStatus.CONFLICT);
    }

    @ExceptionHandler(value={IllegalArgumentException.class})
    protected ResponseEntity<Object> handleIllegalArgument(IllegalArgumentException illegalArgumentException) {
        IllegalArgumentException a = illegalArgumentException;
        GeneralExceptionHandler a2 = this;
        IllegalArgumentException illegalArgumentException2 = a;
        return a2.buildErrorResponse((Exception)illegalArgumentException2, illegalArgumentException2.getMessage(), (HttpStatusCode)HttpStatus.BAD_REQUEST, VALIDATION_ERROR);
    }
}

