/*
 * Decompiled with CFR 0.152.
 */
package com.inscada.mono.datatransfer.services;

import com.inscada.mono.auth.c_Hj;
import com.inscada.mono.cluster.exceptions.ClusterRpcException;
import com.inscada.mono.cluster.services.ClusterNodeListener;
import com.inscada.mono.cluster.services.c_K;
import com.inscada.mono.communication.base.f.c_Jl;
import com.inscada.mono.communication.base.f.c_Kl;
import com.inscada.mono.communication.base.model.Variable;
import com.inscada.mono.communication.base.model.values.NumberVariableValue;
import com.inscada.mono.communication.base.model.values.VariableValue;
import com.inscada.mono.communication.base.model.values.logged.LoggedVariableValueStats;
import com.inscada.mono.communication.base.services.c_FI;
import com.inscada.mono.communication.base.services.c_Si;
import com.inscada.mono.communication.base.services.c_fi;
import com.inscada.mono.datatransfer.f.c_dc;
import com.inscada.mono.datatransfer.model.DataTransfer;
import com.inscada.mono.datatransfer.model.DataTransferDetail;
import com.inscada.mono.datatransfer.model.DataTransferSummary;
import com.inscada.mono.datatransfer.q.c_Gc;
import com.inscada.mono.datatransfer.q.c_gA;
import com.inscada.mono.datatransfer.services.c_VB;
import com.inscada.mono.datatransfer.services.c_rb;
import com.inscada.mono.job.f.c_Kc;
import com.inscada.mono.job.model.Job;
import com.inscada.mono.job.model.PeriodicJob;
import com.inscada.mono.job.q.c_iB;
import com.inscada.mono.log.q.c_BC;
import com.inscada.mono.project.q.c_D;
import com.inscada.mono.settings.q.c_ub;
import com.inscada.mono.shared.exceptions.NotActiveException;
import com.inscada.mono.shared.model.BaseModel;
import com.inscada.mono.shared.model.OwnedSpaceBaseModel;
import jakarta.annotation.PostConstruct;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Component;
import org.springframework.transaction.event.TransactionalEventListener;
import redis.clients.jedis.JedisPooled;

@Component
public class DataTransferManager
implements ClusterNodeListener,
c_D {
    public static final short f_PG = 404;
    private static final Logger f_xg = LoggerFactory.getLogger(DataTransferManager.class);
    private final Map<String, Job> f_ki;
    private final c_BC f_Bh;
    public static final short f_QG = 405;
    private final c_rb f_Ni;
    private final c_fi f_YI;
    public static final short f_mI = 401;
    public static final short f_Ji = 403;
    private final c_FI f_Xh;
    private final c_Kc f_EI;
    private final c_Hj f_wG;
    public static final short f_ai = 406;
    private final Lock f_sG;
    public static final short f_vH = 402;
    private static final String f_cI = "scheduledDataTransfers";
    private final JedisPooled f_gi;
    private final c_K f_FI;
    public static final short f_ji = 407;
    private final c_Si f_Si;

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void lambda$notLeader$2(String string, String string2) {
        void a;
        DataTransferManager dataTransferManager = this;
        DataTransferManager a22 = (Job)dataTransferManager.f_ki.get(a);
        if (a22 != null) {
            void a3;
            try {
                f_xg.info(c_iB.m_fK((Object)"_vovOezyhq~eVvuv|ri73Ytc;[~v\u007fri7`j2-;Tzyxrw{ry|7wxxvw7qxy7}xi7\u007fvov;civud}ri7RS!7`j"), (Object)a3, (Object)a);
                dataTransferManager.f_EI.m_km((Job)a22);
                return;
            }
            catch (Exception a22) {
                Object[] objectArray = new Object[--4];
                objectArray[3 & 4] = a3;
                objectArray[4 ^ 5] = a;
                objectArray[--2] = a22.getMessage();
                objectArray[--3] = a22;
                f_xg.error(c_ub.m_vF((Object)"8\n\b\n(\u0019\u001d\u0005\u000f\r\u0019\u00191\n\u0012\n\u001b\u000e\u000eKT%\u0013\u001f\\'\u0019\n\u0018\u000e\u000eK\u0007\u0016UQ\\.\u000e\u0019\u0013\u0019\\\b\u001d\u0005\u001f\u000e\u0010\u0007\u0015\u0005\u001bK\u0010\u0004\u001f\n\u0010K\u0016\u0004\u001eK\u001a\u0004\u000eK\u0018\n\b\n\\\u001f\u000e\n\u0012\u0018\u001a\u000e\u000eK5/\\\u0010\u0001Q\\\u0010\u0001"), objectArray);
            }
        }
    }

    @PostConstruct
    private /* synthetic */ void initializeClusterIntegration() {
        DataTransferManager a;
        DataTransferManager dataTransferManager = a;
        dataTransferManager.registerRemoteCallsWithClusterNode();
        dataTransferManager.f_FI.m_Ba((ClusterNodeListener)a);
        f_xg.info(c_iB.m_fK((Object)"_vovOezyhq~eVvuv|ri7ryrcrvw~ar\u007f7zy\u007f7ir|~hc~e~s;vh7X{ndoriYts~[rdoruri9"));
    }

    @PreAuthorize(value="hasAuthority('SCHEDULE_DATA_TRANSFER')")
    public void scheduleDataTransfer(String string) {
        Object a = string;
        DataTransferManager a2 = this;
        if (a2.f_FI.m_r()) {
            f_xg.debug(c_iB.m_fK((Object)"WRZS^E!7Htsr\u007fbw~up;szcz7oezyhq~e;lf7wxxvw{b9"), a);
            a2.scheduleDataTransferInternal((String)a);
            return;
        }
        f_xg.debug(c_ub.m_vF((Object)"2$2F0.=/99FK.\u000e\r\u001e\u0019\u0018\b\u0002\u0012\f\\\u0007\u0019\n\u0018\u000e\u000eK\b\u0004\\\u0018\u001f\u0003\u0019\u000f\t\u0007\u0019K\u0018\n\b\n\\\u001f\u000e\n\u0012\u0018\u001a\u000e\u000eK\u0007\u0016R"), a);
        try {
            Object[] objectArray = new Object[2 ^ 3];
            objectArray[3 >> 2] = a;
            a2.f_FI.m_ia(Short.valueOf((short)(0x459D & 0x3BF3)), objectArray);
            return;
        }
        catch (Exception exception) {
            throw new ClusterRpcException("Failed to RPC schedule data transfer " + (String)a, (Throwable)exception);
        }
    }

    /*
     * WARNING - void declaration
     */
    @PreAuthorize(value="hasAuthority('CANCEL_DATA_TRANSFER')")
    public void cancelDataTransfer(String string, String string2) {
        void a;
        DataTransferManager a2;
        Object a3 = string2;
        DataTransferManager dataTransferManager = a2 = this;
        dataTransferManager.cancelDataTransfer(dataTransferManager.f_Ni.m_fn((String)a, (String)a3).getId());
    }

    @PreAuthorize(value="hasAuthority('SCHEDULE_DATA_TRANSFER')")
    public void scheduleDataTransfers(String string) {
        Object a = string;
        DataTransferManager a2 = this;
        if (a2.f_FI.m_r()) {
            f_xg.debug(c_iB.m_fK((Object)"[^V_RI-;Dx\u007f~sn{ry|7z{w7\u007fvov;civud}rid;qte;gixqrxc;lf7wxxvw{b9"), a);
            a2.scheduleDataTransfersByProjectIdInternal((String)a);
            return;
        }
        f_xg.debug(c_ub.m_vF((Object)"%3%Q'9*8..Q\\9\u0019\u001a\t\u000e\u000f\u001f\u0015\u0005\u001bK\u0010\u000e\u001d\u000f\u0019\u0019\\\u001f\u0013K\u000f\b\u0014\u000e\u0018\u001e\u0010\u000e\\\n\u0010\u0007\\\u000f\u001d\u001f\u001dK\b\u0019\u001d\u0005\u000f\r\u0019\u0019\u000fK\u001a\u0004\u000eK\f\u0019\u0013\u0001\u0019\b\bK\u0007\u0016R"), a);
        try {
            Object[] objectArray = new Object[2 ^ 3];
            objectArray[3 ^ 3] = a;
            a2.f_FI.m_ia(Short.valueOf((short)(0x37DC & 0x49B7)), objectArray);
            return;
        }
        catch (Exception exception) {
            throw new ClusterRpcException("Failed to RPC schedule data transfers for project " + (String)a, (Throwable)exception);
        }
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ boolean isValueInThresholdRange(Double d, Double d2, VariableValue<?> variableValue) {
        void a;
        void a2;
        VariableValue<?> a3 = variableValue;
        VariableValue<?> a4 = this;
        return a4.isValueInThresholdRange((Double)a2, (VariableValue)new NumberVariableValue((Number)a, new Date()), a3);
    }

    private /* synthetic */ void lambda$cancelDataTransferInternal$6(DataTransfer dataTransfer) {
        DataTransferManager a = dataTransfer;
        DataTransferManager a2 = this;
        a2.f_sG.lock();
        try {
            Job job = (Job)a2.f_ki.get(a.getId());
            if (job != null) {
                a2.f_EI.m_km(job);
            }
            DataTransferManager dataTransferManager = a2;
            dataTransferManager.f_ki.remove(a.getId());
            String[] stringArray = new String[--1];
            stringArray[3 & 4] = a.getId();
            dataTransferManager.f_gi.srem(f_cI, stringArray);
            return;
        }
        finally {
            a2.f_sG.unlock();
        }
    }

    @PreAuthorize(value="hasAuthority('VIEW_DATA_TRANSFER')")
    public c_dc getDataTransferStatus(String string) {
        Object a = string;
        DataTransferManager a2 = this;
        if (a2.f_FI.m_r()) {
            f_xg.debug(c_ub.m_vF((Object)"'9*8..Q\\,\u0019\u001f\b\u0002\u0012\f\\\u000f\u001d\u001f\u001dK\b\u0019\u001d\u0005\u000f\r\u0019\u0019\\\u0018\b\n\b\u001e\u000fK\u001a\u0004\u000eK5/FK\u0007\u0016\\\u0007\u0013\b\u001d\u0007\u0010\u0012R"), a);
            return a2.getDataTransferStatusInternal((String)a);
        }
        f_xg.debug(c_iB.m_fK((Object)"UXU:WRZS^E!7Irjb~do~up;{~v\u007fri7}xi7\u007fvov;civud}ri7hczcnd;qte;^_-;lf9"), a);
        try {
            Object[] objectArray = new Object[5 >> 2];
            objectArray[3 & 4] = a;
            return (c_dc)a2.f_FI.m_ia(Short.valueOf((short)(0x1BFF & 0x6593)), objectArray);
        }
        catch (Exception exception) {
            throw new ClusterRpcException("Failed to RPC get data transfer status for " + (String)a, (Throwable)exception);
        }
    }

    protected void scheduleDataTransferInternal(String string) {
        DataTransferManager a;
        Object a2 = string;
        DataTransferManager dataTransferManager = a = this;
        dataTransferManager.scheduleDataTransferInternal(dataTransferManager.f_Ni.m_Mn((String)a2));
    }

    @PreAuthorize(value="hasAuthority('VIEW_DATA_TRANSFER')")
    public Map<String, c_dc> getDataTransferStatuses(List<String> list) {
        List<String> a = list;
        DataTransferManager a2 = this;
        if (a == null || a.isEmpty()) {
            return Collections.emptyMap();
        }
        if (a2.f_FI.m_r()) {
            f_xg.debug(c_ub.m_vF((Object)"0.=/99FK;\u000e\b\u001f\u0015\u0005\u001bK\u0018\n\b\n\\\u001f\u000e\n\u0012\u0018\u001a\u000e\u000eK\u000f\u001f\u001d\u001f\t\u0018\u0019\u0018\\\r\u0013\u0019\\\u0010\u0001K5/\u000fK\u0010\u0004\u001f\n\u0010\u0007\u0005Q\\\u0010\u0001"), (Object)a.size(), (Object)a);
            return a2.getDataTransferStatusesByIdsInternal((List)a);
        }
        f_xg.debug(c_iB.m_fK((Object)"YTY6[^V_RI-;E~fnrhcry|7wrzs~e;qte;szcz7oezyhq~e;dovobhrh7}xi7`j;^_d!7`j"), (Object)a.size(), (Object)a);
        try {
            Object[] objectArray = new Object[--1];
            objectArray[5 >> 3] = new ArrayList(a);
            return (Map)a2.f_FI.m_ia(Short.valueOf((short)(0x6BDE & 0x15B7)), objectArray);
        }
        catch (Exception exception) {
            throw new ClusterRpcException("Failed to RPC get data transfer statuses for IDs " + a.stream().map(String::valueOf).collect(Collectors.joining(c_ub.m_vF((Object)"P"))), (Throwable)exception);
        }
    }

    protected Map<String, c_dc> getDataTransferStatusesByProjectIdInternal(String string) {
        Object a = string;
        DataTransferManager a2 = this;
        if ((a = a2.f_Ni.m_Qm((String)a)) == null || a.isEmpty()) {
            return Collections.emptyMap();
        }
        return a.stream().collect(Collectors.toMap(DataTransferSummary::getId, dataTransferSummary -> {
            DataTransferManager a = dataTransferSummary;
            DataTransferManager a2 = this;
            return a2.getDataTransferStatusInternal(a.getId());
        }));
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void handleCurrentValues(List<DataTransferDetail> list, Map<String, Map<String, Object>> map) {
        void a;
        void a2;
        DataTransferManager dataTransferManager = this;
        Object object = (String[])a2.stream().map(DataTransferDetail::getSourceVariableId).toArray(String[]::new);
        Object a3 = a2.stream().map(DataTransferDetail::getTargetVariableId).collect(Collectors.toList());
        Map map2 = dataTransferManager.f_YI.m_HCa((List)a3).stream().collect(Collectors.toMap(BaseModel::getId, Function.identity()));
        DataTransferManager dataTransferManager2 = dataTransferManager;
        object = dataTransferManager2.f_Xh.m_Nca(object);
        a3 = dataTransferManager2.f_Xh.m_Nca((String[])a3.toArray(String[]::new));
        a2.forEach(arg_0 -> dataTransferManager.lambda$handleCurrentValues$10((Map)object, (Map)a3, map2, (Map)a, arg_0));
    }

    protected void cancelDataTransferInternal(String string) {
        DataTransferManager a;
        Object a2 = string;
        DataTransferManager dataTransferManager = a = this;
        dataTransferManager.cancelDataTransferInternal(dataTransferManager.f_Ni.m_Wn((String)a2));
    }

    @PreAuthorize(value="hasAuthority('CANCEL_DATA_TRANSFER')")
    public void cancelDataTransfers(String string) {
        Object a = string;
        DataTransferManager a2 = this;
        if (a2.f_FI.m_r()) {
            f_xg.debug(c_iB.m_fK((Object)"[^V_RI-;Tzyxrw{ry|7z{w7\u007fvov;civud}rid;qte;gixqrxc;lf7wxxvw{b9"), a);
            a2.cancelDataTransfersByProjectIdInternal((String)a);
            return;
        }
        f_xg.debug(c_ub.m_vF((Object)"%3%Q'9*8..Q\\9\u0019\u001a\t\u000e\u000f\u001f\u0015\u0005\u001bK\u0010\u000e\u001d\u000f\u0019\u0019\\\u001f\u0013K\u001f\n\u0012\b\u0019\u0007\\\n\u0010\u0007\\\u000f\u001d\u001f\u001dK\b\u0019\u001d\u0005\u000f\r\u0019\u0019\u000fK\u001a\u0004\u000eK\f\u0019\u0013\u0001\u0019\b\bK\u0007\u0016R"), a);
        try {
            Object[] objectArray = new Object[5 >> 2];
            objectArray[2 & 5] = a;
            a2.f_FI.m_ia(Short.valueOf((short)(0x559F & 0x2BF5)), objectArray);
            return;
        }
        catch (Exception exception) {
            throw new ClusterRpcException("Failed to RPC cancel data transfers for project " + (String)a, (Throwable)exception);
        }
    }

    @PreAuthorize(value="hasAuthority('VIEW_DATA_TRANSFER')")
    public Map<String, c_dc> getDataTransferStatuses(String string) {
        Object a = string;
        DataTransferManager a2 = this;
        if (a2.f_FI.m_r()) {
            f_xg.debug(c_iB.m_fK((Object)"WRZS^E!7\\rocry|7z{w7\u007fvov;civud}ri7hczcnd~d;qte;gixqrxc;lf7wxxvw{b9"), a);
            return a2.getDataTransferStatusesByProjectIdInternal((String)a);
        }
        f_xg.debug(c_ub.m_vF((Object)"%3%Q'9*8..Q\\9\u0019\u001a\t\u000e\u000f\u001f\u0015\u0005\u001bK\u0010\u000e\u001d\u000f\u0019\u0019\\\r\u0013\u0019\\\n\u0010\u0007\\\u000f\u001d\u001f\u001dK\b\u0019\u001d\u0005\u000f\r\u0019\u0019\\\u0018\b\n\b\u001e\u000f\u000e\u000fK\u001a\u0004\u000eK\f\u0019\u0013\u0001\u0019\b\bK\u0007\u0016R"), a);
        try {
            Object[] objectArray = new Object[3 & 5];
            objectArray[3 & 4] = a;
            return (Map)a2.f_FI.m_ia(Short.valueOf((short)(0x47BF & 0x39D7)), objectArray);
        }
        catch (Exception exception) {
            throw new ClusterRpcException("Failed to RPC get statuses for project" + (String)a, (Throwable)exception);
        }
    }

    protected void cancelDataTransfersByProjectIdInternal(String string) {
        Object a = string;
        DataTransferManager a2 = this;
        if ((a = a2.f_Ni.m_sO((String)a)) == null || a.isEmpty()) {
            return;
        }
        a.forEach(arg_0 -> a2.cancelDataTransferInternal(arg_0));
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void updateVariableWithCachedValue(String string, DataTransferDetail dataTransferDetail, Map<String, Variable<?, ?, ?>> map, Map<String, Map<String, Object>> map2, Map<String, VariableValue<?>> map3) {
        void a;
        Variable a2;
        Object a3 = string;
        DataTransferManager a4 = this;
        if ((a2 = (Variable)a2.get(a.getTargetVariableId())) != null) {
            void a5;
            double d = Double.parseDouble((String)a3);
            a3 = (VariableValue)a5.get(a.getTargetVariableId());
            if (a4.isValueInThresholdRange(a.getThreshold(), Double.valueOf(d), (VariableValue)a3)) {
                void a6;
                a3 = new HashMap<String, Double>();
                a3.put(c_ub.m_vF((Object)"\n\n\u0010\u001e\u0019"), d);
                a6.put(a2.getName(), a3);
            }
        }
    }

    protected void scheduleDataTransferInternal(DataTransfer dataTransfer) {
        DataTransferManager a = dataTransfer;
        DataTransferManager a2 = this;
        a2.f_wG.m_bea(() -> a2.lambda$scheduleDataTransferInternal$5((DataTransfer)a), (OwnedSpaceBaseModel)a);
    }

    public void deactivateForProject(String string) {
        Object a = string;
        DataTransferManager a2 = this;
        if (a2.f_FI.m_r()) {
            f_xg.info(c_iB.m_fK((Object)"WRZS^E!7Svusw~up;Gixqrxc_rzto~mvor^a~yo7}xi7ket}~to7RS!7`j"), a);
            a2.cancelDataTransfersByProjectIdInternal((String)a);
            return;
        }
        f_xg.debug(c_ub.m_vF((Object)"%3%Q'9*8..Q\\\"\u001b\u0005\u0013\u0019\u0015\u0005\u001bK,\u0019\u0013\u0001\u0019\b\b/\u0019\n\u001f\u001f\u0015\u001d\u001d\u001f\u0019.\n\u000e\u0012\u001f\\\r\u0013\u0019\\\u001b\u000e\u0004\u0016\u000e\u001f\u001f\\\"8Q\\\u0010\u0001"), a);
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void lambda$handleCurrentValues$10(Map map, Map map2, Map map3, Map map4, DataTransferDetail dataTransferDetail) {
        Variable a;
        void a2;
        VariableValue a3;
        Object a4 = map2;
        DataTransferManager a5 = this;
        a3 = (VariableValue)a3.get(a2.getSourceVariableId());
        a4 = (VariableValue)a4.get(a2.getTargetVariableId());
        a = (Variable)a.get(a2.getTargetVariableId());
        if (a3 != null && a != null && a5.isValueInThresholdRange(a2.getThreshold(), a3, (VariableValue)a4)) {
            void a6;
            a4 = new HashMap<String, Object>();
            a4.put(c_iB.m_fK((Object)"az{nr"), a3.getValue());
            a6.put(a.getName(), a4);
        }
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ boolean lambda$handleStatValues$12(Date date, Map map, Map map2, Map map3, DataTransferDetail dataTransferDetail) {
        void a;
        void a2;
        DataTransferManager dataTransferManager;
        DataTransferManager dataTransferManager2 = dataTransferManager = this;
        Object a3 = dataTransferManager2.buildStatCacheKey((DataTransferDetail)a2);
        if (!dataTransferManager2.shouldRecalculateStats((DataTransferDetail)a2, (Date)a, (String)(a3 = dataTransferManager2.f_gi.get((String)a3)))) {
            void a4;
            void a5;
            void a6;
            dataTransferManager.updateVariableWithCachedValue((String)a3, (DataTransferDetail)a2, (Map)a6, (Map)a5, (Map)a4);
            return 5 >> 3;
        }
        return true;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    private /* synthetic */ boolean shouldRecalculateStats(DataTransferDetail dataTransferDetail, Date date, String string) {
        int n;
        void a;
        void a2;
        Object a222 = string;
        DataTransferManager a3 = this;
        if (a222 == null) {
            return (4 ^ 5) != 0;
        }
        a222 = Calendar.getInstance();
        String string2 = a3.f_gi.get(a3.buildStatLastCalcTimeKey((DataTransferDetail)a2));
        if (string2 == null) {
            return (4 ^ 5) != 0;
        }
        ((Calendar)a222).setTimeInMillis(Long.parseLong(string2));
        Calendar calendar = Calendar.getInstance();
        calendar.setTime((Date)a);
        switch (c_VB.f_RH[a2.getRangeType().ordinal()]) {
            default: {
                throw new IncompatibleClassChangeError();
            }
            case 1: 
            case 2: {
                int n2;
                if (((Calendar)a222).get(0x7F & 0xB) != calendar.get(0xF & 0x7B)) {
                    n2 = 2 ^ 3;
                    break;
                }
                n2 = 0;
                break;
            }
            case 3: 
            case 4: {
                int n2;
                if (((Calendar)a222).get(0xE & 0x77) != calendar.get(0x2F & 0x56)) {
                    n2 = 5 >> 2;
                    break;
                }
                n2 = 0;
                break;
            }
            case 5: 
            case 6: {
                int n2;
                if (((Calendar)a222).get(--3) != calendar.get(--3)) {
                    n2 = 3 >> 1;
                    break;
                }
                n2 = 0;
                break;
            }
            case 7: 
            case 8: {
                int n2;
                if (((Calendar)a222).get(--2) != calendar.get(1 ^ 3)) {
                    n2 = 3 & 5;
                    break;
                }
                n2 = 0;
                break;
            }
            case 9: 
            case 10: {
                int n2 = n = ((Calendar)a222).get(--1) != calendar.get(3 & 5) ? 4 ^ 5 : 0;
            }
        }
        if (n != 0) {
            DataTransferManager dataTransferManager = a3;
            a222 = dataTransferManager.buildStatCacheKey((DataTransferDetail)a2);
            String string3 = dataTransferManager.buildStatLastCalcTimeKey((DataTransferDetail)a2);
            String[] stringArray = new String[--2];
            stringArray[0] = a222;
            stringArray[1] = string3;
            dataTransferManager.f_gi.del(stringArray);
            return true;
        }
        if (!a2.getRangeType().toString().startsWith(c_iB.m_fK((Object)"Tneiruc"))) {
            return false;
        }
        int a222 = switch (c_VB.f_RH[a2.getRangeType().ordinal()]) {
            case 1 -> 5;
            case 3 -> 5;
            case 5 -> 60;
            case 7 -> 720;
            case 9 -> 720;
            default -> throw new IllegalArgumentException("Unexpected range type: " + String.valueOf(a2.getRangeType()));
        };
        long l = a.getTime();
        long l2 = Long.parseLong(string2);
        return l - l2 >= (long)(a222 * (0x3C & 0x7F) * (0xFEA & 0x73FD));
    }

    @PreAuthorize(value="hasAuthority('CANCEL_DATA_TRANSFER')")
    public void cancelDataTransfer(String string) {
        Object a = string;
        DataTransferManager a2 = this;
        if (a2.f_FI.m_r()) {
            f_xg.debug(c_iB.m_fK((Object)"WRZS^E!7Xvut~{w~up;szcz7oezyhq~e;lf7wxxvw{b9"), a);
            a2.cancelDataTransferInternal((String)a);
            return;
        }
        f_xg.debug(c_ub.m_vF((Object)"2$2F0.=/99FK.\u000e\r\u001e\u0019\u0018\b\u0002\u0012\f\\\u0007\u0019\n\u0018\u000e\u000eK\b\u0004\\\b\u001d\u0005\u001f\u000e\u0010K\u0018\n\b\n\\\u001f\u000e\n\u0012\u0018\u001a\u000e\u000eK\u0007\u0016R"), a);
        try {
            Object[] objectArray = new Object[5 >> 2];
            objectArray[3 & 4] = a;
            a2.f_FI.m_ia(Short.valueOf((short)(0x63B2 & 0x1DDF)), objectArray);
            return;
        }
        catch (Exception exception) {
            throw new ClusterRpcException("Failed to RPC cancel data transfer " + (String)a, (Throwable)exception);
        }
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    private /* synthetic */ double extractValue(LoggedVariableValueStats loggedVariableValueStats, c_Kl c_Kl2) {
        void a;
        DataTransferManager a2 = loggedVariableValueStats;
        DataTransferManager a3 = this;
        switch (c_VB.f_Oh[a.ordinal()]) {
            case 1: {
                return a2.getMinValue();
            }
            case 2: {
                return a2.getMaxValue();
            }
            case 3: {
                return a2.getAvgValue();
            }
            case 4: {
                return a2.getSumValue();
            }
            case 5: {
                return a2.getCountValue();
            }
            case 6: {
                return a2.getFirstValue();
            }
            case 7: {
                return a2.getLastValue();
            }
            case 8: {
                return a2.getMaxDiffValue();
            }
            case 9: {
                return a2.getLastFirstDiffValue();
            }
            case 10: {
                return a2.getMiddleValue();
            }
            case 11: {
                return a2.getMedianValue();
            }
        }
        throw new IllegalArgumentException("Unexpected calculation type: " + String.valueOf(a));
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ Pair<Date, Date> calculateDateRange(Date date, c_Jl c_Jl2) {
        void a;
        void a2;
        Object a3;
        DataTransferManager dataTransferManager = this;
        Object object = a3 = Calendar.getInstance();
        ((Calendar)a3).setTime((Date)a2);
        ((Calendar)object).set(0x1D & 0x6F, 3 & 4);
        ((Calendar)object).set(0x2F & 0x5E, 3 >> 2);
        Calendar calendar = (Calendar)((Calendar)object).clone();
        switch (c_VB.f_RH[a.ordinal()]) {
            case 1: {
                Object object2 = a3;
                while (false) {
                }
                ((Calendar)object2).set(0x4E & 0x3D, 3 >> 2);
                return Pair.of((Object)((Calendar)object2).getTime(), (Object)a2);
            }
            case 2: {
                calendar.add(0xB & 0x7F, -4 >> 2);
                Object object3 = a3;
                ((Calendar)object3).add(0x2B & 0x5F, 0xFFFFFFFE & 0xFFFFFFFF);
                ((Calendar)object3).set(0x7C & 0xF, 3 ^ 3);
                return Pair.of((Object)((Calendar)object3).getTime(), (Object)calendar.getTime());
            }
            case 3: {
                Object object4 = a3;
                ((Calendar)object4).set(0x7B & 0xF, 3 ^ 3);
                ((Calendar)object4).set(0x7D & 0xE, 3 & 4);
                return Pair.of((Object)((Calendar)a3).getTime(), (Object)a2);
            }
            case 4: {
                calendar.add(--5, -4 >> 2);
                Object object5 = a3;
                ((Calendar)a3).add(--5, -2);
                ((Calendar)object5).set(11, 3 ^ 3);
                ((Calendar)object5).set(0x6D & 0x1E, 5 >> 3);
                return Pair.of((Object)((Calendar)object5).getTime(), (Object)calendar.getTime());
            }
            case 5: {
                Object object6 = a3;
                Object object7 = a3;
                ((Calendar)object7).set(7, ((Calendar)object7).getFirstDayOfWeek());
                ((Calendar)object6).set(11, 2 & 5);
                ((Calendar)object6).set(12, 0);
                return Pair.of((Object)((Calendar)a3).getTime(), (Object)a2);
            }
            case 6: {
                calendar.add(--3, -4 >> 2);
                Object object8 = a3;
                ((Calendar)a3).add(--3, -2);
                Object object9 = a3;
                ((Calendar)object9).set(7, ((Calendar)object9).getFirstDayOfWeek());
                ((Calendar)object8).set(11, 0);
                ((Calendar)object8).set(12, 0);
                return Pair.of((Object)((Calendar)object8).getTime(), (Object)calendar.getTime());
            }
            case 7: {
                Object object10 = a3;
                ((Calendar)a3).set(--5, 1);
                ((Calendar)object10).set(11, 0);
                ((Calendar)object10).set(12, 0);
                return Pair.of((Object)((Calendar)a3).getTime(), (Object)a2);
            }
            case 8: {
                calendar.add(5 >> 1, -4 >> 2);
                Object object11 = a3;
                Object object12 = a3;
                ((Calendar)object12).add(2, -2);
                ((Calendar)object12).set(5, 1);
                ((Calendar)object11).set(11, 0);
                ((Calendar)object11).set(12, 0);
                return Pair.of((Object)((Calendar)object11).getTime(), (Object)calendar.getTime());
            }
            case 9: {
                Object object13 = a3;
                ((Calendar)a3).set(6, 1);
                ((Calendar)object13).set(11, 0);
                ((Calendar)object13).set(12, 0);
                return Pair.of((Object)((Calendar)a3).getTime(), (Object)a2);
            }
            case 10: {
                calendar.add(1, -1);
                Object object14 = a3;
                Object object15 = a3;
                ((Calendar)object15).add(1, -2);
                ((Calendar)object15).set(6, 1);
                ((Calendar)object14).set(11, 0);
                ((Calendar)object14).set(12, 0);
                return Pair.of((Object)((Calendar)object14).getTime(), (Object)calendar.getTime());
            }
        }
        throw new IllegalArgumentException(c_iB.m_fK((Object)"Burcg~tor\u007f7ivup~7onkr"));
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void lambda$handleStatValues$16(Map map, Map map2, Map map3, Map map4, DataTransferDetail dataTransferDetail) {
        Variable a;
        DataTransferManager a2;
        Object a3;
        DataTransferManager dataTransferManager = dataTransferManager2;
        DataTransferManager dataTransferManager2 = dataTransferDetail;
        DataTransferManager a4 = dataTransferManager;
        if ((a3 = (LoggedVariableValueStats)a3.get(a2.getSourceVariableId())) != null && (a = (Variable)a.get(a2.getTargetVariableId())) != null) {
            String a5;
            double d = a4.extractValue(a3, a2.getCalcType());
            a3 = (VariableValue)a5.get(a2.getTargetVariableId());
            DataTransferManager dataTransferManager3 = a4;
            a5 = dataTransferManager3.buildStatCacheKey((DataTransferDetail)a2);
            String string = dataTransferManager3.buildStatLastCalcTimeKey((DataTransferDetail)a2);
            int n = dataTransferManager3.getMaxTTLForRangeType(a2.getRangeType());
            dataTransferManager3.f_gi.setex(a5, (long)n, String.valueOf(d));
            a4.f_gi.setex(string, (long)n, String.valueOf(System.currentTimeMillis()));
            if (dataTransferManager3.isValueInThresholdRange(a2.getThreshold(), Double.valueOf(d), (VariableValue)a3)) {
                void a6;
                a3 = new HashMap<String, Double>();
                a3.put(c_ub.m_vF((Object)"\n\n\u0010\u001e\u0019"), d);
                a6.put(a.getName(), a3);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void transfer(DataTransfer dataTransfer) {
        void a;
        DataTransferManager dataTransferManager = this;
        if (a.getDataTransferDetails() == null || a.getDataTransferDetails().isEmpty()) {
            return;
        }
        ArrayList arrayList = new ArrayList();
        ArrayList arrayList2 = new ArrayList();
        a.getDataTransferDetails().forEach(dataTransferDetail -> {
            void a;
            List a2 = dataTransferDetail;
            List a3 = arrayList2;
            if (a2.getCalcType() != null && a2.getRangeType() != null) {
                a3.add(a2);
                return;
            }
            a.add(a2);
        });
        HashMap a2 = new HashMap();
        if (!arrayList.isEmpty()) {
            dataTransferManager.handleCurrentValues(arrayList, (Map)a2);
        }
        if (!arrayList2.isEmpty()) {
            dataTransferManager.handleStatValues(arrayList2, (Map)a2);
        }
        if (!a2.isEmpty()) {
            dataTransferManager.f_Xh.m_oAa(a.getProjectId(), (Map)a2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void leader() {
        DataTransferManager dataTransferManager;
        DataTransferManager dataTransferManager2 = dataTransferManager = this;
        Object a = dataTransferManager2.f_FI.m_Ga();
        f_xg.info(c_ub.m_vF((Object)"/\u001d\u001f\u001d?\u000e\n\u0012\u0018\u001a\u000e\u000e&\u001d\u0005\u001d\f\u0019\u0019FK(\u0003\u0015\u0018\\\u0005\u0013\u000f\u0019KT\u0010\u0001B\\\u0003\u001d\u0018\\\t\u0019\b\u0013\u0006\u0019K\b\u0003\u0019K0.=/99RK.\u000e\u000f\u001f\u0013\u0019\u0015\u0005\u001bK\u000f\b\u0014\u000e\u0018\u001e\u0010\u000e\u0018K\u0018\n\b\n\\\u001f\u000e\n\u0012\u0018\u001a\u000e\u000e\u0018RER"), a);
        dataTransferManager2.f_sG.lock();
        try {
            HashSet hashSet = new HashSet(dataTransferManager.f_gi.smembers(f_cI));
            if (hashSet.isEmpty()) {
                f_xg.info(c_iB.m_fK((Object)"SzczCivud}riZzyzp~e;?Wrzs~e;lf>!7Ux;dx\u007f~sn{~s;szcz7oezyhq~eh7}xny\u007f7ry;E~srd;ct7irhcte~9"), a);
                return;
            }
            Object[] objectArray = new Object[--3];
            objectArray[2 & 5] = a;
            objectArray[3 & 5] = hashSet.size();
            objectArray[1 ^ 3] = hashSet;
            f_xg.info(c_ub.m_vF((Object)"8\n\b\n(\u0019\u001d\u0005\u000f\r\u0019\u00191\n\u0012\n\u001b\u000e\u000eKT'\u0019\n\u0018\u000e\u000eK\u0007\u0016UQ\\-\u0013\u001e\u0012\u000f\\\u0010\u0001K\u000f\b\u0014\u000e\u0018\u001e\u0010\u000e\u0018K\u0018\n\b\n\\\u001f\u000e\n\u0012\u0018\u001a\u000e\u000eK5/\u000fK\u0015\u0005\\9\u0019\u000f\u0015\u0018\\\u001f\u0013K\u000e\u000e\u000f\u001f\u0013\u0019\u0019Q\\\u0010\u0001"), objectArray);
            ArrayList arrayList = new ArrayList();
            String[] stringArray = new String[--1];
            stringArray[3 >> 2] = c_iB.m_fK((Object)"M^^@DSZCZHOEZYHQ^E");
            dataTransferManager.f_wG.m_bga(() -> {
                void a;
                Object a2 = hashSet;
                DataTransferManager a3 = this;
                a.addAll(a3.f_Ni.m_nn((Set)a2));
            }, stringArray);
            f_xg.info(c_ub.m_vF((Object)"8\n\b\n(\u0019\u001d\u0005\u000f\r\u0019\u00191\n\u0012\n\u001b\u000e\u000eKT'\u0019\n\u0018\u000e\u000eK\u0007\u0016UQ\\*\b\u001f\u0019\u0006\f\u001f\u0015\u0005\u001bK\b\u0004\\\u0019\u0019\u0018\b\u0004\u000e\u000e\\\u0010\u0001K\u0018\n\b\n\\\u001f\u000e\n\u0012\u0018\u001a\u000e\u000e\u0018R"), a, (Object)arrayList.size());
            arrayList.forEach(dataTransfer -> {
                void a;
                DataTransferManager dataTransferManager;
                DataTransferManager dataTransferManager2 = dataTransferManager = this;
                Object a2 = dataTransferManager2.f_FI.m_Ga();
                String[] stringArray = new String[5 >> 1];
                stringArray[3 >> 2] = c_iB.m_fK((Object)"HTSR_BWRDSZCZHOEZYHQ^E");
                stringArray[5 >> 2] = c_ub.m_vF((Object)"(=%?.048*(*#?.*28:..");
                dataTransferManager2.f_wG.m_VEa(() -> dataTransferManager.lambda$restoreSingleDataTransferOnLeader$1((String)a2, (DataTransfer)a), a.getSpace(), stringArray);
            });
            f_xg.info(c_iB.m_fK((Object)"_vovOezyhq~eVvuv|ri73[~v\u007fri7`j2-;Qryrdsr\u007f7\u007fvov;civud}ri7irhctezcrxu7kett~dh9"), a);
            return;
        }
        catch (Exception exception) {
            Object[] objectArray = new Object[--3];
            objectArray[5 >> 3] = a;
            objectArray[5 >> 2] = exception.getMessage();
            objectArray[--2] = exception;
            f_xg.error(c_ub.m_vF((Object)"8\n\b\n(\u0019\u001d\u0005\u000f\r\u0019\u00191\n\u0012\n\u001b\u000e\u000eKT'\u0019\n\u0018\u000e\u000eK\u0007\u0016UQ\\.\u000e\u0019\u0013\u0019\\\u000f\t\u0019\u0015\u0005\u001bK\u0018\n\b\n\\\u001f\u000e\n\u0012\u0018\u001a\u000e\u000eK\u000e\u000e\u000f\u001f\u0013\u0019\u001d\u001f\u0015\u0004\u0012K\f\u0019\u0013\b\u0019\u0018\u000fQ\\\u0010\u0001"), objectArray);
            return;
        }
        finally {
            dataTransferManager.f_sG.unlock();
        }
    }

    protected void cancelDataTransferInternal(DataTransfer dataTransfer) {
        DataTransferManager a = dataTransfer;
        DataTransferManager a2 = this;
        a2.f_wG.m_bea(() -> a2.lambda$cancelDataTransferInternal$6((DataTransfer)a), (OwnedSpaceBaseModel)a);
    }

    private /* synthetic */ void lambda$scheduleDataTransferInternal$4(DataTransfer dataTransfer) {
        DataTransferManager a = dataTransfer;
        DataTransferManager a2 = this;
        a2.transfer((DataTransfer)a);
    }

    public void notLeader() {
        DataTransferManager dataTransferManager;
        DataTransferManager dataTransferManager2 = dataTransferManager = this;
        Object a = dataTransferManager2.f_FI.m_Ga();
        f_xg.info(c_iB.m_fK((Object)"SzczCivud}riZzyzp~e!7O\u007frd;yts~73lf>;~h7UX;[TY\\RI7O_^7WRZS^E57Xvut~{w~up;vw{;{ttz{;szcz7oezyhq~e;}tuh959"), a);
        dataTransferManager2.f_sG.lock();
        try {
            new ArrayList(dataTransferManager.f_ki.keySet()).forEach(arg_0 -> dataTransferManager.lambda$notLeader$2((String)a, arg_0));
            dataTransferManager.f_ki.clear();
            f_xg.info(c_ub.m_vF((Object)"/\u001d\u001f\u001d?\u000e\n\u0012\u0018\u001a\u000e\u000e&\u001d\u0005\u001d\f\u0019\u0019\\C2\u0004\bK0\u000e\u001d\u000f\u0019\u0019\\\u0010\u0001BFK=\u0007\u0010K\u0010\u0004\u001f\n\u0010K\u0018\n\b\n\\\u001f\u000e\n\u0012\u0018\u001a\u000e\u000eK\u0016\u0004\u001e\u0018\\\u0003\u001d\u001d\u0019K\u001e\u000e\u0019\u0005\\\u0019\u0019\u001a\t\u000e\u000f\u001f\u0019\u000f\\\u001f\u0013K\u001f\n\u0012\b\u0019\u0007\\\n\u0012\u000f\\\b\u0010\u000e\u001d\u0019\u0019\u000f\\\r\u000e\u0004\u0011K\u0010\u0004\u001f\n\u0010K\b\u0019\u001d\b\u0017\u0002\u0012\fR"), a);
            return;
        }
        catch (Exception exception) {
            Object[] objectArray = new Object[--3];
            objectArray[5 >> 3] = a;
            objectArray[--1] = exception.getMessage();
            objectArray[--2] = exception;
            f_xg.error(c_iB.m_fK((Object)"_vovOezyhq~eVvuv|ri73Ytc;[~v\u007fri7`j2-;Riete;snery|7kett~dh7tq;tzyxrw{ry|7wxxvw7\u007fvov;civud}ri7qxyd!7`j"), objectArray);
            return;
        }
        finally {
            dataTransferManager.f_sG.unlock();
        }
    }

    /*
     * WARNING - void declaration
     */
    @PreAuthorize(value="hasAuthority('SCHEDULE_DATA_TRANSFER')")
    public void scheduleDataTransfer(String string, String string2) {
        void a;
        DataTransferManager a2;
        Object a3 = string2;
        DataTransferManager dataTransferManager = a2 = this;
        dataTransferManager.scheduleDataTransfer(dataTransferManager.f_Ni.m_fn((String)a, (String)a3).getId());
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void lambda$restoreSingleDataTransferOnLeader$1(String string, DataTransfer dataTransfer) {
        void a;
        DataTransferManager a2 = dataTransfer;
        DataTransferManager a3 = this;
        try {
            Object[] objectArray = new Object[--3];
            objectArray[5 >> 3] = a;
            objectArray[5 >> 2] = a2.getName();
            objectArray[5 >> 1] = a2.getId();
            f_xg.info(c_iB.m_fK((Object)"SzczCivud}riZzyzp~e;?Wrzs~e;lf>!7Irhctery|7\u007fvov;civud}ri-;lf73^_-;lf>"), objectArray);
            a3.scheduleDataTransferInternal((DataTransfer)a2);
            return;
        }
        catch (Exception exception) {
            Object[] objectArray = new Object[--3];
            objectArray[3 ^ 3] = a2.getName();
            objectArray[--1] = a2.getId();
            objectArray[1 ^ 3] = ExceptionUtils.getRootCauseMessage((Throwable)exception);
            a3.f_Bh.m_jK(a2.getProject()).m_w("Data Transfer Restore (Leader " + (String)a + ")", c_ub.m_vF((Object)"N\u000fKT\"8Q\\N\u000fB\\\r\u001d\u0002\u0010\u000e\u0018K\b\u0004\\\u0019\u0019\u0018\b\u0004\u000e\u000eRK?\n\t\u0018\u0019Q\\N\u000f").formatted(objectArray));
            try {
                f_xg.warn(c_iB.m_fK((Object)"SzczCivud}riZzyzp~e;?Wrzs~e;lf>!7Zcorvgo~up;ct7xvut~{;szcz7oezyhq~e;lf7zqori7irhctezcrxu7}vr{ne~9"), (Object)a, (Object)a2.getId());
                a3.cancelDataTransferInternal((DataTransfer)a2);
                return;
            }
            catch (Exception exception2) {
                Object[] objectArray2 = new Object[--4];
                objectArray2[2 & 5] = a;
                objectArray2[--1] = a2.getId();
                objectArray2[1 ^ 3] = exception2.getMessage();
                objectArray2[--3] = exception2;
                f_xg.error(c_ub.m_vF((Object)"/\u001d\u001f\u001d?\u000e\n\u0012\u0018\u001a\u000e\u000e&\u001d\u0005\u001d\f\u0019\u0019\\C0\u000e\u001d\u000f\u0019\u0019\\\u0010\u0001BFK:\n\u0015\u0007\u0019\u000f\\\u001f\u0013K\u001f\n\u0012\b\u0019\u0007\\\u000f\u001d\u001f\u001dK\b\u0019\u001d\u0005\u000f\r\u0019\u0019\\\u0010\u0001K\u001d\r\b\u000e\u000eK\u000e\u000e\u000f\u001f\u0013\u0019\u001d\u001f\u0015\u0004\u0012K\u001a\n\u0015\u0007\t\u0019\u0019Q\\\u0010\u0001"), objectArray2);
                return;
            }
        }
    }

    private /* synthetic */ String buildStatCacheKey(DataTransferDetail dataTransferDetail) {
        DataTransferManager a = dataTransferDetail;
        DataTransferManager a2 = this;
        Object[] objectArray = new Object[--3];
        objectArray[5 >> 3] = a.getSourceVariableId();
        objectArray[--1] = a.getRangeType();
        objectArray[1 ^ 3] = a.getCalcType();
        return c_iB.m_fK((Object)"szcz:oezyhq~e!dovod!azervy{~->d!2h->d").formatted(objectArray);
    }

    private /* synthetic */ void registerRemoteCallsWithClusterNode() {
        DataTransferManager dataTransferManager = this;
        try {
            Class[] classArray = new Class[5 >> 2];
            classArray[2 & 5] = String.class;
            dataTransferManager.f_FI.m_fa((short)(0x3D1 & 0x7DBF), (Object)dataTransferManager, DataTransferManager.class.getDeclaredMethod(c_ub.m_vF((Object)"\u0018\u001f\u0003\u0019\u000f\t\u0007\u0019/\u001d\u001f\u001d?\u000e\n\u0012\u0018\u001a\u000e\u000e\"\u0012\u001f\u0019\u0019\u0012\n\u0010"), classArray));
            Class[] classArray2 = new Class[3 & 5];
            classArray2[5 >> 3] = String.class;
            dataTransferManager.f_FI.m_fa((short)(0x1FF3 & 0x619E), (Object)dataTransferManager, DataTransferManager.class.getDeclaredMethod(c_iB.m_fK((Object)"xvut~{_vovOezyhq~eRyoriyz{"), classArray2));
            Class[] classArray3 = new Class[3 & 5];
            classArray3[5 >> 3] = String.class;
            dataTransferManager.f_FI.m_fa((short)(0x3D97 & 0x43FB), (Object)dataTransferManager, DataTransferManager.class.getDeclaredMethod(c_ub.m_vF((Object)"\u001b\u000e\b/\u001d\u001f\u001d?\u000e\n\u0012\u0018\u001a\u000e\u000e8\b\n\b\u001e\u000f\"\u0012\u001f\u0019\u0019\u0012\n\u0010"), classArray3));
            Class[] classArray4 = new Class[--1];
            classArray4[3 & 4] = String.class;
            dataTransferManager.f_FI.m_fa((short)(0x3BFE & 0x4595), (Object)dataTransferManager, DataTransferManager.class.getDeclaredMethod(c_iB.m_fK((Object)"htsr\u007fbwr_vovOezyhq~ehUbGixqrxcRsRyoriyz{"), classArray4));
            Class[] classArray5 = new Class[2 ^ 3];
            classArray5[5 >> 3] = String.class;
            dataTransferManager.f_FI.m_fa((short)(0x19DF & 0x67B5), (Object)dataTransferManager, DataTransferManager.class.getDeclaredMethod(c_ub.m_vF((Object)"\b\u001d\u0005\u001f\u000e\u0010/\u001d\u001f\u001d?\u000e\n\u0012\u0018\u001a\u000e\u000e\u0018>\u0012,\u0019\u0013\u0001\u0019\b\b\"\u0018\"\u0012\u001f\u0019\u0019\u0012\n\u0010"), classArray5));
            Class[] classArray6 = new Class[1];
            classArray6[0] = List.class;
            dataTransferManager.f_FI.m_fa((short)(0x11DF & 0x6FB6), (Object)dataTransferManager, DataTransferManager.class.getDeclaredMethod(c_iB.m_fK((Object)"|roSzczCivud}riDovobhrhUb^\u007fdRyoriyz{"), classArray6));
            Class[] classArray7 = new Class[1];
            classArray7[0] = String.class;
            dataTransferManager.f_FI.m_fa((short)(0x2997 & 0x57FF), (Object)dataTransferManager, DataTransferManager.class.getDeclaredMethod(c_ub.m_vF((Object)"\f\u0019\u001f8\n\b\n(\u0019\u001d\u0005\u000f\r\u0019\u0019/\u001f\u001d\u001f\t\u0018\u0019\u0018>\u0012,\u0019\u0013\u0001\u0019\b\b\"\u0018\"\u0012\u001f\u0019\u0019\u0012\n\u0010"), classArray7));
            return;
        }
        catch (NoSuchMethodException a) {
            throw new IllegalStateException(c_iB.m_fK((Object)"]vr{~s;ct7ir|~hc~e;SzczCivud}riZzyzp~e;EKT;z~csx\u007fd"), a);
        }
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void handleStatValues(List<DataTransferDetail> list, Map<String, Map<String, Object>> map) {
        void a;
        void a2;
        DataTransferManager dataTransferManager = this;
        Object a3 = a2.stream().map(DataTransferDetail::getTargetVariableId).collect(Collectors.toList());
        Map map2 = dataTransferManager.f_YI.m_HCa((List)a3).stream().collect(Collectors.toMap(BaseModel::getId, Function.identity()));
        a3 = dataTransferManager.f_Xh.m_Nca((String[])a3.toArray(String[]::new));
        Date date = new Date();
        a2.stream().filter(arg_0 -> dataTransferManager.lambda$handleStatValues$12(date, map2, (Map)a, (Map)a3, arg_0)).collect(Collectors.groupingBy(dataTransferDetail -> {
            void a;
            DataTransferManager a2 = dataTransferDetail;
            DataTransferManager a3 = this;
            return (Date)a3.calculateDateRange((Date)a, a2.getRangeType()).getLeft();
        })).forEach((arg_0, arg_1) -> dataTransferManager.lambda$handleStatValues$17(date, map2, (Map)a3, (Map)a, arg_0, arg_1));
    }

    /*
     * Enabled aggressive block sorting
     */
    private /* synthetic */ int getMaxTTLForRangeType(c_Jl c_Jl2) {
        DataTransferManager a = c_Jl2;
        DataTransferManager a2 = this;
        switch (c_VB.f_RH[a.ordinal()]) {
            case 1: 
            case 2: {
                return 3600;
            }
            case 3: 
            case 4: {
                return 86400;
            }
            case 5: 
            case 6: {
                return 604800;
            }
            case 7: 
            case 8: {
                return 2678400;
            }
            case 9: 
            case 10: {
                return 31622400;
            }
        }
        throw new IllegalArgumentException("Unexpected range type: " + String.valueOf(a));
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ boolean isValueInThresholdRange(Double d, VariableValue<?> variableValue, VariableValue<?> variableValue2) {
        void a;
        void a2;
        VariableValue<?> a3 = variableValue2;
        VariableValue<?> a4 = this;
        if (a2 == null || a3 == null) {
            return true;
        }
        if (!(a instanceof NumberVariableValue) || !(a3 instanceof NumberVariableValue)) {
            return true;
        }
        double d2 = ((Number)a.getValue()).doubleValue();
        double d3 = ((Number)a3.getValue()).doubleValue();
        double d4 = d2 == 0.0 ? Math.abs(d3 - d2) : Math.abs((d3 - d2) / d2 * 100.0);
        if (d4 >= a2.doubleValue()) {
            return --1 != 0;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    @TransactionalEventListener(value={c_gA.class})
    public void handleCancelEvent(c_gA c_gA2) {
        void a;
        DataTransferManager dataTransferManager = this;
        if (dataTransferManager.f_FI.m_r()) {
            DataTransferManager a2 = a.m_hr();
            f_xg.info(c_iB.m_fK((Object)"[^V_RI-;_zy\u007f{ry|7Xvut~{^a~yo7}xi7\u007fvov;civud}ri-;lf73^_-;lf>"), (Object)a2.getName(), (Object)a2.getId());
            dataTransferManager.cancelDataTransferInternal((DataTransfer)a2);
            return;
        }
        f_xg.debug(c_ub.m_vF((Object)"%3%Q'9*8..Q\\\"\u001b\u0005\u0013\u0019\u0015\u0005\u001bK?\n\u0012\b\u0019\u00079\u001d\u0019\u0005\bK\u001a\u0004\u000eK\u0018\n\b\n\\\u001f\u000e\n\u0012\u0018\u001a\u000e\u000eQ\\\u0010\u0001"), (Object)a.m_hr().getId());
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void lambda$handleStatValues$17(Date date, Map map, Map map2, Map map3, Date date2, List list) {
        void a;
        void a2;
        void a3;
        Map a4;
        void a5;
        List a6;
        DataTransferManager dataTransferManager = list2;
        List list2 = list;
        DataTransferManager a7 = dataTransferManager;
        String[] stringArray = (String[])a6.stream().map(DataTransferDetail::getSourceVariableId).distinct().toArray(String[]::new);
        c_Kl[] c_KlArray = (c_Kl[])a6.stream().map(DataTransferDetail::getCalcType).distinct().toArray(c_Kl[]::new);
        a4 = a7.f_Si.m_uba(stringArray, (Date)a5, (Date)((Object)a4), c_KlArray).stream().collect(Collectors.toMap(LoggedVariableValueStats::getVariableId, Function.identity()));
        a6.forEach(arg_0 -> a7.lambda$handleStatValues$16(a4, (Map)a3, (Map)a2, (Map)a, arg_0));
    }

    @TransactionalEventListener(value={c_Gc.class})
    public void handleRescheduleEvent(c_Gc c_Gc2) {
        DataTransferManager dataTransferManager = this;
        if (dataTransferManager.f_FI.m_r()) {
            DataTransferManager a = a.m_Fp();
            f_xg.info(c_iB.m_fK((Object)"[^V_RI-;_zy\u007f{ry|7Irhtsr\u007fbwr^a~yo7}xi7\u007fvov;civud}ri-;lf73^_-;lf>"), (Object)a.getName(), (Object)a.getId());
            if (dataTransferManager.getDataTransferStatusInternal(a.getId()) == c_dc.f_Eh) {
                dataTransferManager.scheduleDataTransferInternal(a.getId());
                return;
            }
        } else {
            f_xg.debug(c_ub.m_vF((Object)"%3%Q'9*8..Q\\\"\u001b\u0005\u0013\u0019\u0015\u0005\u001bK.\u000e\u000f\b\u0014\u000e\u0018\u001e\u0010\u000e9\u001d\u0019\u0005\bK\u001a\u0004\u000eK\u0018\n\b\n\\\u001f\u000e\n\u0012\u0018\u001a\u000e\u000eQ\\\u0010\u0001"), (Object)a.m_Fp().getId());
        }
    }

    private /* synthetic */ String buildStatLastCalcTimeKey(DataTransferDetail dataTransferDetail) {
        DataTransferManager a = dataTransferDetail;
        DataTransferManager a2 = this;
        Object[] objectArray = new Object[--3];
        objectArray[2 & 5] = a.getSourceVariableId();
        objectArray[3 & 5] = a.getRangeType();
        objectArray[--2] = a.getCalcType();
        return c_ub.m_vF((Object)"\u000f\u001d\u001f\u001dF\b\u0019\u001d\u0005\u000f\r\u0019\u0019F\u0007\u001d\u0018\bF\u001f\n\u0010\bQ\u001f\u0015\u0006\u0019Q\n\n\u000e\u0002\u001d\t\u0010\u000eFN\u000fQY\u0018FN\u000f").formatted(objectArray);
    }

    protected Map<String, c_dc> getDataTransferStatusesByIdsInternal(List<String> list) {
        List<String> a = list;
        DataTransferManager a2 = this;
        if (a == null || a.isEmpty()) {
            return Collections.emptyMap();
        }
        return a.stream().collect(Collectors.toMap(Function.identity(), arg_0 -> a2.getDataTransferStatusInternal(arg_0)));
    }

    protected c_dc getDataTransferStatusInternal(String string) {
        Object a = string;
        DataTransferManager a2 = this;
        if (a2.f_ki.containsKey(a)) {
            return c_dc.f_Eh;
        }
        return c_dc.f_gI;
    }

    private /* synthetic */ void lambda$scheduleDataTransferInternal$5(DataTransfer dataTransfer) {
        DataTransferManager a = dataTransfer;
        DataTransferManager a2 = this;
        a2.f_sG.lock();
        try {
            a2.cancelDataTransferInternal((DataTransfer)a);
            if (!Boolean.TRUE.equals(a.getProject().getIsActive())) {
                throw new NotActiveException("Project should be active to schedule data transfer " + a.getName());
            }
            Object[] objectArray = new Object[2 ^ 3];
            objectArray[5 >> 3] = a.getName();
            PeriodicJob periodicJob = a2.f_EI.m_Bo(a.getProject(), c_ub.m_vF((Object)"N\u000fK8\n\b\n\\?\u000e\n\u0012\u0018\u001a\u000e\u000e").formatted(objectArray), () -> a2.lambda$scheduleDataTransferInternal$4((DataTransfer)a), Duration.ofMillis(a.getPeriod().intValue()));
            DataTransferManager dataTransferManager = a2;
            dataTransferManager.f_ki.put(a.getId(), periodicJob);
            String[] stringArray = new String[--1];
            stringArray[3 ^ 3] = a.getId();
            dataTransferManager.f_gi.sadd(f_cI, stringArray);
            return;
        }
        finally {
            a2.f_sG.unlock();
        }
    }

    /*
     * WARNING - void declaration
     */
    public DataTransferManager(c_rb c_rb2, c_fi c_fi2, c_FI c_FI2, c_Si c_Si2, c_Kc c_Kc2, JedisPooled jedisPooled, c_BC c_BC2, c_K c_K2, c_Hj c_Hj2) {
        DataTransferManager a;
        void a2;
        void a3;
        void a4;
        void a5;
        void a6;
        void a7;
        void a8;
        void a9;
        DataTransferManager a10;
        DataTransferManager dataTransferManager = dataTransferManager2;
        DataTransferManager dataTransferManager2 = c_Hj2;
        DataTransferManager dataTransferManager3 = a10 = dataTransferManager;
        DataTransferManager dataTransferManager4 = a10;
        DataTransferManager dataTransferManager5 = a10;
        DataTransferManager dataTransferManager6 = a10;
        DataTransferManager dataTransferManager7 = a10;
        DataTransferManager dataTransferManager8 = a10;
        dataTransferManager7.f_sG = new ReentrantLock();
        dataTransferManager7.f_ki = new ConcurrentHashMap();
        dataTransferManager7.f_Ni = a9;
        dataTransferManager6.f_YI = a8;
        dataTransferManager6.f_Xh = a7;
        dataTransferManager5.f_Si = a6;
        dataTransferManager5.f_EI = a5;
        dataTransferManager4.f_Bh = a4;
        dataTransferManager4.f_gi = a3;
        dataTransferManager3.f_FI = a2;
        dataTransferManager3.f_wG = a;
    }

    /*
     * WARNING - void declaration
     */
    @PreAuthorize(value="hasAuthority('VIEW_DATA_TRANSFER')")
    public c_dc getDataTransferStatus(String string, String string2) {
        void a;
        Object a2 = string;
        DataTransferManager a3 = this;
        if ((a2 = a3.f_Ni.m_tM((String)a2, (String)a)) == null) {
            return c_dc.f_gI;
        }
        return a3.getDataTransferStatus(a2.getId());
    }

    protected void scheduleDataTransfersByProjectIdInternal(String string) {
        Object a = string;
        DataTransferManager a2 = this;
        if ((a = a2.f_Ni.m_on((String)a)) == null || a.isEmpty()) {
            return;
        }
        a.forEach(arg_0 -> a2.scheduleDataTransferInternal(arg_0));
    }
}

