/*
 * Decompiled with CFR 0.152.
 */
package com.inscada.mono.communication.protocols.modbus.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.inscada.mono.communication.base.f.c_EK;
import com.inscada.mono.communication.base.model.Device;
import com.inscada.mono.communication.protocols.modbus.model.ModbusConnection;
import com.inscada.mono.communication.protocols.modbus.model.ModbusFrame;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.OneToMany;
import jakarta.persistence.Table;
import jakarta.validation.constraints.Min;
import jakarta.validation.constraints.NotNull;
import java.util.HashSet;
import java.util.Set;
import org.hibernate.annotations.SQLRestriction;

@Entity
@Table(name="modbus_device")
public class ModbusDevice
extends Device<ModbusConnection, ModbusFrame> {
    @NotNull
    @Min(value=1L)
    @Column(name="scan_time")
    private Integer scanTime;
    @JsonIgnore
    @ManyToOne(optional=false)
    @SQLRestriction(value="deleted_dttm IS NULL")
    @JoinColumn(name="conn_id")
    protected ModbusConnection connection;
    @NotNull
    @Column(name="scan_type")
    private c_EK scanType;
    @JsonIgnore
    @OneToMany(mappedBy="device")
    @SQLRestriction(value="deleted_dttm IS NULL")
    protected Set<ModbusFrame> frames;
    @Column(name="retain_flag")
    private Boolean retainFlag;
    @NotNull
    @Min(value=0L)
    @Column(name="station_address")
    private Integer stationAddress;

    public void setStationAddress(Integer n) {
        Object a = n;
        ModbusDevice a2 = this;
        a2.stationAddress = a;
    }

    public Boolean getRetainFlag() {
        ModbusDevice a;
        return a.retainFlag;
    }

    public Integer getStationAddress() {
        ModbusDevice a;
        return a.stationAddress;
    }

    public void setConnection(ModbusConnection modbusConnection) {
        ModbusDevice a;
        ModbusDevice a2 = modbusConnection;
        ModbusDevice modbusDevice = a = this;
        modbusDevice.connection = a2;
        modbusDevice.connectionId = a2 != null && a2.getId() != null ? a2.getId() : null;
    }

    public Integer getScanTime() {
        ModbusDevice a;
        return a.scanTime;
    }

    public void setScanType(c_EK c_EK2) {
        ModbusDevice a = c_EK2;
        ModbusDevice a2 = this;
        a2.scanType = a;
    }

    public void setRetainFlag(Boolean bl) {
        Object a = bl;
        ModbusDevice a2 = this;
        a2.retainFlag = a;
    }

    public c_EK getScanType() {
        ModbusDevice a;
        return a.scanType;
    }

    public void setScanTime(Integer n) {
        Object a = n;
        ModbusDevice a2 = this;
        a2.scanTime = a;
    }

    public Set<ModbusFrame> getFrames() {
        ModbusDevice a;
        return a.frames;
    }

    public void setFrames(Set<ModbusFrame> set) {
        Object a = set;
        ModbusDevice a2 = this;
        a2.frames = a;
    }

    public ModbusDevice() {
        ModbusDevice a;
        ModbusDevice modbusDevice = a;
        modbusDevice.frames = new HashSet();
    }

    public ModbusConnection getConnection() {
        ModbusDevice a;
        return a.connection;
    }
}

