/*
 * Decompiled with CFR 0.152.
 */
package com.inscada.mono.communication.protocols.iec104.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.inscada.mono.communication.base.model.Connection;
import com.inscada.mono.communication.protocols.iec104.model.Iec104Device;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.OneToMany;
import jakarta.persistence.Table;
import jakarta.validation.constraints.Max;
import jakarta.validation.constraints.Min;
import java.util.HashSet;
import java.util.Set;
import org.hibernate.annotations.SQLRestriction;

@Entity
@Table(name="iec104_connection")
public class Iec104Connection
extends Connection<Iec104Device> {
    @Column(name="is_with_timestamps")
    private Boolean isWithTimestamps;
    @Min(value=100L)
    @Column(name="buffering_period")
    private Integer bufferingPeriod;
    @Min(value=0L)
    @Max(value=255L)
    @Column(name="originator_address")
    private Integer originatorAddress;
    @Min(value=1L)
    @Max(value=2L)
    @Column(name="cot_field_length")
    private Integer cotFieldLength;
    @Min(value=1000L)
    private Integer t1;
    @Min(value=1000L)
    private Integer t3;
    @Min(value=0L)
    @Column(name="spontaneous_duplicates")
    private Integer spontaneousDuplicates;
    @Min(value=1L)
    @Max(value=32767L)
    private Integer w;
    @Min(value=1L)
    @Max(value=32767L)
    private Integer k;
    @Min(value=1L)
    @Max(value=2L)
    @Column(name="ca_field_length")
    private Integer commonAddressFieldLength;
    @Column(name="use_system_timezone")
    private Boolean useSystemTimeZone;
    @Min(value=1L)
    @Max(value=3L)
    @Column(name="ioa_field_length")
    private Integer ioaFieldLength;
    @JsonIgnore
    @OneToMany(mappedBy="connection")
    @SQLRestriction(value="deleted_dttm IS NULL")
    protected Set<Iec104Device> devices;
    @Min(value=100L)
    @Column(name="background_scan_period")
    private Integer backgroundScanPeriod;
    @Min(value=1000L)
    private Integer t2;

    public Integer getIoaFieldLength() {
        Iec104Connection a;
        return a.ioaFieldLength;
    }

    public void setT3(Integer n) {
        Object a = n;
        Iec104Connection a2 = this;
        a2.t3 = a;
    }

    public void setBufferingPeriod(Integer n) {
        Object a = n;
        Iec104Connection a2 = this;
        a2.bufferingPeriod = a;
    }

    public Integer getSpontaneousDuplicates() {
        Iec104Connection a;
        return a.spontaneousDuplicates;
    }

    public void setOriginatorAddress(Integer n) {
        Object a = n;
        Iec104Connection a2 = this;
        a2.originatorAddress = a;
    }

    public Integer getBackgroundScanPeriod() {
        Iec104Connection a;
        return a.backgroundScanPeriod;
    }

    public Integer getT2() {
        Iec104Connection a;
        return a.t2;
    }

    public Integer getT3() {
        Iec104Connection a;
        return a.t3;
    }

    public Integer getK() {
        Iec104Connection a;
        return a.k;
    }

    public void setIsWithTimestamps(Boolean bl) {
        Object a = bl;
        Iec104Connection a2 = this;
        a2.isWithTimestamps = a;
    }

    public Iec104Connection() {
        Iec104Connection a;
        Iec104Connection iec104Connection = a;
        iec104Connection.devices = new HashSet();
    }

    public Integer getOriginatorAddress() {
        Iec104Connection a;
        return a.originatorAddress;
    }

    public void setT2(Integer n) {
        Object a = n;
        Iec104Connection a2 = this;
        a2.t2 = a;
    }

    public Integer getBufferingPeriod() {
        Iec104Connection a;
        return a.bufferingPeriod;
    }

    public void setT1(Integer n) {
        Object a = n;
        Iec104Connection a2 = this;
        a2.t1 = a;
    }

    public void setCommonAddressFieldLength(Integer n) {
        Object a = n;
        Iec104Connection a2 = this;
        a2.commonAddressFieldLength = a;
    }

    public void setIoaFieldLength(Integer n) {
        Object a = n;
        Iec104Connection a2 = this;
        a2.ioaFieldLength = a;
    }

    public void setUseSystemTimeZone(Boolean bl) {
        Object a = bl;
        Iec104Connection a2 = this;
        a2.useSystemTimeZone = a;
    }

    public Integer getW() {
        Iec104Connection a;
        return a.w;
    }

    public Boolean getIsWithTimestamps() {
        Iec104Connection a;
        return a.isWithTimestamps;
    }

    public Set<Iec104Device> getDevices() {
        Iec104Connection a;
        return a.devices;
    }

    public void setW(Integer n) {
        Object a = n;
        Iec104Connection a2 = this;
        a2.w = a;
    }

    public void setDevices(Set<Iec104Device> set) {
        Object a = set;
        Iec104Connection a2 = this;
        a2.devices = a;
    }

    public Boolean getUseSystemTimeZone() {
        Iec104Connection a;
        return a.useSystemTimeZone;
    }

    public void setBackgroundScanPeriod(Integer n) {
        Object a = n;
        Iec104Connection a2 = this;
        a2.backgroundScanPeriod = a;
    }

    public void setSpontaneousDuplicates(Integer n) {
        Object a = n;
        Iec104Connection a2 = this;
        a2.spontaneousDuplicates = a;
    }

    public void setK(Integer n) {
        Object a = n;
        Iec104Connection a2 = this;
        a2.k = a;
    }

    public void setCotFieldLength(Integer n) {
        Object a = n;
        Iec104Connection a2 = this;
        a2.cotFieldLength = a;
    }

    public Integer getCommonAddressFieldLength() {
        Iec104Connection a;
        return a.commonAddressFieldLength;
    }

    public Integer getT1() {
        Iec104Connection a;
        return a.t1;
    }

    public Integer getCotFieldLength() {
        Iec104Connection a;
        return a.cotFieldLength;
    }
}

