/*
 * Decompiled with CFR 0.152.
 */
package com.inscada.mono.communication.base.services;

import com.inscada.mono.auth.c_Hj;
import com.inscada.mono.cluster.exceptions.ClusterRpcException;
import com.inscada.mono.cluster.services.ClusterNodeListener;
import com.inscada.mono.cluster.services.c_K;
import com.inscada.mono.communication.base.exceptions.BrowseOperationException;
import com.inscada.mono.communication.base.f.c_sl;
import com.inscada.mono.communication.base.model.Connection;
import com.inscada.mono.communication.base.model.ConnectionSummary;
import com.inscada.mono.communication.base.model.SetValueRequest;
import com.inscada.mono.communication.base.model.Variable;
import com.inscada.mono.communication.base.model.values.VariableValue;
import com.inscada.mono.communication.base.q.c_fJ;
import com.inscada.mono.communication.base.q.c_ll;
import com.inscada.mono.communication.base.services.c_Gl;
import com.inscada.mono.communication.base.services.c_NI;
import com.inscada.mono.communication.base.services.c_Se;
import com.inscada.mono.communication.base.services.c_d;
import com.inscada.mono.license.q.c_uc;
import com.inscada.mono.log.q.c_BC;
import com.inscada.mono.project.q.c_D;
import com.inscada.mono.shared.exceptions.NotActiveException;
import com.inscada.mono.shared.exceptions.NotFoundException;
import com.inscada.mono.shared.model.OwnedSpaceBaseModel;
import com.inscada.mono.space.q.c_Va;
import jakarta.annotation.PostConstruct;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.stream.Collectors;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Component;
import org.springframework.transaction.event.TransactionalEventListener;
import redis.clients.jedis.JedisPooled;

@Component
public class ConnectionManager<C extends Connection<?>, V extends Variable<?, ?, ?>>
implements ClusterNodeListener,
c_D {
    private final c_K f_VT;
    public static final short f_gs = 207;
    private final c_Hj f_ht;
    private final c_BC f_oT;
    private static final Logger f_zT = LoggerFactory.getLogger(ConnectionManager.class);
    private final JedisPooled f_ZS;
    public static final short f_Wt = 210;
    private final c_uc f_Xu;
    public static final short f_tR = 208;
    private final c_NI<C, V> f_kS;
    public static final short f_iu = 205;
    public static final short f_Yt = 209;
    private final Lock f_fs;
    public static final short f_qT = 206;
    public static final short f_Dt = 202;
    public static final short f_mS = 203;
    public static final short f_gS = 201;
    private final c_Gl f_XR;
    private static final String f_lS = "activeConnections";
    public static final short f_uT = 204;

    protected void stopConnectionInternal(Connection<?> connection) {
        Connection<?> a = connection;
        Connection<?> a2 = this;
        a2.f_ht.m_bea(() -> {
            ConnectionManager a = a;
            ConnectionManager a2 = this;
            a2.f_fs.lock();
            try {
                c_Se c_Se2 = a2.f_kS.m_yAa(a.getId());
                if (c_Se2 != null) {
                    c_Se2.m_WR();
                    a2.f_kS.m_lAa(a.getId(), c_Se2);
                }
                String[] stringArray = new String[5 >> 2];
                stringArray[3 & 4] = a.getId();
                a2.f_ZS.srem(f_lS, stringArray);
                return;
            }
            finally {
                a2.f_fs.unlock();
            }
        }, a);
    }

    @PreAuthorize(value="hasAuthority('START_CONNECTION')")
    public void startConnections(String string) {
        Object a = string;
        ConnectionManager a2 = this;
        if (a2.f_VT.m_r()) {
            f_zT.debug(VariableValue.m_YBa((Object)"Y\fT\rP\u001b/iF=t;a {.5(y%5*z'{,v=|&{:5/z;59g&\u007f,v=52hiy&v(y%lg"), a);
            a2.startConnectionsByProjectIdInternal((String)a);
            return;
        }
        f_zT.debug(c_Va.m_Te((Object)"9S91;Y6X2NM<%y\u0006i\u0012o\u0003u\u0019{Wp\u0012}\u0013y\u0005<\u0003sWo\u0003}\u0005hW}\u001bpW\u007f\u0018r\u0019y\u0014h\u001es\u0019oWz\u0018nWl\u0005s\u001dy\u0014hWg\n2"), a);
        try {
            Object[] objectArray = new Object[5 >> 2];
            objectArray[2 & 5] = a;
            a2.f_VT.m_ia(Short.valueOf((short)(0x17FF & 0x68CE)), objectArray);
            return;
        }
        catch (Exception exception) {
            throw new ClusterRpcException("Failed to RPC start connections for project " + (String)a, (Throwable)exception);
        }
    }

    protected c_sl getConnectionStatusInternal(String string) {
        Object a = string;
        ConnectionManager a2 = this;
        if ((a = a2.f_kS.m_yAa((String)a)) != null && a.m_Eu()) {
            return c_sl.f_Ju;
        }
        return c_sl.f_cT;
    }

    protected void startConnectionsByProjectIdInternal(String string) {
        Object a = string;
        ConnectionManager a2 = this;
        if ((a = a2.f_XR.m_dca((String)a)) == null || a.isEmpty()) {
            return;
        }
        Object object = a = a.iterator();
        while (object.hasNext()) {
            Connection connection = (Connection)a.next();
            ConnectionManager connectionManager = a2;
            connectionManager.startConnectionInternal(connectionManager.loadConnectionWithDetails(connection));
            object = a;
        }
    }

    protected void setVariableValuesInternal(Collection<SetValueRequest<V>> collection) {
        Collection<SetValueRequest<V>> a = collection;
        ConnectionManager a2 = this;
        a.stream().collect(Collectors.groupingBy(SetValueRequest::getConnectionId)).forEach((string, list) -> {
            Object a = string;
            ConnectionManager a2 = this;
            if ((a = a2.f_kS.m_yAa((String)a)) != null) {
                void a3;
                a.m_Iu((List)a3);
            }
        });
    }

    private /* synthetic */ Object lambda$browseConnectionInternal$2(String string) throws Exception {
        Object a = string;
        ConnectionManager a2 = this;
        if ((a = a2.f_kS.m_yAa((String)a)) instanceof c_d) {
            return ((c_d)a).m_n();
        }
        throw new BrowseOperationException(c_Va.m_Te((Object)"5n\u0018k\u0004yWs\u0007y\u0005}\u0003u\u0018rWr\u0018hWo\u0002l\u0007s\u0005h\u0012x"));
    }

    /*
     * WARNING - void declaration
     */
    @TransactionalEventListener(value={c_ll.class})
    public void handleDeleteEvent(c_ll c_ll2) {
        void a;
        ConnectionManager connectionManager = this;
        if (connectionManager.f_VT.m_r()) {
            ConnectionManager a2 = a.m_iba();
            f_zT.info(c_Va.m_Te((Object)";Y6X2NM<?}\u0019x\u001bu\u0019{WX\u0012p\u0012h\u0012Y\u0001y\u0019hWz\u0018nW\u007f\u0018r\u0019y\u0014h\u001es\u0019&Wg\n<_U3&Wg\n5"), (Object)a2.getName(), (Object)a2.getId());
            connectionManager.stopConnectionInternal((Connection)a2);
            return;
        }
        f_zT.debug(VariableValue.m_YBa((Object)"\u0007Z\u00078\u0005P\bQ\fGs5\u0000r'z;|'riQ,y,a,P?p'ais&giv&{'p*a z'/in4"), (Object)a.m_iba().getId());
    }

    /*
     * WARNING - void declaration
     */
    @PreAuthorize(value="hasAuthority('START_CONNECTION')")
    public void startConnection(String string, String string2) {
        void a;
        ConnectionManager a2;
        Object a3 = string2;
        ConnectionManager connectionManager = a2 = this;
        connectionManager.startConnection(connectionManager.f_XR.m_eAa((String)a, (String)a3).getId());
    }

    @PreAuthorize(value="hasAuthority('VIEW_CONNECTION_ITEM')")
    public Map<String, c_sl> getConnectionStatuses(String string) {
        Object a = string;
        ConnectionManager a2 = this;
        if (a2.f_VT.m_r()) {
            f_zT.debug(VariableValue.m_YBa((Object)"\u0005P\bQ\fGs5\u000ep=a {.5(y%5*z'{,v=|&{if=t=`:p:5/z;59g&\u007f,v=52hiy&v(y%lg"), a);
            return a2.getConnectionStatusesByProjectIdInternal((String)a);
        }
        f_zT.debug(c_Va.m_Te((Object)"R8RZP2]3Y%&WN\u0012m\u0002y\u0004h\u001er\u0010<\u001by\u0016x\u0012nWz\u0018nW}\u001bpW\u007f\u0018r\u0019y\u0014h\u001es\u0019<\u0004h\u0016h\u0002o\u0012oWz\u0018nWl\u0005s\u001dy\u0014hWg\n2"), a);
        try {
            Object[] objectArray = new Object[2 ^ 3];
            objectArray[3 & 4] = a;
            return (Map)a2.f_VT.m_ia(Short.valueOf((short)(0x15FC & 0x6AD3)), objectArray);
        }
        catch (Exception exception) {
            throw new ClusterRpcException("Failed to RPC get connection statuses for project " + (String)a, (Throwable)exception);
        }
    }

    protected Map<String, c_sl> getConnectionStatusesByProjectIdInternal(String string) {
        Object a = string;
        ConnectionManager a2 = this;
        if ((a = a2.f_XR.m_sAa((String)a)) == null || a.isEmpty()) {
            return Collections.emptyMap();
        }
        return a.stream().collect(Collectors.toMap(ConnectionSummary::getId, connectionSummary -> {
            ConnectionManager a = connectionSummary;
            ConnectionManager a2 = this;
            return a2.getConnectionStatusInternal(a.getId());
        }));
    }

    /*
     * WARNING - void declaration
     */
    @PreAuthorize(value="hasAuthority('VIEW_CONNECTION_ITEM')")
    public c_sl getConnectionStatus(String string, String string2) {
        void a;
        Object a2 = string;
        ConnectionManager a3 = this;
        if ((a2 = a3.f_XR.m_dAa((String)a2, (String)a)) == null) {
            return c_sl.f_cT;
        }
        return a3.getConnectionStatus(a2.getId());
    }

    @PreAuthorize(value="hasAuthority('START_CONNECTION')")
    public void startConnection(String string) {
        Object a = string;
        ConnectionManager a2 = this;
        if (a2.f_VT.m_r()) {
            f_zT.debug(VariableValue.m_YBa((Object)"\u0005P\bQ\fGs5\u001aa(g=|'riv&{'p*a z'52hiy&v(y%lg"), a);
            a2.startConnectionInternal((String)a);
            return;
        }
        f_zT.debug(c_Va.m_Te((Object)"R8RZP2]3Y%&WN\u0012m\u0002y\u0004h\u001er\u0010<\u001by\u0016x\u0012nWh\u0018<\u0004h\u0016n\u0003<\u0014s\u0019r\u0012\u007f\u0003u\u0018rWg\n2"), a);
        try {
            Object[] objectArray = new Object[3 & 5];
            objectArray[3 & 4] = a;
            a2.f_VT.m_ia(Short.valueOf((short)(0x54CB & 0x2BFD)), objectArray);
            return;
        }
        catch (Exception exception) {
            throw new ClusterRpcException("Failed to RPC start connection " + (String)a, (Throwable)exception);
        }
    }

    /*
     * WARNING - void declaration
     */
    @PreAuthorize(value="hasAuthority('STOP_CONNECTION')")
    public void stopConnection(String string, String string2) {
        void a;
        ConnectionManager a2;
        Object a3 = string2;
        ConnectionManager connectionManager = a2 = this;
        connectionManager.stopConnection(connectionManager.f_XR.m_eAa((String)a, (String)a3).getId());
    }

    protected Map<String, c_sl> getConnectionStatusesByIdsInternal(String[] stringArray) {
        String[] a2 = stringArray;
        String[] a3 = this;
        return Arrays.stream(a2).collect(Collectors.toMap(a -> a, arg_0 -> ((ConnectionManager)a3).getConnectionStatusInternal(arg_0)));
    }

    public void notLeader() {
        ConnectionManager connectionManager;
        ConnectionManager connectionManager2 = connectionManager = this;
        Object a = connectionManager2.f_VT.m_Ga();
        f_zT.info(c_Va.m_Te((Object)"_\u0018r\u0019y\u0014h\u001es\u0019Q\u0016r\u0016{\u0012nM<#t\u001eoWr\u0018x\u0012<_g\n5Wu\u0004<9SWP8R0Y%<#T2<;Y6X2NY<$h\u0018l\u0007u\u0019{W}\u001bpWp\u0018\u007f\u0016pW\u007f\u0018r\u0019y\u0014h\u0018n\u00042Y2"), a);
        connectionManager2.f_fs.lock();
        try {
            connectionManager.f_kS.m_Zaa();
            f_zT.info(VariableValue.m_YBa((Object)"V&{'p*a z'X({(r,gi=\u0007z=5\u0005p(q,gin4<s5\by%5%z*t%5*z'{,v=z;fi}(c,5+p,{ig,d<p:a,qia&5:a&eit'qiv%p(g,qis;z$5%z*t%5=g(v\"|'rg"), a);
            return;
        }
        catch (Exception exception) {
            Object[] objectArray = new Object[--3];
            objectArray[3 ^ 3] = a;
            objectArray[3 & 5] = exception.getMessage();
            objectArray[1 ^ 3] = exception;
            f_zT.error(c_Va.m_Te((Object)"4s\u0019r\u0012\u007f\u0003u\u0018r:}\u0019}\u0010y\u0005<_R\u0018hWP\u0012}\u0013y\u0005<\fa^&WY\u0005n\u0018nWx\u0002n\u001er\u0010<\u0007n\u0018\u007f\u0012o\u0004<\u0018zWo\u0003s\u0007l\u001er\u0010<\u001bs\u0014}\u001b<\u0014s\u0019r\u0012\u007f\u0003s\u0005oM<\fa"), objectArray);
            return;
        }
        finally {
            connectionManager.f_fs.unlock();
        }
    }

    /*
     * WARNING - void declaration
     */
    protected Object browseConnectionInternal(String string) {
        void a;
        ConnectionManager connectionManager;
        ConnectionManager connectionManager2 = connectionManager = this;
        ConnectionManager a2 = connectionManager2.f_XR.m_VAa((String)a);
        return connectionManager2.f_ht.m_iEa(() -> connectionManager.lambda$browseConnectionInternal$2((String)a), (OwnedSpaceBaseModel)a2);
    }

    public void deactivateForProject(String string) {
        Object a = string;
        ConnectionManager a2 = this;
        if (a2.f_VT.m_r()) {
            f_zT.info(c_Va.m_Te((Object)";Y6X2NM<?}\u0019x\u001bu\u0019{WL\u0005s\u001dy\u0014h3y\u0016\u007f\u0003u\u0001}\u0003y2j\u0012r\u0003<\u0011s\u0005<\u0007n\u0018v\u0012\u007f\u0003<>XM<\fa"), a);
            a2.stopConnectionsByProjectIdInternal((String)a);
            return;
        }
        f_zT.debug(VariableValue.m_YBa((Object)"[\u0006[dY\fT\rP\u001b/i\\.{&g {.5\u0019g&\u007f,v=Q,t*a c(a,P?p'ais&gie;z#p*ai\\\r/in4"), a);
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void lambda$restoreSingleConnectionOnLeader$1(String string, Connection connection) {
        void a;
        ConnectionManager a2 = connection;
        ConnectionManager a3 = this;
        try {
            Object[] objectArray = new Object[--3];
            objectArray[3 & 4] = a;
            objectArray[2 ^ 3] = a2.getName();
            objectArray[1 ^ 3] = a2.getId();
            f_zT.info(VariableValue.m_YBa((Object)"V&{'p*a z'X({(r,gi=\u0005p(q,gin4<s5\u001bp:a&g {.5*z'{,v=|&{s52hi=\u0000Qs52h`"), objectArray);
            ConnectionManager connectionManager = a3;
            Connection connection2 = connectionManager.loadConnectionWithDetails((Connection)a2);
            connectionManager.startConnectionInternal(connection2);
            return;
        }
        catch (Exception exception) {
            Object[] objectArray = new Object[--3];
            objectArray[3 & 4] = a2.getName();
            objectArray[4 ^ 5] = a2.getId();
            objectArray[--2] = ExceptionUtils.getRootCauseMessage((Throwable)exception);
            a3.f_oT.m_jK(a2.getProject()).m_w("Connection Restore (Leader " + (String)a + ")", c_Va.m_Te((Object)"RoW4>XM<Ro^<\u0011}\u001ep\u0012xWh\u0018<\u0005y\u0004h\u0018n\u00122W_\u0016i\u0004yM<Ro").formatted(objectArray));
            try {
                f_zT.warn(VariableValue.m_YBa((Object)"V&{'p*a z'X({(r,gi=\u0005p(q,gin4<s5\ba=p$e=|'ria&5:a&eiv&{'p*a z'52hit/a,gig,f=z;t=|&{is(|%`;pg"), (Object)a, (Object)a2.getId());
                a3.stopConnectionInternal((Connection)a2);
                return;
            }
            catch (Exception exception2) {
                Object[] objectArray2 = new Object[--4];
                objectArray2[3 >> 2] = a;
                objectArray2[--1] = a2.getId();
                objectArray2[--2] = exception2.getMessage();
                objectArray2[--3] = exception2;
                f_zT.error(c_Va.m_Te((Object)"_\u0018r\u0019y\u0014h\u001es\u0019Q\u0016r\u0016{\u0012nW4;y\u0016x\u0012nWg\n5M<1}\u001ep\u0012xWh\u0018<\u0004h\u0018lW\u007f\u0018r\u0019y\u0014h\u001es\u0019<\faW}\u0011h\u0012nWn\u0012o\u0003s\u0005}\u0003u\u0018rWz\u0016u\u001bi\u0005yM<\fa"), objectArray2);
                return;
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    protected void startConnectionInternal(String string) {
        void a;
        ConnectionManager connectionManager = this;
        ConnectionManager a2 = connectionManager.f_XR.m_wCa((String)a);
        if (a2 == null) {
            throw new NotFoundException("Connection not found with id: " + (String)a);
        }
        ConnectionManager connectionManager2 = connectionManager;
        connectionManager2.startConnectionInternal(connectionManager2.loadConnectionWithDetails((Connection)a2));
    }

    protected void stopConnectionInternal(String string) {
        ConnectionManager a;
        Object a2 = string;
        ConnectionManager connectionManager = a = this;
        connectionManager.stopConnectionInternal(connectionManager.f_XR.m_VAa((String)a2));
    }

    protected void startConnectionInternal(Connection<?> connection) {
        Connection<?> a = connection;
        Connection<?> a2 = this;
        a2.f_ht.m_bea(() -> {
            ConnectionManager a = a;
            ConnectionManager a2 = this;
            a2.f_fs.lock();
            try {
                a2.stopConnectionInternal((Connection)a);
                if (!Boolean.TRUE.equals(a.getProject().getIsActive())) {
                    throw new NotActiveException("Project should be active to start connection " + a.getName());
                }
                ConnectionManager connectionManager = a2;
                connectionManager.f_Xu.m_wj();
                connectionManager.f_kS.m_Bda((Connection)a).m_Ru();
                String[] stringArray = new String[3 >> 1];
                stringArray[3 >> 2] = a.getId();
                connectionManager.f_ZS.sadd(f_lS, stringArray);
                return;
            }
            finally {
                a2.f_fs.unlock();
            }
        }, a);
    }

    @PreAuthorize(value="hasAuthority('STOP_CONNECTION')")
    public void stopConnection(String string) {
        Object a = string;
        ConnectionManager a2 = this;
        if (a2.f_VT.m_r()) {
            f_zT.debug(VariableValue.m_YBa((Object)"\u0005P\bQ\fGs5\u001aa&e9|'riv&{'p*a z'52hiy&v(y%lg"), a);
            a2.stopConnectionInternal((String)a);
            return;
        }
        f_zT.debug(c_Va.m_Te((Object)"9S91;Y6X2NM<%y\u0006i\u0012o\u0003u\u0019{Wp\u0012}\u0013y\u0005<\u0003sWo\u0003s\u0007<\u0014s\u0019r\u0012\u007f\u0003u\u0018rWg\n2"), a);
        try {
            Object[] objectArray = new Object[5 >> 2];
            objectArray[3 & 4] = a;
            a2.f_VT.m_ia(Short.valueOf((short)(0x21EA & 0x5EDF)), objectArray);
            return;
        }
        catch (Exception exception) {
            throw new ClusterRpcException("Failed to RPC stop connection " + (String)a, (Throwable)exception);
        }
    }

    @PreAuthorize(value="hasAuthority('VIEW_CONNECTION_ITEM')")
    public Object browseConnection(String string) {
        Object a = string;
        ConnectionManager a2 = this;
        if (a2.f_VT.m_r()) {
            f_zT.debug(VariableValue.m_YBa((Object)"Y\fT\rP\u001b/iE,g/z;x {.5+g&b:piz9p;t=|&{is&giv&{'p*a z'52hiy&v(y%lg"), a);
            return a2.browseConnectionInternal((String)a);
        }
        f_zT.debug(c_Va.m_Te((Object)"9S91;Y6X2NM<%y\u0006i\u0012o\u0003u\u0019{Wp\u0012}\u0013y\u0005<\u0003sWl\u0012n\u0011s\u0005qW~\u0005s\u0000o\u0012<\u0018l\u0012n\u0016h\u001es\u0019<\u0011s\u0005<\u0014s\u0019r\u0012\u007f\u0003u\u0018rWg\n2"), a);
        try {
            Object[] objectArray = new Object[4 ^ 5];
            objectArray[2 & 5] = a;
            return a2.f_VT.m_ia(Short.valueOf((short)(0xCFB & 0x73D6)), objectArray);
        }
        catch (Exception exception) {
            throw new ClusterRpcException("Failed to RPC browse connection " + (String)a, (Throwable)exception);
        }
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void restoreSingleConnectionOnLeader(Connection<?> connection) {
        void a;
        ConnectionManager connectionManager;
        ConnectionManager connectionManager2 = connectionManager = this;
        Object a2 = connectionManager2.f_VT.m_Ga();
        String[] stringArray = new String[--3];
        stringArray[2 & 5] = VariableValue.m_YBa((Object)"F\u001dT\u001bA\u0016V\u0006[\u0007P\nA\u0000Z\u0007");
        stringArray[--1] = c_Va.m_Te((Object)"O#S'C4S9R2_#U8R");
        stringArray[5 >> 1] = VariableValue.m_YBa((Object)"C\u0000P\u001eJ\nZ\u0007[\fV\u001d\\\u0006[\u0016\\\u001dP\u0004");
        connectionManager2.f_ht.m_VEa(() -> connectionManager.lambda$restoreSingleConnectionOnLeader$1((String)a2, (Connection)a), a.getSpace(), stringArray);
    }

    @PreAuthorize(value="hasAuthority('SET_VARIABLE_VALUE')")
    public void setVariableValue(SetValueRequest<V> setValueRequest) {
        SetValueRequest<V> a = setValueRequest;
        SetValueRequest<V> a2 = this;
        Objects.requireNonNull(a, VariableValue.m_YBa((Object)"F,a\u001ft%`,G,d<p:aiv({'z=5+pi{<y%"));
        Objects.requireNonNull(a.getConnectionId(), c_Va.m_Te((Object)"4s\u0019r\u0012\u007f\u0003u\u0018r>xWu\u0019<$y\u0003J\u0016p\u0002y%y\u0006i\u0012o\u0003<\u0014}\u0019r\u0018hW~\u0012<\u0019i\u001bp"));
        if (a2.f_VT.m_r()) {
            f_zT.debug(VariableValue.m_YBa((Object)"Y\fT\rP\u001b/iF,a=|'ric(g t+y,5?t%`,5/z;5*z'{,v=|&{in45%z*t%y0/in4"), (Object)a.getConnectionId(), a);
            a2.setVariableValueInternal(a);
            return;
        }
        f_zT.debug(c_Va.m_Te((Object)"R8RZP2]3Y%&WN\u0012m\u0002y\u0004h\u001er\u0010<\u001by\u0016x\u0012nWh\u0018<\u0004y\u0003<\u0001}\u0005u\u0016~\u001byWj\u0016p\u0002yWz\u0018nW\u007f\u0018r\u0019y\u0014h\u001es\u0019<\faM<\fa"), (Object)a.getConnectionId(), a);
        try {
            Object[] objectArray = new Object[3 >> 1];
            objectArray[5 >> 3] = a;
            a2.f_VT.m_ia(Short.valueOf((short)(0x1DCF & 0x62FC)), objectArray);
            return;
        }
        catch (Exception exception) {
            throw new ClusterRpcException("Failed to RPC set variable value for connection " + a.getConnectionId(), (Throwable)exception);
        }
    }

    private /* synthetic */ void registerRemoteCallsWithClusterNode() {
        ConnectionManager connectionManager = this;
        try {
            Class[] classArray = new Class[2 ^ 3];
            classArray[5 >> 3] = String.class;
            connectionManager.f_VT.m_fa((short)(0x5AEB & 0x25DD), (Object)connectionManager, ConnectionManager.class.getDeclaredMethod(VariableValue.m_YBa((Object)":a(g=V&{'p*a z'\\'a,g't%"), classArray));
            Class[] classArray2 = new Class[5 >> 2];
            classArray2[3 & 4] = String.class;
            connectionManager.f_VT.m_fa((short)(0x46CE & 0x39FB), (Object)connectionManager, ConnectionManager.class.getDeclaredMethod(c_Va.m_Te((Object)"\u0004h\u0018l4s\u0019r\u0012\u007f\u0003u\u0018r>r\u0003y\u0005r\u0016p"), classArray2));
            Class[] classArray3 = new Class[4 ^ 5];
            classArray3[2 & 5] = String.class;
            connectionManager.f_VT.m_fa((short)(0x12DF & 0x6DEB), (Object)connectionManager, ConnectionManager.class.getDeclaredMethod(VariableValue.m_YBa((Object)".p=V&{'p*a z'F=t=`:\\'a,g't%"), classArray3));
            Class[] classArray4 = new Class[2 ^ 3];
            classArray4[3 >> 2] = SetValueRequest.class;
            connectionManager.f_VT.m_fa((short)(0x70DE & 0xFED), (Object)connectionManager, ConnectionManager.class.getDeclaredMethod(c_Va.m_Te((Object)"\u0004y\u0003J\u0016n\u001e}\u0015p\u0012J\u0016p\u0002y>r\u0003y\u0005r\u0016p"), classArray4));
            Class[] classArray5 = new Class[2 ^ 3];
            classArray5[3 ^ 3] = Collection.class;
            connectionManager.f_VT.m_fa((short)(0x26CD & 0x59FF), (Object)connectionManager, ConnectionManager.class.getDeclaredMethod(VariableValue.m_YBa((Object)":p=C(g t+y,C(y<p:\\'a,g't%"), classArray5));
            Class[] classArray6 = new Class[1];
            classArray6[0] = String.class;
            connectionManager.f_VT.m_fa((short)(0x37CF & 0x48FE), (Object)connectionManager, ConnectionManager.class.getDeclaredMethod(c_Va.m_Te((Object)"o\u0003}\u0005h4s\u0019r\u0012\u007f\u0003u\u0018r\u0004^\u000eL\u0005s\u001dy\u0014h>x>r\u0003y\u0005r\u0016p"), classArray6));
            Class[] classArray7 = new Class[1];
            classArray7[0] = String.class;
            connectionManager.f_VT.m_fa((short)(0x6FDF & 0x10EF), (Object)connectionManager, ConnectionManager.class.getDeclaredMethod(VariableValue.m_YBa((Object)"f=z9V&{'p*a z'f\u000bl\u0019g&\u007f,v=\\-\\'a,g't%"), classArray7));
            Class[] classArray8 = new Class[1];
            classArray8[0] = String.class;
            connectionManager.f_VT.m_fa((short)(0x7CD3 & 0x3FC), (Object)connectionManager, ConnectionManager.class.getDeclaredMethod(c_Va.m_Te((Object)"\u0010y\u0003_\u0018r\u0019y\u0014h\u001es\u0019O\u0003}\u0003i\u0004y\u0004^\u000eL\u0005s\u001dy\u0014h>x>r\u0003y\u0005r\u0016p"), classArray8));
            Class[] classArray9 = new Class[1];
            classArray9[0] = String[].class;
            connectionManager.f_VT.m_fa((short)(0x7AFF & 0x5D1), (Object)connectionManager, ConnectionManager.class.getDeclaredMethod(VariableValue.m_YBa((Object)"r,a\nz'{,v=|&{\u001aa(a<f,f\u000bl\u0000q:\\'a,g't%"), classArray9));
            Class[] classArray10 = new Class[1];
            classArray10[0] = String.class;
            connectionManager.f_VT.m_fa((short)(0x75F3 & 0xADE), (Object)connectionManager, ConnectionManager.class.getDeclaredMethod(c_Va.m_Te((Object)"\u0015n\u0018k\u0004y4s\u0019r\u0012\u007f\u0003u\u0018r>r\u0003y\u0005r\u0016p"), classArray10));
            return;
        }
        catch (NoSuchMethodException a) {
            throw new IllegalStateException(VariableValue.m_YBa((Object)"S(|%p-5=zig,r f=p;5\nz'{,v=|&{\u0004t't.p;5\u001bE\n5$p=}&q:"), a);
        }
    }

    protected void setVariableValueInternal(SetValueRequest<V> setValueRequest) {
        SetValueRequest<V> a = setValueRequest;
        SetValueRequest<V> a2 = this;
        c_Se c_Se2 = a2.f_kS.m_yAa(a.getConnectionId());
        if (c_Se2 == null) {
            throw new NotFoundException("Connector for connection " + a.getConnectionId() + " not found or not active on leader.");
        }
        c_Se2.m_os(a);
    }

    /*
     * WARNING - void declaration
     */
    public ConnectionManager(c_Gl c_Gl2, c_uc c_uc2, c_BC c_BC2, c_NI<C, V> c_NI2, JedisPooled jedisPooled, c_K c_K2, c_Hj c_Hj2) {
        ConnectionManager a;
        void a2;
        void a3;
        void a4;
        void a5;
        void a6;
        void a7;
        ConnectionManager a8;
        ConnectionManager connectionManager = connectionManager2;
        ConnectionManager connectionManager2 = c_Hj2;
        ConnectionManager connectionManager3 = a8 = connectionManager;
        ConnectionManager connectionManager4 = a8;
        ConnectionManager connectionManager5 = a8;
        ConnectionManager connectionManager6 = a8;
        a8.f_fs = new ReentrantLock();
        a8.f_XR = a7;
        connectionManager5.f_Xu = a6;
        connectionManager5.f_oT = a5;
        connectionManager4.f_kS = a4;
        connectionManager4.f_ZS = a3;
        connectionManager3.f_VT = a2;
        connectionManager3.f_ht = a;
    }

    @PostConstruct
    private /* synthetic */ void initializeClusterIntegration() {
        ConnectionManager a;
        ConnectionManager connectionManager = a;
        connectionManager.registerRemoteCallsWithClusterNode();
        connectionManager.f_VT.m_Ba((ClusterNodeListener)a);
        f_zT.info(c_Va.m_Te((Object)"4s\u0019r\u0012\u007f\u0003u\u0018r:}\u0019}\u0010y\u0005<\u001er\u001eh\u001e}\u001bu\ry\u0013<\u0016r\u0013<\u0005y\u0010u\u0004h\u0012n\u0012xW}\u0004<4p\u0002o\u0003y\u0005R\u0018x\u0012P\u001eo\u0003y\u0019y\u00052"));
    }

    protected void stopConnectionsByProjectIdInternal(String string) {
        Object a = string;
        ConnectionManager a2 = this;
        if ((a = a2.f_XR.m_dca((String)a)) == null || a.isEmpty()) {
            return;
        }
        a.forEach(arg_0 -> a2.stopConnectionInternal(arg_0));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void leader() {
        ConnectionManager connectionManager;
        ConnectionManager connectionManager2 = connectionManager = this;
        Object a = connectionManager2.f_VT.m_Ga();
        f_zT.info(c_Va.m_Te((Object)"4s\u0019r\u0012\u007f\u0003u\u0018r:}\u0019}\u0010y\u0005&WH\u001fu\u0004<\u0019s\u0013yW4\fa^<\u001f}\u0004<\u0015y\u0014s\u001ayWh\u001fyWP2]3Y%2WN\u0012o\u0003s\u0005u\u0019{W}\u0014h\u001ej\u0012<\u0014s\u0019r\u0012\u007f\u0003u\u0018r\u00042Y2"), a);
        connectionManager2.f_fs.lock();
        try {
            HashSet hashSet = new HashSet(connectionManager.f_ZS.smembers(f_lS));
            if (hashSet.isEmpty()) {
                f_zT.info(VariableValue.m_YBa((Object)"\nz'{,v=|&{\u0004t't.p;5aY,t-p;52h`/i[&5(v=|?piv&{'p*a z'fis&`'qi|'5\u001bp-|:5=zig,f=z;pg"), a);
                return;
            }
            Object[] objectArray = new Object[--3];
            objectArray[2 & 5] = a;
            objectArray[3 >> 1] = hashSet.size();
            objectArray[5 >> 1] = hashSet;
            f_zT.info(c_Va.m_Te((Object)"_\u0018r\u0019y\u0014h\u001es\u0019Q\u0016r\u0016{\u0012nW4;y\u0016x\u0012nWg\n5M<1s\u0002r\u0013<\faW}\u0014h\u001ej\u0012<\u0014s\u0019r\u0012\u007f\u0003u\u0018rWU3oWu\u0019<%y\u0013u\u0004<\u0003sWn\u0012o\u0003s\u0005yM<\fa"), objectArray);
            Object object = new ArrayList();
            String[] stringArray = new String[4 ^ 5];
            stringArray[3 & 4] = VariableValue.m_YBa((Object)"C\u0000P\u001eJ\nZ\u0007[\fV\u001d\\\u0006[\u0016\\\u001dP\u0004");
            connectionManager.f_ht.m_bga(() -> {
                void a;
                Object a2 = hashSet;
                ConnectionManager a3 = this;
                a.addAll(a3.f_XR.m_sCa((Set)a2));
            }, stringArray);
            f_zT.info(c_Va.m_Te((Object)"4s\u0019r\u0012\u007f\u0003u\u0018r:}\u0019}\u0010y\u0005<_P\u0012}\u0013y\u0005<\fa^&W]\u0003h\u0012q\u0007h\u001er\u0010<\u0003sWn\u0012o\u0003s\u0005yWg\n<\u0014s\u0019r\u0012\u007f\u0003u\u0018r\u00042"), a, (Object)object.size());
            Object object2 = object = object.iterator();
            while (object2.hasNext()) {
                Connection connection = (Connection)object.next();
                object2 = object;
                connectionManager.restoreSingleConnectionOnLeader(connection);
            }
            f_zT.info(VariableValue.m_YBa((Object)"\nz'{,v=|&{\u0004t't.p;5aY,t-p;52h`/iS { f!p-5*z'{,v=|&{ig,f=z;t=|&{ie;z*p:fg"), a);
            return;
        }
        catch (Exception exception) {
            Object[] objectArray = new Object[--3];
            objectArray[2 & 5] = a;
            objectArray[--1] = exception.getMessage();
            objectArray[5 >> 1] = exception;
            f_zT.error(c_Va.m_Te((Object)"4s\u0019r\u0012\u007f\u0003u\u0018r:}\u0019}\u0010y\u0005<_P\u0012}\u0013y\u0005<\fa^&WY\u0005n\u0018nWx\u0002n\u001er\u0010<\u0014s\u0019r\u0012\u007f\u0003u\u0018rWn\u0012o\u0003s\u0005}\u0003u\u0018rWl\u0005s\u0014y\u0004oM<\fa"), objectArray);
            return;
        }
        finally {
            connectionManager.f_fs.unlock();
        }
    }

    @PreAuthorize(value="hasAuthority('SET_VARIABLE_VALUE')")
    public void setVariableValues(Collection<SetValueRequest<V>> collection) {
        Collection<SetValueRequest<V>> a22 = collection;
        ConnectionManager a3 = this;
        if (a22 == null || a22.isEmpty()) {
            return;
        }
        a22.forEach(a -> Objects.requireNonNull(a, VariableValue.m_YBa((Object)"F,a\u001ft%`,G,d<p:aiv({'z=5+pi{<y%")));
        a22.forEach(a -> Objects.requireNonNull(a.getConnectionId(), c_Va.m_Te((Object)"4s\u0019r\u0012\u007f\u0003u\u0018r>xWu\u0019<$y\u0003J\u0016p\u0002y%y\u0006i\u0012o\u0003<\u0014}\u0019r\u0018hW~\u0012<\u0019i\u001bp")));
        if (a3.f_VT.m_r()) {
            f_zT.debug(VariableValue.m_YBa((Object)"\u0005P\bQ\fGs5\u001ap=a {.52hic(g t+y,5?t%`,fiy&v(y%lg"), (Object)a22.size());
            a3.setVariableValuesInternal((Collection)a22);
            return;
        }
        f_zT.debug(c_Va.m_Te((Object)"9S91;Y6X2NM<%y\u0006i\u0012o\u0003u\u0019{Wp\u0012}\u0013y\u0005<\u0003sWo\u0012hWg\n<\u0001}\u0005u\u0016~\u001byWj\u0016p\u0002y\u00042"), (Object)a22.size());
        try {
            Object[] objectArray = new Object[--1];
            objectArray[5 >> 3] = new ArrayList(a22);
            a3.f_VT.m_ia(Short.valueOf((short)(0x70FD & 0xFCF)), objectArray);
            return;
        }
        catch (Exception a22) {
            throw new ClusterRpcException(VariableValue.m_YBa((Object)"\u000ft y,qia&5\u001bE\n5:p=5?t;|(w%pic(y<p:"), (Throwable)a22);
        }
    }

    @PreAuthorize(value="hasAuthority('STOP_CONNECTION')")
    public void stopConnections(String string) {
        Object a = string;
        ConnectionManager a2 = this;
        if (a2.f_VT.m_r()) {
            f_zT.debug(VariableValue.m_YBa((Object)"Y\fT\rP\u001b/iF=z9e {.5(y%5*z'{,v=|&{:5/z;59g&\u007f,v=52hiy&v(y%lg"), a);
            a2.stopConnectionsByProjectIdInternal((String)a);
            return;
        }
        f_zT.debug(c_Va.m_Te((Object)"R8RZP2]3Y%&WN\u0012m\u0002y\u0004h\u001er\u0010<\u001by\u0016x\u0012nWh\u0018<\u0004h\u0018lW}\u001bpW\u007f\u0018r\u0019y\u0014h\u001es\u0019oWz\u0018nWl\u0005s\u001dy\u0014hWg\n2"), a);
        try {
            Object[] objectArray = new Object[--1];
            objectArray[3 & 4] = a;
            a2.f_VT.m_ia(Short.valueOf((short)(0x37EF & 0x48DF)), objectArray);
            return;
        }
        catch (Exception exception) {
            throw new ClusterRpcException("Failed to RPC stop connections for project " + (String)a, (Throwable)exception);
        }
    }

    @PreAuthorize(value="hasAuthority('VIEW_CONNECTION_ITEM')")
    public c_sl getConnectionStatus(String string) {
        Object a = string;
        ConnectionManager a2 = this;
        if (a2.f_VT.m_r()) {
            f_zT.debug(VariableValue.m_YBa((Object)"\u0005P\bQ\fGs5\u000ep=a {.5*z'{,v=|&{if=t=`:5/z;52hiy&v(y%lg"), a);
            return a2.getConnectionStatusInternal((String)a);
        }
        f_zT.debug(c_Va.m_Te((Object)"R8RZP2]3Y%&WN\u0012m\u0002y\u0004h\u001er\u0010<\u001by\u0016x\u0012nWz\u0018nW\u007f\u0018r\u0019y\u0014h\u001es\u0019<\u0004h\u0016h\u0002oWz\u0018nWg\n2"), a);
        try {
            Object[] objectArray = new Object[5 >> 2];
            objectArray[3 & 4] = a;
            return (c_sl)a2.f_VT.m_ia(Short.valueOf((short)(0x67DF & 0x18EB)), objectArray);
        }
        catch (Exception exception) {
            throw new ClusterRpcException("Failed to RPC get connection status for " + (String)a, (Throwable)exception);
        }
    }

    private /* synthetic */ Connection<?> loadConnectionWithDetails(Connection<?> connection) {
        Connection<?> a = connection;
        Connection<?> a2 = this;
        if (a == null) {
            return null;
        }
        return a2.f_XR.m_RAa(a.getId());
    }

    /*
     * WARNING - void declaration
     */
    @TransactionalEventListener(value={c_fJ.class})
    public void handleRestartEvent(c_fJ c_fJ2) {
        void a;
        ConnectionManager connectionManager = this;
        if (connectionManager.f_VT.m_r()) {
            ConnectionManager a2 = a.m_uAa();
            f_zT.info(c_Va.m_Te((Object)"P2]3Y%&WT\u0016r\u0013p\u001er\u0010<%y\u0004h\u0016n\u0003Y\u0001y\u0019hWz\u0018nW\u007f\u0018r\u0019y\u0014h\u001es\u0019&Wg\n<_U3&Wg\n5"), (Object)a2.getName(), (Object)a2.getId());
            connectionManager.f_fs.lock();
            try {
                if (connectionManager.getConnectionStatusInternal(a2.getId()) == c_sl.f_Ju) {
                    connectionManager.startConnectionInternal(a2.getId());
                }
                return;
            }
            finally {
                connectionManager.f_fs.unlock();
            }
        }
        f_zT.debug(VariableValue.m_YBa((Object)"[\u0006[dY\fT\rP\u001b/i\\.{&g {.5\u001bp:a(g=P?p'ais&giv&{'p*a z'/in4"), (Object)a.m_uAa().getId());
    }

    @PreAuthorize(value="hasAuthority('VIEW_CONNECTION_ITEM')")
    public Map<String, c_sl> getConnectionStatuses(String[] stringArray) {
        Object[] a = stringArray;
        Object[] a2 = this;
        if (a == null || a.length == 0) {
            return Collections.emptyMap();
        }
        if (a2.f_VT.m_r()) {
            f_zT.debug(VariableValue.m_YBa((Object)"\u0005P\bQ\fGs5\u000ep=a {.5*z'{,v=|&{if=t=`:p:5/z;52hi\\\rfiy&v(y%lg"), (Object)a.length);
            return a2.getConnectionStatusesByIdsInternal((String[])a);
        }
        f_zT.debug(c_Va.m_Te((Object)"R8RZP2]3Y%&WN\u0012m\u0002y\u0004h\u001er\u0010<\u001by\u0016x\u0012nWz\u0018nW\u007f\u0018r\u0019y\u0014h\u001es\u0019<\u0004h\u0016h\u0002o\u0012oWz\u0018nWg\n<>X\u00042"), (Object)a.length);
        try {
            Object[] objectArray = new Object[3 >> 1];
            objectArray[3 >> 2] = a;
            return (Map)a2.f_VT.m_ia(Short.valueOf((short)(0xAF9 & 0x75D7)), objectArray);
        }
        catch (Exception exception) {
            throw new ClusterRpcException("Failed to RPC get connection statuses for IDs " + Arrays.toString(a), (Throwable)exception);
        }
    }
}

