/*
 * Decompiled with CFR 0.152.
 */
package com.inscada.mono.communication.base.restcontrollers;

import com.inscada.mono.communication.base.model.Connection;
import com.inscada.mono.communication.base.model.Device;
import com.inscada.mono.communication.base.model.Frame;
import com.inscada.mono.communication.base.model.Variable;
import com.inscada.mono.communication.base.services.c_De;
import com.inscada.mono.communication.base.services.c_WD;
import com.inscada.mono.communication.base.services.c_WF;
import com.inscada.mono.communication.base.template.model.DeviceGenerationRequest;
import com.inscada.mono.communication.base.template.model.DeviceTemplate;
import com.inscada.mono.communication.base.template.model.FrameTemplate;
import com.inscada.mono.communication.base.template.model.VariableTemplate;
import com.inscada.mono.communication.base.template.q.c_Ld;
import com.inscada.mono.config.c_hC;
import com.inscada.mono.shared.aspects.SoftDeleteFilterAspect;
import jakarta.validation.Valid;
import java.net.URI;
import java.util.Collection;
import java.util.List;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.util.UriComponentsBuilder;

public abstract class ConnectionController<TConnection extends Connection<TDevice>, TDevice extends Device<TConnection, TFrame>, TFrame extends Frame<TDevice, TVariable>, TVariable extends Variable<TFrame, TDevice, TConnection>, TConnectionService extends c_De<TConnection, TDevice, TFrame, TVariable>, TDeviceService extends c_WD<TConnection, TDevice, TFrame, TVariable>, TFrameService extends c_WF<TConnection, TDevice, TFrame, TVariable>, TDeviceTemplate extends DeviceTemplate<TFrameTemplate>, TFrameTemplate extends FrameTemplate<TDeviceTemplate, TVariableTemplate>, TVariableTemplate extends VariableTemplate<TFrameTemplate, TDeviceTemplate>, TTemplateService extends c_Ld<TDeviceTemplate, TFrameTemplate, TVariableTemplate, TConnection, TDevice, TFrame, TVariable>> {
    protected final TFrameService f_iL;
    protected final TTemplateService f_sj;
    protected final TDeviceService f_Nl;
    protected final TConnectionService f_jj;

    @GetMapping(value={"/devices/by-project"})
    public Collection<TDevice> getDevicesByProject(@RequestParam String string) {
        ConnectionController connectionController = object;
        Object object = string;
        ConnectionController a = connectionController;
        return a.f_Nl.m_SR((String)object);
    }

    @GetMapping(value={"/{connectionId}/devices"})
    public Collection<TDevice> getDevices(@PathVariable String string) {
        ConnectionController connectionController = object;
        Object object = string;
        ConnectionController a = connectionController;
        return a.f_Nl.m_eT((String)object);
    }

    /*
     * WARNING - void declaration
     */
    @PutMapping(value={"/{connectionId}/devices/{deviceId}"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void updateDevice(@PathVariable String string, @PathVariable String string2, @Valid @RequestBody TDevice TDevice) {
        void deviceId;
        void connectionId;
        ConnectionController connectionController = object;
        Object object = TDevice;
        ConnectionController a = connectionController;
        a.f_Nl.m_hu((String)connectionId, (String)deviceId, (Device)object);
    }

    @GetMapping(value={"/frames"})
    public Collection<TFrame> getFrames() {
        ConnectionController a;
        return a.f_iL.m_b();
    }

    /*
     * WARNING - void declaration
     */
    @GetMapping(value={"/{connectionId}/devices/{deviceId}/frames"})
    public Collection<TFrame> getFrames(@PathVariable String string, @PathVariable String string2) {
        void connectionId;
        ConnectionController connectionController = object;
        Object object = string2;
        ConnectionController a = connectionController;
        return a.f_iL.m_es((String)connectionId, (String)object);
    }

    @GetMapping(value={"/device/{deviceId}"})
    public TDevice getDeviceById(@PathVariable String string) {
        ConnectionController connectionController = object;
        Object object = string;
        ConnectionController a = connectionController;
        return (TDevice)a.f_Nl.m_HT((String)object);
    }

    /*
     * WARNING - void declaration
     */
    @PostMapping
    public ResponseEntity<TConnection> createConnection(@Valid @RequestBody TConnection TConnection, UriComponentsBuilder uriComponentsBuilder) {
        void a;
        ConnectionController connectionController = object;
        Object object = TConnection;
        ConnectionController connection = connectionController;
        object = connection.f_jj.m_Cs((Connection)object);
        Object[] objectArray = new Object[4 ^ 5];
        objectArray[3 ^ 3] = object.getId();
        return ResponseEntity.created((URI)a.path(c_hC.m_JP((Object)"g0+$&%-(<\"'%\u0001/5")).buildAndExpand(objectArray).toUri()).body(object);
    }

    @GetMapping(value={"/by-project"})
    public Collection<TConnection> getConnectionsByProject(@RequestParam String string) {
        ConnectionController connectionController = object;
        Object object = string;
        ConnectionController a = connectionController;
        return a.f_jj.m_at((String)object);
    }

    @GetMapping
    public Collection<TConnection> getConnections() {
        ConnectionController a;
        return a.f_jj.m_b();
    }

    /*
     * WARNING - void declaration
     */
    @DeleteMapping(value={"/{connectionId}/devices/{deviceId}"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void deleteDevice(@PathVariable String string, @PathVariable String string2) {
        void connectionId;
        ConnectionController connectionController = object;
        Object object = string2;
        ConnectionController a = connectionController;
        a.f_Nl.m_Ft((String)connectionId, (String)object);
    }

    /*
     * WARNING - void declaration
     */
    @GetMapping(value={"/{connectionId}/devices/{deviceId}"})
    public TDevice getDevice(@PathVariable String string, @PathVariable String string2) {
        void connectionId;
        ConnectionController connectionController = object;
        Object object = string2;
        ConnectionController a = connectionController;
        return (TDevice)a.f_Nl.m_mt((String)connectionId, (String)object);
    }

    @DeleteMapping(value={"/multi/by-ids"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void deleteConnectionsByIds(@RequestParam String[] stringArray) {
        String[] stringArray2 = stringArray3;
        String[] stringArray3 = stringArray;
        String[] a = stringArray2;
        a.f_jj.m_f(List.of(stringArray3));
    }

    @GetMapping(value={"/frames/by-project"})
    public Collection<TFrame> getFramesByProject(@RequestParam String string) {
        ConnectionController connectionController = object;
        Object object = string;
        ConnectionController a = connectionController;
        return a.f_iL.m_fu((String)object);
    }

    @DeleteMapping(value={"/{connectionId}"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void deleteConnection(@PathVariable String string) {
        ConnectionController connectionController = object;
        Object object = string;
        ConnectionController a = connectionController;
        a.f_jj.m_H((String)object);
    }

    @GetMapping(value={"/{connectionId}"})
    public TConnection getConnection(@PathVariable String string) {
        ConnectionController connectionController = object;
        Object object = string;
        ConnectionController a = connectionController;
        return (TConnection)a.f_jj.m_rs((String)object);
    }

    @DeleteMapping(value={"/devices/multi/by-ids"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void deleteDevicesByIds(@RequestParam String[] stringArray) {
        String[] stringArray2 = stringArray3;
        String[] stringArray3 = stringArray;
        String[] a = stringArray2;
        a.f_Nl.m_f(List.of(stringArray3));
    }

    @GetMapping(value={"/frame/{frameId}"})
    public TFrame getFrameById(@PathVariable String string) {
        ConnectionController connectionController = object;
        Object object = string;
        ConnectionController a = connectionController;
        return (TFrame)a.f_iL.m_Ns((String)object);
    }

    /*
     * WARNING - void declaration
     */
    @GetMapping(value={"/{connectionId}/devices/{deviceId}/frames/{frameId}"})
    public TFrame getFrame(@PathVariable String string, @PathVariable String string2, @PathVariable String string3) {
        void deviceId;
        void connectionId;
        ConnectionController connectionController = object;
        Object object = string3;
        ConnectionController a = connectionController;
        return (TFrame)a.f_iL.m_Et((String)connectionId, (String)deviceId, (String)object);
    }

    /*
     * WARNING - void declaration
     */
    protected ConnectionController(TConnectionService TConnectionService, TDeviceService TDeviceService, TFrameService TFrameService, TTemplateService TTemplateService) {
        Object a;
        void a2;
        void a3;
        void a4;
        ConnectionController a5;
        ConnectionController connectionController = object;
        Object object = TTemplateService;
        ConnectionController connectionController2 = a5 = connectionController;
        ConnectionController connectionController3 = a5;
        connectionController3.f_jj = a4;
        connectionController3.f_Nl = a3;
        connectionController2.f_iL = a2;
        connectionController2.f_sj = a;
    }

    @DeleteMapping(value={"/frames/multi/by-ids"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void deleteFramesByIds(@RequestParam String[] stringArray) {
        String[] stringArray2 = stringArray3;
        String[] stringArray3 = stringArray;
        String[] a = stringArray2;
        a.f_iL.m_f(List.of(stringArray3));
    }

    /*
     * WARNING - void declaration
     */
    @PostMapping(value={"/{connectionId}/devices"})
    public ResponseEntity<TDevice> createDevice(@PathVariable String string, @Valid @RequestBody TDevice TDevice, UriComponentsBuilder uriComponentsBuilder) {
        void a;
        void connectionId;
        ConnectionController connectionController = object;
        Object object = TDevice;
        ConnectionController device = connectionController;
        object = device.f_Nl.m_ls((String)connectionId, (Device)object);
        Object[] objectArray = new Object[--2];
        objectArray[3 ^ 3] = connectionId;
        objectArray[2 ^ 3] = object.getId();
        return ResponseEntity.created((URI)a.path(SoftDeleteFilterAspect.m_Ae((Object)"d\u0012(\u0006%\u0007.\n?\u0000$\u0007\u0002\r6F/\f=\u0000(\f8F0\r.\u001f\"\n. /\u0014")).buildAndExpand(objectArray).toUri()).body(object);
    }

    /*
     * WARNING - void declaration
     */
    @PostMapping(value={"/{connectionId}/devices/{deviceId}/frames"})
    public ResponseEntity<TFrame> createFrame(@PathVariable String string, @PathVariable String string2, @Valid @RequestBody TFrame TFrame, UriComponentsBuilder uriComponentsBuilder) {
        void a;
        void deviceId;
        void connectionId;
        ConnectionController connectionController = object;
        Object object = TFrame;
        ConnectionController frame = connectionController;
        object = frame.f_iL.m_cT((String)connectionId, (String)deviceId, (Frame)object);
        Object[] objectArray = new Object[--3];
        objectArray[5 >> 3] = connectionId;
        objectArray[5 >> 2] = deviceId;
        objectArray[1 ^ 3] = object.getId();
        return ResponseEntity.created((URI)a.path(c_hC.m_JP((Object)"g0+$&%-(<\"'%\u0001/5d,.>\"+.;d3/-=!(-\u0002,6g-:*%.;d3-:*%.\u0001/5")).buildAndExpand(objectArray).toUri()).body(object);
    }

    public static String m_FU(Object object) {
        Object object2 = object;
        object2 = (String)object2;
        int n = ((String)object2).length();
        int a = n - (4 ^ 5);
        char[] cArray = new char[n];
        int n2 = --5 << --3 ^ (--2 ^ 5);
        int cfr_ignored_0 = (5 >> 1 ^ --5) << --3 ^ --5;
        int n3 = a;
        int n4 = --5 << --4 ^ --3;
        while (n3 >= 0) {
            int n5 = a--;
            cArray[n5] = (char)(((String)object2).charAt(n5) ^ n4);
            if (a < 0) break;
            int n6 = a--;
            cArray[n6] = (char)(((String)object2).charAt(n6) ^ n2);
            n3 = a;
        }
        return new String(cArray);
    }

    /*
     * WARNING - void declaration
     */
    @DeleteMapping(value={"/{connectionId}/devices/{deviceId}/frames/{frameId}"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void deleteFrame(@PathVariable String string, @PathVariable String string2, @PathVariable String string3) {
        void deviceId;
        void connectionId;
        ConnectionController connectionController = object;
        Object object = string3;
        ConnectionController a = connectionController;
        a.f_iL.m_gT((String)connectionId, (String)deviceId, (String)object);
    }

    /*
     * WARNING - void declaration
     */
    @PostMapping(value={"/{connectionId}/devices/generate"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void generateFromTemplate(@PathVariable String string, @RequestBody DeviceGenerationRequest deviceGenerationRequest) {
        void connectionId;
        ConnectionController connectionController = connectionController2;
        ConnectionController connectionController2 = deviceGenerationRequest;
        ConnectionController a = connectionController;
        a.f_sj.m_or((String)connectionId, (DeviceGenerationRequest)connectionController2);
    }

    /*
     * WARNING - void declaration
     */
    @PutMapping(value={"/{connectionId}/devices/{deviceId}/frames/{frameId}"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void updateFrame(@PathVariable String string, @PathVariable String string2, @PathVariable String string3, @Valid @RequestBody TFrame TFrame) {
        void frameId;
        void deviceId;
        void connectionId;
        ConnectionController connectionController = object;
        Object object = TFrame;
        ConnectionController a = connectionController;
        a.f_iL.m_fT((String)connectionId, (String)deviceId, (String)frameId, (Frame)object);
    }

    @GetMapping(value={"/devices"})
    public Collection<TDevice> getDevices() {
        ConnectionController a;
        return a.f_Nl.m_b();
    }

    /*
     * WARNING - void declaration
     */
    @PutMapping(value={"/{connectionId}"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void updateConnection(@PathVariable String string, @Valid @RequestBody TConnection TConnection) {
        void connectionId;
        ConnectionController connectionController = object;
        Object object = TConnection;
        ConnectionController a = connectionController;
        a.f_jj.m_nt((String)connectionId, (Connection)object);
    }
}

