/*
 * Decompiled with CFR 0.152.
 */
package com.inscada.mono.communication.base.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.inscada.mono.communication.base.f.c_ak;
import com.inscada.mono.communication.base.f.c_ok;
import com.inscada.mono.communication.base.model.Connection;
import com.inscada.mono.communication.base.model.Device;
import com.inscada.mono.communication.base.model.Frame;
import com.inscada.mono.communication.base.model.HasFrame;
import com.inscada.mono.communication.base.model.values.VariableValue;
import com.inscada.mono.expression.model.Expression;
import com.inscada.mono.project.model.Project;
import com.inscada.mono.shared.model.SpaceBaseModel;
import com.inscada.mono.shared.validations.CheckAtLeastOneNotNull;
import com.inscada.mono.shared.validations.CheckAtLeastOneNotNull$List;
import jakarta.persistence.AttributeOverride;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.Inheritance;
import jakarta.persistence.InheritanceType;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.Transient;
import jakarta.validation.constraints.Min;
import jakarta.validation.constraints.NotBlank;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.PositiveOrZero;
import jakarta.validation.constraints.Size;
import java.util.Objects;
import org.hibernate.annotations.SQLRestriction;

@Entity
@Inheritance(strategy=InheritanceType.TABLE_PER_CLASS)
@AttributeOverride(name="id", column=@Column(name="variable_id", length=36, nullable=false, updatable=false))
@CheckAtLeastOneNotNull$List(value={@CheckAtLeastOneNotNull(fieldNames={"projectId", "project"}), @CheckAtLeastOneNotNull(fieldNames={"frameId", "frame"})})
public class Variable<TFrame extends Frame<?, ?>, TDevice extends Device<?, ?>, TConnection extends Connection<?>>
extends SpaceBaseModel
implements HasFrame<TFrame> {
    @NotNull
    @Column(name="pulse_off_flag")
    protected Boolean isPulseOff;
    @Size(max=20)
    protected String code;
    protected String unit;
    @JsonIgnore
    @Transient
    protected VariableValue<?> value;
    @NotNull
    @Column(name="active_flag")
    protected Boolean isActive;
    @Column(name="log_threshold")
    protected Double logThreshold;
    @Column(name="fractional_digit_count")
    protected Short fractionalDigitCount;
    @Column(name="value_expression_id", insertable=false, updatable=false)
    protected String valueExpressionId;
    @NotNull
    @Column(name="writable_flag", nullable=false)
    protected Boolean isWritable;
    @Column(name="eng_zero_scale")
    protected Double engZeroScale;
    @Size(max=4000)
    @Column(name="value_expression")
    protected String valueExpressionCode;
    @JsonIgnore
    @ManyToOne
    @SQLRestriction(value="deleted_dttm IS NULL")
    @JoinColumn(name="log_expression_id")
    protected Expression logExpression;
    @Column(name="log_expression_id", insertable=false, updatable=false)
    protected String logExpressionId;
    @Min(value=1L)
    @Column(name="log_period")
    protected Integer logPeriod;
    @PositiveOrZero
    @Column(name="pulse_on_duration")
    protected Integer pulseOnDuration;
    @Column(name="log_max_value")
    protected Double logMaxValue;
    @JsonIgnore
    @ManyToOne(optional=false)
    @SQLRestriction(value="deleted_dttm IS NULL")
    @JoinColumn(name="project_id", updatable=false)
    protected Project project;
    @PositiveOrZero
    @Column(name="pulse_off_duration")
    protected Integer pulseOffDuration;
    @Column(name="project_id", insertable=false, updatable=false)
    protected String projectId;
    @NotNull
    @Column(name="keep_last_values")
    protected Boolean keepLastValues;
    @Column(name="set_min_value")
    protected Double setMinValue;
    @Column(name="raw_full_scale")
    protected Double rawFullScale;
    @Column(name="eng_full_scale")
    protected Double engFullScale;
    @Column(name="value_expression_type")
    protected c_ok valueExpressionType;
    @NotBlank
    @Size(max=100)
    protected String name;
    @Size(max=4000)
    @Column(name="log_expression")
    protected String logExpressionCode;
    @Column(name="log_type")
    protected c_ak logType;
    @Column(name="set_max_value")
    protected Double setMaxValue;
    @Column(name="frame_id", insertable=false, updatable=false)
    protected String frameId;
    @Column(name="raw_zero_scale")
    protected Double rawZeroScale;
    @Column(name="log_min_value")
    protected Double logMinValue;
    @JsonIgnore
    @ManyToOne
    @SQLRestriction(value="deleted_dttm IS NULL")
    @JoinColumn(name="value_expression_id")
    protected Expression valueExpression;
    @Size(max=255)
    protected String dsc;
    @NotNull
    @Column(name="pulse_on_flag")
    protected Boolean isPulseOn;

    public Double getEngZeroScale() {
        Variable a;
        return a.engZeroScale;
    }

    public c_ok getValueExpressionType() {
        Variable a;
        return a.valueExpressionType;
    }

    public String getLogExpressionId() {
        Variable a;
        return a.logExpressionId;
    }

    public Double getLogMinValue() {
        Variable a;
        return a.logMinValue;
    }

    public void setName(String string) {
        Object a = string;
        Variable a2 = this;
        a2.name = a;
    }

    public void setFractionalDigitCount(Short s) {
        Object a = s;
        Variable a2 = this;
        a2.fractionalDigitCount = a;
    }

    public String getValueExpressionId() {
        Variable a;
        return a.valueExpressionId;
    }

    public void setSetMaxValue(Double d) {
        Object a = d;
        Variable a2 = this;
        a2.setMaxValue = a;
    }

    public void setCode(String string) {
        Object a = string;
        Variable a2 = this;
        a2.code = a;
    }

    public void setValueExpressionType(c_ok c_ok2) {
        Variable a = c_ok2;
        Variable a2 = this;
        a2.valueExpressionType = a;
    }

    public void setPulseOffDuration(Integer n) {
        Object a = n;
        Variable a2 = this;
        a2.pulseOffDuration = a;
    }

    public String getLogExpressionCode() {
        Variable a;
        return a.logExpressionCode;
    }

    public void setValue(VariableValue<?> variableValue) {
        VariableValue<?> a = variableValue;
        VariableValue<?> a2 = this;
        a2.value = a;
    }

    public Boolean getIsWritable() {
        Variable a;
        return a.isWritable;
    }

    public void setLogExpression(Expression expression) {
        Variable a;
        Variable a2 = expression;
        Variable variable = a = this;
        variable.logExpression = a2;
        variable.logExpressionId = a2 != null && a2.getId() != null ? a2.getId() : null;
    }

    @JsonIgnore
    public TConnection getConnection() {
        Variable a;
        if (a.getDevice() == null) {
            return null;
        }
        return (TConnection)a.getDevice().getConnection();
    }

    public void setSetMinValue(Double d) {
        Object a = d;
        Variable a2 = this;
        a2.setMinValue = a;
    }

    public String getValueExpressionCode() {
        Variable a;
        return a.valueExpressionCode;
    }

    public Expression getValueExpression() {
        Variable a;
        return a.valueExpression;
    }

    public boolean equals(Object object) {
        Variable a = this;
        Object a2 = object;
        if (a == a2) {
            return --1 != 0;
        }
        if (!(a2 instanceof Variable)) {
            return false;
        }
        Object object2 = a2;
        if (!super.equals(a2)) {
            return 5 >> 3;
        }
        if (a.getProjectId().equals(object2.getProjectId()) && a.getName().equals(object2.getName())) {
            return (3 & 5) != 0;
        }
        return false;
    }

    public void setProject(Project project) {
        Variable a;
        Variable a2 = project;
        Variable variable = a = this;
        variable.project = a2;
        variable.projectId = a2 != null && a2.getId() != null ? a2.getId() : null;
    }

    public String getCode() {
        Variable a;
        return a.code;
    }

    public void setValueExpressionId(String string) {
        Object a = string;
        Variable a2 = this;
        a2.valueExpressionId = a;
    }

    public void setKeepLastValues(Boolean bl) {
        Object a = bl;
        Variable a2 = this;
        a2.keepLastValues = a;
    }

    public Expression getLogExpression() {
        Variable a;
        return a.logExpression;
    }

    public void setLogExpressionId(String string) {
        Object a = string;
        Variable a2 = this;
        a2.logExpressionId = a;
    }

    public c_ak getLogType() {
        Variable a;
        return a.logType;
    }

    public String getConnectionId() {
        Variable a;
        if (a.getDevice() == null) {
            return null;
        }
        return a.getDevice().getConnectionId();
    }

    public Short getFractionalDigitCount() {
        Variable a;
        return a.fractionalDigitCount;
    }

    public void setLogType(c_ak c_ak2) {
        Variable a = c_ak2;
        Variable a2 = this;
        a2.logType = a;
    }

    public void setValueExpression(Expression expression) {
        Variable a;
        Variable a2 = expression;
        Variable variable = a = this;
        variable.valueExpression = a2;
        variable.valueExpressionId = a2 != null && a2.getId() != null ? a2.getId() : null;
    }

    public void setRawFullScale(Double d) {
        Object a = d;
        Variable a2 = this;
        a2.rawFullScale = a;
    }

    public Boolean getIsPulseOff() {
        Variable a;
        return a.isPulseOff;
    }

    public Integer getLogPeriod() {
        Variable a;
        return a.logPeriod;
    }

    public void setDsc(String string) {
        Object a = string;
        Variable a2 = this;
        a2.dsc = a;
    }

    public void setProjectId(String string) {
        Object a = string;
        Variable a2 = this;
        a2.projectId = a;
    }

    public void setIsWritable(Boolean bl) {
        Object a = bl;
        Variable a2 = this;
        a2.isWritable = a;
    }

    public Boolean getIsPulseOn() {
        Variable a;
        return a.isPulseOn;
    }

    public void setLogMinValue(Double d) {
        Object a = d;
        Variable a2 = this;
        a2.logMinValue = a;
    }

    public void setValueExpressionCode(String string) {
        Object a = string;
        Variable a2 = this;
        a2.valueExpressionCode = a;
    }

    public Double getRawFullScale() {
        Variable a;
        return a.rawFullScale;
    }

    public Double getRawZeroScale() {
        Variable a;
        return a.rawZeroScale;
    }

    public void setIsPulseOn(Boolean bl) {
        Object a = bl;
        Variable a2 = this;
        a2.isPulseOn = a;
    }

    public void setLogThreshold(Double d) {
        Object a = d;
        Variable a2 = this;
        a2.logThreshold = a;
    }

    public Double getEngFullScale() {
        Variable a;
        return a.engFullScale;
    }

    public Double getSetMinValue() {
        Variable a;
        return a.setMinValue;
    }

    public int hashCode() {
        Variable a;
        Object[] objectArray = new Object[--3];
        objectArray[2 & 5] = super.hashCode();
        objectArray[3 >> 1] = a.getProjectId();
        objectArray[1 ^ 3] = a.getName();
        return Objects.hash(objectArray);
    }

    public void setIsActive(Boolean bl) {
        Object a = bl;
        Variable a2 = this;
        a2.isActive = a;
    }

    public void setPulseOnDuration(Integer n) {
        Object a = n;
        Variable a2 = this;
        a2.pulseOnDuration = a;
    }

    public Boolean getIsActive() {
        Variable a;
        return a.isActive;
    }

    public Integer getPulseOffDuration() {
        Variable a;
        return a.pulseOffDuration;
    }

    public String getFrameId() {
        Variable a;
        return a.frameId;
    }

    public String getDsc() {
        Variable a;
        return a.dsc;
    }

    public Double getLogThreshold() {
        Variable a;
        return a.logThreshold;
    }

    public String getDeviceId() {
        Variable a;
        if (a.getFrame() == null) {
            return null;
        }
        return a.getFrame().getDeviceId();
    }

    public void setEngFullScale(Double d) {
        Object a = d;
        Variable a2 = this;
        a2.engFullScale = a;
    }

    public String getProjectId() {
        Variable a;
        return a.projectId;
    }

    public Double getLogMaxValue() {
        Variable a;
        return a.logMaxValue;
    }

    public void setLogMaxValue(Double d) {
        Object a = d;
        Variable a2 = this;
        a2.logMaxValue = a;
    }

    public void setLogExpressionCode(String string) {
        Object a = string;
        Variable a2 = this;
        a2.logExpressionCode = a;
    }

    public VariableValue<?> getValue() {
        Variable a;
        return a.value;
    }

    public Integer getPulseOnDuration() {
        Variable a;
        return a.pulseOnDuration;
    }

    public Variable() {
        Variable a;
    }

    public Double getSetMaxValue() {
        Variable a;
        return a.setMaxValue;
    }

    public Project getProject() {
        Variable a;
        return a.project;
    }

    public void setLogPeriod(Integer n) {
        Object a = n;
        Variable a2 = this;
        a2.logPeriod = a;
    }

    public void setIsPulseOff(Boolean bl) {
        Object a = bl;
        Variable a2 = this;
        a2.isPulseOff = a;
    }

    public void setRawZeroScale(Double d) {
        Object a = d;
        Variable a2 = this;
        a2.rawZeroScale = a;
    }

    public Boolean getKeepLastValues() {
        Variable a;
        return a.keepLastValues;
    }

    public String getUnit() {
        Variable a;
        return a.unit;
    }

    @JsonIgnore
    public TDevice getDevice() {
        Variable a;
        if (a.getFrame() == null) {
            return null;
        }
        return (TDevice)a.getFrame().getDevice();
    }

    public String getName() {
        Variable a;
        return a.name;
    }

    public void setUnit(String string) {
        Object a = string;
        Variable a2 = this;
        a2.unit = a;
    }

    public void setEngZeroScale(Double d) {
        Object a = d;
        Variable a2 = this;
        a2.engZeroScale = a;
    }

    public void setFrameId(String string) {
        Object a = string;
        Variable a2 = this;
        a2.frameId = a;
    }
}

