/*
 * Decompiled with CFR 0.152.
 */
package com.inscada.mono.user.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.inscada.mono.menu.model.Menu;
import com.inscada.mono.shared.model.SpaceBaseModel;
import com.inscada.mono.user.model.Permission;
import com.inscada.mono.user.model.User;
import jakarta.persistence.AttributeOverride;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.JoinTable;
import jakarta.persistence.ManyToMany;
import jakarta.persistence.Table;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.hibernate.annotations.SQLRestriction;

@Entity
@Table(name="roles")
@AttributeOverride(name="id", column=@Column(name="role_id", length=36, nullable=false, updatable=false))
public class Role
extends SpaceBaseModel {
    @JsonIgnore
    @ManyToMany
    @JoinTable(name="role_permissions", joinColumns={@JoinColumn(name="role_id")}, inverseJoinColumns={@JoinColumn(name="permission_id")})
    @SQLRestriction(value="deleted_dttm IS NULL")
    private Set<Permission> permissions;
    @JsonIgnore
    @ManyToMany
    @JoinTable(name="role_menus", joinColumns={@JoinColumn(name="role_id")}, inverseJoinColumns={@JoinColumn(name="menu_id")})
    @SQLRestriction(value="deleted_dttm IS NULL")
    private Set<Menu> menus;
    @JsonIgnore
    @ManyToMany(mappedBy="roles")
    @SQLRestriction(value="deleted_dttm IS NULL")
    private Set<User> users;
    private String name;

    @JsonIgnore
    public boolean isGlobal() {
        Role a;
        return a.permissions.stream().anyMatch(Permission::isGlobal) || a.menus.stream().anyMatch(Menu::isGlobal);
    }

    private static /* synthetic */ boolean lambda$removePermission$0(String string, Permission permission) {
        String a = permission;
        String a2 = string;
        return a.getId().equals(a2);
    }

    public boolean equals(Object object) {
        Role a = this;
        Object a2 = object;
        if (a == a2) {
            return 5 >> 2;
        }
        if (!(a2 instanceof Role)) {
            return false;
        }
        Object object2 = a2;
        if (!super.equals(a2)) {
            return 5 >> 3;
        }
        return Objects.equals(a.getName(), object2.getName());
    }

    public Role() {
        Role a;
        Role role = a;
        a.permissions = new HashSet();
        role.menus = new HashSet();
        a.users = new HashSet();
    }

    public void setMenus(Set<Menu> set) {
        Object a = set;
        Role a2 = this;
        a2.menus = a;
    }

    public void addPermission(Permission permission) {
        Role a = permission;
        Role a2 = this;
        a2.permissions.add(a);
        a.getRoles().add(a2);
    }

    public void setPermissions(Set<Permission> set) {
        Object a = set;
        Role a2 = this;
        a2.permissions = a;
    }

    public Set<User> getUsers() {
        Role a;
        return a.users;
    }

    public void removeMenu(String string) {
        Object a = string;
        Role a2 = this;
        a = a2.menus.stream().filter(arg_0 -> Role.lambda$removeMenu$1((String)a, arg_0)).findFirst();
        if (((Optional)a).isPresent()) {
            Object object = a;
            a2.menus.remove(((Optional)object).get());
            ((Menu)((Optional)object).get()).getRoles().remove(a2);
        }
    }

    public void setUsers(Set<User> set) {
        Object a = set;
        Role a2 = this;
        a2.users = a;
    }

    public String getName() {
        Role a;
        return a.name;
    }

    public void remove() {
        Permission permission;
        Role role = this;
        Object a = new HashSet(role.permissions).iterator();
        Iterator iterator = a;
        while (iterator.hasNext()) {
            permission = (Permission)a.next();
            iterator = a;
            role.permissions.remove(permission);
            permission.getRoles().remove(role);
        }
        a = new HashSet(role.menus).iterator();
        Iterator iterator2 = a;
        while (iterator2.hasNext()) {
            permission = (Menu)a.next();
            iterator2 = a;
            role.menus.remove(permission);
            permission.getRoles().remove(role);
        }
        a = new HashSet(role.users).iterator();
        Iterator iterator3 = a;
        while (iterator3.hasNext()) {
            permission = (User)a.next();
            iterator3 = a;
            permission.getRoles().remove(role);
        }
        role.users.clear();
    }

    public void removePermission(String string) {
        Object a = string;
        Role a2 = this;
        a = a2.permissions.stream().filter(arg_0 -> Role.lambda$removePermission$0((String)a, arg_0)).findFirst();
        if (((Optional)a).isPresent()) {
            Object object = a;
            a2.permissions.remove(((Optional)object).get());
            ((Permission)((Optional)object).get()).getRoles().remove(a2);
        }
    }

    @JsonIgnore
    public boolean isSpaceScoped() {
        Role a;
        if (!a.isGlobal()) {
            return 5 >> 2;
        }
        return false;
    }

    public Set<Menu> getMenus() {
        Role a;
        return a.menus;
    }

    public int hashCode() {
        Role a;
        Object[] objectArray = new Object[1 ^ 3];
        objectArray[3 >> 2] = super.hashCode();
        objectArray[3 >> 1] = a.getName();
        return Objects.hash(objectArray);
    }

    public Set<Permission> getPermissions() {
        Role a;
        return a.permissions;
    }

    public void setName(String string) {
        Object a = string;
        Role a2 = this;
        a2.name = a;
    }

    private static /* synthetic */ boolean lambda$removeMenu$1(String string, Menu menu) {
        String a = menu;
        String a2 = string;
        return a.getId().equals(a2);
    }

    public void addMenu(Menu menu) {
        Role a = menu;
        Role a2 = this;
        a2.menus.add(a);
        a.getRoles().add(a2);
    }
}

