/*
 * Decompiled with CFR 0.152.
 */
package com.inscada.mono.shared.exceptions;

import com.inscada.mono.auth.exceptions.AuthTokenException;
import com.inscada.mono.auth.exceptions.RunAsExecutionException;
import com.inscada.mono.broadcast.exceptions.BroadcastOperationException;
import com.inscada.mono.cluster.replication.ReplicationReceiver;
import com.inscada.mono.communication.base.exceptions.BrowseOperationException;
import com.inscada.mono.communication.base.exceptions.CommunicationException;
import com.inscada.mono.communication.base.exceptions.SetValueException;
import com.inscada.mono.communication.base.restcontrollers.ConnectionController;
import com.inscada.mono.impexp.exceptions.ImportExportException;
import com.inscada.mono.report.exceptions.ReportGenerationException;
import com.inscada.mono.report.exceptions.ReportSchedulingException;
import com.inscada.mono.script.exceptions.ScriptException;
import com.inscada.mono.settings.exceptions.SettingsException;
import com.inscada.mono.shared.exceptions.AlreadyExistsException;
import com.inscada.mono.shared.exceptions.FileStorageException;
import com.inscada.mono.shared.exceptions.InscadaException;
import com.inscada.mono.shared.exceptions.MismatchException;
import com.inscada.mono.shared.exceptions.NotActiveException;
import com.inscada.mono.shared.exceptions.NotFoundException;
import com.inscada.mono.shared.exceptions.ParsingException;
import com.inscada.mono.shared.exceptions.RelationExistsException;
import com.inscada.mono.shared.exceptions.ValidationDefinitionException;
import com.inscada.mono.shared.exceptions.model.ExceptionDetails;
import com.inscada.mono.sms.exceptions.SmsProviderException;
import com.inscada.mono.space.exceptions.SpaceOperationException;
import jakarta.persistence.EntityNotFoundException;
import jakarta.persistence.OptimisticLockException;
import jakarta.validation.ConstraintViolation;
import jakarta.validation.ConstraintViolationException;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.hibernate.StaleObjectStateException;
import org.influxdb.InfluxDBMapperException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.env.Environment;
import org.springframework.dao.DataIntegrityViolationException;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.http.converter.HttpMessageNotReadableException;
import org.springframework.lang.NonNull;
import org.springframework.security.access.AccessDeniedException;
import org.springframework.security.authentication.BadCredentialsException;
import org.springframework.transaction.TransactionSystemException;
import org.springframework.validation.FieldError;
import org.springframework.web.bind.MethodArgumentNotValidException;
import org.springframework.web.bind.MissingServletRequestParameterException;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.RestControllerAdvice;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;
import org.springframework.web.context.request.WebRequest;
import org.springframework.web.method.annotation.MethodArgumentTypeMismatchException;
import org.springframework.web.servlet.mvc.method.annotation.ResponseEntityExceptionHandler;

@RestControllerAdvice(basePackages={"com.inscada.mono"})
public class GeneralExceptionHandler
extends ResponseEntityExceptionHandler {
    private static final String VALIDATION_DEFINITION_ERROR = "Validation Definition Error";
    private static final String INSCADA_ERROR = "Inscada Error";
    private static final String UNKNOWN_ERROR = "Unknown Error";
    private static final String SCRIPT_ERROR = "Script Execution Error";
    private static final String REPORT_SCHEDULING_ERROR = "Report Scheduling Error";
    private static final String BROWSE_OPERATION_ERROR = "Browse Operation Error";
    private static final String NOT_ACTIVE_ERROR = "Not Active Error";
    private static final String OPTIMISTIC_LOCK_ERROR = "Optimistic Lock Error";
    private static final String NOT_FOUND_ERROR = "Not Found Error";
    private static final String RELATION_EXISTS_ERROR = "Relation Exists Error";
    private static final String PARSING_ERROR = "Parsing Error";
    private static final String BROADCAST_OPERATION_ERROR = "Broadcast Operation Error";
    private static final Logger log = LoggerFactory.getLogger(GeneralExceptionHandler.class);
    private static final String AUTH_TOKEN_ERROR = "Auth Token Error";
    private static final String VALIDATION_ERROR = "Validation Error";
    private static final String DATABASE_ERROR = "Database Error";
    private static final String SPACE_OPERATION_ERROR = "Space Operation Error";
    private static final String SECURITY_ERROR = "Security Error";
    private static final String REPORT_GENERATION_ERROR = "Report Generation Error";
    private static final String RUN_AS_ERROR = "Run-As Execution Error";
    private final Environment environment;
    private static final String SMS_PROVIDER_ERROR = "SMS Provider Error";
    private static final String IMPORT_EXPORT_ERROR = "Import/Export Error";
    private static final String SET_VALUE_ERROR = "Set Value Error";
    private static final String ALREADY_EXISTS_ERROR = "Already Exists Error";
    private static final String SETTINGS_ERROR = "Settings Error";
    private static final String COMMUNICATION_ERROR = "Communication Error";
    private static final String CONSTRAINT_VIOLATION = "Constraint Violation";
    private static final String MISMATCH_ERROR = "Mismatch Error";
    private static final String FILE_STORAGE_ERROR = "File Storage Error";

    @ExceptionHandler(value={Exception.class})
    protected ResponseEntity<Object> handleAllExceptions(Exception exception) {
        Exception a = exception;
        GeneralExceptionHandler a2 = this;
        Exception exception2 = a;
        return a2.buildErrorResponse(exception2, exception2.getMessage(), (HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR, UNKNOWN_ERROR);
    }

    @ExceptionHandler(value={AccessDeniedException.class, BadCredentialsException.class})
    protected ResponseEntity<Object> handleSecurityExceptions(Exception exception) {
        Exception a = exception;
        GeneralExceptionHandler a2 = this;
        Exception exception2 = a;
        return a2.buildErrorResponse(exception2, exception2.getMessage(), (HttpStatusCode)HttpStatus.FORBIDDEN, SECURITY_ERROR);
    }

    @ExceptionHandler(value={RelationExistsException.class})
    protected ResponseEntity<Object> handleRelationExists(RelationExistsException relationExistsException) {
        GeneralExceptionHandler a = relationExistsException;
        GeneralExceptionHandler a2 = this;
        GeneralExceptionHandler generalExceptionHandler = a;
        return a2.buildErrorResponse((Exception)generalExceptionHandler, generalExceptionHandler.getMessage(), (HttpStatusCode)HttpStatus.CONFLICT, RELATION_EXISTS_ERROR);
    }

    @ExceptionHandler(value={ReportSchedulingException.class})
    protected ResponseEntity<Object> handleReportSchedulingException(ReportSchedulingException reportSchedulingException) {
        GeneralExceptionHandler a = reportSchedulingException;
        GeneralExceptionHandler a2 = this;
        GeneralExceptionHandler generalExceptionHandler = a;
        return a2.buildErrorResponse((Exception)generalExceptionHandler, generalExceptionHandler.getMessage(), (HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR, REPORT_SCHEDULING_ERROR);
    }

    @ExceptionHandler(value={ParsingException.class})
    protected ResponseEntity<Object> handleParsingException(ParsingException parsingException) {
        GeneralExceptionHandler a = parsingException;
        GeneralExceptionHandler a2 = this;
        GeneralExceptionHandler generalExceptionHandler = a;
        return a2.buildErrorResponse((Exception)generalExceptionHandler, generalExceptionHandler.getMessage(), (HttpStatusCode)HttpStatus.BAD_REQUEST, PARSING_ERROR);
    }

    /*
     * WARNING - void declaration
     */
    protected ResponseEntity<Object> handleHttpMessageNotReadable(HttpMessageNotReadableException httpMessageNotReadableException, @NonNull HttpHeaders httpHeaders, @NonNull HttpStatusCode httpStatusCode, @NonNull WebRequest webRequest) {
        void ex;
        GeneralExceptionHandler generalExceptionHandler = generalExceptionHandler2;
        GeneralExceptionHandler generalExceptionHandler2 = httpHeaders;
        GeneralExceptionHandler headers = generalExceptionHandler;
        generalExceptionHandler2 = headers.createExceptionDetails((HttpStatusCode)HttpStatus.BAD_REQUEST, "Malformed JSON request: " + ex.getMessage(), (Exception)ex, VALIDATION_ERROR);
        log.error(ReplicationReceiver.m_Eca((Object)"(\u0003\u0016\u0015\u0004\u0001\u0000F\u000b\t\u0011F\u0017\u0003\u0004\u0002\u0004\u0004\t\u0003_F\u001e\u001b"), (Object)generalExceptionHandler2, (Object)ex);
        return new ResponseEntity((Object)generalExceptionHandler2, (HttpStatusCode)HttpStatus.BAD_REQUEST);
    }

    @ExceptionHandler(value={OptimisticLockException.class, StaleObjectStateException.class})
    protected ResponseEntity<Object> handleOptimisticLock(Exception exception) {
        Object a = exception;
        GeneralExceptionHandler a2 = this;
        return a2.buildErrorResponse((Exception)a, ReplicationReceiver.m_Eca((Object)"1\u000e\f\u0015E\u0014\u0000\u0005\n\u0014\u0001F\u0012\u0007\u0016F\u0010\u0016\u0001\u0007\u0011\u0003\u0001F\u0007\u001fE\u0007\u000b\t\u0011\u000e\u0000\u0014E\u0013\u0016\u0003\u0017HE6\t\u0003\u0004\u0015\u0000F\u0017\u0003\u0003\u0014\u0000\u0015\rF\u001c\t\u0010\u0014E\u0002\u0004\u0012\u0004F\u0004\b\u0001F\u0011\u0014\u001cF\u0004\u0001\u0004\u000f\u000bH"), (HttpStatusCode)HttpStatus.CONFLICT, OPTIMISTIC_LOCK_ERROR);
    }

    @ExceptionHandler(value={IllegalArgumentException.class})
    protected ResponseEntity<Object> handleIllegalArgument(IllegalArgumentException illegalArgumentException) {
        IllegalArgumentException a = illegalArgumentException;
        GeneralExceptionHandler a2 = this;
        IllegalArgumentException illegalArgumentException2 = a;
        return a2.buildErrorResponse((Exception)illegalArgumentException2, illegalArgumentException2.getMessage(), (HttpStatusCode)HttpStatus.BAD_REQUEST, VALIDATION_ERROR);
    }

    @ExceptionHandler(value={FileStorageException.class})
    protected ResponseEntity<Object> handleFileStorage(FileStorageException fileStorageException) {
        GeneralExceptionHandler a = fileStorageException;
        GeneralExceptionHandler a2 = this;
        GeneralExceptionHandler generalExceptionHandler = a;
        return a2.buildErrorResponse((Exception)generalExceptionHandler, generalExceptionHandler.getMessage(), (HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR, FILE_STORAGE_ERROR);
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ ResponseEntity<Object> buildErrorResponse(Exception exception, String string, HttpStatusCode httpStatusCode, String string2) {
        void a;
        void a2;
        void a3;
        Object a4 = string;
        GeneralExceptionHandler a5 = this;
        a4 = a5.createExceptionDetails((HttpStatusCode)a3, (String)a4, (Exception)a2, (String)a, null);
        log.error(ReplicationReceiver.m_Eca((Object)",\b\u0011\u0003\u0017\b\u0004\nE\u0003\u0017\u0014\n\u0014_F\u001e\u001b"), a4, (Object)a2);
        return new ResponseEntity(a4, (HttpStatusCode)a3);
    }

    @ExceptionHandler(value={SetValueException.class})
    protected ResponseEntity<Object> handleSetValueException(SetValueException setValueException) {
        GeneralExceptionHandler a = setValueException;
        GeneralExceptionHandler a2 = this;
        GeneralExceptionHandler generalExceptionHandler = a;
        return a2.buildErrorResponse((Exception)generalExceptionHandler, generalExceptionHandler.getMessage(), (HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR, SET_VALUE_ERROR);
    }

    private /* synthetic */ String formatErrorMessages(Map<String, List<String>> map) {
        Map<String, List<String>> a2 = map;
        GeneralExceptionHandler a3 = this;
        return a2.entrySet().stream().map(a -> (String)a.getKey() + ": " + String.join((CharSequence)ReplicationReceiver.m_Eca((Object)"IF"), (Iterable)a.getValue())).collect(Collectors.joining(ReplicationReceiver.m_Eca((Object)"F\u0019F")));
    }

    @ExceptionHandler(value={InfluxDBMapperException.class})
    protected ResponseEntity<Object> handleInfluxDBMapper(InfluxDBMapperException influxDBMapperException) {
        GeneralExceptionHandler a = influxDBMapperException;
        GeneralExceptionHandler a2 = this;
        GeneralExceptionHandler generalExceptionHandler = a;
        return a2.buildErrorResponse((Exception)generalExceptionHandler, generalExceptionHandler.getMessage(), (HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR, DATABASE_ERROR);
    }

    protected ResponseEntity<Object> handleMissingServletRequestParameter(MissingServletRequestParameterException missingServletRequestParameterException, @NonNull HttpHeaders httpHeaders, @NonNull HttpStatusCode httpStatusCode, @NonNull WebRequest webRequest) {
        GeneralExceptionHandler generalExceptionHandler = generalExceptionHandler2;
        GeneralExceptionHandler generalExceptionHandler2 = missingServletRequestParameterException;
        GeneralExceptionHandler ex = generalExceptionHandler;
        Object[] objectArray = new Object[--2];
        objectArray[3 >> 2] = generalExceptionHandler2.getParameterName();
        objectArray[--1] = generalExceptionHandler2.getParameterType();
        ExceptionDetails headers = ex.createExceptionDetails((HttpStatusCode)HttpStatus.BAD_REQUEST, ReplicationReceiver.m_Eca((Object)"4\u0000\u0017\u0010\u000f\u0017\u0003\u0001F\u0015\u0007\u0017\u0007\b\u0003\u0011\u0003\u0017FBC\u0016AE\t\u0003F\u0011\u001f\u0015\u0003EA@\u0015BF\f\u0015E\u000b\f\u0015\u0016\u000f\u000b\u0001").formatted(objectArray), (Exception)generalExceptionHandler2, VALIDATION_ERROR);
        log.error(ConnectionController.m_pS((Object)"VPhJrW|\u0019kXiXv\\o\\i\u0003;Bf"), (Object)headers, (Object)generalExceptionHandler2);
        return new ResponseEntity((Object)headers, (HttpStatusCode)HttpStatus.BAD_REQUEST);
    }

    @ExceptionHandler(value={SettingsException.class})
    protected ResponseEntity<Object> handleSettingsException(SettingsException settingsException) {
        GeneralExceptionHandler a = settingsException;
        GeneralExceptionHandler a2 = this;
        GeneralExceptionHandler generalExceptionHandler = a;
        return a2.buildErrorResponse((Exception)generalExceptionHandler, generalExceptionHandler.getMessage(), (HttpStatusCode)HttpStatus.BAD_REQUEST, SETTINGS_ERROR);
    }

    public GeneralExceptionHandler(Environment environment) {
        GeneralExceptionHandler a = environment;
        GeneralExceptionHandler a2 = this;
        a2.environment = a;
    }

    @ExceptionHandler(value={NotFoundException.class, EntityNotFoundException.class})
    protected ResponseEntity<Object> handleEntityNotFound(Exception exception) {
        Exception a = exception;
        GeneralExceptionHandler a2 = this;
        Exception exception2 = a;
        return a2.buildErrorResponse(exception2, exception2.getMessage(), (HttpStatusCode)HttpStatus.NOT_FOUND, NOT_FOUND_ERROR);
    }

    @ExceptionHandler(value={AlreadyExistsException.class})
    protected ResponseEntity<Object> handleAlreadyExists(AlreadyExistsException alreadyExistsException) {
        GeneralExceptionHandler a = alreadyExistsException;
        GeneralExceptionHandler a2 = this;
        GeneralExceptionHandler generalExceptionHandler = a;
        return a2.buildErrorResponse((Exception)generalExceptionHandler, generalExceptionHandler.getMessage(), (HttpStatusCode)HttpStatus.CONFLICT, ALREADY_EXISTS_ERROR);
    }

    @ExceptionHandler(value={SmsProviderException.class})
    protected ResponseEntity<Object> handleSmsProviderException(SmsProviderException smsProviderException) {
        GeneralExceptionHandler a = smsProviderException;
        GeneralExceptionHandler a2 = this;
        GeneralExceptionHandler generalExceptionHandler = a;
        return a2.buildErrorResponse((Exception)generalExceptionHandler, generalExceptionHandler.getMessage(), (HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR, SMS_PROVIDER_ERROR);
    }

    private /* synthetic */ boolean isDevelopment() {
        String[] stringArray = this;
        String[] a = stringArray.environment.getActiveProfiles();
        if (a.length == 0) {
            return 5 >> 3;
        }
        return Arrays.asList(a).contains(ConnectionController.m_pS((Object)"\u007f\\m"));
    }

    @ExceptionHandler(value={ReportGenerationException.class})
    protected ResponseEntity<Object> handleReportGenerationException(ReportGenerationException reportGenerationException) {
        GeneralExceptionHandler a = reportGenerationException;
        GeneralExceptionHandler a2 = this;
        GeneralExceptionHandler generalExceptionHandler = a;
        return a2.buildErrorResponse((Exception)generalExceptionHandler, generalExceptionHandler.getMessage(), (HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR, REPORT_GENERATION_ERROR);
    }

    @ExceptionHandler(value={BroadcastOperationException.class})
    protected ResponseEntity<Object> handleBroadcastOperationException(BroadcastOperationException broadcastOperationException) {
        GeneralExceptionHandler a = broadcastOperationException;
        GeneralExceptionHandler a2 = this;
        GeneralExceptionHandler generalExceptionHandler = a;
        return a2.buildErrorResponse((Exception)generalExceptionHandler, generalExceptionHandler.getMessage(), (HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR, BROADCAST_OPERATION_ERROR);
    }

    @ExceptionHandler(value={ValidationDefinitionException.class})
    protected ResponseEntity<Object> handleValidationDefinitionException(ValidationDefinitionException validationDefinitionException) {
        GeneralExceptionHandler a = validationDefinitionException;
        GeneralExceptionHandler a2 = this;
        GeneralExceptionHandler generalExceptionHandler = a;
        return a2.buildErrorResponse((Exception)generalExceptionHandler, generalExceptionHandler.getMessage(), (HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR, VALIDATION_DEFINITION_ERROR);
    }

    @ExceptionHandler(value={ConstraintViolationException.class})
    protected ResponseEntity<Object> handleConstraintViolation(ConstraintViolationException constraintViolationException) {
        GeneralExceptionHandler a2 = constraintViolationException;
        GeneralExceptionHandler a3 = this;
        Map map = a2.getConstraintViolations().stream().collect(Collectors.groupingBy(a -> a.getPropertyPath().toString(), Collectors.mapping(ConstraintViolation::getMessage, Collectors.toList())));
        GeneralExceptionHandler generalExceptionHandler = a3;
        a2 = generalExceptionHandler.createExceptionDetails((HttpStatusCode)HttpStatus.CONFLICT, generalExceptionHandler.formatErrorMessages(map), (Exception)a2, CONSTRAINT_VIOLATION, map);
        log.error(ConnectionController.m_pS((Object)"ztWhMiXrWo\u0019mPtUzMrVu\u0003;Bf"), (Object)a2);
        return new ResponseEntity((Object)a2, (HttpStatusCode)HttpStatus.CONFLICT);
    }

    @ExceptionHandler(value={RunAsExecutionException.class})
    protected ResponseEntity<Object> handleRunAsExecution(RunAsExecutionException runAsExecutionException) {
        GeneralExceptionHandler a = runAsExecutionException;
        GeneralExceptionHandler a2 = this;
        GeneralExceptionHandler generalExceptionHandler = a;
        return a2.buildErrorResponse((Exception)generalExceptionHandler, generalExceptionHandler.getMessage(), (HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR, RUN_AS_ERROR);
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ ExceptionDetails createExceptionDetails(HttpStatusCode httpStatusCode, String string, Exception exception, String string2, Map<String, List<String>> map) {
        void a;
        void a2;
        Object a3;
        void a4;
        String a5;
        GeneralExceptionHandler a6;
        GeneralExceptionHandler generalExceptionHandler = object;
        Object object = string2;
        GeneralExceptionHandler generalExceptionHandler2 = a6 = generalExceptionHandler;
        a5 = generalExceptionHandler2.sanitizeMessage(a5, (Exception)a4);
        String string3 = generalExceptionHandler2.isDevelopment() ? a4.getClass().getName() : ConnectionController.m_pS((Object)"^Ax\\kMrVu");
        Object object2 = a6.isDevelopment() ? a3 : ReplicationReceiver.m_Eca((Object)"#\u0017\u0014\n\u0014");
        return new ExceptionDetails(a2.value(), a5, string3, (String)object2, (Map)a, (String)(a3 = a6.isDevelopment() ? ExceptionUtils.getStackTrace((Throwable)a4) : null), new Date(), a6.getCurrentPath());
    }

    @ExceptionHandler(value={AuthTokenException.class})
    protected ResponseEntity<Object> handleAuthTokenException(AuthTokenException authTokenException) {
        GeneralExceptionHandler a = authTokenException;
        GeneralExceptionHandler a2 = this;
        GeneralExceptionHandler generalExceptionHandler = a;
        return a2.buildErrorResponse((Exception)generalExceptionHandler, generalExceptionHandler.getMessage(), (HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR, AUTH_TOKEN_ERROR);
    }

    @ExceptionHandler(value={ImportExportException.class})
    protected ResponseEntity<Object> handleImportExportException(ImportExportException importExportException) {
        GeneralExceptionHandler a = importExportException;
        GeneralExceptionHandler a2 = this;
        GeneralExceptionHandler generalExceptionHandler = a;
        return a2.buildErrorResponse((Exception)generalExceptionHandler, generalExceptionHandler.getMessage(), (HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR, IMPORT_EXPORT_ERROR);
    }

    @ExceptionHandler(value={MethodArgumentTypeMismatchException.class})
    protected ResponseEntity<Object> handleMethodArgumentTypeMismatch(MethodArgumentTypeMismatchException methodArgumentTypeMismatchException) {
        GeneralExceptionHandler a = methodArgumentTypeMismatchException;
        GeneralExceptionHandler a2 = this;
        Object[] objectArray = new Object[--3];
        objectArray[5 >> 3] = a.getName();
        objectArray[5 >> 2] = a.getValue();
        objectArray[1 ^ 3] = a.getRequiredType() != null ? a.getRequiredType().getSimpleName() : ConnectionController.m_pS((Object)"nWpWtNu");
        String string = ReplicationReceiver.m_Eca((Object)"5\u0007\u0017\u0007\b\u0003\u0011\u0003\u0017FBC\u0016AE\u0011\f\u0012\rF\u0013\u0007\t\u0013\u0000FBC\u0016AE\u0005\n\u0013\t\u0002E\b\n\u0012E\u0004\u0000F\u0006\t\u000b\u0010\u0000\u0014\u0011\u0003\u0001F\u0011\tE\u0012\u001c\u0016\u0000FBC\u0016A").formatted(objectArray);
        return a2.buildErrorResponse((Exception)a, string, (HttpStatusCode)HttpStatus.BAD_REQUEST, VALIDATION_ERROR);
    }

    private /* synthetic */ String getCurrentPath() {
        try {
            return ((ServletRequestAttributes)RequestContextHolder.currentRequestAttributes()).getRequest().getRequestURI();
        }
        catch (Exception exception) {
            return ConnectionController.m_pS((Object)"IzMs\u0016nWpWtNu");
        }
    }

    @ExceptionHandler(value={NotActiveException.class})
    protected ResponseEntity<Object> handleNotActive(NotActiveException notActiveException) {
        GeneralExceptionHandler a = notActiveException;
        GeneralExceptionHandler a2 = this;
        GeneralExceptionHandler generalExceptionHandler = a;
        return a2.buildErrorResponse((Exception)generalExceptionHandler, generalExceptionHandler.getMessage(), (HttpStatusCode)HttpStatus.BAD_REQUEST, NOT_ACTIVE_ERROR);
    }

    @ExceptionHandler(value={SpaceOperationException.class})
    protected ResponseEntity<Object> handleSpaceOperationException(SpaceOperationException spaceOperationException) {
        GeneralExceptionHandler a = spaceOperationException;
        GeneralExceptionHandler a2 = this;
        GeneralExceptionHandler generalExceptionHandler = a;
        return a2.buildErrorResponse((Exception)generalExceptionHandler, generalExceptionHandler.getMessage(), (HttpStatusCode)HttpStatus.BAD_REQUEST, SPACE_OPERATION_ERROR);
    }

    @ExceptionHandler(value={DataIntegrityViolationException.class})
    protected ResponseEntity<Object> handleDataIntegrityViolation(DataIntegrityViolationException dataIntegrityViolationException) {
        GeneralExceptionHandler a = dataIntegrityViolationException;
        GeneralExceptionHandler a2 = this;
        GeneralExceptionHandler generalExceptionHandler = a;
        return a2.buildErrorResponse((Exception)generalExceptionHandler, ExceptionUtils.getRootCauseMessage((Throwable)generalExceptionHandler), (HttpStatusCode)HttpStatus.CONFLICT, DATABASE_ERROR);
    }

    @ExceptionHandler(value={MismatchException.class})
    protected ResponseEntity<Object> handleMismatch(MismatchException mismatchException) {
        GeneralExceptionHandler a = mismatchException;
        GeneralExceptionHandler a2 = this;
        GeneralExceptionHandler generalExceptionHandler = a;
        return a2.buildErrorResponse((Exception)generalExceptionHandler, generalExceptionHandler.getMessage(), (HttpStatusCode)HttpStatus.BAD_REQUEST, MISMATCH_ERROR);
    }

    @ExceptionHandler(value={IllegalStateException.class})
    protected ResponseEntity<Object> handleIllegalState(IllegalStateException illegalStateException) {
        IllegalStateException a = illegalStateException;
        GeneralExceptionHandler a2 = this;
        IllegalStateException illegalStateException2 = a;
        return a2.buildErrorResponse((Exception)illegalStateException2, illegalStateException2.getMessage(), (HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR, INSCADA_ERROR);
    }

    @ExceptionHandler(value={ScriptException.class})
    protected ResponseEntity<Object> handleScriptException(ScriptException scriptException) {
        GeneralExceptionHandler a = scriptException;
        GeneralExceptionHandler a2 = this;
        GeneralExceptionHandler generalExceptionHandler = a;
        return a2.buildErrorResponse((Exception)generalExceptionHandler, generalExceptionHandler.getMessage(), (HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR, SCRIPT_ERROR);
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ ExceptionDetails createExceptionDetails(HttpStatusCode httpStatusCode, String string, Exception exception, String string2) {
        Object a;
        void a2;
        void a3;
        void a4;
        GeneralExceptionHandler generalExceptionHandler = object;
        Object object = string2;
        GeneralExceptionHandler a5 = generalExceptionHandler;
        return a5.createExceptionDetails((HttpStatusCode)a4, (String)a3, (Exception)a2, (String)a, null);
    }

    /*
     * WARNING - void declaration
     */
    @NonNull
    protected ResponseEntity<Object> handleMethodArgumentNotValid(MethodArgumentNotValidException methodArgumentNotValidException, @NonNull HttpHeaders httpHeaders, @NonNull HttpStatusCode httpStatusCode, @NonNull WebRequest webRequest) {
        void ex;
        GeneralExceptionHandler generalExceptionHandler = object;
        Object object = httpHeaders;
        GeneralExceptionHandler headers = generalExceptionHandler;
        object = new HashMap();
        Map status = ex.getBindingResult().getFieldErrors().stream().collect(Collectors.groupingBy(FieldError::getField, Collectors.mapping(objectError -> {
            GeneralExceptionHandler a = objectError;
            GeneralExceptionHandler a2 = this;
            if (a.getDefaultMessage() != null) {
                return a.getDefaultMessage();
            }
            return ConnectionController.m_pS((Object)"wt\u0019v\\hJz^~\u0019zOzPwXyU~");
        }, Collectors.toList())));
        List a = ex.getBindingResult().getGlobalErrors().stream().map(objectError -> {
            GeneralExceptionHandler a = objectError;
            GeneralExceptionHandler a2 = this;
            if (a.getDefaultMessage() != null) {
                return a.getDefaultMessage();
            }
            return ConnectionController.m_pS((Object)"wt\u0019v\\hJz^~\u0019zOzPwXyU~");
        }).collect(Collectors.toList());
        object.putAll(status);
        if (!a.isEmpty()) {
            object.put(ReplicationReceiver.m_Eca((Object)"\u0002\n\n\u0004\u0004\n"), a);
        }
        object = headers.createExceptionDetails((HttpStatusCode)HttpStatus.BAD_REQUEST, headers.formatErrorMessages((Map)object), (Exception)ex, VALIDATION_ERROR, (Map)object);
        log.error(ConnectionController.m_pS((Object)"ozUr]zMrVu\u0019~KiVi\u0003;Bf"), object, (Object)ex);
        return new ResponseEntity(object, (HttpStatusCode)HttpStatus.BAD_REQUEST);
    }

    @ExceptionHandler(value={InscadaException.class})
    protected ResponseEntity<Object> handleInscadaException(InscadaException inscadaException) {
        GeneralExceptionHandler a = inscadaException;
        GeneralExceptionHandler a2 = this;
        GeneralExceptionHandler generalExceptionHandler = a;
        return a2.buildErrorResponse((Exception)generalExceptionHandler, generalExceptionHandler.getMessage(), (HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR, INSCADA_ERROR);
    }

    /*
     * WARNING - void declaration
     */
    protected ResponseEntity<Object> handleExceptionInternal(Exception exception, Object object, @NonNull HttpHeaders httpHeaders, @NonNull HttpStatusCode httpStatusCode, @NonNull WebRequest webRequest) {
        void ex;
        void status;
        GeneralExceptionHandler generalExceptionHandler = object2;
        Object object2 = object;
        GeneralExceptionHandler body = generalExceptionHandler;
        object2 = body.createExceptionDetails((HttpStatusCode)status, ex.getMessage(), (Exception)ex, UNKNOWN_ERROR);
        log.error(ConnectionController.m_pS((Object)"puM~KuXw\u0019~KiVi\u0003;Bf"), object2, (Object)ex);
        return new ResponseEntity(object2, (HttpStatusCode)status);
    }

    /*
     * WARNING - void declaration
     */
    @ExceptionHandler(value={TransactionSystemException.class})
    protected ResponseEntity<Object> handleTransactionSystemException(TransactionSystemException transactionSystemException) {
        void a;
        GeneralExceptionHandler generalExceptionHandler = this;
        Object a2 = a.getRootCause();
        if (a2 instanceof ConstraintViolationException) {
            a2 = (ConstraintViolationException)a2;
            return generalExceptionHandler.handleConstraintViolation((ConstraintViolationException)a2);
        }
        void v0 = a;
        return generalExceptionHandler.buildErrorResponse((Exception)v0, ExceptionUtils.getRootCauseMessage((Throwable)v0), (HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR, DATABASE_ERROR);
    }

    @ExceptionHandler(value={BrowseOperationException.class})
    protected ResponseEntity<Object> handleBrowseOperationException(BrowseOperationException browseOperationException) {
        GeneralExceptionHandler a = browseOperationException;
        GeneralExceptionHandler a2 = this;
        GeneralExceptionHandler generalExceptionHandler = a;
        return a2.buildErrorResponse((Exception)generalExceptionHandler, generalExceptionHandler.getMessage(), (HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR, BROWSE_OPERATION_ERROR);
    }

    @ExceptionHandler(value={CommunicationException.class})
    protected ResponseEntity<Object> handleCommunicationException(CommunicationException communicationException) {
        GeneralExceptionHandler a = communicationException;
        GeneralExceptionHandler a2 = this;
        GeneralExceptionHandler generalExceptionHandler = a;
        return a2.buildErrorResponse((Exception)generalExceptionHandler, generalExceptionHandler.getMessage(), (HttpStatusCode)HttpStatus.BAD_REQUEST, COMMUNICATION_ERROR);
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ String sanitizeMessage(String string, Exception exception) {
        void a;
        Object a2 = exception;
        GeneralExceptionHandler a3 = this;
        if (a2 instanceof ScriptException) {
            return a;
        }
        if (a3.isDevelopment()) {
            return a;
        }
        if (a2 instanceof AlreadyExistsException) {
            return ReplicationReceiver.m_Eca((Object)"4\u0000\u0015\n\u0013\u0017\u0005\u0000F\u0004\n\u0017\u0003\u0004\u0002\u001cF\u0000\u001e\f\u0015\u0011\u0015");
        }
        if (a2 instanceof FileStorageException) {
            return ConnectionController.m_pS((Object)"]Pw\\;Vk\\iXoPtW;_zPw\\\u007f");
        }
        if (a2 instanceof MismatchException) {
            return ReplicationReceiver.m_Eca((Object)"4\u0000\u0015\n\u0013\u0017\u0005\u0000F\b\u000f\u0016\u000b\u0004\u0012\u0006\u000e");
        }
        if (a2 instanceof NotActiveException) {
            return ConnectionController.m_pS((Object)"k~JtLiZ~\u0019rJ;WtM;XxMrO~");
        }
        if (a2 instanceof NotFoundException) {
            return ReplicationReceiver.m_Eca((Object)"7\u0003\u0016\t\u0010\u0014\u0006\u0003E\b\n\u0012E\u0000\n\u0013\u000b\u0002");
        }
        if (a2 instanceof RelationExistsException) {
            return ConnectionController.m_pS((Object)"I\\wXo\\\u007f\u0019i\\hVnKx\\;\\cPhMh");
        }
        if (a2 instanceof OptimisticLockException || a2 instanceof StaleObjectStateException) {
            return ReplicationReceiver.m_Eca((Object)"7\u0003\u0016\t\u0010\u0014\u0006\u0003E\u0011\u0004\u0015E\u0013\u0015\u0002\u0004\u0012\u0000\u0002E\u0004\u001cF\u0004\b\n\u0012\r\u0003\u0017F\u0010\u0015\u0000\u0014");
        }
        if (a2 instanceof SmsProviderException) {
            return ConnectionController.m_pS((Object)"jVj;J~KmPx\\;Vk\\iXoPtW;_zPw\\\u007f");
        }
        if (a2 instanceof SettingsException) {
            return ReplicationReceiver.m_Eca((Object)"$\u0016\u0015\n\f\u0005\u0004\u0012\f\t\u000bF\u0016\u0003\u0011\u0012\f\b\u0002\u0015E\u0003\u0017\u0014\n\u0014");
        }
        if (a2 instanceof ParsingException) {
            return ConnectionController.m_pS((Object)"RWmXwP\u007f\u0019\u007fXoX;_tKvXo");
        }
        if (a2 instanceof ValidationDefinitionException) {
            return ReplicationReceiver.m_Eca((Object)"/\u000b\u0012\u0000\u0014\u000b\u0007\tF\u0013\u0007\t\u000f\u0001\u0007\u0011\u000f\n\bE\u0005\n\b\u0003\u000f\u0002\u0013\u0017\u0007\u0011\u000f\n\bE\u0003\u0017\u0014\n\u0014");
        }
        if (a2 instanceof BrowseOperationException) {
            return ConnectionController.m_pS((Object)"ZW;\\iKtK;VxZnKi\\\u007f\u0019\u007fLiPu^;X;[iVlJ~\u0019tI~KzMrVu");
        }
        if (a2 instanceof SetValueException) {
            return ReplicationReceiver.m_Eca((Object)"'\u000bF\u0000\u0014\u0017\t\u0017F\n\u0005\u0006\u0013\u0017\u0014\u0000\u0002E\u0011\r\u000f\t\u0003E\u0015\u0000\u0012\u0011\u000f\u000b\u0001E\u0007E\u0010\u0004\n\u0010\u0003");
        }
        if (a2 instanceof CommunicationException) {
            return ConnectionController.m_pS((Object)"XVvTnWrZzMrVu\u0019xVu_r^nKzMrVu\u0019~KiVi");
        }
        if (a2 instanceof RunAsExecutionException) {
            return ReplicationReceiver.m_Eca((Object)"'\u000bF\f\b\u0011\u0003\u0017\b\u0004\nE\t\u0015\u0003\u0017\u0007\u0011\u000f\n\bE\u0000\u0004\u000f\t\u0003\u0001F\u0001\u0013\u0017\u000f\u000b\u0001E\u0003\u001d\u0003\u0006\u0013\u0011\u000f\n\b");
        }
        if (a2 instanceof SpaceOperationException) {
            return ConnectionController.m_pS((Object)"HIzZ~\u0019tI~KzMrVu\u0019}XrU~];]n\\;Mt\u0019z\u0019yLhPu\\hJ;KnU~\u0019mPtUzMrVu");
        }
        if (a2 instanceof ImportExportException) {
            return ReplicationReceiver.m_Eca((Object)"'\u000bF\u0000\u0014\u0017\t\u0017F\n\u0005\u0006\u0013\u0017\u0014\u0000\u0002E\u0002\u0010\u0014\f\b\u0002F\u0001\u0007\u0011\u0007E\u000f\b\u0016\n\u0014\u0011I\u0000\u001e\u0015\t\u0017\u0012");
        }
        if (a2 instanceof ReportGenerationException) {
            return ConnectionController.m_pS((Object)"xu\u0019~KiVi\u0019tZxLiK~];]nKrW|\u0019i\\kViM;^~W~KzMrVu");
        }
        if (a2 instanceof ReportSchedulingException) {
            return ReplicationReceiver.m_Eca((Object)"$\bE\u0003\u0017\u0014\n\u0014E\t\u0006\u0005\u0010\u0014\u0017\u0003\u0001F\u0001\u0013\u0017\u000f\u000b\u0001E\u0014\u0000\u0016\n\u0014\u0011F\u0016\u0005\r\u0003\u0001\u0013\t\u000f\u000b\u0001");
        }
        if (a2 instanceof BroadcastOperationException) {
            return ConnectionController.m_pS((Object)"xu\u0019~KiVi\u0019tZxLiK~];]nKrW|\u0019z\u0019yKtX\u007fZzJo\u0019tI~KzMrVu");
        }
        if (a2 instanceof AuthTokenException) {
            return ReplicationReceiver.m_Eca((Object)"$\bE\u0007\u0010\u0012\r\u0003\u000b\u0012\f\u0005\u0004\u0012\f\t\u000bF\u0011\t\u000e\u0003\u000bF\u0000\u0014\u0017\t\u0017F\n\u0005\u0006\u0013\u0017\u0014\u0000\u0002");
        }
        if (a2 instanceof DataIntegrityViolationException) {
            return ConnectionController.m_pS((Object)"_XoXyXh\\;ZtWhMiXrWo\u0019mPtUzMrVu");
        }
        if (a2 instanceof TransactionSystemException) {
            return ReplicationReceiver.m_Eca((Object)"!\u0007\u0011\u0007\u0007\u0007\u0016\u0003E\u0012\u0017\u0007\u000b\u0015\u0004\u0005\u0011\u000f\n\bE\u0003\u0017\u0014\n\u0014");
        }
        if (a2 instanceof InfluxDBMapperException) {
            return ConnectionController.m_pS((Object)"mrT~\u0019h\\iP~J;]zMz[zJ~\u0019~KiVi");
        }
        if (a2 instanceof SecurityException || a2 instanceof AccessDeniedException || a2 instanceof BadCredentialsException) {
            return ReplicationReceiver.m_Eca((Object)"'\u0006\u0005\u0000\u0015\u0016F\u0001\u0003\u000b\u000f\u0000\u0002");
        }
        if (a2 instanceof MethodArgumentNotValidException || a2 instanceof IllegalArgumentException) {
            return ConnectionController.m_pS((Object)"RWmXwP\u007f\u0019rWkLo");
        }
        if (a2 instanceof ConstraintViolationException) {
            return ReplicationReceiver.m_Eca((Object)"0\u0004\n\f\u0002\u0004\u0012\f\t\u000bF\u0006\t\u000b\u0015\u0011\u0014\u0004\u000f\u000b\u0012E\u0010\f\t\t\u0007\u0011\u000f\n\b");
        }
        if (a2 instanceof HttpMessageNotReadableException) {
            return ConnectionController.m_pS((Object)"puOzUr];K~Hn\\hM;_tKvXo");
        }
        if (a2 instanceof MissingServletRequestParameterException) {
            return ReplicationReceiver.m_Eca((Object)"(\u000f\u0016\u0015\f\b\u0002F\u0017\u0003\u0014\u0013\f\u0014\u0000\u0002E\u0016\u0004\u0014\u0004\u000b\u0000\u0012\u0000\u0014");
        }
        if (a2 instanceof IllegalStateException) {
            return ConnectionController.m_pS((Object)"RWmXwP\u007f\u0019zIkUrZzMrVu\u0019hMzM~");
        }
        return ReplicationReceiver.m_Eca((Object)"$\bE\u0013\u000b\u0003\u001d\u0016\u0000\u0005\u0011\u0003\u0001F\u0000\u0014\u0017\t\u0017F\n\u0005\u0006\u0013\u0017\u0014\u0000\u0002");
    }
}

