/*
 * Decompiled with CFR 0.152.
 */
package com.inscada.mono.report.services;

import com.inscada.mono.auth.c_oL;
import com.inscada.mono.cluster.exceptions.ClusterRpcException;
import com.inscada.mono.cluster.services.ClusterNodeListener;
import com.inscada.mono.cluster.services.c_b;
import com.inscada.mono.job.model.DailyJob;
import com.inscada.mono.job.model.Job;
import com.inscada.mono.job.model.MonthlyJob;
import com.inscada.mono.job.p.c_nB;
import com.inscada.mono.log.m.c_ac;
import com.inscada.mono.menu.restcontrollers.MenuController;
import com.inscada.mono.project.m.c_E;
import com.inscada.mono.report.exceptions.ReportSchedulingException;
import com.inscada.mono.report.m.c_jc;
import com.inscada.mono.report.m.c_ld;
import com.inscada.mono.report.model.Report;
import com.inscada.mono.report.model.ReportSummary;
import com.inscada.mono.report.p.c_NA;
import com.inscada.mono.report.p.c_ZC;
import com.inscada.mono.report.services.c_ic;
import com.inscada.mono.report.services.c_yC;
import com.inscada.mono.settings.restcontrollers.OtpSettingsController;
import com.inscada.mono.shared.exceptions.NotActiveException;
import com.inscada.mono.shared.model.OwnedSpaceBaseModel;
import jakarta.annotation.PostConstruct;
import java.time.LocalTime;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Component;
import org.springframework.transaction.event.TransactionalEventListener;
import redis.clients.jedis.JedisPooled;

@Component
public class ReportManager
implements ClusterNodeListener,
c_E {
    private final Map<String, List<Job>> f_UE;
    private static final Logger f_Yd = LoggerFactory.getLogger(ReportManager.class);
    public static final short f_nf = 503;
    public static final short f_DE = 505;
    private final c_b f_jE;
    private final c_ac f_iF;
    public static final short f_Re = 502;
    private final c_yC f_le;
    private final c_nB f_gg;
    public static final short f_KF = 506;
    public static final short f_hg = 507;
    private final Lock f_wD;
    private final JedisPooled f_wF;
    public static final short f_EE = 504;
    private final c_oL f_ld;
    public static final short f_pb = 501;
    private static final String f_gd = "scheduledReports";
    private final c_ic f_qc;

    /*
     * WARNING - void declaration
     */
    @TransactionalEventListener(value={c_jc.class})
    public void handleCancelEvent(c_jc c_jc2) {
        void a;
        ReportManager reportManager = this;
        if (reportManager.f_jE.m_fa()) {
            ReportManager a2 = a.m_UJ();
            f_Yd.info(MenuController.m_fl((Object)"N[CZGL8>J\u007flznwly\"]cpa{n[t{lj\"xml\"lgnmlv$\"e\u007f>*WF$\"e\u007f7"), (Object)a2.getName(), (Object)a2.getId());
            reportManager.cancelReportInternal((Report)a2);
            return;
        }
        f_Yd.debug(OtpSettingsController.m_nF((Object)"O$OFM.@/D9;KH\fo\u0004s\u0002o\f!(`\u0005b\u000em.w\u000eo\u001f!\rn\u0019!\u0019d\u001bn\u0019uQ!\u0010|"), (Object)a.m_UJ().getId());
    }

    @PreAuthorize(value="hasAuthority('VIEW_REPORT')")
    public c_NA getReportStatus(String string) {
        Object a = string;
        ReportManager a2 = this;
        if (a2.f_jE.m_fa()) {
            f_Yd.debug(OtpSettingsController.m_nF((Object)"M.@/D9;KF\u000eu\u001fh\u0005fKs\u000eq\u0004s\u001f!\u0018u\nu\u001erKg\u0004sKH/;Kz\u0016!\u0007n\b`\u0007m\u0012/"), a);
            return a2.getReportStatusInternal((String)a);
        }
        f_Yd.debug(MenuController.m_fl((Object)"PMP/RG_F[P$\"Lgow{qjkpe>n{czgl\"xml\"lgnmlv>qjcjwm\"xml\"WF$\"e\u007f0"), a);
        try {
            Object[] objectArray = new Object[--1];
            objectArray[3 & 4] = a;
            return (c_NA)a2.f_jE.m_w(Short.valueOf((short)(0x7BFF & 0x5F7)), objectArray);
        }
        catch (Exception exception) {
            throw new ClusterRpcException("Failed to RPC get report transfer status for " + (String)a, (Throwable)exception);
        }
    }

    /*
     * WARNING - void declaration
     */
    @PreAuthorize(value="hasAuthority('VIEW_REPORT')")
    public c_NA getReportStatus(String string, String string2) {
        void a;
        Object a2 = string;
        ReportManager a3 = this;
        if ((a2 = a3.f_le.m_Cj((String)a2, (String)a)) == null) {
            return c_NA.f_KE;
        }
        return a3.getReportStatus(a2.getId());
    }

    protected c_NA getReportStatusInternal(String string) {
        Object a = string;
        ReportManager a2 = this;
        if (a2.f_UE.containsKey(a)) {
            return c_NA.f_cF;
        }
        return c_NA.f_KE;
    }

    /*
     * WARNING - void declaration
     */
    @PreAuthorize(value="hasAuthority('CANCEL_REPORT')")
    public void cancelReport(String string, String string2) {
        void a;
        ReportManager a2;
        Object a3 = string2;
        ReportManager reportManager = a2 = this;
        reportManager.cancelReport(reportManager.f_le.m_Pg((String)a, (String)a3).getId());
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void lambda$restoreSingleReportOnLeader$1(String string, Report report) {
        void a;
        ReportManager a2 = report;
        ReportManager a3 = this;
        try {
            Object[] objectArray = new Object[--3];
            objectArray[3 ^ 3] = a;
            objectArray[4 ^ 5] = a2.getName();
            objectArray[1 ^ 3] = a2.getId();
            f_Yd.info(OtpSettingsController.m_nF((Object)"9d\u001bn\u0019u&`\u0005`\fd\u0019!CM\u000e`\u000fd\u0019!\u0010|B;KS\u000er\u001fn\u0019h\u0005fKs\u000eq\u0004s\u001f;Kz\u0016!CH/;Kz\u0016("), objectArray);
            a3.scheduleReportInternal((Report)a2);
            return;
        }
        catch (Exception exception) {
            Object[] objectArray = new Object[--3];
            objectArray[3 & 4] = a2.getName();
            objectArray[2 ^ 3] = a2.getId();
            objectArray[5 >> 1] = ExceptionUtils.getRootCauseMessage((Throwable)exception);
            a3.f_iF.m_ML(a2.getProject()).m_s("Report Restore (Leader " + (String)a + ")", MenuController.m_fl((Object)"'m\"6KZ8>'m+>d\u007fkrgz\"jm>p{qjmlg0\"]ckq{8>'m").formatted(objectArray));
            try {
                f_Yd.warn(OtpSettingsController.m_nF((Object)"9d\u001bn\u0019u&`\u0005`\fd\u0019!CM\u000e`\u000fd\u0019!\u0010|B;K@\u001fu\u000el\u001bu\u0002o\f!\u001fnKb\no\bd\u0007!\u0019d\u001bn\u0019uKz\u0016!\ng\u001fd\u0019!\u0019d\u0018u\u0004s\nu\u0002n\u0005!\r`\u0002m\u001es\u000e/"), (Object)a, (Object)a2.getId());
                a3.cancelReportInternal((Report)a2);
                return;
            }
            catch (Exception exception2) {
                Object[] objectArray2 = new Object[--4];
                objectArray2[5 >> 3] = a;
                objectArray2[--1] = a2.getId();
                objectArray2[1 ^ 3] = exception2.getMessage();
                objectArray2[--3] = exception2;
                f_Yd.error(MenuController.m_fl((Object)"LgnmlvScpcygl\"6N{czgl\"e\u007f78>D\u007fkrgz\"jm>a\u007fl}gr\"lgnmlv>yc\"\u007fdjgl\"lgmvqp\u007fvwmp\"xcwnkp{8>yc"), objectArray2);
                return;
            }
        }
    }

    protected void cancelReportInternal(Report report) {
        ReportManager a = report;
        ReportManager a2 = this;
        a2.f_ld.m_qFa(() -> a2.lambda$cancelReportInternal$9((Report)a), (OwnedSpaceBaseModel)a);
    }

    protected void scheduleReportInternal(Report report) {
        ReportManager a = report;
        ReportManager a2 = this;
        a2.f_ld.m_qFa(() -> a2.lambda$scheduleReportInternal$4((Report)a), (OwnedSpaceBaseModel)a);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private /* synthetic */ void lambda$cancelReportInternal$9(Report report) {
        ReportManager reportManager = this;
        reportManager.f_wD.lock();
        try {
            void a;
            Object a2 = (List)reportManager.f_UE.get(a.getId());
            if (a2 != null) {
                Object object = a2 = a2.iterator();
                while (object.hasNext()) {
                    Job job = (Job)a2.next();
                    object = a2;
                    reportManager.f_gg.m_ij(job);
                }
            }
            ReportManager reportManager2 = reportManager;
            reportManager2.f_UE.remove(a.getId());
            String[] stringArray = new String[4 ^ 5];
            stringArray[3 >> 2] = a.getId();
            reportManager2.f_wF.srem(f_gd, stringArray);
            return;
        }
        finally {
            reportManager.f_wD.unlock();
        }
    }

    public void deactivateForProject(String string) {
        Object a = string;
        ReportManager a2 = this;
        if (a2.f_jE.m_fa()) {
            f_Yd.info(MenuController.m_fl((Object)"N[CZGL8>J\u007flznwly\"Npqh{ajF{c}vwt\u007fv{Ghgpv>dqp>rlmtg}v>KZ8>yc"), a);
            a2.cancelReportsByProjectIdInternal((String)a);
            return;
        }
        f_Yd.debug(OtpSettingsController.m_nF((Object)"%N%,'D*E.SQ!\"f\u0005n\u0019h\u0005fKQ\u0019n\u0001d\bu/d\nb\u001fh\u001d`\u001fd.w\u000eo\u001f!\rn\u0019!\u001bs\u0004k\u000eb\u001f!\"EQ!\u0010|"), a);
    }

    protected void scheduleReportsByProjectIdInternal(String string) {
        Object a = string;
        ReportManager a2 = this;
        if ((a = a2.f_le.m_LG((String)a)) == null || a.isEmpty()) {
            return;
        }
        a.forEach(arg_0 -> a2.scheduleReportInternal(arg_0));
    }

    protected Map<String, c_NA> getReportStatusesByProjectIdInternal(String string) {
        Object a = string;
        ReportManager a2 = this;
        if ((a = a2.f_le.m_Oi((String)a)) == null || a.isEmpty()) {
            return Collections.emptyMap();
        }
        return a.stream().collect(Collectors.toMap(ReportSummary::getId, reportSummary -> {
            ReportManager a = reportSummary;
            ReportManager a2 = this;
            return a2.getReportStatusInternal(a.getId());
        }));
    }

    private /* synthetic */ DailyJob scheduleDailyMailReportJob(Report report) {
        ReportManager a = report;
        ReportManager a2 = this;
        return a2.f_gg.m_Dn(a.getProject(), "Report Mail - " + a.getName(), () -> a2.lambda$scheduleDailyMailReportJob$8((Report)a), LocalTime.of(a.getMailTime().getHours(), a.getMailTime().getMinutes(), a.getMailTime().getSeconds()));
    }

    @PostConstruct
    private /* synthetic */ void initializeClusterIntegration() {
        ReportManager a;
        ReportManager reportManager = a;
        reportManager.registerRemoteCallsWithClusterNode();
        reportManager.f_jE.m_Ja((ClusterNodeListener)a);
        f_Yd.info(MenuController.m_fl((Object)"P{rqpjO\u007fl\u007fe{p>kpkjk\u007fnwx{f>cpf>p{ewqjglgz\"\u007fq>Arwmv{pPmzgRkmv{l{p0"));
    }

    private /* synthetic */ MonthlyJob scheduleMonthlyMailReportJob(Report report) {
        ReportManager a = report;
        ReportManager a2 = this;
        return a2.f_gg.m_Bm(a.getProject(), "Report Mail - " + a.getName(), () -> a2.lambda$scheduleMonthlyMailReportJob$6((Report)a), (int)a.getMailDay().shortValue(), LocalTime.of(a.getMailTime().getHours(), a.getMailTime().getMinutes(), a.getMailTime().getSeconds()));
    }

    protected Map<String, c_NA> getReportStatusesByIdsInternal(List<String> list) {
        List<String> a = list;
        ReportManager a2 = this;
        if (a == null || a.isEmpty()) {
            return Collections.emptyMap();
        }
        return a.stream().collect(Collectors.toMap(Function.identity(), arg_0 -> a2.getReportStatusInternal(arg_0)));
    }

    @PreAuthorize(value="hasAuthority('CANCEL_REPORT')")
    public void cancelReport(String string) {
        Object a = string;
        ReportManager a2 = this;
        if (a2.f_jE.m_fa()) {
            f_Yd.debug(MenuController.m_fl((Object)"RG_F[P$\"]cpa{nrkpe>p{rqpj\"e\u007f>nqa\u007fnr{0"), a);
            a2.cancelReportInternal((String)a);
            return;
        }
        f_Yd.debug(OtpSettingsController.m_nF((Object)"%N%,'D*E.SQ!9d\u001at\u000er\u001fh\u0005fKm\u000e`\u000fd\u0019!\u001fnKb\no\bd\u0007!\u0019d\u001bn\u0019uKz\u0016/"), a);
        try {
            Object[] objectArray = new Object[3 & 5];
            objectArray[5 >> 3] = a;
            a2.f_jE.m_w(Short.valueOf((short)(0x49F6 & 0x37FF)), objectArray);
            return;
        }
        catch (Exception exception) {
            throw new ClusterRpcException("Failed to RPC cancel report " + (String)a, (Throwable)exception);
        }
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void lambda$notLeader$2(String string, String string2) {
        void a;
        ReportManager reportManager = this;
        List a22 = (List)reportManager.f_UE.get(a);
        if (a22 != null) {
            void a3;
            try {
                f_Yd.info(OtpSettingsController.m_nF((Object)"S\u000eq\u0004s\u001fL\no\nf\u000esK)%n\u001f!'d\ne\u000esKz\u0016(Q!(`\u0005b\u000em\u0007h\u0005fKm\u0004b\nmKk\u0004cKg\u0004sKs\u000eq\u0004s\u001f!\"EQ!\u0010|"), (Object)a3, (Object)a);
                a22.forEach(arg_0 -> ((c_nB)reportManager.f_gg).m_ij(arg_0));
                return;
            }
            catch (Exception a22) {
                Object[] objectArray = new Object[--4];
                objectArray[3 >> 2] = a3;
                objectArray[--1] = a;
                objectArray[5 >> 1] = a22.getMessage();
                objectArray[--3] = a22;
                f_Yd.error(MenuController.m_fl((Object)"P{rqpjO\u007fl\u007fe{p>*Pmj\"Rg\u007ff{p>yc+$\"[plml\"}cpa{nrkpe>nqa\u007fn>hq`>dqp>p{rqpj\"WF>yc8>yc"), objectArray);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void lambda$scheduleDailyMailReportJob$8(Report report) {
        void a;
        Object a2;
        ReportManager reportManager = this;
        Calendar calendar = Calendar.getInstance();
        Object object = a2 = calendar;
        Object object2 = a2;
        ((Calendar)object2).set(0x4F & 0x3B, a.getReportTime().getHours());
        ((Calendar)object2).set(0x5D & 0x2E, a.getReportTime().getMinutes());
        ((Calendar)object).set(0x5F & 0x2D, a.getReportTime().getSeconds());
        calendar.set(0x3F & 0x4E, 3 & 4);
        a2 = ((Calendar)object).getTime();
        calendar.add(--5, -4 >> 2);
        Date date = calendar.getTime();
        reportManager.f_qc.m_sH(a.getId(), date, (Date)a2, 5 >> 2, a.getLang());
    }

    /*
     * WARNING - void declaration
     */
    @PreAuthorize(value="hasAuthority('SCHEDULE_REPORT')")
    public void scheduleReport(String string, String string2) {
        void a;
        ReportManager a2;
        Object a3 = string2;
        ReportManager reportManager = a2 = this;
        reportManager.scheduleReport(reportManager.f_le.m_Pg((String)a, (String)a3).getId());
    }

    private /* synthetic */ void registerRemoteCallsWithClusterNode() {
        ReportManager reportManager = this;
        try {
            Class[] classArray = new Class[4 ^ 5];
            classArray[3 >> 2] = String.class;
            reportManager.f_jE.m_Da((short)(0x29FF & 0x57F5), (Object)reportManager, ReportManager.class.getDeclaredMethod(OtpSettingsController.m_nF((Object)"\u0018b\u0003d\u000ft\u0007d9d\u001bn\u0019u\"o\u001fd\u0019o\nm"), classArray));
            Class[] classArray2 = new Class[3 >> 1];
            classArray2[3 ^ 3] = String.class;
            reportManager.f_jE.m_Da((short)(0x5FE & 0x7BF7), (Object)reportManager, ReportManager.class.getDeclaredMethod(MenuController.m_fl((Object)"a\u007fl}grP{rqpjKpv{ppcr"), classArray2));
            Class[] classArray3 = new Class[3 & 5];
            classArray3[5 >> 3] = String.class;
            reportManager.f_jE.m_Da((short)(0x5BF7 & 0x25FF), (Object)reportManager, ReportManager.class.getDeclaredMethod(OtpSettingsController.m_nF((Object)"f\u000eu9d\u001bn\u0019u8u\nu\u001er\"o\u001fd\u0019o\nm"), classArray3));
            Class[] classArray4 = new Class[5 >> 2];
            classArray4[2 & 5] = String.class;
            reportManager.f_jE.m_Da((short)(0x37F8 & 0x49FF), (Object)reportManager, ReportManager.class.getDeclaredMethod(MenuController.m_fl((Object)"q}j{fkn{P{rqpjq\\{Npqh{ajKzKpv{ppcr"), classArray4));
            Class[] classArray5 = new Class[2 ^ 3];
            classArray5[5 >> 3] = String.class;
            reportManager.f_jE.m_Da((short)(0x67F9 & 0x19FF), (Object)reportManager, ReportManager.class.getDeclaredMethod(OtpSettingsController.m_nF((Object)"\b`\u0005b\u000em9d\u001bn\u0019u\u0018C\u0012Q\u0019n\u0001d\bu\"e\"o\u001fd\u0019o\nm"), classArray5));
            Class[] classArray6 = new Class[1];
            classArray6[0] = List.class;
            reportManager.f_jE.m_Da((short)(0x17FF & 0x69FA), (Object)reportManager, ReportManager.class.getDeclaredMethod(MenuController.m_fl((Object)"e{vLgnmlvMv\u007fvkq{q\\{WfmKpv{ppcr"), classArray6));
            Class[] classArray7 = new Class[1];
            classArray7[0] = String.class;
            reportManager.f_jE.m_Da((short)(0x1FFB & 0x61FF), (Object)reportManager, ReportManager.class.getDeclaredMethod(OtpSettingsController.m_nF((Object)"\fd\u001fS\u000eq\u0004s\u001fR\u001f`\u001ft\u0018d\u0018C\u0012Q\u0019n\u0001d\bu\"e\"o\u001fd\u0019o\nm"), classArray7));
            return;
        }
        catch (NoSuchMethodException a) {
            throw new IllegalStateException(MenuController.m_fl((Object)"D\u007fkrgz\"jm>p{ewqjgl\"LgnmlvScpcygl\"LR]\"sgjjqfm"), a);
        }
    }

    @PreAuthorize(value="hasAuthority('SCHEDULE_REPORT')")
    public void scheduleReport(String string) {
        Object a = string;
        ReportManager a2 = this;
        if (a2.f_jE.m_fa()) {
            f_Yd.debug(MenuController.m_fl((Object)"RG_F[P$\"Mavgzwrkpe>p{rqpj\"e\u007f>nqa\u007fnr{0"), a);
            a2.scheduleReportInternal((String)a);
            return;
        }
        f_Yd.debug(OtpSettingsController.m_nF((Object)"%N%,'D*E.SQ!9d\u001at\u000er\u001fh\u0005fKm\u000e`\u000fd\u0019!\u001fnKr\bi\u000ee\u001em\u000e!\u0019d\u001bn\u0019uKz\u0016/"), a);
        try {
            Object[] objectArray = new Object[3 >> 1];
            objectArray[5 >> 3] = a;
            a2.f_jE.m_w(Short.valueOf((short)(0x4FFD & 0x31F7)), objectArray);
            return;
        }
        catch (Exception exception) {
            throw new ClusterRpcException("Failed to RPC schedule report " + (String)a, (Throwable)exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private /* synthetic */ void lambda$scheduleReportInternal$4(Report var1_2) {
        a = var1_2;
        a = this;
        a.f_wD.lock();
        try {
            block11: {
                block12: {
                    block10: {
                        a.cancelReportInternal((Report)a);
                        if (!Boolean.TRUE.equals(a.getProject().getIsActive())) {
                            throw new NotActiveException("Project should be active to schedule report " + a.getName());
                        }
                        var2_3 = new ArrayList<MonthlyJob>();
                        try {
                            if (!Boolean.TRUE.equals(a.getPrintFlag())) break block10;
                            var3_4 = a.getPeriod() == c_ZC.f_LF ? a.scheduleMonthlyPrintReportJob((Report)a) : a.scheduleDailyPrintReportJob((Report)a);
                        }
                        catch (Exception var3_5) {
                            v0 = var4_6 = var2_3.iterator();
                            while (v0.hasNext()) {
                                var5_7 = (Job)var4_6.next();
                                v0 = var4_6;
                                a.f_gg.m_ij(var5_7);
                            }
                            throw new ReportSchedulingException(MenuController.m_fl((Object)"Xcwn{f>vq\"mavgzwrg>p{rqpj"), (Throwable)var3_5);
                        }
                        var2_3.add(var3_4);
                    }
                    if (!Boolean.TRUE.equals(a.getMailFlag())) break block11;
                    if (a.getPeriod() != c_ZC.f_LF) break block12;
                    v1 = a.scheduleMonthlyMailReportJob((Report)a);
                    ** GOTO lbl30
                }
                v1 = a.scheduleDailyMailReportJob((Report)a);
lbl30:
                // 2 sources

                var3_4 = v1;
                var2_3.add(var3_4);
            }
            v2 = a;
            v2.f_UE.put(a.getId(), var2_3);
            v3 = new String[2 ^ 3];
            v3[3 >> 2] = a.getId();
            v2.f_wF.sadd("scheduledReports", v3);
            return;
        }
        finally {
            a.f_wD.unlock();
        }
    }

    protected void cancelReportsByProjectIdInternal(String string) {
        Object a = string;
        ReportManager a2 = this;
        if ((a = a2.f_le.m_LG((String)a)) == null || a.isEmpty()) {
            return;
        }
        a.forEach(arg_0 -> a2.cancelReportInternal(arg_0));
    }

    private /* synthetic */ MonthlyJob scheduleMonthlyPrintReportJob(Report report) {
        ReportManager a = report;
        ReportManager a2 = this;
        return a2.f_gg.m_Bm(a.getProject(), "Report Print - " + a.getName(), () -> a2.lambda$scheduleMonthlyPrintReportJob$5((Report)a), (int)a.getPrintDay().shortValue(), LocalTime.of(a.getPrintTime().getHours(), a.getPrintTime().getMinutes(), a.getPrintTime().getSeconds()));
    }

    public void notLeader() {
        ReportManager reportManager;
        ReportManager reportManager2 = reportManager = this;
        Object a = reportManager2.f_jE.m_ja();
        f_Yd.info(MenuController.m_fl((Object)"P{rqpjO\u007fl\u007fe{p$\"Jjwq>lqf{\"6yc+>km\"PM>NQLYGL\"JJ[\"RG_F[P0\"]cpa{nrkpe>crn>nqa\u007fn>p{rqpj\"tm|q0,0"), a);
        reportManager2.f_wD.lock();
        try {
            new ArrayList(reportManager.f_UE.keySet()).forEach(arg_0 -> reportManager.lambda$notLeader$2((String)a, arg_0));
            reportManager.f_UE.clear();
            f_Yd.info(OtpSettingsController.m_nF((Object)"S\u000eq\u0004s\u001fL\no\nf\u000esK)%n\u001f!'d\ne\u000esKz\u0016(Q!*m\u0007!\u0007n\b`\u0007!\u0019d\u001bn\u0019uKk\u0004c\u0018!\u0003`\u001ddKc\u000ed\u0005!\u0019d\u001at\u000er\u001fd\u000f!\u001fnKb\no\bd\u0007!\no\u000f!\bm\u000e`\u0019d\u000f!\rs\u0004lKm\u0004b\nmKu\u0019`\bj\u0002o\f/"), a);
            return;
        }
        catch (Exception exception) {
            Object[] objectArray = new Object[--3];
            objectArray[3 & 4] = a;
            objectArray[--1] = exception.getMessage();
            objectArray[5 >> 1] = exception;
            f_Yd.error(MenuController.m_fl((Object)"LgnmlvScpcygl\"6Lqv>N{czgl\"e\u007f78>Glpqp>fkpwly\"npqa{qm\"qd>a\u007fl}grnwly\"rm}cr\"lgnmlv>hq`m8>yc"), objectArray);
            return;
        }
        finally {
            reportManager.f_wD.unlock();
        }
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void lambda$scheduleMonthlyMailReportJob$6(Report report) {
        void a;
        Object a2;
        ReportManager reportManager = this;
        Calendar calendar = Calendar.getInstance();
        Object object = a2 = calendar;
        Object object2 = a2;
        ((Calendar)a2).set(--5, a.getReportDay().shortValue());
        ((Calendar)object2).set(0x2F & 0x5B, a.getReportTime().getHours());
        ((Calendar)object2).set(0x2D & 0x5E, a.getReportTime().getMinutes());
        ((Calendar)object).set(0x1F & 0x6D, a.getReportTime().getSeconds());
        calendar.set(0x4E & 0x3F, 3 ^ 3);
        a2 = ((Calendar)object).getTime();
        calendar.add(5 >> 1, -4 >> 2);
        Date date = calendar.getTime();
        reportManager.f_qc.m_sH(a.getId(), date, (Date)a2, --1 != 0, a.getLang());
    }

    @PreAuthorize(value="hasAuthority('VIEW_REPORT')")
    public Map<String, c_NA> getReportStatuses(List<String> list) {
        List<String> a = list;
        ReportManager a2 = this;
        if (a == null || a.isEmpty()) {
            return Collections.emptyMap();
        }
        if (a2.f_jE.m_fa()) {
            f_Yd.debug(OtpSettingsController.m_nF((Object)"'D*E.SQ!,d\u001fu\u0002o\f!\u0019d\u001bn\u0019uKr\u001f`\u001ft\u0018d\u0018!\rn\u0019!\u0010|KH/rKm\u0004b\nm\u0007xQ!\u0010|"), (Object)a.size(), (Object)a);
            return a2.getReportStatusesByIdsInternal((List)a);
        }
        f_Yd.debug(MenuController.m_fl((Object)"LQL3N[CZGL8>P{skgmvwly\"rg\u007ff{p>dqp>p{rqpj\"mv\u007fvkq{q>dqp>yc\"WFm8>yc"), (Object)a.size(), (Object)a);
        try {
            Object[] objectArray = new Object[--1];
            objectArray[5 >> 3] = new ArrayList(a);
            return (Map)a2.f_jE.m_w(Short.valueOf((short)(0x6FFF & 0x11FA)), objectArray);
        }
        catch (Exception exception) {
            throw new ClusterRpcException("Failed to RPC get report statuses for IDs " + a.stream().map(String::valueOf).collect(Collectors.joining(OtpSettingsController.m_nF((Object)"-"))), (Throwable)exception);
        }
    }

    private /* synthetic */ DailyJob scheduleDailyPrintReportJob(Report report) {
        ReportManager a = report;
        ReportManager a2 = this;
        return a2.f_gg.m_Dn(a.getProject(), "Report Print - " + a.getName(), () -> a2.lambda$scheduleDailyPrintReportJob$7((Report)a), LocalTime.of(a.getPrintTime().getHours(), a.getPrintTime().getMinutes(), a.getPrintTime().getSeconds()));
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void lambda$scheduleDailyPrintReportJob$7(Report report) {
        void a;
        Object a2;
        ReportManager reportManager = this;
        Calendar calendar = Calendar.getInstance();
        Object object = a2 = calendar;
        Object object2 = a2;
        ((Calendar)object2).set(0xB & 0x7F, a.getReportTime().getHours());
        ((Calendar)object2).set(0x5E & 0x2D, a.getReportTime().getMinutes());
        ((Calendar)object).set(0x7D & 0xF, a.getReportTime().getSeconds());
        calendar.set(0x6E & 0x1F, 2 & 5);
        a2 = ((Calendar)object).getTime();
        calendar.add(--5, -4 >> 2);
        Date date = calendar.getTime();
        reportManager.f_qc.m_Ph(a.getId(), date, (Date)a2, (3 & 5) != 0, a.getLang());
    }

    protected void cancelReportInternal(String string) {
        ReportManager a;
        Object a2 = string;
        ReportManager reportManager = a = this;
        reportManager.cancelReportInternal(reportManager.f_le.m_Nh((String)a2));
    }

    @PreAuthorize(value="hasAuthority('VIEW_REPORT')")
    public Map<String, c_NA> getReportStatuses(String string) {
        Object a = string;
        ReportManager a2 = this;
        if (a2.f_jE.m_fa()) {
            f_Yd.debug(MenuController.m_fl((Object)"RG_F[P$\"Ygjvwly\"\u007fnr\"lgnmlv>qjcjwmgm\"xml\"npqh{aj\"e\u007f>nqa\u007fnr{0"), a);
            return a2.getReportStatusesByProjectIdInternal((String)a);
        }
        f_Yd.debug(OtpSettingsController.m_nF((Object)"O$OFM.@/D9;KS\u000ep\u001ed\u0018u\u0002o\f!\u0007d\ne\u000esKg\u0004sK`\u0007mKs\u000eq\u0004s\u001f!\u0018u\nu\u001er\u000erKg\u0004sKq\u0019n\u0001d\buKz\u0016/"), a);
        try {
            Object[] objectArray = new Object[--1];
            objectArray[5 >> 3] = a;
            return (Map)a2.f_jE.m_w(Short.valueOf((short)(0x5FFF & 0x21FB)), objectArray);
        }
        catch (Exception exception) {
            throw new ClusterRpcException("Failed to RPC get statuses for project" + (String)a, (Throwable)exception);
        }
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void lambda$scheduleMonthlyPrintReportJob$5(Report report) {
        void a;
        Object a2;
        ReportManager reportManager = this;
        Calendar calendar = Calendar.getInstance();
        Object object = a2 = calendar;
        Object object2 = a2;
        ((Calendar)a2).set(--5, a.getReportDay().shortValue());
        ((Calendar)object2).set(0x1B & 0x6F, a.getReportTime().getHours());
        ((Calendar)object2).set(0x6C & 0x1F, a.getReportTime().getMinutes());
        ((Calendar)object).set(0x1D & 0x6F, a.getReportTime().getSeconds());
        calendar.set(0x3E & 0x4F, 3 & 4);
        a2 = ((Calendar)object).getTime();
        calendar.add(5 >> 1, -4 >> 2);
        Date date = calendar.getTime();
        reportManager.f_qc.m_Ph(a.getId(), date, (Date)a2, (2 ^ 3) != 0, a.getLang());
    }

    @TransactionalEventListener(value={c_ld.class})
    public void handleRescheduleEvent(c_ld c_ld2) {
        ReportManager reportManager = this;
        if (reportManager.f_jE.m_fa()) {
            ReportManager a = a.m_Hk();
            f_Yd.info(MenuController.m_fl((Object)"N[CZGL8>J\u007flznwly\"Lgmavgzwrg[t{lj\"xml\"lgnmlv$\"e\u007f>*WF$\"e\u007f7"), (Object)a.getName(), (Object)a.getId());
            if (reportManager.getReportStatusInternal(a.getId()) == c_NA.f_cF) {
                reportManager.scheduleReportInternal(a.getId());
                return;
            }
        } else {
            f_Yd.debug(OtpSettingsController.m_nF((Object)"O$OFM.@/D9;KH\fo\u0004s\u0002o\f!9d\u0018b\u0003d\u000ft\u0007d.w\u000eo\u001f!\rn\u0019!\u0019d\u001bn\u0019uQ!\u0010|"), (Object)a.m_Hk().getId());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void leader() {
        ReportManager reportManager;
        ReportManager reportManager2 = reportManager = this;
        Object a = reportManager2.f_jE.m_ja();
        f_Yd.info(OtpSettingsController.m_nF((Object)"S\u000eq\u0004s\u001fL\no\nf\u000esQ!?i\u0002rKo\u0004e\u000e!Cz\u0016(Ki\nrKc\u000eb\u0004l\u000e!\u001fi\u000e!'D*E.SE!9d\u0018u\u0004s\u0002o\f!\u0018b\u0003d\u000ft\u0007d\u000f!\u0019d\u001bn\u0019u\u0018/E/"), a);
        reportManager2.f_wD.lock();
        try {
            HashSet hashSet = new HashSet(reportManager.f_wF.smembers(f_gd));
            if (hashSet.isEmpty()) {
                f_Yd.info(MenuController.m_fl((Object)"P{rqpjO\u007fl\u007fe{p>*Rg\u007ff{p>yc+$\"Pm>q}j{fkn{f>p{rqpjq>dqwpf>kp\"Lgzkm\"jm>p{qjmlg0"), a);
                return;
            }
            Object[] objectArray = new Object[--3];
            objectArray[3 & 4] = a;
            objectArray[2 ^ 3] = hashSet.size();
            objectArray[5 >> 1] = hashSet;
            f_Yd.info(OtpSettingsController.m_nF((Object)"9d\u001bn\u0019u&`\u0005`\fd\u0019!CM\u000e`\u000fd\u0019!\u0010|B;KG\u0004t\u0005eKz\u0016!\u0018b\u0003d\u000ft\u0007d\u000f!\u0019d\u001bn\u0019uKH/rKh\u0005!9d\u000fh\u0018!\u001fnKs\u000er\u001fn\u0019dQ!\u0010|"), objectArray);
            ArrayList arrayList = new ArrayList();
            String[] stringArray = new String[5 >> 2];
            stringArray[2 & 5] = MenuController.m_fl((Object)"TWGI]LGNMLVAKJGS");
            reportManager.f_ld.m_uea(() -> {
                void a;
                Object a2 = hashSet;
                ReportManager a3 = this;
                a.addAll(a3.f_le.m_vg((Set)a2));
            }, stringArray);
            f_Yd.info(OtpSettingsController.m_nF((Object)"9d\u001bn\u0019u&`\u0005`\fd\u0019!CM\u000e`\u000fd\u0019!\u0010|B;K@\u001fu\u000el\u001bu\u0002o\f!\u001fnKs\u000er\u001fn\u0019dKz\u0016!\u0019d\u001bn\u0019u\u0018/"), a, (Object)arrayList.size());
            arrayList.forEach(report -> {
                void a;
                ReportManager reportManager;
                ReportManager reportManager2 = reportManager = this;
                Object a2 = reportManager2.f_jE.m_ja();
                String[] stringArray = new String[1 ^ 3];
                stringArray[3 & 4] = MenuController.m_fl((Object)"MAVGZWRGAP[RQPJ");
                stringArray[5 >> 2] = OtpSettingsController.m_nF((Object)"B*O(D'^9D;N9U");
                reportManager2.f_ld.m_NDa(() -> reportManager.lambda$restoreSingleReportOnLeader$1((String)a2, (Report)a), a.getSpace(), stringArray);
            });
            f_Yd.info(MenuController.m_fl((Object)"LgnmlvScpcygl\"6N{czgl\"e\u007f78>Dwlwqvgz\"lgnmlv>p{qjmlcjkql>rlm}gmq0"), a);
            return;
        }
        catch (Exception exception) {
            Object[] objectArray = new Object[--3];
            objectArray[3 >> 2] = a;
            objectArray[5 >> 2] = exception.getMessage();
            objectArray[1 ^ 3] = exception;
            f_Yd.error(OtpSettingsController.m_nF((Object)"9d\u001bn\u0019u&`\u0005`\fd\u0019!CM\u000e`\u000fd\u0019!\u0010|B;KD\u0019s\u0004sKe\u001es\u0002o\f!\u0019d\u001bn\u0019uKs\u000er\u001fn\u0019`\u001fh\u0004oKq\u0019n\bd\u0018rQ!\u0010|"), objectArray);
            return;
        }
        finally {
            reportManager.f_wD.unlock();
        }
    }

    /*
     * WARNING - void declaration
     */
    public ReportManager(c_yC c_yC2, c_nB c_nB2, c_ic c_ic2, c_ac c_ac2, JedisPooled jedisPooled, c_b c_b2, c_oL c_oL2) {
        ReportManager a;
        void a2;
        void a3;
        void a4;
        void a5;
        void a6;
        void a7;
        ReportManager a8;
        ReportManager reportManager = reportManager2;
        ReportManager reportManager2 = c_oL2;
        ReportManager reportManager3 = a8 = reportManager;
        ReportManager reportManager4 = a8;
        ReportManager reportManager5 = a8;
        ReportManager reportManager6 = a8;
        ReportManager reportManager7 = a8;
        reportManager6.f_wD = new ReentrantLock();
        reportManager6.f_UE = new ConcurrentHashMap();
        reportManager6.f_le = a7;
        reportManager5.f_gg = a6;
        reportManager5.f_qc = a5;
        reportManager4.f_iF = a4;
        reportManager4.f_wF = a3;
        reportManager3.f_jE = a2;
        reportManager3.f_ld = a;
    }

    @PreAuthorize(value="hasAuthority('SCHEDULE_REPORT')")
    public void scheduleReports(String string) {
        Object a = string;
        ReportManager a2 = this;
        if (a2.f_jE.m_fa()) {
            f_Yd.debug(MenuController.m_fl((Object)"N[CZGL8>Q}j{fknwly\"\u007fnr\"lgnmlvm\"xml\"npqh{aj\"e\u007f>nqa\u007fnr{0"), a);
            a2.scheduleReportsByProjectIdInternal((String)a);
            return;
        }
        f_Yd.debug(OtpSettingsController.m_nF((Object)"O$OFM.@/D9;KS\u000ep\u001ed\u0018u\u0002o\f!\u0007d\ne\u000esKu\u0004!\u0018b\u0003d\u000ft\u0007dK`\u0007mKs\u000eq\u0004s\u001frKg\u0004sKq\u0019n\u0001d\buKz\u0016/"), a);
        try {
            Object[] objectArray = new Object[3 >> 1];
            objectArray[3 & 4] = a;
            a2.f_jE.m_w(Short.valueOf((short)(0x25FD & 0x5BFA)), objectArray);
            return;
        }
        catch (Exception exception) {
            throw new ClusterRpcException("Failed to RPC schedule reports for project " + (String)a, (Throwable)exception);
        }
    }

    protected void scheduleReportInternal(String string) {
        ReportManager a;
        Object a2 = string;
        ReportManager reportManager = a = this;
        reportManager.scheduleReportInternal(reportManager.f_le.m_Nh((String)a2));
    }

    @PreAuthorize(value="hasAuthority('CANCEL_REPORT')")
    public void cancelReports(String string) {
        Object a = string;
        ReportManager a2 = this;
        if (a2.f_jE.m_fa()) {
            f_Yd.debug(MenuController.m_fl((Object)"N[CZGL8>A\u007fl}grnwly\"\u007fnr\"lgnmlvm\"xml\"npqh{aj\"e\u007f>nqa\u007fnr{0"), a);
            a2.cancelReportsByProjectIdInternal((String)a);
            return;
        }
        f_Yd.debug(OtpSettingsController.m_nF((Object)"O$OFM.@/D9;KS\u000ep\u001ed\u0018u\u0002o\f!\u0007d\ne\u000esKu\u0004!\b`\u0005b\u000emK`\u0007mKs\u000eq\u0004s\u001frKg\u0004sKq\u0019n\u0001d\buKz\u0016/"), a);
        try {
            Object[] objectArray = new Object[--1];
            objectArray[3 >> 2] = a;
            a2.f_jE.m_w(Short.valueOf((short)(0x5F9 & 0x7BFF)), objectArray);
            return;
        }
        catch (Exception exception) {
            throw new ClusterRpcException("Failed to RPC cancel reports for project " + (String)a, (Throwable)exception);
        }
    }
}

