/*
 * Decompiled with CFR 0.152.
 */
package com.inscada.mono.filesystem.m;

import com.inscada.mono.filesystem.model.FileDownloadResult;
import com.inscada.mono.filesystem.model.FileInfo;
import com.inscada.mono.filesystem.repositories.FileInfoRepository;
import com.inscada.mono.project.m.c_fB;
import com.inscada.mono.settings.m.c_oA;
import com.inscada.mono.shared.exceptions.FileStorageException;
import com.inscada.mono.shared.exceptions.NotFoundException;
import com.inscada.mono.shared.model.BaseModel;
import com.inscada.mono.shared.model.ModelUpdater;
import com.inscada.mono.shared.model.SpaceBaseModel;
import com.inscada.mono.shared.y.c_oC;
import com.inscada.mono.space.SpaceContext;
import com.inscada.mono.space.model.Space;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.io.Resource;
import org.springframework.core.io.UrlResource;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.StringUtils;
import org.springframework.web.multipart.MultipartFile;

@Service
@Transactional(readOnly=true)
public class c_vA {
    public static final String f_Qh = "logo";
    public static final String f_wi = "scl-files";
    private static final Logger f_cI = LoggerFactory.getLogger(c_vA.class);
    public static final String f_Xg = "project-icons";
    private final ModelUpdater f_gi;
    public static final String f_jI = "jasper-templates";
    private final String f_HH;
    public static final String f_Nh = "login-images";
    public static final String f_RH = "faceplates";
    private final FileInfoRepository f_xH;
    public static final String f_QH = "symbols";
    public static final String f_dH = "animations";
    public static final String f_zG = "general-uploads";

    @PreAuthorize(value="hasAuthority('VIEW_FILE')")
    public FileInfo m_so(String string) {
        Object a = string;
        c_vA a2 = this;
        return a2.f_xH.findById(a).orElse(null);
    }

    @Transactional
    @PreAuthorize(value="hasAuthority('CREATE_FILE') and hasAuthority('UPDATE_FILE')")
    public void m_eN(Collection<FileInfo> collection) {
        Iterator a;
        c_vA c_vA2 = this;
        Object object = a.stream().map(BaseModel::getId).filter(Objects::nonNull).collect(Collectors.toSet());
        Object object2 = a.stream().map(FileInfo::getName).filter(c_oC::m_Ne).collect(Collectors.toSet());
        object = c_vA2.f_xH.findByIdInOrNameIn(object, object2);
        object2 = object.stream().collect(Collectors.toMap(BaseModel::getId, Function.identity()));
        object = object.stream().collect(Collectors.toMap(FileInfo::getName, Function.identity()));
        ArrayList<Object> arrayList = new ArrayList<Object>();
        a = a.iterator();
        while (a.hasNext()) {
            FileInfo fileInfo;
            c_vA a2 = (FileInfo)a.next();
            Object object3 = a2.getId() != null ? (FileInfo)object2.get(a2.getId()) : (fileInfo = c_oC.m_Ne((String)a2.getName()) ? (FileInfo)object.get(a2.getName()) : null);
            if (fileInfo != null) {
                c_vA2.f_gi.copyForUpdate((Object)a2, (SpaceBaseModel)fileInfo, new String[2 & 5]);
                arrayList.add(fileInfo);
                continue;
            }
            arrayList.add(a2);
        }
        c_vA2.f_xH.bulkSave(arrayList);
    }

    @PreAuthorize(value="hasAuthority('VIEW_FILE')")
    public Optional<FileInfo> m_Ym(String string) {
        Object a = string;
        c_vA a2 = this;
        return a2.f_xH.findById(a);
    }

    private static /* synthetic */ NotFoundException m_Eo(String a) {
        return new NotFoundException("File info not found with relative path: " + a);
    }

    private static /* synthetic */ NotFoundException m_QO(String a) {
        return new NotFoundException("File info not found with id: " + a);
    }

    /*
     * WARNING - void declaration
     */
    @Transactional
    @PreAuthorize(value="hasAuthority('DELETE_FILE') and hasAuthority('UPDATE_LOGIN_SETTINGS')")
    public void m_JM(String string) {
        void a;
        c_vA c_vA2 = this;
        if (!StringUtils.hasText((String)a)) {
            f_cI.warn(c_oA.m_qD((Object)"S\u0001[\u0001C\u0001{\u000bP\rY-Z\u0005P\u0001\u0017\u0007V\b[\u0001SD@\rC\f\u0017\u0001Z\u0014C\u001d\u0017\u000bEDY\u0011[\b\u0017\u0002^\bR\nV\tRJ"));
            return;
        }
        try {
            Object a2 = StringUtils.cleanPath((String)a);
            if (a2.contains(c_fB.m_MJ((Object)"_7"))) {
                throw new FileStorageException(c_oA.m_qD((Object)"\"^\bR\nV\tRDT\u000bY\u0010V\rY\u0017\u0017\rY\u0012V\b^\u0000\u0017\u0014V\u0010_DD\u0001F\u0011R\nT\u0001\u0017C\u0019J\u0010J"));
            }
            Path path = Path.of(c_vA2.f_HH, new String[2 & 5]).toAbsolutePath().normalize().resolve(f_Nh).normalize();
            Path path2 = path.resolve((String)a2).normalize();
            if (!path2.startsWith(path)) {
                f_cI.warn(c_fB.m_MJ((Object)"I\u0010m\u00199\u0005k\u0010o\u0014k\u0002x\u001d9\u0010m\u0005|\u001ci\u00059\u0017v\u00039\u001dv\u0016p\u001f9\u0018t\u0010~\u00149\u0015|\u001d|\u0005p\u001ewK9\nd"), a2);
                throw new FileStorageException(c_oA.m_qD((Object)"~\nA\u0005[\rSD[\u000bP\rYD^\tV\u0003RDG\u0005C\f\u0017\u0002X\u0016\u0017\u0000R\bR\u0010^\u000bYJ"));
            }
            Files.deleteIfExists(path2);
            f_cI.info(c_fB.m_MJ((Object)"U\u001e~\u0018wQp\u001cx\u0016|Q>\ndV9\u0015|\u001d|\u0005|\u00159\u0017k\u001etQ\u007f\u0018u\u0014j\bj\u0005|\u001c9Yp\u00179\u0018mQ|\tp\u0002m\u0014}X7"), a2);
            return;
        }
        catch (IOException a2) {
            f_cI.error(c_oA.m_qD((Object)"r\u0016E\u000bEDX\u0007T\u0011E\u0016R\u0000\u0017\u0013_\r[\u0001\u0017\u0000R\bR\u0010^\nPD[\u000bP\rYD^\tV\u0003RDQ\r[\u0001\rDL\u0019"), (Object)a, (Object)a2);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    public FileDownloadResult m_zm(String string) {
        Path path;
        block7: {
            FileInfo fileInfo;
            Object a;
            void a2;
            c_vA c_vA2 = this;
            if (!StringUtils.hasText((String)a2)) {
                throw new NotFoundException(c_oA.m_qD((Object)"*XD[\u000bP\rYDU\u0005T\u000fP\u0016X\u0011Y\u0000\u0017\rZ\u0005P\u0001\u0017\u0002^\bR\nV\tRDG\u0016X\u0012^\u0000R\u0000"));
            }
            Path path2 = Path.of(c_vA2.f_HH, new String[5 >> 3]);
            path = path2.resolve(f_Nh).resolve((String)a2).normalize();
            if (!path.startsWith((Path)(a = path2.resolve(f_Nh).normalize()))) {
                throw new FileStorageException(c_fB.m_MJ((Object)"8w\u0007x\u001dp\u00159\u001dv\u0016p\u001f9\u0018t\u0010~\u00149\u0001x\u0005q"));
            }
            a = new UrlResource(path.toUri());
            if (!a.exists() || !a.isReadable()) break block7;
            FileInfo fileInfo2 = fileInfo = new FileInfo();
            fileInfo2.setFileName((String)a2);
            fileInfo2.setFileType(Files.probeContentType(path));
            if (fileInfo2.getFileType() == null) {
                fileInfo.setFileType(c_oA.m_qD((Object)"V\u0014G\b^\u0007V\u0010^\u000bYKX\u0007C\u0001CID\u0010E\u0001V\t"));
            }
            return new FileDownloadResult((Resource)a, fileInfo);
        }
        try {
            f_cI.error(c_fB.m_MJ((Object)"=v\u0016p\u001f9\u0018t\u0010~\u00149\u0017p\u001d|Qw\u001emQ\u007f\u001el\u001f}Qv\u001f9\u0015p\u0002rK9\nd"), (Object)path);
            throw new NotFoundException(c_oA.m_qD((Object)"{\u000bP\rYD^\tV\u0003RDQ\r[\u0001\u0017\nX\u0010\u0017\u0002X\u0011Y\u0000"));
        }
        catch (MalformedURLException a) {
            throw new NotFoundException(c_fB.m_MJ((Object)"U\u001e~\u0018wQp\u001cx\u0016|Q\u007f\u0018u\u00149\u001fv\u00059\u0017v\u0004w\u00159Yt\u0010u\u0017v\u0003t\u0014}QL#UX7"));
        }
        catch (IOException a) {
            f_cI.error(c_oA.m_qD((Object)"r\u0016E\u000bEDV\u0007T\u0001D\u0017^\nPD[\u000bP\rYD^\tV\u0003RDQ\r[\u0001\rDL\u0019"), (Object)path, (Object)a);
            throw new NotFoundException(c_fB.m_MJ((Object)"=v\u0016p\u001f9\u0018t\u0010~\u00149\u0017p\u001d|Qw\u001emQ\u007f\u001el\u001f}"));
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Transactional
    @PreAuthorize(value="hasAuthority('CREATE_FILE')")
    public FileInfo m_oO(MultipartFile multipartFile, FileInfo fileInfo) {
        String string;
        c_vA c_vA2;
        String string2;
        void a22;
        c_vA a = fileInfo;
        c_vA a3 = this;
        void v0 = a22;
        Objects.requireNonNull(a, c_fB.m_MJ((Object)"_\u0018u\u0014P\u001f\u007f\u001e9\u001e{\u001b|\u0012mQz\u0010w\u001fv\u00059\u0013|Qw\u0004u\u001d7"));
        Objects.requireNonNull(v0, c_oA.m_qD((Object)")B\bC\rG\u0005E\u0010q\r[\u0001\u0017\u0007V\nY\u000bCDU\u0001\u0017\nB\b[J"));
        if (v0.isEmpty()) {
            throw new FileStorageException(c_fB.m_MJ((Object)"Z\u0010w\u001fv\u00059\u0002m\u001ek\u00149\u0010wQ|\u001ci\u0005`Q\u007f\u0018u\u00147"));
        }
        String string3 = StringUtils.cleanPath((String)Objects.requireNonNull(a22.getOriginalFilename(), c_oA.m_qD((Object)")B\bC\rG\u0005E\u0010q\r[\u0001\u0017\u000bE\rP\rY\u0005[DQ\r[\u0001Y\u0005Z\u0001\u0017\u0007V\nY\u000bCDU\u0001\u0017\nB\b[J")));
        String string4 = string2 = StringUtils.hasText((String)a.getTargetSubdirectory()) ? StringUtils.cleanPath((String)a.getTargetSubdirectory()) : f_zG;
        if (string3.contains(c_fB.m_MJ((Object)"_7")) || string2.contains(c_oA.m_qD((Object)"\u0019J"))) {
            throw new FileStorageException(c_fB.m_MJ((Object)"8w\u0007x\u001dp\u00159\u0017p\u001d|Qi\u0010m\u00199\u0002i\u0014z\u0018\u007f\u0018|\u00157"));
        }
        Space space = Objects.requireNonNull(SpaceContext.getActiveSpace(), c_oA.m_qD((Object)"v\u0007C\rA\u0001\u0017\u0017G\u0005T\u0001\u0017\rDDE\u0001F\u0011^\u0016R\u0000\u0017\u0010XDB\u0014[\u000bV\u0000\u0017\u0005\u0017\u0002^\bRJ"));
        String[] stringArray = new String[5 >> 2];
        stringArray[3 >> 2] = space.getName();
        Path path = Path.of(a3.f_HH, stringArray).toAbsolutePath().normalize();
        Path path2 = path.resolve(string2).normalize();
        if (!path2.startsWith(path)) {
            Object[] objectArray = new Object[--3];
            objectArray[5 >> 3] = string2;
            objectArray[--1] = path;
            objectArray[--2] = space.getName();
            f_cI.warn(c_fB.m_MJ((Object)"!x\u0005qQm\u0003x\u0007|\u0003j\u0010uQx\u0005m\u0014t\u0001m_9$i\u001dv\u0010}Qm\u001e9\u0015|\u0003p\u0007|\u00159\u0015p\u0003|\u0012m\u001ek\b9Vb\f>Qk\u0014j\u001eu\u0007|\u00029\u001el\u0005j\u0018}\u00149\u0002i\u0010z\u00149\u0003v\u001emQ>\ndV9\u0017v\u00039\u0002i\u0010z\u00149Vb\f>"), objectArray);
            throw new FileStorageException(c_oA.m_qD((Object)"-Y\u0012V\b^\u0000\u0017\u0000^\u0016R\u0007C\u000bE\u001d\u0017\u0014V\u0010_DD\u0014R\u0007^\u0002^\u0001SJ"));
        }
        Path path3 = path2.resolve(string3).normalize();
        if (!path3.startsWith(path2)) {
            Object[] objectArray = new Object[--3];
            objectArray[5 >> 3] = string3;
            objectArray[3 & 5] = path2;
            objectArray[1 ^ 3] = space.getName();
            f_cI.warn(c_fB.m_MJ((Object)"!x\u0005qQm\u0003x\u0007|\u0003j\u0010uQx\u0005m\u0014t\u0001mQo\u0018xQ\u007f\u0018u\u0014w\u0010t\u00147Q_\u0018u\u0014w\u0010t\u00149Vb\f>Qp\u001f9\u0015p\u0003|\u0012m\u001ek\b9Vb\f>Qk\u0014j\u001eu\u0007|\u00029\u001el\u0005j\u0018}\u00149\u0017v\u00039\u0002i\u0010z\u00149Vb\f>"), objectArray);
            throw new FileStorageException(c_oA.m_qD((Object)"-Y\u0012V\b^\u0000\u0017\u0002^\bR\nV\tRDD\u0014R\u0007^\u0002^\u0001SJ"));
        }
        String string5 = path.relativize(path3).toString().replace(c_fB.m_MJ((Object)"E"), c_oA.m_qD((Object)"K"));
        if (a3.f_xH.existsByRelativePath(string5)) {
            throw new FileStorageException(c_fB.m_MJ((Object)"09\u0017p\u001d|Qn\u0018m\u00199\u0005q\u0018jQw\u0010t\u00149\u0010u\u0003|\u0010}\b9\u0014a\u0018j\u0005jQp\u001f9\u0005q\u00149\u0005x\u0003~\u0014mQu\u001ez\u0010m\u0018v\u001f7"));
        }
        try {
            Files.createDirectories(path2, new FileAttribute[3 ^ 3]);
            CopyOption[] copyOptionArray = new CopyOption[5 >> 2];
            copyOptionArray[5 >> 3] = StandardCopyOption.REPLACE_EXISTING;
            Files.copy(a22.getInputStream(), path3, copyOptionArray);
            f_cI.info(c_oA.m_qD((Object)"q\r[\u0001\u0017CL\u0019\u0010DD\u0011T\u0007R\u0017D\u0002B\b[\u001d\u0017\u0013E\rC\u0010R\n\u0017\u0010XDQ\r[\u0001D\u001dD\u0010R\t\u0017\u0005CD\u0010\u001fJC"), (Object)string3, (Object)path3);
            c_vA c_vA3 = a;
            a.setFileName(string3);
            c_vA3.setRelativePath(string5);
            c_vA3.setFileSize(Long.valueOf(a22.getSize()));
            c_vA2 = a;
            string = StringUtils.hasText((String)a22.getContentType()) ? a22.getContentType() : c_fB.m_MJ((Object)"\u0010i\u0001u\u0018z\u0010m\u0018v\u001f6\u001ez\u0005|\u00054\u0002m\u0003|\u0010t");
        }
        catch (IOException a22) {
            f_cI.error(c_oA.m_qD((Object)"t\u000bB\bSDY\u000bCDD\u0010X\u0016RDQ\r[\u0001\u0017CL\u0019\u0010DS\u0011RDC\u000b\u0017-x!O\u0007R\u0014C\rX\n"), (Object)string3, (Object)a22);
            throw new FileStorageException(c_fB.m_MJ((Object)"2v\u0004u\u00159\u001fv\u00059\u0002m\u001ek\u00149\u0005q\u00149\u0004i\u001dv\u0010}\u0014}Q\u007f\u0018u\u00147QI\u001d|\u0010j\u00149\u0005k\b9\u0010~\u0010p\u001f7"));
        }
        {
            c_vA2.setFileType(string);
            a.setTargetSubdirectory(string2);
            return (FileInfo)a3.f_xH.save((Object)a);
        }
    }

    /*
     * WARNING - void declaration
     */
    @PreAuthorize(value="hasAuthority('DELETE_FILE')")
    @Transactional
    public void m_SN(String string) {
        Path path;
        FileInfo fileInfo;
        void a;
        Object object;
        block5: {
            object = this;
            fileInfo = object.m_Ym((String)a).orElse(null);
            if (fileInfo == null) {
                return;
            }
            String[] stringArray = new String[--1];
            stringArray[3 & 4] = fileInfo.getSpace().getName();
            Path path2 = Path.of(object.f_HH, stringArray);
            path = path2.resolve(fileInfo.getRelativePath()).normalize();
            if (!Files.exists(path, new LinkOption[3 ^ 3])) break block5;
            Object a2 = fileInfo.getFileName();
            String string2 = LocalDateTime.now().format(DateTimeFormatter.ofPattern(c_oA.m_qD((Object)"\u001dN\u001dN)z\u0000S;\u007f,Z\tD\u0017")));
            Object object2 = a2;
            String string3 = "";
            int n = ((String)object2).lastIndexOf(0x2F & 0x7E);
            if (n > 0) {
                Object object3 = a2;
                object2 = ((String)object3).substring(5 >> 3, n);
                string3 = ((String)object3).substring(n);
            }
            a2 = (String)object2 + "_deleted_" + string2 + string3;
            Path path3 = path;
            a2 = path3.getParent().resolve((String)a2);
            Files.move(path3, (Path)a2, new CopyOption[3 ^ 3]);
            f_cI.info(c_fB.m_MJ((Object)"_\u0018u\u00149\u0003|\u001fx\u001c|\u00159\u0017k\u001etQ>\ndV9\u0005vQ>\ndV9\u0017v\u00039\u0015|\u001d|\u0005|"), (Object)path, a2);
        }
        try {
            f_cI.warn(c_oA.m_qD((Object)"g\fN\u0017^\u0007V\b\u0017\u0002^\bRDY\u000bCDQ\u000bB\nSDQ\u000bEDS\u0001[\u0001C\u0001\rDL\u0019"), (Object)path);
        }
        catch (IOException iOException) {
            f_cI.error(c_fB.m_MJ((Object)"2v\u0004u\u00159\u001fv\u00059\u0003|\u001fx\u001c|Q\u007f\u0018u\u00149\u0017v\u00039\u0015|\u001d|\u0005|K9\nd"), (Object)fileInfo.getFileName(), (Object)iOException);
        }
        object.f_xH.delete((Object)fileInfo);
        f_cI.info(c_oA.m_qD((Object)"q\r[\u0001\u0017\u0000R\bR\u0010R\u0000\u0017\u0002X\u0016\u0017-s^\u0017\u001fJH\u0017+E\rP\rY\u0005[Dy\u0005Z\u0001\rDL\u0019"), (Object)a, (Object)fileInfo.getFileName());
    }

    /*
     * WARNING - void declaration
     */
    @Transactional
    @PreAuthorize(value="hasAuthority('CREATE_FILE') and hasAuthority('UPDATE_LOGIN_SETTINGS')")
    public String m_vn(MultipartFile multipartFile) {
        void a22;
        c_vA c_vA2 = this;
        void v0 = a22;
        Objects.requireNonNull(v0, c_fB.m_MJ((Object)"T\u0004u\u0005p\u0001x\u0003m7p\u001d|Qz\u0010w\u001fv\u00059\u0013|Qw\u0004u\u001d7"));
        if (v0.isEmpty()) {
            throw new FileStorageException(c_oA.m_qD((Object)"'V\nY\u000bCDD\u0010X\u0016RDV\n\u0017\u0001Z\u0014C\u001d\u0017\u0002^\bRJ"));
        }
        Object a = StringUtils.cleanPath((String)Objects.requireNonNull(a22.getOriginalFilename(), c_fB.m_MJ((Object)"T\u0004u\u0005p\u0001x\u0003m7p\u001d|Qv\u0003p\u0016p\u001fx\u001d9\u0017p\u001d|\u001fx\u001c|Qz\u0010w\u001fv\u00059\u0013|Qw\u0004u\u001d7")));
        if (a.contains(c_oA.m_qD((Object)"\u0019J"))) {
            throw new FileStorageException(c_fB.m_MJ((Object)"_\u0018u\u0014w\u0010t\u00149\u0012v\u001fm\u0010p\u001fjQp\u001fo\u0010u\u0018}Qi\u0010m\u00199\u0002|\u0000l\u0014w\u0012|Q>_7V7"));
        }
        Path path = Path.of(c_vA2.f_HH, new String[3 & 4]).toAbsolutePath().normalize().resolve(f_Nh).normalize();
        Path path2 = path.resolve((String)a).normalize();
        if (!path2.startsWith(path)) {
            throw new FileStorageException(c_oA.m_qD((Object)"~\nA\u0005[\rSD[\u000bP\rYD^\tV\u0003RDG\u0005C\f"));
        }
        try {
            Files.createDirectories(path, new FileAttribute[3 & 4]);
            CopyOption[] copyOptionArray = new CopyOption[--1];
            copyOptionArray[3 >> 2] = StandardCopyOption.REPLACE_EXISTING;
            Files.copy(a22.getInputStream(), path2, copyOptionArray);
            f_cI.info(c_fB.m_MJ((Object)"U\u001e~\u0018wQp\u001cx\u0016|Q>\ndV9\u0002l\u0012z\u0014j\u0002\u007f\u0004u\u001d`Qn\u0003p\u0005m\u0014wQm\u001e9\u0017p\u001d|\u0002`\u0002m\u0014tQx\u00059Vb\f>"), a, (Object)path2);
            return a;
        }
        catch (IOException a22) {
            throw new FileStorageException("Could not store login image " + (String)a + ". Please try again!", (Throwable)a22);
        }
    }

    @PreAuthorize(value="hasAuthority('VIEW_FILE')")
    public FileInfo m_In(String string) {
        Object a = string;
        c_vA a2 = this;
        return a2.f_xH.findOneByName((String)a);
    }

    /*
     * WARNING - void declaration
     */
    public c_vA(FileInfoRepository fileInfoRepository, ModelUpdater modelUpdater, @Value(value="${ins.files.path}") String string) {
        void modelUpdater2;
        void fileInfoRepository2;
        c_vA a;
        c_vA c_vA2 = object;
        Object object = string;
        c_vA c_vA3 = a = c_vA2;
        a.f_xH = fileInfoRepository2;
        c_vA3.f_gi = modelUpdater2;
        c_vA3.f_HH = object;
    }

    @PreAuthorize(value="hasAuthority('VIEW_FILE')")
    public List<FileInfo> m_AN() {
        c_vA a;
        return a.f_xH.findAll();
    }

    /*
     * WARNING - void declaration
     */
    @Transactional
    @PreAuthorize(value="hasAuthority('UPDATE_FILE')")
    public FileInfo m_BO(String string, MultipartFile multipartFile, FileInfo fileInfo) {
        String string2;
        String string3;
        void a;
        int n;
        Object object;
        c_vA a2;
        void a3;
        c_vA c_vA2;
        block12: {
            int n2;
            void v2;
            void a222;
            c_vA2 = this;
            Objects.requireNonNull(a3, c_fB.m_MJ((Object)"$i\u0015x\u0005|\u00159\u001c|\u0005x\u0015x\u0005xQ17p\u001d|8w\u0017vX9\u001e{\u001b|\u0012mQz\u0010w\u001fv\u00059\u0013|Qw\u0004u\u001d7"));
            a2 = c_vA2.m_jn((String)a222);
            String[] stringArray = new String[5 >> 2];
            stringArray[2 & 5] = a2.getSpace().getName();
            object = Path.of(c_vA2.f_HH, stringArray).toAbsolutePath().normalize();
            Path path = object.resolve(a2.getRelativePath()).normalize();
            int n3 = n = a != null && !a.isEmpty() ? 3 & 5 : 0;
            if (n != 0) {
                string3 = StringUtils.cleanPath((String)Objects.requireNonNull(a.getOriginalFilename(), c_oA.m_qD((Object)"z\u0011[\u0010^\u0014V\u0016C\"^\bRDX\u0016^\u0003^\nV\b\u0017\u0002^\bR\nV\tRDT\u0005Y\nX\u0010\u0017\u0006RDY\u0011[\b\u0017\u0013_\u0001YDE\u0001G\bV\u0007^\nPDT\u000bY\u0010R\nCJ")));
                v2 = a3;
            } else {
                string3 = a2.getFileName();
                v2 = a3;
            }
            String string4 = StringUtils.hasText((String)v2.getTargetSubdirectory()) ? StringUtils.cleanPath((String)a3.getTargetSubdirectory()) : (string2 = StringUtils.hasText((String)a2.getTargetSubdirectory()) ? a2.getTargetSubdirectory() : f_zG);
            if (string3.contains(c_fB.m_MJ((Object)"_7")) || string2.contains(c_oA.m_qD((Object)"\u0019J"))) {
                throw new FileStorageException(c_fB.m_MJ((Object)"P\u001fo\u0010u\u0018}Qi\u0010m\u00199\u0002i\u0014z\u0018\u007f\u0018|\u00159\u0018wQl\u0001}\u0010m\u00149\u0003|\u0000l\u0014j\u00057"));
            }
            Path path2 = object.resolve(string2).normalize();
            if (!path2.startsWith((Path)object)) {
                f_cI.warn(c_oA.m_qD((Object)"4V\u0010_DC\u0016V\u0012R\u0016D\u0005[DV\u0010C\u0001Z\u0014CJ\u0017*R\u0013\u0017\u0010V\u0016P\u0001CDD\u0011U\u0000^\u0016R\u0007C\u000bE\u001d\u0017CL\u0019\u0010DE\u0001D\u000b[\u0012R\u0017\u0017\u000bB\u0010D\rS\u0001\u0017\u0017G\u0005T\u0001\u0017\u0016X\u000bCD\u0010\u001fJC"), (Object)string2, object);
                throw new FileStorageException(c_fB.m_MJ((Object)"P\u001fo\u0010u\u0018}Q}\u0018k\u0014z\u0005v\u0003`Qi\u0010m\u00199\u0002i\u0014z\u0018\u007f\u0018|\u00157"));
            }
            Path path3 = path2.resolve(string3).normalize();
            if (!path3.startsWith(path2)) {
                f_cI.warn(c_oA.m_qD((Object)"4V\u0010_DC\u0016V\u0012R\u0016D\u0005[DV\u0010C\u0001Z\u0014CDA\rVDY\u0001@DQ\r[\u0001Y\u0005Z\u0001\u0019Dq\r[\u0001Y\u0005Z\u0001\u0017CL\u0019\u0010D^\n\u0017\u0000^\u0016R\u0007C\u000bE\u001d\u0017CL\u0019\u0010DE\u0001D\u000b[\u0012R\u0017\u0017\u000bB\u0010D\rS\u0001"), (Object)string3, (Object)path2);
                throw new FileStorageException(c_fB.m_MJ((Object)"P\u001fo\u0010u\u0018}Q\u007f\u0018u\u0014w\u0010t\u00149\u0002i\u0014z\u0018\u007f\u0018|\u00157"));
            }
            int n4 = n2 = !((String)(object = object.relativize(path3).toString().replace(c_oA.m_qD((Object)"8"), c_fB.m_MJ((Object)"6")))).equals(a2.getRelativePath()) ? 3 & 5 : 0;
            if (n2 != 0 && c_vA2.f_xH.existsByRelativePathAndIdNot((String)object, (String)a222)) {
                throw new FileStorageException(c_oA.m_qD((Object)"vDQ\r[\u0001\u0017\u0013^\u0010_DC\f^\u0017\u0017\nV\tRDV\bE\u0001V\u0000NDR\u001c^\u0017C\u0017\u0017\u0005CDC\fRDC\u0005E\u0003R\u0010\u0017\bX\u0007V\u0010^\u000bYJ"));
            }
            try {
                if (n != 0) {
                    if (Files.exists(path, new LinkOption[2 & 5])) {
                        Files.deleteIfExists(path);
                        f_cI.info(c_fB.m_MJ((Object)">u\u00159\u0017p\u001d|Qz\u001ew\u0005|\u001fmQ}\u0014u\u0014m\u0014}Q\u007f\u0003v\u001c9\u0017p\u001d|\u0002`\u0002m\u0014tK9\nd"), (Object)path);
                    }
                    Files.createDirectories(path2, new FileAttribute[3 >> 2]);
                    CopyOption[] copyOptionArray = new CopyOption[3 >> 1];
                    copyOptionArray[3 >> 2] = StandardCopyOption.REPLACE_EXISTING;
                    Files.copy(a.getInputStream(), path3, copyOptionArray);
                    f_cI.info(c_oA.m_qD((Object)"y\u0001@DQ\r[\u0001\u0017\u0007X\nC\u0001Y\u0010\u0017\u0002X\u0016\u0017CL\u0019\u0010DD\u0011T\u0007R\u0017D\u0002B\b[\u001d\u0017\u0013E\rC\u0010R\n\u0017\u0010XDQ\r[\u0001D\u001dD\u0010R\t\u0017\u0005CD\u0010\u001fJC"), (Object)string3, (Object)path3);
                    break block12;
                }
                if (n2 == 0) break block12;
                if (Files.exists(path, new LinkOption[3 >> 2])) {
                    Files.createDirectories(path2, new FileAttribute[0]);
                    CopyOption[] copyOptionArray = new CopyOption[1];
                    copyOptionArray[0] = StandardCopyOption.REPLACE_EXISTING;
                    Files.move(path, path3, copyOptionArray);
                    f_cI.info(c_fB.m_MJ((Object)"7p\u001d|Qt\u001eo\u0014}Q\u007f\u0003v\u001c9\ndQm\u001e9\nd"), (Object)path, (Object)path3);
                    break block12;
                }
                f_cI.warn(c_oA.m_qD((Object)"x\bSDQ\r[\u0001\u0017\nX\u0010\u0017\u0002X\u0011Y\u0000\u0017\u0005CDL\u0019\u0017\u0002X\u0016\u0017\tX\u0012RDX\u0014R\u0016V\u0010^\u000bYH\u0017\u0006B\u0010\u0017\tR\u0010V\u0000V\u0010VDR\u001c^\u0017C\u0001SJ"), (Object)path);
                throw new NotFoundException(c_fB.m_MJ((Object)"7p\u001d|Qw\u001emQ\u007f\u001el\u001f}Q\u007f\u001ekQl\u0001}\u0010m\u00149\u001ei\u0014k\u0010m\u0018v\u001f7"));
            }
            catch (IOException a222) {
                f_cI.error(c_oA.m_qD((Object)"'X\u0011[\u0000\u0017\nX\u0010\u0017\u0011G\u0000V\u0010RDQ\r[\u0001\u0017CL\u0019\u0010DS\u0011RDC\u000b\u0017-x!O\u0007R\u0014C\rX\n"), (Object)a2.getFileName(), (Object)a222);
                throw new FileStorageException(c_fB.m_MJ((Object)"2v\u0004u\u00159\u001fv\u00059\u0004i\u0015x\u0005|Qm\u0019|Q\u007f\u0018u\u00147QI\u001d|\u0010j\u00149\u0005k\b9\u0010~\u0010p\u001f7"));
            }
        }
        c_vA c_vA3 = a2;
        c_vA c_vA4 = a2;
        c_vA4.setName(a3.getName());
        c_vA4.setDsc(a3.getDsc());
        c_vA3.setFileName(string3);
        c_vA3.setTargetSubdirectory(string2);
        a2.setRelativePath((String)object);
        if (n != 0) {
            c_vA c_vA5 = a2;
            c_vA5.setFileSize(Long.valueOf(a.getSize()));
            c_vA5.setFileType(StringUtils.hasText((String)a.getContentType()) ? a.getContentType() : c_oA.m_qD((Object)"V\u0014G\b^\u0007V\u0010^\u000bYKX\u0007C\u0001CID\u0010E\u0001V\t"));
        }
        return (FileInfo)c_vA2.f_xH.save((Object)a2);
    }

    @PreAuthorize(value="hasAuthority('VIEW_FILE')")
    public Optional<FileInfo> m_dm(String string) {
        Object a = string;
        c_vA a2 = this;
        return a2.f_xH.findByRelativePath((String)a);
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @PreAuthorize(value="hasAuthority('CREATE_FILE') and hasAuthority('UPDATE_FILE')")
    public void m_oM(ZipFile zipFile, FileInfo fileInfo) {
        void a3222;
        InputStream a22;
        c_vA c_vA2 = this;
        ZipEntry zipEntry = ((ZipFile)((Object)a22)).getEntry(a3222.getFileName());
        if (zipEntry == null) return;
        Objects.requireNonNull(a3222, c_fB.m_MJ((Object)"_\u0018u\u0014P\u001f\u007f\u001e9\u001e{\u001b|\u0012mQz\u0010w\u001fv\u00059\u0013|Qw\u0004u\u001d7"));
        Object a = zipEntry.getName();
        if (((String)a).trim().isEmpty()) {
            throw new FileStorageException(c_oA.m_qD((Object)">^\u0014\u0017\u0001Y\u0010E\u001d\u0017\nV\tRDT\u0005Y\nX\u0010\u0017\u0006RDR\tG\u0010NJ"));
        }
        if (((String)a).contains(c_fB.m_MJ((Object)"_7")) || ((String)a).startsWith(c_oA.m_qD((Object)"K")) || ((String)a).startsWith(c_fB.m_MJ((Object)"E")) || ((String)a).contains(c_oA.m_qD((Object)"\rK")) || ((String)a).contains(c_fB.m_MJ((Object)"KE"))) {
            f_cI.warn(c_oA.m_qD((Object)">^\u0014\u0017\u0017[\rGDV\u0010C\u0001Z\u0014CDS\u0001C\u0001T\u0010R\u0000\u0017\rYDR\nC\u0016NDY\u0005Z\u0001\rD\u0010\u001fJC"), a);
            throw new FileStorageException(c_fB.m_MJ((Object)"+p\u00019\u0014w\u0005k\b9\u0012v\u001fm\u0010p\u001fjQp\u001fo\u0010u\u0018}Qi\u0010m\u00199\u0002|\u0000l\u0014w\u0012|Qm\u0019x\u00059\u0012v\u0004u\u00159\u001d|\u0010}Qm\u001e9\u0015p\u0003|\u0012m\u001ek\b9\u0005k\u0010o\u0014k\u0002x\u001d7"));
        }
        Object object = ((String)a).replace((char)(0x5E & 0x7D), (char)(0x7F & 0x2F));
        if (((String)object).contains(c_oA.m_qD((Object)"J\u0019K")) || ((String)object).contains(c_fB.m_MJ((Object)"6_7")) || ((String)object).equals(c_oA.m_qD((Object)"\u0019J"))) {
            f_cI.warn(c_fB.m_MJ((Object)"+p\u00019\u0002u\u0018iQx\u0005m\u0014t\u0001mQ}\u0014m\u0014z\u0005|\u00159\u0018wQw\u001ek\u001cx\u001dp\u000b|\u00159\u0014w\u0005k\b9\u001fx\u001c|K9Vb\f>"), object);
            throw new FileStorageException(c_oA.m_qD((Object)">^\u0014\u0017\u0001Y\u0010E\u001d\u0017\u0007X\nC\u0005^\nDDS\rE\u0001T\u0010X\u0016NDC\u0016V\u0012R\u0016D\u0005[DD\u0001F\u0011R\nT\u0001DJ"));
        }
        Object object2 = object;
        int n = ((String)object2).lastIndexOf(0x7F & 0x2F);
        if (n >= 0) {
            object2 = ((String)object).substring(n + (3 >> 1));
        }
        if (((String)object2).isEmpty() || ((String)object2).equals(c_fB.m_MJ((Object)"7")) || ((String)object2).equals(c_oA.m_qD((Object)"\u0019J"))) {
            throw new FileStorageException("Invalid filename extracted from zip entry: " + (String)a);
        }
        if (((String)(object2 = StringUtils.cleanPath((String)object2))).contains(c_fB.m_MJ((Object)"_7"))) {
            throw new FileStorageException(c_oA.m_qD((Object)"q\r[\u0001Y\u0005Z\u0001\u0017\u0007X\nC\u0005^\nDD^\nA\u0005[\rSDG\u0005C\f\u0017\u0017R\u0015B\u0001Y\u0007RD\u0010J\u0019C\u0017\u0005Q\u0010R\u0016\u0017\u0007[\u0001V\n^\nPJ"));
        }
        String string = a = StringUtils.hasText((String)a3222.getTargetSubdirectory()) ? StringUtils.cleanPath((String)a3222.getTargetSubdirectory()) : f_zG;
        if (((String)a).contains(c_fB.m_MJ((Object)"_7"))) {
            throw new FileStorageException(c_oA.m_qD((Object)"c\u0005E\u0003R\u0010\u0017\u0017B\u0006S\rE\u0001T\u0010X\u0016NDT\u000bY\u0010V\rY\u0017\u0017\rY\u0012V\b^\u0000\u0017\u0014V\u0010_DD\u0001F\u0011R\nT\u0001\u0017C\u0019J\u0010J"));
        }
        Space a3222 = Objects.requireNonNull(SpaceContext.getActiveSpace(), c_fB.m_MJ((Object)"0z\u0005p\u0007|Qj\u0001x\u0012|Qp\u00029\u0003|\u0000l\u0018k\u0014}Qm\u001e9\u0004i\u001dv\u0010}QxQ\u007f\u0018u\u00147"));
        String[] stringArray = new String[--1];
        stringArray[5 >> 3] = a3222.getName();
        object = Path.of(c_vA2.f_HH, stringArray).toAbsolutePath().normalize();
        Path path = object.resolve((String)a).normalize();
        if (!path.startsWith((Path)object)) {
            Object[] objectArray = new Object[--3];
            objectArray[3 ^ 3] = a;
            objectArray[--1] = object;
            objectArray[--2] = a3222.getName();
            f_cI.warn(c_oA.m_qD((Object)"g\u0005C\f\u0017\u0010E\u0005A\u0001E\u0017V\b\u0017\u0005C\u0010R\tG\u0010\u0019Db\u0014[\u000bV\u0000\u0017\u0010XDS\u0001E\rA\u0001SDS\rE\u0001T\u0010X\u0016ND\u0010\u001fJC\u0017\u0016R\u0017X\bA\u0001DDX\u0011C\u0017^\u0000RDD\u0014V\u0007RDE\u000bX\u0010\u0017CL\u0019\u0010DQ\u000bEDD\u0014V\u0007RD\u0010\u001fJC"), objectArray);
            throw new FileStorageException(c_fB.m_MJ((Object)"P\u001fo\u0010u\u0018}Q}\u0014k\u0018o\u0014}Qi\u0010m\u00199\u0002i\u0014z\u0018\u007f\u0018|\u00157QX\u0005m\u0014t\u0001mQm\u001e9\u0010z\u0012|\u0002jQv\u0004m\u0002p\u0015|Q}\u0014j\u0018~\u001fx\u0005|\u00159\u0015p\u0003|\u0012m\u001ek\b7"));
        }
        a = path.resolve((String)object2).normalize();
        if (!a.startsWith(path)) {
            Object[] objectArray = new Object[--3];
            objectArray[2 & 5] = object2;
            objectArray[--1] = path;
            objectArray[1 ^ 3] = a3222.getName();
            f_cI.warn(c_oA.m_qD((Object)"g\u0005C\f\u0017\u0010E\u0005A\u0001E\u0017V\b\u0017\u0005C\u0010R\tG\u0010\u0017\u0012^\u0005\u0017\u0002^\bR\nV\tRJ\u0017\"^\bR\nV\tRD\u0010\u001fJC\u0017\rYDS\rE\u0001T\u0010X\u0016ND\u0010\u001fJC\u0017\u0016R\u0017X\bA\u0001DDX\u0011C\u0017^\u0000RDQ\u000bEDD\u0014V\u0007RD\u0010\u001fJC"), objectArray);
            throw new FileStorageException("Invalid file name results in path traversal: " + (String)object2);
        }
        if (!a.startsWith((Path)object)) {
            Object[] objectArray = new Object[--3];
            objectArray[5 >> 3] = a;
            objectArray[3 & 5] = object;
            objectArray[5 >> 1] = a3222.getName();
            f_cI.warn(c_fB.m_MJ((Object)"7p\u001fx\u001d9\u0002|\u0012l\u0003p\u0005`Qz\u0019|\u0012rQ\u007f\u0010p\u001d|\u00157QM\u0010k\u0016|\u00059\u0017p\u001d|Qi\u0010m\u00199Vb\f>Qp\u00029\u001el\u0005j\u0018}\u00149\u0002i\u0010z\u00149\u0003v\u001emQ>\ndV9\u0017v\u00039\u0002i\u0010z\u00149Vb\f>"), objectArray);
            throw new FileStorageException(c_oA.m_qD((Object)"0V\u0016P\u0001CDQ\r[\u0001\u0017\u0014V\u0010_DE\u0001D\u000b[\u0012R\u0017\u0017\u000bB\u0010D\rS\u0001\u0017\u0000R\u0017^\u0003Y\u0005C\u0001SDD\u0014V\u0007RDS\rE\u0001T\u0010X\u0016NJ"));
        }
        String a3222 = object.relativize((Path)a).toString().replace(c_fB.m_MJ((Object)"E"), c_oA.m_qD((Object)"K"));
        if (c_vA2.f_xH.existsByRelativePath(a3222)) {
            f_cI.info("A file already exists at path: " + a3222);
            return;
        }
        try {
            Files.createDirectories(path, new FileAttribute[0]);
            a22 = ((ZipFile)((Object)a22)).getInputStream(zipEntry);
            try {
                CopyOption[] copyOptionArray = new CopyOption[1];
                copyOptionArray[0] = StandardCopyOption.REPLACE_EXISTING;
                Files.copy(a22, (Path)a, copyOptionArray);
                f_cI.info(c_fB.m_MJ((Object)"7p\u001d|Q>\ndV9\u0002l\u0012z\u0014j\u0002\u007f\u0004u\u001d`Qn\u0003p\u0005m\u0014wQm\u001e9\u0017p\u001d|\u0002`\u0002m\u0014tQx\u00059Vb\f>"), object2, a);
                if (a22 == null) return;
            }
            catch (Throwable throwable) {
                Throwable throwable2;
                if (a22 != null) {
                    try {
                        a22.close();
                        throwable2 = throwable;
                        throw throwable2;
                    }
                    catch (Throwable a3222) {
                        throwable.addSuppressed(a3222);
                    }
                }
                throwable2 = throwable;
                throw throwable2;
            }
            a22.close();
            return;
        }
        catch (IOException a22) {
            throw new FileStorageException("Could not store file " + (String)object2 + ". Please try again!", (Throwable)a22);
        }
    }

    @PreAuthorize(value="hasAuthority('VIEW_FILE')")
    public FileInfo m_GM(String string) {
        Object a = string;
        c_vA a2 = this;
        return (FileInfo)a2.m_dm((String)a).orElseThrow(() -> c_vA.m_Eo((String)a));
    }

    @PreAuthorize(value="hasAuthority('VIEW_FILE')")
    public FileDownloadResult m_Nn(String string) {
        Path path;
        block3: {
            c_vA a;
            Object a2 = string;
            c_vA c_vA2 = a = this;
            a2 = c_vA2.m_GM((String)a2);
            String[] stringArray = new String[--1];
            stringArray[3 ^ 3] = a2.getSpace().getName();
            path = Path.of(c_vA2.f_HH, stringArray).resolve(a2.getRelativePath()).normalize();
            try {
                UrlResource urlResource = new UrlResource(path.toUri());
                if (!urlResource.exists() || !urlResource.isReadable()) break block3;
                return new FileDownloadResult((Resource)urlResource, (FileInfo)a2);
            }
            catch (MalformedURLException malformedURLException) {
                throw new NotFoundException(c_oA.m_qD((Object)"\"^\bRDY\u000bCDQ\u000bB\nSD\u001f\tV\bQ\u000bE\tR\u0000\u00171e(\u001eJ"));
            }
        }
        f_cI.error(c_oA.m_qD((Object)"q\r[\u0001\u0017\tR\u0010V\u0000V\u0010VDR\u001c^\u0017C\u0017\u0017\u0002X\u0016\u0017CL\u0019\u0010DU\u0011CDQ\r[\u0001\u0017\rDDZ\rD\u0017^\nPDX\n\u0017\u0000^\u0017\\J"), (Object)path);
        throw new NotFoundException(c_fB.m_MJ((Object)"7p\u001d|Qw\u001emQ\u007f\u001el\u001f}"));
    }

    @Transactional
    @PreAuthorize(value="hasAuthority('CREATE_FILE') and hasAuthority('UPDATE_FILE')")
    public FileInfo m_zo(FileInfo fileInfo) {
        FileInfo fileInfo2;
        c_vA a = fileInfo;
        c_vA a2 = this;
        Object object = a.getId() != null ? a2.m_so(a.getId()) : (fileInfo2 = StringUtils.hasText((String)a.getName()) ? a2.m_In(a.getName()) : null);
        if (fileInfo2 != null) {
            a2.f_gi.copyForUpdate((Object)a, (SpaceBaseModel)fileInfo2, new String[3 ^ 3]);
            return fileInfo2;
        }
        return (FileInfo)a2.f_xH.save((Object)a);
    }

    @PreAuthorize(value="hasAuthority('VIEW_FILE')")
    public FileInfo m_jn(String string) {
        Object a = string;
        c_vA a2 = this;
        return (FileInfo)a2.m_Ym((String)a).orElseThrow(() -> c_vA.m_QO((String)a));
    }

    @Transactional
    @PreAuthorize(value="hasAuthority('VIEW_FILE') and hasAuthority('CREATE_FILE')")
    public FileInfo m_dn(String string) {
        FileInfo a;
        c_vA c_vA2 = this;
        Objects.requireNonNull(a, c_fB.m_MJ((Object)">k\u0018~\u0018w\u0010uQ\u007f\u0018u\u001498]Qz\u0010w\u001fv\u00059\u0013|Qw\u0004u\u001d7"));
        a = c_vA2.m_jn((String)a);
        long l = System.currentTimeMillis();
        String string2 = a.getFileName();
        Object a22 = "";
        String string3 = string2;
        int n = string3.lastIndexOf(0x6E & 0x3F);
        if (n > 0) {
            String string4 = string2;
            string3 = string4.substring(2 & 5, n);
            a22 = string4.substring(n);
        }
        if ((string2 = StringUtils.cleanPath((String)(string3 + "_clone_" + l + (String)a22))).contains(c_oA.m_qD((Object)"\u0019J"))) {
            throw new FileStorageException(c_fB.m_MJ((Object)"^\u0014w\u0014k\u0010m\u0014}Q\u007f\u0018u\u0014w\u0010t\u00149\u0012v\u001fm\u0010p\u001fjQp\u001fo\u0010u\u0018}Qi\u0010m\u00199\u0002|\u0000l\u0014w\u0012|Q>_7V7"));
        }
        a22 = Objects.requireNonNull(SpaceContext.getActiveSpace(), c_oA.m_qD((Object)"%T\u0010^\u0012RDD\u0014V\u0007RD^\u0017\u0017\u0016R\u0015B\rE\u0001SDC\u000b\u0017\u0007[\u000bY\u0001\u0017\u0005\u0017\u0002^\bRJ"));
        String[] stringArray = new String[3 & 5];
        stringArray[3 ^ 3] = a22.getName();
        a22 = Path.of(c_vA2.f_HH, stringArray).toAbsolutePath().normalize();
        Path path = a22.resolve(string3 = StringUtils.hasText((String)a.getTargetSubdirectory()) ? a.getTargetSubdirectory() : f_zG).normalize();
        Path path2 = path.resolve(string2).normalize();
        if (!path2.startsWith(path)) {
            throw new FileStorageException("Generated filename results in path traversal: " + string2);
        }
        String string5 = a22.relativize(path2).toString().replace(c_fB.m_MJ((Object)"E"), c_oA.m_qD((Object)"K"));
        if (c_vA2.f_xH.existsByRelativePath(string5)) {
            throw new FileStorageException("A file already exists at generated path: " + string5);
        }
        a22 = a22.resolve(a.getRelativePath()).normalize();
        try {
            Files.createDirectories(path, new FileAttribute[3 >> 2]);
            CopyOption[] copyOptionArray = new CopyOption[--1];
            copyOptionArray[3 & 4] = StandardCopyOption.REPLACE_EXISTING;
            Files.copy((Path)a22, path2, copyOptionArray);
            f_cI.info(c_fB.m_MJ((Object)"_\u0018u\u00149\u0012u\u001ew\u0014}Q\u007f\u0003v\u001c9Vb\f>Qm\u001e9Vb\f>"), a22, (Object)path2);
        }
        catch (IOException a22) {
            throw new FileStorageException("Could not clone file: " + a.getFileName(), (Throwable)a22);
        }
        a22 = a.getName() + "_clone_" + l;
        Path path3 = path = new FileInfo();
        path3.setName((String)a22);
        path3.setDsc("Clone of " + a.getName());
        Path path4 = path;
        FileInfo fileInfo = a;
        Path path5 = path;
        path5.setFileName(string2);
        path5.setRelativePath(string5);
        path.setFileSize(fileInfo.getFileSize());
        path4.setFileType(fileInfo.getFileType());
        path4.setTargetSubdirectory(string3);
        return (FileInfo)c_vA2.f_xH.save((Object)path);
    }
}

