/*
 * Decompiled with CFR 0.152.
 */
package com.inscada.mono.datatransfer.services;

import com.inscada.mono.auth.c_oL;
import com.inscada.mono.cluster.exceptions.ClusterRpcException;
import com.inscada.mono.cluster.services.ClusterNodeListener;
import com.inscada.mono.cluster.services.c_b;
import com.inscada.mono.communication.base.model.Variable;
import com.inscada.mono.communication.base.model.values.NumberVariableValue;
import com.inscada.mono.communication.base.model.values.VariableValue;
import com.inscada.mono.communication.base.model.values.logged.LoggedVariableValueStats;
import com.inscada.mono.communication.base.p.c_Pl;
import com.inscada.mono.communication.base.p.c_wL;
import com.inscada.mono.communication.base.services.c_QH;
import com.inscada.mono.communication.base.services.c_SI;
import com.inscada.mono.communication.base.services.c_Zh;
import com.inscada.mono.config.c_wA;
import com.inscada.mono.datatransfer.m.c_kC;
import com.inscada.mono.datatransfer.m.c_ob;
import com.inscada.mono.datatransfer.model.DataTransfer;
import com.inscada.mono.datatransfer.model.DataTransferDetail;
import com.inscada.mono.datatransfer.model.DataTransferSummary;
import com.inscada.mono.datatransfer.p.c_uA;
import com.inscada.mono.datatransfer.services.c_dd;
import com.inscada.mono.datatransfer.services.c_nd;
import com.inscada.mono.job.model.Job;
import com.inscada.mono.job.model.PeriodicJob;
import com.inscada.mono.job.p.c_nB;
import com.inscada.mono.log.m.c_ac;
import com.inscada.mono.project.m.c_E;
import com.inscada.mono.shared.exceptions.NotActiveException;
import com.inscada.mono.shared.model.BaseModel;
import com.inscada.mono.shared.model.OwnedSpaceBaseModel;
import jakarta.annotation.PostConstruct;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Component;
import org.springframework.transaction.event.TransactionalEventListener;
import redis.clients.jedis.JedisPooled;

@Component
public class DataTransferManager
implements ClusterNodeListener,
c_E {
    private final c_QH f_GH;
    public static final short f_FI = 402;
    private final c_SI f_th;
    private final c_Zh f_zI;
    private final Lock f_WI;
    private final c_b f_NH;
    private static final String f_lh = "scheduledDataTransfers";
    private final JedisPooled f_UI;
    private static final Logger f_QI = LoggerFactory.getLogger(DataTransferManager.class);
    public static final short f_AI = 405;
    private final c_nB f_Hh;
    public static final short f_bI = 401;
    public static final short f_aj = 406;
    private final c_ac f_lG;
    private final c_oL f_BG;
    private final Map<String, Job> f_LG;
    public static final short f_Ki = 403;
    public static final short f_uh = 407;
    public static final short f_ui = 404;
    private final c_dd f_yi;

    public void notLeader() {
        DataTransferManager dataTransferManager;
        DataTransferManager dataTransferManager2 = dataTransferManager = this;
        Object a = dataTransferManager2.f_NH.m_ja();
        f_QI.info(c_wA.m_hr((Object)"QsasA`t|ftp`Xs{srwg(5F}{f2{}qw5:no<2|a5\\Z2Y][UP@5F]W5^PSQWG<5Qt|vwy~||r2t~y2y}vsy2qsas5fgs{aswg2\u007f}wa;<;"), a);
        dataTransferManager2.f_WI.lock();
        try {
            new ArrayList(dataTransferManager.f_LG.keySet()).forEach(arg_0 -> dataTransferManager.lambda$notLeader$2((String)a, arg_0));
            dataTransferManager.f_LG.clear();
            f_QI.info(Job.m_UM((Object)"l6\\6|%I9[1M%e6F6O2Zw\u0000\u0019G#\b\u001bM6L2ZwS*\u0001m\b\u0016D;\b;G4I;\b3I#Iw\\%I9[1M%\b=G5[w@6^2\b5M2FwZ2Y\"M$\\2Lw\\8\b4I9K2DwI9LwK;M6Z2LwN%G:\b;G4I;\b#Z6K<A9Oy"), a);
            return;
        }
        catch (Exception exception) {
            Object[] objectArray = new Object[--3];
            objectArray[3 & 4] = a;
            objectArray[4 ^ 5] = exception.getMessage();
            objectArray[--2] = exception;
            f_QI.error(c_wA.m_hr((Object)"VtftFgs{aswg_t|tup`5:[}a2Ywtvp`5ih;/2P`g}g2qgg{{u5bg}vwfa5}s2vs{qp~y{{u5~zqt~5vtft2a`t|ftp`5xzpf(5ih"), objectArray);
            return;
        }
        finally {
            dataTransferManager.f_WI.unlock();
        }
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void lambda$handleStatValues$16(Map map, Map map2, Map map3, Map map4, DataTransferDetail dataTransferDetail) {
        Variable a;
        DataTransferManager a2;
        Object a3;
        DataTransferManager dataTransferManager = dataTransferManager2;
        DataTransferManager dataTransferManager2 = dataTransferDetail;
        DataTransferManager a4 = dataTransferManager;
        if ((a3 = (LoggedVariableValueStats)a3.get(a2.getSourceVariableId())) != null && (a = (Variable)a.get(a2.getTargetVariableId())) != null) {
            String a5;
            double d = a4.extractValue(a3, a2.getCalcType());
            a3 = (VariableValue)a5.get(a2.getTargetVariableId());
            DataTransferManager dataTransferManager3 = a4;
            a5 = dataTransferManager3.buildStatCacheKey((DataTransferDetail)a2);
            String string = dataTransferManager3.buildStatLastCalcTimeKey((DataTransferDetail)a2);
            int n = dataTransferManager3.getMaxTTLForRangeType(a2.getRangeType());
            dataTransferManager3.f_UI.setex(a5, (long)n, String.valueOf(d));
            a4.f_UI.setex(string, (long)n, String.valueOf(System.currentTimeMillis()));
            if (dataTransferManager3.isValueInThresholdRange(a2.getThreshold(), Double.valueOf(d), (VariableValue)a3)) {
                void a6;
                a3 = new HashMap<String, Double>();
                a3.put(Job.m_UM((Object)"!I;]2"), d);
                a6.put(a.getName(), a3);
            }
        }
    }

    private /* synthetic */ void lambda$scheduleDataTransferInternal$5(DataTransfer dataTransfer) {
        DataTransferManager a = dataTransfer;
        DataTransferManager a2 = this;
        a2.f_WI.lock();
        try {
            a2.cancelDataTransferInternal((DataTransfer)a);
            if (!Boolean.TRUE.equals(a.getProject().getIsActive())) {
                throw new NotActiveException("Project should be active to schedule data transfer " + a.getName());
            }
            Object[] objectArray = new Object[5 >> 2];
            objectArray[3 & 4] = a.getName();
            PeriodicJob periodicJob = a2.f_Hh.m_nn(a.getProject(), Job.m_UM((Object)"\r$\b\u0013I#Iw|%I9[1M%").formatted(objectArray), () -> a2.lambda$scheduleDataTransferInternal$4((DataTransfer)a), Duration.ofMillis(a.getPeriod().intValue()));
            DataTransferManager dataTransferManager = a2;
            dataTransferManager.f_LG.put(a.getId(), periodicJob);
            String[] stringArray = new String[2 ^ 3];
            stringArray[3 & 4] = a.getId();
            dataTransferManager.f_UI.sadd(f_lh, stringArray);
            return;
        }
        finally {
            a2.f_WI.unlock();
        }
    }

    /*
     * WARNING - void declaration
     */
    @PreAuthorize(value="hasAuthority('VIEW_DATA_TRANSFER')")
    public c_uA getDataTransferStatus(String string, String string2) {
        void a;
        Object a2 = string;
        DataTransferManager a3 = this;
        if ((a2 = a3.f_yi.m_Sm((String)a2, (String)a)) == null) {
            return c_uA.f_ZH;
        }
        return a3.getDataTransferStatus(a2.getId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void leader() {
        DataTransferManager dataTransferManager;
        DataTransferManager dataTransferManager2 = dataTransferManager = this;
        Object a = dataTransferManager2.f_NH.m_ja();
        f_QI.info(Job.m_UM((Object)"l6\\6|%I9[1M%e6F6O2Zm\b\u0003@>[wF8L2\b\u007fS*\u0001w@6[wJ2K8E2\b#@2\b\u001bm\u0016l\u0012zy\b\u0005M$\\8Z>F0\b$K?M3];M3\b3I#Iw\\%I9[1M%[y\u0006y"), a);
        dataTransferManager2.f_WI.lock();
        try {
            HashSet hashSet = new HashSet(dataTransferManager.f_UI.smembers(f_lh));
            if (hashSet.isEmpty()) {
                f_QI.info(c_wA.m_hr((Object)"QsasA`t|ftp`Xs{srwg2=^psqwg2no<(5\\z2fq}wqgywq2qsas5fgs{aswga5tzg{v5{{2Gwq{f2a}5`paa}gw;"), a);
                return;
            }
            Object[] objectArray = new Object[--3];
            objectArray[3 & 4] = a;
            objectArray[3 & 5] = hashSet.size();
            objectArray[5 >> 1] = hashSet;
            f_QI.info(Job.m_UM((Object)"\u0013I#I\u0003Z6F$N2Z\u001aI9I0M%\b\u007fd2I3M%\b,U~\u0012wn8]9LwS*\b$K?M3];M3\b3I#Iw\\%I9[1M%\b\u001el$\b>Fwz2L>[w\\8\b%M$\\8Z2\u0012wS*"), objectArray);
            ArrayList arrayList = new ArrayList();
            String[] stringArray = new String[3 & 5];
            stringArray[5 >> 3] = c_wA.m_hr((Object)"D\\WBMQSASJFGS[ASWG");
            dataTransferManager.f_BG.m_uea(() -> {
                void a;
                Object a2 = hashSet;
                DataTransferManager a3 = this;
                a.addAll(a3.f_yi.m_Ko((Set)a2));
            }, stringArray);
            f_QI.info(Job.m_UM((Object)"\u0013I#I\u0003Z6F$N2Z\u001aI9I0M%\b\u007fd2I3M%\b,U~\u0012wi#\\2E'\\>F0\b#GwZ2[#G%MwS*\b3I#Iw\\%I9[1M%[y"), a, (Object)arrayList.size());
            arrayList.forEach(dataTransfer -> {
                void a;
                DataTransferManager dataTransferManager;
                DataTransferManager dataTransferManager2 = dataTransferManager = this;
                Object a2 = dataTransferManager2.f_NH.m_ja();
                String[] stringArray = new String[1 ^ 3];
                stringArray[3 ^ 3] = c_wA.m_hr((Object)"AVZPV@^PMQSASJFGS[ASWG");
                stringArray[5 >> 2] = Job.m_UM((Object)"k\u0016f\u0014m\u001bw\u0013i\u0003i\b|\u0005i\u0019{\u0011m\u0005");
                dataTransferManager2.f_BG.m_NDa(() -> dataTransferManager.lambda$restoreSingleDataTransferOnLeader$1((String)a2, (DataTransfer)a), a.getSpace(), stringArray);
            });
            f_QI.info(c_wA.m_hr((Object)"VtftFgs{aswg_t|tup`5:Ywtvp`5ih;/2S{{{fzpv5vtft2a`t|ftp`5`paa}gsa{z|5bg}vwfa;"), a);
            return;
        }
        catch (Exception exception) {
            Object[] objectArray = new Object[--3];
            objectArray[3 >> 2] = a;
            objectArray[4 ^ 5] = exception.getMessage();
            objectArray[1 ^ 3] = exception;
            f_QI.error(Job.m_UM((Object)"\u0013I#I\u0003Z6F$N2Z\u001aI9I0M%\b\u007fd2I3M%\b,U~\u0012wm%Z8ZwL\"Z>F0\b3I#Iw\\%I9[1M%\b%M$\\8Z6\\>G9\b'Z8K2[$\u0012wS*"), objectArray);
            return;
        }
        finally {
            dataTransferManager.f_WI.unlock();
        }
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void lambda$restoreSingleDataTransferOnLeader$1(String string, DataTransfer dataTransfer) {
        void a;
        DataTransferManager a2 = dataTransfer;
        DataTransferManager a3 = this;
        try {
            Object[] objectArray = new Object[--3];
            objectArray[2 & 5] = a;
            objectArray[--1] = a2.getName();
            objectArray[5 >> 1] = a2.getId();
            f_QI.info(c_wA.m_hr((Object)"QsasA`t|ftp`Xs{srwg2=^psqwg2no<(5@paa}g{{u5vtft2a`t|ftp`/2no5:\\V/2no<"), objectArray);
            a3.scheduleDataTransferInternal((DataTransfer)a2);
            return;
        }
        catch (Exception exception) {
            Object[] objectArray = new Object[--3];
            objectArray[3 & 4] = a2.getName();
            objectArray[--1] = a2.getId();
            objectArray[1 ^ 3] = ExceptionUtils.getRootCauseMessage((Throwable)exception);
            a3.f_lG.m_ML(a2.getProject()).m_s("Data Transfer Restore (Leader " + (String)a + ")", Job.m_UM((Object)"\r$\b\u007fa\u0013\u0012w\r$\u0001wN6A;M3\b#GwZ2[#G%My\b\u0014I\"[2\u0012w\r$").formatted(objectArray));
            try {
                f_QI.warn(c_wA.m_hr((Object)"QsasA`t|ftp`Xs{srwg2=^psqwg2no<(5Safp\u007fef||r2a}5qt|vwy2qsas5fgs{aswg2no5ssfp`5`paa}gsa{z|5tt{yggw;"), (Object)a, (Object)a2.getId());
                a3.cancelDataTransferInternal((DataTransfer)a2);
                return;
            }
            catch (Exception exception2) {
                Object[] objectArray2 = new Object[--4];
                objectArray2[5 >> 3] = a;
                objectArray2[4 ^ 5] = a2.getId();
                objectArray2[--2] = exception2.getMessage();
                objectArray2[--3] = exception2;
                f_QI.error(Job.m_UM((Object)"l6\\6|%I9[1M%e6F6O2Zw\u0000\u001bM6L2ZwS*\u0001m\b\u0011I>D2Lw\\8\b4I9K2DwL6\\6\b#Z6F$N2ZwS*\b6N#M%\b%M$\\8Z6\\>G9\b1I>D\"Z2\u0012wS*"), objectArray2);
                return;
            }
        }
    }

    protected Map<String, c_uA> getDataTransferStatusesByIdsInternal(List<String> list) {
        List<String> a = list;
        DataTransferManager a2 = this;
        if (a == null || a.isEmpty()) {
            return Collections.emptyMap();
        }
        return a.stream().collect(Collectors.toMap(Function.identity(), arg_0 -> a2.getDataTransferStatusInternal(arg_0)));
    }

    @TransactionalEventListener(value={c_kC.class})
    public void handleRescheduleEvent(c_kC c_kC2) {
        DataTransferManager dataTransferManager = this;
        if (dataTransferManager.f_NH.m_fa()) {
            DataTransferManager a = a.m_vq();
            f_QI.info(c_wA.m_hr((Object)"YWTVP@/2]s{vy{{u5@pavzpv`~pWcw{f5tz`5vtft2a`t|ftp`/2no5:\\V/2no<"), (Object)a.getName(), (Object)a.getId());
            if (dataTransferManager.getDataTransferStatusInternal(a.getId()) == c_uA.f_yG) {
                dataTransferManager.scheduleDataTransferInternal(a.getId());
                return;
            }
        } else {
            f_QI.debug(Job.m_UM((Object)"f\u0018fzd\u0012i\u0013m\u0005\u0012wa0F8Z>F0\b\u0005M$K?M3];M\u0012^2F#\b1G%\b3I#Iw\\%I9[1M%\u0012wS*"), (Object)a.m_vq().getId());
        }
    }

    @PreAuthorize(value="hasAuthority('CANCEL_DATA_TRANSFER')")
    public void cancelDataTransfer(String string) {
        Object a = string;
        DataTransferManager a2 = this;
        if (a2.f_NH.m_fa()) {
            f_QI.debug(c_wA.m_hr((Object)"^PSQWG(5Qt|vwy~||r2qsas5fgs{aswg2no5~zqt~yk;"), a);
            a2.cancelDataTransferInternal((String)a);
            return;
        }
        f_QI.debug(Job.m_UM((Object)"\u0019g\u0019\u0005\u001bm\u0016l\u0012zm\b\u0005M&]2[#A9OwD2I3M%\b#GwK6F4M;\b3I#Iw\\%I9[1M%\b,Uy"), a);
        try {
            Object[] objectArray = new Object[3 >> 1];
            objectArray[3 & 4] = a;
            a2.f_NH.m_w(Short.valueOf((short)(0x15BF & 0x6BD2)), objectArray);
            return;
        }
        catch (Exception exception) {
            throw new ClusterRpcException("Failed to RPC cancel data transfer " + (String)a, (Throwable)exception);
        }
    }

    @PostConstruct
    private /* synthetic */ void initializeClusterIntegration() {
        DataTransferManager a;
        DataTransferManager dataTransferManager = a;
        dataTransferManager.registerRemoteCallsWithClusterNode();
        dataTransferManager.f_NH.m_Ja((ClusterNodeListener)a);
        f_QI.info(c_wA.m_hr((Object)"VtftFgs{aswg_t|tup`5{{{a{t~|hpv5s{v5`pu|aawgwq2ta5Qygffp`[}qwY{ffp|p`;"));
    }

    @PreAuthorize(value="hasAuthority('VIEW_DATA_TRANSFER')")
    public Map<String, c_uA> getDataTransferStatuses(String string) {
        Object a = string;
        DataTransferManager a2 = this;
        if (a2.f_NH.m_fa()) {
            f_QI.debug(c_wA.m_hr((Object)"^PSQWG(5Upfa{{u5sy~5vtft2a`t|ftp`5aasagfwf2s}g2e`zxpqa2no5~zqt~yk;"), a);
            return a2.getDataTransferStatusesByProjectIdInternal((String)a);
        }
        f_QI.debug(Job.m_UM((Object)"f\u0018fzd\u0012i\u0013m\u0005\u0012wz2Y\"M$\\>F0\b;M6L2ZwN8ZwI;DwL6\\6\b#Z6F$N2Zw[#I#]$M$\b1G%\b'Z8B2K#\b,Uy"), a);
        try {
            Object[] objectArray = new Object[--1];
            objectArray[2 & 5] = a;
            return (Map)a2.f_NH.m_w(Short.valueOf((short)(0x1DF7 & 0x639F)), objectArray);
        }
        catch (Exception exception) {
            throw new ClusterRpcException("Failed to RPC get statuses for project" + (String)a, (Throwable)exception);
        }
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void lambda$handleCurrentValues$10(Map map, Map map2, Map map3, Map map4, DataTransferDetail dataTransferDetail) {
        Variable a;
        void a2;
        VariableValue a3;
        Object a4 = map2;
        DataTransferManager a5 = this;
        a3 = (VariableValue)a3.get(a2.getSourceVariableId());
        a4 = (VariableValue)a4.get(a2.getTargetVariableId());
        a = (Variable)a.get(a2.getTargetVariableId());
        if (a3 != null && a != null && a5.isValueInThresholdRange(a2.getThreshold(), a3, (VariableValue)a4)) {
            void a6;
            a4 = new HashMap<String, Object>();
            a4.put(c_wA.m_hr((Object)"csygp"), a3.getValue());
            a6.put(a.getName(), a4);
        }
    }

    protected void cancelDataTransferInternal(DataTransfer dataTransfer) {
        DataTransferManager a = dataTransfer;
        DataTransferManager a2 = this;
        a2.f_BG.m_qFa(() -> a2.lambda$cancelDataTransferInternal$6((DataTransfer)a), (OwnedSpaceBaseModel)a);
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void lambda$notLeader$2(String string, String string2) {
        void a;
        DataTransferManager dataTransferManager = this;
        DataTransferManager a22 = (Job)dataTransferManager.f_LG.get(a);
        if (a22 != null) {
            void a3;
            try {
                f_QI.info(c_wA.m_hr((Object)"VtftFgs{aswg_t|tup`5:[}a2Ywtvp`5ih;/2Vs{qp~y{{u5~zqt~5xzp5tz`5vtft2a`t|ftp`5[Q(5ih"), (Object)a3, (Object)a);
                dataTransferManager.f_Hh.m_ij((Job)a22);
                return;
            }
            catch (Exception a22) {
                Object[] objectArray = new Object[--4];
                objectArray[5 >> 3] = a3;
                objectArray[2 ^ 3] = a;
                objectArray[5 >> 1] = a22.getMessage();
                objectArray[--3] = a22;
                f_QI.error(Job.m_UM((Object)"\u0013I#I\u0003Z6F$N2Z\u001aI9I0M%\b\u007ff8\\wd2I3M%\b,U~\u0012wm%Z8ZwK6F4M;D>F0\b;G4I;\b=G5\b1G%\b3I#Iw\\%I9[1M%\b\u001elwS*\u0012wS*"), objectArray);
            }
        }
    }

    @PreAuthorize(value="hasAuthority('VIEW_DATA_TRANSFER')")
    public Map<String, c_uA> getDataTransferStatuses(List<String> list) {
        List<String> a = list;
        DataTransferManager a2 = this;
        if (a == null || a.isEmpty()) {
            return Collections.emptyMap();
        }
        if (a2.f_NH.m_fa()) {
            f_QI.debug(Job.m_UM((Object)"\u001bm\u0016l\u0012zm\b\u0010M#\\>F0\b3I#Iw\\%I9[1M%\b$\\6\\\"[2[wN8ZwS*\b\u001el$\b;G4I;D.\u0012wS*"), (Object)a.size(), (Object)a);
            return a2.getDataTransferStatusesByIdsInternal((List)a);
        }
        f_QI.debug(c_wA.m_hr((Object)"[][?YWTVP@/2Gwdgpaa{{u5~psqwg2s}g2qsas5fgs{aswg2fftf`apa5tz`5ih2\\Vf(5ih"), (Object)a.size(), (Object)a);
        try {
            Object[] objectArray = new Object[--1];
            objectArray[3 >> 2] = new ArrayList(a);
            return (Map)a2.f_NH.m_w(Short.valueOf((short)(0x73B6 & 0xDDF)), objectArray);
        }
        catch (Exception exception) {
            throw new ClusterRpcException("Failed to RPC get data transfer statuses for IDs " + a.stream().map(String::valueOf).collect(Collectors.joining(Job.m_UM((Object)"{"))), (Throwable)exception);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private /* synthetic */ int getMaxTTLForRangeType(c_wL c_wL2) {
        DataTransferManager a = c_wL2;
        DataTransferManager a2 = this;
        switch (c_nd.f_Dj[a.ordinal()]) {
            case 1: 
            case 2: {
                return 3600;
            }
            case 3: 
            case 4: {
                return 86400;
            }
            case 5: 
            case 6: {
                return 604800;
            }
            case 7: 
            case 8: {
                return 2678400;
            }
            case 9: 
            case 10: {
                return 31622400;
            }
        }
        throw new IllegalArgumentException("Unexpected range type: " + String.valueOf(a));
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void handleCurrentValues(List<DataTransferDetail> list, Map<String, Map<String, Object>> map) {
        void a;
        void a2;
        DataTransferManager dataTransferManager = this;
        Object object = (String[])a2.stream().map(DataTransferDetail::getSourceVariableId).toArray(String[]::new);
        Object a3 = a2.stream().map(DataTransferDetail::getTargetVariableId).collect(Collectors.toList());
        Map map2 = dataTransferManager.f_GH.m_LAa((List)a3).stream().collect(Collectors.toMap(BaseModel::getId, Function.identity()));
        DataTransferManager dataTransferManager2 = dataTransferManager;
        object = dataTransferManager2.f_zI.m_XBa(object);
        a3 = dataTransferManager2.f_zI.m_XBa((String[])a3.toArray(String[]::new));
        a2.forEach(arg_0 -> dataTransferManager.lambda$handleCurrentValues$10((Map)object, (Map)a3, map2, (Map)a, arg_0));
    }

    @PreAuthorize(value="hasAuthority('VIEW_DATA_TRANSFER')")
    public c_uA getDataTransferStatus(String string) {
        Object a = string;
        DataTransferManager a2 = this;
        if (a2.f_NH.m_fa()) {
            f_QI.debug(Job.m_UM((Object)"d\u0012i\u0013m\u0005\u0012wo2\\#A9OwL6\\6\b#Z6F$N2Zw[#I#]$\b1G%\b\u001elm\b,UwD8K6D;Qy"), a);
            return a2.getDataTransferStatusInternal((String)a);
        }
        f_QI.debug(c_wA.m_hr((Object)"\\Z\\8^PSQWG(5@pc`wff||r2ywtvp`5tz`5vtft2a`t|ftp`5aasagf2s}g2\\V/2no;"), a);
        try {
            Object[] objectArray = new Object[2 ^ 3];
            objectArray[3 >> 2] = a;
            return (c_uA)a2.f_NH.m_w(Short.valueOf((short)(0x21D7 & 0x5FBB)), objectArray);
        }
        catch (Exception exception) {
            throw new ClusterRpcException("Failed to RPC get data transfer status for " + (String)a, (Throwable)exception);
        }
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void transfer(DataTransfer dataTransfer) {
        void a;
        DataTransferManager dataTransferManager = this;
        if (a.getDataTransferDetails() == null || a.getDataTransferDetails().isEmpty()) {
            return;
        }
        ArrayList arrayList = new ArrayList();
        ArrayList arrayList2 = new ArrayList();
        a.getDataTransferDetails().forEach(dataTransferDetail -> {
            void a;
            List a2 = dataTransferDetail;
            List a3 = arrayList2;
            if (a2.getCalcType() != null && a2.getRangeType() != null) {
                a3.add(a2);
                return;
            }
            a.add(a2);
        });
        HashMap a2 = new HashMap();
        if (!arrayList.isEmpty()) {
            dataTransferManager.handleCurrentValues(arrayList, (Map)a2);
        }
        if (!arrayList2.isEmpty()) {
            dataTransferManager.handleStatValues(arrayList2, (Map)a2);
        }
        if (!a2.isEmpty()) {
            dataTransferManager.f_zI.m_Qca(a.getProjectId(), (Map)a2);
        }
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ boolean isValueInThresholdRange(Double d, Double d2, VariableValue<?> variableValue) {
        void a;
        void a2;
        VariableValue<?> a3 = variableValue;
        VariableValue<?> a4 = this;
        return a4.isValueInThresholdRange((Double)a2, (VariableValue)new NumberVariableValue((Number)a, new Date()), a3);
    }

    protected void cancelDataTransfersByProjectIdInternal(String string) {
        Object a = string;
        DataTransferManager a2 = this;
        if ((a = a2.f_yi.m_Wm((String)a)) == null || a.isEmpty()) {
            return;
        }
        a.forEach(arg_0 -> a2.cancelDataTransferInternal(arg_0));
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void handleStatValues(List<DataTransferDetail> list, Map<String, Map<String, Object>> map) {
        void a;
        void a2;
        DataTransferManager dataTransferManager = this;
        Object a3 = a2.stream().map(DataTransferDetail::getTargetVariableId).collect(Collectors.toList());
        Map map2 = dataTransferManager.f_GH.m_LAa((List)a3).stream().collect(Collectors.toMap(BaseModel::getId, Function.identity()));
        a3 = dataTransferManager.f_zI.m_XBa((String[])a3.toArray(String[]::new));
        Date date = new Date();
        a2.stream().filter(arg_0 -> dataTransferManager.lambda$handleStatValues$12(date, map2, (Map)a, (Map)a3, arg_0)).collect(Collectors.groupingBy(dataTransferDetail -> {
            void a;
            DataTransferManager a2 = dataTransferDetail;
            DataTransferManager a3 = this;
            return (Date)a3.calculateDateRange((Date)a, a2.getRangeType()).getLeft();
        })).forEach((arg_0, arg_1) -> dataTransferManager.lambda$handleStatValues$17(date, map2, (Map)a3, (Map)a, arg_0, arg_1));
    }

    private /* synthetic */ String buildStatLastCalcTimeKey(DataTransferDetail dataTransferDetail) {
        DataTransferManager a = dataTransferDetail;
        DataTransferManager a2 = this;
        Object[] objectArray = new Object[--3];
        objectArray[3 >> 2] = a.getSourceVariableId();
        objectArray[5 >> 2] = a.getRangeType();
        objectArray[--2] = a.getCalcType();
        return Job.m_UM((Object)"L6\\6\u0005#Z6F$N2ZmD6[#\u00054I;Kz\\>E2\u0012!I%A6J;Mm\r$\u0012r[m\r$").formatted(objectArray);
    }

    private /* synthetic */ void registerRemoteCallsWithClusterNode() {
        DataTransferManager dataTransferManager = this;
        try {
            Class[] classArray = new Class[3 & 5];
            classArray[3 >> 2] = String.class;
            dataTransferManager.f_NH.m_Da((short)(0x1DBD & 0x63D3), (Object)dataTransferManager, DataTransferManager.class.getDeclaredMethod(Job.m_UM((Object)"[4@2L\"D2l6\\6|%I9[1M%a9\\2Z9I;"), classArray));
            Class[] classArray2 = new Class[--1];
            classArray2[3 ^ 3] = String.class;
            dataTransferManager.f_NH.m_Da((short)(0x65BB & 0x1BD6), (Object)dataTransferManager, DataTransferManager.class.getDeclaredMethod(c_wA.m_hr((Object)"qt|vwyVtftFgs{aswg[{fp`{sy"), classArray2));
            Class[] classArray3 = new Class[3 >> 1];
            classArray3[3 ^ 3] = String.class;
            dataTransferManager.f_NH.m_Da((short)(0x31FF & 0x4F93), (Object)dataTransferManager, DataTransferManager.class.getDeclaredMethod(Job.m_UM((Object)"0M#l6\\6|%I9[1M%{#I#]$a9\\2Z9I;"), classArray3));
            Class[] classArray4 = new Class[3 >> 1];
            classArray4[2 & 5] = String.class;
            dataTransferManager.f_NH.m_Da((short)(0x739E & 0xDF5), (Object)dataTransferManager, DataTransferManager.class.getDeclaredMethod(c_wA.m_hr((Object)"avzpv`~pVtftFgs{aswgaWkE`zxpqa[q[{fp`{sy"), classArray4));
            Class[] classArray5 = new Class[5 >> 2];
            classArray5[5 >> 3] = String.class;
            dataTransferManager.f_NH.m_Da((short)(0x21D5 & 0x5FBF), (Object)dataTransferManager, DataTransferManager.class.getDeclaredMethod(Job.m_UM((Object)"K6F4M;l6\\6|%I9[1M%[\u0015Q\u0007Z8B2K#a3a9\\2Z9I;"), classArray5));
            Class[] classArray6 = new Class[1];
            classArray6[0] = List.class;
            dataTransferManager.f_NH.m_Da((short)(0x79DE & 0x7B7), (Object)dataTransferManager, DataTransferManager.class.getDeclaredMethod(c_wA.m_hr((Object)"upfQsasA`t|ftp`Fftf`apaWk\\vf[{fp`{sy"), classArray6));
            Class[] classArray7 = new Class[1];
            classArray7[0] = String.class;
            dataTransferManager.f_NH.m_Da((short)(0x4BFF & 0x3597), (Object)dataTransferManager, DataTransferManager.class.getDeclaredMethod(Job.m_UM((Object)"O2\\\u0013I#I\u0003Z6F$N2Z\u0004\\6\\\"[2[\u0015Q\u0007Z8B2K#a3a9\\2Z9I;"), classArray7));
            return;
        }
        catch (NoSuchMethodException a) {
            throw new IllegalStateException(c_wA.m_hr((Object)"Tt{ywq2a}5`pu|aawg2QsasA`t|ftp`Xs{srwg2GBV2xwazzvf"), a);
        }
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    private /* synthetic */ double extractValue(LoggedVariableValueStats loggedVariableValueStats, c_Pl c_Pl2) {
        void a;
        DataTransferManager a2 = loggedVariableValueStats;
        DataTransferManager a3 = this;
        switch (c_nd.f_Sh[a.ordinal()]) {
            case 1: {
                return a2.getMinValue();
            }
            case 2: {
                return a2.getMaxValue();
            }
            case 3: {
                return a2.getAvgValue();
            }
            case 4: {
                return a2.getSumValue();
            }
            case 5: {
                return a2.getCountValue();
            }
            case 6: {
                return a2.getFirstValue();
            }
            case 7: {
                return a2.getLastValue();
            }
            case 8: {
                return a2.getMaxDiffValue();
            }
            case 9: {
                return a2.getLastFirstDiffValue();
            }
            case 10: {
                return a2.getMiddleValue();
            }
            case 11: {
                return a2.getMedianValue();
            }
        }
        throw new IllegalArgumentException("Unexpected calculation type: " + String.valueOf(a));
    }

    /*
     * WARNING - void declaration
     */
    @PreAuthorize(value="hasAuthority('CANCEL_DATA_TRANSFER')")
    public void cancelDataTransfer(String string, String string2) {
        void a;
        DataTransferManager a2;
        Object a3 = string2;
        DataTransferManager dataTransferManager = a2 = this;
        dataTransferManager.cancelDataTransfer(dataTransferManager.f_yi.m_bO((String)a, (String)a3).getId());
    }

    protected void scheduleDataTransfersByProjectIdInternal(String string) {
        Object a = string;
        DataTransferManager a2 = this;
        if ((a = a2.f_yi.m_Qo((String)a)) == null || a.isEmpty()) {
            return;
        }
        a.forEach(arg_0 -> a2.scheduleDataTransferInternal(arg_0));
    }

    /*
     * WARNING - void declaration
     */
    @TransactionalEventListener(value={c_ob.class})
    public void handleCancelEvent(c_ob c_ob2) {
        void a;
        DataTransferManager dataTransferManager = this;
        if (dataTransferManager.f_NH.m_fa()) {
            DataTransferManager a2 = a.m_UO();
            f_QI.info(c_wA.m_hr((Object)"YWTVP@/2]s{vy{{u5Qt|vwyWcw{f5tz`5vtft2a`t|ftp`/2no5:\\V/2no<"), (Object)a2.getName(), (Object)a2.getId());
            dataTransferManager.cancelDataTransferInternal((DataTransfer)a2);
            return;
        }
        f_QI.debug(Job.m_UM((Object)"f\u0018fzd\u0012i\u0013m\u0005\u0012wa0F8Z>F0\b\u0014I9K2D\u0012^2F#\b1G%\b3I#Iw\\%I9[1M%\u0012wS*"), (Object)a.m_UO().getId());
    }

    public void deactivateForProject(String string) {
        Object a = string;
        DataTransferManager a2 = this;
        if (a2.f_NH.m_fa()) {
            f_QI.info(c_wA.m_hr((Object)"^PSQWG(5Zt|q~||r2E`zxpqaVpsvf|dtfpWcw{f5tz`5bg}\u007fwvf5[Q(5ih"), a);
            a2.cancelDataTransfersByProjectIdInternal((String)a);
            return;
        }
        f_QI.debug(Job.m_UM((Object)"f\u0018fzd\u0012i\u0013m\u0005\u0012wa0F8Z>F0\b\u0007Z8B2K#l2I4\\>^6\\2m!M9\\wN8ZwX%G=M4\\wa\u0013\u0012wS*"), a);
    }

    @PreAuthorize(value="hasAuthority('CANCEL_DATA_TRANSFER')")
    public void cancelDataTransfers(String string) {
        Object a = string;
        DataTransferManager a2 = this;
        if (a2.f_NH.m_fa()) {
            f_QI.debug(c_wA.m_hr((Object)"YWTVP@/2Vs{qp~y{{u5sy~5vtft2a`t|ftp`f2s}g2e`zxpqa2no5~zqt~yk;"), a);
            a2.cancelDataTransfersByProjectIdInternal((String)a);
            return;
        }
        f_QI.debug(Job.m_UM((Object)"f\u0018fzd\u0012i\u0013m\u0005\u0012wz2Y\"M$\\>F0\b;M6L2Zw\\8\b4I9K2DwI;DwL6\\6\b#Z6F$N2Z$\b1G%\b'Z8B2K#\b,Uy"), a);
        try {
            Object[] objectArray = new Object[5 >> 2];
            objectArray[3 ^ 3] = a;
            a2.f_NH.m_w(Short.valueOf((short)(0x19FF & 0x6795)), objectArray);
            return;
        }
        catch (Exception exception) {
            throw new ClusterRpcException("Failed to RPC cancel data transfers for project " + (String)a, (Throwable)exception);
        }
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void updateVariableWithCachedValue(String string, DataTransferDetail dataTransferDetail, Map<String, Variable<?, ?, ?>> map, Map<String, Map<String, Object>> map2, Map<String, VariableValue<?>> map3) {
        void a;
        Variable a2;
        Object a3 = string;
        DataTransferManager a4 = this;
        if ((a2 = (Variable)a2.get(a.getTargetVariableId())) != null) {
            void a5;
            double d = Double.parseDouble((String)a3);
            a3 = (VariableValue)a5.get(a.getTargetVariableId());
            if (a4.isValueInThresholdRange(a.getThreshold(), Double.valueOf(d), (VariableValue)a3)) {
                void a6;
                a3 = new HashMap<String, Double>();
                a3.put(Job.m_UM((Object)"!I;]2"), d);
                a6.put(a2.getName(), a3);
            }
        }
    }

    private /* synthetic */ void lambda$scheduleDataTransferInternal$4(DataTransfer dataTransfer) {
        DataTransferManager a = dataTransfer;
        DataTransferManager a2 = this;
        a2.transfer((DataTransfer)a);
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ Pair<Date, Date> calculateDateRange(Date date, c_wL c_wL2) {
        void a;
        void a2;
        Object a3;
        DataTransferManager dataTransferManager = this;
        Object object = a3 = Calendar.getInstance();
        ((Calendar)a3).setTime((Date)a2);
        ((Calendar)object).set(0x4F & 0x3D, 3 >> 2);
        ((Calendar)object).set(0x7E & 0xF, 3 >> 2);
        Calendar calendar = (Calendar)((Calendar)object).clone();
        switch (c_nd.f_Dj[a.ordinal()]) {
            case 1: {
                Object object2 = a3;
                while (false) {
                }
                ((Calendar)object2).set(0x6C & 0x1F, 5 >> 3);
                return Pair.of((Object)((Calendar)object2).getTime(), (Object)a2);
            }
            case 2: {
                calendar.add(0x3B & 0x4F, -4 >> 2);
                Object object3 = a3;
                ((Calendar)object3).add(0x1F & 0x6B, 0xFFFFFFFF & 0xFFFFFFFE);
                ((Calendar)object3).set(0x2D & 0x5E, 3 ^ 3);
                return Pair.of((Object)((Calendar)object3).getTime(), (Object)calendar.getTime());
            }
            case 3: {
                Object object4 = a3;
                ((Calendar)object4).set(0x4F & 0x3B, 3 ^ 3);
                ((Calendar)object4).set(0x4E & 0x3D, 3 & 4);
                return Pair.of((Object)((Calendar)a3).getTime(), (Object)a2);
            }
            case 4: {
                calendar.add(--5, -4 >> 2);
                Object object5 = a3;
                ((Calendar)a3).add(--5, -2);
                ((Calendar)object5).set(11, 2 & 5);
                ((Calendar)object5).set(0x1E & 0x6D, 3 ^ 3);
                return Pair.of((Object)((Calendar)object5).getTime(), (Object)calendar.getTime());
            }
            case 5: {
                Object object6 = a3;
                Object object7 = a3;
                ((Calendar)object7).set(7, ((Calendar)object7).getFirstDayOfWeek());
                ((Calendar)object6).set(11, 3 ^ 3);
                ((Calendar)object6).set(12, 0);
                return Pair.of((Object)((Calendar)a3).getTime(), (Object)a2);
            }
            case 6: {
                calendar.add(--3, -4 >> 2);
                Object object8 = a3;
                ((Calendar)a3).add(--3, -2);
                Object object9 = a3;
                ((Calendar)object9).set(7, ((Calendar)object9).getFirstDayOfWeek());
                ((Calendar)object8).set(11, 0);
                ((Calendar)object8).set(12, 0);
                return Pair.of((Object)((Calendar)object8).getTime(), (Object)calendar.getTime());
            }
            case 7: {
                Object object10 = a3;
                ((Calendar)a3).set(--5, 1);
                ((Calendar)object10).set(11, 0);
                ((Calendar)object10).set(12, 0);
                return Pair.of((Object)((Calendar)a3).getTime(), (Object)a2);
            }
            case 8: {
                calendar.add(--2, -4 >> 2);
                Object object11 = a3;
                Object object12 = a3;
                ((Calendar)object12).add(2, -2);
                ((Calendar)object12).set(5, 1);
                ((Calendar)object11).set(11, 0);
                ((Calendar)object11).set(12, 0);
                return Pair.of((Object)((Calendar)object11).getTime(), (Object)calendar.getTime());
            }
            case 9: {
                Object object13 = a3;
                ((Calendar)a3).set(6, 1);
                ((Calendar)object13).set(11, 0);
                ((Calendar)object13).set(12, 0);
                return Pair.of((Object)((Calendar)a3).getTime(), (Object)a2);
            }
            case 10: {
                calendar.add(1, -1);
                Object object14 = a3;
                Object object15 = a3;
                ((Calendar)object15).add(1, -2);
                ((Calendar)object15).set(6, 1);
                ((Calendar)object14).set(11, 0);
                ((Calendar)object14).set(12, 0);
                return Pair.of((Object)((Calendar)object14).getTime(), (Object)calendar.getTime());
            }
        }
        throw new IllegalArgumentException(c_wA.m_hr((Object)"@|pjewvfpv5`t|rw5flbp"));
    }

    private /* synthetic */ String buildStatCacheKey(DataTransferDetail dataTransferDetail) {
        DataTransferManager a = dataTransferDetail;
        DataTransferManager a2 = this;
        Object[] objectArray = new Object[--3];
        objectArray[3 ^ 3] = a.getSourceVariableId();
        objectArray[5 >> 2] = a.getRangeType();
        objectArray[--2] = a.getCalcType();
        return c_wA.m_hr((Object)"qsas8fgs{aswg(fftff(csg{tpyw/7f(0a/7f").formatted(objectArray);
    }

    @PreAuthorize(value="hasAuthority('SCHEDULE_DATA_TRANSFER')")
    public void scheduleDataTransfers(String string) {
        Object a = string;
        DataTransferManager a2 = this;
        if (a2.f_NH.m_fa()) {
            f_QI.debug(c_wA.m_hr((Object)"YWTVP@/2Fq}wqgy{{u5sy~5vtft2a`t|ftp`f2s}g2e`zxpqa2no5~zqt~yk;"), a);
            a2.scheduleDataTransfersByProjectIdInternal((String)a);
            return;
        }
        f_QI.debug(Job.m_UM((Object)"f\u0018fzd\u0012i\u0013m\u0005\u0012wz2Y\"M$\\>F0\b;M6L2Zw\\8\b$K?M3];MwI;DwL6\\6\b#Z6F$N2Z$\b1G%\b'Z8B2K#\b,Uy"), a);
        try {
            Object[] objectArray = new Object[2 ^ 3];
            objectArray[5 >> 3] = a;
            a2.f_NH.m_w(Short.valueOf((short)(0x43DE & 0x3DB5)), objectArray);
            return;
        }
        catch (Exception exception) {
            throw new ClusterRpcException("Failed to RPC schedule data transfers for project " + (String)a, (Throwable)exception);
        }
    }

    protected void scheduleDataTransferInternal(String string) {
        DataTransferManager a;
        Object a2 = string;
        DataTransferManager dataTransferManager = a = this;
        dataTransferManager.scheduleDataTransferInternal(dataTransferManager.f_yi.m_Cn((String)a2));
    }

    private /* synthetic */ void lambda$cancelDataTransferInternal$6(DataTransfer dataTransfer) {
        DataTransferManager a = dataTransfer;
        DataTransferManager a2 = this;
        a2.f_WI.lock();
        try {
            Job job = (Job)a2.f_LG.get(a.getId());
            if (job != null) {
                a2.f_Hh.m_ij(job);
            }
            DataTransferManager dataTransferManager = a2;
            dataTransferManager.f_LG.remove(a.getId());
            String[] stringArray = new String[5 >> 2];
            stringArray[5 >> 3] = a.getId();
            dataTransferManager.f_UI.srem(f_lh, stringArray);
            return;
        }
        finally {
            a2.f_WI.unlock();
        }
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void lambda$handleStatValues$17(Date date, Map map, Map map2, Map map3, Date date2, List list) {
        void a;
        void a2;
        void a3;
        Map a4;
        void a5;
        List a6;
        DataTransferManager dataTransferManager = list2;
        List list2 = list;
        DataTransferManager a7 = dataTransferManager;
        String[] stringArray = (String[])a6.stream().map(DataTransferDetail::getSourceVariableId).distinct().toArray(String[]::new);
        c_Pl[] c_PlArray = (c_Pl[])a6.stream().map(DataTransferDetail::getCalcType).distinct().toArray(c_Pl[]::new);
        a4 = a7.f_th.m_YAa(stringArray, (Date)a5, (Date)((Object)a4), c_PlArray).stream().collect(Collectors.toMap(LoggedVariableValueStats::getVariableId, Function.identity()));
        a6.forEach(arg_0 -> a7.lambda$handleStatValues$16(a4, (Map)a3, (Map)a2, (Map)a, arg_0));
    }

    protected Map<String, c_uA> getDataTransferStatusesByProjectIdInternal(String string) {
        Object a = string;
        DataTransferManager a2 = this;
        if ((a = a2.f_yi.m_Yn((String)a)) == null || a.isEmpty()) {
            return Collections.emptyMap();
        }
        return a.stream().collect(Collectors.toMap(DataTransferSummary::getId, dataTransferSummary -> {
            DataTransferManager a = dataTransferSummary;
            DataTransferManager a2 = this;
            return a2.getDataTransferStatusInternal(a.getId());
        }));
    }

    protected void scheduleDataTransferInternal(DataTransfer dataTransfer) {
        DataTransferManager a = dataTransfer;
        DataTransferManager a2 = this;
        a2.f_BG.m_qFa(() -> a2.lambda$scheduleDataTransferInternal$5((DataTransfer)a), (OwnedSpaceBaseModel)a);
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    private /* synthetic */ boolean shouldRecalculateStats(DataTransferDetail dataTransferDetail, Date date, String string) {
        int n;
        void a;
        void a2;
        Object a222 = string;
        DataTransferManager a3 = this;
        if (a222 == null) {
            return (4 ^ 5) != 0;
        }
        a222 = Calendar.getInstance();
        String string2 = a3.f_UI.get(a3.buildStatLastCalcTimeKey((DataTransferDetail)a2));
        if (string2 == null) {
            return 3 >> 1;
        }
        ((Calendar)a222).setTimeInMillis(Long.parseLong(string2));
        Calendar calendar = Calendar.getInstance();
        calendar.setTime((Date)a);
        switch (c_nd.f_Dj[a2.getRangeType().ordinal()]) {
            default: {
                throw new IncompatibleClassChangeError();
            }
            case 1: 
            case 2: {
                int n2;
                if (((Calendar)a222).get(0x7B & 0xF) != calendar.get(0x6B & 0x1F)) {
                    n2 = 4 ^ 5;
                    break;
                }
                n2 = 0;
                break;
            }
            case 3: 
            case 4: {
                int n2;
                if (((Calendar)a222).get(0x1E & 0x67) != calendar.get(0x76 & 0xF)) {
                    n2 = --1;
                    break;
                }
                n2 = 0;
                break;
            }
            case 5: 
            case 6: {
                int n2;
                if (((Calendar)a222).get(--3) != calendar.get(--3)) {
                    n2 = 3 >> 1;
                    break;
                }
                n2 = 0;
                break;
            }
            case 7: 
            case 8: {
                int n2;
                if (((Calendar)a222).get(5 >> 1) != calendar.get(5 >> 1)) {
                    n2 = 4 ^ 5;
                    break;
                }
                n2 = 0;
                break;
            }
            case 9: 
            case 10: {
                int n2 = n = ((Calendar)a222).get(3 & 5) != calendar.get(5 >> 2) ? 3 >> 1 : 0;
            }
        }
        if (n != 0) {
            DataTransferManager dataTransferManager = a3;
            a222 = dataTransferManager.buildStatCacheKey((DataTransferDetail)a2);
            String string3 = dataTransferManager.buildStatLastCalcTimeKey((DataTransferDetail)a2);
            String[] stringArray = new String[1 ^ 3];
            stringArray[0] = a222;
            stringArray[1] = string3;
            dataTransferManager.f_UI.del(stringArray);
            return true;
        }
        if (!a2.getRangeType().toString().startsWith(c_wA.m_hr((Object)"Vgg`p|a"))) {
            return false;
        }
        int a222 = switch (c_nd.f_Dj[a2.getRangeType().ordinal()]) {
            case 1 -> 5;
            case 3 -> 5;
            case 5 -> 60;
            case 7 -> 720;
            case 9 -> 720;
            default -> throw new IllegalArgumentException("Unexpected range type: " + String.valueOf(a2.getRangeType()));
        };
        long l = a.getTime();
        long l2 = Long.parseLong(string2);
        return l - l2 >= (long)(a222 * (0x7D & 0x3E) * (0x57FF & 0x2BE8));
    }

    /*
     * WARNING - void declaration
     */
    @PreAuthorize(value="hasAuthority('SCHEDULE_DATA_TRANSFER')")
    public void scheduleDataTransfer(String string, String string2) {
        void a;
        DataTransferManager a2;
        Object a3 = string2;
        DataTransferManager dataTransferManager = a2 = this;
        dataTransferManager.scheduleDataTransfer(dataTransferManager.f_yi.m_bO((String)a, (String)a3).getId());
    }

    @PreAuthorize(value="hasAuthority('SCHEDULE_DATA_TRANSFER')")
    public void scheduleDataTransfer(String string) {
        Object a = string;
        DataTransferManager a2 = this;
        if (a2.f_NH.m_fa()) {
            f_QI.debug(c_wA.m_hr((Object)"^PSQWG(5Avzpv`~||r2qsas5fgs{aswg2no5~zqt~yk;"), a);
            a2.scheduleDataTransferInternal((String)a);
            return;
        }
        f_QI.debug(Job.m_UM((Object)"\u0019g\u0019\u0005\u001bm\u0016l\u0012zm\b\u0005M&]2[#A9OwD2I3M%\b#Gw[4@2L\"D2\b3I#Iw\\%I9[1M%\b,Uy"), a);
        try {
            Object[] objectArray = new Object[--1];
            objectArray[3 ^ 3] = a;
            a2.f_NH.m_w(Short.valueOf((short)(0x25BD & 0x5BD3)), objectArray);
            return;
        }
        catch (Exception exception) {
            throw new ClusterRpcException("Failed to RPC schedule data transfer " + (String)a, (Throwable)exception);
        }
    }

    protected void cancelDataTransferInternal(String string) {
        DataTransferManager a;
        Object a2 = string;
        DataTransferManager dataTransferManager = a = this;
        dataTransferManager.cancelDataTransferInternal(dataTransferManager.f_yi.m_Im((String)a2));
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ boolean lambda$handleStatValues$12(Date date, Map map, Map map2, Map map3, DataTransferDetail dataTransferDetail) {
        void a;
        void a2;
        DataTransferManager dataTransferManager;
        DataTransferManager dataTransferManager2 = dataTransferManager = this;
        Object a3 = dataTransferManager2.buildStatCacheKey((DataTransferDetail)a2);
        if (!dataTransferManager2.shouldRecalculateStats((DataTransferDetail)a2, (Date)a, (String)(a3 = dataTransferManager2.f_UI.get((String)a3)))) {
            void a4;
            void a5;
            void a6;
            dataTransferManager.updateVariableWithCachedValue((String)a3, (DataTransferDetail)a2, (Map)a6, (Map)a5, (Map)a4);
            return 3 >> 2;
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    public DataTransferManager(c_dd c_dd2, c_QH c_QH2, c_Zh c_Zh2, c_SI c_SI2, c_nB c_nB2, JedisPooled jedisPooled, c_ac c_ac2, c_b c_b2, c_oL c_oL2) {
        DataTransferManager a;
        void a2;
        void a3;
        void a4;
        void a5;
        void a6;
        void a7;
        void a8;
        void a9;
        DataTransferManager a10;
        DataTransferManager dataTransferManager = dataTransferManager2;
        DataTransferManager dataTransferManager2 = c_oL2;
        DataTransferManager dataTransferManager3 = a10 = dataTransferManager;
        DataTransferManager dataTransferManager4 = a10;
        DataTransferManager dataTransferManager5 = a10;
        DataTransferManager dataTransferManager6 = a10;
        DataTransferManager dataTransferManager7 = a10;
        DataTransferManager dataTransferManager8 = a10;
        dataTransferManager7.f_WI = new ReentrantLock();
        dataTransferManager7.f_LG = new ConcurrentHashMap();
        dataTransferManager7.f_yi = a9;
        dataTransferManager6.f_GH = a8;
        dataTransferManager6.f_zI = a7;
        dataTransferManager5.f_th = a6;
        dataTransferManager5.f_Hh = a5;
        dataTransferManager4.f_lG = a4;
        dataTransferManager4.f_UI = a3;
        dataTransferManager3.f_NH = a2;
        dataTransferManager3.f_BG = a;
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ boolean isValueInThresholdRange(Double d, VariableValue<?> variableValue, VariableValue<?> variableValue2) {
        void a;
        void a2;
        VariableValue<?> a3 = variableValue2;
        VariableValue<?> a4 = this;
        if (a2 == null || a3 == null) {
            return true;
        }
        if (!(a instanceof NumberVariableValue) || !(a3 instanceof NumberVariableValue)) {
            return true;
        }
        double d2 = ((Number)a.getValue()).doubleValue();
        double d3 = ((Number)a3.getValue()).doubleValue();
        double d4 = d2 == 0.0 ? Math.abs(d3 - d2) : Math.abs((d3 - d2) / d2 * 100.0);
        if (d4 >= a2.doubleValue()) {
            return 3 >> 1;
        }
        return false;
    }

    protected c_uA getDataTransferStatusInternal(String string) {
        Object a = string;
        DataTransferManager a2 = this;
        if (a2.f_LG.containsKey(a)) {
            return c_uA.f_yG;
        }
        return c_uA.f_ZH;
    }
}

