/*
 * Decompiled with CFR 0.152.
 */
package com.inscada.mono.datatransfer.repositories;

import com.inscada.mono.datatransfer.model.DataTransfer;
import com.inscada.mono.datatransfer.model.DataTransferSummary;
import com.inscada.mono.shared.aspects.DisableSpaceFilter;
import com.inscada.mono.shared.aspects.EnableSpaceFilter;
import com.inscada.mono.shared.repositories.BaseJpaRepository;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;

@EnableSpaceFilter
public interface DataTransferRepository
extends BaseJpaRepository<DataTransfer> {
    @Query(value="SELECT DISTINCT dt FROM DataTransfer dt LEFT JOIN FETCH dt.dataTransferDetails d LEFT JOIN FETCH d.sourceVariable sv LEFT JOIN FETCH d.targetVariable tv WHERE dt.projectId = :projectId")
    public List<DataTransfer> findByProjectIdWithDetails(@Param(value="projectId") String var1);

    @Query(value="SELECT new com.inscada.mono.datatransfer.model.DataTransferSummary(d.id, d.name, d.projectId, d.dsc, d.period, d.createdBy, d.creationDate, d.lastModifiedBy, d.lastModifiedDate) FROM DataTransfer d WHERE d.projectId = :projectId AND d.name = :name")
    public Optional<DataTransferSummary> findSummaryByProjectIdAndName(@Param(value="projectId") String var1, @Param(value="name") String var2);

    @Query(value="SELECT new com.inscada.mono.datatransfer.model.DataTransferSummary(d.id, d.name, d.projectId, d.dsc, d.period, d.createdBy, d.creationDate, d.lastModifiedBy, d.lastModifiedDate) FROM DataTransfer d WHERE d.id = :id")
    public Optional<DataTransferSummary> findSummaryById(@Param(value="id") String var1);

    public List<DataTransfer> findByProjectId(String var1);

    @DisableSpaceFilter
    @Query(value="SELECT DISTINCT dt FROM DataTransfer dt WHERE dt.id IN :dataTransferIds")
    public Collection<DataTransfer> findAllInAllSpaces(@Param(value="dataTransferIds") Set<String> var1);

    @Query(value="SELECT DISTINCT dt FROM DataTransfer dt LEFT JOIN FETCH dt.dataTransferDetails d LEFT JOIN FETCH d.sourceVariable sv LEFT JOIN FETCH d.targetVariable tv WHERE dt.id = :dataTransferId")
    public Optional<DataTransfer> findOneWithDetails(@Param(value="dataTransferId") String var1);

    public Optional<DataTransfer> findOneByProjectIdAndName(String var1, String var2);

    @DisableSpaceFilter
    @Query(value="SELECT DISTINCT dt FROM DataTransfer dt LEFT JOIN FETCH dt.dataTransferDetails d LEFT JOIN FETCH d.sourceVariable sv LEFT JOIN FETCH d.targetVariable tv WHERE dt.id IN :dataTransferIds")
    public Collection<DataTransfer> findAllInAllSpacesWithDetails(@Param(value="dataTransferIds") Set<String> var1);

    public List<DataTransfer> findByProjectIdAndNameIn(String var1, Set<String> var2);

    @Query(value="SELECT new com.inscada.mono.datatransfer.model.DataTransferSummary(d.id, d.name, d.projectId, d.dsc, d.period, d.createdBy, d.creationDate, d.lastModifiedBy, d.lastModifiedDate) FROM DataTransfer d")
    public List<DataTransferSummary> findSummary();

    @Query(value="SELECT new com.inscada.mono.datatransfer.model.DataTransferSummary(d.id, d.name, d.projectId, d.dsc, d.period, d.createdBy, d.creationDate, d.lastModifiedBy, d.lastModifiedDate) FROM DataTransfer d WHERE d.projectId = :projectId")
    public List<DataTransferSummary> findSummaryByProjectId(@Param(value="projectId") String var1);
}

