/*
 * Decompiled with CFR 0.152.
 */
package com.inscada.mono.communication.protocols.opcua.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.inscada.mono.communication.base.model.Connection;
import com.inscada.mono.communication.protocols.opcua.model.OpcUaDevice;
import com.inscada.mono.communication.protocols.opcua.p.c_Pe;
import com.inscada.mono.communication.protocols.opcua.p.c_eF;
import com.inscada.mono.communication.protocols.opcua.p.c_wE;
import com.inscada.mono.shared.converters.c_cB;
import jakarta.persistence.Column;
import jakarta.persistence.Convert;
import jakarta.persistence.Entity;
import jakarta.persistence.OneToMany;
import jakarta.persistence.Table;
import jakarta.validation.constraints.Max;
import jakarta.validation.constraints.Min;
import jakarta.validation.constraints.NotNull;
import java.util.HashSet;
import java.util.Set;
import org.hibernate.annotations.SQLRestriction;

@Entity
@Table(name="opc_ua_connection")
public class OpcUaConnection
extends Connection<OpcUaDevice> {
    @Min(value=0L)
    @Max(value=65535L)
    @Column(name="https_port")
    private Integer httpsPort;
    @NotNull
    @Column(name="security_mode")
    private c_eF securityMode;
    @NotNull
    @Column(name="is_username_password_authentication")
    private Boolean isUsernamePasswordAuthentication;
    @Column(name="encoding_type")
    private c_Pe encodingType;
    @Column(name="server_name")
    private String serverName;
    @NotNull
    @Column(name="security_policy")
    private c_wE securityPolicy;
    @Column(name="is_https_enabled")
    private Boolean isHttpsEnabled;
    @JsonIgnore
    @OneToMany(mappedBy="connection")
    @SQLRestriction(value="deleted_dttm IS NULL")
    protected Set<OpcUaDevice> devices;
    @NotNull
    @Column(name="is_anonymous_authentication")
    private Boolean isAnonymousAuthentication;
    @Column(name="username")
    private String username;
    @Column(name="password")
    @Convert(converter=c_cB.class)
    private String password;
    @Min(value=100L)
    @Column(name="timeout")
    private Integer timeoutInMs;

    public void setSecurityMode(c_eF c_eF2) {
        OpcUaConnection a = c_eF2;
        OpcUaConnection a2 = this;
        a2.securityMode = a;
    }

    public c_Pe getEncodingType() {
        OpcUaConnection a;
        return a.encodingType;
    }

    public String getServerName() {
        OpcUaConnection a;
        return a.serverName;
    }

    public Set<OpcUaDevice> getDevices() {
        OpcUaConnection a;
        return a.devices;
    }

    public void setPassword(String string) {
        Object a = string;
        OpcUaConnection a2 = this;
        a2.password = a;
    }

    public Boolean getIsHttpsEnabled() {
        OpcUaConnection a;
        return a.isHttpsEnabled;
    }

    public Boolean getIsUsernamePasswordAuthentication() {
        OpcUaConnection a;
        return a.isUsernamePasswordAuthentication;
    }

    public Boolean getIsAnonymousAuthentication() {
        OpcUaConnection a;
        return a.isAnonymousAuthentication;
    }

    public void setTimeoutInMs(Integer n) {
        Object a = n;
        OpcUaConnection a2 = this;
        a2.timeoutInMs = a;
    }

    public void setUsername(String string) {
        Object a = string;
        OpcUaConnection a2 = this;
        a2.username = a;
    }

    public c_eF getSecurityMode() {
        OpcUaConnection a;
        return a.securityMode;
    }

    public void setIsAnonymousAuthentication(Boolean bl) {
        Object a = bl;
        OpcUaConnection a2 = this;
        a2.isAnonymousAuthentication = a;
    }

    public void setSecurityPolicy(c_wE c_wE2) {
        OpcUaConnection a = c_wE2;
        OpcUaConnection a2 = this;
        a2.securityPolicy = a;
    }

    public Integer getHttpsPort() {
        OpcUaConnection a;
        return a.httpsPort;
    }

    public OpcUaConnection() {
        OpcUaConnection a;
        OpcUaConnection opcUaConnection = a;
        opcUaConnection.devices = new HashSet();
    }

    public void setServerName(String string) {
        Object a = string;
        OpcUaConnection a2 = this;
        a2.serverName = a;
    }

    public c_wE getSecurityPolicy() {
        OpcUaConnection a;
        return a.securityPolicy;
    }

    public String getUsername() {
        OpcUaConnection a;
        return a.username;
    }

    public String getPassword() {
        OpcUaConnection a;
        return a.password;
    }

    public void setDevices(Set<OpcUaDevice> set) {
        Object a = set;
        OpcUaConnection a2 = this;
        a2.devices = a;
    }

    public Integer getTimeoutInMs() {
        OpcUaConnection a;
        return a.timeoutInMs;
    }

    public void setIsUsernamePasswordAuthentication(Boolean bl) {
        Object a = bl;
        OpcUaConnection a2 = this;
        a2.isUsernamePasswordAuthentication = a;
    }

    public void setIsHttpsEnabled(Boolean bl) {
        Object a = bl;
        OpcUaConnection a2 = this;
        a2.isHttpsEnabled = a;
    }

    public void setHttpsPort(Integer n) {
        Object a = n;
        OpcUaConnection a2 = this;
        a2.httpsPort = a;
    }

    public void setEncodingType(c_Pe c_Pe2) {
        OpcUaConnection a = c_Pe2;
        OpcUaConnection a2 = this;
        a2.encodingType = a;
    }
}

