/*
 * Decompiled with CFR 0.152.
 */
package com.inscada.mono.communication.protocols.mqtt.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.inscada.mono.communication.base.model.Frame;
import com.inscada.mono.communication.base.p.c_VL;
import com.inscada.mono.communication.protocols.mqtt.model.MqttDevice;
import com.inscada.mono.communication.protocols.mqtt.model.MqttVariable;
import com.inscada.mono.expression.model.Expression;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.OneToMany;
import jakarta.persistence.Table;
import jakarta.validation.constraints.Max;
import jakarta.validation.constraints.Min;
import jakarta.validation.constraints.NotBlank;
import jakarta.validation.constraints.NotNull;
import java.util.HashSet;
import java.util.Set;
import org.hibernate.annotations.SQLRestriction;

@Entity
@Table(name="mqtt_frame")
public class MqttFrame
extends Frame<MqttDevice, MqttVariable> {
    @Column(name="publish_expression_type")
    private c_VL publishExpressionType;
    @NotNull
    @Min(value=0L)
    @Max(value=2L)
    private Integer qos;
    @Column(name="subscribe_expression_type")
    private c_VL subscribeExpressionType;
    @JsonIgnore
    @ManyToOne(optional=false)
    @SQLRestriction(value="deleted_dttm IS NULL")
    @JoinColumn(name="device_id")
    protected MqttDevice device;
    @JsonIgnore
    @OneToMany(mappedBy="frame")
    @SQLRestriction(value="deleted_dttm IS NULL")
    protected Set<MqttVariable> variables;
    @Column(name="subscribe_expression")
    private String subscribeExpressionCode;
    @NotBlank
    private String topic;
    @JsonIgnore
    @ManyToOne
    @SQLRestriction(value="deleted_dttm IS NULL")
    @JoinColumn(name="publish_expression_id")
    private Expression publishExpression;
    @Column(name="publish_expression")
    private String publishExpressionCode;
    @ManyToOne
    @SQLRestriction(value="deleted_dttm IS NULL")
    @JoinColumn(name="subscribe_expression_id")
    @JsonIgnore
    private Expression subscribeExpression;
    @Column(name="subscribe_expression_id", insertable=false, updatable=false)
    private String subscribeExpressionId;
    @Column(name="publish_expression_id", insertable=false, updatable=false)
    private String publishExpressionId;

    public MqttDevice getDevice() {
        MqttFrame a;
        return a.device;
    }

    public void setPublishExpression(Expression expression) {
        MqttFrame a;
        MqttFrame a2 = expression;
        MqttFrame mqttFrame = a = this;
        mqttFrame.publishExpression = a2;
        mqttFrame.publishExpressionId = a2 != null && a2.getId() != null ? a2.getId() : null;
    }

    public String getSubscribeExpressionCode() {
        MqttFrame a;
        return a.subscribeExpressionCode;
    }

    public Expression getSubscribeExpression() {
        MqttFrame a;
        return a.subscribeExpression;
    }

    public Integer getQos() {
        MqttFrame a;
        return a.qos;
    }

    public c_VL getSubscribeExpressionType() {
        MqttFrame a;
        return a.subscribeExpressionType;
    }

    public void setQos(Integer n) {
        Object a = n;
        MqttFrame a2 = this;
        a2.qos = a;
    }

    public String getTopic() {
        MqttFrame a;
        return a.topic;
    }

    public MqttFrame() {
        MqttFrame a;
        MqttFrame mqttFrame = a;
        mqttFrame.variables = new HashSet();
    }

    public void setSubscribeExpressionType(c_VL c_VL2) {
        MqttFrame a = c_VL2;
        MqttFrame a2 = this;
        a2.subscribeExpressionType = a;
    }

    public void setSubscribeExpressionCode(String string) {
        Object a = string;
        MqttFrame a2 = this;
        a2.subscribeExpressionCode = a;
    }

    public void setVariables(Set<MqttVariable> set) {
        Object a = set;
        MqttFrame a2 = this;
        a2.variables = a;
    }

    public String getPublishExpressionId() {
        MqttFrame a;
        return a.publishExpressionId;
    }

    public void setDevice(MqttDevice mqttDevice) {
        MqttFrame a;
        MqttFrame a2 = mqttDevice;
        MqttFrame mqttFrame = a = this;
        mqttFrame.device = a2;
        mqttFrame.deviceId = a2 != null && a2.getId() != null ? a2.getId() : null;
    }

    public String getPublishExpressionCode() {
        MqttFrame a;
        return a.publishExpressionCode;
    }

    public void setPublishExpressionType(c_VL c_VL2) {
        MqttFrame a = c_VL2;
        MqttFrame a2 = this;
        a2.publishExpressionType = a;
    }

    public void setTopic(String string) {
        Object a = string;
        MqttFrame a2 = this;
        a2.topic = a;
    }

    public void setPublishExpressionCode(String string) {
        Object a = string;
        MqttFrame a2 = this;
        a2.publishExpressionCode = a;
    }

    public void setSubscribeExpressionId(String string) {
        Object a = string;
        MqttFrame a2 = this;
        a2.subscribeExpressionId = a;
    }

    public String getSubscribeExpressionId() {
        MqttFrame a;
        return a.subscribeExpressionId;
    }

    public void setSubscribeExpression(Expression expression) {
        MqttFrame a;
        MqttFrame a2 = expression;
        MqttFrame mqttFrame = a = this;
        mqttFrame.subscribeExpression = a2;
        mqttFrame.subscribeExpressionId = a2 != null && a2.getId() != null ? a2.getId() : null;
    }

    public Expression getPublishExpression() {
        MqttFrame a;
        return a.publishExpression;
    }

    public c_VL getPublishExpressionType() {
        MqttFrame a;
        return a.publishExpressionType;
    }

    public void setPublishExpressionId(String string) {
        Object a = string;
        MqttFrame a2 = this;
        a2.publishExpressionId = a;
    }

    public Set<MqttVariable> getVariables() {
        MqttFrame a;
        return a.variables;
    }
}

