/*
 * Decompiled with CFR 0.152.
 */
package com.inscada.mono.communication.base.services;

import com.inscada.mono.auth.c_oL;
import com.inscada.mono.cluster.exceptions.ClusterRpcException;
import com.inscada.mono.cluster.services.ClusterNodeListener;
import com.inscada.mono.cluster.services.c_b;
import com.inscada.mono.communication.base.exceptions.BrowseOperationException;
import com.inscada.mono.communication.base.m.c_hJ;
import com.inscada.mono.communication.base.m.c_wK;
import com.inscada.mono.communication.base.model.Connection;
import com.inscada.mono.communication.base.model.ConnectionSummary;
import com.inscada.mono.communication.base.model.SetValueRequest;
import com.inscada.mono.communication.base.model.Variable;
import com.inscada.mono.communication.base.p.c_yl;
import com.inscada.mono.communication.base.services.c_AL;
import com.inscada.mono.communication.base.services.c_Ze;
import com.inscada.mono.communication.base.services.c_m;
import com.inscada.mono.communication.base.services.c_oI;
import com.inscada.mono.communication.base.services.m.c_Ff;
import com.inscada.mono.license.m.c_eA;
import com.inscada.mono.log.m.c_ac;
import com.inscada.mono.project.m.c_E;
import com.inscada.mono.shared.exceptions.NotActiveException;
import com.inscada.mono.shared.exceptions.NotFoundException;
import com.inscada.mono.shared.model.OwnedSpaceBaseModel;
import com.inscada.mono.shared.y.c_SC;
import jakarta.annotation.PostConstruct;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.stream.Collectors;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Component;
import org.springframework.transaction.event.TransactionalEventListener;
import redis.clients.jedis.JedisPooled;

@Component
public class ConnectionManager<C extends Connection<?>, V extends Variable<?, ?, ?>>
implements ClusterNodeListener,
c_E {
    public static final short f_Bs = 208;
    private final c_AL f_hu;
    private final c_oL f_Gu;
    public static final short f_ys = 205;
    public static final short f_et = 203;
    public static final short f_MS = 206;
    public static final short f_AS = 201;
    private final Lock f_gs;
    private static final Logger f_cT = LoggerFactory.getLogger(ConnectionManager.class);
    public static final short f_Xu = 204;
    public static final short f_RT = 202;
    private final JedisPooled f_xT;
    public static final short f_At = 207;
    private final c_ac f_lT;
    public static final short f_js = 209;
    private static final String f_cU = "activeConnections";
    private final c_oI<C, V> f_Yt;
    private final c_b f_US;
    public static final short f_FT = 210;
    private final c_eA f_YT;

    protected c_yl getConnectionStatusInternal(String string) {
        Object a = string;
        ConnectionManager a2 = this;
        if ((a = a2.f_Yt.m_fca((String)a)) != null && a.m_Vs()) {
            return c_yl.f_XR;
        }
        return c_yl.f_UT;
    }

    /*
     * WARNING - void declaration
     */
    @TransactionalEventListener(value={c_wK.class})
    public void handleRestartEvent(c_wK c_wK2) {
        void a;
        ConnectionManager connectionManager = this;
        if (connectionManager.f_US.m_fa()) {
            ConnectionManager a2 = a.m_DAa();
            f_cT.info(c_Ff.m_oR((Object)"\"6/7+!TS&\u0012\u0000\u0017\u0002\u001a\u0000\u0014N!\u000b\u0000\u001a\u0012\u001c\u0007+\u0005\u000b\u001d\u001aS\b\u001c\u001cS\r\u001c\u0000\u001d\u000b\u0010\u001a\u001a\u0001\u001dTS\u0015\u000eN['7TS\u0015\u000eG"), (Object)a2.getName(), (Object)a2.getId());
            connectionManager.f_gs.lock();
            try {
                if (connectionManager.getConnectionStatusInternal(a2.getId()) == c_yl.f_XR) {
                    connectionManager.startConnectionInternal(a2.getId());
                }
                return;
            }
            finally {
                connectionManager.f_gs.unlock();
            }
        }
        f_cT.debug(c_SC.m_eD((Object)"UDU&WNZO^Y!+Rludibul;Y~xoji\u007f^}~eo+}di+xdue~hobte!+`v"), (Object)a.m_DAa().getId());
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void restoreSingleConnectionOnLeader(Connection<?> connection) {
        void a;
        ConnectionManager connectionManager;
        ConnectionManager connectionManager2 = connectionManager = this;
        Object a2 = connectionManager2.f_US.m_ja();
        String[] stringArray = new String[--3];
        stringArray[3 & 4] = c_SC.m_eD((Object)"H_ZYOTXDUE^HOBTE");
        stringArray[4 ^ 5] = c_Ff.m_oR((Object)"='!#10!= 6-''< ");
        stringArray[5 >> 1] = c_SC.m_eD((Object)"MB^\\DHTEUNX_RDUTR_^F");
        connectionManager2.f_Gu.m_NDa(() -> connectionManager.lambda$restoreSingleConnectionOnLeader$1((String)a2, (Connection)a), a.getSpace(), stringArray);
    }

    @PreAuthorize(value="hasAuthority('VIEW_CONNECTION_ITEM')")
    public Object browseConnection(String string) {
        Object a = string;
        ConnectionManager a2 = this;
        if (a2.f_US.m_fa()) {
            f_cT.debug(c_SC.m_eD((Object)"WNZO^Y!+Knimtyvbul;iidlx~+t{~yz\u007frdu+}di+xdue~hobte;pf+wdxjwgb%"), a);
            return a2.browseConnectionInternal((String)a);
        }
        f_cT.debug(c_Ff.m_oR((Object)"=!=C?+2*6<IN!\u000b\u0002\u001b\u0016\u001d\u0007\u0007\u001d\tS\u0002\u0016\u000f\u0017\u000b\u0001N\u0007\u0001S\u001e\u0016\u001c\u0015\u0001\u0001\u0003S\f\u0001\u0001\u0004\u001d\u0016N\u001c\u001e\u0016\u001c\u0012\u001a\u001a\u0001\u001dN\u0015\u0001\u0001N\u0010\u0001\u001d\u0000\u0016\r\u0007\u0007\u001c\u0000S\u0015\u000e@"), a);
        try {
            Object[] objectArray = new Object[--1];
            objectArray[3 & 4] = a;
            return a2.f_US.m_w(Short.valueOf((short)(0x44FF & 0x3BD2)), objectArray);
        }
        catch (Exception exception) {
            throw new ClusterRpcException("Failed to RPC browse connection " + (String)a, (Throwable)exception);
        }
    }

    /*
     * WARNING - void declaration
     */
    @PreAuthorize(value="hasAuthority('START_CONNECTION')")
    public void startConnection(String string, String string2) {
        void a;
        ConnectionManager a2;
        Object a3 = string2;
        ConnectionManager connectionManager = a2 = this;
        connectionManager.startConnection(connectionManager.f_hu.m_Iba((String)a, (String)a3).getId());
    }

    /*
     * WARNING - void declaration
     */
    @PreAuthorize(value="hasAuthority('VIEW_CONNECTION_ITEM')")
    public c_yl getConnectionStatus(String string, String string2) {
        void a;
        Object a2 = string;
        ConnectionManager a3 = this;
        if ((a2 = a3.f_hu.m_yAa((String)a2, (String)a)) == null) {
            return c_yl.f_UT;
        }
        return a3.getConnectionStatus(a2.getId());
    }

    protected void startConnectionInternal(Connection<?> connection) {
        Connection<?> a = connection;
        Connection<?> a2 = this;
        a2.f_Gu.m_qFa(() -> {
            ConnectionManager a = a;
            ConnectionManager a2 = this;
            a2.f_gs.lock();
            try {
                a2.stopConnectionInternal((Connection)a);
                if (!Boolean.TRUE.equals(a.getProject().getIsActive())) {
                    throw new NotActiveException("Project should be active to start connection " + a.getName());
                }
                ConnectionManager connectionManager = a2;
                connectionManager.f_YT.m_gL();
                connectionManager.f_Yt.m_RBa((Connection)a).m_gs();
                String[] stringArray = new String[3 & 5];
                stringArray[5 >> 3] = a.getId();
                connectionManager.f_xT.sadd(f_cU, stringArray);
                return;
            }
            finally {
                a2.f_gs.unlock();
            }
        }, a);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void leader() {
        ConnectionManager connectionManager;
        ConnectionManager connectionManager2 = connectionManager = this;
        Object a = connectionManager2.f_US.m_ja();
        f_cT.info(c_Ff.m_oR((Object)"0\u0001\u001d\u0000\u0016\r\u0007\u0007\u001c\u0000>\u000f\u001d\u000f\u0014\u000b\u0001TS:\u001b\u0007\u0000N\u001d\u0001\u0017\u000bSF\b\u0013ZN\u001b\u000f\u0000N\u0011\u000b\u0010\u0001\u001e\u000bS\u001a\u001b\u000bS\"6/7+!@S<\u0016\u001d\u0007\u0001\u0001\u0007\u001d\tS\u000f\u0010\u001a\u001a\u0018\u0016N\u0010\u0001\u001d\u0000\u0016\r\u0007\u0007\u001c\u0000\u0000@]@"), a);
        connectionManager2.f_gs.lock();
        try {
            HashSet hashSet = new HashSet(connectionManager.f_xT.smembers(f_cU));
            if (hashSet.isEmpty()) {
                f_cT.info(c_SC.m_eD((Object)"Hteunx\u007frduFzezl~y;#Wnzo~y;pf\"!+Ud;jx\u007fr}~+xdue~hobteh+}dne\u007f+re;Y~orx;\u007ft+inh\u007fty~%"), a);
                return;
            }
            Object[] objectArray = new Object[--3];
            objectArray[3 ^ 3] = a;
            objectArray[3 & 5] = hashSet.size();
            objectArray[5 >> 1] = hashSet;
            f_cT.info(c_Ff.m_oR((Object)"-\u001c\u0000\u001d\u000b\u0010\u001a\u001a\u0001\u001d#\u0012\u0000\u0012\t\u0016\u001cSF?\u000b\u0012\n\u0016\u001cS\u0015\u000eGIN5\u0001\u0006\u0000\u0017N\b\u0013S\u000f\u0010\u001a\u001a\u0018\u0016N\u0010\u0001\u001d\u0000\u0016\r\u0007\u0007\u001c\u0000S'7\u001dS\u0007\u001dN!\u000b\u0017\u0007\u0000N\u0007\u0001S\u001c\u0016\u001d\u0007\u0001\u0001\u000bIN\b\u0013"), objectArray);
            Object object = new ArrayList();
            String[] stringArray = new String[2 ^ 3];
            stringArray[2 & 5] = c_SC.m_eD((Object)"MB^\\DHTEUNX_RDUTR_^F");
            connectionManager.f_Gu.m_uea(() -> {
                void a;
                Object a2 = hashSet;
                ConnectionManager a3 = this;
                a.addAll(a3.f_hu.m_jCa((Set)a2));
            }, stringArray);
            f_cT.info(c_Ff.m_oR((Object)"0\u0001\u001d\u0000\u0016\r\u0007\u0007\u001c\u0000>\u000f\u001d\u000f\u0014\u000b\u0001N[\"\u0016\u000f\u0017\u000b\u0001N\b\u0013ZTS/\u0007\u001a\u0016\u0003\u0003\u001a\u001a\u0000\u0014N\u0007\u0001S\u001c\u0016\u001d\u0007\u0001\u0001\u000bS\u0015\u000eN\u0010\u0001\u001d\u0000\u0016\r\u0007\u0007\u001c\u0000\u0000@"), a, (Object)object.size());
            Object object2 = object = object.iterator();
            while (object2.hasNext()) {
                Connection connection = (Connection)object.next();
                object2 = object;
                connectionManager.restoreSingleConnectionOnLeader(connection);
            }
            f_cT.info(c_SC.m_eD((Object)"Hteunx\u007frduFzezl~y;#Wnzo~y;pf\"!+]bubhc~o;hteunx\u007frdu+inh\u007ftyz\u007frdu+kyth~xh%"), a);
            return;
        }
        catch (Exception exception) {
            Object[] objectArray = new Object[--3];
            objectArray[3 ^ 3] = a;
            objectArray[5 >> 2] = exception.getMessage();
            objectArray[1 ^ 3] = exception;
            f_cT.error(c_Ff.m_oR((Object)"0\u0001\u001d\u0000\u0016\r\u0007\u0007\u001c\u0000>\u000f\u001d\u000f\u0014\u000b\u0001N[\"\u0016\u000f\u0017\u000b\u0001N\b\u0013ZTS+\u0001\u001c\u001c\u001cS\n\u0006\u001c\u001a\u0000\u0014N\u0010\u0001\u001d\u0000\u0016\r\u0007\u0007\u001c\u0000S\u001c\u0016\u001d\u0007\u0001\u0001\u000f\u0007\u0007\u001c\u0000S\u001e\u0001\u0001\u0010\u000b\u0000\u001dIN\b\u0013"), objectArray);
            return;
        }
        finally {
            connectionManager.f_gs.unlock();
        }
    }

    private /* synthetic */ Object lambda$browseConnectionInternal$2(String string) throws Exception {
        Object a = string;
        ConnectionManager a2 = this;
        if ((a = a2.f_Yt.m_fca((String)a)) instanceof c_m) {
            return ((c_m)a).m_p();
        }
        throw new BrowseOperationException(c_Ff.m_oR((Object)"1\u001c\u001c\u0019\u0000\u000bS\u0001\u0003\u000b\u0001\u000f\u0007\u0007\u001c\u0000S\u0000\u001c\u001aS\u001d\u0006\u001e\u0003\u0001\u0001\u001a\u0016\n"));
    }

    private /* synthetic */ void registerRemoteCallsWithClusterNode() {
        ConnectionManager connectionManager = this;
        try {
            Class[] classArray = new Class[5 >> 2];
            classArray[3 & 4] = String.class;
            connectionManager.f_US.m_Da((short)(0x67ED & 0x18DB), (Object)connectionManager, ConnectionManager.class.getDeclaredMethod(c_SC.m_eD((Object)"xoji\u007fXdue~hobteReoniezg"), classArray));
            Class[] classArray2 = new Class[3 & 5];
            classArray2[3 & 4] = String.class;
            connectionManager.f_US.m_Da((short)(0x3EEF & 0x41DA), (Object)connectionManager, ConnectionManager.class.getDeclaredMethod(c_Ff.m_oR((Object)"\u0000\u001a\u001c\u001e0\u0001\u001d\u0000\u0016\r\u0007\u0007\u001c\u0000:\u0000\u0007\u000b\u0001\u0000\u0012\u0002"), classArray2));
            Class[] classArray3 = new Class[--1];
            classArray3[5 >> 3] = String.class;
            connectionManager.f_US.m_Da((short)(0x4CEF & 0x33DB), (Object)connectionManager, ConnectionManager.class.getDeclaredMethod(c_SC.m_eD((Object)"l~\u007fXdue~hobteH\u007fz\u007fnxReoniezg"), classArray3));
            Class[] classArray4 = new Class[--1];
            classArray4[3 ^ 3] = SetValueRequest.class;
            connectionManager.f_US.m_Da((short)(0x7CC & 0x78FF), (Object)connectionManager, ConnectionManager.class.getDeclaredMethod(c_Ff.m_oR((Object)"\u0000\u000b\u00078\u0012\u001c\u001a\u000f\u0011\u0002\u00168\u0012\u0002\u0006\u000b:\u0000\u0007\u000b\u0001\u0000\u0012\u0002"), classArray4));
            Class[] classArray5 = new Class[3 & 5];
            classArray5[3 >> 2] = Collection.class;
            connectionManager.f_US.m_Da((short)(0x13CF & 0x6CFD), (Object)connectionManager, ConnectionManager.class.getDeclaredMethod(c_SC.m_eD((Object)"x~\u007fMjibziwnMjw~~xReoniezg"), classArray5));
            Class[] classArray6 = new Class[1];
            classArray6[0] = String.class;
            connectionManager.f_US.m_Da((short)(0x53DF & 0x2CEE), (Object)connectionManager, ConnectionManager.class.getDeclaredMethod(c_Ff.m_oR((Object)"\u001d\u0007\u000f\u0001\u001a0\u0001\u001d\u0000\u0016\r\u0007\u0007\u001c\u0000\u0000,\n>\u0001\u0001\u0019\u000b\u0010\u001a:\n:\u0000\u0007\u000b\u0001\u0000\u0012\u0002"), classArray6));
            Class[] classArray7 = new Class[1];
            classArray7[0] = String.class;
            connectionManager.f_US.m_Da((short)(0x30CF & 0x4FFF), (Object)connectionManager, ConnectionManager.class.getDeclaredMethod(c_SC.m_eD((Object)"h\u007ft{Xdue~hobtehIb[idqnx\u007fRoReoniezg"), classArray7));
            Class[] classArray8 = new Class[1];
            classArray8[0] = String.class;
            connectionManager.f_US.m_Da((short)(0x51DB & 0x2EF4), (Object)connectionManager, ConnectionManager.class.getDeclaredMethod(c_Ff.m_oR((Object)"\u0014\u000b\u0007-\u001c\u0000\u001d\u000b\u0010\u001a\u001a\u0001\u001d=\u0007\u000f\u0007\u001b\u0000\u000b\u0000,\n>\u0001\u0001\u0019\u000b\u0010\u001a:\n:\u0000\u0007\u000b\u0001\u0000\u0012\u0002"), classArray8));
            Class[] classArray9 = new Class[1];
            classArray9[0] = String[].class;
            connectionManager.f_US.m_Da((short)(0x6EFF & 0x11D1), (Object)connectionManager, ConnectionManager.class.getDeclaredMethod(c_SC.m_eD((Object)"|noHteunx\u007frduXojo~hnhIbB\u007fxReoniezg"), classArray9));
            Class[] classArray10 = new Class[1];
            classArray10[0] = String.class;
            connectionManager.f_US.m_Da((short)(0x7BF6 & 0x4DB), (Object)connectionManager, ConnectionManager.class.getDeclaredMethod(c_Ff.m_oR((Object)"\u0011\u001c\u001c\u0019\u0000\u000b0\u0001\u001d\u0000\u0016\r\u0007\u0007\u001c\u0000:\u0000\u0007\u000b\u0001\u0000\u0012\u0002"), classArray10));
            return;
        }
        catch (NoSuchMethodException a) {
            throw new IllegalStateException(c_SC.m_eD((Object)"]jrg~o;\u007ft+in|bh\u007f~y;Hteunx\u007frduFzezl~y;YKH;f~\u007fsd\u007fx"), a);
        }
    }

    protected void stopConnectionInternal(Connection<?> connection) {
        Connection<?> a = connection;
        Connection<?> a2 = this;
        a2.f_Gu.m_qFa(() -> {
            ConnectionManager a = a;
            ConnectionManager a2 = this;
            a2.f_gs.lock();
            try {
                c_Ze c_Ze2 = a2.f_Yt.m_fca(a.getId());
                if (c_Ze2 != null) {
                    c_Ze2.m_Gs();
                    a2.f_Yt.m_Tba(a.getId(), c_Ze2);
                }
                String[] stringArray = new String[3 >> 1];
                stringArray[5 >> 3] = a.getId();
                a2.f_xT.srem(f_cU, stringArray);
                return;
            }
            finally {
                a2.f_gs.unlock();
            }
        }, a);
    }

    @PreAuthorize(value="hasAuthority('SET_VARIABLE_VALUE')")
    public void setVariableValues(Collection<SetValueRequest<V>> collection) {
        Collection<SetValueRequest<V>> a22 = collection;
        ConnectionManager a3 = this;
        if (a22 == null || a22.isEmpty()) {
            return;
        }
        a22.forEach(a -> Objects.requireNonNull(a, c_SC.m_eD((Object)"Hno]zgnnInj~~xo+xjuet\u007f;i~+u~wg")));
        a22.forEach(a -> Objects.requireNonNull(a.getConnectionId(), c_Ff.m_oR((Object)"0\u0001\u001d\u0000\u0016\r\u0007\u0007\u001c\u0000:\nS\u0007\u001dN \u000b\u00078\u0012\u0002\u0006\u000b!\u000b\u0002\u001b\u0016\u001d\u0007N\u0010\u000f\u001d\u0000\u001c\u001aS\f\u0016N\u001d\u001b\u001f\u0002")));
        if (a3.f_US.m_fa()) {
            f_cT.debug(c_SC.m_eD((Object)"G^J_NI1;X~\u007fobul;pf+mjibziwn;}zgnnh+wdxjwgb%"), (Object)a22.size());
            a3.setVariableValuesInternal((Collection)a22);
            return;
        }
        f_cT.debug(c_Ff.m_oR((Object)"=!=C?+2*6<IN!\u000b\u0002\u001b\u0016\u001d\u0007\u0007\u001d\tS\u0002\u0016\u000f\u0017\u000b\u0001N\u0007\u0001S\u001d\u0016\u001aS\u0015\u000eN\u0005\u000f\u0001\u0007\u0012\f\u001f\u000bS\u0018\u0012\u0002\u0006\u000b\u0000@"), (Object)a22.size());
        try {
            Object[] objectArray = new Object[3 & 5];
            objectArray[3 ^ 3] = new ArrayList(a22);
            a3.f_US.m_w(Short.valueOf((short)(0x16FD & 0x69CF)), objectArray);
            return;
        }
        catch (Exception a22) {
            throw new ClusterRpcException(c_SC.m_eD((Object)"Mzbwn\u007f+od;YKH;x~\u007f;}zyrjyg~+mjw~~x"), (Throwable)a22);
        }
    }

    @PreAuthorize(value="hasAuthority('VIEW_CONNECTION_ITEM')")
    public c_yl getConnectionStatus(String string) {
        Object a = string;
        ConnectionManager a2 = this;
        if (a2.f_US.m_fa()) {
            f_cT.debug(c_SC.m_eD((Object)"G^J_NI1;L~\u007fobul;hteunx\u007frdu+h\u007fz\u007fnx;mty;pf+wdxjwgb%"), a);
            return a2.getConnectionStatusInternal((String)a);
        }
        f_cT.debug(c_Ff.m_oR((Object)" < ^\"6/7+!TS<\u0016\u001f\u0006\u000b\u0000\u001a\u001a\u0000\u0014N\u001f\u000b\u0012\n\u0016\u001cS\b\u001c\u001cS\r\u001c\u0000\u001d\u000b\u0010\u001a\u001a\u0001\u001dN\u0000\u001a\u0012\u001a\u0006\u001dS\b\u001c\u001cS\u0015\u000e@"), a);
        try {
            Object[] objectArray = new Object[--1];
            objectArray[3 ^ 3] = a;
            return (c_yl)a2.f_US.m_w(Short.valueOf((short)(0x7CB & 0x78FF)), objectArray);
        }
        catch (Exception exception) {
            throw new ClusterRpcException("Failed to RPC get connection status for " + (String)a, (Throwable)exception);
        }
    }

    private /* synthetic */ Connection<?> loadConnectionWithDetails(Connection<?> connection) {
        Connection<?> a = connection;
        Connection<?> a2 = this;
        if (a == null) {
            return null;
        }
        return a2.f_hu.m_Jba(a.getId());
    }

    @PreAuthorize(value="hasAuthority('VIEW_CONNECTION_ITEM')")
    public Map<String, c_yl> getConnectionStatuses(String string) {
        Object a = string;
        ConnectionManager a2 = this;
        if (a2.f_US.m_fa()) {
            f_cT.debug(c_SC.m_eD((Object)"G^J_NI1;L~\u007fobul;jwg;hteunx\u007frdu+h\u007fz\u007fnx~x;mty;{idqnx\u007f;pf+wdxjwgb%"), a);
            return a2.getConnectionStatusesByProjectIdInternal((String)a);
        }
        f_cT.debug(c_Ff.m_oR((Object)" < ^\"6/7+!TS<\u0016\u001f\u0006\u000b\u0000\u001a\u001a\u0000\u0014N\u001f\u000b\u0012\n\u0016\u001cS\b\u001c\u001cS\u000f\u001f\u0002S\r\u001c\u0000\u001d\u000b\u0010\u001a\u001a\u0001\u001dN\u0000\u001a\u0012\u001a\u0006\u001d\u0016\u001dS\b\u001c\u001cS\u001e\u0001\u0001\u0019\u000b\u0010\u001aS\u0015\u000e@"), a);
        try {
            Object[] objectArray = new Object[4 ^ 5];
            objectArray[3 ^ 3] = a;
            return (Map)a2.f_US.m_w(Short.valueOf((short)(0x2DFB & 0x52D4)), objectArray);
        }
        catch (Exception exception) {
            throw new ClusterRpcException("Failed to RPC get connection statuses for project " + (String)a, (Throwable)exception);
        }
    }

    /*
     * WARNING - void declaration
     */
    @PreAuthorize(value="hasAuthority('STOP_CONNECTION')")
    public void stopConnection(String string, String string2) {
        void a;
        ConnectionManager a2;
        Object a3 = string2;
        ConnectionManager connectionManager = a2 = this;
        connectionManager.stopConnection(connectionManager.f_hu.m_Iba((String)a, (String)a3).getId());
    }

    public void notLeader() {
        ConnectionManager connectionManager;
        ConnectionManager connectionManager2 = connectionManager = this;
        Object a = connectionManager2.f_US.m_ja();
        f_cT.info(c_Ff.m_oR((Object)"-\u001c\u0000\u001d\u000b\u0010\u001a\u001a\u0001\u001d#\u0012\u0000\u0012\t\u0016\u001cIN'\u0006\u001a\u001dS\u0000\u001c\n\u0016N[\u0015\u000eGS\u0007\u0000N=!S\"< 4+!N'&6N?+2*6<]N \u001a\u001c\u001e\u0003\u0007\u001d\tS\u000f\u001f\u0002S\u0002\u001c\r\u0012\u0002S\r\u001c\u0000\u001d\u000b\u0010\u001a\u001c\u001c\u0000@]@"), a);
        connectionManager2.f_gs.lock();
        try {
            connectionManager.f_Yt.m_PCa();
            f_cT.info(c_SC.m_eD((Object)"Xdue~hobteVjuj|ni+3Et\u007f;G~j\u007fni+`v21;Jwg;gthzg;hteunx\u007ftyh+sjmn;i~nu+inj~~xon\u007f+od;xodk+ze\u007f+xg~jin\u007f+}ytf;gthzg;\u007fijx`re|%"), a);
            return;
        }
        catch (Exception exception) {
            Object[] objectArray = new Object[--3];
            objectArray[3 >> 2] = a;
            objectArray[--1] = exception.getMessage();
            objectArray[1 ^ 3] = exception;
            f_cT.error(c_Ff.m_oR((Object)"0\u0001\u001d\u0000\u0016\r\u0007\u0007\u001c\u0000>\u000f\u001d\u000f\u0014\u000b\u0001N[ \u001c\u001aS\"\u0016\u000f\u0017\u000b\u0001N\b\u0013ZTS+\u0001\u001c\u001c\u001cS\n\u0006\u001c\u001a\u0000\u0014N\u0003\u001c\u001c\r\u0016\u001d\u0000N\u001c\bS\u001d\u0007\u0001\u0003\u001e\u001a\u0000\u0014N\u001f\u0001\u0010\u000f\u001fN\u0010\u0001\u001d\u0000\u0016\r\u0007\u0001\u0001\u001dIN\b\u0013"), objectArray);
            return;
        }
        finally {
            connectionManager.f_gs.unlock();
        }
    }

    /*
     * WARNING - void declaration
     */
    protected Object browseConnectionInternal(String string) {
        void a;
        ConnectionManager connectionManager;
        ConnectionManager connectionManager2 = connectionManager = this;
        ConnectionManager a2 = connectionManager2.f_hu.m_UAa((String)a);
        return connectionManager2.f_Gu.m_kDa(() -> connectionManager.lambda$browseConnectionInternal$2((String)a), (OwnedSpaceBaseModel)a2);
    }

    @PreAuthorize(value="hasAuthority('VIEW_CONNECTION_ITEM')")
    public Map<String, c_yl> getConnectionStatuses(String[] stringArray) {
        Object[] a = stringArray;
        Object[] a2 = this;
        if (a == null || a.length == 0) {
            return Collections.emptyMap();
        }
        if (a2.f_US.m_fa()) {
            f_cT.debug(c_SC.m_eD((Object)"G^J_NI1;L~\u007fobul;hteunx\u007frdu+h\u007fz\u007fnx~x;mty;pf+ROh+wdxjwgb%"), (Object)a.length);
            return a2.getConnectionStatusesByIdsInternal((String[])a);
        }
        f_cT.debug(c_Ff.m_oR((Object)" < ^\"6/7+!TS<\u0016\u001f\u0006\u000b\u0000\u001a\u001a\u0000\u0014N\u001f\u000b\u0012\n\u0016\u001cS\b\u001c\u001cS\r\u001c\u0000\u001d\u000b\u0010\u001a\u001a\u0001\u001dN\u0000\u001a\u0012\u001a\u0006\u001d\u0016\u001dS\b\u001c\u001cS\u0015\u000eN:*\u0000@"), (Object)a.length);
        try {
            Object[] objectArray = new Object[2 ^ 3];
            objectArray[5 >> 3] = a;
            return (Map)a2.f_US.m_w(Short.valueOf((short)(0x46DD & 0x39F3)), objectArray);
        }
        catch (Exception exception) {
            throw new ClusterRpcException("Failed to RPC get connection statuses for IDs " + Arrays.toString(a), (Throwable)exception);
        }
    }

    @PreAuthorize(value="hasAuthority('START_CONNECTION')")
    public void startConnections(String string) {
        Object a = string;
        ConnectionManager a2 = this;
        if (a2.f_US.m_fa()) {
            f_cT.debug(c_SC.m_eD((Object)"WNZO^Y!+H\u007fzyobul;jwg;hteunx\u007frdux;mty;{idqnx\u007f;pf+wdxjwgb%"), a);
            a2.startConnectionsByProjectIdInternal((String)a);
            return;
        }
        f_cT.debug(c_Ff.m_oR((Object)"=!=C?+2*6<IN!\u000b\u0002\u001b\u0016\u001d\u0007\u0007\u001d\tS\u0002\u0016\u000f\u0017\u000b\u0001N\u0007\u0001S\u001d\u0007\u000f\u0001\u001aS\u000f\u001f\u0002S\r\u001c\u0000\u001d\u000b\u0010\u001a\u001a\u0001\u001d\u001dS\b\u001c\u001cS\u001e\u0001\u0001\u0019\u000b\u0010\u001aS\u0015\u000e@"), a);
        try {
            Object[] objectArray = new Object[--1];
            objectArray[5 >> 3] = a;
            a2.f_US.m_w(Short.valueOf((short)(0x28DF & 0x57EE)), objectArray);
            return;
        }
        catch (Exception exception) {
            throw new ClusterRpcException("Failed to RPC start connections for project " + (String)a, (Throwable)exception);
        }
    }

    @PostConstruct
    private /* synthetic */ void initializeClusterIntegration() {
        ConnectionManager a;
        ConnectionManager connectionManager = a;
        connectionManager.registerRemoteCallsWithClusterNode();
        connectionManager.f_US.m_Ja((ClusterNodeListener)a);
        f_cT.info(c_Ff.m_oR((Object)"0\u0001\u001d\u0000\u0016\r\u0007\u0007\u001c\u0000>\u000f\u001d\u000f\u0014\u000b\u0001N\u001a\u0000\u001a\u001a\u001a\u000f\u001f\u0007\t\u000b\u0017N\u0012\u0000\u0017N\u0001\u000b\u0014\u0007\u0000\u001a\u0016\u001c\u0016\nS\u000f\u0000N0\u0002\u0006\u001d\u0007\u000b\u0001 \u001c\n\u0016\"\u001a\u001d\u0007\u000b\u001d\u000b\u0001@"));
    }

    public void deactivateForProject(String string) {
        Object a = string;
        ConnectionManager a2 = this;
        if (a2.f_US.m_fa()) {
            f_cT.info(c_Ff.m_oR((Object)"?+2*6<IN;\u000f\u001d\n\u001f\u0007\u001d\tS>\u0001\u0001\u0019\u000b\u0010\u001a7\u000b\u0012\r\u0007\u0007\u0005\u000f\u0007\u000b6\u0018\u0016\u0000\u0007N\u0015\u0001\u0001N\u0003\u001c\u001c\u0004\u0016\r\u0007N:*IN\b\u0013"), a);
            a2.stopConnectionsByProjectIdInternal((String)a);
            return;
        }
        f_cT.debug(c_SC.m_eD((Object)"UDU&WNZO^Y!+Rludibul;[idqnx\u007f_nzhobmjon^}~eo+}di+kyta~ho+RO!+`v"), a);
    }

    protected Map<String, c_yl> getConnectionStatusesByIdsInternal(String[] stringArray) {
        String[] a2 = stringArray;
        String[] a3 = this;
        return Arrays.stream(a2).collect(Collectors.toMap(a -> a, arg_0 -> ((ConnectionManager)a3).getConnectionStatusInternal(arg_0)));
    }

    protected void stopConnectionInternal(String string) {
        ConnectionManager a;
        Object a2 = string;
        ConnectionManager connectionManager = a = this;
        connectionManager.stopConnectionInternal(connectionManager.f_hu.m_UAa((String)a2));
    }

    protected void stopConnectionsByProjectIdInternal(String string) {
        Object a = string;
        ConnectionManager a2 = this;
        if ((a = a2.f_hu.m_pBa((String)a)) == null || a.isEmpty()) {
            return;
        }
        a.forEach(arg_0 -> a2.stopConnectionInternal(arg_0));
    }

    protected void startConnectionsByProjectIdInternal(String string) {
        Object a = string;
        ConnectionManager a2 = this;
        if ((a = a2.f_hu.m_pBa((String)a)) == null || a.isEmpty()) {
            return;
        }
        Object object = a = a.iterator();
        while (object.hasNext()) {
            Connection connection = (Connection)a.next();
            ConnectionManager connectionManager = a2;
            connectionManager.startConnectionInternal(connectionManager.loadConnectionWithDetails(connection));
            object = a;
        }
    }

    @PreAuthorize(value="hasAuthority('STOP_CONNECTION')")
    public void stopConnections(String string) {
        Object a = string;
        ConnectionManager a2 = this;
        if (a2.f_US.m_fa()) {
            f_cT.debug(c_SC.m_eD((Object)"WNZO^Y!+H\u007ft{kbul;jwg;hteunx\u007frdux;mty;{idqnx\u007f;pf+wdxjwgb%"), a);
            a2.stopConnectionsByProjectIdInternal((String)a);
            return;
        }
        f_cT.debug(c_Ff.m_oR((Object)" < ^\"6/7+!TS<\u0016\u001f\u0006\u000b\u0000\u001a\u001a\u0000\u0014N\u001f\u000b\u0012\n\u0016\u001cS\u001a\u001cN\u0000\u001a\u001c\u001eS\u000f\u001f\u0002S\r\u001c\u0000\u001d\u000b\u0010\u001a\u001a\u0001\u001d\u001dS\b\u001c\u001cS\u001e\u0001\u0001\u0019\u000b\u0010\u001aS\u0015\u000e@"), a);
        try {
            Object[] objectArray = new Object[5 >> 2];
            objectArray[5 >> 3] = a;
            a2.f_US.m_w(Short.valueOf((short)(0x52EF & 0x2DDF)), objectArray);
            return;
        }
        catch (Exception exception) {
            throw new ClusterRpcException("Failed to RPC stop connections for project " + (String)a, (Throwable)exception);
        }
    }

    protected void setVariableValueInternal(SetValueRequest<V> setValueRequest) {
        SetValueRequest<V> a = setValueRequest;
        SetValueRequest<V> a2 = this;
        c_Ze c_Ze2 = a2.f_Yt.m_fca(a.getConnectionId());
        if (c_Ze2 == null) {
            throw new NotFoundException("Connector for connection " + a.getConnectionId() + " not found or not active on leader.");
        }
        c_Ze2.m_eS(a);
    }

    @PreAuthorize(value="hasAuthority('SET_VARIABLE_VALUE')")
    public void setVariableValue(SetValueRequest<V> setValueRequest) {
        SetValueRequest<V> a = setValueRequest;
        SetValueRequest<V> a2 = this;
        Objects.requireNonNull(a, c_SC.m_eD((Object)"Hno]zgnnInj~~xo+xjuet\u007f;i~+u~wg"));
        Objects.requireNonNull(a.getConnectionId(), c_Ff.m_oR((Object)"0\u0001\u001d\u0000\u0016\r\u0007\u0007\u001c\u0000:\nS\u0007\u001dN \u000b\u00078\u0012\u0002\u0006\u000b!\u000b\u0002\u001b\u0016\u001d\u0007N\u0010\u000f\u001d\u0000\u001c\u001aS\f\u0016N\u001d\u001b\u001f\u0002"));
        if (a2.f_US.m_fa()) {
            f_cT.debug(c_SC.m_eD((Object)"WNZO^Y!+Hno\u007fre|+mjibziwn;}zgnn;mty;hteunx\u007frdu+`v;gthzgwr!+`v"), (Object)a.getConnectionId(), a);
            a2.setVariableValueInternal(a);
            return;
        }
        f_cT.debug(c_Ff.m_oR((Object)" < ^\"6/7+!TS<\u0016\u001f\u0006\u000b\u0000\u001a\u001a\u0000\u0014N\u001f\u000b\u0012\n\u0016\u001cS\u001a\u001cN\u0000\u000b\u0007N\u0005\u000f\u0001\u0007\u0012\f\u001f\u000bS\u0018\u0012\u0002\u0006\u000bS\b\u001c\u001cS\r\u001c\u0000\u001d\u000b\u0010\u001a\u001a\u0001\u001dN\b\u0013IN\b\u0013"), (Object)a.getConnectionId(), a);
        try {
            Object[] objectArray = new Object[2 ^ 3];
            objectArray[2 & 5] = a;
            a2.f_US.m_w(Short.valueOf((short)(0x7BDF & 0x4EC)), objectArray);
            return;
        }
        catch (Exception exception) {
            throw new ClusterRpcException("Failed to RPC set variable value for connection " + a.getConnectionId(), (Throwable)exception);
        }
    }

    /*
     * WARNING - void declaration
     */
    public ConnectionManager(c_AL c_AL2, c_eA c_eA2, c_ac c_ac2, c_oI<C, V> c_oI2, JedisPooled jedisPooled, c_b c_b2, c_oL c_oL2) {
        ConnectionManager a;
        void a2;
        void a3;
        void a4;
        void a5;
        void a6;
        void a7;
        ConnectionManager a8;
        ConnectionManager connectionManager = connectionManager2;
        ConnectionManager connectionManager2 = c_oL2;
        ConnectionManager connectionManager3 = a8 = connectionManager;
        ConnectionManager connectionManager4 = a8;
        ConnectionManager connectionManager5 = a8;
        ConnectionManager connectionManager6 = a8;
        a8.f_gs = new ReentrantLock();
        a8.f_hu = a7;
        connectionManager5.f_YT = a6;
        connectionManager5.f_lT = a5;
        connectionManager4.f_Yt = a4;
        connectionManager4.f_xT = a3;
        connectionManager3.f_US = a2;
        connectionManager3.f_Gu = a;
    }

    protected void setVariableValuesInternal(Collection<SetValueRequest<V>> collection) {
        Collection<SetValueRequest<V>> a = collection;
        ConnectionManager a2 = this;
        a.stream().collect(Collectors.groupingBy(SetValueRequest::getConnectionId)).forEach((string, list) -> {
            Object a = string;
            ConnectionManager a2 = this;
            if ((a = a2.f_Yt.m_fca((String)a)) != null) {
                void a3;
                a.m_RS((List)a3);
            }
        });
    }

    protected Map<String, c_yl> getConnectionStatusesByProjectIdInternal(String string) {
        Object a = string;
        ConnectionManager a2 = this;
        if ((a = a2.f_hu.m_jba((String)a)) == null || a.isEmpty()) {
            return Collections.emptyMap();
        }
        return a.stream().collect(Collectors.toMap(ConnectionSummary::getId, connectionSummary -> {
            ConnectionManager a = connectionSummary;
            ConnectionManager a2 = this;
            return a2.getConnectionStatusInternal(a.getId());
        }));
    }

    @PreAuthorize(value="hasAuthority('START_CONNECTION')")
    public void startConnection(String string) {
        Object a = string;
        ConnectionManager a2 = this;
        if (a2.f_US.m_fa()) {
            f_cT.debug(c_SC.m_eD((Object)"G^J_NI1;Xoji\u007fre|+xdue~hobte;pf+wdxjwgb%"), a);
            a2.startConnectionInternal((String)a);
            return;
        }
        f_cT.debug(c_Ff.m_oR((Object)" < ^\"6/7+!TS<\u0016\u001f\u0006\u000b\u0000\u001a\u001a\u0000\u0014N\u001f\u000b\u0012\n\u0016\u001cS\u001a\u001cN\u0000\u001a\u0012\u001c\u0007N\u0010\u0001\u001d\u0000\u0016\r\u0007\u0007\u001c\u0000S\u0015\u000e@"), a);
        try {
            Object[] objectArray = new Object[5 >> 2];
            objectArray[3 >> 2] = a;
            a2.f_US.m_w(Short.valueOf((short)(0x5CEB & 0x23DD)), objectArray);
            return;
        }
        catch (Exception exception) {
            throw new ClusterRpcException("Failed to RPC start connection " + (String)a, (Throwable)exception);
        }
    }

    @PreAuthorize(value="hasAuthority('STOP_CONNECTION')")
    public void stopConnection(String string) {
        Object a = string;
        ConnectionManager a2 = this;
        if (a2.f_US.m_fa()) {
            f_cT.debug(c_SC.m_eD((Object)"G^J_NI1;Xodk{re|+xdue~hobte;pf+wdxjwgb%"), a);
            a2.stopConnectionInternal((String)a);
            return;
        }
        f_cT.debug(c_Ff.m_oR((Object)"=!=C?+2*6<IN!\u000b\u0002\u001b\u0016\u001d\u0007\u0007\u001d\tS\u0002\u0016\u000f\u0017\u000b\u0001N\u0007\u0001S\u001d\u0007\u0001\u0003N\u0010\u0001\u001d\u0000\u0016\r\u0007\u0007\u001c\u0000S\u0015\u000e@"), a);
        try {
            Object[] objectArray = new Object[3 & 5];
            objectArray[3 >> 2] = a;
            a2.f_US.m_w(Short.valueOf((short)(0x57EE & 0x28DB)), objectArray);
            return;
        }
        catch (Exception exception) {
            throw new ClusterRpcException("Failed to RPC stop connection " + (String)a, (Throwable)exception);
        }
    }

    /*
     * WARNING - void declaration
     */
    @TransactionalEventListener(value={c_hJ.class})
    public void handleDeleteEvent(c_hJ c_hJ2) {
        void a;
        ConnectionManager connectionManager = this;
        if (connectionManager.f_US.m_fa()) {
            ConnectionManager a2 = a.m_ica();
            f_cT.info(c_Ff.m_oR((Object)"?+2*6<IN;\u000f\u001d\n\u001f\u0007\u001d\tS*\u0016\u0002\u0016\u001a\u0016+\u0005\u000b\u001d\u001aS\b\u001c\u001cS\r\u001c\u0000\u001d\u000b\u0010\u001a\u001a\u0001\u001dTS\u0015\u000eN['7TS\u0015\u000eG"), (Object)a2.getName(), (Object)a2.getId());
            connectionManager.stopConnectionInternal((Connection)a2);
            return;
        }
        f_cT.debug(c_SC.m_eD((Object)"ETE6G^J_NI1;B|etyre|+_nwnon^}~eo+}di+xdue~hobte!+`v"), (Object)a.m_ica().getId());
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void lambda$restoreSingleConnectionOnLeader$1(String string, Connection connection) {
        void a;
        ConnectionManager a2 = connection;
        ConnectionManager a3 = this;
        try {
            Object[] objectArray = new Object[--3];
            objectArray[3 & 4] = a;
            objectArray[3 >> 1] = a2.getName();
            objectArray[1 ^ 3] = a2.getId();
            f_cT.info(c_SC.m_eD((Object)"Xdue~hobteVjuj|ni+3G~j\u007fni+`v21;Y~xodibul;hteunx\u007frdu1;pf+3B_1;pf\""), objectArray);
            ConnectionManager connectionManager = a3;
            Connection connection2 = connectionManager.loadConnectionWithDetails((Connection)a2);
            connectionManager.startConnectionInternal(connection2);
            return;
        }
        catch (Exception exception) {
            Object[] objectArray = new Object[--3];
            objectArray[3 >> 2] = a2.getName();
            objectArray[3 & 5] = a2.getId();
            objectArray[5 >> 1] = ExceptionUtils.getRootCauseMessage((Throwable)exception);
            a3.f_lT.m_ML(a2.getProject()).m_s("Connection Restore (Leader " + (String)a + ")", c_Ff.m_oR((Object)"V\u001dSF:*INV\u001dZN\u0015\u000f\u001a\u0002\u0016\nS\u001a\u001cN\u0001\u000b\u0000\u001a\u001c\u001c\u0016@S-\u0012\u001b\u0000\u000bINV\u001d").formatted(objectArray));
            try {
                f_cT.warn(c_SC.m_eD((Object)"Xdue~hobteVjuj|ni+3G~j\u007fni+`v21;Jo\u007f~fk\u007fre|+od;xodk+xdue~hobte;pf+zmoni+inh\u007ftyz\u007frdu+}jrgny~%"), (Object)a, (Object)a2.getId());
                a3.stopConnectionInternal((Connection)a2);
                return;
            }
            catch (Exception exception2) {
                Object[] objectArray2 = new Object[--4];
                objectArray2[2 & 5] = a;
                objectArray2[3 & 5] = a2.getId();
                objectArray2[--2] = exception2.getMessage();
                objectArray2[--3] = exception2;
                f_cT.error(c_Ff.m_oR((Object)"-\u001c\u0000\u001d\u000b\u0010\u001a\u001a\u0001\u001d#\u0012\u0000\u0012\t\u0016\u001cSF?\u000b\u0012\n\u0016\u001cS\u0015\u000eGIN5\u000f\u001a\u0002\u0016\nS\u001a\u001cN\u0000\u001a\u001c\u001eS\r\u001c\u0000\u001d\u000b\u0010\u001a\u001a\u0001\u001dN\b\u0013S\u000f\u0015\u001a\u0016\u001cS\u001c\u0016\u001d\u0007\u0001\u0001\u000f\u0007\u0007\u001c\u0000S\b\u0012\u0007\u001f\u001b\u0001\u000bIN\b\u0013"), objectArray2);
                return;
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    protected void startConnectionInternal(String string) {
        void a;
        ConnectionManager connectionManager = this;
        ConnectionManager a2 = connectionManager.f_hu.m_pCa((String)a);
        if (a2 == null) {
            throw new NotFoundException("Connection not found with id: " + (String)a);
        }
        ConnectionManager connectionManager2 = connectionManager;
        connectionManager2.startConnectionInternal(connectionManager2.loadConnectionWithDetails((Connection)a2));
    }
}

