/*
 * Decompiled with CFR 0.152.
 */
package com.inscada.mono.alarm.services;

import com.inscada.mono.alarm.m.c_GL;
import com.inscada.mono.alarm.m.c_Tl;
import com.inscada.mono.alarm.m.c_Xl;
import com.inscada.mono.alarm.m.c_YK;
import com.inscada.mono.alarm.m.c_rL;
import com.inscada.mono.alarm.model.Alarm;
import com.inscada.mono.alarm.model.AlarmGroup;
import com.inscada.mono.alarm.model.AlarmGroupSummary;
import com.inscada.mono.alarm.p.c_RJ;
import com.inscada.mono.alarm.services.c_SJ;
import com.inscada.mono.alarm.services.c_cK;
import com.inscada.mono.alarm.services.c_fk;
import com.inscada.mono.alarm.services.c_vk;
import com.inscada.mono.auth.c_oL;
import com.inscada.mono.cluster.exceptions.ClusterRpcException;
import com.inscada.mono.cluster.services.ClusterNodeListener;
import com.inscada.mono.cluster.services.c_b;
import com.inscada.mono.datatransfer.model.DataTransferSummary;
import com.inscada.mono.log.m.c_ac;
import com.inscada.mono.project.m.c_E;
import com.inscada.mono.settings.restcontrollers.LogoController;
import com.inscada.mono.shared.exceptions.NotActiveException;
import com.inscada.mono.shared.model.BaseModel;
import com.inscada.mono.shared.model.OwnedSpaceBaseModel;
import jakarta.annotation.PostConstruct;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Component;
import org.springframework.transaction.event.TransactionalEventListener;
import redis.clients.jedis.JedisPooled;

@Component
public class AlarmManager
implements ClusterNodeListener,
c_E {
    private final c_b f_QV;
    private final c_ac f_iw;
    public static final short f_jw = 107;
    private final Lock f_sv;
    public static final short f_zw = 101;
    private final c_SJ f_lV;
    public static final short f_Iv = 104;
    private final c_fk f_qV;
    public static final short f_Xx = 105;
    private final c_oL f_HV;
    private final JedisPooled f_KU;
    public static final short f_xv = 102;
    private static final String f_nw = "activeAlarmGroups";
    public static final short f_TU = 108;
    public static final short f_qU = 106;
    public static final short f_Aw = 109;
    public static final short f_Qw = 103;
    private static final Logger f_pV = LoggerFactory.getLogger(AlarmManager.class);
    private final c_vk f_cv;

    /*
     * WARNING - void declaration
     */
    @TransactionalEventListener(value={c_Xl.class})
    public void handleAlarmGroupChangeEvent(c_Xl c_Xl2) {
        void a;
        AlarmManager alarmManager = this;
        if (alarmManager.f_QV.m_fa()) {
            f_pV.info(LogoController.m_Zd((Object)"S\u001a^\u001bZ\r%\u007fW>q;s6q8?\u001es>m2X-p*o\u001cw>q8z\u001ai:q+?9p-?8m0j/?\u0016[e?$b"), (Object)a.m_Ria().getId());
            alarmManager.f_sv.lock();
            try {
                Object a2 = a.m_Ria().getId();
                if (alarmManager.getAlarmGroupStatusInternal((String)a2) == c_RJ.f_CY) {
                    AlarmManager alarmManager2 = alarmManager;
                    alarmManager2.deactivateAlarmGroupInternal((String)a2);
                    alarmManager2.activateAlarmGroupInternal((String)a2);
                }
                return;
            }
            finally {
                alarmManager.f_sv.unlock();
            }
        }
        f_pV.debug(DataTransferSummary.m_eR((Object)"\u0003\u000e\u0003l\u0001\u0004\f\u0005\b\u0013wa\u0004&#.?(#&m\u0000! ?,\n3\"4=\u0002% #&(\u0004;$#5m'\"3m&?.81m\b\t{m:0"), (Object)a.m_Ria().getId());
    }

    @PreAuthorize(value="hasAuthority('VIEW_ALARM')")
    public c_RJ getAlarmGroupStatus(String string) {
        Object a = string;
        AlarmManager a2 = this;
        if (a2.f_QV.m_fa()) {
            f_pV.debug(LogoController.m_Zd((Object)"\u0013Z\u001e[\u001aMe?\u0018z+k6q8?>s>m2?8m0j/?,k>k*l\u007fy0m\u007fd\"?3p<~3s&1"), a);
            return a2.getAlarmGroupStatusInternal((String)a);
        }
        f_pV.debug(DataTransferSummary.m_eR((Object)"\u000f\u0002\u000f`\r\b\u0000\t\u0004\u001f{m\u0013(08$>5$/*a!$,%(3m'\"3m ! ?,m&?.81m29 94>a+.?a6<c"), a);
        try {
            Object[] objectArray = new Object[3 >> 1];
            objectArray[5 >> 3] = a;
            return (c_RJ)a2.f_QV.m_w(Short.valueOf((short)(0x7C & 0x6B)), objectArray);
        }
        catch (Exception exception) {
            throw new ClusterRpcException("Failed to RPC get alarm group status for " + (String)a, (Throwable)exception);
        }
    }

    /*
     * WARNING - void declaration
     */
    protected c_RJ getAlarmStatusInternal(Alarm alarm) {
        void a;
        AlarmManager alarmManager = this;
        if (a == null) {
            return c_RJ.f_Uy;
        }
        AlarmManager a2 = alarmManager.f_cv.m_Iga(a.getGroup().getId());
        if (a2 != null && a2.m_dGa() && a2.m_HHa(a.getId())) {
            return c_RJ.f_CY;
        }
        return c_RJ.f_Uy;
    }

    protected void activateAlarmGroupsByProjectIdInternal(String string) {
        Object a = string;
        AlarmManager a2 = this;
        if ((a = a2.f_lV.m_XIa((String)a)) == null || a.isEmpty()) {
            return;
        }
        Object object = a = a.iterator();
        while (object.hasNext()) {
            AlarmGroup alarmGroup = (AlarmGroup)a.next();
            object = a;
            a2.activateAlarmGroupInternal(alarmGroup.getId());
        }
    }

    public void deactivateForProject(String string) {
        Object a = string;
        AlarmManager a2 = this;
        if (a2.f_QV.m_fa()) {
            f_pV.info(LogoController.m_Zd((Object)"\u0013Z\u001e[\u001aMe?\u0017~1{3v1x\u007fO-p5z<k\u001bz>|+v)~+z\u001ai:q+?9p-?/m0u:|+?\u0016[e?$b"), a);
            a2.deactivateAlarmGroupsByProjectIdInternal((String)a);
            return;
        }
        f_pV.debug(DataTransferSummary.m_eR((Object)"\u000f\u0002\u000f`\r\b\u0000\t\u0004\u001f{m\b*/\"3$/*a\u001d3\"+(\"9\u0005( .5$7,5(\u0004;$#5m'\"3m1?.'$.5m\b\t{m:0"), a);
    }

    @PreAuthorize(value="hasAuthority('ACTIVATE_ALARM')")
    public void activateAlarmGroup(String string) {
        Object a = string;
        AlarmManager a2 = this;
        if (a2.f_QV.m_fa()) {
            f_pV.debug(LogoController.m_Zd((Object)"\u0013Z\u001e[\u001aMe?\u001e|+v)~+v1x\u007f~3~-r\u007fx-p*o\u007fd\"?3p<~3s&1"), a);
            a2.activateAlarmGroupInternal((String)a);
            return;
        }
        f_pV.debug(DataTransferSummary.m_eR((Object)"\u0003\u000e\u0003l\u0001\u0004\f\u0005\b\u0013wa\u001f$<4(29(#&m-( )$?a9.m .5$7,5(a,-,3 a*3\"4=a6<c"), a);
        try {
            Object[] objectArray = new Object[--1];
            objectArray[2 & 5] = a;
            a2.f_QV.m_w(Short.valueOf((short)(0x77 & 0x6D)), objectArray);
            return;
        }
        catch (Exception exception) {
            throw new ClusterRpcException("Failed to RPC activate alarm group " + (String)a, (Throwable)exception);
        }
    }

    protected c_RJ getAlarmGroupStatusInternal(String string) {
        Object a = string;
        AlarmManager a2 = this;
        if ((a = a2.f_cv.m_Iga((String)a)) != null && a.m_dGa()) {
            return c_RJ.f_CY;
        }
        return c_RJ.f_Uy;
    }

    @TransactionalEventListener(value={c_rL.class})
    public void handleAlarmGroupDeleteEvent(c_rL c_rL2) {
        AlarmManager a = c_rL2;
        AlarmManager a2 = this;
        if (a2.f_QV.m_fa()) {
            f_pV.info(LogoController.m_Zd((Object)"S\u001a^\u001bZ\r%\u007fW>q;s6q8?\u001es>m2X-p*o\u001bz3z+z\u001ai:q+?9p-?8m0j/?\u0016[e?$b"), (Object)a.m_DIa().getId());
            a2.deactivateAlarmGroupInternal(a.m_DIa().getId());
            return;
        }
        f_pV.debug(DataTransferSummary.m_eR((Object)"\u0003\u000e\u0003l\u0001\u0004\f\u0005\b\u0013wa\u0004&#.?(#&m\u0000! ?,\n3\"4=\u0005(-(5(\u0004;$#5m'\"3m&?.81m\b\t{m:0"), (Object)a.m_DIa().getId());
    }

    private /* synthetic */ void lambda$deactivateAlarmGroupInternal$3(AlarmGroup alarmGroup) {
        AlarmManager a = alarmGroup;
        AlarmManager a2 = this;
        a2.f_sv.lock();
        try {
            c_cK c_cK2 = a2.f_cv.m_Iga(a.getId());
            if (c_cK2 != null) {
                c_cK2.m_vha();
                a2.f_cv.m_aha(a.getId(), c_cK2);
            }
            String[] stringArray = new String[3 >> 1];
            stringArray[3 ^ 3] = a.getId();
            a2.f_KU.srem(f_nw, stringArray);
            return;
        }
        finally {
            a2.f_sv.unlock();
        }
    }

    protected Map<String, c_RJ> getAlarmStatusesByProjectIdInternal(String string) {
        Object a = string;
        AlarmManager a2 = this;
        if ((a = a2.f_qV.m_EIa((String)a)) == null || a.isEmpty()) {
            return Collections.emptyMap();
        }
        return a.stream().collect(Collectors.toMap(BaseModel::getId, arg_0 -> a2.getAlarmStatusInternal(arg_0)));
    }

    protected void deactivateAlarmGroupInternal(AlarmGroup alarmGroup) {
        AlarmManager a = alarmGroup;
        AlarmManager a2 = this;
        a2.f_HV.m_qFa(() -> a2.lambda$deactivateAlarmGroupInternal$3((AlarmGroup)a), (OwnedSpaceBaseModel)a);
    }

    @PreAuthorize(value="hasAuthority('DEACTIVATE_ALARM')")
    public void deactivateAlarmGroup(String string) {
        Object a = string;
        AlarmManager a2 = this;
        if (a2.f_QV.m_fa()) {
            f_pV.debug(LogoController.m_Zd((Object)"\u0013Z\u001e[\u001aMe?\u001bz>|+v)~+v1x\u007f~3~-r\u007fx-p*o\u007fd\"?3p<~3s&1"), a);
            a2.deactivateAlarmGroupInternal((String)a);
            return;
        }
        f_pV.debug(DataTransferSummary.m_eR((Object)"\u0003\u000e\u0003l\u0001\u0004\f\u0005\b\u0013wa\u001f$<4(29(#&m-( )$?a9.m%( .5$7,5(a,-,3 a*3\"4=a6<c"), a);
        try {
            Object[] objectArray = new Object[5 >> 2];
            objectArray[3 ^ 3] = a;
            a2.f_QV.m_w(Short.valueOf((short)(0x76 & 0x6F)), objectArray);
            return;
        }
        catch (Exception exception) {
            throw new ClusterRpcException("Failed to RPC deactivate alarm group " + (String)a, (Throwable)exception);
        }
    }

    private /* synthetic */ void lambda$activateAlarmGroupInternal$2(AlarmGroup alarmGroup) {
        AlarmManager a = alarmGroup;
        AlarmManager a2 = this;
        a2.f_sv.lock();
        try {
            if (!Boolean.TRUE.equals(a.getProject().getIsActive())) {
                throw new NotActiveException("Project should be active to start alarm group " + a.getName());
            }
            c_cK c_cK2 = a2.f_cv.m_QHa((AlarmGroup)a);
            c_cK2.m_Fia();
            if (c_cK2.m_dGa()) {
                String[] stringArray = new String[4 ^ 5];
                stringArray[2 & 5] = a.getId();
                a2.f_KU.sadd(f_nw, stringArray);
            }
            return;
        }
        finally {
            a2.f_sv.unlock();
        }
    }

    @PreAuthorize(value="hasAuthority('VIEW_ALARM')")
    public c_RJ getAlarmStatus(String string) {
        Object a = string;
        AlarmManager a2 = this;
        if (a2.f_QV.m_fa()) {
            f_pV.debug(LogoController.m_Zd((Object)"\u0013Z\u001e[\u001aMe?\u0018z+k6q8?>s>m2?,k>k*l\u007fy0m\u007fd\"?3p<~3s&1"), a);
            return a2.getAlarmStatusInternal((String)a);
        }
        f_pV.debug(DataTransferSummary.m_eR((Object)"\u000f\u0002\u000f`\r\b\u0000\t\u0004\u001f{m\u0013(08$>5$/*a!$,%(3m'\"3m ! ?,m29 94>a+.?a6<c"), a);
        try {
            Object[] objectArray = new Object[5 >> 2];
            objectArray[3 >> 2] = a;
            return (c_RJ)a2.f_QV.m_w(Short.valueOf((short)(0x7F & 0x67)), objectArray);
        }
        catch (Exception exception) {
            throw new ClusterRpcException("Failed to RPC get alarm status for " + (String)a, (Throwable)exception);
        }
    }

    @TransactionalEventListener(value={c_GL.class})
    public void handleAlarmAddEvent(c_GL c_GL2) {
        AlarmManager alarmManager = this;
        if (alarmManager.f_QV.m_fa()) {
            c_cK c_cK2;
            AlarmManager a = a.m_xga();
            f_pV.info(LogoController.m_Zd((Object)"S\u001a^\u001bZ\r%\u007fW>q;s6q8?\u001es>m2^;{\u001ai:q+?9p-?>s>m2?\u0016[e?$bs?\u0018m0j/?\u0016[e?$b"), (Object)a.getId(), (Object)a.getGroupId());
            if (Boolean.TRUE.equals(a.getIsActive()) && (c_cK2 = alarmManager.f_cv.m_Iga(a.getGroupId())) != null && c_cK2.m_dGa()) {
                c_cK2.m_Yga((Alarm)a);
                return;
            }
        } else {
            f_pV.debug(DataTransferSummary.m_eR((Object)"\u0003\u000e\u0003l\u0001\u0004\f\u0005\b\u0013wa\u0004&#.?(#&m\u0000! ?,\f%)\u0004;$#5m'\"3m ! ?,m\b\t{m:0"), (Object)a.m_xga().getId());
        }
    }

    @PreAuthorize(value="hasAuthority('VIEW_ALARM')")
    public Map<String, c_RJ> getAlarmStatuses(String string) {
        Object a = string;
        AlarmManager a2 = this;
        if (a2.f_QV.m_fa()) {
            f_pV.debug(LogoController.m_Zd((Object)"\u0013Z\u001e[\u001aMe?\u0018z+k6q8?>s3?>s>m2?,k>k*l:l\u007fy0m\u007fo-p5z<k\u007fd\"?3p<~3s&1"), a);
            return a2.getAlarmStatusesByProjectIdInternal((String)a);
        }
        f_pV.debug(DataTransferSummary.m_eR((Object)"\u000f\u0002\u000f`\r\b\u0000\t\u0004\u001f{m\u0013(08$>5$/*a!$,%(3m'\"3m !-m ! ?,m29 94>$>a+.?a=3\"+(\"9a6<c"), a);
        try {
            Object[] objectArray = new Object[--1];
            objectArray[5 >> 3] = a;
            return (Map)a2.f_QV.m_w(Short.valueOf((short)(0x6B & 0x7D)), objectArray);
        }
        catch (Exception exception) {
            throw new ClusterRpcException("Failed to RPC get alarm statuses for project " + (String)a, (Throwable)exception);
        }
    }

    protected void deactivateAlarmGroupsByProjectIdInternal(String string) {
        Object a = string;
        AlarmManager a2 = this;
        if ((a = a2.f_lV.m_XIa((String)a)) == null || a.isEmpty()) {
            return;
        }
        Object object = a = a.iterator();
        while (object.hasNext()) {
            AlarmGroup alarmGroup = (AlarmGroup)a.next();
            object = a;
            a2.deactivateAlarmGroupInternal(alarmGroup.getId());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void leader() {
        AlarmManager alarmManager;
        AlarmManager alarmManager2 = alarmManager = this;
        Object a = alarmManager2.f_QV.m_ja();
        f_pV.info(LogoController.m_Zd((Object)"\u001es>m2R>q>x:me?\u000bw6l\u007fq0{:?wd\"6\u007fw>l\u007f}:|0r:?+w:?\u0013Z\u001e[\u001aMq?\rz,k0m6q8?>|+v)z\u007f~3~-r,1q1"), a);
        alarmManager2.f_sv.lock();
        try {
            HashSet hashSet = new HashSet(alarmManager.f_KU.smembers(f_nw));
            if (hashSet.isEmpty()) {
                f_pV.info(DataTransferSummary.m_eR((Object)"\f-,3 \f,/,&(3mi\u0001$,%(3m:0hwa\u0003.m .5$7(a,-,3 a*3\"4=2m'\"4#%m(#a\u001f$)(>a9.m3(29.?$c"), a);
                return;
            }
            Object[] objectArray = new Object[--3];
            objectArray[2 & 5] = a;
            objectArray[--1] = hashSet.size();
            objectArray[5 >> 1] = hashSet;
            f_pV.info(LogoController.m_Zd((Object)"^3~-r\u0012~1~8z-?wS:~;z-?$bv%\u007fY0j1{\u007fd\"?>|+v)z\u007f~3~-r\u007fx-p*o\u007fV\u001bl\u007fv1?\rz;v,?+p\u007fm:l+p-ze?$b"), objectArray);
            ArrayList arrayList = new ArrayList();
            String[] stringArray = new String[5 >> 2];
            stringArray[5 >> 3] = DataTransferSummary.m_eR((Object)"\u0017\u0004\u0004\u001a\u001e\f\r\f\u0013\u0000\u001e\n\u0013\u0002\u0014\u001d");
            alarmManager.f_HV.m_uea(() -> {
                void a;
                Object a2 = hashSet;
                AlarmManager a3 = this;
                a.addAll(a3.f_lV.m_UIa((Set)a2));
            }, stringArray);
            f_pV.info(LogoController.m_Zd((Object)"\u001es>m2R>q>x:m\u007f7\u0013z>{:m\u007fd\"6e?\u001ek+z2o+v1x\u007fk0?-z,k0m:?$b\u007f~3~-r\u007fx-p*o,1"), a, (Object)arrayList.size());
            arrayList.forEach(alarmGroup -> {
                void a;
                AlarmManager alarmManager;
                AlarmManager alarmManager2 = alarmManager = this;
                Object a2 = alarmManager2.f_QV.m_ja();
                String[] stringArray = new String[--2];
                stringArray[5 >> 3] = DataTransferSummary.m_eR((Object)"\u0000\u000e\u0015\u0004\u0017\f\u0015\b\u001e\f\r\f\u0013\u0000");
                stringArray[3 & 5] = LogoController.m_Zd((Object)"\u001bZ\u001e\\\u000bV\t^\u000bZ\u0000^\u0013^\rR");
                alarmManager2.f_HV.m_NDa(() -> alarmManager.lambda$restoreSingleAlarmGroupOnLeader$1((String)a2, (AlarmGroup)a), a.getSpace(), stringArray);
            });
            f_pV.info(DataTransferSummary.m_eR((Object)"\f-,3 \f,/,&(3mi\u0001$,%(3m:0hwa\u000b(#(>)(%m ! ?,m3(29.? 9(\"/m1?..$>2c"), a);
            return;
        }
        catch (Exception exception) {
            Object[] objectArray = new Object[--3];
            objectArray[3 >> 2] = a;
            objectArray[4 ^ 5] = exception.getMessage();
            objectArray[5 >> 1] = exception;
            f_pV.error(LogoController.m_Zd((Object)"\u001es>m2R>q>x:m\u007f7\u0013z>{:m\u007fd\"6e?\u001am-p-?;j-v1x\u007f~3~-r\u007fm:l+p-~+v0q\u007fo-p<z,le?$b"), objectArray);
            return;
        }
        finally {
            alarmManager.f_sv.unlock();
        }
    }

    /*
     * WARNING - void declaration
     */
    @PreAuthorize(value="hasAuthority('ACTIVATE_ALARM')")
    public void activateAlarmGroup(String string, String string2) {
        void a;
        AlarmManager a2;
        Object a3 = string2;
        AlarmManager alarmManager = a2 = this;
        alarmManager.activateAlarmGroup(alarmManager.f_lV.m_YGa((String)a, (String)a3).getId());
    }

    @PreAuthorize(value="hasAuthority('DEACTIVATE_ALARM')")
    public void deactivateAlarmGroups(String string) {
        Object a = string;
        AlarmManager a2 = this;
        if (a2.f_QV.m_fa()) {
            f_pV.debug(LogoController.m_Zd((Object)"S\u001a^\u001bZ\r%\u007f[:~<k6i>k6q8?>s3?>s>m2?8m0j/l\u007fy0m\u007fo-p5z<k\u007fd\"?3p<~3s&1"), a);
            a2.deactivateAlarmGroupsByProjectIdInternal((String)a);
            return;
        }
        f_pV.debug(DataTransferSummary.m_eR((Object)"\u000f\u0002\u000f`\r\b\u0000\t\u0004\u001f{m\u0013(08$>5$/*a!$,%(3m5\"a)$,\"9(; 9$m !-m ! ?,m&?.81>a+.?a=3\"+(\"9a6<c"), a);
        try {
            Object[] objectArray = new Object[5 >> 2];
            objectArray[3 >> 2] = a;
            a2.f_QV.m_w(Short.valueOf((short)(0x6F & 0x7D)), objectArray);
            return;
        }
        catch (Exception exception) {
            throw new ClusterRpcException("Failed to RPC deactivate alarm groups for project " + (String)a, (Throwable)exception);
        }
    }

    /*
     * WARNING - void declaration
     */
    public AlarmManager(c_fk c_fk2, c_SJ c_SJ2, c_vk c_vk2, c_ac c_ac2, JedisPooled jedisPooled, c_b c_b2, c_oL c_oL2) {
        AlarmManager a;
        void a2;
        void a3;
        void a4;
        void a5;
        void a6;
        void a7;
        AlarmManager a8;
        AlarmManager alarmManager = alarmManager2;
        AlarmManager alarmManager2 = c_oL2;
        AlarmManager alarmManager3 = a8 = alarmManager;
        AlarmManager alarmManager4 = a8;
        AlarmManager alarmManager5 = a8;
        AlarmManager alarmManager6 = a8;
        a8.f_sv = new ReentrantLock();
        a8.f_qV = a7;
        alarmManager5.f_lV = a6;
        alarmManager5.f_cv = a5;
        alarmManager4.f_iw = a4;
        alarmManager4.f_KU = a3;
        alarmManager3.f_QV = a2;
        alarmManager3.f_HV = a;
    }

    /*
     * WARNING - void declaration
     */
    @PreAuthorize(value="hasAuthority('DEACTIVATE_ALARM')")
    public void deactivateAlarmGroup(String string, String string2) {
        void a;
        AlarmManager a2;
        Object a3 = string2;
        AlarmManager alarmManager = a2 = this;
        alarmManager.deactivateAlarmGroup(alarmManager.f_lV.m_YGa((String)a, (String)a3).getId());
    }

    @PreAuthorize(value="hasAuthority('VIEW_ALARM')")
    public Map<String, c_RJ> getAlarmStatuses(List<String> list) {
        List<String> a = list;
        AlarmManager a2 = this;
        if (a == null || a.isEmpty()) {
            return Collections.emptyMap();
        }
        if (a2.f_QV.m_fa()) {
            f_pV.debug(LogoController.m_Zd((Object)"S\u001a^\u001bZ\r%\u007fX:k+v1x\u007f~3~-r\u007fl+~+j,z,?9p-?$b\u007fV\u001bl\u007fs0|>s3fe?$b"), (Object)a.size(), (Object)a);
            return a2.getAlarmStatusesInternal((List)a);
        }
        f_pV.debug(DataTransferSummary.m_eR((Object)"\u0003\u000e\u0003l\u0001\u0004\f\u0005\b\u0013wa\u001f$<4(29(#&m-( )$?a+.?a,-,3 a>5,582(2m'\"3m:0a\u0004\u0005>{m:0"), (Object)a.size(), (Object)a);
        try {
            Object[] objectArray = new Object[--1];
            objectArray[2 & 5] = new ArrayList(a);
            return (Map)a2.f_QV.m_w(Short.valueOf((short)(0x7F & 0x6B)), objectArray);
        }
        catch (Exception exception) {
            throw new ClusterRpcException("Failed to RPC get alarm statuses for IDs " + String.valueOf(a), (Throwable)exception);
        }
    }

    private /* synthetic */ void registerRemoteCallsWithClusterNode() {
        AlarmManager alarmManager = this;
        try {
            Class[] classArray = new Class[--1];
            classArray[3 >> 2] = String.class;
            alarmManager.f_QV.m_Da((short)(0x67 & 0x7D), (Object)alarmManager, AlarmManager.class.getDeclaredMethod(LogoController.m_Zd((Object)">|+v)~+z\u001es>m2X-p*o\u0016q+z-q>s"), classArray));
            Class[] classArray2 = new Class[3 >> 1];
            classArray2[3 & 4] = String.class;
            alarmManager.f_QV.m_Da((short)(0x6E & 0x77), (Object)alarmManager, AlarmManager.class.getDeclaredMethod(DataTransferSummary.m_eR((Object)"%( .5$7,5(\u0000! ?,\n3\"4=\b#5(3# !"), classArray2));
            Class[] classArray3 = new Class[--1];
            classArray3[3 & 4] = String.class;
            alarmManager.f_QV.m_Da((short)(0x6F & 0x77), (Object)alarmManager, AlarmManager.class.getDeclaredMethod(LogoController.m_Zd((Object)"8z+^3~-r\fk>k*l\u0016q+z-q>s"), classArray3));
            Class[] classArray4 = new Class[4 ^ 5];
            classArray4[5 >> 3] = String.class;
            alarmManager.f_QV.m_Da((short)(0x7C & 0x6B), (Object)alarmManager, AlarmManager.class.getDeclaredMethod(DataTransferSummary.m_eR((Object)"*$9\u0000! ?,\n3\"4=\u00129 94>\b#5(3# !"), classArray4));
            Class[] classArray5 = new Class[--1];
            classArray5[2 & 5] = String.class;
            alarmManager.f_QV.m_Da((short)(0x6B & 0x7D), (Object)alarmManager, AlarmManager.class.getDeclaredMethod(LogoController.m_Zd((Object)"x:k\u001es>m2L+~+j,z,]&O-p5z<k\u0016{\u0016q+z-q>s"), classArray5));
            Class[] classArray6 = new Class[1];
            classArray6[0] = String.class;
            alarmManager.f_QV.m_Da((short)(0x7A & 0x6F), (Object)alarmManager, AlarmManager.class.getDeclaredMethod(DataTransferSummary.m_eR((Object)"&(5\f-,3 \u0006?.81\u001e5,582(2\u000f8\u001d3\"+(\"9\b)\b#5(3# !"), classArray6));
            Class[] classArray7 = new Class[1];
            classArray7[0] = List.class;
            alarmManager.f_QV.m_Da((short)(0x7F & 0x6B), (Object)alarmManager, AlarmManager.class.getDeclaredMethod(LogoController.m_Zd((Object)"8z+^3~-r\fk>k*l:l\u0016q+z-q>s"), classArray7));
            Class[] classArray8 = new Class[1];
            classArray8[0] = String.class;
            alarmManager.f_QV.m_Da((short)(0x6E & 0x7D), (Object)alarmManager, AlarmManager.class.getDeclaredMethod(DataTransferSummary.m_eR((Object)" .5$7,5(\u0000! ?,\n3\"4=2\u000f8\u001d3\"+(\"9\b)\b#5(3# !"), classArray8));
            Class[] classArray9 = new Class[1];
            classArray9[0] = String.class;
            alarmManager.f_QV.m_Da((short)(0x6D & 0x7F), (Object)alarmManager, AlarmManager.class.getDeclaredMethod(LogoController.m_Zd((Object)";z>|+v)~+z\u001es>m2X-p*o,]&O-p5z<k\u0016{\u0016q+z-q>s"), classArray9));
            return;
        }
        catch (NoSuchMethodException a) {
            throw new IllegalStateException(DataTransferSummary.m_eR((Object)"\u000b $-(%m5\"a?$*(>5(3m\u0000! ?,\u0000 # *$?a\u001f\u0011\u000ea $9)\"%>"), a);
        }
    }

    @PostConstruct
    private /* synthetic */ void initializeClusterIntegration() {
        AlarmManager a;
        AlarmManager alarmManager = a;
        alarmManager.registerRemoteCallsWithClusterNode();
        alarmManager.f_QV.m_Ja((ClusterNodeListener)a);
        f_pV.info(DataTransferSummary.m_eR((Object)"\f-,3 \f,/,&(3m(#(9(,-$;(%m #%m3(&$29$?$)a,2m\u0002!4>5(3\u0003.)$\u0001(>5(/(3c"));
    }

    /*
     * WARNING - void declaration
     */
    @PreAuthorize(value="hasAuthority('VIEW_ALARM')")
    public c_RJ getAlarmStatus(String string, String string2) {
        void a;
        Object a2 = string;
        AlarmManager a3 = this;
        if ((a2 = a3.f_qV.m_kHa((String)a2, (String)a)) == null) {
            return c_RJ.f_Uy;
        }
        return a3.getAlarmStatus(a2.getId());
    }

    @TransactionalEventListener(value={c_Tl.class})
    public void handleAlarmDeleteEvent(c_Tl c_Tl2) {
        AlarmManager alarmManager = this;
        if (alarmManager.f_QV.m_fa()) {
            AlarmManager a = a.m_wha();
            f_pV.info(LogoController.m_Zd((Object)"\u0013Z\u001e[\u001aMe?\u0017~1{3v1x\u007f^3~-r\u001bz3z+z\u001ai:q+?9p-?>s>m2?\u0016[e?$bs?\u0018m0j/?\u0016[e?$b"), (Object)a.getId(), (Object)a.getGroupId());
            c_cK c_cK2 = alarmManager.f_cv.m_Iga(a.getGroupId());
            if (c_cK2 != null && c_cK2.m_dGa()) {
                c_cK2.m_Gia((Alarm)a);
                return;
            }
        } else {
            f_pV.debug(DataTransferSummary.m_eR((Object)"\u000f\u0002\u000f`\r\b\u0000\t\u0004\u001f{m\b*/\"3$/*a\f-,3 \u0005(-(5(\u0004;$#5m'\"3m ! ?,m\b\t{m:0"), (Object)a.m_wha().getId());
        }
    }

    protected Map<String, c_RJ> getAlarmStatusesInternal(List<String> list) {
        List<String> a = list;
        AlarmManager a2 = this;
        if (a == null || a.isEmpty()) {
            return Collections.emptyMap();
        }
        return a.stream().collect(Collectors.toMap(Function.identity(), arg_0 -> a2.getAlarmStatusInternal(arg_0)));
    }

    protected void activateAlarmGroupInternal(String string) {
        AlarmManager a;
        Object a2 = string;
        AlarmManager alarmManager = a = this;
        alarmManager.activateAlarmGroupInternal(alarmManager.f_lV.m_xha((String)a2));
    }

    @PreAuthorize(value="hasAuthority('ACTIVATE_ALARM')")
    public void activateAlarmGroups(String string) {
        Object a = string;
        AlarmManager a2 = this;
        if (a2.f_QV.m_fa()) {
            f_pV.debug(LogoController.m_Zd((Object)"S\u001a^\u001bZ\r%\u007f^<k6i>k6q8?>s3?>s>m2?8m0j/l\u007fy0m\u007fo-p5z<k\u007fd\"?3p<~3s&1"), a);
            a2.activateAlarmGroupsByProjectIdInternal((String)a);
            return;
        }
        f_pV.debug(DataTransferSummary.m_eR((Object)"\u000f\u0002\u000f`\r\b\u0000\t\u0004\u001f{m\u0013(08$>5$/*a!$,%(3m5\"a,\"9(; 9$m !-m ! ?,m&?.81>a+.?a=3\"+(\"9a6<c"), a);
        try {
            Object[] objectArray = new Object[4 ^ 5];
            objectArray[2 & 5] = a;
            a2.f_QV.m_w(Short.valueOf((short)(0x6D & 0x7E)), objectArray);
            return;
        }
        catch (Exception exception) {
            throw new ClusterRpcException("Failed to RPC activate alarm groups for project " + (String)a, (Throwable)exception);
        }
    }

    @PreAuthorize(value="hasAuthority('VIEW_ALARM')")
    public Map<String, c_RJ> getAlarmGroupStatuses(String string) {
        Object a = string;
        AlarmManager a2 = this;
        if (a2.f_QV.m_fa()) {
            f_pV.debug(LogoController.m_Zd((Object)"\u0013Z\u001e[\u001aMe?\u0018z+k6q8?>s3?>s>m2?8m0j/?,k>k*l:l\u007fy0m\u007fo-p5z<k\u007fd\"?3p<~3s&1"), a);
            return a2.getAlarmGroupStatusesByProjectIdInternal((String)a);
        }
        f_pV.debug(DataTransferSummary.m_eR((Object)"\u000f\u0002\u000f`\r\b\u0000\t\u0004\u001f{m\u0013(08$>5$/*a!$,%(3m'\"3m !-m ! ?,m&?.81m29 94>$>a+.?a=3\"+(\"9a6<c"), a);
        try {
            Object[] objectArray = new Object[--1];
            objectArray[2 & 5] = a;
            return (Map)a2.f_QV.m_w(Short.valueOf((short)(0x6E & 0x7B)), objectArray);
        }
        catch (Exception exception) {
            throw new ClusterRpcException("Failed to RPC get alarm group statuses for project " + (String)a, (Throwable)exception);
        }
    }

    protected c_RJ getAlarmStatusInternal(String string) {
        AlarmManager a;
        Object a2 = string;
        AlarmManager alarmManager = a = this;
        return alarmManager.getAlarmStatusInternal(alarmManager.f_qV.m_xHa((String)a2));
    }

    protected Map<String, c_RJ> getAlarmGroupStatusesByProjectIdInternal(String string) {
        Object a = string;
        AlarmManager a2 = this;
        if ((a = a2.f_lV.m_Uha((String)a)) == null || a.isEmpty()) {
            return Collections.emptyMap();
        }
        return a.stream().collect(Collectors.toMap(AlarmGroupSummary::getId, alarmGroupSummary -> {
            AlarmManager a = alarmGroupSummary;
            AlarmManager a2 = this;
            return a2.getAlarmGroupStatusInternal(a.getId());
        }));
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void lambda$restoreSingleAlarmGroupOnLeader$1(String string, AlarmGroup alarmGroup) {
        void a;
        AlarmManager a2 = alarmGroup;
        AlarmManager a3 = this;
        try {
            Object[] objectArray = new Object[--3];
            objectArray[5 >> 3] = a;
            objectArray[--1] = a2.getName();
            objectArray[1 ^ 3] = a2.getId();
            f_pV.info(LogoController.m_Zd((Object)"\u001es>m2R>q>x:m\u007f7\u0013z>{:m\u007fd\"6e?\rz,k0m6q8?>s>m2?8m0j/%\u007fd\"?wV\u001b%\u007fd\"6"), objectArray);
            a3.activateAlarmGroupInternal((AlarmGroup)a2);
            return;
        }
        catch (Exception exception) {
            Object[] objectArray = new Object[--3];
            objectArray[3 ^ 3] = a2.getName();
            objectArray[--1] = a2.getId();
            objectArray[--2] = ExceptionUtils.getRootCauseMessage((Throwable)exception);
            a3.f_iw.m_ML(a2.getProject()).m_s("Alarm Group Restore (Leader " + (String)a + ")", DataTransferSummary.m_eR((Object)"d>ae\b\t{md>hm',(!$)a9.m3(29.?$ca\u000e 82({md>").formatted(objectArray));
            try {
                f_pV.warn(LogoController.m_Zd((Object)"\u001es>m2R>q>x:m\u007f7\u0013z>{:m\u007fd\"6e?\u001ek+z2o+v1x\u007fk0?;z>|+v)~+z\u007f~3~-r\u007fx-p*o\u007fd\"?>y+z-?-z,k0m>k6p1?9~6s*m:1"), (Object)a, (Object)a2.getId());
                a3.deactivateAlarmGroupInternal((AlarmGroup)a2);
                return;
            }
            catch (Exception exception2) {
                Object[] objectArray2 = new Object[--4];
                objectArray2[5 >> 3] = a;
                objectArray2[3 >> 1] = a2.getId();
                objectArray2[5 >> 1] = exception2.getMessage();
                objectArray2[--3] = exception2;
                f_pV.error(DataTransferSummary.m_eR((Object)"\f-,3 \f,/,&(3mi\u0001$,%(3m:0hwa\u000b $-(%m5\"a)$,\"9(; 9$m ! ?,m&?.81m:0a,'9$?a?$>5\"3,5$.#a+ $-83({m:0"), objectArray2);
                return;
            }
        }
    }

    public void notLeader() {
        AlarmManager alarmManager;
        AlarmManager alarmManager2 = alarmManager = this;
        Object a = alarmManager2.f_QV.m_ja();
        f_pV.info(DataTransferSummary.m_eR((Object)"\u0000! ?,\u0000 # *$?{m\u0015%(>a#.)$mi6<da$2m\u000f\u0002a\u0001\u000e\u0003\u0006\b\u0013m\u0015\u0005\u0004m\r\b\u0000\t\u0004\u001fom\u00129.=1$/*a,-!a!.. !a,-,3 a$/>1(\"9.?2coc"), a);
        alarmManager2.f_sv.lock();
        try {
            alarmManager.f_cv.m_Eia();
            f_pV.info(LogoController.m_Zd((Object)"^3~-r\u0012~1~8z-?wQ0k\u007fS:~;z-?$bv%\u007f^3s\u007fs0|>s\u007f~3~-r\u007fv1l/z<k6p1?+~,t,?7~)z\u007f}:z1?-z.j:l+z;?+p\u007fl+p/1"), a);
            return;
        }
        catch (Exception exception) {
            Object[] objectArray = new Object[--3];
            objectArray[3 >> 2] = a;
            objectArray[--1] = exception.getMessage();
            objectArray[--2] = exception;
            f_pV.error(DataTransferSummary.m_eR((Object)"\f-,3 \f,/,&(3mi\u0003.9a\u0001$,%(3m:0hwa\b3?.?a)4?(#&m1?..$>2m.+a>5\"1=(#&m-\"\",-m ! ?,m(#2=$.5\"3>{m:0"), objectArray);
            return;
        }
        finally {
            alarmManager.f_sv.unlock();
        }
    }

    protected void activateAlarmGroupInternal(AlarmGroup alarmGroup) {
        AlarmManager a = alarmGroup;
        AlarmManager a2 = this;
        a2.f_HV.m_qFa(() -> a2.lambda$activateAlarmGroupInternal$2((AlarmGroup)a), (OwnedSpaceBaseModel)a);
    }

    protected void deactivateAlarmGroupInternal(String string) {
        AlarmManager a;
        Object a2 = string;
        AlarmManager alarmManager = a = this;
        alarmManager.deactivateAlarmGroupInternal(alarmManager.f_lV.m_xha((String)a2));
    }

    /*
     * WARNING - void declaration
     */
    @PreAuthorize(value="hasAuthority('VIEW_ALARM')")
    public c_RJ getAlarmGroupStatus(String string, String string2) {
        void a;
        Object a2 = string;
        AlarmManager a3 = this;
        if ((a2 = a3.f_lV.m_nia((String)a2, (String)a)) == null) {
            return c_RJ.f_Uy;
        }
        return a3.getAlarmGroupStatus(a2.getId());
    }

    @TransactionalEventListener(value={c_YK.class})
    public void handleAlarmChangeEvent(c_YK c_YK2) {
        AlarmManager alarmManager = this;
        if (alarmManager.f_QV.m_fa()) {
            AlarmManager a = a.m_Cha();
            f_pV.info(LogoController.m_Zd((Object)"\u0013Z\u001e[\u001aMe?\u0017~1{3v1x\u007f^3~-r\u001cw>q8z\u001ai:q+?9p-?>s>m2?\u0016[e?$bs?\u0018m0j/?\u0016[e?$b"), (Object)a.getId(), (Object)a.getGroupId());
            c_cK c_cK2 = alarmManager.f_cv.m_Iga(a.getGroupId());
            if (c_cK2 != null && c_cK2.m_dGa()) {
                if (Boolean.TRUE.equals(a.getIsActive())) {
                    c_cK2.m_Yga((Alarm)a);
                    return;
                }
                c_cK2.m_Gia((Alarm)a);
                return;
            }
        } else {
            f_pV.debug(DataTransferSummary.m_eR((Object)"\u000f\u0002\u000f`\r\b\u0000\t\u0004\u001f{m\b*/\"3$/*a\f-,3 \u0002% #&(\u0004;$#5m'\"3m ! ?,m\b\t{m:0"), (Object)a.m_Cha().getId());
        }
    }
}

