/*
 * Decompiled with CFR 0.152.
 */
package com.inscada.mono.user.repositories;

import com.inscada.mono.shared.repositories.BaseJpaRepository;
import com.inscada.mono.user.model.User;
import java.util.Collection;
import java.util.Optional;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;

public interface UserRepository
extends BaseJpaRepository<User> {
    @Query(value="SELECT u FROM User u WHERE u.username IN :usernames")
    public Collection<User> findByUsernameIn(@Param(value="usernames") String[] var1);

    @Query(value="SELECT u FROM User u WHERE u.username = :username")
    public User findOneByUsername(@Param(value="username") String var1);

    @Query(value="SELECT u FROM User u JOIN u.spaces s WHERE s.id = :spaceId")
    public Collection<User> findBySpacesId(@Param(value="spaceId") String var1);

    public User findOneByUsernameIgnoreCase(String var1);

    @Query(value="SELECT DISTINCT u FROM User u LEFT JOIN FETCH u.roles WHERE u.id = :id")
    public Optional<User> findByIdWithRoles(@Param(value="id") String var1);

    @Query(value="SELECT u FROM User u JOIN u.spaces s WHERE s.name = :space")
    public Collection<User> findBySpacesName(@Param(value="space") String var1);

    @Query(value="SELECT DISTINCT u FROM User u LEFT JOIN FETCH u.spaces WHERE u.id = :id")
    public Optional<User> findByIdWithSpaces(@Param(value="id") String var1);

    @Query(value="SELECT u FROM User u JOIN u.spaces s WHERE u.username IN :usernames AND s.name = :space")
    public Collection<User> findByUsernameInAndSpacesName(@Param(value="usernames") String[] var1, @Param(value="space") String var2);
}

