/*
 * Decompiled with CFR 0.152.
 */
package com.inscada.mono.user.repositories;

import com.inscada.mono.shared.aspects.EnableSpaceFilter;
import com.inscada.mono.shared.repositories.BaseJpaRepository;
import com.inscada.mono.user.model.Permission;
import java.util.Collection;
import java.util.Optional;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;

@EnableSpaceFilter
public interface PermissionRepository
extends BaseJpaRepository<Permission> {
    @Query(value="SELECT p FROM Permission p WHERE p.isGlobal = false")
    public Collection<Permission> findSpacePermissions();

    @Query(value="SELECT p FROM Permission p WHERE p.id = :permissionId AND p.isGlobal = false")
    public Optional<Permission> findSpacePermission(@Param(value="permissionId") String var1);

    @Query(value="SELECT p FROM Permission p LEFT JOIN FETCH p.roles WHERE p.name = :name AND p.isGlobal = false")
    public Optional<Permission> findSpacePermissionByNameWithRoles(@Param(value="name") String var1);

    public Optional<Permission> findOneByName(String var1);
}

