/*
 * Decompiled with CFR 0.152.
 */
package com.inscada.mono.shared.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.f4b6a3.uuid.UuidCreator;
import com.inscada.mono.project.model.ProjectStatus;
import jakarta.persistence.Column;
import jakarta.persistence.EntityListeners;
import jakarta.persistence.Id;
import jakarta.persistence.MappedSuperclass;
import jakarta.persistence.PrePersist;
import jakarta.persistence.PreRemove;
import jakarta.persistence.Temporal;
import jakarta.persistence.TemporalType;
import jakarta.persistence.Version;
import java.util.Date;
import org.hibernate.annotations.Filter;
import org.hibernate.annotations.FilterDef;
import org.springframework.data.annotation.CreatedBy;
import org.springframework.data.annotation.CreatedDate;
import org.springframework.data.annotation.LastModifiedBy;
import org.springframework.data.annotation.LastModifiedDate;
import org.springframework.data.jpa.domain.support.AuditingEntityListener;

@MappedSuperclass
@EntityListeners(value={AuditingEntityListener.class})
@FilterDef(name="softDeleteFilter", defaultCondition="deleted_dttm IS NULL")
@Filter(name="softDeleteFilter")
public abstract class BaseModel {
    public static final String SOFT_DELETE_FILTER_DEFAULT_CONDITION = "deleted_dttm IS NULL";
    @JsonProperty(access=JsonProperty.Access.READ_ONLY)
    @LastModifiedDate
    @Column(name="version_dttm")
    @Temporal(value=TemporalType.TIMESTAMP)
    protected Date lastModifiedDate;
    @JsonProperty(access=JsonProperty.Access.READ_ONLY)
    @Column(name="deleted_user")
    private String deletedBy;
    @JsonProperty(access=JsonProperty.Access.READ_ONLY)
    @Column(name="deleted_dttm")
    @Temporal(value=TemporalType.TIMESTAMP)
    private Date deletedDate;
    @JsonProperty(access=JsonProperty.Access.READ_ONLY)
    @CreatedBy
    @Column(name="insert_user", updatable=false)
    protected String createdBy;
    @JsonProperty(access=JsonProperty.Access.READ_ONLY)
    @CreatedDate
    @Column(name="insert_dttm", updatable=false)
    @Temporal(value=TemporalType.TIMESTAMP)
    protected Date creationDate;
    @JsonProperty(access=JsonProperty.Access.READ_ONLY)
    @Version
    @Column(name="version")
    private Long version;
    public static final String SOFT_DELETE_FILTER_NAME = "softDeleteFilter";
    @Id
    @Column(name="id", updatable=false, nullable=false, length=36)
    protected String id;
    @JsonProperty(access=JsonProperty.Access.READ_ONLY)
    @LastModifiedBy
    @Column(name="version_user")
    protected String lastModifiedBy;

    @PreRemove
    private /* synthetic */ void preventHardDelete() {
        throw new UnsupportedOperationException(ProjectStatus.m_gj((Object)"\u0003\u001d9\u0018k\u0018.\u0010.\b.\\\"\u000fk\u0012$\bk\u001d'\u0010$\u000b.\u0018e\\\u001b\u0010.\u001d8\u0019k\t8\u0019k\b#\u0019k\u000e.\f$\u000f\"\b$\u000e2[8\\/\u0019'\u0019?\u0019k\u0011.\b#\u0013/\\-\u00139\\8\u0013-\bk\u0018.\u0010.\b\"\u0013%R"));
    }

    public Long getVersion() {
        BaseModel a;
        return a.version;
    }

    public String getCreatedBy() {
        BaseModel a;
        return a.createdBy;
    }

    public void setDeletedDate(Date date) {
        Object a = date;
        BaseModel a2 = this;
        a2.deletedDate = a;
    }

    public void setLastModifiedBy(String string) {
        Object a = string;
        BaseModel a2 = this;
        a2.lastModifiedBy = a;
    }

    public Date getDeletedDate() {
        BaseModel a;
        return a.deletedDate;
    }

    public void setVersion(Long l) {
        Object a = l;
        BaseModel a2 = this;
        a2.version = a;
    }

    @PrePersist
    protected void onCreate() {
        BaseModel a;
        if (a.id == null) {
            a.id = UuidCreator.getTimeOrdered().toString();
        }
    }

    protected BaseModel() {
        BaseModel a;
    }

    public void setCreationDate(Date date) {
        Object a = date;
        BaseModel a2 = this;
        a2.creationDate = a;
    }

    public String getLastModifiedBy() {
        BaseModel a;
        return a.lastModifiedBy;
    }

    public Date getLastModifiedDate() {
        BaseModel a;
        return a.lastModifiedDate;
    }

    public String getDeletedBy() {
        BaseModel a;
        return a.deletedBy;
    }

    public String getId() {
        BaseModel a;
        return a.id;
    }

    public void setId(String string) {
        Object a = string;
        BaseModel a2 = this;
        a2.id = a;
    }

    public void setCreatedBy(String string) {
        Object a = string;
        BaseModel a2 = this;
        a2.createdBy = a;
    }

    public void setDeletedBy(String string) {
        Object a = string;
        BaseModel a2 = this;
        a2.deletedBy = a;
    }

    public void setLastModifiedDate(Date date) {
        Object a = date;
        BaseModel a2 = this;
        a2.lastModifiedDate = a;
    }

    public Date getCreationDate() {
        BaseModel a;
        return a.creationDate;
    }
}

