/*
 * Decompiled with CFR 0.152.
 */
package com.inscada.mono.shared.exceptions;

import com.inscada.mono.auth.exceptions.AuthTokenException;
import com.inscada.mono.auth.exceptions.RunAsExecutionException;
import com.inscada.mono.broadcast.exceptions.BroadcastOperationException;
import com.inscada.mono.communication.base.exceptions.BrowseOperationException;
import com.inscada.mono.communication.base.exceptions.CommunicationException;
import com.inscada.mono.communication.base.exceptions.SetValueException;
import com.inscada.mono.impexp.exceptions.ImportExportException;
import com.inscada.mono.job.x.c_Mc;
import com.inscada.mono.report.exceptions.ReportGenerationException;
import com.inscada.mono.report.exceptions.ReportSchedulingException;
import com.inscada.mono.script.exceptions.ScriptException;
import com.inscada.mono.settings.exceptions.SettingsException;
import com.inscada.mono.shared.exceptions.AlreadyExistsException;
import com.inscada.mono.shared.exceptions.FileStorageException;
import com.inscada.mono.shared.exceptions.InscadaException;
import com.inscada.mono.shared.exceptions.MismatchException;
import com.inscada.mono.shared.exceptions.NotActiveException;
import com.inscada.mono.shared.exceptions.NotFoundException;
import com.inscada.mono.shared.exceptions.ParsingException;
import com.inscada.mono.shared.exceptions.RelationExistsException;
import com.inscada.mono.shared.exceptions.ValidationDefinitionException;
import com.inscada.mono.shared.exceptions.model.ExceptionDetails;
import com.inscada.mono.sms.exceptions.SmsProviderException;
import com.inscada.mono.space.exceptions.SpaceOperationException;
import com.inscada.mono.system.x.c_Ya;
import jakarta.persistence.EntityNotFoundException;
import jakarta.persistence.OptimisticLockException;
import jakarta.validation.ConstraintViolation;
import jakarta.validation.ConstraintViolationException;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.hibernate.StaleObjectStateException;
import org.influxdb.InfluxDBMapperException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.env.Environment;
import org.springframework.dao.DataIntegrityViolationException;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.http.converter.HttpMessageNotReadableException;
import org.springframework.lang.NonNull;
import org.springframework.security.access.AccessDeniedException;
import org.springframework.security.authentication.BadCredentialsException;
import org.springframework.transaction.TransactionSystemException;
import org.springframework.validation.FieldError;
import org.springframework.web.bind.MethodArgumentNotValidException;
import org.springframework.web.bind.MissingServletRequestParameterException;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.RestControllerAdvice;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;
import org.springframework.web.context.request.WebRequest;
import org.springframework.web.method.annotation.MethodArgumentTypeMismatchException;
import org.springframework.web.servlet.mvc.method.annotation.ResponseEntityExceptionHandler;

@RestControllerAdvice
public class GeneralExceptionHandler
extends ResponseEntityExceptionHandler {
    private static final String NOT_ACTIVE_ERROR = "Not Active Error";
    private static final String MISMATCH_ERROR = "Mismatch Error";
    private static final String INSCADA_ERROR = "Inscada Error";
    private static final String FILE_STORAGE_ERROR = "File Storage Error";
    private static final String REPORT_SCHEDULING_ERROR = "Report Scheduling Error";
    private static final String BROADCAST_OPERATION_ERROR = "Broadcast Operation Error";
    private static final String NOT_FOUND_ERROR = "Not Found Error";
    private static final String SECURITY_ERROR = "Security Error";
    private static final String OPTIMISTIC_LOCK_ERROR = "Optimistic Lock Error";
    private static final String VALIDATION_ERROR = "Validation Error";
    private static final String IMPORT_EXPORT_ERROR = "Import/Export Error";
    private static final String RUN_AS_ERROR = "Run-As Execution Error";
    private static final String CONSTRAINT_VIOLATION = "Constraint Violation";
    private static final String PARSING_ERROR = "Parsing Error";
    private static final String VALIDATION_DEFINITION_ERROR = "Validation Definition Error";
    private final Environment environment;
    private static final Logger log = LoggerFactory.getLogger(GeneralExceptionHandler.class);
    private static final String DATABASE_ERROR = "Database Error";
    private static final String UNKNOWN_ERROR = "Unknown Error";
    private static final String SET_VALUE_ERROR = "Set Value Error";
    private static final String REPORT_GENERATION_ERROR = "Report Generation Error";
    private static final String SMS_PROVIDER_ERROR = "SMS Provider Error";
    private static final String COMMUNICATION_ERROR = "Communication Error";
    private static final String SPACE_OPERATION_ERROR = "Space Operation Error";
    private static final String RELATION_EXISTS_ERROR = "Relation Exists Error";
    private static final String ALREADY_EXISTS_ERROR = "Already Exists Error";
    private static final String SCRIPT_ERROR = "Script Execution Error";
    private static final String AUTH_TOKEN_ERROR = "Auth Token Error";
    private static final String SETTINGS_ERROR = "Settings Error";
    private static final String BROWSE_OPERATION_ERROR = "Browse Operation Error";

    private /* synthetic */ boolean isDevelopment() {
        String[] stringArray = this;
        String[] a = stringArray.environment.getActiveProfiles();
        if (a.length == 0) {
            return (2 & 5) != 0;
        }
        return Arrays.asList(a).contains(c_Ya.m_aC((Object)"<F."));
    }

    @ExceptionHandler(value={OptimisticLockException.class, StaleObjectStateException.class})
    protected ResponseEntity<Object> handleOptimisticLock(Exception exception) {
        Object a = exception;
        GeneralExceptionHandler a2 = this;
        return a2.buildErrorResponse((Exception)a, c_Mc.m_zk((Object)"9\u0007\u0004\u001cM\u001d\b\f\u0002\u001d\tO\u001a\u000e\u001eO\u0018\u001f\t\u000e\u0019\n\tO\u000f\u0016M\u000e\u0003\u0000\u0019\u0007\b\u001dM\u001a\u001e\n\u001fAM?\u0001\n\f\u001c\bO\u001f\n\u000b\u001d\b\u001c\u0005O\u0014\u0000\u0018\u001dM\u000b\f\u001b\fO\f\u0001\tO\u0019\u001d\u0014O\f\b\f\u0006\u0003A"), (HttpStatusCode)HttpStatus.CONFLICT, OPTIMISTIC_LOCK_ERROR);
    }

    @ExceptionHandler(value={AccessDeniedException.class, BadCredentialsException.class})
    protected ResponseEntity<Object> handleSecurityExceptions(Exception exception) {
        Exception a = exception;
        GeneralExceptionHandler a2 = this;
        Exception exception2 = a;
        return a2.buildErrorResponse(exception2, exception2.getMessage(), (HttpStatusCode)HttpStatus.FORBIDDEN, SECURITY_ERROR);
    }

    private /* synthetic */ String getCurrentPath() {
        try {
            return ((ServletRequestAttributes)RequestContextHolder.currentRequestAttributes()).getRequest().getRequestURI();
        }
        catch (Exception exception) {
            return c_Ya.m_aC((Object)"S9W0\f-M3M7T6");
        }
    }

    @ExceptionHandler(value={SetValueException.class})
    protected ResponseEntity<Object> handleSetValueException(SetValueException setValueException) {
        GeneralExceptionHandler a = setValueException;
        GeneralExceptionHandler a2 = this;
        GeneralExceptionHandler generalExceptionHandler = a;
        return a2.buildErrorResponse((Exception)generalExceptionHandler, generalExceptionHandler.getMessage(), (HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR, SET_VALUE_ERROR);
    }

    public GeneralExceptionHandler(Environment environment) {
        GeneralExceptionHandler a = environment;
        GeneralExceptionHandler a2 = this;
        a2.environment = a;
    }

    @ExceptionHandler(value={InfluxDBMapperException.class})
    protected ResponseEntity<Object> handleInfluxDBMapper(InfluxDBMapperException influxDBMapperException) {
        GeneralExceptionHandler a = influxDBMapperException;
        GeneralExceptionHandler a2 = this;
        GeneralExceptionHandler generalExceptionHandler = a;
        return a2.buildErrorResponse((Exception)generalExceptionHandler, generalExceptionHandler.getMessage(), (HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR, DATABASE_ERROR);
    }

    @ExceptionHandler(value={MethodArgumentTypeMismatchException.class})
    protected ResponseEntity<Object> handleMethodArgumentTypeMismatch(MethodArgumentTypeMismatchException methodArgumentTypeMismatchException) {
        GeneralExceptionHandler a = methodArgumentTypeMismatchException;
        GeneralExceptionHandler a2 = this;
        Object[] objectArray = new Object[--3];
        objectArray[3 ^ 3] = a.getName();
        objectArray[--1] = a.getValue();
        objectArray[--2] = a.getRequiredType() != null ? a.getRequiredType().getSimpleName() : c_Ya.m_aC((Object)"-M3M7T6");
        String string = c_Mc.m_zk((Object)"=\u000e\u001f\u000e\u0000\n\u0019\n\u001fOJJ\u001eHM\u0018\u0004\u001b\u0005O\u001b\u000e\u0001\u001a\bOJJ\u001eHM\f\u0002\u001a\u0001\u000bM\u0001\u0002\u001bM\r\bO\u000e\u0000\u0003\u0019\b\u001d\u0019\n\tO\u0019\u0000M\u001b\u0014\u001f\bOJJ\u001eH").formatted(objectArray);
        return a2.buildErrorResponse((Exception)a, string, (HttpStatusCode)HttpStatus.BAD_REQUEST, VALIDATION_ERROR);
    }

    @ExceptionHandler(value={AuthTokenException.class})
    protected ResponseEntity<Object> handleAuthTokenException(AuthTokenException authTokenException) {
        GeneralExceptionHandler a = authTokenException;
        GeneralExceptionHandler a2 = this;
        GeneralExceptionHandler generalExceptionHandler = a;
        return a2.buildErrorResponse((Exception)generalExceptionHandler, generalExceptionHandler.getMessage(), (HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR, AUTH_TOKEN_ERROR);
    }

    @ExceptionHandler(value={MismatchException.class})
    protected ResponseEntity<Object> handleMismatch(MismatchException mismatchException) {
        GeneralExceptionHandler a = mismatchException;
        GeneralExceptionHandler a2 = this;
        GeneralExceptionHandler generalExceptionHandler = a;
        return a2.buildErrorResponse((Exception)generalExceptionHandler, generalExceptionHandler.getMessage(), (HttpStatusCode)HttpStatus.BAD_REQUEST, MISMATCH_ERROR);
    }

    @ExceptionHandler(value={ValidationDefinitionException.class})
    protected ResponseEntity<Object> handleValidationDefinitionException(ValidationDefinitionException validationDefinitionException) {
        GeneralExceptionHandler a = validationDefinitionException;
        GeneralExceptionHandler a2 = this;
        GeneralExceptionHandler generalExceptionHandler = a;
        return a2.buildErrorResponse((Exception)generalExceptionHandler, generalExceptionHandler.getMessage(), (HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR, VALIDATION_DEFINITION_ERROR);
    }

    @ExceptionHandler(value={ConstraintViolationException.class})
    protected ResponseEntity<Object> handleConstraintViolation(ConstraintViolationException constraintViolationException) {
        GeneralExceptionHandler a2 = constraintViolationException;
        GeneralExceptionHandler a3 = this;
        Map map = a2.getConstraintViolations().stream().collect(Collectors.groupingBy(a -> a.getPropertyPath().toString(), Collectors.mapping(ConstraintViolation::getMessage, Collectors.toList())));
        GeneralExceptionHandler generalExceptionHandler = a3;
        a2 = generalExceptionHandler.createExceptionDetails((HttpStatusCode)HttpStatus.CONFLICT, generalExceptionHandler.formatErrorMessages(map), (Exception)a2, CONSTRAINT_VIOLATION, map);
        log.error(c_Ya.m_aC((Object)"`7M+W*B1M,\u0003.J7O9W1L6\u0019xX%"), (Object)a2);
        return new ResponseEntity((Object)a2, (HttpStatusCode)HttpStatus.CONFLICT);
    }

    @ExceptionHandler(value={CommunicationException.class})
    protected ResponseEntity<Object> handleCommunicationException(CommunicationException communicationException) {
        GeneralExceptionHandler a = communicationException;
        GeneralExceptionHandler a2 = this;
        GeneralExceptionHandler generalExceptionHandler = a;
        return a2.buildErrorResponse((Exception)generalExceptionHandler, generalExceptionHandler.getMessage(), (HttpStatusCode)HttpStatus.BAD_REQUEST, COMMUNICATION_ERROR);
    }

    @ExceptionHandler(value={SmsProviderException.class})
    protected ResponseEntity<Object> handleSmsProviderException(SmsProviderException smsProviderException) {
        GeneralExceptionHandler a = smsProviderException;
        GeneralExceptionHandler a2 = this;
        GeneralExceptionHandler generalExceptionHandler = a;
        return a2.buildErrorResponse((Exception)generalExceptionHandler, generalExceptionHandler.getMessage(), (HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR, SMS_PROVIDER_ERROR);
    }

    @ExceptionHandler(value={RunAsExecutionException.class})
    protected ResponseEntity<Object> handleRunAsExecution(RunAsExecutionException runAsExecutionException) {
        GeneralExceptionHandler a = runAsExecutionException;
        GeneralExceptionHandler a2 = this;
        GeneralExceptionHandler generalExceptionHandler = a;
        return a2.buildErrorResponse((Exception)generalExceptionHandler, generalExceptionHandler.getMessage(), (HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR, RUN_AS_ERROR);
    }

    @ExceptionHandler(value={DataIntegrityViolationException.class})
    protected ResponseEntity<Object> handleDataIntegrityViolation(DataIntegrityViolationException dataIntegrityViolationException) {
        GeneralExceptionHandler a = dataIntegrityViolationException;
        GeneralExceptionHandler a2 = this;
        GeneralExceptionHandler generalExceptionHandler = a;
        return a2.buildErrorResponse((Exception)generalExceptionHandler, ExceptionUtils.getRootCauseMessage((Throwable)generalExceptionHandler), (HttpStatusCode)HttpStatus.CONFLICT, DATABASE_ERROR);
    }

    @ExceptionHandler(value={ScriptException.class})
    protected ResponseEntity<Object> handleScriptException(ScriptException scriptException) {
        GeneralExceptionHandler a = scriptException;
        GeneralExceptionHandler a2 = this;
        GeneralExceptionHandler generalExceptionHandler = a;
        return a2.buildErrorResponse((Exception)generalExceptionHandler, generalExceptionHandler.getMessage(), (HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR, SCRIPT_ERROR);
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ ExceptionDetails createExceptionDetails(HttpStatusCode httpStatusCode, String string, Exception exception, String string2) {
        Object a;
        void a2;
        void a3;
        void a4;
        GeneralExceptionHandler generalExceptionHandler = object;
        Object object = string2;
        GeneralExceptionHandler a5 = generalExceptionHandler;
        return a5.createExceptionDetails((HttpStatusCode)a4, (String)a3, (Exception)a2, (String)a, null);
    }

    @ExceptionHandler(value={SpaceOperationException.class})
    protected ResponseEntity<Object> handleSpaceOperationException(SpaceOperationException spaceOperationException) {
        GeneralExceptionHandler a = spaceOperationException;
        GeneralExceptionHandler a2 = this;
        GeneralExceptionHandler generalExceptionHandler = a;
        return a2.buildErrorResponse((Exception)generalExceptionHandler, generalExceptionHandler.getMessage(), (HttpStatusCode)HttpStatus.BAD_REQUEST, SPACE_OPERATION_ERROR);
    }

    /*
     * WARNING - void declaration
     */
    @NonNull
    protected ResponseEntity<Object> handleMethodArgumentNotValid(MethodArgumentNotValidException methodArgumentNotValidException, @NonNull HttpHeaders httpHeaders, @NonNull HttpStatusCode httpStatusCode, @NonNull WebRequest webRequest) {
        void ex;
        GeneralExceptionHandler generalExceptionHandler = object;
        Object object = httpHeaders;
        GeneralExceptionHandler headers = generalExceptionHandler;
        object = new HashMap();
        Map status = ex.getBindingResult().getFieldErrors().stream().collect(Collectors.groupingBy(FieldError::getField, Collectors.mapping(objectError -> {
            GeneralExceptionHandler a = objectError;
            GeneralExceptionHandler a2 = this;
            if (a.getDefaultMessage() != null) {
                return a.getDefaultMessage();
            }
            return c_Ya.m_aC((Object)"m7\u00035F+P9D=\u00039U9J4B:O=");
        }, Collectors.toList())));
        List a = ex.getBindingResult().getGlobalErrors().stream().map(objectError -> {
            GeneralExceptionHandler a = objectError;
            GeneralExceptionHandler a2 = this;
            if (a.getDefaultMessage() != null) {
                return a.getDefaultMessage();
            }
            return c_Ya.m_aC((Object)"m7\u00035F+P9D=\u00039U9J4B:O=");
        }).collect(Collectors.toList());
        object.putAll(status);
        if (!a.isEmpty()) {
            object.put(c_Mc.m_zk((Object)"\n\u0003\u0002\r\f\u0003"), a);
        }
        object = headers.createExceptionDetails((HttpStatusCode)HttpStatus.BAD_REQUEST, headers.formatErrorMessages((Map)object), (Exception)ex, VALIDATION_ERROR, (Map)object);
        log.error(c_Ya.m_aC((Object)"u9O1G9W1L6\u0003=Q*L*\u0019xX%"), object, (Object)ex);
        return new ResponseEntity(object, (HttpStatusCode)HttpStatus.BAD_REQUEST);
    }

    @ExceptionHandler(value={SettingsException.class})
    protected ResponseEntity<Object> handleSettingsException(SettingsException settingsException) {
        GeneralExceptionHandler a = settingsException;
        GeneralExceptionHandler a2 = this;
        GeneralExceptionHandler generalExceptionHandler = a;
        return a2.buildErrorResponse((Exception)generalExceptionHandler, generalExceptionHandler.getMessage(), (HttpStatusCode)HttpStatus.BAD_REQUEST, SETTINGS_ERROR);
    }

    @ExceptionHandler(value={RelationExistsException.class})
    protected ResponseEntity<Object> handleRelationExists(RelationExistsException relationExistsException) {
        GeneralExceptionHandler a = relationExistsException;
        GeneralExceptionHandler a2 = this;
        GeneralExceptionHandler generalExceptionHandler = a;
        return a2.buildErrorResponse((Exception)generalExceptionHandler, generalExceptionHandler.getMessage(), (HttpStatusCode)HttpStatus.CONFLICT, RELATION_EXISTS_ERROR);
    }

    @ExceptionHandler(value={Exception.class})
    protected ResponseEntity<Object> handleAllExceptions(Exception exception) {
        Exception a = exception;
        GeneralExceptionHandler a2 = this;
        Exception exception2 = a;
        return a2.buildErrorResponse(exception2, exception2.getMessage(), (HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR, UNKNOWN_ERROR);
    }

    @ExceptionHandler(value={AlreadyExistsException.class})
    protected ResponseEntity<Object> handleAlreadyExists(AlreadyExistsException alreadyExistsException) {
        GeneralExceptionHandler a = alreadyExistsException;
        GeneralExceptionHandler a2 = this;
        GeneralExceptionHandler generalExceptionHandler = a;
        return a2.buildErrorResponse((Exception)generalExceptionHandler, generalExceptionHandler.getMessage(), (HttpStatusCode)HttpStatus.CONFLICT, ALREADY_EXISTS_ERROR);
    }

    @ExceptionHandler(value={ReportGenerationException.class})
    protected ResponseEntity<Object> handleReportGenerationException(ReportGenerationException reportGenerationException) {
        GeneralExceptionHandler a = reportGenerationException;
        GeneralExceptionHandler a2 = this;
        GeneralExceptionHandler generalExceptionHandler = a;
        return a2.buildErrorResponse((Exception)generalExceptionHandler, generalExceptionHandler.getMessage(), (HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR, REPORT_GENERATION_ERROR);
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ ExceptionDetails createExceptionDetails(HttpStatusCode httpStatusCode, String string, Exception exception, String string2, Map<String, List<String>> map) {
        void a;
        void a2;
        Object a3;
        void a4;
        String a5;
        GeneralExceptionHandler a6;
        GeneralExceptionHandler generalExceptionHandler = object;
        Object object = string2;
        GeneralExceptionHandler generalExceptionHandler2 = a6 = generalExceptionHandler;
        a5 = generalExceptionHandler2.sanitizeMessage(a5, (Exception)a4);
        String string3 = generalExceptionHandler2.isDevelopment() ? a4.getClass().getName() : c_Ya.m_aC((Object)"\u001d[;F(W1L6");
        Object object2 = a6.isDevelopment() ? a3 : c_Mc.m_zk((Object)"*\u001f\u001d\u0002\u001d");
        return new ExceptionDetails(a2.value(), a5, string3, (String)object2, (Map)a, (String)(a3 = a6.isDevelopment() ? ExceptionUtils.getStackTrace((Throwable)a4) : null), new Date(), a6.getCurrentPath());
    }

    @ExceptionHandler(value={FileStorageException.class})
    protected ResponseEntity<Object> handleFileStorage(FileStorageException fileStorageException) {
        GeneralExceptionHandler a = fileStorageException;
        GeneralExceptionHandler a2 = this;
        GeneralExceptionHandler generalExceptionHandler = a;
        return a2.buildErrorResponse((Exception)generalExceptionHandler, generalExceptionHandler.getMessage(), (HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR, FILE_STORAGE_ERROR);
    }

    private /* synthetic */ String formatErrorMessages(Map<String, List<String>> map) {
        Map<String, List<String>> a2 = map;
        GeneralExceptionHandler a3 = this;
        return a2.entrySet().stream().map(a -> (String)a.getKey() + ": " + String.join((CharSequence)c_Mc.m_zk((Object)"AO"), (Iterable)a.getValue())).collect(Collectors.joining(c_Mc.m_zk((Object)"O\u0011O")));
    }

    @ExceptionHandler(value={ReportSchedulingException.class})
    protected ResponseEntity<Object> handleReportSchedulingException(ReportSchedulingException reportSchedulingException) {
        GeneralExceptionHandler a = reportSchedulingException;
        GeneralExceptionHandler a2 = this;
        GeneralExceptionHandler generalExceptionHandler = a;
        return a2.buildErrorResponse((Exception)generalExceptionHandler, generalExceptionHandler.getMessage(), (HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR, REPORT_SCHEDULING_ERROR);
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ String sanitizeMessage(String string, Exception exception) {
        void a;
        Object a2 = exception;
        GeneralExceptionHandler a3 = this;
        if (a2 instanceof ScriptException) {
            return a;
        }
        if (a3.isDevelopment()) {
            return a;
        }
        if (a2 instanceof AlreadyExistsException) {
            return c_Mc.m_zk((Object)"=\b\u001c\u0002\u001a\u001f\f\bO\f\u0003\u001f\n\f\u000b\u0014O\b\u0017\u0004\u001c\u0019\u001c");
        }
        if (a2 instanceof FileStorageException) {
            return c_Ya.m_aC((Object)"\u001eJ4FxL(F*B,J7MxE9J4F<");
        }
        if (a2 instanceof MismatchException) {
            return c_Mc.m_zk((Object)"=\b\u001c\u0002\u001a\u001f\f\bO\u0000\u0006\u001e\u0002\f\u001b\u000e\u0007");
        }
        if (a2 instanceof NotActiveException) {
            return c_Ya.m_aC((Object)"q=P7V*@=\u00031PxM7WxB;W1U=");
        }
        if (a2 instanceof NotFoundException) {
            return c_Mc.m_zk((Object)"?\n\u001e\u0000\u0018\u001d\u000e\nM\u0001\u0002\u001bM\t\u0002\u001a\u0003\u000b");
        }
        if (a2 instanceof RelationExistsException) {
            return c_Ya.m_aC((Object)"\nF4B,F<\u0003*F+L-Q;FxF J+W+");
        }
        if (a2 instanceof OptimisticLockException || a2 instanceof StaleObjectStateException) {
            return c_Mc.m_zk((Object)"?\n\u001e\u0000\u0018\u001d\u000e\nM\u0018\f\u001cM\u001a\u001d\u000b\f\u001b\b\u000bM\r\u0014O\f\u0001\u0002\u001b\u0005\n\u001fO\u0018\u001c\b\u001d");
        }
        if (a2 instanceof SmsProviderException) {
            return c_Ya.m_aC((Object)"p\u0015pxP=Q.J;FxL(F*B,J7MxE9J4F<");
        }
        if (a2 instanceof SettingsException) {
            return c_Mc.m_zk((Object)",\u001f\u001d\u0003\u0004\f\f\u001b\u0004\u0000\u0003O\u001e\n\u0019\u001b\u0004\u0001\n\u001cM\n\u001f\u001d\u0002\u001d");
        }
        if (a2 instanceof ParsingException) {
            return c_Ya.m_aC((Object)"\u0011M.B4J<\u0003<B,BxE7Q5B,");
        }
        if (a2 instanceof ValidationDefinitionException) {
            return c_Mc.m_zk((Object)"&\u0003\u001b\b\u001d\u0003\u000e\u0001O\u001b\u000e\u0001\u0006\t\u000e\u0019\u0006\u0002\u0001M\f\u0002\u0001\u000b\u0006\n\u001a\u001f\u000e\u0019\u0006\u0002\u0001M\n\u001f\u001d\u0002\u001d");
        }
        if (a2 instanceof BrowseOperationException) {
            return c_Ya.m_aC((Object)"\u0019MxF*Q7QxL;@-Q*F<\u0003<V*J6DxBxA*L/P=\u00037S=Q9W1L6");
        }
        if (a2 instanceof SetValueException) {
            return c_Mc.m_zk((Object)".\u0003O\b\u001d\u001f\u0000\u001fO\u0002\f\u000e\u001a\u001f\u001d\b\u000bM\u0018\u0005\u0006\u0001\nM\u001c\b\u001b\u0019\u0006\u0003\bM\u000eM\u0019\f\u0003\u0018\n");
        }
        if (a2 instanceof CommunicationException) {
            return c_Ya.m_aC((Object)"\u001bL5N-M1@9W1L6\u0003;L6E1D-Q9W1L6\u0003=Q*L*");
        }
        if (a2 instanceof RunAsExecutionException) {
            return c_Mc.m_zk((Object)".\u0003O\u0004\u0001\u0019\n\u001f\u0001\f\u0003M\u0000\u001d\n\u001f\u000e\u0019\u0006\u0002\u0001M\t\f\u0006\u0001\n\tO\t\u001a\u001f\u0006\u0003\bM\n\u0015\n\u000e\u001a\u0019\u0006\u0002\u0001");
        }
        if (a2 instanceof SpaceOperationException) {
            return c_Ya.m_aC((Object)"\u000bS9@=\u00037S=Q9W1L6\u0003>B1O=GxG-FxW7\u00039\u0003:V+J6F+PxQ-O=\u0003.J7O9W1L6");
        }
        if (a2 instanceof ImportExportException) {
            return c_Mc.m_zk((Object)".\u0003O\b\u001d\u001f\u0000\u001fO\u0002\f\u000e\u001a\u001f\u001d\b\u000bM\u000b\u0018\u001d\u0004\u0001\nO\t\u000e\u0019\u000eM\u0006\u0000\u001f\u0002\u001d\u0019@\b\u0017\u001d\u0000\u001f\u001b");
        }
        if (a2 instanceof ReportGenerationException) {
            return c_Ya.m_aC((Object)"b6\u0003=Q*L*\u00037@;V*Q=GxG-Q1M?\u0003*F(L*WxD=M=Q9W1L6");
        }
        if (a2 instanceof ReportSchedulingException) {
            return c_Mc.m_zk((Object)",\u0001M\n\u001f\u001d\u0002\u001dM\u0000\u000e\f\u0018\u001d\u001f\n\tO\t\u001a\u001f\u0006\u0003\bM\u001d\b\u001f\u0002\u001d\u0019O\u001e\f\u0005\n\t\u001a\u0001\u0006\u0003\b");
        }
        if (a2 instanceof BroadcastOperationException) {
            return c_Ya.m_aC((Object)"b6\u0003=Q*L*\u00037@;V*Q=GxG-Q1M?\u00039\u0003:Q7B<@9P,\u00037S=Q9W1L6");
        }
        if (a2 instanceof AuthTokenException) {
            return c_Mc.m_zk((Object)",\u0001M\u000e\u0018\u001b\u0005\n\u0003\u001b\u0004\f\f\u001b\u0004\u0000\u0003O\u0019\u0000\u0006\n\u0003O\b\u001d\u001f\u0000\u001fO\u0002\f\u000e\u001a\u001f\u001d\b\u000b");
        }
        if (a2 instanceof DataIntegrityViolationException) {
            return c_Ya.m_aC((Object)"\u001cB,B:B+Fx@7M+W*B1M,\u0003.J7O9W1L6");
        }
        if (a2 instanceof TransactionSystemException) {
            return c_Mc.m_zk((Object)")\u000e\u0019\u000e\u000f\u000e\u001e\nM\u001b\u001f\u000e\u0003\u001c\f\f\u0019\u0006\u0002\u0001M\n\u001f\u001d\u0002\u001d");
        }
        if (a2 instanceof InfluxDBMapperException) {
            return c_Ya.m_aC((Object)"w1N=\u0003+F*J=PxG9W9A9P=\u0003=Q*L*");
        }
        if (a2 instanceof SecurityException || a2 instanceof AccessDeniedException || a2 instanceof BadCredentialsException) {
            return c_Mc.m_zk((Object)".\u000e\f\b\u001c\u001eO\t\n\u0003\u0006\b\u000b");
        }
        if (a2 instanceof MethodArgumentNotValidException || a2 instanceof IllegalArgumentException) {
            return c_Ya.m_aC((Object)"\u0011M.B4J<\u00031M(V,");
        }
        if (a2 instanceof ConstraintViolationException) {
            return c_Mc.m_zk((Object)"9\f\u0003\u0004\u000b\f\u001b\u0004\u0000\u0003O\u000e\u0000\u0003\u001c\u0019\u001d\f\u0006\u0003\u001bM\u0019\u0004\u0000\u0001\u000e\u0019\u0006\u0002\u0001");
        }
        if (a2 instanceof HttpMessageNotReadableException) {
            return c_Ya.m_aC((Object)"j6U9O1GxQ=R-F+WxE7Q5B,");
        }
        if (a2 instanceof MissingServletRequestParameterException) {
            return c_Mc.m_zk((Object)" \u0006\u001e\u001c\u0004\u0001\nO\u001f\n\u001c\u001a\u0004\u001d\b\u000bM\u001f\f\u001d\f\u0002\b\u001b\b\u001d");
        }
        if (a2 instanceof IllegalStateException) {
            return c_Ya.m_aC((Object)"\u0011M.B4J<\u00039S(O1@9W1L6\u0003+W9W=");
        }
        return c_Mc.m_zk((Object)",\u0001M\u001a\u0003\n\u0015\u001f\b\f\u0019\n\tO\b\u001d\u001f\u0000\u001fO\u0002\f\u000e\u001a\u001f\u001d\b\u000b");
    }

    protected ResponseEntity<Object> handleMissingServletRequestParameter(MissingServletRequestParameterException missingServletRequestParameterException, @NonNull HttpHeaders httpHeaders, @NonNull HttpStatusCode httpStatusCode, @NonNull WebRequest webRequest) {
        GeneralExceptionHandler generalExceptionHandler = generalExceptionHandler2;
        GeneralExceptionHandler generalExceptionHandler2 = missingServletRequestParameterException;
        GeneralExceptionHandler ex = generalExceptionHandler;
        Object[] objectArray = new Object[5 >> 1];
        objectArray[3 & 4] = generalExceptionHandler2.getParameterName();
        objectArray[3 >> 1] = generalExceptionHandler2.getParameterType();
        ExceptionDetails headers = ex.createExceptionDetails((HttpStatusCode)HttpStatus.BAD_REQUEST, c_Mc.m_zk((Object)"=\b\u001e\u0018\u0006\u001f\n\tO\u001d\u000e\u001f\u000e\u0000\n\u0019\n\u001fOJJ\u001eHM\u0000\u000bO\u0019\u0016\u001d\nMHH\u001cJO\u0004\u001cM\u0002\u0004\u001c\u001e\u0006\u0003\b").formatted(objectArray), (Exception)generalExceptionHandler2, VALIDATION_ERROR);
        log.error(c_Ya.m_aC((Object)"\u0015J+P1M?\u0003(B*B5F,F*\u0019xX%"), (Object)headers, (Object)generalExceptionHandler2);
        return new ResponseEntity((Object)headers, (HttpStatusCode)HttpStatus.BAD_REQUEST);
    }

    /*
     * WARNING - void declaration
     */
    @ExceptionHandler(value={TransactionSystemException.class})
    protected ResponseEntity<Object> handleTransactionSystemException(TransactionSystemException transactionSystemException) {
        void a;
        GeneralExceptionHandler generalExceptionHandler = this;
        Object a2 = a.getRootCause();
        if (a2 instanceof ConstraintViolationException) {
            a2 = (ConstraintViolationException)a2;
            return generalExceptionHandler.handleConstraintViolation((ConstraintViolationException)a2);
        }
        void v0 = a;
        return generalExceptionHandler.buildErrorResponse((Exception)v0, ExceptionUtils.getRootCauseMessage((Throwable)v0), (HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR, DATABASE_ERROR);
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ ResponseEntity<Object> buildErrorResponse(Exception exception, String string, HttpStatusCode httpStatusCode, String string2) {
        void a;
        void a2;
        void a3;
        Object a4 = string;
        GeneralExceptionHandler a5 = this;
        a4 = a5.createExceptionDetails((HttpStatusCode)a3, (String)a4, (Exception)a2, (String)a, null);
        log.error(c_Mc.m_zk((Object)"$\u0001\u0019\n\u001f\u0001\f\u0003M\n\u001f\u001d\u0002\u001dWO\u0016\u0012"), a4, (Object)a2);
        return new ResponseEntity(a4, (HttpStatusCode)a3);
    }

    /*
     * WARNING - void declaration
     */
    protected ResponseEntity<Object> handleExceptionInternal(Exception exception, Object object, @NonNull HttpHeaders httpHeaders, @NonNull HttpStatusCode httpStatusCode, @NonNull WebRequest webRequest) {
        void ex;
        void status;
        GeneralExceptionHandler generalExceptionHandler = object2;
        Object object2 = object;
        GeneralExceptionHandler body = generalExceptionHandler;
        object2 = body.createExceptionDetails((HttpStatusCode)status, ex.getMessage(), (Exception)ex, UNKNOWN_ERROR);
        log.error(c_Ya.m_aC((Object)"j6W=Q6B4\u0003=Q*L*\u0019xX%"), object2, (Object)ex);
        return new ResponseEntity(object2, (HttpStatusCode)status);
    }

    @ExceptionHandler(value={InscadaException.class})
    protected ResponseEntity<Object> handleInscadaException(InscadaException inscadaException) {
        GeneralExceptionHandler a = inscadaException;
        GeneralExceptionHandler a2 = this;
        GeneralExceptionHandler generalExceptionHandler = a;
        return a2.buildErrorResponse((Exception)generalExceptionHandler, generalExceptionHandler.getMessage(), (HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR, INSCADA_ERROR);
    }

    @ExceptionHandler(value={NotActiveException.class})
    protected ResponseEntity<Object> handleNotActive(NotActiveException notActiveException) {
        GeneralExceptionHandler a = notActiveException;
        GeneralExceptionHandler a2 = this;
        GeneralExceptionHandler generalExceptionHandler = a;
        return a2.buildErrorResponse((Exception)generalExceptionHandler, generalExceptionHandler.getMessage(), (HttpStatusCode)HttpStatus.BAD_REQUEST, NOT_ACTIVE_ERROR);
    }

    @ExceptionHandler(value={ParsingException.class})
    protected ResponseEntity<Object> handleParsingException(ParsingException parsingException) {
        GeneralExceptionHandler a = parsingException;
        GeneralExceptionHandler a2 = this;
        GeneralExceptionHandler generalExceptionHandler = a;
        return a2.buildErrorResponse((Exception)generalExceptionHandler, generalExceptionHandler.getMessage(), (HttpStatusCode)HttpStatus.BAD_REQUEST, PARSING_ERROR);
    }

    @ExceptionHandler(value={IllegalArgumentException.class})
    protected ResponseEntity<Object> handleIllegalArgument(IllegalArgumentException illegalArgumentException) {
        IllegalArgumentException a = illegalArgumentException;
        GeneralExceptionHandler a2 = this;
        IllegalArgumentException illegalArgumentException2 = a;
        return a2.buildErrorResponse((Exception)illegalArgumentException2, illegalArgumentException2.getMessage(), (HttpStatusCode)HttpStatus.BAD_REQUEST, VALIDATION_ERROR);
    }

    @ExceptionHandler(value={BrowseOperationException.class})
    protected ResponseEntity<Object> handleBrowseOperationException(BrowseOperationException browseOperationException) {
        GeneralExceptionHandler a = browseOperationException;
        GeneralExceptionHandler a2 = this;
        GeneralExceptionHandler generalExceptionHandler = a;
        return a2.buildErrorResponse((Exception)generalExceptionHandler, generalExceptionHandler.getMessage(), (HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR, BROWSE_OPERATION_ERROR);
    }

    @ExceptionHandler(value={IllegalStateException.class})
    protected ResponseEntity<Object> handleIllegalState(IllegalStateException illegalStateException) {
        IllegalStateException a = illegalStateException;
        GeneralExceptionHandler a2 = this;
        IllegalStateException illegalStateException2 = a;
        return a2.buildErrorResponse((Exception)illegalStateException2, illegalStateException2.getMessage(), (HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR, INSCADA_ERROR);
    }

    @ExceptionHandler(value={NotFoundException.class, EntityNotFoundException.class})
    protected ResponseEntity<Object> handleEntityNotFound(Exception exception) {
        Exception a = exception;
        GeneralExceptionHandler a2 = this;
        Exception exception2 = a;
        return a2.buildErrorResponse(exception2, exception2.getMessage(), (HttpStatusCode)HttpStatus.NOT_FOUND, NOT_FOUND_ERROR);
    }

    @ExceptionHandler(value={BroadcastOperationException.class})
    protected ResponseEntity<Object> handleBroadcastOperationException(BroadcastOperationException broadcastOperationException) {
        GeneralExceptionHandler a = broadcastOperationException;
        GeneralExceptionHandler a2 = this;
        GeneralExceptionHandler generalExceptionHandler = a;
        return a2.buildErrorResponse((Exception)generalExceptionHandler, generalExceptionHandler.getMessage(), (HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR, BROADCAST_OPERATION_ERROR);
    }

    @ExceptionHandler(value={ImportExportException.class})
    protected ResponseEntity<Object> handleImportExportException(ImportExportException importExportException) {
        GeneralExceptionHandler a = importExportException;
        GeneralExceptionHandler a2 = this;
        GeneralExceptionHandler generalExceptionHandler = a;
        return a2.buildErrorResponse((Exception)generalExceptionHandler, generalExceptionHandler.getMessage(), (HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR, IMPORT_EXPORT_ERROR);
    }

    /*
     * WARNING - void declaration
     */
    protected ResponseEntity<Object> handleHttpMessageNotReadable(HttpMessageNotReadableException httpMessageNotReadableException, @NonNull HttpHeaders httpHeaders, @NonNull HttpStatusCode httpStatusCode, @NonNull WebRequest webRequest) {
        void ex;
        GeneralExceptionHandler generalExceptionHandler = generalExceptionHandler2;
        GeneralExceptionHandler generalExceptionHandler2 = httpHeaders;
        GeneralExceptionHandler headers = generalExceptionHandler;
        generalExceptionHandler2 = headers.createExceptionDetails((HttpStatusCode)HttpStatus.BAD_REQUEST, "Malformed JSON request: " + ex.getMessage(), (Exception)ex, VALIDATION_ERROR);
        log.error(c_Mc.m_zk((Object)" \n\u001e\u001c\f\b\bO\u0003\u0000\u0019O\u001f\n\f\u000b\f\r\u0001\nWO\u0016\u0012"), (Object)generalExceptionHandler2, (Object)ex);
        return new ResponseEntity((Object)generalExceptionHandler2, (HttpStatusCode)HttpStatus.BAD_REQUEST);
    }
}

