/*
 * Decompiled with CFR 0.152.
 */
package com.inscada.mono.script.services;

import com.inscada.mono.auth.c_ZK;
import com.inscada.mono.cluster.exceptions.ClusterRpcException;
import com.inscada.mono.cluster.services.ClusterNodeListener;
import com.inscada.mono.cluster.services.c_B;
import com.inscada.mono.config.c_FB;
import com.inscada.mono.datasource.sql.model.metadata.ProcedureMetadata;
import com.inscada.mono.job.e.c_OA;
import com.inscada.mono.job.model.Job;
import com.inscada.mono.log.services.c_lA;
import com.inscada.mono.project.x.c_I;
import com.inscada.mono.script.e.c_ad;
import com.inscada.mono.script.e.c_db;
import com.inscada.mono.script.model.RepeatableScript;
import com.inscada.mono.script.model.RepeatableScriptSummary;
import com.inscada.mono.script.model.Script;
import com.inscada.mono.script.services.c_Hd;
import com.inscada.mono.script.services.c_vb;
import com.inscada.mono.script.services.c_wc;
import com.inscada.mono.script.x.c_OC;
import com.inscada.mono.script.x.c_bA;
import com.inscada.mono.shared.exceptions.NotActiveException;
import com.inscada.mono.shared.model.OwnedSpaceBaseModel;
import jakarta.annotation.PostConstruct;
import java.time.Duration;
import java.time.LocalTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Component;
import org.springframework.transaction.event.TransactionalEventListener;
import redis.clients.jedis.JedisPooled;

@Component
public class ScriptManager
implements ClusterNodeListener,
c_I {
    private final c_vb f_eb;
    public static final short f_Ic = 301;
    public static final short f_ic = 306;
    private final Lock f_zB;
    private static final Logger f_qB = LoggerFactory.getLogger(ScriptManager.class);
    private final c_wc f_jA;
    private static final String f_Fd = "scheduled_scripts";
    public static final short f_LC = 307;
    public static final short f_rc = 305;
    private final JedisPooled f_Gb;
    private final c_lA f_dc;
    public static final short f_Od = 302;
    private final c_ZK f_hC;
    public static final short f_bC = 303;
    private final c_OA f_bA;
    public static final short f_Vc = 304;
    private final c_B f_ub;
    private final Map<String, Job> f_VA;

    @TransactionalEventListener(value={c_bA.class})
    public void handleRescheduleEvent(c_bA c_bA2) {
        ScriptManager scriptManager = this;
        if (scriptManager.f_ub.m_fa()) {
            ScriptManager a = a.m_zE();
            f_qB.info(c_FB.m_lQ((Object)"aClBhT\u0017&egCbAoCa\rTHuNnHbXjHC[cCr\r`Bt\ruNtDvY<\r}P&\u0005Oi<\r}P/"), (Object)a.getName(), (Object)a.getId());
            if (scriptManager.getScriptStatusInternal(a.getId()) == c_db.f_lB) {
                scriptManager.scheduleScriptInternal(a.getId());
                return;
            }
        } else {
            f_qB.debug(ProcedureMetadata.m_Sq((Object)"Y}Y\u001f[wVvR`-\u0012^Uy]e[yU7`rAtZrVb^rwaWyF7Tx@7At@~Bc\b7Ij"), (Object)a.m_zE().getId());
        }
    }

    protected void cancelScriptInternal(String string) {
        ScriptManager a;
        Object a2 = string;
        ScriptManager scriptManager = a = this;
        scriptManager.cancelScriptInternal(scriptManager.f_jA.m_EE((String)a2));
    }

    @PostConstruct
    private /* synthetic */ void initializeClusterIntegration() {
        ScriptManager a;
        ScriptManager scriptManager = a;
        scriptManager.registerRemoteCallsWithClusterNode();
        scriptManager.f_ub.m_ka((ClusterNodeListener)a);
        f_qB.info(ProcedureMetadata.m_Sq((Object)"at@~Bc\u007fv\\vUr@7[y[c[v^~HrV7SyV7@rU~AcWeWs\u0012vA7q{GdFr@Y]sW[[dFr\\r@9"));
    }

    protected Map<String, c_db> getScriptStatusesByIdsInternal(List<String> list) {
        List<String> a = list;
        ScriptManager a2 = this;
        if (a == null || a.isEmpty()) {
            return Collections.emptyMap();
        }
        return a.stream().collect(Collectors.toMap(Function.identity(), arg_0 -> a2.getScriptStatusInternal(arg_0)));
    }

    private /* synthetic */ void lambda$scheduleScriptInternal$4(RepeatableScript repeatableScript) {
        ScriptManager a = repeatableScript;
        ScriptManager a2 = this;
        a2.f_zB.lock();
        try {
            Job job;
            ScriptManager scriptManager;
            block14: {
                a2.cancelScriptInternal((RepeatableScript)a);
                if (!Boolean.TRUE.equals(a.getProject().getIsActive())) {
                    throw new NotActiveException("Project should be active to schedule script " + a.getName());
                }
                switch (c_Hd.f_DC[a.getType().ordinal()]) {
                    case 1: {
                        ScriptManager scriptManager2 = a2;
                        while (false) {
                        }
                        scriptManager = scriptManager2;
                        job = scriptManager2.createDailyScriptJob((RepeatableScript)a);
                        break block14;
                    }
                    case 2: {
                        ScriptManager scriptManager3 = a2;
                        scriptManager = scriptManager3;
                        job = scriptManager3.createPeriodicScriptJob((RepeatableScript)a);
                        break block14;
                    }
                    case 3: {
                        job = a2.createOnceScriptJob((RepeatableScript)a);
                        break;
                    }
                    case 4: {
                        return;
                    }
                    default: {
                        throw new IllegalArgumentException("Unknown schedule type of " + String.valueOf(a.getType()));
                    }
                }
                scriptManager = a2;
            }
            scriptManager.f_VA.put(a.getId(), job);
            String[] stringArray = new String[3 & 5];
            stringArray[3 >> 2] = a.getId();
            a2.f_Gb.sadd(f_Fd, stringArray);
            return;
        }
        finally {
            a2.f_zB.unlock();
        }
    }

    protected void scheduleScriptsByProjectIdInternal(String string) {
        Object a2 = string;
        ScriptManager a3 = this;
        if ((a2 = a3.f_jA.m_wD((String)a2)) == null || a2.isEmpty()) {
            return;
        }
        a2.stream().filter(a -> {
            if (a.getType() != c_ad.f_ZA) {
                return 5 >> 2;
            }
            return false;
        }).forEach(arg_0 -> a3.scheduleScriptInternal(arg_0));
    }

    /*
     * WARNING - void declaration
     */
    @PreAuthorize(value="hasAuthority('SCHEDULE_SCRIPT')")
    public void scheduleScript(String string, String string2) {
        void a;
        ScriptManager a2;
        Object a3 = string2;
        ScriptManager scriptManager = a2 = this;
        scriptManager.scheduleScript(scriptManager.f_jA.m_KE((String)a, (String)a3).getId());
    }

    @PreAuthorize(value="hasAuthority('VIEW_SCRIPT')")
    public Map<String, c_db> getScriptStatuses(List<String> list) {
        List<String> a = list;
        ScriptManager a2 = this;
        if (a == null || a.isEmpty()) {
            return Collections.emptyMap();
        }
        if (a2.f_ub.m_fa()) {
            f_qB.debug(c_FB.m_lQ((Object)"aClBhT\u0017&jcYrDhJ&^e_o]r\ruYgYs^c^&Ki_&V{\rOiu\rjBeLjA\u007f\u0017&V{"), (Object)a.size(), (Object)a);
            return a2.getScriptStatusesByIdsInternal((List)a);
        }
        f_qB.debug(ProcedureMetadata.m_Sq((Object)"|X|:~RsSwE\b7`rCbWdF~\\p\u0012{WvVr@7Tx@7At@~Bc\u0012dFvFbArA7Tx@7Ij\u0012^vd\b7Ij"), (Object)a.size(), (Object)a);
        try {
            Object[] objectArray = new Object[--1];
            objectArray[5 >> 3] = new ArrayList(a);
            return (Map)a2.f_ub.m_ga(Short.valueOf((short)(0xF33 & 0x71FE)), objectArray);
        }
        catch (Exception exception) {
            throw new ClusterRpcException("Failed to RPC get script statuses for IDs " + a.stream().map(String::valueOf).collect(Collectors.joining(c_FB.m_lQ((Object)"*"))), (Throwable)exception);
        }
    }

    private /* synthetic */ String generateJobName(RepeatableScript repeatableScript) {
        ScriptManager a = repeatableScript;
        ScriptManager a2 = this;
        Object[] objectArray = new Object[--2];
        objectArray[5 >> 3] = a.getType().m_rf();
        objectArray[3 >> 1] = a.getName();
        return ProcedureMetadata.m_Sq((Object)"\u0017d\u0012DQe[gF7\u001f7\u0017d").formatted(objectArray);
    }

    private /* synthetic */ void lambda$createPeriodicScriptJob$7(RepeatableScript repeatableScript) {
        ScriptManager a = repeatableScript;
        ScriptManager a2 = this;
        a = Script.newBuilder((RepeatableScript)a).build();
        a2.f_eb.m_ke((Script)a);
    }

    protected void cancelScriptsByProjectIdInternal(String string) {
        Object a = string;
        ScriptManager a2 = this;
        if ((a = a2.f_jA.m_wD((String)a)) == null || a.isEmpty()) {
            return;
        }
        a.forEach(arg_0 -> a2.cancelScriptInternal(arg_0));
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ Job createDailyScriptJob(RepeatableScript repeatableScript) {
        void a;
        ScriptManager scriptManager = this;
        Object a2 = a.getTime();
        a2 = LocalTime.of(((Date)a2).getHours(), ((Date)a2).getMinutes(), ((Date)a2).getSeconds());
        return scriptManager.f_bA.m_Ij(a.getProject(), scriptManager.generateJobName((RepeatableScript)a), () -> scriptManager.lambda$createDailyScriptJob$8((RepeatableScript)a), (LocalTime)a2);
    }

    @PreAuthorize(value="hasAuthority('SCHEDULE_SCRIPT')")
    public void scheduleScripts(String string) {
        Object a = string;
        ScriptManager a2 = this;
        if (a2.f_ub.m_fa()) {
            f_qB.debug(ProcedureMetadata.m_Sq((Object)"~RsSwE\b7atZrVb^~\\p\u0012v^{\u0012dQe[gFd\u0012q]e\u0012g@xXrQc\u0012lO7^xQv^{K9"), a);
            a2.scheduleScriptsByProjectIdInternal((String)a);
            return;
        }
        f_qB.debug(c_FB.m_lQ((Object)"HbH\u0000JhGiC\u007f<\rTHwXc^rDhJ&AcLbHt\rrB&^eEcIsAc\rgAj\ruNtDvYu\r`Bt\rv_iGcNr\r}P("), a);
        try {
            Object[] objectArray = new Object[2 ^ 3];
            objectArray[5 >> 3] = a;
            a2.f_ub.m_ga(Short.valueOf((short)(0x4FB8 & 0x3177)), objectArray);
            return;
        }
        catch (Exception exception) {
            throw new ClusterRpcException("Failed to RPC schedule scripts for project " + (String)a, (Throwable)exception);
        }
    }

    /*
     * WARNING - void declaration
     */
    @TransactionalEventListener(value={c_OC.class})
    public void handleCancelEvent(c_OC c_OC2) {
        void a;
        ScriptManager scriptManager = this;
        if (scriptManager.f_ub.m_fa()) {
            ScriptManager a2 = a.m_Ig();
            f_qB.info(c_FB.m_lQ((Object)"aClBhT\u0017&egCbAoCa\rELhNcAC[cCr\r`Bt\ruNtDvY<\r}P&\u0005Oi<\r}P/"), (Object)a2.getName(), (Object)a2.getId());
            scriptManager.cancelScriptInternal((RepeatableScript)a2);
            return;
        }
        f_qB.debug(ProcedureMetadata.m_Sq((Object)"Y}Y\u001f[wVvR`-\u0012^Uy]e[yU7qv\\tW{waWyF7Tx@7At@~Bc\b7Ij"), (Object)a.m_Ig().getId());
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void lambda$createOnceScriptJob$6(RepeatableScript repeatableScript) {
        void a;
        ScriptManager scriptManager = this;
        ScriptManager a2 = Script.newBuilder((RepeatableScript)a).build();
        scriptManager.f_eb.m_ke((Script)a2);
        scriptManager.cancelScript(a.getId());
    }

    protected c_db getScriptStatusInternal(String string) {
        Object a = string;
        ScriptManager a2 = this;
        if (a2.f_VA.containsKey(a)) {
            return c_db.f_lB;
        }
        return c_db.f_wA;
    }

    public void notLeader() {
        ScriptManager scriptManager;
        ScriptManager scriptManager2 = scriptManager = this;
        Object a = scriptManager2.f_ub.m_ja().getNodeId();
        f_qB.info(ProcedureMetadata.m_Sq((Object)"at@~Bc\u007fv\\vUr@-\u0012CZ~A7\\xVr\u0012?Ij\u001b7[d\u0012Y}7~X|PwE\u0012CzR\u0012[wVvR`9\u0012TSyQr^{[yU7S{^7^xQv^7At@~Bc\u0012}]uA9\u001c9"), a);
        scriptManager2.f_zB.lock();
        try {
            new ArrayList(scriptManager.f_VA.keySet()).forEach(arg_0 -> scriptManager.lambda$notLeader$2((String)a, arg_0));
            scriptManager.f_VA.clear();
            f_qB.info(c_FB.m_lQ((Object)"UNtDvYKLhLaHt\r.ciY&acLbHt\r}P/\u0017&ljA&AiNgA&^e_o]r\rlBd^&Eg[c\rdHcC&_c\\sHuYcI&Yi\reLhNcA&LhI&NjHg_cI&KtBk\rjBeLj\rr_gNmDhJ("), a);
            return;
        }
        catch (Exception exception) {
            Object[] objectArray = new Object[--3];
            objectArray[3 & 4] = a;
            objectArray[4 ^ 5] = exception.getMessage();
            objectArray[1 ^ 3] = exception;
            f_qB.error(ProcedureMetadata.m_Sq((Object)"DQe[gFZSySpWe\u0012?|xF7~rSsWe\u0012lO>\b7we@x@7Vb@~\\p\u0012g@xQrAd\u0012xT7Qv\\tW{^~\\p\u0012{]tS{\u0012dQe[gF7XxPd\b7Ij"), objectArray);
            return;
        }
        finally {
            scriptManager.f_zB.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void leader() {
        ScriptManager scriptManager;
        ScriptManager scriptManager2 = scriptManager = this;
        Object a = scriptManager2.f_ub.m_ja().getNodeId();
        f_qB.info(c_FB.m_lQ((Object)"UNtDvYKLhLaHt\u0017&ynDu\rhBbH&\u0005}P/\rnLu\rdHeBkH&YnH&aClBhT\u0003&\u007fc^rBtDhJ&^eEcIsAcI&^e_o]r^(\u0003("), a);
        scriptManager2.f_zB.lock();
        try {
            HashSet hashSet = new HashSet(scriptManager.f_Gb.smembers(f_Fd));
            if (hashSet.isEmpty()) {
                f_qB.info(ProcedureMetadata.m_Sq((Object)"at@~Bc\u007fv\\vUr@7\u001a[WvVr@7Ij\u001b-\u0012Y]7AtZrVb^rV7At@~BcA7TxGyV7[y\u0012EWs[d\u0012c]7@rAc]eW9"), a);
                return;
            }
            Object[] objectArray = new Object[--3];
            objectArray[5 >> 3] = a;
            objectArray[2 ^ 3] = hashSet.size();
            objectArray[5 >> 1] = hashSet;
            f_qB.info(c_FB.m_lQ((Object)"~e_o]r`gCgJc_&\u0005JHgIc_&V{\u0004<\r@BsCb\r}P&^eEcIsAcI&^e_o]r\rOiu\roC&\u007fcIo^&Yi\rtHuYi_c\u0017&V{"), objectArray);
            ArrayList arrayList = new ArrayList();
            String[] stringArray = new String[4 ^ 5];
            stringArray[5 >> 3] = ProcedureMetadata.m_Sq((Object)"A{ReHaT`^bC");
            scriptManager.f_hC.m_fBa(() -> {
                void a;
                Object a2 = hashSet;
                ScriptManager a3 = this;
                a.addAll(a3.f_jA.m_eD((Set)a2));
            }, stringArray);
            f_qB.info(c_FB.m_lQ((Object)"~e_o]r`gCgJc_&\u0005JHgIc_&V{\u0004<\rGYrHk]rDhJ&Yi\rtHuYi_c\r}P&^e_o]r^("), a, (Object)arrayList.size());
            arrayList.forEach(repeatableScript -> {
                void a;
                ScriptManager scriptManager;
                ScriptManager scriptManager2 = scriptManager = this;
                Object a2 = scriptManager2.f_ub.m_ja().getNodeId();
                String[] stringArray = new String[5 >> 1];
                stringArray[2 & 5] = ProcedureMetadata.m_Sq((Object)"Dq_wSg[wHaT`^bC");
                stringArray[5 >> 2] = c_FB.m_lQ((Object)"ElHnCaY~E\u007fO}R");
                scriptManager2.f_hC.m_kDa(() -> scriptManager.lambda$restoreSingleScriptOnLeader$1((String)a2, (RepeatableScript)a), a.getSpace(), stringArray);
            });
            f_qB.info(ProcedureMetadata.m_Sq((Object)"DQe[gFZSySpWe\u0012?~rSsWe\u0012lO>\b7t~\\~A\u007fWs\u0012dQe[gF7@rAc]eSc[x\\7Be]tWdA9"), a);
            return;
        }
        catch (Exception exception) {
            Object[] objectArray = new Object[--3];
            objectArray[3 & 4] = a;
            objectArray[3 & 5] = exception.getMessage();
            objectArray[1 ^ 3] = exception;
            f_qB.error(c_FB.m_lQ((Object)"~e_o]r`gCgJc_&\u0005JHgIc_&V{\u0004<\rC_tBt\rbXtDhJ&^e_o]r\rtHuYi_gYoBh\rv_iNc^u\u0017&V{"), objectArray);
            return;
        }
        finally {
            scriptManager.f_zB.unlock();
        }
    }

    protected void scheduleScriptInternal(String string) {
        ScriptManager a;
        Object a2 = string;
        ScriptManager scriptManager = a = this;
        scriptManager.scheduleScriptInternal(scriptManager.f_jA.m_EE((String)a2));
    }

    private /* synthetic */ void lambda$cancelScriptInternal$9(RepeatableScript repeatableScript) {
        ScriptManager a = repeatableScript;
        ScriptManager a2 = this;
        a2.f_zB.lock();
        try {
            Job job = (Job)a2.f_VA.get(a.getId());
            if (job != null) {
                a2.f_bA.m_jl(job);
            }
            ScriptManager scriptManager = a2;
            scriptManager.f_VA.remove(a.getId());
            String[] stringArray = new String[--1];
            stringArray[2 & 5] = a.getId();
            scriptManager.f_Gb.srem(f_Fd, stringArray);
            return;
        }
        finally {
            a2.f_zB.unlock();
        }
    }

    protected Map<String, c_db> getScriptStatusesByProjectIdInternal(String string) {
        Object a = string;
        ScriptManager a2 = this;
        if ((a = a2.f_jA.m_nF((String)a)) == null || a.isEmpty()) {
            return Collections.emptyMap();
        }
        return a.stream().collect(Collectors.toMap(RepeatableScriptSummary::getId, repeatableScriptSummary -> {
            ScriptManager a = repeatableScriptSummary;
            ScriptManager a2 = this;
            return a2.getScriptStatusInternal(a.getId());
        }));
    }

    private /* synthetic */ Job createOnceScriptJob(RepeatableScript repeatableScript) {
        ScriptManager a = repeatableScript;
        ScriptManager a2 = this;
        return a2.f_bA.m_Jl(a.getProject(), a2.generateJobName((RepeatableScript)a), () -> a2.lambda$createOnceScriptJob$6((RepeatableScript)a), Duration.ofMillis(a.getDelay().intValue()), (3 ^ 3) != 0);
    }

    /*
     * WARNING - void declaration
     */
    @PreAuthorize(value="hasAuthority('CANCEL_SCRIPT')")
    public void cancelScript(String string, String string2) {
        void a;
        ScriptManager a2;
        Object a3 = string2;
        ScriptManager scriptManager = a2 = this;
        scriptManager.cancelScript(scriptManager.f_jA.m_KE((String)a, (String)a3).getId());
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void lambda$restoreSingleScriptOnLeader$1(String string, RepeatableScript repeatableScript) {
        void a;
        ScriptManager a2 = repeatableScript;
        ScriptManager a3 = this;
        try {
            Object[] objectArray = new Object[--3];
            objectArray[5 >> 3] = a;
            objectArray[2 ^ 3] = a2.getName();
            objectArray[5 >> 1] = a2.getId();
            f_qB.info(c_FB.m_lQ((Object)"~e_o]r`gCgJc_&\u0005JHgIc_&V{\u0004<\rTHuYi_oCa\ruNtDvY<\r}P&\u0005Oi<\r}P/"), objectArray);
            a3.scheduleScriptInternal((RepeatableScript)a2);
            return;
        }
        catch (Exception exception) {
            Object[] objectArray = new Object[--3];
            objectArray[5 >> 3] = a2.getName();
            objectArray[2 ^ 3] = a2.getId();
            objectArray[--2] = ExceptionUtils.getRootCauseMessage((Throwable)exception);
            a3.f_dc.m_BJ(a2.getProject()).m_s("Script Restore (Leader " + (String)a + ")", ProcedureMetadata.m_Sq((Object)"\u0017d\u0012?{S\b7\u0017d\u001b7Tv[{Ws\u0012c]7@rAc]eW9\u0012TSbAr\b7\u0017d").formatted(objectArray));
            try {
                f_qB.warn(c_FB.m_lQ((Object)"~e_o]r`gCgJc_&\u0005JHgIc_&V{\u0004<\rGYrHk]rDhJ&Yi\reLhNcA&^e_o]r\r}P&L`Yc_&_c^rBtLrDiC&KgDjXtH("), (Object)a, (Object)a2.getId());
                a3.cancelScriptInternal((RepeatableScript)a2);
                return;
            }
            catch (Exception exception2) {
                Object[] objectArray2 = new Object[--4];
                objectArray2[2 & 5] = a;
                objectArray2[2 ^ 3] = a2.getId();
                objectArray2[1 ^ 3] = exception2.getMessage();
                objectArray2[--3] = exception2;
                f_qB.error(ProcedureMetadata.m_Sq((Object)"DQe[gFZSySpWe\u0012?~rSsWe\u0012lO>\b7tv[{Ws\u0012c]7Qv\\tW{\u0012dQe[gF7Ij\u0012vTcWe\u0012eWdFx@vF~]y\u0012qS~^b@r\b7Ij"), objectArray2);
                return;
            }
        }
    }

    protected void cancelScriptInternal(RepeatableScript repeatableScript) {
        ScriptManager a = repeatableScript;
        ScriptManager a2 = this;
        a2.f_hC.m_pCa(() -> a2.lambda$cancelScriptInternal$9((RepeatableScript)a), (OwnedSpaceBaseModel)a);
    }

    private /* synthetic */ void lambda$createDailyScriptJob$8(RepeatableScript repeatableScript) {
        ScriptManager a = repeatableScript;
        ScriptManager a2 = this;
        a = Script.newBuilder((RepeatableScript)a).build();
        a2.f_eb.m_ke((Script)a);
    }

    @PreAuthorize(value="hasAuthority('CANCEL_SCRIPT')")
    public void cancelScript(String string) {
        Object a = string;
        ScriptManager a2 = this;
        if (a2.f_ub.m_fa()) {
            f_qB.debug(c_FB.m_lQ((Object)"JhGiC\u007f<\rELhNcAjDhJ&^e_o]r\r}P&AiNgAjT("), a);
            a2.cancelScriptInternal((String)a);
            return;
        }
        f_qB.debug(ProcedureMetadata.m_Sq((Object)"|X|:~RsSwE\b7`rCbWdF~\\p\u0012{WvVr@7Fx\u0012tSyQr^7At@~Bc\u0012lO9"), a);
        try {
            Object[] objectArray = new Object[--1];
            objectArray[3 ^ 3] = a;
            a2.f_ub.m_ga(Short.valueOf((short)(0x97F & 0x77AE)), objectArray);
            return;
        }
        catch (Exception exception) {
            throw new ClusterRpcException("Failed to RPC cancel script " + (String)a, (Throwable)exception);
        }
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void lambda$notLeader$2(String string, String string2) {
        void a;
        ScriptManager scriptManager = this;
        ScriptManager a22 = (Job)scriptManager.f_VA.get(a);
        if (a22 != null) {
            void a3;
            try {
                f_qB.info(c_FB.m_lQ((Object)"UNtDvYKLhLaHt\r.ciY&acLbHt\r}P/\u0017&ngCeHjAoCa\rjBeLj\rlBd\r`Bt\ruNtDvY&dB\u0017&V{"), (Object)a3, (Object)a);
                scriptManager.f_bA.m_jl((Job)a22);
                return;
            }
            catch (Exception a22) {
                Object[] objectArray = new Object[--4];
                objectArray[2 & 5] = a3;
                objectArray[3 & 5] = a;
                objectArray[1 ^ 3] = a22.getMessage();
                objectArray[--3] = a22;
                f_qB.error(ProcedureMetadata.m_Sq((Object)"at@~Bc\u007fv\\vUr@7\u001aY]c\u0012[WvVr@7Ij\u001b-\u0012R@e]e\u0012tSyQr^{[yU7^xQv^7XxP7Tx@7At@~Bc\u0012^v7Ij\b7Ij"), objectArray);
            }
        }
    }

    private /* synthetic */ void registerRemoteCallsWithClusterNode() {
        ScriptManager scriptManager = this;
        try {
            Class[] classArray = new Class[3 >> 1];
            classArray[3 & 4] = String.class;
            scriptManager.f_ub.m_ma((short)(0x1FAD & 0x617F), (Object)scriptManager, ScriptManager.class.getDeclaredMethod(c_FB.m_lQ((Object)"^eEcIsAc~e_o]rdhYc_hLj"), classArray));
            Class[] classArray2 = new Class[--1];
            classArray2[3 & 4] = String.class;
            scriptManager.f_ub.m_ma((short)(0x41AF & 0x3F7E), (Object)scriptManager, ScriptManager.class.getDeclaredMethod(ProcedureMetadata.m_Sq((Object)"Qv\\tW{at@~Bc{yFr@yS{"), classArray2));
            Class[] classArray3 = new Class[3 & 5];
            classArray3[3 >> 2] = String.class;
            scriptManager.f_ub.m_ma((short)(0x6D6F & 0x13BF), (Object)scriptManager, ScriptManager.class.getDeclaredMethod(c_FB.m_lQ((Object)"aHr~e_o]r~rLrXudhYc_hLj"), classArray3));
            Class[] classArray4 = new Class[3 & 5];
            classArray4[3 & 4] = String.class;
            scriptManager.f_ub.m_ma((short)(0x4D3A & 0x33F5), (Object)scriptManager, ScriptManager.class.getDeclaredMethod(ProcedureMetadata.m_Sq((Object)"AtZrVb^rat@~BcAUKG@xXrQc{s{yFr@yS{"), classArray4));
            Class[] classArray5 = new Class[3 >> 1];
            classArray5[3 ^ 3] = String.class;
            scriptManager.f_ub.m_ma((short)(0x4BFB & 0x3535), (Object)scriptManager, ScriptManager.class.getDeclaredMethod(c_FB.m_lQ((Object)"NgCeHj~e_o]r^DTV_iGcNrdbdhYc_hLj"), classArray5));
            Class[] classArray6 = new Class[1];
            classArray6[0] = List.class;
            scriptManager.f_ub.m_ma((short)(0x1FF6 & 0x613B), (Object)scriptManager, ScriptManager.class.getDeclaredMethod(ProcedureMetadata.m_Sq((Object)"UrFDQe[gFDFvFbArAUK^Vd{yFr@yS{"), classArray6));
            Class[] classArray7 = new Class[1];
            classArray7[0] = String.class;
            scriptManager.f_ub.m_ma((short)(0x2933 & 0x57FF), (Object)scriptManager, ScriptManager.class.getDeclaredMethod(c_FB.m_lQ((Object)"JcYUNtDvYUYgYs^c^DTV_iGcNrdbdhYc_hLj"), classArray7));
            return;
        }
        catch (NoSuchMethodException a) {
            throw new IllegalStateException(ProcedureMetadata.m_Sq((Object)"tv[{Ws\u0012c]7@rU~AcWe\u0012DQe[gFZSySpWe\u0012EbT\u0012zWcZxVd"), a);
        }
    }

    private /* synthetic */ Job createPeriodicScriptJob(RepeatableScript repeatableScript) {
        ScriptManager a = repeatableScript;
        ScriptManager a2 = this;
        return a2.f_bA.m_Rk(a.getProject(), a2.generateJobName((RepeatableScript)a), () -> a2.lambda$createPeriodicScriptJob$7((RepeatableScript)a), Duration.ofMillis(a.getPeriod().intValue()), a.getOffset());
    }

    /*
     * WARNING - void declaration
     */
    public ScriptManager(c_wc c_wc2, c_OA c_OA2, c_vb c_vb2, c_lA c_lA2, JedisPooled jedisPooled, c_B c_B2, c_ZK c_ZK2) {
        ScriptManager a;
        void a2;
        void a3;
        void a4;
        void a5;
        void a6;
        void a7;
        ScriptManager a8;
        ScriptManager scriptManager = scriptManager2;
        ScriptManager scriptManager2 = c_ZK2;
        ScriptManager scriptManager3 = a8 = scriptManager;
        ScriptManager scriptManager4 = a8;
        ScriptManager scriptManager5 = a8;
        ScriptManager scriptManager6 = a8;
        ScriptManager scriptManager7 = a8;
        scriptManager6.f_zB = new ReentrantLock();
        scriptManager6.f_VA = new ConcurrentHashMap();
        scriptManager6.f_jA = a7;
        scriptManager5.f_bA = a6;
        scriptManager5.f_eb = a5;
        scriptManager4.f_dc = a4;
        scriptManager4.f_Gb = a3;
        scriptManager3.f_ub = a2;
        scriptManager3.f_hC = a;
    }

    @PreAuthorize(value="hasAuthority('VIEW_SCRIPT')")
    public c_db getScriptStatus(String string) {
        Object a = string;
        ScriptManager a2 = this;
        if (a2.f_ub.m_fa()) {
            f_qB.debug(c_FB.m_lQ((Object)"JhGiC\u007f<\rAHrYoCa\ruNtDvY&^rLrXu\r`Bt\r}P&AiNgAjT("), a);
            return a2.getScriptStatusInternal((String)a);
        }
        f_qB.debug(ProcedureMetadata.m_Sq((Object)"Y}Y\u001f[wVvR`-\u0012EWfGrAc[yU7^rSsWe\u0012q]e\u0012dQe[gF7AcScGd\u0012q]e\u0012lO9"), a);
        try {
            Object[] objectArray = new Object[3 >> 1];
            objectArray[3 ^ 3] = a;
            return (c_db)a2.f_ub.m_ga(Short.valueOf((short)(0x31EF & 0x4F3F)), objectArray);
        }
        catch (Exception exception) {
            throw new ClusterRpcException("Failed to RPC get script status for " + (String)a, (Throwable)exception);
        }
    }

    @PreAuthorize(value="hasAuthority('VIEW_SCRIPT')")
    public Map<String, c_db> getScriptStatuses(String string) {
        Object a = string;
        ScriptManager a2 = this;
        if (a2.f_ub.m_fa()) {
            f_qB.debug(ProcedureMetadata.m_Sq((Object)"[wVvR`-\u0012PWcF~\\p\u0012v^{\u0012dQe[gF7AcScGdWd\u0012q]e\u0012g@xXrQc\u0012lO7^xQv^{K9"), a);
            return a2.getScriptStatusesByProjectIdInternal((String)a);
        }
        f_qB.debug(c_FB.m_lQ((Object)"HbH\u0000JhGiC\u007f<\rTHwXc^rDhJ&AcLbHt\r`Bt\rgAj\ruNtDvY&^rLrXuHu\r`Bt\rv_iGcNr\r}P("), a);
        try {
            Object[] objectArray = new Object[--1];
            objectArray[5 >> 3] = a;
            return (Map)a2.f_ub.m_ga(Short.valueOf((short)(0x39BF & 0x4773)), objectArray);
        }
        catch (Exception exception) {
            throw new ClusterRpcException("Failed to RPC get statuses for project" + (String)a, (Throwable)exception);
        }
    }

    public void deactivateForProject(String string) {
        Object a = string;
        ScriptManager a2 = this;
        if (a2.f_ub.m_fa()) {
            f_qB.info(c_FB.m_lQ((Object)"aClBhT\u0017&egCbAoCa\rV_iGcNricLeYo[gYchpHhY&Ki_&]tBlHeY&dB\u0017&V{"), a);
            a2.cancelScriptsByProjectIdInternal((String)a);
            return;
        }
        f_qB.debug(ProcedureMetadata.m_Sq((Object)"|X|:~RsSwE\b7{p\\x@~\\p\u0012G@xXrQcvrStF~DvFrwaWyF7Tx@7Be]}WtF7{S\b7Ij"), a);
    }

    protected void scheduleScriptInternal(RepeatableScript repeatableScript) {
        ScriptManager a = repeatableScript;
        ScriptManager a2 = this;
        a2.f_hC.m_pCa(() -> a2.lambda$scheduleScriptInternal$4((RepeatableScript)a), (OwnedSpaceBaseModel)a);
    }

    @PreAuthorize(value="hasAuthority('CANCEL_SCRIPT')")
    public void cancelScripts(String string) {
        Object a = string;
        ScriptManager a2 = this;
        if (a2.f_ub.m_fa()) {
            f_qB.debug(c_FB.m_lQ((Object)"aClBhT\u0017&ngCeHjAoCa\rgAj\ruNtDvYu\r`Bt\rv_iGcNr\r}P&AiNgAjT("), a);
            a2.cancelScriptsByProjectIdInternal((String)a);
            return;
        }
        f_qB.debug(ProcedureMetadata.m_Sq((Object)"Y}Y\u001f[wVvR`-\u0012EWfGrAc[yU7^rSsWe\u0012c]7Qv\\tW{\u0012v^{\u0012dQe[gFd\u0012q]e\u0012g@xXrQc\u0012lO9"), a);
        try {
            Object[] objectArray = new Object[3 & 5];
            objectArray[3 & 4] = a;
            a2.f_ub.m_ga(Short.valueOf((short)(0x597F & 0x27B1)), objectArray);
            return;
        }
        catch (Exception exception) {
            throw new ClusterRpcException("Failed to RPC cancel scripts for project " + (String)a, (Throwable)exception);
        }
    }

    @PreAuthorize(value="hasAuthority('SCHEDULE_SCRIPT')")
    public void scheduleScript(String string) {
        Object a = string;
        ScriptManager a2 = this;
        if (a2.f_ub.m_fa()) {
            f_qB.debug(ProcedureMetadata.m_Sq((Object)"[wVvR`-\u0012DQ\u007fWsG{[yU7At@~Bc\u0012lO7^xQv^{K9"), a);
            a2.scheduleScriptInternal((String)a);
            return;
        }
        f_qB.debug(c_FB.m_lQ((Object)"cIc+aClBhT\u0017&\u007fc\\sHuYoCa\rjHgIc_&Yi\ruNnHbXjH&^e_o]r\r}P("), a);
        try {
            Object[] objectArray = new Object[5 >> 2];
            objectArray[2 & 5] = a;
            a2.f_ub.m_ga(Short.valueOf((short)(0x3FFF & 0x412D)), objectArray);
            return;
        }
        catch (Exception exception) {
            throw new ClusterRpcException("Failed to RPC schedule script " + (String)a, (Throwable)exception);
        }
    }

    /*
     * WARNING - void declaration
     */
    @PreAuthorize(value="hasAuthority('VIEW_SCRIPT')")
    public c_db getScriptStatus(String string, String string2) {
        void a;
        Object a2 = string;
        ScriptManager a3 = this;
        if ((a2 = a3.f_jA.m_mE((String)a2, (String)a)) == null) {
            return c_db.f_wA;
        }
        return a3.getScriptStatus(a2.getId());
    }
}

