/*
 * Decompiled with CFR 0.152.
 */
package com.inscada.mono.report.model;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.inscada.mono.project.model.Project;
import com.inscada.mono.report.e.c_Rd;
import com.inscada.mono.report.model.ReportGroup;
import com.inscada.mono.shared.model.OwnedSpaceBaseModel;
import com.inscada.mono.shared.validations.CheckAtLeastOneNotNull;
import jakarta.persistence.AttributeOverride;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.OneToMany;
import jakarta.persistence.Table;
import jakarta.persistence.Temporal;
import jakarta.persistence.TemporalType;
import jakarta.validation.constraints.Max;
import jakarta.validation.constraints.Min;
import jakarta.validation.constraints.NotBlank;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Size;
import java.util.Date;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import org.hibernate.annotations.SQLRestriction;

@Entity
@Table(name="report")
@AttributeOverride(name="id", column=@Column(name="report_id", length=36, nullable=false, updatable=false))
@CheckAtLeastOneNotNull(fieldNames={"projectId", "project"})
public class Report
extends OwnedSpaceBaseModel {
    @JsonFormat(shape=JsonFormat.Shape.STRING, pattern="HH:mm:ss")
    @Temporal(value=TemporalType.TIME)
    @Column(name="report_time")
    private Date reportTime;
    @JsonFormat(shape=JsonFormat.Shape.STRING, pattern="HH:mm:ss")
    @Temporal(value=TemporalType.TIME)
    @Column(name="mail_time")
    private Date mailTime;
    @Min(value=1L)
    @Max(value=31L)
    @Column(name="report_day")
    private Short reportDay;
    @Min(value=1L)
    @Max(value=31L)
    @Column(name="mail_day")
    private Short mailDay;
    @NotNull
    @Column(name="logo_flag")
    private Boolean logoFlag;
    @JsonIgnore
    @OneToMany(mappedBy="report")
    @SQLRestriction(value="deleted_dttm IS NULL")
    private Set<ReportGroup> reportGroups;
    @Min(value=1L)
    @Column(name="minutes")
    private Integer minutes;
    @NotBlank
    @Size(max=100)
    private String name;
    @Size(max=50)
    private String no;
    @NotNull
    @Column(name="mail_flag")
    private Boolean mailFlag;
    @Size(max=255)
    private String dsc;
    @NotNull
    @Column(name="print_flag")
    private Boolean printFlag;
    @Min(value=1L)
    @Max(value=31L)
    @Column(name="print_day")
    private Short printDay;
    @NotNull
    private c_Rd period;
    @JsonFormat(shape=JsonFormat.Shape.STRING, pattern="HH:mm:ss")
    @Temporal(value=TemporalType.TIME)
    @Column(name="print_time")
    private Date printTime;
    private String lang;
    @JsonIgnore
    @ManyToOne(optional=false)
    @SQLRestriction(value="deleted_dttm IS NULL")
    @JoinColumn(name="project_id", updatable=false)
    private Project project;
    @Column(name="mail_to")
    private String mailTo;
    @Column(name="project_id", insertable=false, updatable=false)
    private String projectId;

    public void setLang(String string) {
        Object a = string;
        Report a2 = this;
        a2.lang = a;
    }

    public Set<ReportGroup> getReportGroups() {
        Report a;
        return a.reportGroups;
    }

    public Boolean getPrintFlag() {
        Report a;
        return a.printFlag;
    }

    public Short getMailDay() {
        Report a;
        return a.mailDay;
    }

    public String getProjectId() {
        Report a;
        return a.projectId;
    }

    public void setPrintDay(Short s) {
        Object a = s;
        Report a2 = this;
        a2.printDay = a;
    }

    public Boolean getMailFlag() {
        Report a;
        return a.mailFlag;
    }

    public void setPrintTime(Date date) {
        Object a = date;
        Report a2 = this;
        a2.printTime = a;
    }

    public String getMailTo() {
        Report a;
        return a.mailTo;
    }

    public String getNo() {
        Report a;
        return a.no;
    }

    public Date getReportTime() {
        Report a;
        return a.reportTime;
    }

    public void setMailTime(Date date) {
        Object a = date;
        Report a2 = this;
        a2.mailTime = a;
    }

    public void setReportTime(Date date) {
        Object a = date;
        Report a2 = this;
        a2.reportTime = a;
    }

    public int hashCode() {
        Report a;
        Object[] objectArray = new Object[--3];
        objectArray[3 >> 2] = super.hashCode();
        objectArray[5 >> 2] = a.getProjectId();
        objectArray[1 ^ 3] = a.getName();
        return Objects.hash(objectArray);
    }

    public Date getPrintTime() {
        Report a;
        return a.printTime;
    }

    public void setMinutes(Integer n) {
        Object a = n;
        Report a2 = this;
        a2.minutes = a;
    }

    public void setNo(String string) {
        Object a = string;
        Report a2 = this;
        a2.no = a;
    }

    public String getDsc() {
        Report a;
        return a.dsc;
    }

    public String getName() {
        Report a;
        return a.name;
    }

    public Report() {
        Report a;
        Report report = a;
        report.reportGroups = new HashSet();
    }

    public Integer getMinutes() {
        Report a;
        return a.minutes;
    }

    public Short getPrintDay() {
        Report a;
        return a.printDay;
    }

    public void setMailDay(Short s) {
        Object a = s;
        Report a2 = this;
        a2.mailDay = a;
    }

    public Short getReportDay() {
        Report a;
        return a.reportDay;
    }

    public void setProject(Project project) {
        Report a;
        Report a2 = project;
        Report report = a = this;
        report.project = a2;
        report.projectId = a2 != null && a2.getId() != null ? a2.getId() : null;
    }

    public Project getProject() {
        Report a;
        return a.project;
    }

    public void setPrintFlag(Boolean bl) {
        Object a = bl;
        Report a2 = this;
        a2.printFlag = a;
    }

    public void setMailTo(String string) {
        Object a = string;
        Report a2 = this;
        a2.mailTo = a;
    }

    public void setDsc(String string) {
        Object a = string;
        Report a2 = this;
        a2.dsc = a;
    }

    public void setPeriod(c_Rd c_Rd2) {
        Report a = c_Rd2;
        Report a2 = this;
        a2.period = a;
    }

    public void setMailFlag(Boolean bl) {
        Object a = bl;
        Report a2 = this;
        a2.mailFlag = a;
    }

    public boolean equals(Object object) {
        Report a = this;
        Object a2 = object;
        if (a == a2) {
            return (4 ^ 5) != 0;
        }
        if (!(a2 instanceof Report)) {
            return false;
        }
        Object object2 = a2;
        if (!super.equals(a2)) {
            return 3 >> 2;
        }
        if (a.getProjectId().equals(object2.getProjectId()) && a.getName().equals(object2.getName())) {
            return 5 >> 2;
        }
        return false;
    }

    public void setReportDay(Short s) {
        Object a = s;
        Report a2 = this;
        a2.reportDay = a;
    }

    public void setLogoFlag(Boolean bl) {
        Object a = bl;
        Report a2 = this;
        a2.logoFlag = a;
    }

    public Date getMailTime() {
        Report a;
        return a.mailTime;
    }

    public String getLang() {
        Report a;
        return a.lang;
    }

    public void setReportGroups(Set<ReportGroup> set) {
        Object a = set;
        Report a2 = this;
        a2.reportGroups = a;
    }

    public void setName(String string) {
        Object a = string;
        Report a2 = this;
        a2.name = a;
    }

    public Boolean getLogoFlag() {
        Report a;
        return a.logoFlag;
    }

    public void setProjectId(String string) {
        Object a = string;
        Report a2 = this;
        a2.projectId = a;
    }

    public c_Rd getPeriod() {
        Report a;
        return a.period;
    }
}

