/*
 * Decompiled with CFR 0.152.
 */
package com.inscada.mono.report.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.inscada.mono.filesystem.model.FileInfo;
import com.inscada.mono.project.model.Project;
import com.inscada.mono.shared.model.SpaceBaseModel;
import com.inscada.mono.shared.validations.CheckAtLeastOneNotNull;
import com.inscada.mono.shared.validations.CheckAtLeastOneNotNull$List;
import jakarta.persistence.AttributeOverride;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.OneToOne;
import jakarta.persistence.Table;
import jakarta.validation.constraints.NotBlank;
import jakarta.validation.constraints.Size;
import java.util.Objects;
import org.hibernate.annotations.SQLRestriction;

@Entity
@Table(name="jasper_report")
@AttributeOverride(name="id", column=@Column(name="jasper_report_id", length=36, nullable=false, updatable=false))
@CheckAtLeastOneNotNull$List(value={@CheckAtLeastOneNotNull(fieldNames={"projectId", "project"}), @CheckAtLeastOneNotNull(fieldNames={"templateFileId", "templateFile"})})
public class JasperReport
extends SpaceBaseModel {
    @Column(name="project_id", insertable=false, updatable=false)
    private String projectId;
    @Column(name="template_file_id", updatable=false, insertable=false)
    private String templateFileId;
    @JsonIgnore
    @ManyToOne(optional=false)
    @SQLRestriction(value="deleted_dttm IS NULL")
    @JoinColumn(name="project_id", updatable=false)
    private Project project;
    @NotBlank
    @Size(max=100)
    private String name;
    @JsonIgnore
    @OneToOne(optional=false)
    @JoinColumn(name="template_file_id")
    @SQLRestriction(value="deleted_dttm IS NULL")
    private FileInfo templateFile;
    private String subreports;
    private String parameters;
    @Size(max=255)
    private String dsc;
    private String datasource;

    public int hashCode() {
        JasperReport a;
        Object[] objectArray = new Object[--3];
        objectArray[3 ^ 3] = super.hashCode();
        objectArray[4 ^ 5] = a.getProjectId();
        objectArray[--2] = a.getName();
        return Objects.hash(objectArray);
    }

    public void setParameters(String string) {
        Object a = string;
        JasperReport a2 = this;
        a2.parameters = a;
    }

    public boolean equals(Object object) {
        JasperReport a = this;
        Object a2 = object;
        if (a == a2) {
            return --1 != 0;
        }
        if (!(a2 instanceof JasperReport)) {
            return false;
        }
        Object object2 = a2;
        if (!super.equals(a2)) {
            return (3 ^ 3) != 0;
        }
        if (a.getProjectId().equals(object2.getProjectId()) && a.getName().equals(object2.getName())) {
            return (4 ^ 5) != 0;
        }
        return false;
    }

    public String getDsc() {
        JasperReport a;
        return a.dsc;
    }

    public void setSubreports(String string) {
        Object a = string;
        JasperReport a2 = this;
        a2.subreports = a;
    }

    public void setDatasource(String string) {
        Object a = string;
        JasperReport a2 = this;
        a2.datasource = a;
    }

    public String getTemplateFileId() {
        JasperReport a;
        return a.templateFileId;
    }

    public void setName(String string) {
        Object a = string;
        JasperReport a2 = this;
        a2.name = a;
    }

    public String getDatasource() {
        JasperReport a;
        return a.datasource;
    }

    public FileInfo getTemplateFile() {
        JasperReport a;
        return a.templateFile;
    }

    public String getName() {
        JasperReport a;
        return a.name;
    }

    public void setDsc(String string) {
        Object a = string;
        JasperReport a2 = this;
        a2.dsc = a;
    }

    public void setTemplateFile(FileInfo fileInfo) {
        JasperReport a = fileInfo;
        JasperReport a2 = this;
        a2.templateFile = a;
    }

    public String getProjectId() {
        JasperReport a;
        return a.projectId;
    }

    public void setProjectId(String string) {
        Object a = string;
        JasperReport a2 = this;
        a2.projectId = a;
    }

    public String getSubreports() {
        JasperReport a;
        return a.subreports;
    }

    public Project getProject() {
        JasperReport a;
        return a.project;
    }

    public String getParameters() {
        JasperReport a;
        return a.parameters;
    }

    public void setProject(Project project) {
        JasperReport a;
        JasperReport a2 = project;
        JasperReport jasperReport = a = this;
        jasperReport.project = a2;
        jasperReport.projectId = a2 != null && a2.getId() != null ? a2.getId() : null;
    }

    public void setTemplateFileId(String string) {
        Object a = string;
        JasperReport a2 = this;
        a2.templateFileId = a;
    }

    public JasperReport() {
        JasperReport a;
    }
}

