/*
 * Decompiled with CFR 0.152.
 */
package com.inscada.mono.datatransfer.services;

import com.inscada.mono.auth.c_ZK;
import com.inscada.mono.cluster.exceptions.ClusterRpcException;
import com.inscada.mono.cluster.services.ClusterNodeListener;
import com.inscada.mono.cluster.services.c_B;
import com.inscada.mono.communication.base.e.c_Ni;
import com.inscada.mono.communication.base.e.c_Oh;
import com.inscada.mono.communication.base.model.Variable;
import com.inscada.mono.communication.base.model.values.NumberVariableValue;
import com.inscada.mono.communication.base.model.values.VariableValue;
import com.inscada.mono.communication.base.model.values.logged.LoggedVariableValueStats;
import com.inscada.mono.communication.base.services.c_FH;
import com.inscada.mono.communication.base.services.c_PH;
import com.inscada.mono.communication.base.services.c_aj;
import com.inscada.mono.datatransfer.e.c_td;
import com.inscada.mono.datatransfer.model.DataTransfer;
import com.inscada.mono.datatransfer.model.DataTransferDetail;
import com.inscada.mono.datatransfer.model.DataTransferSummary;
import com.inscada.mono.datatransfer.services.c_Mb;
import com.inscada.mono.datatransfer.services.c_PC;
import com.inscada.mono.datatransfer.x.c_Dc;
import com.inscada.mono.datatransfer.x.c_dA;
import com.inscada.mono.impexp.e.c_ib;
import com.inscada.mono.job.e.c_OA;
import com.inscada.mono.job.model.Job;
import com.inscada.mono.job.model.PeriodicJob;
import com.inscada.mono.log.services.c_lA;
import com.inscada.mono.project.x.c_I;
import com.inscada.mono.report.model.ReportDataItem;
import com.inscada.mono.shared.exceptions.NotActiveException;
import com.inscada.mono.shared.model.BaseModel;
import com.inscada.mono.shared.model.OwnedSpaceBaseModel;
import jakarta.annotation.PostConstruct;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Component;
import org.springframework.transaction.event.TransactionalEventListener;
import redis.clients.jedis.JedisPooled;

@Component
public class DataTransferManager
implements ClusterNodeListener,
c_I {
    private final c_aj f_OH;
    public static final short f_Ug = 406;
    public static final short f_zI = 405;
    private final c_PH f_Ei;
    private static final Logger f_wh = LoggerFactory.getLogger(DataTransferManager.class);
    private final c_OA f_PG;
    private static final String f_kI = "scheduledDataTransfers";
    public static final short f_bG = 401;
    private final c_FH f_dj;
    private final JedisPooled f_ug;
    private final c_ZK f_lG;
    private final c_B f_Ti;
    private final Lock f_mh;
    private final Map<String, Job> f_AI;
    public static final short f_wg = 407;
    public static final short f_bj = 404;
    private final c_lA f_fh;
    public static final short f_tG = 403;
    private final c_Mb f_mG;
    public static final short f_VG = 402;

    public void deactivateForProject(String string) {
        Object a = string;
        DataTransferManager a2 = this;
        if (a2.f_Ti.m_fa()) {
            f_wh.info(ReportDataItem.m_hi((Object)" )-()>VL$\r\u0002\b\u0000\u0005\u0002\u000bL<\u001e\u0003\u0006\t\u000f\u0018(\t\r\u000f\u0018\u0005\u001a\r\u0018\t)\u001a\t\u0002\u0018L\n\u0003\u001eL\u001c\u001e\u0003\u0006\t\u000f\u0018L%(VL\u0017\u0011"), a);
            a2.cancelDataTransfersByProjectIdInternal((String)a);
            return;
        }
        f_wh.debug(c_ib.m_Hj((Object)"\u0019\u0011\u0019s\u001b\u001b\u0016\u001a\u0012\fm~\u001e991%799w\u000e%1=;4*\u0013;6=#7!?#;\u0012(20#~11%~',842=#~\u001e\u001am~,#"), a);
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void lambda$handleStatValues$17(Date date, Map map, Map map2, Map map3, Date date2, List list) {
        void a;
        void a2;
        void a3;
        Map a4;
        void a5;
        List a6;
        DataTransferManager dataTransferManager = list2;
        List list2 = list;
        DataTransferManager a7 = dataTransferManager;
        String[] stringArray = (String[])a6.stream().map(DataTransferDetail::getSourceVariableId).distinct().toArray(String[]::new);
        c_Ni[] c_NiArray = (c_Ni[])a6.stream().map(DataTransferDetail::getCalcType).distinct().toArray(c_Ni[]::new);
        a4 = a7.f_Ei.m_Uca(stringArray, (Date)a5, (Date)((Object)a4), c_NiArray).stream().collect(Collectors.toMap(LoggedVariableValueStats::getVariableId, Function.identity()));
        a6.forEach(arg_0 -> a7.lambda$handleStatValues$16(a4, (Map)a3, (Map)a2, (Map)a, arg_0));
    }

    /*
     * Enabled aggressive block sorting
     */
    private /* synthetic */ int getMaxTTLForRangeType(c_Oh c_Oh2) {
        DataTransferManager a = c_Oh2;
        DataTransferManager a2 = this;
        switch (c_PC.f_wH[a.ordinal()]) {
            case 1: 
            case 2: {
                return 3600;
            }
            case 3: 
            case 4: {
                return 86400;
            }
            case 5: 
            case 6: {
                return 604800;
            }
            case 7: 
            case 8: {
                return 2678400;
            }
            case 9: 
            case 10: {
                return 31622400;
            }
        }
        throw new IllegalArgumentException("Unexpected range type: " + String.valueOf(a));
    }

    protected c_td getDataTransferStatusInternal(String string) {
        Object a = string;
        DataTransferManager a2 = this;
        if (a2.f_AI.containsKey(a)) {
            return c_td.f_Ph;
        }
        return c_td.f_Cj;
    }

    protected void cancelDataTransfersByProjectIdInternal(String string) {
        Object a = string;
        DataTransferManager a2 = this;
        if ((a = a2.f_mG.m_cO((String)a)) == null || a.isEmpty()) {
            return;
        }
        a.forEach(arg_0 -> a2.cancelDataTransferInternal(arg_0));
    }

    protected void cancelDataTransferInternal(DataTransfer dataTransfer) {
        DataTransferManager a = dataTransfer;
        DataTransferManager a2 = this;
        a2.f_lG.m_pCa(() -> a2.lambda$cancelDataTransferInternal$6((DataTransfer)a), (OwnedSpaceBaseModel)a);
    }

    /*
     * WARNING - void declaration
     */
    public DataTransferManager(c_Mb c_Mb2, c_aj c_aj2, c_FH c_FH2, c_PH c_PH2, c_OA c_OA2, JedisPooled jedisPooled, c_lA c_lA2, c_B c_B2, c_ZK c_ZK2) {
        DataTransferManager a;
        void a2;
        void a3;
        void a4;
        void a5;
        void a6;
        void a7;
        void a8;
        void a9;
        DataTransferManager a10;
        DataTransferManager dataTransferManager = dataTransferManager2;
        DataTransferManager dataTransferManager2 = c_ZK2;
        DataTransferManager dataTransferManager3 = a10 = dataTransferManager;
        DataTransferManager dataTransferManager4 = a10;
        DataTransferManager dataTransferManager5 = a10;
        DataTransferManager dataTransferManager6 = a10;
        DataTransferManager dataTransferManager7 = a10;
        DataTransferManager dataTransferManager8 = a10;
        dataTransferManager7.f_mh = new ReentrantLock();
        dataTransferManager7.f_AI = new ConcurrentHashMap();
        dataTransferManager7.f_mG = a9;
        dataTransferManager6.f_OH = a8;
        dataTransferManager6.f_dj = a7;
        dataTransferManager5.f_Ei = a6;
        dataTransferManager5.f_PG = a5;
        dataTransferManager4.f_fh = a4;
        dataTransferManager4.f_ug = a3;
        dataTransferManager3.f_Ti = a2;
        dataTransferManager3.f_lG = a;
    }

    /*
     * WARNING - void declaration
     */
    @PreAuthorize(value="hasAuthority('SCHEDULE_DATA_TRANSFER')")
    public void scheduleDataTransfer(String string, String string2) {
        void a;
        DataTransferManager a2;
        Object a3 = string2;
        DataTransferManager dataTransferManager = a2 = this;
        dataTransferManager.scheduleDataTransfer(dataTransferManager.f_mG.m_SO((String)a, (String)a3).getId());
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void handleCurrentValues(List<DataTransferDetail> list, Map<String, Map<String, Object>> map) {
        void a;
        void a2;
        DataTransferManager dataTransferManager = this;
        Object object = (String[])a2.stream().map(DataTransferDetail::getSourceVariableId).toArray(String[]::new);
        Object a3 = a2.stream().map(DataTransferDetail::getTargetVariableId).collect(Collectors.toList());
        Map map2 = dataTransferManager.f_OH.m_taa((List)a3).stream().collect(Collectors.toMap(BaseModel::getId, Function.identity()));
        DataTransferManager dataTransferManager2 = dataTransferManager;
        object = dataTransferManager2.f_dj.m_CX(object);
        a3 = dataTransferManager2.f_dj.m_CX((String[])a3.toArray(String[]::new));
        a2.forEach(arg_0 -> dataTransferManager.lambda$handleCurrentValues$10((Map)object, (Map)a3, map2, (Map)a, arg_0));
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ boolean lambda$handleStatValues$12(Date date, Map map, Map map2, Map map3, DataTransferDetail dataTransferDetail) {
        void a;
        void a2;
        DataTransferManager dataTransferManager;
        DataTransferManager dataTransferManager2 = dataTransferManager = this;
        Object a3 = dataTransferManager2.buildStatCacheKey((DataTransferDetail)a2);
        if (!dataTransferManager2.shouldRecalculateStats((DataTransferDetail)a2, (Date)a, (String)(a3 = dataTransferManager2.f_ug.get((String)a3)))) {
            void a4;
            void a5;
            void a6;
            dataTransferManager.updateVariableWithCachedValue((String)a3, (DataTransferDetail)a2, (Map)a6, (Map)a5, (Map)a4);
            return (2 & 5) != 0;
        }
        return true;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    private /* synthetic */ double extractValue(LoggedVariableValueStats loggedVariableValueStats, c_Ni c_Ni2) {
        void a;
        DataTransferManager a2 = loggedVariableValueStats;
        DataTransferManager a3 = this;
        switch (c_PC.f_uH[a.ordinal()]) {
            case 1: {
                return a2.getMinValue();
            }
            case 2: {
                return a2.getMaxValue();
            }
            case 3: {
                return a2.getAvgValue();
            }
            case 4: {
                return a2.getSumValue();
            }
            case 5: {
                return a2.getCountValue();
            }
            case 6: {
                return a2.getFirstValue();
            }
            case 7: {
                return a2.getLastValue();
            }
            case 8: {
                return a2.getMaxDiffValue();
            }
            case 9: {
                return a2.getLastFirstDiffValue();
            }
            case 10: {
                return a2.getMiddleValue();
            }
            case 11: {
                return a2.getMedianValue();
            }
        }
        throw new IllegalArgumentException("Unexpected calculation type: " + String.valueOf(a));
    }

    protected Map<String, c_td> getDataTransferStatusesByProjectIdInternal(String string) {
        Object a = string;
        DataTransferManager a2 = this;
        if ((a = a2.f_mG.m_XN((String)a)) == null || a.isEmpty()) {
            return Collections.emptyMap();
        }
        return a.stream().collect(Collectors.toMap(DataTransferSummary::getId, dataTransferSummary -> {
            DataTransferManager a = dataTransferSummary;
            DataTransferManager a2 = this;
            return a2.getDataTransferStatusInternal(a.getId());
        }));
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void transfer(DataTransfer dataTransfer) {
        void a;
        DataTransferManager dataTransferManager = this;
        if (a.getDataTransferDetails() == null || a.getDataTransferDetails().isEmpty()) {
            return;
        }
        ArrayList arrayList = new ArrayList();
        ArrayList arrayList2 = new ArrayList();
        a.getDataTransferDetails().forEach(dataTransferDetail -> {
            void a;
            List a2 = dataTransferDetail;
            List a3 = arrayList2;
            if (a2.getCalcType() != null && a2.getRangeType() != null) {
                a3.add(a2);
                return;
            }
            a.add(a2);
        });
        HashMap a2 = new HashMap();
        if (!arrayList.isEmpty()) {
            dataTransferManager.handleCurrentValues(arrayList, (Map)a2);
        }
        if (!arrayList2.isEmpty()) {
            dataTransferManager.handleStatValues(arrayList2, (Map)a2);
        }
        if (!a2.isEmpty()) {
            dataTransferManager.f_dj.m_Fy(a.getProjectId(), (Map)a2);
        }
    }

    /*
     * WARNING - void declaration
     */
    @TransactionalEventListener(value={c_Dc.class})
    public void handleCancelEvent(c_Dc c_Dc2) {
        void a;
        DataTransferManager dataTransferManager = this;
        if (dataTransferManager.f_Ti.m_fa()) {
            DataTransferManager a2 = a.m_oM();
            f_wh.info(ReportDataItem.m_hi((Object)" )-()>VL$\r\u0002\b\u0000\u0005\u0002\u000bL/\r\u0002\u000f\t\u0000)\u001a\t\u0002\u0018L\n\u0003\u001eL\b\r\u0018\rL\u0018\u001e\r\u0002\u001f\n\t\u001eVL\u0017\u0011LD%(VL\u0017\u0011E"), (Object)a2.getName(), (Object)a2.getId());
            dataTransferManager.cancelDataTransferInternal((DataTransfer)a2);
            return;
        }
        f_wh.debug(c_ib.m_Hj((Object)"\u0019\u0011\u0019s\u001b\u001b\u0016\u001a\u0012\fm~\u001e991%799w\u001d604;;\u001b!;9*w88,w:6*6~#,60$82,m~,#"), (Object)a.m_oM().getId());
    }

    @PreAuthorize(value="hasAuthority('VIEW_DATA_TRANSFER')")
    public c_td getDataTransferStatus(String string) {
        Object a = string;
        DataTransferManager a2 = this;
        if (a2.f_Ti.m_fa()) {
            f_wh.debug(c_ib.m_Hj((Object)"\u001b\u001b\u0016\u001a\u0012\fm~\u0010;#*>00~3?#?w*%?9-1;%~$*6*\"-w88,w\u0017\u0013dw%*~;14?;2.p"), a);
            return a2.getDataTransferStatusInternal((String)a);
        }
        f_wh.debug(ReportDataItem.m_hi((Object)"\"#\"A )-()>VL>\t\u001d\u0019\t\u001f\u0018\u0005\u0002\u000bL\u0000\t\r\b\t\u001eL\n\u0003\u001eL\b\r\u0018\rL\u0018\u001e\r\u0002\u001f\n\t\u001eL\u001f\u0018\r\u0018\u0019\u001fL\n\u0003\u001eL%(VL\u0017\u0011B"), a);
        try {
            Object[] objectArray = new Object[5 >> 2];
            objectArray[3 & 4] = a;
            return (c_td)a2.f_Ti.m_ga(Short.valueOf((short)(0x65FB & 0x1B97)), objectArray);
        }
        catch (Exception exception) {
            throw new ClusterRpcException("Failed to RPC get data transfer status for " + (String)a, (Throwable)exception);
        }
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void lambda$handleCurrentValues$10(Map map, Map map2, Map map3, Map map4, DataTransferDetail dataTransferDetail) {
        Variable a;
        void a2;
        VariableValue a3;
        Object a4 = map2;
        DataTransferManager a5 = this;
        a3 = (VariableValue)a3.get(a2.getSourceVariableId());
        a4 = (VariableValue)a4.get(a2.getTargetVariableId());
        a = (Variable)a.get(a2.getTargetVariableId());
        if (a3 != null && a != null && a5.isValueInThresholdRange(a2.getThreshold(), a3, (VariableValue)a4)) {
            void a6;
            a4 = new HashMap<String, Object>();
            a4.put(ReportDataItem.m_hi((Object)"\u001a\r\u0000\u0019\t"), a3.getValue());
            a6.put(a.getName(), a4);
        }
    }

    public void notLeader() {
        DataTransferManager dataTransferManager;
        DataTransferManager dataTransferManager2 = dataTransferManager = this;
        Object a = dataTransferManager2.f_Ti.m_ja().getNodeId();
        f_wh.info(ReportDataItem.m_hi((Object)"(\r\u0018\r8\u001e\r\u0002\u001f\n\t\u001e!\r\u0002\r\u000b\t\u001eVL8\u0004\u0005\u001fL\u0002\u0003\b\tLD\u0017\u0011EL\u0005\u001fL\"#L #\"+)>L8$)L )-()>BL/\r\u0002\u000f\t\u0000\u0000\u0005\u0002\u000bL\r\u0000\u0000L\u0000\u0003\u000f\r\u0000L\b\r\u0018\rL\u0018\u001e\r\u0002\u001f\n\t\u001eL\u0006\u0003\u000e\u001fBBB"), a);
        dataTransferManager2.f_mh.lock();
        try {
            new ArrayList(dataTransferManager.f_AI.keySet()).forEach(arg_0 -> dataTransferManager.lambda$notLeader$2((String)a, arg_0));
            dataTransferManager.f_AI.clear();
            f_wh.info(c_ib.m_Hj((Object)"\u0013?#?\u0003,60$82,\u001a?9?0;%~\u007f\u00108*w\u00122?3;%~,#~dw\u001f;2w28=62w:6*6~#,60$82,w48<$~??!;w<2;9~%;&+2-#;3~#1w=604;;~603~422?%;3~1,83w28=62w*%?45>00p"), a);
            return;
        }
        catch (Exception exception) {
            Object[] objectArray = new Object[--3];
            objectArray[5 >> 3] = a;
            objectArray[3 >> 1] = exception.getMessage();
            objectArray[5 >> 1] = exception;
            f_wh.error(ReportDataItem.m_hi((Object)"(\r\u0018\r8\u001e\r\u0002\u001f\n\t\u001e!\r\u0002\r\u000b\t\u001eLD\"\u0003\u0018L \t\r\b\t\u001eL\u0017\u0011EVL)\u001e\u001e\u0003\u001eL\b\u0019\u001e\u0005\u0002\u000bL\u001c\u001e\u0003\u000f\t\u001f\u001fL\u0003\nL\u000f\r\u0002\u000f\t\u0000\u0000\u0005\u0002\u000bL\u0000\u0003\u000f\r\u0000L\b\r\u0018\rL\u0018\u001e\r\u0002\u001f\n\t\u001eL\u0006\u0003\u000e\u001fVL\u0017\u0011"), objectArray);
            return;
        }
        finally {
            dataTransferManager.f_mh.unlock();
        }
    }

    private /* synthetic */ void lambda$cancelDataTransferInternal$6(DataTransfer dataTransfer) {
        DataTransferManager a = dataTransfer;
        DataTransferManager a2 = this;
        a2.f_mh.lock();
        try {
            Job job = (Job)a2.f_AI.get(a.getId());
            if (job != null) {
                a2.f_PG.m_jl(job);
            }
            DataTransferManager dataTransferManager = a2;
            dataTransferManager.f_AI.remove(a.getId());
            String[] stringArray = new String[--1];
            stringArray[3 & 4] = a.getId();
            dataTransferManager.f_ug.srem(f_kI, stringArray);
            return;
        }
        finally {
            a2.f_mh.unlock();
        }
    }

    private /* synthetic */ String buildStatCacheKey(DataTransferDetail dataTransferDetail) {
        DataTransferManager a = dataTransferDetail;
        DataTransferManager a2 = this;
        Object[] objectArray = new Object[--3];
        objectArray[2 & 5] = a.getSourceVariableId();
        objectArray[3 & 5] = a.getRangeType();
        objectArray[1 ^ 3] = a.getCalcType();
        return ReportDataItem.m_hi((Object)"\b\r\u0018\rA\u0018\u001e\r\u0002\u001f\n\t\u001eV\u001f\u0018\r\u0018\u001fV\u001a\r\u001e\u0005\r\u000e\u0000\tVI\u001fVI\u001fVI\u001f").formatted(objectArray);
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void updateVariableWithCachedValue(String string, DataTransferDetail dataTransferDetail, Map<String, Variable<?, ?, ?>> map, Map<String, Map<String, Object>> map2, Map<String, VariableValue<?>> map3) {
        void a;
        Variable a2;
        Object a3 = string;
        DataTransferManager a4 = this;
        if ((a2 = (Variable)a2.get(a.getTargetVariableId())) != null) {
            void a5;
            double d = Double.parseDouble((String)a3);
            a3 = (VariableValue)a5.get(a.getTargetVariableId());
            if (a4.isValueInThresholdRange(a.getThreshold(), Double.valueOf(d), (VariableValue)a3)) {
                void a6;
                a3 = new HashMap<String, Double>();
                a3.put(c_ib.m_Hj((Object)"(62\";"), d);
                a6.put(a2.getName(), a3);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void leader() {
        DataTransferManager dataTransferManager;
        DataTransferManager dataTransferManager2 = dataTransferManager = this;
        Object a = dataTransferManager2.f_Ti.m_ja().getNodeId();
        f_wh.info(c_ib.m_Hj((Object)"\u0013?#?\u0003,60$82,\u001a?9?0;%dw\n?7$~913;wv,#~~??$~5;41:;w*?;w\u0012\u0012\u001f\u0013\u001b\u0005pw\f2-#1%799w-462:\"22:w:6*6~#,60$82,$pyp"), a);
        dataTransferManager2.f_mh.lock();
        try {
            HashSet hashSet = new HashSet(dataTransferManager.f_ug.smembers(f_kI));
            if (hashSet.isEmpty()) {
                f_wh.info(ReportDataItem.m_hi((Object)"(\r\u0018\r8\u001e\r\u0002\u001f\n\t\u001e!\r\u0002\r\u000b\t\u001eLD \t\r\b\t\u001eL\u0017\u0011EVL\"\u0003L\u001f\u000f\u0004\t\b\u0019\u0000\t\bL\b\r\u0018\rL\u0018\u001e\r\u0002\u001f\n\t\u001e\u001fL\n\u0003\u0019\u0002\bL\u0005\u0002L>\t\b\u0005\u001fL\u0018\u0003L\u001e\t\u001f\u0018\u0003\u001e\tB"), a);
                return;
            }
            Object[] objectArray = new Object[--3];
            objectArray[5 >> 3] = a;
            objectArray[2 ^ 3] = hashSet.size();
            objectArray[1 ^ 3] = hashSet;
            f_wh.info(c_ib.m_Hj((Object)"\u001a6*6\n%?9-1;%\u001360692,wv\u001b;6:2,w%*wm~\u00111\"03~,#w-462:\"22:w:6*6~#,60$82,w\u0017\u0013-w79~\u0005;37$~#1w,2-#1%;m~,#"), objectArray);
            ArrayList arrayList = new ArrayList();
            String[] stringArray = new String[3 & 5];
            stringArray[2 & 5] = ReportDataItem.m_hi((Object)":%);3(-8-38>-\"?*)>");
            dataTransferManager.f_lG.m_fBa(() -> {
                void a;
                Object a2 = hashSet;
                DataTransferManager a3 = this;
                a.addAll(a3.f_mG.m_CM((Set)a2));
            }, stringArray);
            f_wh.info(c_ib.m_Hj((Object)"\u001a6*6\n%?9-1;%\u001360692,wv\u001b;6:2,w%*wm~\u0016*#;:.#799w*8~%;$*8,2~,#w:6*6~#,60$82,$p"), a, (Object)arrayList.size());
            arrayList.forEach(dataTransfer -> {
                void a;
                DataTransferManager dataTransferManager;
                DataTransferManager dataTransferManager2 = dataTransferManager = this;
                Object a2 = dataTransferManager2.f_Ti.m_ja().getNodeId();
                String[] stringArray = new String[--2];
                stringArray[3 & 4] = ReportDataItem.m_hi((Object)"?/$)(9 )3(-8-38>-\"?*)>");
                stringArray[2 ^ 3] = c_ib.m_Hj((Object)"\u0014\u001f\u0019\u001d\u0012\u0012\b\u001a\u0016\n\u0016\u0001\u0003\f\u0016\u0010\u0004\u0018\u0012\f");
                dataTransferManager2.f_lG.m_kDa(() -> dataTransferManager.lambda$restoreSingleDataTransferOnLeader$1((String)a2, (DataTransfer)a), a.getSpace(), stringArray);
            });
            f_wh.info(ReportDataItem.m_hi((Object)"(\r\u0018\r8\u001e\r\u0002\u001f\n\t\u001e!\r\u0002\r\u000b\t\u001eLD \t\r\b\t\u001eL\u0017\u0011EVL*\u0005\u0002\u0005\u001f\u0004\t\bL\b\r\u0018\rL\u0018\u001e\r\u0002\u001f\n\t\u001eL\u001e\t\u001f\u0018\u0003\u001e\r\u0018\u0005\u0003\u0002L\u001c\u001e\u0003\u000f\t\u001f\u001fB"), a);
            return;
        }
        catch (Exception exception) {
            Object[] objectArray = new Object[--3];
            objectArray[3 >> 2] = a;
            objectArray[5 >> 2] = exception.getMessage();
            objectArray[--2] = exception;
            f_wh.error(c_ib.m_Hj((Object)"\u001a6*6\n%?9-1;%\u001360692,wv\u001b;6:2,w%*wm~\u0012,%1%~3+%799w:6*6~#,60$82,w,2-#1%?#780w.%14;$-m~,#"), objectArray);
            return;
        }
        finally {
            dataTransferManager.f_mh.unlock();
        }
    }

    private /* synthetic */ String buildStatLastCalcTimeKey(DataTransferDetail dataTransferDetail) {
        DataTransferManager a = dataTransferDetail;
        DataTransferManager a2 = this;
        Object[] objectArray = new Object[--3];
        objectArray[3 ^ 3] = a.getSourceVariableId();
        objectArray[4 ^ 5] = a.getRangeType();
        objectArray[5 >> 1] = a.getCalcType();
        return c_ib.m_Hj((Object)"3?#?z*%?9-1;%d;?$*z=624s#7:;m(6,>?522dr-m{$dr-").formatted(objectArray);
    }

    private /* synthetic */ void registerRemoteCallsWithClusterNode() {
        DataTransferManager dataTransferManager = this;
        try {
            Class[] classArray = new Class[--1];
            classArray[3 ^ 3] = String.class;
            dataTransferManager.f_Ti.m_ma((short)(0x5BB7 & 0x25D9), (Object)dataTransferManager, DataTransferManager.class.getDeclaredMethod(c_ib.m_Hj((Object)"$=?;3+;;\u0013?#?\u0003,60$82,\u001e0#;%062"), classArray));
            Class[] classArray2 = new Class[--1];
            classArray2[3 >> 2] = String.class;
            dataTransferManager.f_Ti.m_ma((short)(0x3B92 & 0x45FF), (Object)dataTransferManager, DataTransferManager.class.getDeclaredMethod(ReportDataItem.m_hi((Object)"\u000f\r\u0002\u000f\t\u0000(\r\u0018\r8\u001e\r\u0002\u001f\n\t\u001e%\u0002\u0018\t\u001e\u0002\r\u0000"), classArray2));
            Class[] classArray3 = new Class[5 >> 2];
            classArray3[5 >> 3] = String.class;
            dataTransferManager.f_Ti.m_ma((short)(0x27B7 & 0x59DB), (Object)dataTransferManager, DataTransferManager.class.getDeclaredMethod(c_ib.m_Hj((Object)"92*\u0013?#?\u0003,60$82,\u0004*6*\"-\u001e0#;%062"), classArray3));
            Class[] classArray4 = new Class[4 ^ 5];
            classArray4[3 ^ 3] = String.class;
            dataTransferManager.f_Ti.m_ma((short)(0x75B5 & 0xBDE), (Object)dataTransferManager, DataTransferManager.class.getDeclaredMethod(ReportDataItem.m_hi((Object)"\u001f\u000f\u0004\t\b\u0019\u0000\t(\r\u0018\r8\u001e\r\u0002\u001f\n\t\u001e\u001f.\u0015<\u001e\u0003\u0006\t\u000f\u0018%\b%\u0002\u0018\t\u001e\u0002\r\u0000"), classArray4));
            Class[] classArray5 = new Class[4 ^ 5];
            classArray5[3 & 4] = String.class;
            dataTransferManager.f_Ti.m_ma((short)(0x319F & 0x4FF5), (Object)dataTransferManager, DataTransferManager.class.getDeclaredMethod(c_ib.m_Hj((Object)"4?9=22\u0013?#?\u0003,60$82,$\u001c.\u000e%1=;4*\u001e:\u001e0#;%062"), classArray5));
            Class[] classArray6 = new Class[1];
            classArray6[0] = List.class;
            dataTransferManager.f_Ti.m_ma((short)(0x15FE & 0x6B97), (Object)dataTransferManager, DataTransferManager.class.getDeclaredMethod(ReportDataItem.m_hi((Object)"\u000b\t\u0018(\r\u0018\r8\u001e\r\u0002\u001f\n\t\u001e?\u0018\r\u0018\u0019\u001f\t\u001f.\u0015%\b\u001f%\u0002\u0018\t\u001e\u0002\r\u0000"), classArray6));
            Class[] classArray7 = new Class[1];
            classArray7[0] = String.class;
            dataTransferManager.f_Ti.m_ma((short)(0x39F7 & 0x479F), (Object)dataTransferManager, DataTransferManager.class.getDeclaredMethod(c_ib.m_Hj((Object)"0;#\u001a6*6\n%?9-1;%\r#?#+$;$\u001c.\u000e%1=;4*\u001e:\u001e0#;%062"), classArray7));
            return;
        }
        catch (NoSuchMethodException a) {
            throw new IllegalStateException(ReportDataItem.m_hi((Object)"*\r\u0005\u0000\t\bL\u0018\u0003L\u001e\t\u000b\u0005\u001f\u0018\t\u001eL(\r\u0018\r8\u001e\r\u0002\u001f\n\t\u001e!\r\u0002\r\u000b\t\u001eL></L\u0001\t\u0018\u0004\u0003\b\u001f"), a);
        }
    }

    @PreAuthorize(value="hasAuthority('VIEW_DATA_TRANSFER')")
    public Map<String, c_td> getDataTransferStatuses(String string) {
        Object a = string;
        DataTransferManager a2 = this;
        if (a2.f_Ti.m_fa()) {
            f_wh.debug(ReportDataItem.m_hi((Object)" )-()>VL+\t\u0018\u0018\u0005\u0002\u000bL\r\u0000\u0000L\b\r\u0018\rL\u0018\u001e\r\u0002\u001f\n\t\u001eL\u001f\u0018\r\u0018\u0019\u001f\t\u001fL\n\u0003\u001eL\u001c\u001e\u0003\u0006\t\u000f\u0018L\u0017\u0011L\u0000\u0003\u000f\r\u0000\u0000\u0015B"), a);
            return a2.getDataTransferStatusesByProjectIdInternal((String)a);
        }
        f_wh.debug(c_ib.m_Hj((Object)"\u0019\u0011\u0019s\u001b\u001b\u0016\u001a\u0012\fm~\u0005;&+2-#799w22?3;%~11%~62;~3?#?w*%?9-1;%~$*6*\"-2-w88,w.%1=;4*w%*p"), a);
        try {
            Object[] objectArray = new Object[3 >> 1];
            objectArray[3 ^ 3] = a;
            return (Map)a2.f_Ti.m_ga(Short.valueOf((short)(0x57BF & 0x29D7)), objectArray);
        }
        catch (Exception exception) {
            throw new ClusterRpcException("Failed to RPC get statuses for project" + (String)a, (Throwable)exception);
        }
    }

    protected void cancelDataTransferInternal(String string) {
        DataTransferManager a;
        Object a2 = string;
        DataTransferManager dataTransferManager = a = this;
        dataTransferManager.cancelDataTransferInternal(dataTransferManager.f_mG.m_KN((String)a2));
    }

    private /* synthetic */ void lambda$scheduleDataTransferInternal$5(DataTransfer dataTransfer) {
        DataTransferManager a = dataTransfer;
        DataTransferManager a2 = this;
        a2.f_mh.lock();
        try {
            a2.cancelDataTransferInternal((DataTransfer)a);
            if (!Boolean.TRUE.equals(a.getProject().getIsActive())) {
                throw new NotActiveException("Project should be active to schedule data transfer " + a.getName());
            }
            Object[] objectArray = new Object[4 ^ 5];
            objectArray[2 & 5] = a.getName();
            PeriodicJob periodicJob = a2.f_PG.m_oL(a.getProject(), c_ib.m_Hj((Object)"r-w\u001a6*6~\u0003,60$82,").formatted(objectArray), () -> a2.lambda$scheduleDataTransferInternal$4((DataTransfer)a), Duration.ofMillis(a.getPeriod().intValue()));
            DataTransferManager dataTransferManager = a2;
            dataTransferManager.f_AI.put(a.getId(), periodicJob);
            String[] stringArray = new String[2 ^ 3];
            stringArray[3 & 4] = a.getId();
            dataTransferManager.f_ug.sadd(f_kI, stringArray);
            return;
        }
        finally {
            a2.f_mh.unlock();
        }
    }

    @PreAuthorize(value="hasAuthority('CANCEL_DATA_TRANSFER')")
    public void cancelDataTransfer(String string) {
        Object a = string;
        DataTransferManager a2 = this;
        if (a2.f_Ti.m_fa()) {
            f_wh.debug(ReportDataItem.m_hi((Object)" )-()>VL/\r\u0002\u000f\t\u0000\u0000\u0005\u0002\u000bL\b\r\u0018\rL\u0018\u001e\r\u0002\u001f\n\t\u001eL\u0017\u0011L\u0000\u0003\u000f\r\u0000\u0000\u0015B"), a);
            a2.cancelDataTransferInternal((String)a);
            return;
        }
        f_wh.debug(c_ib.m_Hj((Object)"\u0010\u0018\u0010z\u0012\u0012\u001f\u0013\u001b\u0005dw\f2/\";$*>00~;;6:2,w*8~4?9=22w:6*6~#,60$82,w%*p"), a);
        try {
            Object[] objectArray = new Object[5 >> 2];
            objectArray[3 >> 2] = a;
            a2.f_Ti.m_ga(Short.valueOf((short)(0x1F6 & 0x7F9B)), objectArray);
            return;
        }
        catch (Exception exception) {
            throw new ClusterRpcException("Failed to RPC cancel data transfer " + (String)a, (Throwable)exception);
        }
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ Pair<Date, Date> calculateDateRange(Date date, c_Oh c_Oh2) {
        void a;
        void a2;
        Object a3;
        DataTransferManager dataTransferManager = this;
        Object object = a3 = Calendar.getInstance();
        ((Calendar)a3).setTime((Date)a2);
        ((Calendar)object).set(0x6D & 0x1F, 3 & 4);
        ((Calendar)object).set(0x6F & 0x1E, 3 & 4);
        Calendar calendar = (Calendar)((Calendar)object).clone();
        switch (c_PC.f_wH[a.ordinal()]) {
            case 1: {
                Object object2 = a3;
                while (false) {
                }
                ((Calendar)object2).set(0x7D & 0xE, 5 >> 3);
                return Pair.of((Object)((Calendar)object2).getTime(), (Object)a2);
            }
            case 2: {
                calendar.add(0x5F & 0x2B, -4 >> 2);
                Object object3 = a3;
                ((Calendar)object3).add(0x3F & 0x4B, 0xFFFFFFFF & 0xFFFFFFFE);
                ((Calendar)object3).set(0x6E & 0x1D, 3 ^ 3);
                return Pair.of((Object)((Calendar)object3).getTime(), (Object)calendar.getTime());
            }
            case 3: {
                Object object4 = a3;
                ((Calendar)object4).set(0x3B & 0x4F, 3 ^ 3);
                ((Calendar)object4).set(0x3E & 0x4D, 2 & 5);
                return Pair.of((Object)((Calendar)a3).getTime(), (Object)a2);
            }
            case 4: {
                calendar.add(--5, -4 >> 2);
                Object object5 = a3;
                ((Calendar)a3).add(--5, -2);
                ((Calendar)object5).set(11, 3 ^ 3);
                ((Calendar)object5).set(0x2D & 0x5E, 3 ^ 3);
                return Pair.of((Object)((Calendar)object5).getTime(), (Object)calendar.getTime());
            }
            case 5: {
                Object object6 = a3;
                Object object7 = a3;
                ((Calendar)object7).set(7, ((Calendar)object7).getFirstDayOfWeek());
                ((Calendar)object6).set(11, 5 >> 3);
                ((Calendar)object6).set(12, 0);
                return Pair.of((Object)((Calendar)a3).getTime(), (Object)a2);
            }
            case 6: {
                calendar.add(--3, -4 >> 2);
                Object object8 = a3;
                ((Calendar)a3).add(--3, -2);
                Object object9 = a3;
                ((Calendar)object9).set(7, ((Calendar)object9).getFirstDayOfWeek());
                ((Calendar)object8).set(11, 0);
                ((Calendar)object8).set(12, 0);
                return Pair.of((Object)((Calendar)object8).getTime(), (Object)calendar.getTime());
            }
            case 7: {
                Object object10 = a3;
                ((Calendar)a3).set(--5, 1);
                ((Calendar)object10).set(11, 0);
                ((Calendar)object10).set(12, 0);
                return Pair.of((Object)((Calendar)a3).getTime(), (Object)a2);
            }
            case 8: {
                calendar.add(--2, -4 >> 2);
                Object object11 = a3;
                Object object12 = a3;
                ((Calendar)object12).add(2, -2);
                ((Calendar)object12).set(5, 1);
                ((Calendar)object11).set(11, 0);
                ((Calendar)object11).set(12, 0);
                return Pair.of((Object)((Calendar)object11).getTime(), (Object)calendar.getTime());
            }
            case 9: {
                Object object13 = a3;
                ((Calendar)a3).set(6, 1);
                ((Calendar)object13).set(11, 0);
                ((Calendar)object13).set(12, 0);
                return Pair.of((Object)((Calendar)a3).getTime(), (Object)a2);
            }
            case 10: {
                calendar.add(1, -1);
                Object object14 = a3;
                Object object15 = a3;
                ((Calendar)object15).add(1, -2);
                ((Calendar)object15).set(6, 1);
                ((Calendar)object14).set(11, 0);
                ((Calendar)object14).set(12, 0);
                return Pair.of((Object)((Calendar)object14).getTime(), (Object)calendar.getTime());
            }
        }
        throw new IllegalArgumentException(ReportDataItem.m_hi((Object)"9\u0002\t\u0014\u001c\t\u000f\u0018\t\bL\u001e\r\u0002\u000b\tL\u0018\u0015\u001c\t"));
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    private /* synthetic */ boolean shouldRecalculateStats(DataTransferDetail dataTransferDetail, Date date, String string) {
        int n;
        void a;
        void a2;
        Object a222 = string;
        DataTransferManager a3 = this;
        if (a222 == null) {
            return (2 ^ 3) != 0;
        }
        a222 = Calendar.getInstance();
        String string2 = a3.f_ug.get(a3.buildStatLastCalcTimeKey((DataTransferDetail)a2));
        if (string2 == null) {
            return (2 ^ 3) != 0;
        }
        ((Calendar)a222).setTimeInMillis(Long.parseLong(string2));
        Calendar calendar = Calendar.getInstance();
        calendar.setTime((Date)a);
        switch (c_PC.f_wH[a2.getRangeType().ordinal()]) {
            default: {
                throw new IncompatibleClassChangeError();
            }
            case 1: 
            case 2: {
                int n2;
                if (((Calendar)a222).get(0x1F & 0x6B) != calendar.get(0x5B & 0x2F)) {
                    n2 = 5 >> 2;
                    break;
                }
                n2 = 0;
                break;
            }
            case 3: 
            case 4: {
                int n2;
                if (((Calendar)a222).get(6 & 0x7F) != calendar.get(0x56 & 0x2F)) {
                    n2 = --1;
                    break;
                }
                n2 = 0;
                break;
            }
            case 5: 
            case 6: {
                int n2;
                if (((Calendar)a222).get(--3) != calendar.get(--3)) {
                    n2 = --1;
                    break;
                }
                n2 = 0;
                break;
            }
            case 7: 
            case 8: {
                int n2;
                if (((Calendar)a222).get(5 >> 1) != calendar.get(--2)) {
                    n2 = 2 ^ 3;
                    break;
                }
                n2 = 0;
                break;
            }
            case 9: 
            case 10: {
                int n2 = n = ((Calendar)a222).get(2 ^ 3) != calendar.get(--1) ? 2 ^ 3 : 0;
            }
        }
        if (n != 0) {
            DataTransferManager dataTransferManager = a3;
            a222 = dataTransferManager.buildStatCacheKey((DataTransferDetail)a2);
            String string3 = dataTransferManager.buildStatLastCalcTimeKey((DataTransferDetail)a2);
            String[] stringArray = new String[--2];
            stringArray[0] = a222;
            stringArray[1] = string3;
            dataTransferManager.f_ug.del(stringArray);
            return true;
        }
        if (!a2.getRangeType().toString().startsWith(ReportDataItem.m_hi((Object)"/\u0019\u001e\u001e\t\u0002\u0018"))) {
            return false;
        }
        int a222 = switch (c_PC.f_wH[a2.getRangeType().ordinal()]) {
            case 1 -> 5;
            case 3 -> 5;
            case 5 -> 60;
            case 7 -> 720;
            case 9 -> 720;
            default -> throw new IllegalArgumentException("Unexpected range type: " + String.valueOf(a2.getRangeType()));
        };
        long l = a.getTime();
        long l2 = Long.parseLong(string2);
        return l - l2 >= (long)(a222 * (0x3D & 0x7E) * (0x43EA & 0x3FFD));
    }

    @PreAuthorize(value="hasAuthority('SCHEDULE_DATA_TRANSFER')")
    public void scheduleDataTransfer(String string) {
        Object a = string;
        DataTransferManager a2 = this;
        if (a2.f_Ti.m_fa()) {
            f_wh.debug(ReportDataItem.m_hi((Object)" )-()>VL?\u000f\u0004\t\b\u0019\u0000\u0005\u0002\u000bL\b\r\u0018\rL\u0018\u001e\r\u0002\u001f\n\t\u001eL\u0017\u0011L\u0000\u0003\u000f\r\u0000\u0000\u0015B"), a);
            a2.scheduleDataTransferInternal((String)a);
            return;
        }
        f_wh.debug(c_ib.m_Hj((Object)"\u0010\u0018\u0010z\u0012\u0012\u001f\u0013\u001b\u0005dw\f2/\";$*>00~;;6:2,w*8~$=?;3+;;w:6*6~#,60$82,w%*p"), a);
        try {
            Object[] objectArray = new Object[3 & 5];
            objectArray[3 & 4] = a;
            a2.f_Ti.m_ga(Short.valueOf((short)(0x9FD & 0x7793)), objectArray);
            return;
        }
        catch (Exception exception) {
            throw new ClusterRpcException("Failed to RPC schedule data transfer " + (String)a, (Throwable)exception);
        }
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ boolean isValueInThresholdRange(Double d, Double d2, VariableValue<?> variableValue) {
        void a;
        void a2;
        VariableValue<?> a3 = variableValue;
        VariableValue<?> a4 = this;
        return a4.isValueInThresholdRange((Double)a2, (VariableValue)new NumberVariableValue((Number)a, new Date()), a3);
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void lambda$restoreSingleDataTransferOnLeader$1(String string, DataTransfer dataTransfer) {
        void a;
        DataTransferManager a2 = dataTransfer;
        DataTransferManager a3 = this;
        try {
            Object[] objectArray = new Object[--3];
            objectArray[3 & 4] = a;
            objectArray[--1] = a2.getName();
            objectArray[--2] = a2.getId();
            f_wh.info(ReportDataItem.m_hi((Object)"(\r\u0018\r8\u001e\r\u0002\u001f\n\t\u001e!\r\u0002\r\u000b\t\u001eLD \t\r\b\t\u001eL\u0017\u0011EVL>\t\u001f\u0018\u0003\u001e\u0005\u0002\u000bL\b\r\u0018\rL\u0018\u001e\r\u0002\u001f\n\t\u001eVL\u0017\u0011LD%(VL\u0017\u0011E"), objectArray);
            a3.scheduleDataTransferInternal((DataTransfer)a2);
            return;
        }
        catch (Exception exception) {
            Object[] objectArray = new Object[--3];
            objectArray[2 & 5] = a2.getName();
            objectArray[3 & 5] = a2.getId();
            objectArray[1 ^ 3] = ExceptionUtils.getRootCauseMessage((Throwable)exception);
            a3.f_fh.m_BJ(a2.getProject()).m_s("Data Transfer Restore (Leader " + (String)a + ")", c_ib.m_Hj((Object)"r-wv\u001e\u001am~r-~~1?>22:w*8~%;$*8,2pw\u001d6+$;m~r-").formatted(objectArray));
            try {
                f_wh.warn(ReportDataItem.m_hi((Object)"(\r\u0018\r8\u001e\r\u0002\u001f\n\t\u001e!\r\u0002\r\u000b\t\u001eLD \t\r\b\t\u001eL\u0017\u0011EVL-\u0018\u0018\t\u0001\u001c\u0018\u0005\u0002\u000bL\u0018\u0003L\u000f\r\u0002\u000f\t\u0000L\b\r\u0018\rL\u0018\u001e\r\u0002\u001f\n\t\u001eL\u0017\u0011L\r\n\u0018\t\u001eL\u001e\t\u001f\u0018\u0003\u001e\r\u0018\u0005\u0003\u0002L\n\r\u0005\u0000\u0019\u001e\tB"), (Object)a, (Object)a2.getId());
                a3.cancelDataTransferInternal((DataTransfer)a2);
                return;
            }
            catch (Exception exception2) {
                Object[] objectArray2 = new Object[--4];
                objectArray2[3 >> 2] = a;
                objectArray2[2 ^ 3] = a2.getId();
                objectArray2[--2] = exception2.getMessage();
                objectArray2[--3] = exception2;
                f_wh.error(c_ib.m_Hj((Object)"\u0013?#?\u0003,60$82,\u001a?9?0;%~\u007f\u00122?3;%~,#~dw\u001867;;3~#1w=604;;~3?#?w*%?9-1;%~,#w?1*2,w,2-#1%?#780w867;+%;m~,#"), objectArray2);
                return;
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void lambda$notLeader$2(String string, String string2) {
        void a;
        DataTransferManager dataTransferManager = this;
        DataTransferManager a22 = (Job)dataTransferManager.f_AI.get(a);
        if (a22 != null) {
            void a3;
            try {
                f_wh.info(ReportDataItem.m_hi((Object)"(\r\u0018\r8\u001e\r\u0002\u001f\n\t\u001e!\r\u0002\r\u000b\t\u001eLD\"\u0003\u0018L \t\r\b\t\u001eL\u0017\u0011EVL/\r\u0002\u000f\t\u0000\u0000\u0005\u0002\u000bL\u0000\u0003\u000f\r\u0000L\u0006\u0003\u000eL\n\u0003\u001eL\b\r\u0018\rL\u0018\u001e\r\u0002\u001f\n\t\u001eL%(VL\u0017\u0011"), (Object)a3, (Object)a);
                dataTransferManager.f_PG.m_jl((Job)a22);
                return;
            }
            catch (Exception a22) {
                Object[] objectArray = new Object[--4];
                objectArray[3 ^ 3] = a3;
                objectArray[5 >> 2] = a;
                objectArray[--2] = a22.getMessage();
                objectArray[--3] = a22;
                f_wh.error(c_ib.m_Hj((Object)"\u001a6*6\n%?9-1;%\u001360692,wv\u00191#~\u001b;6:2,w%*wm~\u0012,%1%~4?9=22;799w28=62w48<w88,w:6*6~#,60$82,w\u0017\u0013~,#m~,#"), objectArray);
            }
        }
    }

    protected void scheduleDataTransfersByProjectIdInternal(String string) {
        Object a = string;
        DataTransferManager a2 = this;
        if ((a = a2.f_mG.m_lM((String)a)) == null || a.isEmpty()) {
            return;
        }
        a.forEach(arg_0 -> a2.scheduleDataTransferInternal(arg_0));
    }

    protected Map<String, c_td> getDataTransferStatusesByIdsInternal(List<String> list) {
        List<String> a = list;
        DataTransferManager a2 = this;
        if (a == null || a.isEmpty()) {
            return Collections.emptyMap();
        }
        return a.stream().collect(Collectors.toMap(Function.identity(), arg_0 -> a2.getDataTransferStatusInternal(arg_0)));
    }

    @TransactionalEventListener(value={c_dA.class})
    public void handleRescheduleEvent(c_dA c_dA2) {
        DataTransferManager dataTransferManager = this;
        if (dataTransferManager.f_Ti.m_fa()) {
            DataTransferManager a = a.m_mm();
            f_wh.info(ReportDataItem.m_hi((Object)" )-()>VL$\r\u0002\b\u0000\u0005\u0002\u000bL>\t\u001f\u000f\u0004\t\b\u0019\u0000\t)\u001a\t\u0002\u0018L\n\u0003\u001eL\b\r\u0018\rL\u0018\u001e\r\u0002\u001f\n\t\u001eVL\u0017\u0011LD%(VL\u0017\u0011E"), (Object)a.getName(), (Object)a.getId());
            if (dataTransferManager.getDataTransferStatusInternal(a.getId()) == c_td.f_Ph) {
                dataTransferManager.scheduleDataTransferInternal(a.getId());
                return;
            }
        } else {
            f_wh.debug(c_ib.m_Hj((Object)"\u0019\u0011\u0019s\u001b\u001b\u0016\u001a\u0012\fm~\u001e991%799w\f2-462:\"22\u001b!;9*w88,w:6*6~#,60$82,m~,#"), (Object)a.m_mm().getId());
        }
    }

    /*
     * WARNING - void declaration
     */
    @PreAuthorize(value="hasAuthority('VIEW_DATA_TRANSFER')")
    public c_td getDataTransferStatus(String string, String string2) {
        void a;
        Object a2 = string;
        DataTransferManager a3 = this;
        if ((a2 = a3.f_mG.m_xo((String)a2, (String)a)) == null) {
            return c_td.f_Cj;
        }
        return a3.getDataTransferStatus(a2.getId());
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void lambda$handleStatValues$16(Map map, Map map2, Map map3, Map map4, DataTransferDetail dataTransferDetail) {
        Variable a;
        DataTransferManager a2;
        Object a3;
        DataTransferManager dataTransferManager = dataTransferManager2;
        DataTransferManager dataTransferManager2 = dataTransferDetail;
        DataTransferManager a4 = dataTransferManager;
        if ((a3 = (LoggedVariableValueStats)a3.get(a2.getSourceVariableId())) != null && (a = (Variable)a.get(a2.getTargetVariableId())) != null) {
            String a5;
            double d = a4.extractValue(a3, a2.getCalcType());
            a3 = (VariableValue)a5.get(a2.getTargetVariableId());
            DataTransferManager dataTransferManager3 = a4;
            a5 = dataTransferManager3.buildStatCacheKey((DataTransferDetail)a2);
            String string = dataTransferManager3.buildStatLastCalcTimeKey((DataTransferDetail)a2);
            int n = dataTransferManager3.getMaxTTLForRangeType(a2.getRangeType());
            dataTransferManager3.f_ug.setex(a5, (long)n, String.valueOf(d));
            a4.f_ug.setex(string, (long)n, String.valueOf(System.currentTimeMillis()));
            if (dataTransferManager3.isValueInThresholdRange(a2.getThreshold(), Double.valueOf(d), (VariableValue)a3)) {
                void a6;
                a3 = new HashMap<String, Double>();
                a3.put(c_ib.m_Hj((Object)"(62\";"), d);
                a6.put(a.getName(), a3);
            }
        }
    }

    @PreAuthorize(value="hasAuthority('SCHEDULE_DATA_TRANSFER')")
    public void scheduleDataTransfers(String string) {
        Object a = string;
        DataTransferManager a2 = this;
        if (a2.f_Ti.m_fa()) {
            f_wh.debug(ReportDataItem.m_hi((Object)" )-()>VL?\u000f\u0004\t\b\u0019\u0000\u0005\u0002\u000bL\r\u0000\u0000L\b\r\u0018\rL\u0018\u001e\r\u0002\u001f\n\t\u001e\u001fL\n\u0003\u001eL\u001c\u001e\u0003\u0006\t\u000f\u0018L\u0017\u0011L\u0000\u0003\u000f\r\u0000\u0000\u0015B"), a);
            a2.scheduleDataTransfersByProjectIdInternal((String)a);
            return;
        }
        f_wh.debug(c_ib.m_Hj((Object)"\u0019\u0011\u0019s\u001b\u001b\u0016\u001a\u0012\fm~\u0005;&+2-#799w22?3;%~#1w-462:\"22~62;~3?#?w*%?9-1;%-w88,w.%1=;4*w%*p"), a);
        try {
            Object[] objectArray = new Object[3 >> 1];
            objectArray[3 & 4] = a;
            a2.f_Ti.m_ga(Short.valueOf((short)(0x17FD & 0x6996)), objectArray);
            return;
        }
        catch (Exception exception) {
            throw new ClusterRpcException("Failed to RPC schedule data transfers for project " + (String)a, (Throwable)exception);
        }
    }

    /*
     * WARNING - void declaration
     */
    @PreAuthorize(value="hasAuthority('CANCEL_DATA_TRANSFER')")
    public void cancelDataTransfer(String string, String string2) {
        void a;
        DataTransferManager a2;
        Object a3 = string2;
        DataTransferManager dataTransferManager = a2 = this;
        dataTransferManager.cancelDataTransfer(dataTransferManager.f_mG.m_SO((String)a, (String)a3).getId());
    }

    @PreAuthorize(value="hasAuthority('VIEW_DATA_TRANSFER')")
    public Map<String, c_td> getDataTransferStatuses(List<String> list) {
        List<String> a = list;
        DataTransferManager a2 = this;
        if (a == null || a.isEmpty()) {
            return Collections.emptyMap();
        }
        if (a2.f_Ti.m_fa()) {
            f_wh.debug(c_ib.m_Hj((Object)"\u0012\u0012\u001f\u0013\u001b\u0005dw\u00192*#799w:6*6~#,60$82,w-#?#+$;$~11%~,#w\u0017\u0013-w28=62;'m~,#"), (Object)a.size(), (Object)a);
            return a2.getDataTransferStatusesByIdsInternal((List)a);
        }
        f_wh.debug(ReportDataItem.m_hi((Object)"\"#\"A )-()>VL>\t\u001d\u0019\t\u001f\u0018\u0005\u0002\u000bL\u0000\t\r\b\t\u001eL\n\u0003\u001eL\b\r\u0018\rL\u0018\u001e\r\u0002\u001f\n\t\u001eL\u001f\u0018\r\u0018\u0019\u001f\t\u001fL\n\u0003\u001eL\u0017\u0011L%(\u001fVL\u0017\u0011"), (Object)a.size(), (Object)a);
        try {
            Object[] objectArray = new Object[--1];
            objectArray[3 >> 2] = new ArrayList(a);
            return (Map)a2.f_Ti.m_ga(Short.valueOf((short)(0x4BD6 & 0x35BF)), objectArray);
        }
        catch (Exception exception) {
            throw new ClusterRpcException("Failed to RPC get data transfer statuses for IDs " + a.stream().map(String::valueOf).collect(Collectors.joining(c_ib.m_Hj((Object)"r"))), (Throwable)exception);
        }
    }

    protected void scheduleDataTransferInternal(DataTransfer dataTransfer) {
        DataTransferManager a = dataTransfer;
        DataTransferManager a2 = this;
        a2.f_lG.m_pCa(() -> a2.lambda$scheduleDataTransferInternal$5((DataTransfer)a), (OwnedSpaceBaseModel)a);
    }

    @PostConstruct
    private /* synthetic */ void initializeClusterIntegration() {
        DataTransferManager a;
        DataTransferManager dataTransferManager = a;
        dataTransferManager.registerRemoteCallsWithClusterNode();
        dataTransferManager.f_Ti.m_ka((ClusterNodeListener)a);
        f_wh.info(ReportDataItem.m_hi((Object)"(\r\u0018\r8\u001e\r\u0002\u001f\n\t\u001e!\r\u0002\r\u000b\t\u001eL\u0005\u0002\u0005\u0018\u0005\r\u0000\u0005\u0016\t\bL\r\u0002\bL\u001e\t\u000b\u0005\u001f\u0018\t\u001e\t\bL\r\u001fL/\u0000\u0019\u001f\u0018\t\u001e\"\u0003\b\t \u0005\u001f\u0018\t\u0002\t\u001eB"));
    }

    @PreAuthorize(value="hasAuthority('CANCEL_DATA_TRANSFER')")
    public void cancelDataTransfers(String string) {
        Object a = string;
        DataTransferManager a2 = this;
        if (a2.f_Ti.m_fa()) {
            f_wh.debug(ReportDataItem.m_hi((Object)" )-()>VL/\r\u0002\u000f\t\u0000\u0000\u0005\u0002\u000bL\r\u0000\u0000L\b\r\u0018\rL\u0018\u001e\r\u0002\u001f\n\t\u001e\u001fL\n\u0003\u001eL\u001c\u001e\u0003\u0006\t\u000f\u0018L\u0017\u0011L\u0000\u0003\u000f\r\u0000\u0000\u0015B"), a);
            a2.cancelDataTransfersByProjectIdInternal((String)a);
            return;
        }
        f_wh.debug(c_ib.m_Hj((Object)"\u0019\u0011\u0019s\u001b\u001b\u0016\u001a\u0012\fm~\u0005;&+2-#799w22?3;%~#1w=604;;~62;~3?#?w*%?9-1;%-w88,w.%1=;4*w%*p"), a);
        try {
            Object[] objectArray = new Object[2 ^ 3];
            objectArray[2 & 5] = a;
            a2.f_Ti.m_ga(Short.valueOf((short)(0x53F5 & 0x2D9F)), objectArray);
            return;
        }
        catch (Exception exception) {
            throw new ClusterRpcException("Failed to RPC cancel data transfers for project " + (String)a, (Throwable)exception);
        }
    }

    protected void scheduleDataTransferInternal(String string) {
        DataTransferManager a;
        Object a2 = string;
        DataTransferManager dataTransferManager = a = this;
        dataTransferManager.scheduleDataTransferInternal(dataTransferManager.f_mG.m_jo((String)a2));
    }

    private /* synthetic */ void lambda$scheduleDataTransferInternal$4(DataTransfer dataTransfer) {
        DataTransferManager a = dataTransfer;
        DataTransferManager a2 = this;
        a2.transfer((DataTransfer)a);
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void handleStatValues(List<DataTransferDetail> list, Map<String, Map<String, Object>> map) {
        void a;
        void a2;
        DataTransferManager dataTransferManager = this;
        Object a3 = a2.stream().map(DataTransferDetail::getTargetVariableId).collect(Collectors.toList());
        Map map2 = dataTransferManager.f_OH.m_taa((List)a3).stream().collect(Collectors.toMap(BaseModel::getId, Function.identity()));
        a3 = dataTransferManager.f_dj.m_CX((String[])a3.toArray(String[]::new));
        Date date = new Date();
        a2.stream().filter(arg_0 -> dataTransferManager.lambda$handleStatValues$12(date, map2, (Map)a, (Map)a3, arg_0)).collect(Collectors.groupingBy(dataTransferDetail -> {
            void a;
            DataTransferManager a2 = dataTransferDetail;
            DataTransferManager a3 = this;
            return (Date)a3.calculateDateRange((Date)a, a2.getRangeType()).getLeft();
        })).forEach((arg_0, arg_1) -> dataTransferManager.lambda$handleStatValues$17(date, map2, (Map)a3, (Map)a, arg_0, arg_1));
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ boolean isValueInThresholdRange(Double d, VariableValue<?> variableValue, VariableValue<?> variableValue2) {
        void a;
        void a2;
        VariableValue<?> a3 = variableValue2;
        VariableValue<?> a4 = this;
        if (a2 == null || a3 == null) {
            return true;
        }
        if (!(a instanceof NumberVariableValue) || !(a3 instanceof NumberVariableValue)) {
            return true;
        }
        double d2 = ((Number)a.getValue()).doubleValue();
        double d3 = ((Number)a3.getValue()).doubleValue();
        double d4 = d2 == 0.0 ? Math.abs(d3 - d2) : Math.abs((d3 - d2) / d2 * 100.0);
        if (d4 >= a2.doubleValue()) {
            return (2 ^ 3) != 0;
        }
        return false;
    }
}

