/*
 * Decompiled with CFR 0.152.
 */
package com.inscada.mono.config;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.inscada.mono.communication.base.model.FrameSummary;
import com.inscada.mono.config.BrokerProperties;
import com.inscada.mono.config.ListenerBrokerProperties;
import com.inscada.mono.shared.interfaces.Listener;
import com.inscada.mono.system.model.SystemRequest;
import jakarta.jms.ConnectionFactory;
import jakarta.jms.MessageListener;
import java.time.Duration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.activemq.artemis.api.core.TransportConfiguration;
import org.apache.activemq.artemis.core.remoting.impl.netty.NettyConnectorFactory;
import org.apache.activemq.artemis.jms.client.ActiveMQConnectionFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.jms.JmsProperties;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.jms.annotation.EnableJms;
import org.springframework.jms.annotation.JmsListenerConfigurer;
import org.springframework.jms.config.DefaultJmsListenerContainerFactory;
import org.springframework.jms.config.JmsListenerContainerFactory;
import org.springframework.jms.config.JmsListenerEndpoint;
import org.springframework.jms.config.JmsListenerEndpointRegistrar;
import org.springframework.jms.config.JmsListenerEndpointRegistry;
import org.springframework.jms.config.SimpleJmsListenerEndpoint;
import org.springframework.jms.connection.CachingConnectionFactory;
import org.springframework.jms.listener.adapter.MessageListenerAdapter;
import org.springframework.jms.support.converter.MappingJackson2MessageConverter;
import org.springframework.jms.support.converter.MessageConverter;
import org.springframework.jms.support.converter.MessageType;
import org.springframework.util.StringUtils;

@Configuration
@EnableConfigurationProperties(value={ListenerBrokerProperties.class})
@ConditionalOnProperty(value={"spring.remote.broker.enabled"}, havingValue="true")
@EnableJms
public class ListenerBrokerConfig
implements JmsListenerConfigurer {
    private final ListenerBrokerProperties brokerProperties;
    private final ObjectMapper objectMapper;
    private final List<Listener<?>> listenerList;
    private final JmsProperties jmsProperties;
    private final String nodeId;

    @Bean(destroyMethod="stop")
    JmsListenerEndpointRegistry jmsListenerEndpointRegistry() {
        return new JmsListenerEndpointRegistry();
    }

    /*
     * WARNING - void declaration
     */
    public void configureJmsListeners(JmsListenerEndpointRegistrar jmsListenerEndpointRegistrar) {
        void a;
        ListenerBrokerConfig listenerBrokerConfig = this;
        void v0 = a;
        ListenerBrokerConfig listenerBrokerConfig2 = listenerBrokerConfig;
        v0.setEndpointRegistry(listenerBrokerConfig2.jmsListenerEndpointRegistry());
        v0.afterPropertiesSet();
        if (listenerBrokerConfig2.brokerProperties.getList() == null) {
            return;
        }
        for (BrokerProperties brokerProperties : listenerBrokerConfig.brokerProperties.getList()) {
            Object a2 = new HashMap<String, String>();
            a2.put(SystemRequest.m_gB((Object)"\u0003S\u0018H"), brokerProperties.getHost());
            a2.put(FrameSummary.m_vV((Object)"\u0010\r\u0012\u0016"), brokerProperties.getPort());
            a2 = new TransportConfiguration(NettyConnectorFactory.class.getName(), (Map)a2);
            TransportConfiguration[] transportConfigurationArray = new TransportConfiguration[--1];
            transportConfigurationArray[2 & 5] = a2;
            a2 = new ActiveMQConnectionFactory((2 & 5) != 0, transportConfigurationArray);
            String string = brokerProperties.getUser();
            if (StringUtils.hasText((String)string)) {
                a2.setUser(string);
                a2.setPassword(brokerProperties.getPassword());
            }
            a2.setClientID(listenerBrokerConfig.nodeId);
            ListenerBrokerConfig listenerBrokerConfig3 = listenerBrokerConfig;
            brokerProperties = listenerBrokerConfig3.jmsProperties.getCache();
            Object object = a2 = new CachingConnectionFactory((ConnectionFactory)a2);
            BrokerProperties brokerProperties2 = brokerProperties;
            a2.setCacheConsumers(brokerProperties2.isConsumers());
            object.setCacheProducers(brokerProperties2.isProducers());
            object.setSessionCacheSize(brokerProperties.getSessionCacheSize());
            BrokerProperties brokerProperties3 = brokerProperties = new DefaultJmsListenerContainerFactory();
            ListenerBrokerConfig listenerBrokerConfig4 = listenerBrokerConfig;
            brokerProperties.setConnectionFactory((ConnectionFactory)a2);
            brokerProperties.setMessageConverter(listenerBrokerConfig4.jacksonReceiveJmsMessageConverter());
            brokerProperties3.setPubSubDomain(Boolean.valueOf(listenerBrokerConfig4.jmsProperties.isPubSubDomain()));
            brokerProperties3.setSubscriptionDurable(Boolean.valueOf(--1 != 0));
            Object object2 = a2 = listenerBrokerConfig3.jmsProperties.getListener();
            brokerProperties.setAutoStartup(object2.isAutoStartup());
            if (object2.getAcknowledgeMode() != null) {
                brokerProperties.setSessionAcknowledgeMode(Integer.valueOf(a2.getAcknowledgeMode().getMode()));
            }
            if ((string = a2.formatConcurrency()) != null) {
                brokerProperties.setConcurrency(string);
            }
            if ((a2 = a2.getReceiveTimeout()) != null) {
                brokerProperties.setReceiveTimeout(Long.valueOf(((Duration)a2).toMillis()));
            }
            Object object3 = a2 = listenerBrokerConfig.listenerList.iterator();
            while (object3.hasNext()) {
                SimpleJmsListenerEndpoint simpleJmsListenerEndpoint;
                string = (Listener)a2.next();
                SimpleJmsListenerEndpoint simpleJmsListenerEndpoint2 = simpleJmsListenerEndpoint = new SimpleJmsListenerEndpoint();
                String string2 = string;
                simpleJmsListenerEndpoint.setId(string2.m_u());
                simpleJmsListenerEndpoint2.setSubscription(string2.m_x());
                simpleJmsListenerEndpoint2.setDestination(string.m_o());
                String string3 = string = new MessageListenerAdapter((Object)string);
                string3.setMessageConverter(listenerBrokerConfig.jacksonReceiveJmsMessageConverter());
                string3.setDefaultListenerMethod(SystemRequest.m_gB((Object)"N\u000e_\u000eU\u001dY"));
                simpleJmsListenerEndpoint2.setMessageListener((MessageListener)string3);
                object3 = a2;
                a.registerEndpoint((JmsListenerEndpoint)simpleJmsListenerEndpoint, (JmsListenerContainerFactory)brokerProperties);
            }
        }
    }

    @Bean
    public MessageConverter jacksonReceiveJmsMessageConverter() {
        ListenerBrokerConfig a;
        ListenerBrokerConfig listenerBrokerConfig = this;
        ListenerBrokerConfig listenerBrokerConfig2 = a = new MappingJackson2MessageConverter();
        a.setObjectMapper(listenerBrokerConfig.objectMapper);
        listenerBrokerConfig2.setTargetType(MessageType.TEXT);
        listenerBrokerConfig2.setTypeIdPropertyName(FrameSummary.m_vV((Object)"=\u0014\u001b\u0010\u0007"));
        return listenerBrokerConfig2;
    }

    /*
     * WARNING - void declaration
     */
    public ListenerBrokerConfig(List<Listener<?>> list, ObjectMapper objectMapper, JmsProperties jmsProperties, ListenerBrokerProperties listenerBrokerProperties, @Value(value="${ins.node.id}") String string) {
        void brokerProperties;
        void jmsProperties2;
        void objectMapper2;
        void listenerList;
        ListenerBrokerConfig a;
        ListenerBrokerConfig listenerBrokerConfig = object;
        Object object = string;
        ListenerBrokerConfig listenerBrokerConfig2 = a = listenerBrokerConfig;
        ListenerBrokerConfig listenerBrokerConfig3 = a;
        a.listenerList = listenerList;
        listenerBrokerConfig3.objectMapper = objectMapper2;
        listenerBrokerConfig3.jmsProperties = jmsProperties2;
        listenerBrokerConfig2.brokerProperties = brokerProperties;
        listenerBrokerConfig2.nodeId = object;
    }
}

