/*
 * Decompiled with CFR 0.152.
 */
package com.inscada.mono.communication.base.services;

import com.inscada.mono.auth.c_ZK;
import com.inscada.mono.cluster.exceptions.ClusterRpcException;
import com.inscada.mono.cluster.services.ClusterNodeListener;
import com.inscada.mono.cluster.services.c_B;
import com.inscada.mono.communication.base.e.c_Ah;
import com.inscada.mono.communication.base.exceptions.BrowseOperationException;
import com.inscada.mono.communication.base.model.Connection;
import com.inscada.mono.communication.base.model.ConnectionSummary;
import com.inscada.mono.communication.base.model.SetValueRequest;
import com.inscada.mono.communication.base.model.Variable;
import com.inscada.mono.communication.base.model.values.logged.LoggedVariableValueList;
import com.inscada.mono.communication.base.services.c_Fi;
import com.inscada.mono.communication.base.services.c_Gf;
import com.inscada.mono.communication.base.services.c_Wg;
import com.inscada.mono.communication.base.services.c_e;
import com.inscada.mono.communication.base.x.c_Vg;
import com.inscada.mono.communication.base.x.c_jG;
import com.inscada.mono.license.x.c_Cb;
import com.inscada.mono.log.services.c_lA;
import com.inscada.mono.project.x.c_I;
import com.inscada.mono.shared.exceptions.NotActiveException;
import com.inscada.mono.shared.exceptions.NotFoundException;
import com.inscada.mono.shared.model.OwnedSpaceBaseModel;
import com.inscada.mono.user.restcontrollers.UserController;
import jakarta.annotation.PostConstruct;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.stream.Collectors;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Component;
import org.springframework.transaction.event.TransactionalEventListener;
import redis.clients.jedis.JedisPooled;

@Component
public class ConnectionManager<C extends Connection<?>, V extends Variable<?, ?, ?>>
implements ClusterNodeListener,
c_I {
    private final c_Cb f_JT;
    public static final short f_NS = 203;
    private static final String f_uT = "activeConnections";
    private final JedisPooled f_Xs;
    public static final short f_rT = 208;
    public static final short f_pt = 201;
    public static final short f_IT = 202;
    public static final short f_pT = 210;
    public static final short f_Qt = 209;
    private final c_B f_Ps;
    public static final short f_Ts = 205;
    public static final short f_US = 207;
    private final c_ZK f_Us;
    private final c_Fi f_DS;
    private final c_lA f_It;
    public static final short f_ws = 204;
    private final c_Wg<C, V> f_Qs;
    public static final short f_sS = 206;
    private final Lock f_cT;
    private static final Logger f_BU = LoggerFactory.getLogger(ConnectionManager.class);

    protected void setVariableValueInternal(SetValueRequest<V> setValueRequest) {
        SetValueRequest<V> a = setValueRequest;
        SetValueRequest<V> a2 = this;
        c_Gf c_Gf2 = a2.f_Qs.m_jda(a.getConnectionId());
        if (c_Gf2 == null) {
            throw new NotFoundException("Connector for connection " + a.getConnectionId() + " not found or not active on leader.");
        }
        c_Gf2.m_Rt(a);
    }

    private /* synthetic */ Object lambda$browseConnectionInternal$2(String string) throws Exception {
        Object a = string;
        ConnectionManager a2 = this;
        if ((a = a2.f_Qs.m_jda((String)a)) instanceof c_e) {
            return ((c_e)a).m_ca();
        }
        throw new BrowseOperationException(UserController.m_lA((Object)"k0F5Z'\t-Y'[#]+F,\t,F6\t1\\2Y-[6L&"));
    }

    @PreAuthorize(value="hasAuthority('START_CONNECTION')")
    public void startConnection(String string) {
        Object a = string;
        ConnectionManager a2 = this;
        if (a2.f_Ps.m_fa()) {
            f_BU.debug(LoggedVariableValueList.m_Tba((Object)"IQDP@F?4V`dfq}ks%wjzkqf`l{k4~i%xjwdxim+"), a);
            a2.startConnectionInternal((String)a);
            return;
        }
        f_BU.debug(UserController.m_lA((Object)"\ff\f\u0004\u000el\u0003m\u0007{x\t\u0010L3\\'Z6@,NbE'H&L0\t6FbZ6H0]bJ-G,L!]+F,\t9Tl"), a);
        try {
            Object[] objectArray = new Object[--1];
            objectArray[3 ^ 3] = a;
            a2.f_Ps.m_ga(Short.valueOf((short)(0x77DB & 0x8ED)), objectArray);
            return;
        }
        catch (Exception exception) {
            throw new ClusterRpcException("Failed to RPC start connection " + (String)a, (Throwable)exception);
        }
    }

    private /* synthetic */ void registerRemoteCallsWithClusterNode() {
        ConnectionManager connectionManager = this;
        try {
            Class[] classArray = new Class[3 & 5];
            classArray[3 & 4] = String.class;
            connectionManager.f_Ps.m_ma((short)(0x38CB & 0x47FD), (Object)connectionManager, ConnectionManager.class.getDeclaredMethod(LoggedVariableValueList.m_Tba((Object)"v`dfqWjzkqf`l{k]k``fkui"), classArray));
            Class[] classArray2 = new Class[2 ^ 3];
            classArray2[3 >> 2] = String.class;
            connectionManager.f_Ps.m_ma((short)(0x25EE & 0x5ADB), (Object)connectionManager, ConnectionManager.class.getDeclaredMethod(UserController.m_lA((Object)"Z6F2j-G,L!]+F,`,]'[,H."), classArray2));
            Class[] classArray3 = new Class[3 & 5];
            classArray3[3 ^ 3] = String.class;
            connectionManager.f_Ps.m_ma((short)(0x6BEF & 0x14DB), (Object)connectionManager, ConnectionManager.class.getDeclaredMethod(LoggedVariableValueList.m_Tba((Object)"bqqWjzkqf`l{kGquqav]k``fkui"), classArray3));
            Class[] classArray4 = new Class[4 ^ 5];
            classArray4[2 & 5] = SetValueRequest.class;
            connectionManager.f_Ps.m_ma((short)(0x38ED & 0x47DE), (Object)connectionManager, ConnectionManager.class.getDeclaredMethod(UserController.m_lA((Object)"Z']\u0014H0@#K.L\u0014H.\\'`,]'[,H."), classArray4));
            Class[] classArray5 = new Class[5 >> 2];
            classArray5[3 & 4] = Collection.class;
            connectionManager.f_Ps.m_ma((short)(0x1FCD & 0x60FF), (Object)connectionManager, ConnectionManager.class.getDeclaredMethod(LoggedVariableValueList.m_Tba((Object)"vqqBdflugx`Bdxpqv]k``fkui"), classArray5));
            Class[] classArray6 = new Class[1];
            classArray6[0] = String.class;
            connectionManager.f_Ps.m_ma((short)(0xDDF & 0x72EE), (Object)connectionManager, ConnectionManager.class.getDeclaredMethod(UserController.m_lA((Object)"1]#[6j-G,L!]+F,Z\u0000P\u0012[-C'J6`&`,]'[,H."), classArray6));
            Class[] classArray7 = new Class[1];
            classArray7[0] = String.class;
            connectionManager.f_Ps.m_ma((short)(0x41FF & 0x3ECF), (Object)connectionManager, ConnectionManager.class.getDeclaredMethod(LoggedVariableValueList.m_Tba((Object)"gq{uWjzkqf`l{kgGmUfj~`wq]a]k``fkui"), classArray7));
            Class[] classArray8 = new Class[1];
            classArray8[0] = String.class;
            connectionManager.f_Ps.m_ma((short)(0x59F7 & 0x26D8), (Object)connectionManager, ConnectionManager.class.getDeclaredMethod(UserController.m_lA((Object)"N']\u0001F,G'J6@-G\u0011]#]7Z'Z\u0000P\u0012[-C'J6`&`,]'[,H."), classArray8));
            Class[] classArray9 = new Class[1];
            classArray9[0] = String[].class;
            connectionManager.f_Ps.m_ma((short)(0x37D5 & 0x48FB), (Object)connectionManager, ConnectionManager.class.getDeclaredMethod(LoggedVariableValueList.m_Tba((Object)"s``F{kz`wq}jzV`d`pg`gGmLpv]k``fkui"), classArray9));
            Class[] classArray10 = new Class[1];
            classArray10[0] = String.class;
            connectionManager.f_Ps.m_ma((short)(0x18D3 & 0x67FE), (Object)connectionManager, ConnectionManager.class.getDeclaredMethod(UserController.m_lA((Object)"K0F5Z'j-G,L!]+F,`,]'[,H."), classArray10));
            return;
        }
        catch (NoSuchMethodException a) {
            throw new IllegalStateException(LoggedVariableValueList.m_Tba((Object)"Rd}iqa4q{%f`slgqqw4F{kz`wq}jzHukubqw4WDF4hqq|jpv"), a);
        }
    }

    @PreAuthorize(value="hasAuthority('START_CONNECTION')")
    public void startConnections(String string) {
        Object a = string;
        ConnectionManager a2 = this;
        if (a2.f_Ps.m_fa()) {
            f_BU.debug(LoggedVariableValueList.m_Tba((Object)"X@UAQW.%Gquw`lzb4dxi4f{kz`wq}jzv4c{w4ufj~`wq4~i%xjwdxim+"), a);
            a2.startConnectionsByProjectIdInternal((String)a);
            return;
        }
        f_BU.debug(UserController.m_lA((Object)"g\rgoe\u0007h\u0006l\u0010\u0013b{'X7L1]+G%\t.L#M'[b]-\t1]#[6\t#E.\t!F,G'J6@-G1\t$F0\t2[-C'J6\t9Tl"), a);
        try {
            Object[] objectArray = new Object[4 ^ 5];
            objectArray[5 >> 3] = a;
            a2.f_Ps.m_ga(Short.valueOf((short)(0x47FF & 0x38CE)), objectArray);
            return;
        }
        catch (Exception exception) {
            throw new ClusterRpcException("Failed to RPC start connections for project " + (String)a, (Throwable)exception);
        }
    }

    protected void startConnectionInternal(Connection<?> connection) {
        Connection<?> a = connection;
        Connection<?> a2 = this;
        a2.f_Us.m_pCa(() -> {
            ConnectionManager a = a;
            ConnectionManager a2 = this;
            a2.f_cT.lock();
            try {
                a2.stopConnectionInternal((Connection)a);
                if (!Boolean.TRUE.equals(a.getProject().getIsActive())) {
                    throw new NotActiveException("Project should be active to start connection " + a.getName());
                }
                ConnectionManager connectionManager = a2;
                connectionManager.f_JT.m_Fl();
                connectionManager.f_Qs.m_JBa((Connection)a).m_mT();
                String[] stringArray = new String[2 ^ 3];
                stringArray[3 & 4] = a.getId();
                connectionManager.f_Xs.sadd(f_uT, stringArray);
                return;
            }
            finally {
                a2.f_cT.unlock();
            }
        }, a);
    }

    protected void setVariableValuesInternal(Collection<SetValueRequest<V>> collection) {
        Collection<SetValueRequest<V>> a = collection;
        ConnectionManager a2 = this;
        a.stream().collect(Collectors.groupingBy(SetValueRequest::getConnectionId)).forEach((string, list) -> {
            Object a = string;
            ConnectionManager a2 = this;
            if ((a = a2.f_Qs.m_jda((String)a)) != null) {
                void a3;
                a.m_JT((List)a3);
            }
        });
    }

    @PostConstruct
    private /* synthetic */ void initializeClusterIntegration() {
        ConnectionManager a;
        ConnectionManager connectionManager = a;
        connectionManager.registerRemoteCallsWithClusterNode();
        connectionManager.f_Ps.m_ka((ClusterNodeListener)a);
        f_BU.info(UserController.m_lA((Object)"j-G,L!]+F,d#G#N'[b@,@6@#E+S'MbH,Mb['N+Z6L0L&\t#Zbj.\\1]'[\fF&L\u000e@1]'G'[l"));
    }

    @PreAuthorize(value="hasAuthority('VIEW_CONNECTION_ITEM')")
    public Map<String, c_Ah> getConnectionStatuses(String[] stringArray) {
        Object[] a = stringArray;
        Object[] a2 = this;
        if (a == null || a.length == 0) {
            return Collections.emptyMap();
        }
        if (a2.f_Ps.m_fa()) {
            f_BU.debug(LoggedVariableValueList.m_Tba((Object)"IQDP@F?4Bqq`lzb4f{kz`wq}jz%gquqavqv4c{w4~i%]Ag%xjwdxim+"), (Object)a.length);
            return a2.getConnectionStatusesByIdsInternal((String[])a);
        }
        f_BU.debug(UserController.m_lA((Object)"\ff\f\u0004\u000el\u0003m\u0007{x\t\u0010L3\\'Z6@,NbE'H&L0\t$F0\t!F,G'J6@-GbZ6H6\\1L1\t$F0\t9Tb`\u0006Zl"), (Object)a.length);
        try {
            Object[] objectArray = new Object[3 >> 1];
            objectArray[3 & 4] = a;
            return (Map)a2.f_Ps.m_ga(Short.valueOf((short)(0x40DD & 0x3FF3)), objectArray);
        }
        catch (Exception exception) {
            throw new ClusterRpcException("Failed to RPC get connection statuses for IDs " + Arrays.toString(a), (Throwable)exception);
        }
    }

    @PreAuthorize(value="hasAuthority('VIEW_CONNECTION_ITEM')")
    public c_Ah getConnectionStatus(String string) {
        Object a = string;
        ConnectionManager a2 = this;
        if (a2.f_Ps.m_fa()) {
            f_BU.debug(LoggedVariableValueList.m_Tba((Object)"IQDP@F?4Bqq`lzb4f{kz`wq}jz%gquqav4c{w4~i%xjwdxim+"), a);
            return a2.getConnectionStatusInternal((String)a);
        }
        f_BU.debug(UserController.m_lA((Object)"\ff\f\u0004\u000el\u0003m\u0007{x\t\u0010L3\\'Z6@,NbE'H&L0\t$F0\t!F,G'J6@-GbZ6H6\\1\t$F0\t9Tl"), a);
        try {
            Object[] objectArray = new Object[4 ^ 5];
            objectArray[3 >> 2] = a;
            return (c_Ah)a2.f_Ps.m_ga(Short.valueOf((short)(0x7DF & 0x78EB)), objectArray);
        }
        catch (Exception exception) {
            throw new ClusterRpcException("Failed to RPC get connection status for " + (String)a, (Throwable)exception);
        }
    }

    protected c_Ah getConnectionStatusInternal(String string) {
        Object a = string;
        ConnectionManager a2 = this;
        if ((a = a2.f_Qs.m_jda((String)a)) != null && a.m_Ms()) {
            return c_Ah.f_CU;
        }
        return c_Ah.f_UR;
    }

    @PreAuthorize(value="hasAuthority('VIEW_CONNECTION_ITEM')")
    public Map<String, c_Ah> getConnectionStatuses(String string) {
        Object a = string;
        ConnectionManager a2 = this;
        if (a2.f_Ps.m_fa()) {
            f_BU.debug(LoggedVariableValueList.m_Tba((Object)"IQDP@F?4Bqq`lzb4dxi4f{kz`wq}jz%gquqavqv4c{w4ufj~`wq4~i%xjwdxim+"), a);
            return a2.getConnectionStatusesByProjectIdInternal((String)a);
        }
        f_BU.debug(UserController.m_lA((Object)"\ff\f\u0004\u000el\u0003m\u0007{x\t\u0010L3\\'Z6@,NbE'H&L0\t$F0\t#E.\t!F,G'J6@-GbZ6H6\\1L1\t$F0\t2[-C'J6\t9Tl"), a);
        try {
            Object[] objectArray = new Object[5 >> 2];
            objectArray[3 & 4] = a;
            return (Map)a2.f_Ps.m_ga(Short.valueOf((short)(0x51DC & 0x2EF3)), objectArray);
        }
        catch (Exception exception) {
            throw new ClusterRpcException("Failed to RPC get connection statuses for project " + (String)a, (Throwable)exception);
        }
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void lambda$restoreSingleConnectionOnLeader$1(String string, Connection connection) {
        void a;
        ConnectionManager a2 = connection;
        ConnectionManager a3 = this;
        try {
            Object[] objectArray = new Object[--3];
            objectArray[3 & 4] = a;
            objectArray[--1] = a2.getName();
            objectArray[--2] = a2.getId();
            f_BU.info(LoggedVariableValueList.m_Tba((Object)"Wjzkqf`l{kYdzds`f%<Iqdp`f%ox=?4Wqv`jflzb4f{kz`wq}jz?4~i%<LP?4~i,"), objectArray);
            ConnectionManager connectionManager = a3;
            Connection connection2 = connectionManager.loadConnectionWithDetails((Connection)a2);
            connectionManager.startConnectionInternal(connection2);
            return;
        }
        catch (Exception exception) {
            Object[] objectArray = new Object[--3];
            objectArray[3 >> 2] = a2.getName();
            objectArray[--1] = a2.getId();
            objectArray[5 >> 1] = ExceptionUtils.getRootCauseMessage((Throwable)exception);
            a3.f_It.m_BJ(a2.getProject()).m_s("Connection Restore (Leader " + (String)a + ")", UserController.m_lA((Object)"\f1\tj`\u0006\u0013b\f1\u0000bO#@.L&\t6Fb['Z6F0Ll\t\u0001H7Z'\u0013b\f1").formatted(objectArray));
            try {
                f_BU.warn(LoggedVariableValueList.m_Tba((Object)"Wjzkqf`l{kYdzds`f%<Iqdp`f%ox=?4D`qqhdq}ks%`j4v`jd%wjzkqf`l{k4~i%uc``f%f`gq{wuq}jz%rd}iawq+"), (Object)a, (Object)a2.getId());
                a3.stopConnectionInternal((Connection)a2);
                return;
            }
            catch (Exception exception2) {
                Object[] objectArray2 = new Object[--4];
                objectArray2[3 >> 2] = a;
                objectArray2[--1] = a2.getId();
                objectArray2[5 >> 1] = exception2.getMessage();
                objectArray2[--3] = exception2;
                f_BU.error(UserController.m_lA((Object)"\u0001F,G'J6@-G\u000fH,H%L0\tje'H&L0\t9Tk\u0013bo#@.L&\t6FbZ6F2\t!F,G'J6@-GbR?\t#O6L0\t0L1]-[#]+F,\t$H+E7['\u0013bR?"), objectArray2);
                return;
            }
        }
    }

    public void notLeader() {
        ConnectionManager connectionManager;
        ConnectionManager connectionManager2 = connectionManager = this;
        Object a = connectionManager2.f_Ps.m_ja().getNodeId();
        f_BU.info(UserController.m_lA((Object)"\u0001F,G'J6@-G\u000fH,H%L0\u0013b}*@1\t,F&Lb\u00019Tk\t+Zbg\r\t\u000ef\fn\u0007{b}\nlbe\u0007h\u0006l\u0010\u0007bz6F2Y+G%\t#E.\t.F!H.\t!F,G'J6F0Zl\u0007l"), a);
        connectionManager2.f_cT.lock();
        try {
            connectionManager.f_Qs.m_BCa();
            f_BU.info(LoggedVariableValueList.m_Tba((Object)"Wjzkqf`l{kYdzds`f%<K{q4Iqdp`f%ox=?4Dxi4i{fui4f{kz`wq{wg%|db`4gq`z%f`epqv``p%`j4v`jd%ukp%wiqdf`p%rw{h4i{fui4qfdwn}ks+"), a);
            return;
        }
        catch (Exception exception) {
            Object[] objectArray = new Object[--3];
            objectArray[3 >> 2] = a;
            objectArray[3 >> 1] = exception.getMessage();
            objectArray[1 ^ 3] = exception;
            f_BU.error(UserController.m_lA((Object)"j-G,L!]+F,d#G#N'[b\u0001\fF6\t\u000eL#M'[bR?\u0000x\t\u0007[0F0\t&\\0@,NbY0F!L1ZbF$\t1]-Y2@,NbE-J#EbJ-G,L!]-[1\u0013bR?"), objectArray);
            return;
        }
        finally {
            connectionManager.f_cT.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void leader() {
        ConnectionManager connectionManager;
        ConnectionManager connectionManager2 = connectionManager = this;
        Object a = connectionManager2.f_Ps.m_ja().getNodeId();
        f_BU.info(UserController.m_lA((Object)"j-G,L!]+F,d#G#N'[x\t\u0016A+ZbG-M'\tjR?\u0000bA#ZbK'J-D'\t6A'\t\u000el\u0003m\u0007{l\t\u0010L1]-[+G%\t#J6@4LbJ-G,L!]+F,Zl\u0007l"), a);
        connectionManager2.f_cT.lock();
        try {
            HashSet hashSet = new HashSet(connectionManager.f_Xs.smembers(f_uT));
            if (hashSet.isEmpty()) {
                f_BU.info(LoggedVariableValueList.m_Tba((Object)"F{kz`wq}jzHukubqw4-X`uaqw4~i,.%Zj4dwq}sq%wjzkqf`l{kg%rjakp%}k4Wqa}v4q{%f`gq{wq+"), a);
                return;
            }
            Object[] objectArray = new Object[--3];
            objectArray[3 ^ 3] = a;
            objectArray[4 ^ 5] = hashSet.size();
            objectArray[1 ^ 3] = hashSet;
            f_BU.info(UserController.m_lA((Object)"\u0001F,G'J6@-G\u000fH,H%L0\tje'H&L0\t9Tk\u0013bo-\\,MbR?\t#J6@4LbJ-G,L!]+F,\t\u000bm1\t+Gb{'M+Zb]-\t0L1]-['\u0013bR?"), objectArray);
            Object object = new ArrayList();
            String[] stringArray = new String[5 >> 2];
            stringArray[3 & 4] = LoggedVariableValueList.m_Tba((Object)"BLQRKF[KZ@WQ]JZZ]QQH");
            connectionManager.f_Us.m_fBa(() -> {
                void a;
                Object a2 = hashSet;
                ConnectionManager a3 = this;
                a.addAll(a3.f_DS.m_aBa((Set)a2));
            }, stringArray);
            f_BU.info(UserController.m_lA((Object)"j-G,L!]+F,d#G#N'[b\u0001\u000eL#M'[bR?\u0000x\t\u0003]6L/Y6@,Nb]-\t0L1]-['\t9TbJ-G,L!]+F,Zl"), a, (Object)object.size());
            Object object2 = object = object.iterator();
            while (object2.hasNext()) {
                Connection connection = (Connection)object.next();
                object2 = object;
                connectionManager.restoreSingleConnectionOnLeader(connection);
            }
            f_BU.info(LoggedVariableValueList.m_Tba((Object)"F{kz`wq}jzHukubqw4-X`uaqw4~i,.%Rlzlgmqa4f{kz`wq}jz%f`gq{wuq}jz%dw{fqvg+"), a);
            return;
        }
        catch (Exception exception) {
            Object[] objectArray = new Object[--3];
            objectArray[3 & 4] = a;
            objectArray[--1] = exception.getMessage();
            objectArray[5 >> 1] = exception;
            f_BU.error(UserController.m_lA((Object)"j-G,L!]+F,d#G#N'[b\u0001\u000eL#M'[bR?\u0000x\t\u0007[0F0\t&\\0@,NbJ-G,L!]+F,\t0L1]-[#]+F,\t2[-J'Z1\u0013bR?"), objectArray);
            return;
        }
        finally {
            connectionManager.f_cT.unlock();
        }
    }

    protected void stopConnectionInternal(String string) {
        ConnectionManager a;
        Object a2 = string;
        ConnectionManager connectionManager = a = this;
        connectionManager.stopConnectionInternal(connectionManager.f_DS.m_yaa((String)a2));
    }

    protected void stopConnectionsByProjectIdInternal(String string) {
        Object a = string;
        ConnectionManager a2 = this;
        if ((a = a2.f_DS.m_aba((String)a)) == null || a.isEmpty()) {
            return;
        }
        a.forEach(arg_0 -> a2.stopConnectionInternal(arg_0));
    }

    /*
     * WARNING - void declaration
     */
    @PreAuthorize(value="hasAuthority('START_CONNECTION')")
    public void startConnection(String string, String string2) {
        void a;
        ConnectionManager a2;
        Object a3 = string2;
        ConnectionManager connectionManager = a2 = this;
        connectionManager.startConnection(connectionManager.f_DS.m_pba((String)a, (String)a3).getId());
    }

    /*
     * WARNING - void declaration
     */
    @PreAuthorize(value="hasAuthority('STOP_CONNECTION')")
    public void stopConnection(String string, String string2) {
        void a;
        ConnectionManager a2;
        Object a3 = string2;
        ConnectionManager connectionManager = a2 = this;
        connectionManager.stopConnection(connectionManager.f_DS.m_pba((String)a, (String)a3).getId());
    }

    /*
     * WARNING - void declaration
     */
    protected void startConnectionInternal(String string) {
        void a;
        ConnectionManager connectionManager = this;
        ConnectionManager a2 = connectionManager.f_DS.m_fda((String)a);
        if (a2 == null) {
            throw new NotFoundException("Connection not found with id: " + (String)a);
        }
        ConnectionManager connectionManager2 = connectionManager;
        connectionManager2.startConnectionInternal(connectionManager2.loadConnectionWithDetails((Connection)a2));
    }

    protected void stopConnectionInternal(Connection<?> connection) {
        Connection<?> a = connection;
        Connection<?> a2 = this;
        a2.f_Us.m_pCa(() -> {
            ConnectionManager a = a;
            ConnectionManager a2 = this;
            a2.f_cT.lock();
            try {
                c_Gf c_Gf2 = a2.f_Qs.m_jda(a.getId());
                if (c_Gf2 != null) {
                    c_Gf2.m_RS();
                    a2.f_Qs.m_oBa(a.getId(), c_Gf2);
                }
                String[] stringArray = new String[3 >> 1];
                stringArray[2 & 5] = a.getId();
                a2.f_Xs.srem(f_uT, stringArray);
                return;
            }
            finally {
                a2.f_cT.unlock();
            }
        }, a);
    }

    /*
     * WARNING - void declaration
     */
    protected Object browseConnectionInternal(String string) {
        void a;
        ConnectionManager connectionManager;
        ConnectionManager connectionManager2 = connectionManager = this;
        ConnectionManager a2 = connectionManager2.f_DS.m_yaa((String)a);
        return connectionManager2.f_Us.m_Kea(() -> connectionManager.lambda$browseConnectionInternal$2((String)a), (OwnedSpaceBaseModel)a2);
    }

    protected Map<String, c_Ah> getConnectionStatusesByIdsInternal(String[] stringArray) {
        String[] a2 = stringArray;
        String[] a3 = this;
        return Arrays.stream(a2).collect(Collectors.toMap(a -> a, arg_0 -> ((ConnectionManager)a3).getConnectionStatusInternal(arg_0)));
    }

    /*
     * WARNING - void declaration
     */
    @TransactionalEventListener(value={c_jG.class})
    public void handleRestartEvent(c_jG c_jG2) {
        void a;
        ConnectionManager connectionManager = this;
        if (connectionManager.f_Ps.m_fa()) {
            ConnectionManager a2 = a.m_aca();
            f_BU.info(UserController.m_lA((Object)"\u000el\u0003m\u0007{x\t\nH,M.@,Nb{'Z6H0]\u0007_'G6\t$F0\t!F,G'J6@-Gx\t9Tb\u0001\u000bmx\t9Tk"), (Object)a2.getName(), (Object)a2.getId());
            connectionManager.f_cT.lock();
            try {
                if (connectionManager.getConnectionStatusInternal(a2.getId()) == c_Ah.f_CU) {
                    connectionManager.startConnectionInternal(a2.getId());
                }
                return;
            }
            finally {
                connectionManager.f_cT.unlock();
            }
        }
        f_BU.debug(LoggedVariableValueList.m_Tba((Object)"ZJZ(X@UAQW.%]bzjflzb4Wqv`dfqQsqk`%rjf%wjzkqf`l{k.%ox"), (Object)a.m_aca().getId());
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void restoreSingleConnectionOnLeader(Connection<?> connection) {
        void a;
        ConnectionManager connectionManager;
        ConnectionManager connectionManager2 = connectionManager = this;
        Object a2 = connectionManager2.f_Ps.m_ja().getNodeId();
        String[] stringArray = new String[--3];
        stringArray[5 >> 3] = LoggedVariableValueList.m_Tba((Object)"GQUW@ZWJZKQF@L[K");
        stringArray[2 ^ 3] = UserController.m_lA((Object)"\u0011}\ry\u001dj\rg\fl\u0001}\u000bf\f");
        stringArray[5 >> 1] = LoggedVariableValueList.m_Tba((Object)"BLQRKF[KZ@WQ]JZZ]QQH");
        connectionManager2.f_Us.m_kDa(() -> connectionManager.lambda$restoreSingleConnectionOnLeader$1((String)a2, (Connection)a), a.getSpace(), stringArray);
    }

    public void deactivateForProject(String string) {
        Object a = string;
        ConnectionManager a2 = this;
        if (a2.f_Ps.m_fa()) {
            f_BU.info(UserController.m_lA((Object)"e\u0007h\u0006l\u0010\u0013ba#G&E+G%\t\u0012[-C'J6m'H!]+_#]'l4L,]bO-[bY0F(L!]b`\u0006\u0013bR?"), a);
            a2.stopConnectionsByProjectIdInternal((String)a);
            return;
        }
        f_BU.debug(LoggedVariableValueList.m_Tba((Object)"ZJZ(X@UAQW.%]bzjflzb4Ufj~`wqP`uf`lbd``Qsqk`%rjf%dw{oqf`%]A.%ox"), a);
    }

    protected void startConnectionsByProjectIdInternal(String string) {
        Object a = string;
        ConnectionManager a2 = this;
        if ((a = a2.f_DS.m_aba((String)a)) == null || a.isEmpty()) {
            return;
        }
        Object object = a = a.iterator();
        while (object.hasNext()) {
            Connection connection = (Connection)a.next();
            ConnectionManager connectionManager = a2;
            connectionManager.startConnectionInternal(connectionManager.loadConnectionWithDetails(connection));
            object = a;
        }
    }

    protected Map<String, c_Ah> getConnectionStatusesByProjectIdInternal(String string) {
        Object a = string;
        ConnectionManager a2 = this;
        if ((a = a2.f_DS.m_Fba((String)a)) == null || a.isEmpty()) {
            return Collections.emptyMap();
        }
        return a.stream().collect(Collectors.toMap(ConnectionSummary::getId, connectionSummary -> {
            ConnectionManager a = connectionSummary;
            ConnectionManager a2 = this;
            return a2.getConnectionStatusInternal(a.getId());
        }));
    }

    /*
     * WARNING - void declaration
     */
    public ConnectionManager(c_Fi c_Fi2, c_Cb c_Cb2, c_lA c_lA2, c_Wg<C, V> c_Wg2, JedisPooled jedisPooled, c_B c_B2, c_ZK c_ZK2) {
        ConnectionManager a;
        void a2;
        void a3;
        void a4;
        void a5;
        void a6;
        void a7;
        ConnectionManager a8;
        ConnectionManager connectionManager = connectionManager2;
        ConnectionManager connectionManager2 = c_ZK2;
        ConnectionManager connectionManager3 = a8 = connectionManager;
        ConnectionManager connectionManager4 = a8;
        ConnectionManager connectionManager5 = a8;
        ConnectionManager connectionManager6 = a8;
        a8.f_cT = new ReentrantLock();
        a8.f_DS = a7;
        connectionManager5.f_JT = a6;
        connectionManager5.f_It = a5;
        connectionManager4.f_Qs = a4;
        connectionManager4.f_Xs = a3;
        connectionManager3.f_Ps = a2;
        connectionManager3.f_Us = a;
    }

    @PreAuthorize(value="hasAuthority('STOP_CONNECTION')")
    public void stopConnections(String string) {
        Object a = string;
        ConnectionManager a2 = this;
        if (a2.f_Ps.m_fa()) {
            f_BU.debug(LoggedVariableValueList.m_Tba((Object)"X@UAQW.%Gq{udlzb4dxi4f{kz`wq}jzv4c{w4ufj~`wq4~i%xjwdxim+"), a);
            a2.stopConnectionsByProjectIdInternal((String)a);
            return;
        }
        f_BU.debug(UserController.m_lA((Object)"\ff\f\u0004\u000el\u0003m\u0007{x\t\u0010L3\\'Z6@,NbE'H&L0\t6FbZ6F2\t#E.\t!F,G'J6@-G1\t$F0\t2[-C'J6\t9Tl"), a);
        try {
            Object[] objectArray = new Object[2 ^ 3];
            objectArray[3 ^ 3] = a;
            a2.f_Ps.m_ga(Short.valueOf((short)(0x2FDF & 0x50EF)), objectArray);
            return;
        }
        catch (Exception exception) {
            throw new ClusterRpcException("Failed to RPC stop connections for project " + (String)a, (Throwable)exception);
        }
    }

    private /* synthetic */ Connection<?> loadConnectionWithDetails(Connection<?> connection) {
        Connection<?> a = connection;
        Connection<?> a2 = this;
        if (a == null) {
            return null;
        }
        return a2.f_DS.m_XAa(a.getId());
    }

    @PreAuthorize(value="hasAuthority('SET_VARIABLE_VALUE')")
    public void setVariableValues(Collection<SetValueRequest<V>> collection) {
        Collection<SetValueRequest<V>> a22 = collection;
        ConnectionManager a3 = this;
        if (a22 == null || a22.isEmpty()) {
            return;
        }
        a22.forEach(a -> Objects.requireNonNull(a, LoggedVariableValueList.m_Tba((Object)"G``Suia`F`epqv`%wdzk{q4gq%zpxi")));
        a22.forEach(a -> Objects.requireNonNull(a.getConnectionId(), UserController.m_lA((Object)"j-G,L!]+F,`&\t+Gbz']\u0014H.\\'{'X7L1]bJ#G,F6\t LbG7E.")));
        if (a3.f_Ps.m_fa()) {
            f_BU.debug(LoggedVariableValueList.m_Tba((Object)"IQDP@F?4Vqq`lzb4~i%bdflugx`4suia`g%xjwdxim+"), (Object)a22.size());
            a3.setVariableValuesInternal((Collection)a22);
            return;
        }
        f_BU.debug(UserController.m_lA((Object)"g\rgoe\u0007h\u0006l\u0010\u0013b{'X7L1]+G%\t.L#M'[b]-\t1L6\t9Tb_#[+H E'\t4H.\\'Zl"), (Object)a22.size());
        try {
            Object[] objectArray = new Object[2 ^ 3];
            objectArray[3 >> 2] = new ArrayList(a22);
            a3.f_Ps.m_ga(Short.valueOf((short)(0x4ECD & 0x31FF)), objectArray);
            return;
        }
        catch (Exception a22) {
            throw new ClusterRpcException(LoggedVariableValueList.m_Tba((Object)"Culx`p%`j4WDF4vqq4suw}dviq%bdxpqv"), (Throwable)a22);
        }
    }

    @PreAuthorize(value="hasAuthority('SET_VARIABLE_VALUE')")
    public void setVariableValue(SetValueRequest<V> setValueRequest) {
        SetValueRequest<V> a = setValueRequest;
        SetValueRequest<V> a2 = this;
        Objects.requireNonNull(a, LoggedVariableValueList.m_Tba((Object)"G``Suia`F`epqv`%wdzk{q4gq%zpxi"));
        Objects.requireNonNull(a.getConnectionId(), UserController.m_lA((Object)"j-G,L!]+F,`&\t+Gbz']\u0014H.\\'{'X7L1]bJ#G,F6\t LbG7E."));
        if (a2.f_Ps.m_fa()) {
            f_BU.debug(LoggedVariableValueList.m_Tba((Object)"X@UAQW.%G``q}ks%bdflugx`4suia`4c{w4f{kz`wq}jz%ox4i{fuix|.%ox"), (Object)a.getConnectionId(), a);
            a2.setVariableValueInternal(a);
            return;
        }
        f_BU.debug(UserController.m_lA((Object)"\ff\f\u0004\u000el\u0003m\u0007{x\t\u0010L3\\'Z6@,NbE'H&L0\t6FbZ']b_#[+H E'\t4H.\\'\t$F0\t!F,G'J6@-GbR?\u0013bR?"), (Object)a.getConnectionId(), a);
        try {
            Object[] objectArray = new Object[4 ^ 5];
            objectArray[5 >> 3] = a;
            a2.f_Ps.m_ga(Short.valueOf((short)(0x8ED & 0x77DE)), objectArray);
            return;
        }
        catch (Exception exception) {
            throw new ClusterRpcException("Failed to RPC set variable value for connection " + a.getConnectionId(), (Throwable)exception);
        }
    }

    @PreAuthorize(value="hasAuthority('VIEW_CONNECTION_ITEM')")
    public Object browseConnection(String string) {
        Object a = string;
        ConnectionManager a2 = this;
        if (a2.f_Ps.m_fa()) {
            f_BU.debug(LoggedVariableValueList.m_Tba((Object)"X@UAQW.%D`fc{wylzb4gfjcvq%{uqwuq}jz%rjf%wjzkqf`l{k4~i%xjwdxim+"), a);
            return a2.browseConnectionInternal((String)a);
        }
        f_BU.debug(UserController.m_lA((Object)"g\rgoe\u0007h\u0006l\u0010\u0013b{'X7L1]+G%\t.L#M'[b]-\t2L0O-[/\t [-^1LbF2L0H6@-GbO-[bJ-G,L!]+F,\t9Tl"), a);
        try {
            Object[] objectArray = new Object[--1];
            objectArray[3 >> 2] = a;
            return a2.f_Ps.m_ga(Short.valueOf((short)(0x11DA & 0x6EF7)), objectArray);
        }
        catch (Exception exception) {
            throw new ClusterRpcException("Failed to RPC browse connection " + (String)a, (Throwable)exception);
        }
    }

    @PreAuthorize(value="hasAuthority('STOP_CONNECTION')")
    public void stopConnection(String string) {
        Object a = string;
        ConnectionManager a2 = this;
        if (a2.f_Ps.m_fa()) {
            f_BU.debug(LoggedVariableValueList.m_Tba((Object)"IQDP@F?4V`jdu}ks%wjzkqf`l{k4~i%xjwdxim+"), a);
            a2.stopConnectionInternal((String)a);
            return;
        }
        f_BU.debug(UserController.m_lA((Object)"g\rgoe\u0007h\u0006l\u0010\u0013b{'X7L1]+G%\t.L#M'[b]-\t1]-YbJ-G,L!]+F,\t9Tl"), a);
        try {
            Object[] objectArray = new Object[--1];
            objectArray[2 & 5] = a;
            a2.f_Ps.m_ga(Short.valueOf((short)(0x46FE & 0x39CB)), objectArray);
            return;
        }
        catch (Exception exception) {
            throw new ClusterRpcException("Failed to RPC stop connection " + (String)a, (Throwable)exception);
        }
    }

    /*
     * WARNING - void declaration
     */
    @PreAuthorize(value="hasAuthority('VIEW_CONNECTION_ITEM')")
    public c_Ah getConnectionStatus(String string, String string2) {
        void a;
        Object a2 = string;
        ConnectionManager a3 = this;
        if ((a2 = a3.f_DS.m_oca((String)a2, (String)a)) == null) {
            return c_Ah.f_UR;
        }
        return a3.getConnectionStatus(a2.getId());
    }

    /*
     * WARNING - void declaration
     */
    @TransactionalEventListener(value={c_Vg.class})
    public void handleDeleteEvent(c_Vg c_Vg2) {
        void a;
        ConnectionManager connectionManager = this;
        if (connectionManager.f_Ps.m_fa()) {
            ConnectionManager a2 = a.m_qca();
            f_BU.info(UserController.m_lA((Object)"e\u0007h\u0006l\u0010\u0013ba#G&E+G%\t\u0006L.L6L\u0007_'G6\t$F0\t!F,G'J6@-Gx\t9Tb\u0001\u000bmx\t9Tk"), (Object)a2.getName(), (Object)a2.getId());
            connectionManager.stopConnectionInternal((Connection)a2);
            return;
        }
        f_BU.debug(LoggedVariableValueList.m_Tba((Object)"K[K9IQDP@F?4Lsk{w}ks%P`x```Qsqk`%rjf%wjzkqf`l{k.%ox"), (Object)a.m_qca().getId());
    }
}

