/*
 * Decompiled with CFR 0.152.
 */
package com.inscada.mono.alarm.services;

import com.inscada.mono.alarm.e.c_Jl;
import com.inscada.mono.alarm.model.Alarm;
import com.inscada.mono.alarm.model.AlarmGroup;
import com.inscada.mono.alarm.model.AlarmGroupSummary;
import com.inscada.mono.alarm.services.c_FK;
import com.inscada.mono.alarm.services.c_KL;
import com.inscada.mono.alarm.services.c_mK;
import com.inscada.mono.alarm.services.c_pl;
import com.inscada.mono.alarm.x.c_WK;
import com.inscada.mono.alarm.x.c_vJ;
import com.inscada.mono.alarm.x.c_vj;
import com.inscada.mono.alarm.x.c_yL;
import com.inscada.mono.alarm.x.c_zk;
import com.inscada.mono.auth.c_ZK;
import com.inscada.mono.cluster.exceptions.ClusterRpcException;
import com.inscada.mono.cluster.services.ClusterNodeListener;
import com.inscada.mono.cluster.services.c_B;
import com.inscada.mono.datasource.sql.model.metadata.TableMetadata;
import com.inscada.mono.log.services.c_lA;
import com.inscada.mono.project.x.c_I;
import com.inscada.mono.search.model.SearchFilter;
import com.inscada.mono.shared.exceptions.NotActiveException;
import com.inscada.mono.shared.model.BaseModel;
import com.inscada.mono.shared.model.OwnedSpaceBaseModel;
import jakarta.annotation.PostConstruct;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Component;
import org.springframework.transaction.event.TransactionalEventListener;
import redis.clients.jedis.JedisPooled;

@Component
public class AlarmManager
implements ClusterNodeListener,
c_I {
    private final c_ZK f_rZ;
    private final Lock f_VZ;
    public static final short f_gy = 106;
    private final c_lA f_IX;
    public static final short f_sz = 107;
    private final c_B f_MV;
    public static final short f_HW = 108;
    private static final Logger f_MU = LoggerFactory.getLogger(AlarmManager.class);
    private final c_pl f_tv;
    public static final short f_aV = 105;
    private final c_FK f_xx;
    public static final short f_NV = 101;
    public static final short f_dV = 103;
    private final JedisPooled f_jW;
    public static final short f_rv = 102;
    private static final String f_Ew = "activeAlarmGroups";
    public static final short f_yV = 109;
    private final c_mK f_kv;
    public static final short f_KV = 104;

    protected void deactivateAlarmGroupInternal(AlarmGroup alarmGroup) {
        AlarmManager a = alarmGroup;
        AlarmManager a2 = this;
        a2.f_rZ.m_pCa(() -> a2.lambda$deactivateAlarmGroupInternal$3((AlarmGroup)a), (OwnedSpaceBaseModel)a);
    }

    @PreAuthorize(value="hasAuthority('VIEW_ALARM')")
    public c_Jl getAlarmGroupStatus(String string) {
        Object a = string;
        AlarmManager a2 = this;
        if (a2.f_MV.m_fa()) {
            f_MU.debug(SearchFilter.m_ne((Object)"v\u0018{\u0019\u007f\u000f\u0000}}8N)S3]}[1[/W}]/U(J}I)[)O.\u001a;U/\u001a&G}V2Y<V1Cs"), a);
            return a2.getAlarmGroupStatusInternal((String)a);
        }
        f_MU.debug(TableMetadata.m_lR((Object)"\u001e\n\u001eh\u001c\u0000\u0011\u0001\u0015\u0017je\u0002 !056$,>\"p)5$4 \"e6*\"e1)17=e77?0 e#111%6p#?7p>-k"), a);
        try {
            Object[] objectArray = new Object[--1];
            objectArray[3 ^ 3] = a;
            return (c_Jl)a2.f_MV.m_ga(Short.valueOf((short)(0x7C & 0x6B)), objectArray);
        }
        catch (Exception exception) {
            throw new ClusterRpcException("Failed to RPC get alarm group status for " + (String)a, (Throwable)exception);
        }
    }

    /*
     * WARNING - void declaration
     */
    @PreAuthorize(value="hasAuthority('DEACTIVATE_ALARM')")
    public void deactivateAlarmGroup(String string, String string2) {
        void a;
        AlarmManager a2;
        Object a3 = string2;
        AlarmManager alarmManager = a2 = this;
        alarmManager.deactivateAlarmGroup(alarmManager.f_kv.m_LIa((String)a, (String)a3).getId());
    }

    protected void activateAlarmGroupInternal(AlarmGroup alarmGroup) {
        AlarmManager a = alarmGroup;
        AlarmManager a2 = this;
        a2.f_rZ.m_pCa(() -> a2.lambda$activateAlarmGroupInternal$2((AlarmGroup)a), (OwnedSpaceBaseModel)a);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void leader() {
        AlarmManager alarmManager;
        AlarmManager alarmManager2 = alarmManager = this;
        Object a = alarmManager2.f_MV.m_ja().getNodeId();
        f_MU.info(SearchFilter.m_ne((Object)"{1[/W\u0010[3[:_/\u0000}n5S.\u001a3U9_}\u0012&Gt\u001a5[.\u001a?_>U0_}N5_}v\u0018{\u0019\u007f\u000f\u0014}h8I)U/S3]}[>N4L8\u001a<V<H0Is\u0014s"), a);
        alarmManager2.f_VZ.lock();
        try {
            HashSet hashSet = new HashSet(alarmManager.f_jW.smembers(f_Ew));
            if (hashSet.isEmpty()) {
                f_MU.info(TableMetadata.m_lR((Object)"\u0004<$\"(\u001d$>$7 \"ex\t5$4 \"e+8y\u007fp\u000b?e1&$,& p$<$\"(p\"\"*%5#e6*%+4e9+p\u00175!96p1?e\" #1?75k"), a);
                return;
            }
            Object[] objectArray = new Object[--3];
            objectArray[5 >> 3] = a;
            objectArray[3 >> 1] = hashSet.size();
            objectArray[--2] = hashSet;
            f_MU.info(SearchFilter.m_ne((Object)"\u001cV<H0w<T<]8H}\u0012\u0011_<^8H}A \u0013g\u001a\u001bU(T9\u001a&G}[>N4L8\u001a<V<H0\u001a:H2O-\u001a\u0014~.\u001a4T}h8^4I}N2\u001a/_.N2H8\u0000}A "), objectArray);
            ArrayList arrayList = new ArrayList();
            String[] stringArray = new String[--1];
            stringArray[3 & 4] = TableMetadata.m_lR((Object)"\u0006\f\u0015\u0012\u000f\u0004\u001c\u0004\u0002\b\u000f\u0002\u0002\n\u0005\u0015");
            alarmManager.f_rZ.m_fBa(() -> {
                void a;
                Object a2 = hashSet;
                AlarmManager a3 = this;
                a.addAll(a3.f_kv.m_Dha((Set)a2));
            }, stringArray);
            f_MU.info(SearchFilter.m_ne((Object)"{1[/W\u0010[3[:_/\u001auv8[9_/\u001a&Gt\u0000}{)N8W-N4T:\u001a)U}H8I)U/_}A \u001a<V<H0\u001a:H2O-Is"), a, (Object)arrayList.size());
            arrayList.forEach(alarmGroup -> {
                void a;
                AlarmManager alarmManager;
                AlarmManager alarmManager2 = alarmManager = this;
                Object a2 = alarmManager2.f_MV.m_ja().getNodeId();
                String[] stringArray = new String[--2];
                stringArray[2 & 5] = TableMetadata.m_lR((Object)"\u0011\u0006\u0004\f\u0006\u0004\u0004\u0000\u000f\u0004\u001c\u0004\u0002\b");
                stringArray[2 ^ 3] = SearchFilter.m_ne((Object)"~\u0018{\u001en\u0014l\u001cn\u0018e\u001cv\u001ch\u0010");
                alarmManager2.f_rZ.m_kDa(() -> alarmManager.lambda$restoreSingleAlarmGroupOnLeader$1((String)a2, (AlarmGroup)a), a.getSpace(), stringArray);
            });
            f_MU.info(TableMetadata.m_lR((Object)"\u0004<$\"(\u001d$>$7 \"ex\t5$4 \"e+8y\u007fp\u00039+968 4e1)17=e\" #1?7119*>e 7?&56#k"), a);
            return;
        }
        catch (Exception exception) {
            Object[] objectArray = new Object[--3];
            objectArray[3 & 4] = a;
            objectArray[2 ^ 3] = exception.getMessage();
            objectArray[5 >> 1] = exception;
            f_MU.error(SearchFilter.m_ne((Object)"{1[/W\u0010[3[:_/\u001auv8[9_/\u001a&Gt\u0000}\u007f/H2H}^(H4T:\u001a<V<H0\u001a/_.N2H<N4U3\u001a-H2Y8I.\u0000}A "), objectArray);
            return;
        }
        finally {
            alarmManager.f_VZ.unlock();
        }
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void lambda$restoreSingleAlarmGroupOnLeader$1(String string, AlarmGroup alarmGroup) {
        void a;
        AlarmManager a2 = alarmGroup;
        AlarmManager a3 = this;
        try {
            Object[] objectArray = new Object[--3];
            objectArray[3 >> 2] = a;
            objectArray[2 ^ 3] = a2.getName();
            objectArray[1 ^ 3] = a2.getId();
            f_MU.info(SearchFilter.m_ne((Object)"{1[/W\u0010[3[:_/\u001auv8[9_/\u001a&Gt\u0000}h8I)U/S3]}[1[/W}]/U(Jg\u001a&G}\u0012\u0014~g\u001a&Gt"), objectArray);
            a3.activateAlarmGroupInternal((AlarmGroup)a2);
            return;
        }
        catch (Exception exception) {
            Object[] objectArray = new Object[--3];
            objectArray[3 ^ 3] = a2.getName();
            objectArray[2 ^ 3] = a2.getId();
            objectArray[--2] = ExceptionUtils.getRootCauseMessage((Throwable)exception);
            a3.f_IX.m_BJ(a2.getProject()).m_s("Alarm Group Restore (Leader " + (String)a + ")", TableMetadata.m_lR((Object)"u6pm\u0019\u0001jeu6ye6$9)5!p1?e\" #1?75kp\u000610# jeu6").formatted(objectArray));
            try {
                f_MU.warn(SearchFilter.m_ne((Object)"{1[/W\u0010[3[:_/\u001auv8[9_/\u001a&Gt\u0000}{)N8W-N4T:\u001a)U}^8[>N4L<N8\u001a<V<H0\u001a:H2O-\u001a&G}[;N8H}H8I)U/[)S2T}\\<S1O/_s"), (Object)a, (Object)a2.getId());
                a3.deactivateAlarmGroupInternal((AlarmGroup)a2);
                return;
            }
            catch (Exception exception2) {
                Object[] objectArray2 = new Object[--4];
                objectArray2[5 >> 3] = a;
                objectArray2[--1] = a2.getId();
                objectArray2[--2] = exception2.getMessage();
                objectArray2[--3] = exception2;
                f_MU.error(TableMetadata.m_lR((Object)"\u0004<$\"(\u001d$>$7 \"ex\t5$4 \"e+8y\u007fp\u00031,< 4e$*p!5$3193115e1)17=e77?0 e+8p$6157p756$*\"$$,?+p#1,<0\" je+8"), objectArray2);
                return;
            }
        }
    }

    @PreAuthorize(value="hasAuthority('ACTIVATE_ALARM')")
    public void activateAlarmGroups(String string) {
        Object a = string;
        AlarmManager a2 = this;
        if (a2.f_MV.m_fa()) {
            f_MU.debug(SearchFilter.m_ne((Object)"\u0011\u007f\u001c~\u0018hg\u001a\u001cY)S+[)S3]}[1V}[1[/W}]/U(J.\u001a;U/\u001a-H2P8Y)\u001a&G}V2Y<V1Cs"), a);
            a2.activateAlarmGroupsByProjectIdInternal((String)a);
            return;
        }
        f_MU.debug(TableMetadata.m_lR((Object)"\u001e\n\u001eh\u001c\u0000\u0011\u0001\u0015\u0017je\u0002 !056$,>\"p)5$4 \"e$*p$3193115e1)<e1)17=e77?0 6p#?7p5\"*: 31p>-k"), a);
        try {
            Object[] objectArray = new Object[3 >> 1];
            objectArray[3 & 4] = a;
            a2.f_MV.m_ga(Short.valueOf((short)(0x7E & 0x6D)), objectArray);
            return;
        }
        catch (Exception exception) {
            throw new ClusterRpcException("Failed to RPC activate alarm groups for project " + (String)a, (Throwable)exception);
        }
    }

    private /* synthetic */ void lambda$deactivateAlarmGroupInternal$3(AlarmGroup alarmGroup) {
        AlarmManager a = alarmGroup;
        AlarmManager a2 = this;
        a2.f_VZ.lock();
        try {
            c_KL c_KL2 = a2.f_tv.m_Qha(a.getId());
            if (c_KL2 != null) {
                c_KL2.m_sGa();
                a2.f_tv.m_nha(a.getId(), c_KL2);
            }
            String[] stringArray = new String[4 ^ 5];
            stringArray[2 & 5] = a.getId();
            a2.f_jW.srem(f_Ew, stringArray);
            return;
        }
        finally {
            a2.f_VZ.unlock();
        }
    }

    @TransactionalEventListener(value={c_zk.class})
    public void handleAlarmGroupDeleteEvent(c_zk c_zk2) {
        AlarmManager a = c_zk2;
        AlarmManager a2 = this;
        if (a2.f_MV.m_fa()) {
            f_MU.info(SearchFilter.m_ne((Object)"\u0011\u007f\u001c~\u0018hg\u001a\u0015[3^1S3]}{1[/W\u001aH2O-~8V8N8\u007f+_3N}\\2H}]/U(J}s\u0019\u0000}A "), (Object)a.m_Eha().getId());
            a2.deactivateAlarmGroupInternal(a.m_Eha().getId());
            return;
        }
        f_MU.debug(TableMetadata.m_lR((Object)"\u000b\u001f\u000b}\t\u0015\u0004\u0014\u0000\u0002\u007fp\f7+?79+7e\u0011)17=\u0002\"*%5\u0014 < $ \u001535+$e6*\"e77?0 e\u0019\u0001je+8"), (Object)a.m_Eha().getId());
    }

    private /* synthetic */ void registerRemoteCallsWithClusterNode() {
        AlarmManager alarmManager = this;
        try {
            Class[] classArray = new Class[2 ^ 3];
            classArray[3 ^ 3] = String.class;
            alarmManager.f_MV.m_ma((short)(0x6D & 0x77), (Object)alarmManager, AlarmManager.class.getDeclaredMethod(SearchFilter.m_ne((Object)"[>N4L<N8{1[/W\u001aH2O-s3N8H3[1"), classArray));
            Class[] classArray2 = new Class[3 >> 1];
            classArray2[3 ^ 3] = String.class;
            alarmManager.f_MV.m_ma((short)(0x66 & 0x7F), (Object)alarmManager, AlarmManager.class.getDeclaredMethod(TableMetadata.m_lR((Object)"4 1&$,&$$ \u0011)17=\u0002\"*%5\u0019+$ \"+1)"), classArray2));
            Class[] classArray3 = new Class[5 >> 2];
            classArray3[3 & 4] = String.class;
            alarmManager.f_MV.m_ma((short)(0x77 & 0x6F), (Object)alarmManager, AlarmManager.class.getDeclaredMethod(SearchFilter.m_ne((Object)"]8N\u001cV<H0i)[)O.s3N8H3[1"), classArray3));
            Class[] classArray4 = new Class[--1];
            classArray4[2 & 5] = String.class;
            alarmManager.f_MV.m_ma((short)(0x6D & 0x7A), (Object)alarmManager, AlarmManager.class.getDeclaredMethod(TableMetadata.m_lR((Object)"\"51\u0011)17=\u0002\"*%5\u0003111%6\u0019+$ \"+1)"), classArray4));
            Class[] classArray5 = new Class[2 ^ 3];
            classArray5[2 & 5] = String.class;
            alarmManager.f_MV.m_ma((short)(0x6F & 0x79), (Object)alarmManager, AlarmManager.class.getDeclaredMethod(SearchFilter.m_ne((Object)":_){1[/W\u000eN<N(I8I\u001fC\rH2P8Y)s9s3N8H3[1"), classArray5));
            Class[] classArray6 = new Class[1];
            classArray6[0] = String.class;
            alarmManager.f_MV.m_ma((short)(0x6E & 0x7B), (Object)alarmManager, AlarmManager.class.getDeclaredMethod(TableMetadata.m_lR((Object)"7 $\u0004<$\"(\u00177?0 \u0016$$$0# #\u0007)\u0015\"*: 31\u0019!\u0019+$ \"+1)"), classArray6));
            Class[] classArray7 = new Class[1];
            classArray7[0] = List.class;
            alarmManager.f_MV.m_ma((short)(0x6B & 0x7F), (Object)alarmManager, AlarmManager.class.getDeclaredMethod(SearchFilter.m_ne((Object)"]8N\u001cV<H0i)[)O._.s3N8H3[1"), classArray7));
            Class[] classArray8 = new Class[1];
            classArray8[0] = String.class;
            alarmManager.f_MV.m_ma((short)(0x7E & 0x6D), (Object)alarmManager, AlarmManager.class.getDeclaredMethod(TableMetadata.m_lR((Object)"1&$,&$$ \u0011)17=\u0002\"*%5#\u0007)\u0015\"*: 31\u0019!\u0019+$ \"+1)"), classArray8));
            Class[] classArray9 = new Class[1];
            classArray9[0] = String.class;
            alarmManager.f_MV.m_ma((short)(0x7F & 0x6D), (Object)alarmManager, AlarmManager.class.getDeclaredMethod(SearchFilter.m_ne((Object)"^8[>N4L<N8{1[/W\u001aH2O-I\u001fC\rH2P8Y)s9s3N8H3[1"), classArray9));
            return;
        }
        catch (NoSuchMethodException a) {
            throw new IllegalStateException(TableMetadata.m_lR((Object)"\u00031,< 4e$*p75\"96$ \"e\u0011)17=\b1+1\"57p\u0017\u0000\u0006p(518*46"), a);
        }
    }

    @PreAuthorize(value="hasAuthority('VIEW_ALARM')")
    public Map<String, c_Jl> getAlarmStatuses(List<String> list) {
        List<String> a = list;
        AlarmManager a2 = this;
        if (a == null || a.isEmpty()) {
            return Collections.emptyMap();
        }
        if (a2.f_MV.m_fa()) {
            f_MU.debug(SearchFilter.m_ne((Object)"\u0011\u007f\u001c~\u0018hg\u001a\u001a_)N4T:\u001a<V<H0\u001a.N<N(I8I}\\2H}A \u001a\u0014~.\u001a1U>[1V$\u0000}A "), (Object)a.size(), (Object)a);
            return a2.getAlarmStatusesInternal((List)a);
        }
        f_MU.debug(TableMetadata.m_lR((Object)"\u000b\u001f\u000b}\t\u0015\u0004\u0014\u0000\u0002\u007fp\u001754% #19+7e< 1!57p#?7p$<$\"(p6$$$0# #e6*\"e+8p\f\u00146je+8"), (Object)a.size(), (Object)a);
        try {
            Object[] objectArray = new Object[--1];
            objectArray[3 >> 2] = new ArrayList(a);
            return (Map)a2.f_MV.m_ga(Short.valueOf((short)(0x7B & 0x6F)), objectArray);
        }
        catch (Exception exception) {
            throw new ClusterRpcException("Failed to RPC get alarm statuses for IDs " + String.valueOf(a), (Throwable)exception);
        }
    }

    public void notLeader() {
        AlarmManager alarmManager;
        AlarmManager alarmManager2 = alarmManager = this;
        Object a = alarmManager2.f_MV.m_ja().getNodeId();
        f_MU.info(TableMetadata.m_lR((Object)"\u0011)17=\b1+1\"57je\u0004-96p+?!5ex>-lp,#e\u001e\np\t\u001f\u000b\u0017\u0000\u0002e\u0004\r\u0015e\u001c\u0000\u0011\u0001\u0015\u0017~e\u00031?5 ,>\"p$<)p)?&1)p$<$\"(p,>6  31?7#k~k"), a);
        alarmManager2.f_VZ.lock();
        try {
            alarmManager.f_tv.m_QIa();
            f_MU.info(SearchFilter.m_ne((Object)"\u001cV<H0w<T<]8H}\u0012\u0013U)\u001a\u0011_<^8H}A \u0013g\u001a\u001cV1\u001a1U>[1\u001a<V<H0\u001a4T.J8Y)S2T}N<I6I}R<L8\u001a?_8T}H8K(_.N8^}N2\u001a.N2Js"), a);
            return;
        }
        catch (Exception exception) {
            Object[] objectArray = new Object[--3];
            objectArray[3 & 4] = a;
            objectArray[3 >> 1] = exception.getMessage();
            objectArray[5 >> 1] = exception;
            f_MU.error(TableMetadata.m_lR((Object)"\u0004<$\"(\u001d$>$7 \"ex\u000b?1p\t5$4 \"e+8y\u007fp\u0000\"7?7p!%79+7e 7?&56#e?#p6$* 59+7e<*3$<e1)17=e9+#55&$*\"6je+8"), objectArray);
            return;
        }
        finally {
            alarmManager.f_VZ.unlock();
        }
    }

    @TransactionalEventListener(value={c_yL.class})
    public void handleAlarmChangeEvent(c_yL c_yL2) {
        AlarmManager alarmManager = this;
        if (alarmManager.f_MV.m_fa()) {
            AlarmManager a = a.m_Yga();
            f_MU.info(SearchFilter.m_ne((Object)"v\u0018{\u0019\u007f\u000f\u0000}r<T9V4T:\u001a\u001cV<H0y5[3]8\u007f+_3N}\\2H}[1[/W}s\u0019\u0000}A \u0016}}/U(J}s\u0019\u0000}A "), (Object)a.getId(), (Object)a.getGroupId());
            c_KL c_KL2 = alarmManager.f_tv.m_Qha(a.getGroupId());
            if (c_KL2 != null && c_KL2.m_iGa()) {
                if (Boolean.TRUE.equals(a.getIsActive())) {
                    c_KL2.m_zHa((Alarm)a);
                    return;
                }
                c_KL2.m_Bha((Alarm)a);
                return;
            }
        } else {
            f_MU.debug(TableMetadata.m_lR((Object)"\u001e\n\u001eh\u001c\u0000\u0011\u0001\u0015\u0017je\u0019\">*\",>\"p\u0004<$\"(\u0013-1+7 \u001535+$e6*\"e1)17=e\u0019\u0001je+8"), (Object)a.m_Yga().getId());
        }
    }

    private /* synthetic */ void lambda$activateAlarmGroupInternal$2(AlarmGroup alarmGroup) {
        AlarmManager a = alarmGroup;
        AlarmManager a2 = this;
        a2.f_VZ.lock();
        try {
            if (!Boolean.TRUE.equals(a.getProject().getIsActive())) {
                throw new NotActiveException("Project should be active to start alarm group " + a.getName());
            }
            c_KL c_KL2 = a2.f_tv.m_TIa((AlarmGroup)a);
            c_KL2.m_lGa();
            if (c_KL2.m_iGa()) {
                String[] stringArray = new String[3 >> 1];
                stringArray[3 ^ 3] = a.getId();
                a2.f_jW.sadd(f_Ew, stringArray);
            }
            return;
        }
        finally {
            a2.f_VZ.unlock();
        }
    }

    @PreAuthorize(value="hasAuthority('VIEW_ALARM')")
    public c_Jl getAlarmStatus(String string) {
        Object a = string;
        AlarmManager a2 = this;
        if (a2.f_MV.m_fa()) {
            f_MU.debug(SearchFilter.m_ne((Object)"v\u0018{\u0019\u007f\u000f\u0000}}8N)S3]}[1[/W}I)[)O.\u001a;U/\u001a&G}V2Y<V1Cs"), a);
            return a2.getAlarmStatusInternal((String)a);
        }
        f_MU.debug(TableMetadata.m_lR((Object)"\u001e\n\u001eh\u001c\u0000\u0011\u0001\u0015\u0017je\u0002 !056$,>\"p)5$4 \"e6*\"e1)17=e#111%6p#?7p>-k"), a);
        try {
            Object[] objectArray = new Object[5 >> 2];
            objectArray[3 >> 2] = a;
            return (c_Jl)a2.f_MV.m_ga(Short.valueOf((short)(0x6F & 0x77)), objectArray);
        }
        catch (Exception exception) {
            throw new ClusterRpcException("Failed to RPC get alarm status for " + (String)a, (Throwable)exception);
        }
    }

    protected Map<String, c_Jl> getAlarmGroupStatusesByProjectIdInternal(String string) {
        Object a = string;
        AlarmManager a2 = this;
        if ((a = a2.f_kv.m_kha((String)a)) == null || a.isEmpty()) {
            return Collections.emptyMap();
        }
        return a.stream().collect(Collectors.toMap(AlarmGroupSummary::getId, alarmGroupSummary -> {
            AlarmManager a = alarmGroupSummary;
            AlarmManager a2 = this;
            return a2.getAlarmGroupStatusInternal(a.getId());
        }));
    }

    protected Map<String, c_Jl> getAlarmStatusesByProjectIdInternal(String string) {
        Object a = string;
        AlarmManager a2 = this;
        if ((a = a2.f_xx.m_oIa((String)a)) == null || a.isEmpty()) {
            return Collections.emptyMap();
        }
        return a.stream().collect(Collectors.toMap(BaseModel::getId, arg_0 -> a2.getAlarmStatusInternal(arg_0)));
    }

    @PostConstruct
    private /* synthetic */ void initializeClusterIntegration() {
        AlarmManager a;
        AlarmManager alarmManager = a;
        alarmManager.registerRemoteCallsWithClusterNode();
        alarmManager.f_MV.m_ka((ClusterNodeListener)a);
        f_MU.info(TableMetadata.m_lR((Object)"\u0004<$\"(\u001d$>$7 \"e9+919$<,* 4e1+4e\" 7,#1575!p$#e\u0013)%6$ \"\u000b?!5\t96$ > \"k"));
    }

    @PreAuthorize(value="hasAuthority('DEACTIVATE_ALARM')")
    public void deactivateAlarmGroup(String string) {
        Object a = string;
        AlarmManager a2 = this;
        if (a2.f_MV.m_fa()) {
            f_MU.debug(SearchFilter.m_ne((Object)"v\u0018{\u0019\u007f\u000f\u0000}~8[>N4L<N4T:\u001a<V<H0\u001a:H2O-\u001a&G}V2Y<V1Cs"), a);
            a2.deactivateAlarmGroupInternal((String)a);
            return;
        }
        f_MU.debug(TableMetadata.m_lR((Object)"\u000b\u001f\u000b}\t\u0015\u0004\u0014\u0000\u0002\u007fp\u001754% #19+7e< 1!57p1?e4 1&$,&$$ p$<$\"(p\"\"*%5p>-k"), a);
        try {
            Object[] objectArray = new Object[2 ^ 3];
            objectArray[3 ^ 3] = a;
            a2.f_MV.m_ga(Short.valueOf((short)(0x6E & 0x77)), objectArray);
            return;
        }
        catch (Exception exception) {
            throw new ClusterRpcException("Failed to RPC deactivate alarm group " + (String)a, (Throwable)exception);
        }
    }

    protected void activateAlarmGroupsByProjectIdInternal(String string) {
        Object a = string;
        AlarmManager a2 = this;
        if ((a = a2.f_kv.m_bia((String)a)) == null || a.isEmpty()) {
            return;
        }
        Object object = a = a.iterator();
        while (object.hasNext()) {
            AlarmGroup alarmGroup = (AlarmGroup)a.next();
            object = a;
            a2.activateAlarmGroupInternal(alarmGroup.getId());
        }
    }

    /*
     * WARNING - void declaration
     */
    @PreAuthorize(value="hasAuthority('VIEW_ALARM')")
    public c_Jl getAlarmGroupStatus(String string, String string2) {
        void a;
        Object a2 = string;
        AlarmManager a3 = this;
        if ((a2 = a3.f_kv.m_iIa((String)a2, (String)a)) == null) {
            return c_Jl.f_rz;
        }
        return a3.getAlarmGroupStatus(a2.getId());
    }

    /*
     * WARNING - void declaration
     */
    @PreAuthorize(value="hasAuthority('ACTIVATE_ALARM')")
    public void activateAlarmGroup(String string, String string2) {
        void a;
        AlarmManager a2;
        Object a3 = string2;
        AlarmManager alarmManager = a2 = this;
        alarmManager.activateAlarmGroup(alarmManager.f_kv.m_LIa((String)a, (String)a3).getId());
    }

    /*
     * WARNING - void declaration
     */
    public AlarmManager(c_FK c_FK2, c_mK c_mK2, c_pl c_pl2, c_lA c_lA2, JedisPooled jedisPooled, c_B c_B2, c_ZK c_ZK2) {
        AlarmManager a;
        void a2;
        void a3;
        void a4;
        void a5;
        void a6;
        void a7;
        AlarmManager a8;
        AlarmManager alarmManager = alarmManager2;
        AlarmManager alarmManager2 = c_ZK2;
        AlarmManager alarmManager3 = a8 = alarmManager;
        AlarmManager alarmManager4 = a8;
        AlarmManager alarmManager5 = a8;
        AlarmManager alarmManager6 = a8;
        a8.f_VZ = new ReentrantLock();
        a8.f_xx = a7;
        alarmManager5.f_kv = a6;
        alarmManager5.f_tv = a5;
        alarmManager4.f_IX = a4;
        alarmManager4.f_jW = a3;
        alarmManager3.f_MV = a2;
        alarmManager3.f_rZ = a;
    }

    @PreAuthorize(value="hasAuthority('DEACTIVATE_ALARM')")
    public void deactivateAlarmGroups(String string) {
        Object a = string;
        AlarmManager a2 = this;
        if (a2.f_MV.m_fa()) {
            f_MU.debug(SearchFilter.m_ne((Object)"\u0011\u007f\u001c~\u0018hg\u001a\u0019_<Y)S+[)S3]}[1V}[1[/W}]/U(J.\u001a;U/\u001a-H2P8Y)\u001a&G}V2Y<V1Cs"), a);
            a2.deactivateAlarmGroupsByProjectIdInternal((String)a);
            return;
        }
        f_MU.debug(TableMetadata.m_lR((Object)"\u001e\n\u001eh\u001c\u0000\u0011\u0001\u0015\u0017je\u0002 !056$,>\"p)5$4 \"e$*p!5$3193115e1)<e1)17=e77?0 6p#?7p5\"*: 31p>-k"), a);
        try {
            Object[] objectArray = new Object[3 & 5];
            objectArray[3 & 4] = a;
            a2.f_MV.m_ga(Short.valueOf((short)(0x6D & 0x7F)), objectArray);
            return;
        }
        catch (Exception exception) {
            throw new ClusterRpcException("Failed to RPC deactivate alarm groups for project " + (String)a, (Throwable)exception);
        }
    }

    protected c_Jl getAlarmGroupStatusInternal(String string) {
        Object a = string;
        AlarmManager a2 = this;
        if ((a = a2.f_tv.m_Qha((String)a)) != null && a.m_iGa()) {
            return c_Jl.f_jy;
        }
        return c_Jl.f_rz;
    }

    public void deactivateForProject(String string) {
        Object a = string;
        AlarmManager a2 = this;
        if (a2.f_MV.m_fa()) {
            f_MU.info(SearchFilter.m_ne((Object)"v\u0018{\u0019\u007f\u000f\u0000}r<T9V4T:\u001a\rH2P8Y)~8[>N4L<N8\u007f+_3N}\\2H}J/U7_>N}s\u0019\u0000}A "), a);
            a2.deactivateAlarmGroupsByProjectIdInternal((String)a);
            return;
        }
        f_MU.debug(TableMetadata.m_lR((Object)"\u001e\n\u001eh\u001c\u0000\u0011\u0001\u0015\u0017je\u0019\">*\",>\"p\u0015\"*: 31\u0014 1&$,&$$ \u001535+$e6*\"e 7?/5&$e\u0019\u0001je+8"), a);
    }

    @TransactionalEventListener(value={c_WK.class})
    public void handleAlarmAddEvent(c_WK c_WK2) {
        AlarmManager alarmManager = this;
        if (alarmManager.f_MV.m_fa()) {
            c_KL c_KL2;
            AlarmManager a = a.m_Rha();
            f_MU.info(SearchFilter.m_ne((Object)"\u0011\u007f\u001c~\u0018hg\u001a\u0015[3^1S3]}{1[/W\u001c^9\u007f+_3N}\\2H}[1[/W}s\u0019\u0000}A \u0016}}/U(J}s\u0019\u0000}A "), (Object)a.getId(), (Object)a.getGroupId());
            if (Boolean.TRUE.equals(a.getIsActive()) && (c_KL2 = alarmManager.f_tv.m_Qha(a.getGroupId())) != null && c_KL2.m_iGa()) {
                c_KL2.m_zHa((Alarm)a);
                return;
            }
        } else {
            f_MU.debug(TableMetadata.m_lR((Object)"\u000b\u001f\u000b}\t\u0015\u0004\u0014\u0000\u0002\u007fp\f7+?79+7e\u0011)17=\u00044!\u001535+$e6*\"e1)17=e\u0019\u0001je+8"), (Object)a.m_Rha().getId());
        }
    }

    @PreAuthorize(value="hasAuthority('ACTIVATE_ALARM')")
    public void activateAlarmGroup(String string) {
        Object a = string;
        AlarmManager a2 = this;
        if (a2.f_MV.m_fa()) {
            f_MU.debug(SearchFilter.m_ne((Object)"v\u0018{\u0019\u007f\u000f\u0000}{>N4L<N4T:\u001a<V<H0\u001a:H2O-\u001a&G}V2Y<V1Cs"), a);
            a2.activateAlarmGroupInternal((String)a);
            return;
        }
        f_MU.debug(TableMetadata.m_lR((Object)"\u000b\u001f\u000b}\t\u0015\u0004\u0014\u0000\u0002\u007fp\u001754% #19+7e< 1!57p1?e1&$,&$$ p$<$\"(p\"\"*%5p>-k"), a);
        try {
            Object[] objectArray = new Object[3 & 5];
            objectArray[2 & 5] = a;
            a2.f_MV.m_ga(Short.valueOf((short)(0x77 & 0x6D)), objectArray);
            return;
        }
        catch (Exception exception) {
            throw new ClusterRpcException("Failed to RPC activate alarm group " + (String)a, (Throwable)exception);
        }
    }

    protected void activateAlarmGroupInternal(String string) {
        AlarmManager a;
        Object a2 = string;
        AlarmManager alarmManager = a = this;
        alarmManager.activateAlarmGroupInternal(alarmManager.f_kv.m_Kia((String)a2));
    }

    protected void deactivateAlarmGroupsByProjectIdInternal(String string) {
        Object a = string;
        AlarmManager a2 = this;
        if ((a = a2.f_kv.m_bia((String)a)) == null || a.isEmpty()) {
            return;
        }
        Object object = a = a.iterator();
        while (object.hasNext()) {
            AlarmGroup alarmGroup = (AlarmGroup)a.next();
            object = a;
            a2.deactivateAlarmGroupInternal(alarmGroup.getId());
        }
    }

    @TransactionalEventListener(value={c_vj.class})
    public void handleAlarmDeleteEvent(c_vj c_vj2) {
        AlarmManager alarmManager = this;
        if (alarmManager.f_MV.m_fa()) {
            AlarmManager a = a.m_QGa();
            f_MU.info(SearchFilter.m_ne((Object)"v\u0018{\u0019\u007f\u000f\u0000}r<T9V4T:\u001a\u001cV<H0~8V8N8\u007f+_3N}\\2H}[1[/W}s\u0019\u0000}A \u0016}}/U(J}s\u0019\u0000}A "), (Object)a.getId(), (Object)a.getGroupId());
            c_KL c_KL2 = alarmManager.f_tv.m_Qha(a.getGroupId());
            if (c_KL2 != null && c_KL2.m_iGa()) {
                c_KL2.m_Bha((Alarm)a);
                return;
            }
        } else {
            f_MU.debug(TableMetadata.m_lR((Object)"\u001e\n\u001eh\u001c\u0000\u0011\u0001\u0015\u0017je\u0019\">*\",>\"p\u0004<$\"(\u0014 < $ \u001535+$e6*\"e1)17=e\u0019\u0001je+8"), (Object)a.m_QGa().getId());
        }
    }

    @PreAuthorize(value="hasAuthority('VIEW_ALARM')")
    public Map<String, c_Jl> getAlarmGroupStatuses(String string) {
        Object a = string;
        AlarmManager a2 = this;
        if (a2.f_MV.m_fa()) {
            f_MU.debug(SearchFilter.m_ne((Object)"v\u0018{\u0019\u007f\u000f\u0000}}8N)S3]}[1V}[1[/W}]/U(J}I)[)O._.\u001a;U/\u001a-H2P8Y)\u001a&G}V2Y<V1Cs"), a);
            return a2.getAlarmGroupStatusesByProjectIdInternal((String)a);
        }
        f_MU.debug(TableMetadata.m_lR((Object)"\u001e\n\u001eh\u001c\u0000\u0011\u0001\u0015\u0017je\u0002 !056$,>\"p)5$4 \"e6*\"e1)<e1)17=e77?0 e#111%656p#?7p5\"*: 31p>-k"), a);
        try {
            Object[] objectArray = new Object[--1];
            objectArray[3 >> 2] = a;
            return (Map)a2.f_MV.m_ga(Short.valueOf((short)(0x6B & 0x7E)), objectArray);
        }
        catch (Exception exception) {
            throw new ClusterRpcException("Failed to RPC get alarm group statuses for project " + (String)a, (Throwable)exception);
        }
    }

    protected c_Jl getAlarmStatusInternal(String string) {
        AlarmManager a;
        Object a2 = string;
        AlarmManager alarmManager = a = this;
        return alarmManager.getAlarmStatusInternal(alarmManager.f_xx.m_oha((String)a2));
    }

    protected void deactivateAlarmGroupInternal(String string) {
        AlarmManager a;
        Object a2 = string;
        AlarmManager alarmManager = a = this;
        alarmManager.deactivateAlarmGroupInternal(alarmManager.f_kv.m_Kia((String)a2));
    }

    /*
     * WARNING - void declaration
     */
    @TransactionalEventListener(value={c_vJ.class})
    public void handleAlarmGroupChangeEvent(c_vJ c_vJ2) {
        void a;
        AlarmManager alarmManager = this;
        if (alarmManager.f_MV.m_fa()) {
            f_MU.info(SearchFilter.m_ne((Object)"\u0011\u007f\u001c~\u0018hg\u001a\u0015[3^1S3]}{1[/W\u001aH2O-y5[3]8\u007f+_3N}\\2H}]/U(J}s\u0019\u0000}A "), (Object)a.m_aHa().getId());
            alarmManager.f_VZ.lock();
            try {
                Object a2 = a.m_aHa().getId();
                if (alarmManager.getAlarmGroupStatusInternal((String)a2) == c_Jl.f_jy) {
                    AlarmManager alarmManager2 = alarmManager;
                    alarmManager2.deactivateAlarmGroupInternal((String)a2);
                    alarmManager2.activateAlarmGroupInternal((String)a2);
                }
                return;
            }
            finally {
                alarmManager.f_VZ.unlock();
            }
        }
        f_MU.debug(TableMetadata.m_lR((Object)"\u000b\u001f\u000b}\t\u0015\u0004\u0014\u0000\u0002\u007fp\f7+?79+7e\u0011)17=\u0002\"*%5\u0013-1+7 \u001535+$e6*\"e77?0 e\u0019\u0001je+8"), (Object)a.m_aHa().getId());
    }

    @PreAuthorize(value="hasAuthority('VIEW_ALARM')")
    public Map<String, c_Jl> getAlarmStatuses(String string) {
        Object a = string;
        AlarmManager a2 = this;
        if (a2.f_MV.m_fa()) {
            f_MU.debug(SearchFilter.m_ne((Object)"v\u0018{\u0019\u007f\u000f\u0000}}8N)S3]}[1V}[1[/W}I)[)O._.\u001a;U/\u001a-H2P8Y)\u001a&G}V2Y<V1Cs"), a);
            return a2.getAlarmStatusesByProjectIdInternal((String)a);
        }
        f_MU.debug(TableMetadata.m_lR((Object)"\u001e\n\u001eh\u001c\u0000\u0011\u0001\u0015\u0017je\u0002 !056$,>\"p)5$4 \"e6*\"e1)<e1)17=e#111%656p#?7p5\"*: 31p>-k"), a);
        try {
            Object[] objectArray = new Object[4 ^ 5];
            objectArray[3 & 4] = a;
            return (Map)a2.f_MV.m_ga(Short.valueOf((short)(0x7F & 0x69)), objectArray);
        }
        catch (Exception exception) {
            throw new ClusterRpcException("Failed to RPC get alarm statuses for project " + (String)a, (Throwable)exception);
        }
    }

    protected Map<String, c_Jl> getAlarmStatusesInternal(List<String> list) {
        List<String> a = list;
        AlarmManager a2 = this;
        if (a == null || a.isEmpty()) {
            return Collections.emptyMap();
        }
        return a.stream().collect(Collectors.toMap(Function.identity(), arg_0 -> a2.getAlarmStatusInternal(arg_0)));
    }

    /*
     * WARNING - void declaration
     */
    protected c_Jl getAlarmStatusInternal(Alarm alarm) {
        void a;
        AlarmManager alarmManager = this;
        if (a == null) {
            return c_Jl.f_rz;
        }
        AlarmManager a2 = alarmManager.f_tv.m_Qha(a.getGroup().getId());
        if (a2 != null && a2.m_iGa() && a2.m_jIa(a.getId())) {
            return c_Jl.f_jy;
        }
        return c_Jl.f_rz;
    }

    /*
     * WARNING - void declaration
     */
    @PreAuthorize(value="hasAuthority('VIEW_ALARM')")
    public c_Jl getAlarmStatus(String string, String string2) {
        void a;
        Object a2 = string;
        AlarmManager a3 = this;
        if ((a2 = a3.f_xx.m_qIa((String)a2, (String)a)) == null) {
            return c_Jl.f_rz;
        }
        return a3.getAlarmStatus(a2.getId());
    }
}

