/*
 * Decompiled with CFR 0.152.
 */
package com.inscada.mono.alarm.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.inscada.mono.alarm.e.c_yl;
import com.inscada.mono.alarm.model.Alarm;
import com.inscada.mono.communication.base.model.Variable;
import com.inscada.mono.communication.base.model.VariableView;
import com.inscada.mono.shared.validations.CheckAtLeastOneNotNull;
import com.inscada.mono.shared.validations.CheckAtLeastOneNotNull$List;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.Table;
import org.hibernate.annotations.SQLRestriction;

@Entity
@Table(name="analog_alarm")
@CheckAtLeastOneNotNull$List(value={@CheckAtLeastOneNotNull(fieldNames={"variableId", "variable"}), @CheckAtLeastOneNotNull(fieldNames={"setPointValue", "highHighValue", "highValue", "lowValue", "lowLowValue"})})
public class AnalogAlarm
extends Alarm {
    @Column(name="deviation_percentage")
    private Double deviationPercentage;
    @Column(name="dead_band")
    private Double deadband;
    @Column(name="low_value")
    private Double lowValue;
    @Column(name="high_value")
    private Double highValue;
    @Column(name="low_low_value")
    private Double lowLowValue;
    @Column(name="set_point_value")
    private Double setPointValue;
    @Column(name="high_high_value")
    private Double highHighValue;
    @JsonIgnore
    @ManyToOne(optional=false)
    @SQLRestriction(value="deleted_dttm IS NULL")
    @JoinColumn(name="variable_id", insertable=false, updatable=false)
    private VariableView variable;
    @Column(name="variable_id")
    private String variableId;

    public void setHighHighValue(Double d) {
        Object a = d;
        AnalogAlarm a2 = this;
        a2.highHighValue = a;
    }

    @JsonSetter
    public void setVariable(VariableView variableView) {
        AnalogAlarm a = variableView;
        AnalogAlarm a2 = this;
        a2.variable = a;
        if (a2.variable != null) {
            a2.variableId = a.getId();
            return;
        }
        a2.variableId = null;
    }

    public void setHighValue(Double d) {
        Object a = d;
        AnalogAlarm a2 = this;
        a2.highValue = a;
    }

    public c_yl getType() {
        return c_yl.f_Rz;
    }

    public void setSetPointValue(Double d) {
        Object a = d;
        AnalogAlarm a2 = this;
        a2.setPointValue = a;
    }

    public Double getSetPointValue() {
        AnalogAlarm a;
        return a.setPointValue;
    }

    public Double getDeadband() {
        AnalogAlarm a;
        return a.deadband;
    }

    public Double getHighHighValue() {
        AnalogAlarm a;
        return a.highHighValue;
    }

    public void setVariable(Variable<?, ?, ?> variable) {
        Variable<?, ?, ?> a = variable;
        Variable<?, ?, ?> a2 = this;
        if (a != null) {
            Variable<?, ?, ?> variable2 = a2;
            variable2.variableId = a.getId();
            variable2.variable = VariableView.from(a);
            return;
        }
        a2.variableId = null;
        a2.variable = null;
    }

    public void setVariableId(String string) {
        Object a = string;
        AnalogAlarm a2 = this;
        a2.variableId = a;
    }

    public AnalogAlarm() {
        AnalogAlarm a;
    }

    public Double getHighValue() {
        AnalogAlarm a;
        return a.highValue;
    }

    public void setDeviationPercentage(Double d) {
        Object a = d;
        AnalogAlarm a2 = this;
        a2.deviationPercentage = a;
    }

    public String getVariableId() {
        AnalogAlarm a;
        return a.variableId;
    }

    public VariableView getVariable() {
        AnalogAlarm a;
        return a.variable;
    }

    public void setLowLowValue(Double d) {
        Object a = d;
        AnalogAlarm a2 = this;
        a2.lowLowValue = a;
    }

    public Double getDeviationPercentage() {
        AnalogAlarm a;
        return a.deviationPercentage;
    }

    public Double getLowValue() {
        AnalogAlarm a;
        return a.lowValue;
    }

    public void setLowValue(Double d) {
        Object a = d;
        AnalogAlarm a2 = this;
        a2.lowValue = a;
    }

    public void setDeadband(Double d) {
        Object a = d;
        AnalogAlarm a2 = this;
        a2.deadband = a;
    }

    public Double getLowLowValue() {
        AnalogAlarm a;
        return a.lowLowValue;
    }
}

