/*
 * Decompiled with CFR 0.152.
 */
package com.inscada.mono.alarm.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.inscada.mono.alarm.e.c_hj;
import com.inscada.mono.alarm.e.c_yl;
import com.inscada.mono.alarm.model.AlarmGroup;
import com.inscada.mono.alarm.model.AnalogAlarm;
import com.inscada.mono.alarm.model.CustomAlarm;
import com.inscada.mono.alarm.model.DigitalAlarm;
import com.inscada.mono.communication.base.model.Variable;
import com.inscada.mono.communication.base.model.VariableView;
import com.inscada.mono.project.model.Project;
import com.inscada.mono.shared.model.SpaceBaseModel;
import com.inscada.mono.shared.validations.CheckAtLeastOneNotNull;
import com.inscada.mono.shared.validations.CheckAtLeastOneNotNull$List;
import jakarta.persistence.AttributeOverride;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.Inheritance;
import jakarta.persistence.InheritanceType;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.Table;
import jakarta.persistence.Transient;
import jakarta.validation.constraints.Min;
import jakarta.validation.constraints.NotBlank;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Size;
import java.util.Map;
import java.util.Objects;
import org.hibernate.annotations.SQLRestriction;

@Entity
@Table(name="alarm")
@AttributeOverride(name="id", column=@Column(name="alarm_id", length=36, nullable=false, updatable=false))
@Inheritance(strategy=InheritanceType.JOINED)
@CheckAtLeastOneNotNull$List(value={@CheckAtLeastOneNotNull(fieldNames={"projectId", "project"}), @CheckAtLeastOneNotNull(fieldNames={"groupId", "group"})})
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, property="type")
@JsonSubTypes(value={@JsonSubTypes.Type(value=DigitalAlarm.class, name="Digital"), @JsonSubTypes.Type(value=AnalogAlarm.class, name="Analog"), @JsonSubTypes.Type(value=CustomAlarm.class, name="Custom")})
@SQLRestriction(value="deleted_dttm IS NULL")
public abstract class Alarm
extends SpaceBaseModel {
    @Column(name="project_id", insertable=false, updatable=false)
    protected String projectId;
    @NotNull
    @Column(name="active_flag")
    protected Boolean isActive;
    @Column(name="off_time_variable_id")
    protected String offTimeVariableId;
    @Size(max=100)
    protected String part;
    @JsonIgnore
    @Transient
    protected Map<c_hj, Long> lastDelayTimes;
    @JsonIgnore
    @ManyToOne(optional=false)
    @JoinColumn(name="project_id", updatable=false)
    @SQLRestriction(value="deleted_dttm IS NULL")
    protected Project project;
    @Size(max=255)
    protected String dsc;
    @NotBlank
    @Size(max=100)
    protected String name;
    @JsonIgnore
    @ManyToOne
    @SQLRestriction(value="deleted_dttm IS NULL")
    @JoinColumn(name="off_time_variable_id", insertable=false, updatable=false)
    private VariableView offTimeVariable;
    @JsonIgnore
    @ManyToOne(optional=false)
    @SQLRestriction(value="deleted_dttm IS NULL")
    @JoinColumn(name="group_id")
    protected AlarmGroup group;
    @Min(value=0L)
    protected Integer delay;
    @Column(name="group_id", insertable=false, updatable=false)
    protected String groupId;
    @JsonIgnore
    @ManyToOne
    @SQLRestriction(value="deleted_dttm IS NULL")
    @JoinColumn(name="on_time_variable_id", insertable=false, updatable=false)
    private VariableView onTimeVariable;
    @Column(name="on_time_variable_id")
    protected String onTimeVariableId;

    public Project getProject() {
        Alarm a;
        return a.project;
    }

    public void setProject(Project project) {
        Alarm a;
        Alarm a2 = project;
        Alarm alarm = a = this;
        alarm.project = a2;
        alarm.projectId = a2 != null && a2.getId() != null ? a2.getId() : null;
    }

    public Map<c_hj, Long> getLastDelayTimes() {
        Alarm a;
        return a.lastDelayTimes;
    }

    public String getOnTimeVariableId() {
        Alarm a;
        return a.onTimeVariableId;
    }

    public String getProjectId() {
        Alarm a;
        return a.projectId;
    }

    public Alarm() {
        Alarm a;
    }

    public boolean equals(Object object) {
        Alarm a = this;
        Object a2 = object;
        if (a == a2) {
            return (2 ^ 3) != 0;
        }
        if (!(a2 instanceof Alarm)) {
            return false;
        }
        Object object2 = a2;
        if (!super.equals(a2)) {
            return (3 & 4) != 0;
        }
        if (a.getProjectId().equals(object2.getProjectId()) && a.getName().equals(object2.getName())) {
            return 5 >> 2;
        }
        return false;
    }

    public void setOffTimeVariableId(String string) {
        Object a = string;
        Alarm a2 = this;
        a2.offTimeVariableId = a;
    }

    public void setPart(String string) {
        Object a = string;
        Alarm a2 = this;
        a2.part = a;
    }

    public void setIsActive(Boolean bl) {
        Object a = bl;
        Alarm a2 = this;
        a2.isActive = a;
    }

    public void setDelay(Integer n) {
        Object a = n;
        Alarm a2 = this;
        a2.delay = a;
    }

    public String getPart() {
        Alarm a;
        return a.part;
    }

    public String getOffTimeVariableId() {
        Alarm a;
        return a.offTimeVariableId;
    }

    @JsonSetter
    public void setOnTimeVariable(VariableView variableView) {
        Alarm a = variableView;
        Alarm a2 = this;
        a2.onTimeVariable = a;
        if (a2.onTimeVariable != null) {
            a2.onTimeVariableId = a.getId();
            return;
        }
        a2.onTimeVariableId = null;
    }

    public AlarmGroup getGroup() {
        Alarm a;
        return a.group;
    }

    @JsonSetter
    public void setOffTimeVariable(VariableView variableView) {
        Alarm a = variableView;
        Alarm a2 = this;
        a2.offTimeVariable = a;
        if (a2.offTimeVariable != null) {
            a2.offTimeVariableId = a.getId();
            return;
        }
        a2.offTimeVariableId = null;
    }

    public String getDsc() {
        Alarm a;
        return a.dsc;
    }

    public void setOnTimeVariableId(String string) {
        Object a = string;
        Alarm a2 = this;
        a2.onTimeVariableId = a;
    }

    public String getGroupId() {
        Alarm a;
        return a.groupId;
    }

    public VariableView getOnTimeVariable() {
        Alarm a;
        return a.onTimeVariable;
    }

    public void setName(String string) {
        Object a = string;
        Alarm a2 = this;
        a2.name = a;
    }

    public Integer getDelay() {
        Alarm a;
        return a.delay;
    }

    public int hashCode() {
        Alarm a;
        Object[] objectArray = new Object[--3];
        objectArray[3 ^ 3] = super.hashCode();
        objectArray[5 >> 2] = a.getProjectId();
        objectArray[1 ^ 3] = a.getName();
        return Objects.hash(objectArray);
    }

    public void setGroup(AlarmGroup alarmGroup) {
        Alarm a;
        Alarm a2 = alarmGroup;
        Alarm alarm = a = this;
        alarm.group = a2;
        alarm.groupId = a2 != null && a2.getId() != null ? a2.getId() : null;
    }

    public VariableView getOffTimeVariable() {
        Alarm a;
        return a.offTimeVariable;
    }

    public void setOnTimeVariable(Variable<?, ?, ?> variable) {
        Variable<?, ?, ?> a = variable;
        Variable<?, ?, ?> a2 = this;
        if (a != null) {
            Variable<?, ?, ?> variable2 = a2;
            variable2.onTimeVariableId = a.getId();
            variable2.onTimeVariable = VariableView.from(a);
            return;
        }
        a2.onTimeVariableId = null;
        a2.onTimeVariable = null;
    }

    public void setOffTimeVariable(Variable<?, ?, ?> variable) {
        Variable<?, ?, ?> a = variable;
        Variable<?, ?, ?> a2 = this;
        if (a != null) {
            Variable<?, ?, ?> variable2 = a2;
            variable2.offTimeVariableId = a.getId();
            variable2.offTimeVariable = VariableView.from(a);
            return;
        }
        a2.offTimeVariableId = null;
        a2.offTimeVariable = null;
    }

    public void setProjectId(String string) {
        Object a = string;
        Alarm a2 = this;
        a2.projectId = a;
    }

    public String getName() {
        Alarm a;
        return a.name;
    }

    public void setLastDelayTimes(Map<c_hj, Long> map) {
        Object a = map;
        Alarm a2 = this;
        a2.lastDelayTimes = a;
    }

    public Boolean getIsActive() {
        Alarm a;
        return a.isActive;
    }

    public void setGroupId(String string) {
        Object a = string;
        Alarm a2 = this;
        a2.groupId = a;
    }

    public abstract c_yl getType();

    public void setDsc(String string) {
        Object a = string;
        Alarm a2 = this;
        a2.dsc = a;
    }
}

